# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetSecretVersionsResult',
    'AwaitableGetSecretVersionsResult',
    'get_secret_versions',
    'get_secret_versions_output',
]

@pulumi.output_type
class GetSecretVersionsResult:
    """
    A collection of values returned by getSecretVersions.
    """
    def __init__(__self__, enable_details=None, id=None, ids=None, include_deprecated=None, output_file=None, secret_name=None, version_stage=None, versions=None):
        if enable_details and not isinstance(enable_details, bool):
            raise TypeError("Expected argument 'enable_details' to be a bool")
        pulumi.set(__self__, "enable_details", enable_details)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if include_deprecated and not isinstance(include_deprecated, str):
            raise TypeError("Expected argument 'include_deprecated' to be a str")
        pulumi.set(__self__, "include_deprecated", include_deprecated)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if secret_name and not isinstance(secret_name, str):
            raise TypeError("Expected argument 'secret_name' to be a str")
        pulumi.set(__self__, "secret_name", secret_name)
        if version_stage and not isinstance(version_stage, str):
            raise TypeError("Expected argument 'version_stage' to be a str")
        pulumi.set(__self__, "version_stage", version_stage)
        if versions and not isinstance(versions, list):
            raise TypeError("Expected argument 'versions' to be a list")
        pulumi.set(__self__, "versions", versions)

    @_builtins.property
    @pulumi.getter(name="enableDetails")
    def enable_details(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "enable_details")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        """
        A list of Kms Secret Version ids.
        """
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter(name="includeDeprecated")
    def include_deprecated(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "include_deprecated")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")

    @_builtins.property
    @pulumi.getter(name="secretName")
    def secret_name(self) -> _builtins.str:
        """
        The name of the secret.
        """
        return pulumi.get(self, "secret_name")

    @_builtins.property
    @pulumi.getter(name="versionStage")
    def version_stage(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "version_stage")

    @_builtins.property
    @pulumi.getter
    def versions(self) -> Sequence['outputs.GetSecretVersionsVersionResult']:
        """
        A list of KMS Secret Versions. Each element contains the following attributes:
        """
        return pulumi.get(self, "versions")


class AwaitableGetSecretVersionsResult(GetSecretVersionsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSecretVersionsResult(
            enable_details=self.enable_details,
            id=self.id,
            ids=self.ids,
            include_deprecated=self.include_deprecated,
            output_file=self.output_file,
            secret_name=self.secret_name,
            version_stage=self.version_stage,
            versions=self.versions)


def get_secret_versions(enable_details: Optional[_builtins.bool] = None,
                        ids: Optional[Sequence[_builtins.str]] = None,
                        include_deprecated: Optional[_builtins.str] = None,
                        output_file: Optional[_builtins.str] = None,
                        secret_name: Optional[_builtins.str] = None,
                        version_stage: Optional[_builtins.str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSecretVersionsResult:
    """
    This data source provides a list of KMS Secret Versions in an Alibaba Cloud account according to the specified filters.

    > **NOTE:** Available in v1.88.0+.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    # Declare the data source
    kms_secret_versions_ds = alicloud.kms.get_secret_versions(secret_name="secret_name",
        enable_details=True)
    pulumi.export("firstSecretData", kms_secret_versions_ds.versions[0].secret_data)
    ```


    :param _builtins.bool enable_details: Default to false and only output `secret_name`, `version_id`, `version_stages`. Set it to true can output more details.
    :param Sequence[_builtins.str] ids: A list of KMS Secret Version ids.
    :param _builtins.str include_deprecated: Specifies whether to return deprecated secret versions. Default to `false`.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str secret_name: The name of the secret.
    :param _builtins.str version_stage: The stage of the secret version.
    """
    __args__ = dict()
    __args__['enableDetails'] = enable_details
    __args__['ids'] = ids
    __args__['includeDeprecated'] = include_deprecated
    __args__['outputFile'] = output_file
    __args__['secretName'] = secret_name
    __args__['versionStage'] = version_stage
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:kms/getSecretVersions:getSecretVersions', __args__, opts=opts, typ=GetSecretVersionsResult).value

    return AwaitableGetSecretVersionsResult(
        enable_details=pulumi.get(__ret__, 'enable_details'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        include_deprecated=pulumi.get(__ret__, 'include_deprecated'),
        output_file=pulumi.get(__ret__, 'output_file'),
        secret_name=pulumi.get(__ret__, 'secret_name'),
        version_stage=pulumi.get(__ret__, 'version_stage'),
        versions=pulumi.get(__ret__, 'versions'))
def get_secret_versions_output(enable_details: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                               ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                               include_deprecated: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                               output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                               secret_name: Optional[pulumi.Input[_builtins.str]] = None,
                               version_stage: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSecretVersionsResult]:
    """
    This data source provides a list of KMS Secret Versions in an Alibaba Cloud account according to the specified filters.

    > **NOTE:** Available in v1.88.0+.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    # Declare the data source
    kms_secret_versions_ds = alicloud.kms.get_secret_versions(secret_name="secret_name",
        enable_details=True)
    pulumi.export("firstSecretData", kms_secret_versions_ds.versions[0].secret_data)
    ```


    :param _builtins.bool enable_details: Default to false and only output `secret_name`, `version_id`, `version_stages`. Set it to true can output more details.
    :param Sequence[_builtins.str] ids: A list of KMS Secret Version ids.
    :param _builtins.str include_deprecated: Specifies whether to return deprecated secret versions. Default to `false`.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str secret_name: The name of the secret.
    :param _builtins.str version_stage: The stage of the secret version.
    """
    __args__ = dict()
    __args__['enableDetails'] = enable_details
    __args__['ids'] = ids
    __args__['includeDeprecated'] = include_deprecated
    __args__['outputFile'] = output_file
    __args__['secretName'] = secret_name
    __args__['versionStage'] = version_stage
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:kms/getSecretVersions:getSecretVersions', __args__, opts=opts, typ=GetSecretVersionsResult)
    return __ret__.apply(lambda __response__: GetSecretVersionsResult(
        enable_details=pulumi.get(__response__, 'enable_details'),
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        include_deprecated=pulumi.get(__response__, 'include_deprecated'),
        output_file=pulumi.get(__response__, 'output_file'),
        secret_name=pulumi.get(__response__, 'secret_name'),
        version_stage=pulumi.get(__response__, 'version_stage'),
        versions=pulumi.get(__response__, 'versions')))
