# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['IngestionArgs', 'Ingestion']

@pulumi.input_type
class IngestionArgs:
    def __init__(__self__, *,
                 display_name: pulumi.Input[_builtins.str],
                 ingestion_name: pulumi.Input[_builtins.str],
                 interval: pulumi.Input[_builtins.str],
                 logstore: pulumi.Input[_builtins.str],
                 project: pulumi.Input[_builtins.str],
                 run_immediately: pulumi.Input[_builtins.bool],
                 source: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 time_zone: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Ingestion resource.
        :param pulumi.Input[_builtins.str] display_name: The name displayed on the web page.
        :param pulumi.Input[_builtins.str] ingestion_name: Ingestion job name, it can only contain lowercase letters, numbers, dashes `-` and underscores `_`. It must start and end with lowercase letters or numbers, and the name must be 2 to 128 characters long.
        :param pulumi.Input[_builtins.str] interval: Task execution interval, support minute `m`, hour `h`, day `d`, for example 30 minutes `30m`.
        :param pulumi.Input[_builtins.str] logstore: The name of the target logstore.
        :param pulumi.Input[_builtins.str] project: The name of the log project. It is the only in one Alicloud account.
        :param pulumi.Input[_builtins.bool] run_immediately: Whether to run the ingestion job immediately, if false, wait for an interval before starting the ingestion.
        :param pulumi.Input[_builtins.str] source: Data source and data format details. [Refer to details](https://www.alibabacloud.com/help/en/doc-detail/147819.html).
        :param pulumi.Input[_builtins.str] description: Ingestion job description.
        :param pulumi.Input[_builtins.str] time_zone: Which time zone is the log time imported in, e.g. `+0800`.
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "ingestion_name", ingestion_name)
        pulumi.set(__self__, "interval", interval)
        pulumi.set(__self__, "logstore", logstore)
        pulumi.set(__self__, "project", project)
        pulumi.set(__self__, "run_immediately", run_immediately)
        pulumi.set(__self__, "source", source)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name displayed on the web page.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="ingestionName")
    def ingestion_name(self) -> pulumi.Input[_builtins.str]:
        """
        Ingestion job name, it can only contain lowercase letters, numbers, dashes `-` and underscores `_`. It must start and end with lowercase letters or numbers, and the name must be 2 to 128 characters long.
        """
        return pulumi.get(self, "ingestion_name")

    @ingestion_name.setter
    def ingestion_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "ingestion_name", value)

    @_builtins.property
    @pulumi.getter
    def interval(self) -> pulumi.Input[_builtins.str]:
        """
        Task execution interval, support minute `m`, hour `h`, day `d`, for example 30 minutes `30m`.
        """
        return pulumi.get(self, "interval")

    @interval.setter
    def interval(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "interval", value)

    @_builtins.property
    @pulumi.getter
    def logstore(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the target logstore.
        """
        return pulumi.get(self, "logstore")

    @logstore.setter
    def logstore(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "logstore", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the log project. It is the only in one Alicloud account.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="runImmediately")
    def run_immediately(self) -> pulumi.Input[_builtins.bool]:
        """
        Whether to run the ingestion job immediately, if false, wait for an interval before starting the ingestion.
        """
        return pulumi.get(self, "run_immediately")

    @run_immediately.setter
    def run_immediately(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "run_immediately", value)

    @_builtins.property
    @pulumi.getter
    def source(self) -> pulumi.Input[_builtins.str]:
        """
        Data source and data format details. [Refer to details](https://www.alibabacloud.com/help/en/doc-detail/147819.html).
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "source", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Ingestion job description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Which time zone is the log time imported in, e.g. `+0800`.
        """
        return pulumi.get(self, "time_zone")

    @time_zone.setter
    def time_zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_zone", value)


@pulumi.input_type
class _IngestionState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 ingestion_name: Optional[pulumi.Input[_builtins.str]] = None,
                 interval: Optional[pulumi.Input[_builtins.str]] = None,
                 logstore: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 run_immediately: Optional[pulumi.Input[_builtins.bool]] = None,
                 source: Optional[pulumi.Input[_builtins.str]] = None,
                 time_zone: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Ingestion resources.
        :param pulumi.Input[_builtins.str] description: Ingestion job description.
        :param pulumi.Input[_builtins.str] display_name: The name displayed on the web page.
        :param pulumi.Input[_builtins.str] ingestion_name: Ingestion job name, it can only contain lowercase letters, numbers, dashes `-` and underscores `_`. It must start and end with lowercase letters or numbers, and the name must be 2 to 128 characters long.
        :param pulumi.Input[_builtins.str] interval: Task execution interval, support minute `m`, hour `h`, day `d`, for example 30 minutes `30m`.
        :param pulumi.Input[_builtins.str] logstore: The name of the target logstore.
        :param pulumi.Input[_builtins.str] project: The name of the log project. It is the only in one Alicloud account.
        :param pulumi.Input[_builtins.bool] run_immediately: Whether to run the ingestion job immediately, if false, wait for an interval before starting the ingestion.
        :param pulumi.Input[_builtins.str] source: Data source and data format details. [Refer to details](https://www.alibabacloud.com/help/en/doc-detail/147819.html).
        :param pulumi.Input[_builtins.str] time_zone: Which time zone is the log time imported in, e.g. `+0800`.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if ingestion_name is not None:
            pulumi.set(__self__, "ingestion_name", ingestion_name)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if logstore is not None:
            pulumi.set(__self__, "logstore", logstore)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if run_immediately is not None:
            pulumi.set(__self__, "run_immediately", run_immediately)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Ingestion job description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name displayed on the web page.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="ingestionName")
    def ingestion_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Ingestion job name, it can only contain lowercase letters, numbers, dashes `-` and underscores `_`. It must start and end with lowercase letters or numbers, and the name must be 2 to 128 characters long.
        """
        return pulumi.get(self, "ingestion_name")

    @ingestion_name.setter
    def ingestion_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ingestion_name", value)

    @_builtins.property
    @pulumi.getter
    def interval(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Task execution interval, support minute `m`, hour `h`, day `d`, for example 30 minutes `30m`.
        """
        return pulumi.get(self, "interval")

    @interval.setter
    def interval(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "interval", value)

    @_builtins.property
    @pulumi.getter
    def logstore(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the target logstore.
        """
        return pulumi.get(self, "logstore")

    @logstore.setter
    def logstore(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "logstore", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the log project. It is the only in one Alicloud account.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="runImmediately")
    def run_immediately(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to run the ingestion job immediately, if false, wait for an interval before starting the ingestion.
        """
        return pulumi.get(self, "run_immediately")

    @run_immediately.setter
    def run_immediately(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "run_immediately", value)

    @_builtins.property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Data source and data format details. [Refer to details](https://www.alibabacloud.com/help/en/doc-detail/147819.html).
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source", value)

    @_builtins.property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Which time zone is the log time imported in, e.g. `+0800`.
        """
        return pulumi.get(self, "time_zone")

    @time_zone.setter
    def time_zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_zone", value)


@pulumi.type_token("alicloud:log/ingestion:Ingestion")
class Ingestion(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 ingestion_name: Optional[pulumi.Input[_builtins.str]] = None,
                 interval: Optional[pulumi.Input[_builtins.str]] = None,
                 logstore: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 run_immediately: Optional[pulumi.Input[_builtins.bool]] = None,
                 source: Optional[pulumi.Input[_builtins.str]] = None,
                 time_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Log service ingestion, this service provides the function of importing logs of various data sources(OSS, MaxCompute) into logstore. [Refer to details](https://www.alibabacloud.com/help/en/doc-detail/147819.html).

        > **NOTE:** Available since v1.161.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        default = random.index.Integer("default",
            max=99999,
            min=10000)
        example = alicloud.log.Project("example",
            project_name=f"terraform-example-{default['result']}",
            description="terraform-example",
            tags={
                "Created": "TF",
                "For": "example",
            })
        example_store = alicloud.log.Store("example",
            project_name=example.project_name,
            logstore_name="example-store",
            retention_period=3650,
            shard_count=3,
            auto_split=True,
            max_split_shard_count=60,
            append_meta=True)
        example_ingestion = alicloud.log.Ingestion("example",
            project=example.project_name,
            logstore=example_store.logstore_name,
            ingestion_name="terraform-example",
            display_name="terraform-example",
            description="terraform-example",
            interval="30m",
            run_immediately=True,
            time_zone="+0800",
            source=\"\"\"        {
                  "bucket": "bucket_name",
                  "compressionCodec": "none",
                  "encoding": "UTF-8",
                  "endpoint": "oss-cn-hangzhou-internal.aliyuncs.com",
                  "format": {
                    "escapeChar": "\\\\",
                    "fieldDelimiter": ",",
                    "fieldNames": [],
                    "firstRowAsHeader": true,
                    "maxLines": 1,
                    "quoteChar": "\\"",
                    "skipLeadingRows": 0,
                    "timeField": "",
                    "type": "DelimitedText"
                  },
                  "pattern": "",
                  "prefix": "test-prefix/",
                  "restoreObjectEnabled": false,
                  "roleARN": "acs:ram::1049446484210612:role/aliyunlogimportossrole",
                  "type": "AliyunOSS"
                }
        \"\"\")
        ```

        ## Import

        Log ingestion can be imported using the id or name, e.g.

        ```sh
        $ pulumi import alicloud:log/ingestion:Ingestion example tf-log-project:tf-log-logstore:ingestion_name
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: Ingestion job description.
        :param pulumi.Input[_builtins.str] display_name: The name displayed on the web page.
        :param pulumi.Input[_builtins.str] ingestion_name: Ingestion job name, it can only contain lowercase letters, numbers, dashes `-` and underscores `_`. It must start and end with lowercase letters or numbers, and the name must be 2 to 128 characters long.
        :param pulumi.Input[_builtins.str] interval: Task execution interval, support minute `m`, hour `h`, day `d`, for example 30 minutes `30m`.
        :param pulumi.Input[_builtins.str] logstore: The name of the target logstore.
        :param pulumi.Input[_builtins.str] project: The name of the log project. It is the only in one Alicloud account.
        :param pulumi.Input[_builtins.bool] run_immediately: Whether to run the ingestion job immediately, if false, wait for an interval before starting the ingestion.
        :param pulumi.Input[_builtins.str] source: Data source and data format details. [Refer to details](https://www.alibabacloud.com/help/en/doc-detail/147819.html).
        :param pulumi.Input[_builtins.str] time_zone: Which time zone is the log time imported in, e.g. `+0800`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: IngestionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Log service ingestion, this service provides the function of importing logs of various data sources(OSS, MaxCompute) into logstore. [Refer to details](https://www.alibabacloud.com/help/en/doc-detail/147819.html).

        > **NOTE:** Available since v1.161.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        default = random.index.Integer("default",
            max=99999,
            min=10000)
        example = alicloud.log.Project("example",
            project_name=f"terraform-example-{default['result']}",
            description="terraform-example",
            tags={
                "Created": "TF",
                "For": "example",
            })
        example_store = alicloud.log.Store("example",
            project_name=example.project_name,
            logstore_name="example-store",
            retention_period=3650,
            shard_count=3,
            auto_split=True,
            max_split_shard_count=60,
            append_meta=True)
        example_ingestion = alicloud.log.Ingestion("example",
            project=example.project_name,
            logstore=example_store.logstore_name,
            ingestion_name="terraform-example",
            display_name="terraform-example",
            description="terraform-example",
            interval="30m",
            run_immediately=True,
            time_zone="+0800",
            source=\"\"\"        {
                  "bucket": "bucket_name",
                  "compressionCodec": "none",
                  "encoding": "UTF-8",
                  "endpoint": "oss-cn-hangzhou-internal.aliyuncs.com",
                  "format": {
                    "escapeChar": "\\\\",
                    "fieldDelimiter": ",",
                    "fieldNames": [],
                    "firstRowAsHeader": true,
                    "maxLines": 1,
                    "quoteChar": "\\"",
                    "skipLeadingRows": 0,
                    "timeField": "",
                    "type": "DelimitedText"
                  },
                  "pattern": "",
                  "prefix": "test-prefix/",
                  "restoreObjectEnabled": false,
                  "roleARN": "acs:ram::1049446484210612:role/aliyunlogimportossrole",
                  "type": "AliyunOSS"
                }
        \"\"\")
        ```

        ## Import

        Log ingestion can be imported using the id or name, e.g.

        ```sh
        $ pulumi import alicloud:log/ingestion:Ingestion example tf-log-project:tf-log-logstore:ingestion_name
        ```

        :param str resource_name: The name of the resource.
        :param IngestionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IngestionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 ingestion_name: Optional[pulumi.Input[_builtins.str]] = None,
                 interval: Optional[pulumi.Input[_builtins.str]] = None,
                 logstore: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 run_immediately: Optional[pulumi.Input[_builtins.bool]] = None,
                 source: Optional[pulumi.Input[_builtins.str]] = None,
                 time_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IngestionArgs.__new__(IngestionArgs)

            __props__.__dict__["description"] = description
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            if ingestion_name is None and not opts.urn:
                raise TypeError("Missing required property 'ingestion_name'")
            __props__.__dict__["ingestion_name"] = ingestion_name
            if interval is None and not opts.urn:
                raise TypeError("Missing required property 'interval'")
            __props__.__dict__["interval"] = interval
            if logstore is None and not opts.urn:
                raise TypeError("Missing required property 'logstore'")
            __props__.__dict__["logstore"] = logstore
            if project is None and not opts.urn:
                raise TypeError("Missing required property 'project'")
            __props__.__dict__["project"] = project
            if run_immediately is None and not opts.urn:
                raise TypeError("Missing required property 'run_immediately'")
            __props__.__dict__["run_immediately"] = run_immediately
            if source is None and not opts.urn:
                raise TypeError("Missing required property 'source'")
            __props__.__dict__["source"] = source
            __props__.__dict__["time_zone"] = time_zone
        super(Ingestion, __self__).__init__(
            'alicloud:log/ingestion:Ingestion',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            ingestion_name: Optional[pulumi.Input[_builtins.str]] = None,
            interval: Optional[pulumi.Input[_builtins.str]] = None,
            logstore: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            run_immediately: Optional[pulumi.Input[_builtins.bool]] = None,
            source: Optional[pulumi.Input[_builtins.str]] = None,
            time_zone: Optional[pulumi.Input[_builtins.str]] = None) -> 'Ingestion':
        """
        Get an existing Ingestion resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: Ingestion job description.
        :param pulumi.Input[_builtins.str] display_name: The name displayed on the web page.
        :param pulumi.Input[_builtins.str] ingestion_name: Ingestion job name, it can only contain lowercase letters, numbers, dashes `-` and underscores `_`. It must start and end with lowercase letters or numbers, and the name must be 2 to 128 characters long.
        :param pulumi.Input[_builtins.str] interval: Task execution interval, support minute `m`, hour `h`, day `d`, for example 30 minutes `30m`.
        :param pulumi.Input[_builtins.str] logstore: The name of the target logstore.
        :param pulumi.Input[_builtins.str] project: The name of the log project. It is the only in one Alicloud account.
        :param pulumi.Input[_builtins.bool] run_immediately: Whether to run the ingestion job immediately, if false, wait for an interval before starting the ingestion.
        :param pulumi.Input[_builtins.str] source: Data source and data format details. [Refer to details](https://www.alibabacloud.com/help/en/doc-detail/147819.html).
        :param pulumi.Input[_builtins.str] time_zone: Which time zone is the log time imported in, e.g. `+0800`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _IngestionState.__new__(_IngestionState)

        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["ingestion_name"] = ingestion_name
        __props__.__dict__["interval"] = interval
        __props__.__dict__["logstore"] = logstore
        __props__.__dict__["project"] = project
        __props__.__dict__["run_immediately"] = run_immediately
        __props__.__dict__["source"] = source
        __props__.__dict__["time_zone"] = time_zone
        return Ingestion(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Ingestion job description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name displayed on the web page.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="ingestionName")
    def ingestion_name(self) -> pulumi.Output[_builtins.str]:
        """
        Ingestion job name, it can only contain lowercase letters, numbers, dashes `-` and underscores `_`. It must start and end with lowercase letters or numbers, and the name must be 2 to 128 characters long.
        """
        return pulumi.get(self, "ingestion_name")

    @_builtins.property
    @pulumi.getter
    def interval(self) -> pulumi.Output[_builtins.str]:
        """
        Task execution interval, support minute `m`, hour `h`, day `d`, for example 30 minutes `30m`.
        """
        return pulumi.get(self, "interval")

    @_builtins.property
    @pulumi.getter
    def logstore(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the target logstore.
        """
        return pulumi.get(self, "logstore")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the log project. It is the only in one Alicloud account.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="runImmediately")
    def run_immediately(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether to run the ingestion job immediately, if false, wait for an interval before starting the ingestion.
        """
        return pulumi.get(self, "run_immediately")

    @_builtins.property
    @pulumi.getter
    def source(self) -> pulumi.Output[_builtins.str]:
        """
        Data source and data format details. [Refer to details](https://www.alibabacloud.com/help/en/doc-detail/147819.html).
        """
        return pulumi.get(self, "source")

    @_builtins.property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Which time zone is the log time imported in, e.g. `+0800`.
        """
        return pulumi.get(self, "time_zone")

