# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ListenerAdditionalCertificateAttachmentArgs', 'ListenerAdditionalCertificateAttachment']

@pulumi.input_type
class ListenerAdditionalCertificateAttachmentArgs:
    def __init__(__self__, *,
                 certificate_id: pulumi.Input[_builtins.str],
                 listener_id: pulumi.Input[_builtins.str],
                 dry_run: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a ListenerAdditionalCertificateAttachment resource.
        :param pulumi.Input[_builtins.str] certificate_id: The ID of additional certificates.
        :param pulumi.Input[_builtins.str] listener_id: The listener ID. You must specify the ID of a listener that uses SSL over TCP.
        :param pulumi.Input[_builtins.bool] dry_run: Specifies whether to perform a dry run, without performing the actual request. Valid values:
        """
        pulumi.set(__self__, "certificate_id", certificate_id)
        pulumi.set(__self__, "listener_id", listener_id)
        if dry_run is not None:
            pulumi.set(__self__, "dry_run", dry_run)

    @_builtins.property
    @pulumi.getter(name="certificateId")
    def certificate_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of additional certificates.
        """
        return pulumi.get(self, "certificate_id")

    @certificate_id.setter
    def certificate_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "certificate_id", value)

    @_builtins.property
    @pulumi.getter(name="listenerId")
    def listener_id(self) -> pulumi.Input[_builtins.str]:
        """
        The listener ID. You must specify the ID of a listener that uses SSL over TCP.
        """
        return pulumi.get(self, "listener_id")

    @listener_id.setter
    def listener_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "listener_id", value)

    @_builtins.property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to perform a dry run, without performing the actual request. Valid values:
        """
        return pulumi.get(self, "dry_run")

    @dry_run.setter
    def dry_run(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "dry_run", value)


@pulumi.input_type
class _ListenerAdditionalCertificateAttachmentState:
    def __init__(__self__, *,
                 certificate_id: Optional[pulumi.Input[_builtins.str]] = None,
                 dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
                 listener_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ListenerAdditionalCertificateAttachment resources.
        :param pulumi.Input[_builtins.str] certificate_id: The ID of additional certificates.
        :param pulumi.Input[_builtins.bool] dry_run: Specifies whether to perform a dry run, without performing the actual request. Valid values:
        :param pulumi.Input[_builtins.str] listener_id: The listener ID. You must specify the ID of a listener that uses SSL over TCP.
        :param pulumi.Input[_builtins.str] status: The status of the resource
        """
        if certificate_id is not None:
            pulumi.set(__self__, "certificate_id", certificate_id)
        if dry_run is not None:
            pulumi.set(__self__, "dry_run", dry_run)
        if listener_id is not None:
            pulumi.set(__self__, "listener_id", listener_id)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="certificateId")
    def certificate_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of additional certificates.
        """
        return pulumi.get(self, "certificate_id")

    @certificate_id.setter
    def certificate_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "certificate_id", value)

    @_builtins.property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to perform a dry run, without performing the actual request. Valid values:
        """
        return pulumi.get(self, "dry_run")

    @dry_run.setter
    def dry_run(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "dry_run", value)

    @_builtins.property
    @pulumi.getter(name="listenerId")
    def listener_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The listener ID. You must specify the ID of a listener that uses SSL over TCP.
        """
        return pulumi.get(self, "listener_id")

    @listener_id.setter
    def listener_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "listener_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the resource
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.type_token("alicloud:nlb/listenerAdditionalCertificateAttachment:ListenerAdditionalCertificateAttachment")
class ListenerAdditionalCertificateAttachment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate_id: Optional[pulumi.Input[_builtins.str]] = None,
                 dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
                 listener_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a NLB Listener Additional Certificate Attachment resource.

        For information about NLB Listener Additional Certificate Attachment and how to use it, see [What is Listener Additional Certificate Attachment](https://www.alibabacloud.com/help/en/server-load-balancer/latest/nlb-instances-change).

        > **NOTE:** Available since v1.209.0.

        ## Import

        NLB Listener Additional Certificate Attachment can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:nlb/listenerAdditionalCertificateAttachment:ListenerAdditionalCertificateAttachment example <listener_id>:<certificate_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] certificate_id: The ID of additional certificates.
        :param pulumi.Input[_builtins.bool] dry_run: Specifies whether to perform a dry run, without performing the actual request. Valid values:
        :param pulumi.Input[_builtins.str] listener_id: The listener ID. You must specify the ID of a listener that uses SSL over TCP.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ListenerAdditionalCertificateAttachmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a NLB Listener Additional Certificate Attachment resource.

        For information about NLB Listener Additional Certificate Attachment and how to use it, see [What is Listener Additional Certificate Attachment](https://www.alibabacloud.com/help/en/server-load-balancer/latest/nlb-instances-change).

        > **NOTE:** Available since v1.209.0.

        ## Import

        NLB Listener Additional Certificate Attachment can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:nlb/listenerAdditionalCertificateAttachment:ListenerAdditionalCertificateAttachment example <listener_id>:<certificate_id>
        ```

        :param str resource_name: The name of the resource.
        :param ListenerAdditionalCertificateAttachmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ListenerAdditionalCertificateAttachmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate_id: Optional[pulumi.Input[_builtins.str]] = None,
                 dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
                 listener_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ListenerAdditionalCertificateAttachmentArgs.__new__(ListenerAdditionalCertificateAttachmentArgs)

            if certificate_id is None and not opts.urn:
                raise TypeError("Missing required property 'certificate_id'")
            __props__.__dict__["certificate_id"] = certificate_id
            __props__.__dict__["dry_run"] = dry_run
            if listener_id is None and not opts.urn:
                raise TypeError("Missing required property 'listener_id'")
            __props__.__dict__["listener_id"] = listener_id
            __props__.__dict__["status"] = None
        super(ListenerAdditionalCertificateAttachment, __self__).__init__(
            'alicloud:nlb/listenerAdditionalCertificateAttachment:ListenerAdditionalCertificateAttachment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            certificate_id: Optional[pulumi.Input[_builtins.str]] = None,
            dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
            listener_id: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None) -> 'ListenerAdditionalCertificateAttachment':
        """
        Get an existing ListenerAdditionalCertificateAttachment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] certificate_id: The ID of additional certificates.
        :param pulumi.Input[_builtins.bool] dry_run: Specifies whether to perform a dry run, without performing the actual request. Valid values:
        :param pulumi.Input[_builtins.str] listener_id: The listener ID. You must specify the ID of a listener that uses SSL over TCP.
        :param pulumi.Input[_builtins.str] status: The status of the resource
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ListenerAdditionalCertificateAttachmentState.__new__(_ListenerAdditionalCertificateAttachmentState)

        __props__.__dict__["certificate_id"] = certificate_id
        __props__.__dict__["dry_run"] = dry_run
        __props__.__dict__["listener_id"] = listener_id
        __props__.__dict__["status"] = status
        return ListenerAdditionalCertificateAttachment(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="certificateId")
    def certificate_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of additional certificates.
        """
        return pulumi.get(self, "certificate_id")

    @_builtins.property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether to perform a dry run, without performing the actual request. Valid values:
        """
        return pulumi.get(self, "dry_run")

    @_builtins.property
    @pulumi.getter(name="listenerId")
    def listener_id(self) -> pulumi.Output[_builtins.str]:
        """
        The listener ID. You must specify the ID of a listener that uses SSL over TCP.
        """
        return pulumi.get(self, "listener_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the resource
        """
        return pulumi.get(self, "status")

