# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['BucketPublicAccessBlockArgs', 'BucketPublicAccessBlock']

@pulumi.input_type
class BucketPublicAccessBlockArgs:
    def __init__(__self__, *,
                 block_public_access: pulumi.Input[_builtins.bool],
                 bucket: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a BucketPublicAccessBlock resource.
        :param pulumi.Input[_builtins.bool] block_public_access: Whether AlibabaCloud OSS should block public bucket policies and ACL for this bucket.
        :param pulumi.Input[_builtins.str] bucket: The name of the bucket.
        """
        pulumi.set(__self__, "block_public_access", block_public_access)
        pulumi.set(__self__, "bucket", bucket)

    @_builtins.property
    @pulumi.getter(name="blockPublicAccess")
    def block_public_access(self) -> pulumi.Input[_builtins.bool]:
        """
        Whether AlibabaCloud OSS should block public bucket policies and ACL for this bucket.
        """
        return pulumi.get(self, "block_public_access")

    @block_public_access.setter
    def block_public_access(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "block_public_access", value)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the bucket.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "bucket", value)


@pulumi.input_type
class _BucketPublicAccessBlockState:
    def __init__(__self__, *,
                 block_public_access: Optional[pulumi.Input[_builtins.bool]] = None,
                 bucket: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering BucketPublicAccessBlock resources.
        :param pulumi.Input[_builtins.bool] block_public_access: Whether AlibabaCloud OSS should block public bucket policies and ACL for this bucket.
        :param pulumi.Input[_builtins.str] bucket: The name of the bucket.
        """
        if block_public_access is not None:
            pulumi.set(__self__, "block_public_access", block_public_access)
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)

    @_builtins.property
    @pulumi.getter(name="blockPublicAccess")
    def block_public_access(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether AlibabaCloud OSS should block public bucket policies and ACL for this bucket.
        """
        return pulumi.get(self, "block_public_access")

    @block_public_access.setter
    def block_public_access(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "block_public_access", value)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the bucket.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bucket", value)


@pulumi.type_token("alicloud:oss/bucketPublicAccessBlock:BucketPublicAccessBlock")
class BucketPublicAccessBlock(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 block_public_access: Optional[pulumi.Input[_builtins.bool]] = None,
                 bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a OSS Bucket Public Access Block resource. Blocking public access at the bucket-level.

        For information about OSS Bucket Public Access Block and how to use it, see [What is Bucket Public Access Block](https://www.alibabacloud.com/help/en/oss/developer-reference/putbucketpublicaccessblock).

        > **NOTE:** Available since v1.224.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = random.index.Integer("default",
            min=10000,
            max=99999)
        create_bucket = alicloud.oss.Bucket("CreateBucket",
            storage_class="Standard",
            bucket=f"{name}-{default['result']}")
        default_bucket_public_access_block = alicloud.oss.BucketPublicAccessBlock("default",
            bucket=create_bucket.bucket,
            block_public_access=True)
        ```

        ## Import

        OSS Bucket Public Access Block can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:oss/bucketPublicAccessBlock:BucketPublicAccessBlock example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] block_public_access: Whether AlibabaCloud OSS should block public bucket policies and ACL for this bucket.
        :param pulumi.Input[_builtins.str] bucket: The name of the bucket.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BucketPublicAccessBlockArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a OSS Bucket Public Access Block resource. Blocking public access at the bucket-level.

        For information about OSS Bucket Public Access Block and how to use it, see [What is Bucket Public Access Block](https://www.alibabacloud.com/help/en/oss/developer-reference/putbucketpublicaccessblock).

        > **NOTE:** Available since v1.224.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = random.index.Integer("default",
            min=10000,
            max=99999)
        create_bucket = alicloud.oss.Bucket("CreateBucket",
            storage_class="Standard",
            bucket=f"{name}-{default['result']}")
        default_bucket_public_access_block = alicloud.oss.BucketPublicAccessBlock("default",
            bucket=create_bucket.bucket,
            block_public_access=True)
        ```

        ## Import

        OSS Bucket Public Access Block can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:oss/bucketPublicAccessBlock:BucketPublicAccessBlock example <id>
        ```

        :param str resource_name: The name of the resource.
        :param BucketPublicAccessBlockArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BucketPublicAccessBlockArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 block_public_access: Optional[pulumi.Input[_builtins.bool]] = None,
                 bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BucketPublicAccessBlockArgs.__new__(BucketPublicAccessBlockArgs)

            if block_public_access is None and not opts.urn:
                raise TypeError("Missing required property 'block_public_access'")
            __props__.__dict__["block_public_access"] = block_public_access
            if bucket is None and not opts.urn:
                raise TypeError("Missing required property 'bucket'")
            __props__.__dict__["bucket"] = bucket
        super(BucketPublicAccessBlock, __self__).__init__(
            'alicloud:oss/bucketPublicAccessBlock:BucketPublicAccessBlock',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            block_public_access: Optional[pulumi.Input[_builtins.bool]] = None,
            bucket: Optional[pulumi.Input[_builtins.str]] = None) -> 'BucketPublicAccessBlock':
        """
        Get an existing BucketPublicAccessBlock resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] block_public_access: Whether AlibabaCloud OSS should block public bucket policies and ACL for this bucket.
        :param pulumi.Input[_builtins.str] bucket: The name of the bucket.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BucketPublicAccessBlockState.__new__(_BucketPublicAccessBlockState)

        __props__.__dict__["block_public_access"] = block_public_access
        __props__.__dict__["bucket"] = bucket
        return BucketPublicAccessBlock(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="blockPublicAccess")
    def block_public_access(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether AlibabaCloud OSS should block public bucket policies and ACL for this bucket.
        """
        return pulumi.get(self, "block_public_access")

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the bucket.
        """
        return pulumi.get(self, "bucket")

