# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['BucketRefererArgs', 'BucketReferer']

@pulumi.input_type
class BucketRefererArgs:
    def __init__(__self__, *,
                 allow_empty_referer: pulumi.Input[_builtins.bool],
                 bucket: pulumi.Input[_builtins.str],
                 allow_truncate_query_string: Optional[pulumi.Input[_builtins.bool]] = None,
                 referer_blacklists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 referer_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 truncate_path: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a BucketReferer resource.
        :param pulumi.Input[_builtins.bool] allow_empty_referer: Whether to allow empty Referer request headers.
        :param pulumi.Input[_builtins.str] bucket: Name of the Bucket.
        :param pulumi.Input[_builtins.bool] allow_truncate_query_string: Specifies whether to truncate the query string in the URL when the Referer is matched. Valid values: true, false.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] referer_blacklists: The container that holds the Referer blacklist.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] referer_lists: The container that holds the Referer whitelist.
        :param pulumi.Input[_builtins.bool] truncate_path: Specifies whether to truncate the path and parts that follow the path in the URL when the Referer is matched. Valid values: true, false. If TruncatePath is set to true, the value of AllowTruncateQueryString must be also true because the query string follows the path component. When the path is truncated, the query string is also truncated.
        """
        pulumi.set(__self__, "allow_empty_referer", allow_empty_referer)
        pulumi.set(__self__, "bucket", bucket)
        if allow_truncate_query_string is not None:
            pulumi.set(__self__, "allow_truncate_query_string", allow_truncate_query_string)
        if referer_blacklists is not None:
            pulumi.set(__self__, "referer_blacklists", referer_blacklists)
        if referer_lists is not None:
            pulumi.set(__self__, "referer_lists", referer_lists)
        if truncate_path is not None:
            pulumi.set(__self__, "truncate_path", truncate_path)

    @_builtins.property
    @pulumi.getter(name="allowEmptyReferer")
    def allow_empty_referer(self) -> pulumi.Input[_builtins.bool]:
        """
        Whether to allow empty Referer request headers.
        """
        return pulumi.get(self, "allow_empty_referer")

    @allow_empty_referer.setter
    def allow_empty_referer(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "allow_empty_referer", value)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> pulumi.Input[_builtins.str]:
        """
        Name of the Bucket.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "bucket", value)

    @_builtins.property
    @pulumi.getter(name="allowTruncateQueryString")
    def allow_truncate_query_string(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to truncate the query string in the URL when the Referer is matched. Valid values: true, false.
        """
        return pulumi.get(self, "allow_truncate_query_string")

    @allow_truncate_query_string.setter
    def allow_truncate_query_string(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allow_truncate_query_string", value)

    @_builtins.property
    @pulumi.getter(name="refererBlacklists")
    def referer_blacklists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The container that holds the Referer blacklist.
        """
        return pulumi.get(self, "referer_blacklists")

    @referer_blacklists.setter
    def referer_blacklists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "referer_blacklists", value)

    @_builtins.property
    @pulumi.getter(name="refererLists")
    def referer_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The container that holds the Referer whitelist.
        """
        return pulumi.get(self, "referer_lists")

    @referer_lists.setter
    def referer_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "referer_lists", value)

    @_builtins.property
    @pulumi.getter(name="truncatePath")
    def truncate_path(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to truncate the path and parts that follow the path in the URL when the Referer is matched. Valid values: true, false. If TruncatePath is set to true, the value of AllowTruncateQueryString must be also true because the query string follows the path component. When the path is truncated, the query string is also truncated.
        """
        return pulumi.get(self, "truncate_path")

    @truncate_path.setter
    def truncate_path(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "truncate_path", value)


@pulumi.input_type
class _BucketRefererState:
    def __init__(__self__, *,
                 allow_empty_referer: Optional[pulumi.Input[_builtins.bool]] = None,
                 allow_truncate_query_string: Optional[pulumi.Input[_builtins.bool]] = None,
                 bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 referer_blacklists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 referer_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 truncate_path: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering BucketReferer resources.
        :param pulumi.Input[_builtins.bool] allow_empty_referer: Whether to allow empty Referer request headers.
        :param pulumi.Input[_builtins.bool] allow_truncate_query_string: Specifies whether to truncate the query string in the URL when the Referer is matched. Valid values: true, false.
        :param pulumi.Input[_builtins.str] bucket: Name of the Bucket.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] referer_blacklists: The container that holds the Referer blacklist.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] referer_lists: The container that holds the Referer whitelist.
        :param pulumi.Input[_builtins.bool] truncate_path: Specifies whether to truncate the path and parts that follow the path in the URL when the Referer is matched. Valid values: true, false. If TruncatePath is set to true, the value of AllowTruncateQueryString must be also true because the query string follows the path component. When the path is truncated, the query string is also truncated.
        """
        if allow_empty_referer is not None:
            pulumi.set(__self__, "allow_empty_referer", allow_empty_referer)
        if allow_truncate_query_string is not None:
            pulumi.set(__self__, "allow_truncate_query_string", allow_truncate_query_string)
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if referer_blacklists is not None:
            pulumi.set(__self__, "referer_blacklists", referer_blacklists)
        if referer_lists is not None:
            pulumi.set(__self__, "referer_lists", referer_lists)
        if truncate_path is not None:
            pulumi.set(__self__, "truncate_path", truncate_path)

    @_builtins.property
    @pulumi.getter(name="allowEmptyReferer")
    def allow_empty_referer(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to allow empty Referer request headers.
        """
        return pulumi.get(self, "allow_empty_referer")

    @allow_empty_referer.setter
    def allow_empty_referer(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allow_empty_referer", value)

    @_builtins.property
    @pulumi.getter(name="allowTruncateQueryString")
    def allow_truncate_query_string(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to truncate the query string in the URL when the Referer is matched. Valid values: true, false.
        """
        return pulumi.get(self, "allow_truncate_query_string")

    @allow_truncate_query_string.setter
    def allow_truncate_query_string(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allow_truncate_query_string", value)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the Bucket.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bucket", value)

    @_builtins.property
    @pulumi.getter(name="refererBlacklists")
    def referer_blacklists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The container that holds the Referer blacklist.
        """
        return pulumi.get(self, "referer_blacklists")

    @referer_blacklists.setter
    def referer_blacklists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "referer_blacklists", value)

    @_builtins.property
    @pulumi.getter(name="refererLists")
    def referer_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The container that holds the Referer whitelist.
        """
        return pulumi.get(self, "referer_lists")

    @referer_lists.setter
    def referer_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "referer_lists", value)

    @_builtins.property
    @pulumi.getter(name="truncatePath")
    def truncate_path(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to truncate the path and parts that follow the path in the URL when the Referer is matched. Valid values: true, false. If TruncatePath is set to true, the value of AllowTruncateQueryString must be also true because the query string follows the path component. When the path is truncated, the query string is also truncated.
        """
        return pulumi.get(self, "truncate_path")

    @truncate_path.setter
    def truncate_path(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "truncate_path", value)


@pulumi.type_token("alicloud:oss/bucketReferer:BucketReferer")
class BucketReferer(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_empty_referer: Optional[pulumi.Input[_builtins.bool]] = None,
                 allow_truncate_query_string: Optional[pulumi.Input[_builtins.bool]] = None,
                 bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 referer_blacklists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 referer_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 truncate_path: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        Provides a OSS Bucket Referer resource. Bucket Referer configuration (Hotlink protection).

        For information about OSS Bucket Referer and how to use it, see [What is Bucket Referer](https://www.alibabacloud.com/help/en/oss/user-guide/hotlink-protection).

        > **NOTE:** Available since v1.220.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = random.index.Integer("default",
            min=10000,
            max=99999)
        create_bucket = alicloud.oss.Bucket("CreateBucket",
            storage_class="Standard",
            bucket=f"{name}-{default['result']}")
        default_bucket_referer = alicloud.oss.BucketReferer("default",
            allow_empty_referer=True,
            referer_blacklists=["*.forbidden.com"],
            bucket=create_bucket.bucket,
            truncate_path=False,
            allow_truncate_query_string=True,
            referer_lists=[
                "*.aliyun.com",
                "*.example.com",
            ])
        ```

        ## Import

        OSS Bucket Referer can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:oss/bucketReferer:BucketReferer example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] allow_empty_referer: Whether to allow empty Referer request headers.
        :param pulumi.Input[_builtins.bool] allow_truncate_query_string: Specifies whether to truncate the query string in the URL when the Referer is matched. Valid values: true, false.
        :param pulumi.Input[_builtins.str] bucket: Name of the Bucket.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] referer_blacklists: The container that holds the Referer blacklist.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] referer_lists: The container that holds the Referer whitelist.
        :param pulumi.Input[_builtins.bool] truncate_path: Specifies whether to truncate the path and parts that follow the path in the URL when the Referer is matched. Valid values: true, false. If TruncatePath is set to true, the value of AllowTruncateQueryString must be also true because the query string follows the path component. When the path is truncated, the query string is also truncated.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BucketRefererArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a OSS Bucket Referer resource. Bucket Referer configuration (Hotlink protection).

        For information about OSS Bucket Referer and how to use it, see [What is Bucket Referer](https://www.alibabacloud.com/help/en/oss/user-guide/hotlink-protection).

        > **NOTE:** Available since v1.220.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = random.index.Integer("default",
            min=10000,
            max=99999)
        create_bucket = alicloud.oss.Bucket("CreateBucket",
            storage_class="Standard",
            bucket=f"{name}-{default['result']}")
        default_bucket_referer = alicloud.oss.BucketReferer("default",
            allow_empty_referer=True,
            referer_blacklists=["*.forbidden.com"],
            bucket=create_bucket.bucket,
            truncate_path=False,
            allow_truncate_query_string=True,
            referer_lists=[
                "*.aliyun.com",
                "*.example.com",
            ])
        ```

        ## Import

        OSS Bucket Referer can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:oss/bucketReferer:BucketReferer example <id>
        ```

        :param str resource_name: The name of the resource.
        :param BucketRefererArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BucketRefererArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_empty_referer: Optional[pulumi.Input[_builtins.bool]] = None,
                 allow_truncate_query_string: Optional[pulumi.Input[_builtins.bool]] = None,
                 bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 referer_blacklists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 referer_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 truncate_path: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BucketRefererArgs.__new__(BucketRefererArgs)

            if allow_empty_referer is None and not opts.urn:
                raise TypeError("Missing required property 'allow_empty_referer'")
            __props__.__dict__["allow_empty_referer"] = allow_empty_referer
            __props__.__dict__["allow_truncate_query_string"] = allow_truncate_query_string
            if bucket is None and not opts.urn:
                raise TypeError("Missing required property 'bucket'")
            __props__.__dict__["bucket"] = bucket
            __props__.__dict__["referer_blacklists"] = referer_blacklists
            __props__.__dict__["referer_lists"] = referer_lists
            __props__.__dict__["truncate_path"] = truncate_path
        super(BucketReferer, __self__).__init__(
            'alicloud:oss/bucketReferer:BucketReferer',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allow_empty_referer: Optional[pulumi.Input[_builtins.bool]] = None,
            allow_truncate_query_string: Optional[pulumi.Input[_builtins.bool]] = None,
            bucket: Optional[pulumi.Input[_builtins.str]] = None,
            referer_blacklists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            referer_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            truncate_path: Optional[pulumi.Input[_builtins.bool]] = None) -> 'BucketReferer':
        """
        Get an existing BucketReferer resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] allow_empty_referer: Whether to allow empty Referer request headers.
        :param pulumi.Input[_builtins.bool] allow_truncate_query_string: Specifies whether to truncate the query string in the URL when the Referer is matched. Valid values: true, false.
        :param pulumi.Input[_builtins.str] bucket: Name of the Bucket.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] referer_blacklists: The container that holds the Referer blacklist.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] referer_lists: The container that holds the Referer whitelist.
        :param pulumi.Input[_builtins.bool] truncate_path: Specifies whether to truncate the path and parts that follow the path in the URL when the Referer is matched. Valid values: true, false. If TruncatePath is set to true, the value of AllowTruncateQueryString must be also true because the query string follows the path component. When the path is truncated, the query string is also truncated.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BucketRefererState.__new__(_BucketRefererState)

        __props__.__dict__["allow_empty_referer"] = allow_empty_referer
        __props__.__dict__["allow_truncate_query_string"] = allow_truncate_query_string
        __props__.__dict__["bucket"] = bucket
        __props__.__dict__["referer_blacklists"] = referer_blacklists
        __props__.__dict__["referer_lists"] = referer_lists
        __props__.__dict__["truncate_path"] = truncate_path
        return BucketReferer(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="allowEmptyReferer")
    def allow_empty_referer(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether to allow empty Referer request headers.
        """
        return pulumi.get(self, "allow_empty_referer")

    @_builtins.property
    @pulumi.getter(name="allowTruncateQueryString")
    def allow_truncate_query_string(self) -> pulumi.Output[_builtins.bool]:
        """
        Specifies whether to truncate the query string in the URL when the Referer is matched. Valid values: true, false.
        """
        return pulumi.get(self, "allow_truncate_query_string")

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the Bucket.
        """
        return pulumi.get(self, "bucket")

    @_builtins.property
    @pulumi.getter(name="refererBlacklists")
    def referer_blacklists(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The container that holds the Referer blacklist.
        """
        return pulumi.get(self, "referer_blacklists")

    @_builtins.property
    @pulumi.getter(name="refererLists")
    def referer_lists(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The container that holds the Referer whitelist.
        """
        return pulumi.get(self, "referer_lists")

    @_builtins.property
    @pulumi.getter(name="truncatePath")
    def truncate_path(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether to truncate the path and parts that follow the path in the URL when the Referer is matched. Valid values: true, false. If TruncatePath is set to true, the value of AllowTruncateQueryString must be also true because the query string follows the path component. When the path is truncated, the query string is also truncated.
        """
        return pulumi.get(self, "truncate_path")

