# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['BucketWebsiteInitArgs', 'BucketWebsite']

@pulumi.input_type
class BucketWebsiteInitArgs:
    def __init__(__self__, *,
                 bucket: pulumi.Input[_builtins.str],
                 error_document: Optional[pulumi.Input['BucketWebsiteErrorDocumentArgs']] = None,
                 index_document: Optional[pulumi.Input['BucketWebsiteIndexDocumentArgs']] = None,
                 routing_rules: Optional[pulumi.Input['BucketWebsiteRoutingRulesArgs']] = None):
        """
        The set of arguments for constructing a BucketWebsite resource.
        :param pulumi.Input[_builtins.str] bucket: The name of the bucket
        :param pulumi.Input['BucketWebsiteErrorDocumentArgs'] error_document: The container that holds the error page configuration information. See `error_document` below.
        :param pulumi.Input['BucketWebsiteIndexDocumentArgs'] index_document: Static Website Default Home Page Configuration See `index_document` below.
        :param pulumi.Input['BucketWebsiteRoutingRulesArgs'] routing_rules: The container that holds the jump rule or the mirroring back-to-origin rule. See `routing_rules` below.
        """
        pulumi.set(__self__, "bucket", bucket)
        if error_document is not None:
            pulumi.set(__self__, "error_document", error_document)
        if index_document is not None:
            pulumi.set(__self__, "index_document", index_document)
        if routing_rules is not None:
            pulumi.set(__self__, "routing_rules", routing_rules)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the bucket
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "bucket", value)

    @_builtins.property
    @pulumi.getter(name="errorDocument")
    def error_document(self) -> Optional[pulumi.Input['BucketWebsiteErrorDocumentArgs']]:
        """
        The container that holds the error page configuration information. See `error_document` below.
        """
        return pulumi.get(self, "error_document")

    @error_document.setter
    def error_document(self, value: Optional[pulumi.Input['BucketWebsiteErrorDocumentArgs']]):
        pulumi.set(self, "error_document", value)

    @_builtins.property
    @pulumi.getter(name="indexDocument")
    def index_document(self) -> Optional[pulumi.Input['BucketWebsiteIndexDocumentArgs']]:
        """
        Static Website Default Home Page Configuration See `index_document` below.
        """
        return pulumi.get(self, "index_document")

    @index_document.setter
    def index_document(self, value: Optional[pulumi.Input['BucketWebsiteIndexDocumentArgs']]):
        pulumi.set(self, "index_document", value)

    @_builtins.property
    @pulumi.getter(name="routingRules")
    def routing_rules(self) -> Optional[pulumi.Input['BucketWebsiteRoutingRulesArgs']]:
        """
        The container that holds the jump rule or the mirroring back-to-origin rule. See `routing_rules` below.
        """
        return pulumi.get(self, "routing_rules")

    @routing_rules.setter
    def routing_rules(self, value: Optional[pulumi.Input['BucketWebsiteRoutingRulesArgs']]):
        pulumi.set(self, "routing_rules", value)


@pulumi.input_type
class _BucketWebsiteState:
    def __init__(__self__, *,
                 bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 error_document: Optional[pulumi.Input['BucketWebsiteErrorDocumentArgs']] = None,
                 index_document: Optional[pulumi.Input['BucketWebsiteIndexDocumentArgs']] = None,
                 routing_rules: Optional[pulumi.Input['BucketWebsiteRoutingRulesArgs']] = None):
        """
        Input properties used for looking up and filtering BucketWebsite resources.
        :param pulumi.Input[_builtins.str] bucket: The name of the bucket
        :param pulumi.Input['BucketWebsiteErrorDocumentArgs'] error_document: The container that holds the error page configuration information. See `error_document` below.
        :param pulumi.Input['BucketWebsiteIndexDocumentArgs'] index_document: Static Website Default Home Page Configuration See `index_document` below.
        :param pulumi.Input['BucketWebsiteRoutingRulesArgs'] routing_rules: The container that holds the jump rule or the mirroring back-to-origin rule. See `routing_rules` below.
        """
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if error_document is not None:
            pulumi.set(__self__, "error_document", error_document)
        if index_document is not None:
            pulumi.set(__self__, "index_document", index_document)
        if routing_rules is not None:
            pulumi.set(__self__, "routing_rules", routing_rules)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the bucket
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bucket", value)

    @_builtins.property
    @pulumi.getter(name="errorDocument")
    def error_document(self) -> Optional[pulumi.Input['BucketWebsiteErrorDocumentArgs']]:
        """
        The container that holds the error page configuration information. See `error_document` below.
        """
        return pulumi.get(self, "error_document")

    @error_document.setter
    def error_document(self, value: Optional[pulumi.Input['BucketWebsiteErrorDocumentArgs']]):
        pulumi.set(self, "error_document", value)

    @_builtins.property
    @pulumi.getter(name="indexDocument")
    def index_document(self) -> Optional[pulumi.Input['BucketWebsiteIndexDocumentArgs']]:
        """
        Static Website Default Home Page Configuration See `index_document` below.
        """
        return pulumi.get(self, "index_document")

    @index_document.setter
    def index_document(self, value: Optional[pulumi.Input['BucketWebsiteIndexDocumentArgs']]):
        pulumi.set(self, "index_document", value)

    @_builtins.property
    @pulumi.getter(name="routingRules")
    def routing_rules(self) -> Optional[pulumi.Input['BucketWebsiteRoutingRulesArgs']]:
        """
        The container that holds the jump rule or the mirroring back-to-origin rule. See `routing_rules` below.
        """
        return pulumi.get(self, "routing_rules")

    @routing_rules.setter
    def routing_rules(self, value: Optional[pulumi.Input['BucketWebsiteRoutingRulesArgs']]):
        pulumi.set(self, "routing_rules", value)


@pulumi.type_token("alicloud:oss/bucketWebsite:BucketWebsite")
class BucketWebsite(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 error_document: Optional[pulumi.Input[Union['BucketWebsiteErrorDocumentArgs', 'BucketWebsiteErrorDocumentArgsDict']]] = None,
                 index_document: Optional[pulumi.Input[Union['BucketWebsiteIndexDocumentArgs', 'BucketWebsiteIndexDocumentArgsDict']]] = None,
                 routing_rules: Optional[pulumi.Input[Union['BucketWebsiteRoutingRulesArgs', 'BucketWebsiteRoutingRulesArgsDict']]] = None,
                 __props__=None):
        """
        Provides a OSS Bucket Website resource.

        the static website configuration and mirror configuration of the bucket.

        For information about OSS Bucket Website and how to use it, see [What is Bucket Website](https://www.alibabacloud.com/help/en/oss/developer-reference/putbucketwebsite).

        > **NOTE:** Available since v1.237.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = random.index.Uuid("default")
        defaultn_vj9x3 = alicloud.oss.Bucket("defaultnVj9x3",
            bucket=f"{name}-{default['result']}",
            storage_class="Standard")
        default_bucket_website = alicloud.oss.BucketWebsite("default",
            index_document={
                "suffix": "index.html",
                "support_sub_dir": True,
                "type": "0",
            },
            error_document={
                "key": "error.html",
                "http_status": 404,
            },
            bucket=defaultn_vj9x3.bucket,
            routing_rules={
                "routing_rules": [{
                    "rule_number": 1,
                    "condition": {
                        "http_error_code_returned_equals": "404",
                    },
                    "redirect": {
                        "protocol": "https",
                        "http_redirect_code": "305",
                        "redirect_type": "AliCDN",
                        "host_name": "www.alicdn-master.com",
                    },
                    "lua_config": {
                        "script": "example.lua",
                    },
                }],
            })
        ```

        ## Import

        OSS Bucket Website can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:oss/bucketWebsite:BucketWebsite example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] bucket: The name of the bucket
        :param pulumi.Input[Union['BucketWebsiteErrorDocumentArgs', 'BucketWebsiteErrorDocumentArgsDict']] error_document: The container that holds the error page configuration information. See `error_document` below.
        :param pulumi.Input[Union['BucketWebsiteIndexDocumentArgs', 'BucketWebsiteIndexDocumentArgsDict']] index_document: Static Website Default Home Page Configuration See `index_document` below.
        :param pulumi.Input[Union['BucketWebsiteRoutingRulesArgs', 'BucketWebsiteRoutingRulesArgsDict']] routing_rules: The container that holds the jump rule or the mirroring back-to-origin rule. See `routing_rules` below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BucketWebsiteInitArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a OSS Bucket Website resource.

        the static website configuration and mirror configuration of the bucket.

        For information about OSS Bucket Website and how to use it, see [What is Bucket Website](https://www.alibabacloud.com/help/en/oss/developer-reference/putbucketwebsite).

        > **NOTE:** Available since v1.237.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = random.index.Uuid("default")
        defaultn_vj9x3 = alicloud.oss.Bucket("defaultnVj9x3",
            bucket=f"{name}-{default['result']}",
            storage_class="Standard")
        default_bucket_website = alicloud.oss.BucketWebsite("default",
            index_document={
                "suffix": "index.html",
                "support_sub_dir": True,
                "type": "0",
            },
            error_document={
                "key": "error.html",
                "http_status": 404,
            },
            bucket=defaultn_vj9x3.bucket,
            routing_rules={
                "routing_rules": [{
                    "rule_number": 1,
                    "condition": {
                        "http_error_code_returned_equals": "404",
                    },
                    "redirect": {
                        "protocol": "https",
                        "http_redirect_code": "305",
                        "redirect_type": "AliCDN",
                        "host_name": "www.alicdn-master.com",
                    },
                    "lua_config": {
                        "script": "example.lua",
                    },
                }],
            })
        ```

        ## Import

        OSS Bucket Website can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:oss/bucketWebsite:BucketWebsite example <id>
        ```

        :param str resource_name: The name of the resource.
        :param BucketWebsiteInitArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BucketWebsiteInitArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 error_document: Optional[pulumi.Input[Union['BucketWebsiteErrorDocumentArgs', 'BucketWebsiteErrorDocumentArgsDict']]] = None,
                 index_document: Optional[pulumi.Input[Union['BucketWebsiteIndexDocumentArgs', 'BucketWebsiteIndexDocumentArgsDict']]] = None,
                 routing_rules: Optional[pulumi.Input[Union['BucketWebsiteRoutingRulesArgs', 'BucketWebsiteRoutingRulesArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BucketWebsiteInitArgs.__new__(BucketWebsiteInitArgs)

            if bucket is None and not opts.urn:
                raise TypeError("Missing required property 'bucket'")
            __props__.__dict__["bucket"] = bucket
            __props__.__dict__["error_document"] = error_document
            __props__.__dict__["index_document"] = index_document
            __props__.__dict__["routing_rules"] = routing_rules
        super(BucketWebsite, __self__).__init__(
            'alicloud:oss/bucketWebsite:BucketWebsite',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            bucket: Optional[pulumi.Input[_builtins.str]] = None,
            error_document: Optional[pulumi.Input[Union['BucketWebsiteErrorDocumentArgs', 'BucketWebsiteErrorDocumentArgsDict']]] = None,
            index_document: Optional[pulumi.Input[Union['BucketWebsiteIndexDocumentArgs', 'BucketWebsiteIndexDocumentArgsDict']]] = None,
            routing_rules: Optional[pulumi.Input[Union['BucketWebsiteRoutingRulesArgs', 'BucketWebsiteRoutingRulesArgsDict']]] = None) -> 'BucketWebsite':
        """
        Get an existing BucketWebsite resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] bucket: The name of the bucket
        :param pulumi.Input[Union['BucketWebsiteErrorDocumentArgs', 'BucketWebsiteErrorDocumentArgsDict']] error_document: The container that holds the error page configuration information. See `error_document` below.
        :param pulumi.Input[Union['BucketWebsiteIndexDocumentArgs', 'BucketWebsiteIndexDocumentArgsDict']] index_document: Static Website Default Home Page Configuration See `index_document` below.
        :param pulumi.Input[Union['BucketWebsiteRoutingRulesArgs', 'BucketWebsiteRoutingRulesArgsDict']] routing_rules: The container that holds the jump rule or the mirroring back-to-origin rule. See `routing_rules` below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BucketWebsiteState.__new__(_BucketWebsiteState)

        __props__.__dict__["bucket"] = bucket
        __props__.__dict__["error_document"] = error_document
        __props__.__dict__["index_document"] = index_document
        __props__.__dict__["routing_rules"] = routing_rules
        return BucketWebsite(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the bucket
        """
        return pulumi.get(self, "bucket")

    @_builtins.property
    @pulumi.getter(name="errorDocument")
    def error_document(self) -> pulumi.Output[Optional['outputs.BucketWebsiteErrorDocument']]:
        """
        The container that holds the error page configuration information. See `error_document` below.
        """
        return pulumi.get(self, "error_document")

    @_builtins.property
    @pulumi.getter(name="indexDocument")
    def index_document(self) -> pulumi.Output[Optional['outputs.BucketWebsiteIndexDocument']]:
        """
        Static Website Default Home Page Configuration See `index_document` below.
        """
        return pulumi.get(self, "index_document")

    @_builtins.property
    @pulumi.getter(name="routingRules")
    def routing_rules(self) -> pulumi.Output[Optional['outputs.BucketWebsiteRoutingRules']]:
        """
        The container that holds the jump rule or the mirroring back-to-origin rule. See `routing_rules` below.
        """
        return pulumi.get(self, "routing_rules")

