# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ServiceArgs', 'Service']

@pulumi.input_type
class ServiceArgs:
    def __init__(__self__, *,
                 service_config: pulumi.Input[_builtins.str],
                 develop: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 workspace_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Service resource.
        :param pulumi.Input[_builtins.str] service_config: Service configuration information. Please refer to https://www.alibabacloud.com/help/en/pai/user-guide/parameters-of-model-services
        :param pulumi.Input[_builtins.str] develop: Whether to enter the development mode.
        :param pulumi.Input[_builtins.str] status: Service Current Status.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag of the resource.
        :param pulumi.Input[_builtins.str] workspace_id: Workspace id
        """
        pulumi.set(__self__, "service_config", service_config)
        if develop is not None:
            pulumi.set(__self__, "develop", develop)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if workspace_id is not None:
            pulumi.set(__self__, "workspace_id", workspace_id)

    @_builtins.property
    @pulumi.getter(name="serviceConfig")
    def service_config(self) -> pulumi.Input[_builtins.str]:
        """
        Service configuration information. Please refer to https://www.alibabacloud.com/help/en/pai/user-guide/parameters-of-model-services
        """
        return pulumi.get(self, "service_config")

    @service_config.setter
    def service_config(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "service_config", value)

    @_builtins.property
    @pulumi.getter
    def develop(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether to enter the development mode.
        """
        return pulumi.get(self, "develop")

    @develop.setter
    def develop(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "develop", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Service Current Status.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The tag of the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Workspace id
        """
        return pulumi.get(self, "workspace_id")

    @workspace_id.setter
    def workspace_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "workspace_id", value)


@pulumi.input_type
class _ServiceState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 develop: Optional[pulumi.Input[_builtins.str]] = None,
                 region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 service_config: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 workspace_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Service resources.
        :param pulumi.Input[_builtins.str] create_time: Creation time of the service
        :param pulumi.Input[_builtins.str] develop: Whether to enter the development mode.
        :param pulumi.Input[_builtins.str] region_id: The region ID of the resource
        :param pulumi.Input[_builtins.str] service_config: Service configuration information. Please refer to https://www.alibabacloud.com/help/en/pai/user-guide/parameters-of-model-services
        :param pulumi.Input[_builtins.str] status: Service Current Status.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag of the resource.
        :param pulumi.Input[_builtins.str] workspace_id: Workspace id
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if develop is not None:
            pulumi.set(__self__, "develop", develop)
        if region_id is not None:
            pulumi.set(__self__, "region_id", region_id)
        if service_config is not None:
            pulumi.set(__self__, "service_config", service_config)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if workspace_id is not None:
            pulumi.set(__self__, "workspace_id", workspace_id)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Creation time of the service
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter
    def develop(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether to enter the development mode.
        """
        return pulumi.get(self, "develop")

    @develop.setter
    def develop(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "develop", value)

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region ID of the resource
        """
        return pulumi.get(self, "region_id")

    @region_id.setter
    def region_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region_id", value)

    @_builtins.property
    @pulumi.getter(name="serviceConfig")
    def service_config(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Service configuration information. Please refer to https://www.alibabacloud.com/help/en/pai/user-guide/parameters-of-model-services
        """
        return pulumi.get(self, "service_config")

    @service_config.setter
    def service_config(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_config", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Service Current Status.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The tag of the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Workspace id
        """
        return pulumi.get(self, "workspace_id")

    @workspace_id.setter
    def workspace_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "workspace_id", value)


@pulumi.type_token("alicloud:pai/service:Service")
class Service(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 develop: Optional[pulumi.Input[_builtins.str]] = None,
                 service_config: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a PAI Service resource.

        Eas service instance.

        For information about PAI Service and how to use it, see [What is Service](https://www.alibabacloud.com/help/en/pai/developer-reference/api-eas-2021-07-01-createservice).

        > **NOTE:** Field `labels` has been removed since version 1.245.0. Please use new field `tags`.

        > **NOTE:** Available since v1.238.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import json
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.pai.Service("default",
            develop="false",
            service_config=json.dumps({
                "metadata": {
                    "cpu": 1,
                    "gpu": 0,
                    "instance": 1,
                    "memory": 2000,
                    "name": "tfexample",
                    "rpc": {
                        "keepalive": 70000,
                    },
                },
                "model_path": "http://eas-data.oss-cn-shanghai.aliyuncs.com/processors/echo_processor_release.tar.gz",
                "processor_entry": "libecho.so",
                "processor_path": "http://eas-data.oss-cn-shanghai.aliyuncs.com/processors/echo_processor_release.tar.gz",
                "processor_type": "cpp",
            }))
        ```

        ## Import

        PAI Service can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:pai/service:Service example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] develop: Whether to enter the development mode.
        :param pulumi.Input[_builtins.str] service_config: Service configuration information. Please refer to https://www.alibabacloud.com/help/en/pai/user-guide/parameters-of-model-services
        :param pulumi.Input[_builtins.str] status: Service Current Status.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag of the resource.
        :param pulumi.Input[_builtins.str] workspace_id: Workspace id
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServiceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a PAI Service resource.

        Eas service instance.

        For information about PAI Service and how to use it, see [What is Service](https://www.alibabacloud.com/help/en/pai/developer-reference/api-eas-2021-07-01-createservice).

        > **NOTE:** Field `labels` has been removed since version 1.245.0. Please use new field `tags`.

        > **NOTE:** Available since v1.238.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import json
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.pai.Service("default",
            develop="false",
            service_config=json.dumps({
                "metadata": {
                    "cpu": 1,
                    "gpu": 0,
                    "instance": 1,
                    "memory": 2000,
                    "name": "tfexample",
                    "rpc": {
                        "keepalive": 70000,
                    },
                },
                "model_path": "http://eas-data.oss-cn-shanghai.aliyuncs.com/processors/echo_processor_release.tar.gz",
                "processor_entry": "libecho.so",
                "processor_path": "http://eas-data.oss-cn-shanghai.aliyuncs.com/processors/echo_processor_release.tar.gz",
                "processor_type": "cpp",
            }))
        ```

        ## Import

        PAI Service can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:pai/service:Service example <id>
        ```

        :param str resource_name: The name of the resource.
        :param ServiceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServiceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 develop: Optional[pulumi.Input[_builtins.str]] = None,
                 service_config: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServiceArgs.__new__(ServiceArgs)

            __props__.__dict__["develop"] = develop
            if service_config is None and not opts.urn:
                raise TypeError("Missing required property 'service_config'")
            __props__.__dict__["service_config"] = service_config
            __props__.__dict__["status"] = status
            __props__.__dict__["tags"] = tags
            __props__.__dict__["workspace_id"] = workspace_id
            __props__.__dict__["create_time"] = None
            __props__.__dict__["region_id"] = None
        super(Service, __self__).__init__(
            'alicloud:pai/service:Service',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            develop: Optional[pulumi.Input[_builtins.str]] = None,
            region_id: Optional[pulumi.Input[_builtins.str]] = None,
            service_config: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            workspace_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'Service':
        """
        Get an existing Service resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] create_time: Creation time of the service
        :param pulumi.Input[_builtins.str] develop: Whether to enter the development mode.
        :param pulumi.Input[_builtins.str] region_id: The region ID of the resource
        :param pulumi.Input[_builtins.str] service_config: Service configuration information. Please refer to https://www.alibabacloud.com/help/en/pai/user-guide/parameters-of-model-services
        :param pulumi.Input[_builtins.str] status: Service Current Status.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag of the resource.
        :param pulumi.Input[_builtins.str] workspace_id: Workspace id
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServiceState.__new__(_ServiceState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["develop"] = develop
        __props__.__dict__["region_id"] = region_id
        __props__.__dict__["service_config"] = service_config
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["workspace_id"] = workspace_id
        return Service(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        Creation time of the service
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def develop(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Whether to enter the development mode.
        """
        return pulumi.get(self, "develop")

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> pulumi.Output[_builtins.str]:
        """
        The region ID of the resource
        """
        return pulumi.get(self, "region_id")

    @_builtins.property
    @pulumi.getter(name="serviceConfig")
    def service_config(self) -> pulumi.Output[_builtins.str]:
        """
        Service configuration information. Please refer to https://www.alibabacloud.com/help/en/pai/user-guide/parameters-of-model-services
        """
        return pulumi.get(self, "service_config")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Service Current Status.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        The tag of the resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Workspace id
        """
        return pulumi.get(self, "workspace_id")

