# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['WorkspaceModelVersionArgs', 'WorkspaceModelVersion']

@pulumi.input_type
class WorkspaceModelVersionArgs:
    def __init__(__self__, *,
                 model_id: pulumi.Input[_builtins.str],
                 uri: pulumi.Input[_builtins.str],
                 approval_status: Optional[pulumi.Input[_builtins.str]] = None,
                 extra_info: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 format_type: Optional[pulumi.Input[_builtins.str]] = None,
                 framework_type: Optional[pulumi.Input[_builtins.str]] = None,
                 inference_spec: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 labels: Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceModelVersionLabelArgs']]]] = None,
                 metrics: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 options: Optional[pulumi.Input[_builtins.str]] = None,
                 source_id: Optional[pulumi.Input[_builtins.str]] = None,
                 source_type: Optional[pulumi.Input[_builtins.str]] = None,
                 training_spec: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 version_description: Optional[pulumi.Input[_builtins.str]] = None,
                 version_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a WorkspaceModelVersion resource.
        :param pulumi.Input[_builtins.str] model_id: The model ID.
        :param pulumi.Input[_builtins.str] uri: The URI of the model version.
        :param pulumi.Input[_builtins.str] approval_status: The approval status. Valid values:
               - Pending: To be determined.
               - Approved: Allow to go online.
               - Rejected: Online is not allowed.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] extra_info: Other information.
        :param pulumi.Input[_builtins.str] format_type: The format of the model. Valid values:
               - OfflineModel
               - SavedModel
               - Keras H5
               - Frozen Pb
               - Caffe Prototxt
               - TorchScript
               - XGBoost
               - PMML
               - AlinkModel
               - ONNX
        :param pulumi.Input[_builtins.str] framework_type: The framework of the model. Valid values:
               - Pytorch
               - XGBoost
               - Keras
               - Caffe
               - Alink
               - Xflow
               - TensorFlow
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] inference_spec: Describes how to apply to downstream inference services.
        :param pulumi.Input[Sequence[pulumi.Input['WorkspaceModelVersionLabelArgs']]] labels: List of model version labels. See `labels` below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] metrics: The metrics for the model. The serialized length is limited to 8192.
        :param pulumi.Input[_builtins.str] options: The extended field. This is a JSON string.
        :param pulumi.Input[_builtins.str] source_id: The source ID.
        :param pulumi.Input[_builtins.str] source_type: The type of the model source. Valid values:
               - Custom: Custom.
               - PAIFlow:PAI workflow.
               - TrainingService:PAI training service.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] training_spec: The training configurations. Used for fine-tuning and incremental training.
        :param pulumi.Input[_builtins.str] version_description: The version descriptions.
        :param pulumi.Input[_builtins.str] version_name: The Model version.
        """
        pulumi.set(__self__, "model_id", model_id)
        pulumi.set(__self__, "uri", uri)
        if approval_status is not None:
            pulumi.set(__self__, "approval_status", approval_status)
        if extra_info is not None:
            pulumi.set(__self__, "extra_info", extra_info)
        if format_type is not None:
            pulumi.set(__self__, "format_type", format_type)
        if framework_type is not None:
            pulumi.set(__self__, "framework_type", framework_type)
        if inference_spec is not None:
            pulumi.set(__self__, "inference_spec", inference_spec)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if metrics is not None:
            pulumi.set(__self__, "metrics", metrics)
        if options is not None:
            pulumi.set(__self__, "options", options)
        if source_id is not None:
            pulumi.set(__self__, "source_id", source_id)
        if source_type is not None:
            pulumi.set(__self__, "source_type", source_type)
        if training_spec is not None:
            pulumi.set(__self__, "training_spec", training_spec)
        if version_description is not None:
            pulumi.set(__self__, "version_description", version_description)
        if version_name is not None:
            pulumi.set(__self__, "version_name", version_name)

    @_builtins.property
    @pulumi.getter(name="modelId")
    def model_id(self) -> pulumi.Input[_builtins.str]:
        """
        The model ID.
        """
        return pulumi.get(self, "model_id")

    @model_id.setter
    def model_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "model_id", value)

    @_builtins.property
    @pulumi.getter
    def uri(self) -> pulumi.Input[_builtins.str]:
        """
        The URI of the model version.
        """
        return pulumi.get(self, "uri")

    @uri.setter
    def uri(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "uri", value)

    @_builtins.property
    @pulumi.getter(name="approvalStatus")
    def approval_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The approval status. Valid values:
        - Pending: To be determined.
        - Approved: Allow to go online.
        - Rejected: Online is not allowed.
        """
        return pulumi.get(self, "approval_status")

    @approval_status.setter
    def approval_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "approval_status", value)

    @_builtins.property
    @pulumi.getter(name="extraInfo")
    def extra_info(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Other information.
        """
        return pulumi.get(self, "extra_info")

    @extra_info.setter
    def extra_info(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "extra_info", value)

    @_builtins.property
    @pulumi.getter(name="formatType")
    def format_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The format of the model. Valid values:
        - OfflineModel
        - SavedModel
        - Keras H5
        - Frozen Pb
        - Caffe Prototxt
        - TorchScript
        - XGBoost
        - PMML
        - AlinkModel
        - ONNX
        """
        return pulumi.get(self, "format_type")

    @format_type.setter
    def format_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "format_type", value)

    @_builtins.property
    @pulumi.getter(name="frameworkType")
    def framework_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The framework of the model. Valid values:
        - Pytorch
        - XGBoost
        - Keras
        - Caffe
        - Alink
        - Xflow
        - TensorFlow
        """
        return pulumi.get(self, "framework_type")

    @framework_type.setter
    def framework_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "framework_type", value)

    @_builtins.property
    @pulumi.getter(name="inferenceSpec")
    def inference_spec(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Describes how to apply to downstream inference services.
        """
        return pulumi.get(self, "inference_spec")

    @inference_spec.setter
    def inference_spec(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "inference_spec", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceModelVersionLabelArgs']]]]:
        """
        List of model version labels. See `labels` below.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceModelVersionLabelArgs']]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def metrics(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The metrics for the model. The serialized length is limited to 8192.
        """
        return pulumi.get(self, "metrics")

    @metrics.setter
    def metrics(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "metrics", value)

    @_builtins.property
    @pulumi.getter
    def options(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The extended field. This is a JSON string.
        """
        return pulumi.get(self, "options")

    @options.setter
    def options(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "options", value)

    @_builtins.property
    @pulumi.getter(name="sourceId")
    def source_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The source ID.
        """
        return pulumi.get(self, "source_id")

    @source_id.setter
    def source_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_id", value)

    @_builtins.property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the model source. Valid values:
        - Custom: Custom.
        - PAIFlow:PAI workflow.
        - TrainingService:PAI training service.
        """
        return pulumi.get(self, "source_type")

    @source_type.setter
    def source_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_type", value)

    @_builtins.property
    @pulumi.getter(name="trainingSpec")
    def training_spec(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The training configurations. Used for fine-tuning and incremental training.
        """
        return pulumi.get(self, "training_spec")

    @training_spec.setter
    def training_spec(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "training_spec", value)

    @_builtins.property
    @pulumi.getter(name="versionDescription")
    def version_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The version descriptions.
        """
        return pulumi.get(self, "version_description")

    @version_description.setter
    def version_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version_description", value)

    @_builtins.property
    @pulumi.getter(name="versionName")
    def version_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Model version.
        """
        return pulumi.get(self, "version_name")

    @version_name.setter
    def version_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version_name", value)


@pulumi.input_type
class _WorkspaceModelVersionState:
    def __init__(__self__, *,
                 approval_status: Optional[pulumi.Input[_builtins.str]] = None,
                 extra_info: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 format_type: Optional[pulumi.Input[_builtins.str]] = None,
                 framework_type: Optional[pulumi.Input[_builtins.str]] = None,
                 inference_spec: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 labels: Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceModelVersionLabelArgs']]]] = None,
                 metrics: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 model_id: Optional[pulumi.Input[_builtins.str]] = None,
                 options: Optional[pulumi.Input[_builtins.str]] = None,
                 source_id: Optional[pulumi.Input[_builtins.str]] = None,
                 source_type: Optional[pulumi.Input[_builtins.str]] = None,
                 training_spec: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 uri: Optional[pulumi.Input[_builtins.str]] = None,
                 version_description: Optional[pulumi.Input[_builtins.str]] = None,
                 version_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering WorkspaceModelVersion resources.
        :param pulumi.Input[_builtins.str] approval_status: The approval status. Valid values:
               - Pending: To be determined.
               - Approved: Allow to go online.
               - Rejected: Online is not allowed.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] extra_info: Other information.
        :param pulumi.Input[_builtins.str] format_type: The format of the model. Valid values:
               - OfflineModel
               - SavedModel
               - Keras H5
               - Frozen Pb
               - Caffe Prototxt
               - TorchScript
               - XGBoost
               - PMML
               - AlinkModel
               - ONNX
        :param pulumi.Input[_builtins.str] framework_type: The framework of the model. Valid values:
               - Pytorch
               - XGBoost
               - Keras
               - Caffe
               - Alink
               - Xflow
               - TensorFlow
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] inference_spec: Describes how to apply to downstream inference services.
        :param pulumi.Input[Sequence[pulumi.Input['WorkspaceModelVersionLabelArgs']]] labels: List of model version labels. See `labels` below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] metrics: The metrics for the model. The serialized length is limited to 8192.
        :param pulumi.Input[_builtins.str] model_id: The model ID.
        :param pulumi.Input[_builtins.str] options: The extended field. This is a JSON string.
        :param pulumi.Input[_builtins.str] source_id: The source ID.
        :param pulumi.Input[_builtins.str] source_type: The type of the model source. Valid values:
               - Custom: Custom.
               - PAIFlow:PAI workflow.
               - TrainingService:PAI training service.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] training_spec: The training configurations. Used for fine-tuning and incremental training.
        :param pulumi.Input[_builtins.str] uri: The URI of the model version.
        :param pulumi.Input[_builtins.str] version_description: The version descriptions.
        :param pulumi.Input[_builtins.str] version_name: The Model version.
        """
        if approval_status is not None:
            pulumi.set(__self__, "approval_status", approval_status)
        if extra_info is not None:
            pulumi.set(__self__, "extra_info", extra_info)
        if format_type is not None:
            pulumi.set(__self__, "format_type", format_type)
        if framework_type is not None:
            pulumi.set(__self__, "framework_type", framework_type)
        if inference_spec is not None:
            pulumi.set(__self__, "inference_spec", inference_spec)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if metrics is not None:
            pulumi.set(__self__, "metrics", metrics)
        if model_id is not None:
            pulumi.set(__self__, "model_id", model_id)
        if options is not None:
            pulumi.set(__self__, "options", options)
        if source_id is not None:
            pulumi.set(__self__, "source_id", source_id)
        if source_type is not None:
            pulumi.set(__self__, "source_type", source_type)
        if training_spec is not None:
            pulumi.set(__self__, "training_spec", training_spec)
        if uri is not None:
            pulumi.set(__self__, "uri", uri)
        if version_description is not None:
            pulumi.set(__self__, "version_description", version_description)
        if version_name is not None:
            pulumi.set(__self__, "version_name", version_name)

    @_builtins.property
    @pulumi.getter(name="approvalStatus")
    def approval_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The approval status. Valid values:
        - Pending: To be determined.
        - Approved: Allow to go online.
        - Rejected: Online is not allowed.
        """
        return pulumi.get(self, "approval_status")

    @approval_status.setter
    def approval_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "approval_status", value)

    @_builtins.property
    @pulumi.getter(name="extraInfo")
    def extra_info(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Other information.
        """
        return pulumi.get(self, "extra_info")

    @extra_info.setter
    def extra_info(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "extra_info", value)

    @_builtins.property
    @pulumi.getter(name="formatType")
    def format_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The format of the model. Valid values:
        - OfflineModel
        - SavedModel
        - Keras H5
        - Frozen Pb
        - Caffe Prototxt
        - TorchScript
        - XGBoost
        - PMML
        - AlinkModel
        - ONNX
        """
        return pulumi.get(self, "format_type")

    @format_type.setter
    def format_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "format_type", value)

    @_builtins.property
    @pulumi.getter(name="frameworkType")
    def framework_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The framework of the model. Valid values:
        - Pytorch
        - XGBoost
        - Keras
        - Caffe
        - Alink
        - Xflow
        - TensorFlow
        """
        return pulumi.get(self, "framework_type")

    @framework_type.setter
    def framework_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "framework_type", value)

    @_builtins.property
    @pulumi.getter(name="inferenceSpec")
    def inference_spec(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Describes how to apply to downstream inference services.
        """
        return pulumi.get(self, "inference_spec")

    @inference_spec.setter
    def inference_spec(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "inference_spec", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceModelVersionLabelArgs']]]]:
        """
        List of model version labels. See `labels` below.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceModelVersionLabelArgs']]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def metrics(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The metrics for the model. The serialized length is limited to 8192.
        """
        return pulumi.get(self, "metrics")

    @metrics.setter
    def metrics(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "metrics", value)

    @_builtins.property
    @pulumi.getter(name="modelId")
    def model_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The model ID.
        """
        return pulumi.get(self, "model_id")

    @model_id.setter
    def model_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "model_id", value)

    @_builtins.property
    @pulumi.getter
    def options(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The extended field. This is a JSON string.
        """
        return pulumi.get(self, "options")

    @options.setter
    def options(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "options", value)

    @_builtins.property
    @pulumi.getter(name="sourceId")
    def source_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The source ID.
        """
        return pulumi.get(self, "source_id")

    @source_id.setter
    def source_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_id", value)

    @_builtins.property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the model source. Valid values:
        - Custom: Custom.
        - PAIFlow:PAI workflow.
        - TrainingService:PAI training service.
        """
        return pulumi.get(self, "source_type")

    @source_type.setter
    def source_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_type", value)

    @_builtins.property
    @pulumi.getter(name="trainingSpec")
    def training_spec(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The training configurations. Used for fine-tuning and incremental training.
        """
        return pulumi.get(self, "training_spec")

    @training_spec.setter
    def training_spec(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "training_spec", value)

    @_builtins.property
    @pulumi.getter
    def uri(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URI of the model version.
        """
        return pulumi.get(self, "uri")

    @uri.setter
    def uri(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "uri", value)

    @_builtins.property
    @pulumi.getter(name="versionDescription")
    def version_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The version descriptions.
        """
        return pulumi.get(self, "version_description")

    @version_description.setter
    def version_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version_description", value)

    @_builtins.property
    @pulumi.getter(name="versionName")
    def version_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Model version.
        """
        return pulumi.get(self, "version_name")

    @version_name.setter
    def version_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version_name", value)


@pulumi.type_token("alicloud:pai/workspaceModelVersion:WorkspaceModelVersion")
class WorkspaceModelVersion(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 approval_status: Optional[pulumi.Input[_builtins.str]] = None,
                 extra_info: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 format_type: Optional[pulumi.Input[_builtins.str]] = None,
                 framework_type: Optional[pulumi.Input[_builtins.str]] = None,
                 inference_spec: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 labels: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkspaceModelVersionLabelArgs', 'WorkspaceModelVersionLabelArgsDict']]]]] = None,
                 metrics: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 model_id: Optional[pulumi.Input[_builtins.str]] = None,
                 options: Optional[pulumi.Input[_builtins.str]] = None,
                 source_id: Optional[pulumi.Input[_builtins.str]] = None,
                 source_type: Optional[pulumi.Input[_builtins.str]] = None,
                 training_spec: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 uri: Optional[pulumi.Input[_builtins.str]] = None,
                 version_description: Optional[pulumi.Input[_builtins.str]] = None,
                 version_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a PAI Workspace Model Version resource.

        For information about PAI Workspace Model Version and how to use it, see [What is Model Version](https://next.api.alibabacloud.com/document/AIWorkSpace/2021-02-04/CreateModelVersion).

        > **NOTE:** Available since v1.248.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform_example"
        default = random.index.Integer("default",
            min=10000,
            max=99999)
        default_di9fs_l = alicloud.pai.WorkspaceWorkspace("defaultDI9fsL",
            description="802",
            display_name=name,
            workspace_name=f"{name}_{default['result']}",
            env_types=["prod"])
        defaults_hpt_el = alicloud.pai.WorkspaceModel("defaultsHptEL",
            model_name=name,
            workspace_id=default_di9fs_l.id,
            origin="Civitai",
            task="text-to-image-synthesis",
            accessibility="PRIVATE",
            model_type="Checkpoint",
            order_number=1,
            model_description="ModelDescription.",
            model_doc="https://eas-***.oss-cn-hangzhou.aliyuncs.com/s**.safetensors",
            domain="aigc",
            labels=[{
                "key": "base_model",
                "value": "SD 1.5",
            }],
            extra_info={
                "test": "15",
            })
        default_workspace_model_version = alicloud.pai.WorkspaceModelVersion("default",
            version_description="VersionDescription.",
            source_type="TrainingService",
            source_id="region=${region},workspaceId=${workspace_id},kind=TrainingJob,id=job-id",
            extra_info={
                "test": "15",
            },
            training_spec={
                "test": "TrainingSpec",
            },
            uri="oss://hz-example-0701.oss-cn-hangzhou-internal.aliyuncs.com/checkpoints/",
            inference_spec={
                "test": "InferenceSpec",
            },
            model_id=defaults_hpt_el.id,
            format_type="SavedModel",
            approval_status="Pending",
            framework_type="PyTorch",
            version_name="1.0.0",
            metrics={},
            labels=[{
                "key": "k1",
                "value": "vs1",
            }])
        ```

        ## Import

        PAI Workspace Model Version can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:pai/workspaceModelVersion:WorkspaceModelVersion example <model_id>:<version_name>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] approval_status: The approval status. Valid values:
               - Pending: To be determined.
               - Approved: Allow to go online.
               - Rejected: Online is not allowed.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] extra_info: Other information.
        :param pulumi.Input[_builtins.str] format_type: The format of the model. Valid values:
               - OfflineModel
               - SavedModel
               - Keras H5
               - Frozen Pb
               - Caffe Prototxt
               - TorchScript
               - XGBoost
               - PMML
               - AlinkModel
               - ONNX
        :param pulumi.Input[_builtins.str] framework_type: The framework of the model. Valid values:
               - Pytorch
               - XGBoost
               - Keras
               - Caffe
               - Alink
               - Xflow
               - TensorFlow
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] inference_spec: Describes how to apply to downstream inference services.
        :param pulumi.Input[Sequence[pulumi.Input[Union['WorkspaceModelVersionLabelArgs', 'WorkspaceModelVersionLabelArgsDict']]]] labels: List of model version labels. See `labels` below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] metrics: The metrics for the model. The serialized length is limited to 8192.
        :param pulumi.Input[_builtins.str] model_id: The model ID.
        :param pulumi.Input[_builtins.str] options: The extended field. This is a JSON string.
        :param pulumi.Input[_builtins.str] source_id: The source ID.
        :param pulumi.Input[_builtins.str] source_type: The type of the model source. Valid values:
               - Custom: Custom.
               - PAIFlow:PAI workflow.
               - TrainingService:PAI training service.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] training_spec: The training configurations. Used for fine-tuning and incremental training.
        :param pulumi.Input[_builtins.str] uri: The URI of the model version.
        :param pulumi.Input[_builtins.str] version_description: The version descriptions.
        :param pulumi.Input[_builtins.str] version_name: The Model version.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WorkspaceModelVersionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a PAI Workspace Model Version resource.

        For information about PAI Workspace Model Version and how to use it, see [What is Model Version](https://next.api.alibabacloud.com/document/AIWorkSpace/2021-02-04/CreateModelVersion).

        > **NOTE:** Available since v1.248.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform_example"
        default = random.index.Integer("default",
            min=10000,
            max=99999)
        default_di9fs_l = alicloud.pai.WorkspaceWorkspace("defaultDI9fsL",
            description="802",
            display_name=name,
            workspace_name=f"{name}_{default['result']}",
            env_types=["prod"])
        defaults_hpt_el = alicloud.pai.WorkspaceModel("defaultsHptEL",
            model_name=name,
            workspace_id=default_di9fs_l.id,
            origin="Civitai",
            task="text-to-image-synthesis",
            accessibility="PRIVATE",
            model_type="Checkpoint",
            order_number=1,
            model_description="ModelDescription.",
            model_doc="https://eas-***.oss-cn-hangzhou.aliyuncs.com/s**.safetensors",
            domain="aigc",
            labels=[{
                "key": "base_model",
                "value": "SD 1.5",
            }],
            extra_info={
                "test": "15",
            })
        default_workspace_model_version = alicloud.pai.WorkspaceModelVersion("default",
            version_description="VersionDescription.",
            source_type="TrainingService",
            source_id="region=${region},workspaceId=${workspace_id},kind=TrainingJob,id=job-id",
            extra_info={
                "test": "15",
            },
            training_spec={
                "test": "TrainingSpec",
            },
            uri="oss://hz-example-0701.oss-cn-hangzhou-internal.aliyuncs.com/checkpoints/",
            inference_spec={
                "test": "InferenceSpec",
            },
            model_id=defaults_hpt_el.id,
            format_type="SavedModel",
            approval_status="Pending",
            framework_type="PyTorch",
            version_name="1.0.0",
            metrics={},
            labels=[{
                "key": "k1",
                "value": "vs1",
            }])
        ```

        ## Import

        PAI Workspace Model Version can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:pai/workspaceModelVersion:WorkspaceModelVersion example <model_id>:<version_name>
        ```

        :param str resource_name: The name of the resource.
        :param WorkspaceModelVersionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WorkspaceModelVersionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 approval_status: Optional[pulumi.Input[_builtins.str]] = None,
                 extra_info: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 format_type: Optional[pulumi.Input[_builtins.str]] = None,
                 framework_type: Optional[pulumi.Input[_builtins.str]] = None,
                 inference_spec: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 labels: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkspaceModelVersionLabelArgs', 'WorkspaceModelVersionLabelArgsDict']]]]] = None,
                 metrics: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 model_id: Optional[pulumi.Input[_builtins.str]] = None,
                 options: Optional[pulumi.Input[_builtins.str]] = None,
                 source_id: Optional[pulumi.Input[_builtins.str]] = None,
                 source_type: Optional[pulumi.Input[_builtins.str]] = None,
                 training_spec: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 uri: Optional[pulumi.Input[_builtins.str]] = None,
                 version_description: Optional[pulumi.Input[_builtins.str]] = None,
                 version_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WorkspaceModelVersionArgs.__new__(WorkspaceModelVersionArgs)

            __props__.__dict__["approval_status"] = approval_status
            __props__.__dict__["extra_info"] = extra_info
            __props__.__dict__["format_type"] = format_type
            __props__.__dict__["framework_type"] = framework_type
            __props__.__dict__["inference_spec"] = inference_spec
            __props__.__dict__["labels"] = labels
            __props__.__dict__["metrics"] = metrics
            if model_id is None and not opts.urn:
                raise TypeError("Missing required property 'model_id'")
            __props__.__dict__["model_id"] = model_id
            __props__.__dict__["options"] = options
            __props__.__dict__["source_id"] = source_id
            __props__.__dict__["source_type"] = source_type
            __props__.__dict__["training_spec"] = training_spec
            if uri is None and not opts.urn:
                raise TypeError("Missing required property 'uri'")
            __props__.__dict__["uri"] = uri
            __props__.__dict__["version_description"] = version_description
            __props__.__dict__["version_name"] = version_name
        super(WorkspaceModelVersion, __self__).__init__(
            'alicloud:pai/workspaceModelVersion:WorkspaceModelVersion',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            approval_status: Optional[pulumi.Input[_builtins.str]] = None,
            extra_info: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            format_type: Optional[pulumi.Input[_builtins.str]] = None,
            framework_type: Optional[pulumi.Input[_builtins.str]] = None,
            inference_spec: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            labels: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkspaceModelVersionLabelArgs', 'WorkspaceModelVersionLabelArgsDict']]]]] = None,
            metrics: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            model_id: Optional[pulumi.Input[_builtins.str]] = None,
            options: Optional[pulumi.Input[_builtins.str]] = None,
            source_id: Optional[pulumi.Input[_builtins.str]] = None,
            source_type: Optional[pulumi.Input[_builtins.str]] = None,
            training_spec: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            uri: Optional[pulumi.Input[_builtins.str]] = None,
            version_description: Optional[pulumi.Input[_builtins.str]] = None,
            version_name: Optional[pulumi.Input[_builtins.str]] = None) -> 'WorkspaceModelVersion':
        """
        Get an existing WorkspaceModelVersion resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] approval_status: The approval status. Valid values:
               - Pending: To be determined.
               - Approved: Allow to go online.
               - Rejected: Online is not allowed.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] extra_info: Other information.
        :param pulumi.Input[_builtins.str] format_type: The format of the model. Valid values:
               - OfflineModel
               - SavedModel
               - Keras H5
               - Frozen Pb
               - Caffe Prototxt
               - TorchScript
               - XGBoost
               - PMML
               - AlinkModel
               - ONNX
        :param pulumi.Input[_builtins.str] framework_type: The framework of the model. Valid values:
               - Pytorch
               - XGBoost
               - Keras
               - Caffe
               - Alink
               - Xflow
               - TensorFlow
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] inference_spec: Describes how to apply to downstream inference services.
        :param pulumi.Input[Sequence[pulumi.Input[Union['WorkspaceModelVersionLabelArgs', 'WorkspaceModelVersionLabelArgsDict']]]] labels: List of model version labels. See `labels` below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] metrics: The metrics for the model. The serialized length is limited to 8192.
        :param pulumi.Input[_builtins.str] model_id: The model ID.
        :param pulumi.Input[_builtins.str] options: The extended field. This is a JSON string.
        :param pulumi.Input[_builtins.str] source_id: The source ID.
        :param pulumi.Input[_builtins.str] source_type: The type of the model source. Valid values:
               - Custom: Custom.
               - PAIFlow:PAI workflow.
               - TrainingService:PAI training service.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] training_spec: The training configurations. Used for fine-tuning and incremental training.
        :param pulumi.Input[_builtins.str] uri: The URI of the model version.
        :param pulumi.Input[_builtins.str] version_description: The version descriptions.
        :param pulumi.Input[_builtins.str] version_name: The Model version.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _WorkspaceModelVersionState.__new__(_WorkspaceModelVersionState)

        __props__.__dict__["approval_status"] = approval_status
        __props__.__dict__["extra_info"] = extra_info
        __props__.__dict__["format_type"] = format_type
        __props__.__dict__["framework_type"] = framework_type
        __props__.__dict__["inference_spec"] = inference_spec
        __props__.__dict__["labels"] = labels
        __props__.__dict__["metrics"] = metrics
        __props__.__dict__["model_id"] = model_id
        __props__.__dict__["options"] = options
        __props__.__dict__["source_id"] = source_id
        __props__.__dict__["source_type"] = source_type
        __props__.__dict__["training_spec"] = training_spec
        __props__.__dict__["uri"] = uri
        __props__.__dict__["version_description"] = version_description
        __props__.__dict__["version_name"] = version_name
        return WorkspaceModelVersion(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="approvalStatus")
    def approval_status(self) -> pulumi.Output[_builtins.str]:
        """
        The approval status. Valid values:
        - Pending: To be determined.
        - Approved: Allow to go online.
        - Rejected: Online is not allowed.
        """
        return pulumi.get(self, "approval_status")

    @_builtins.property
    @pulumi.getter(name="extraInfo")
    def extra_info(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Other information.
        """
        return pulumi.get(self, "extra_info")

    @_builtins.property
    @pulumi.getter(name="formatType")
    def format_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The format of the model. Valid values:
        - OfflineModel
        - SavedModel
        - Keras H5
        - Frozen Pb
        - Caffe Prototxt
        - TorchScript
        - XGBoost
        - PMML
        - AlinkModel
        - ONNX
        """
        return pulumi.get(self, "format_type")

    @_builtins.property
    @pulumi.getter(name="frameworkType")
    def framework_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The framework of the model. Valid values:
        - Pytorch
        - XGBoost
        - Keras
        - Caffe
        - Alink
        - Xflow
        - TensorFlow
        """
        return pulumi.get(self, "framework_type")

    @_builtins.property
    @pulumi.getter(name="inferenceSpec")
    def inference_spec(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Describes how to apply to downstream inference services.
        """
        return pulumi.get(self, "inference_spec")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Sequence['outputs.WorkspaceModelVersionLabel']]]:
        """
        List of model version labels. See `labels` below.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def metrics(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        The metrics for the model. The serialized length is limited to 8192.
        """
        return pulumi.get(self, "metrics")

    @_builtins.property
    @pulumi.getter(name="modelId")
    def model_id(self) -> pulumi.Output[_builtins.str]:
        """
        The model ID.
        """
        return pulumi.get(self, "model_id")

    @_builtins.property
    @pulumi.getter
    def options(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The extended field. This is a JSON string.
        """
        return pulumi.get(self, "options")

    @_builtins.property
    @pulumi.getter(name="sourceId")
    def source_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The source ID.
        """
        return pulumi.get(self, "source_id")

    @_builtins.property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of the model source. Valid values:
        - Custom: Custom.
        - PAIFlow:PAI workflow.
        - TrainingService:PAI training service.
        """
        return pulumi.get(self, "source_type")

    @_builtins.property
    @pulumi.getter(name="trainingSpec")
    def training_spec(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        The training configurations. Used for fine-tuning and incremental training.
        """
        return pulumi.get(self, "training_spec")

    @_builtins.property
    @pulumi.getter
    def uri(self) -> pulumi.Output[_builtins.str]:
        """
        The URI of the model version.
        """
        return pulumi.get(self, "uri")

    @_builtins.property
    @pulumi.getter(name="versionDescription")
    def version_description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The version descriptions.
        """
        return pulumi.get(self, "version_description")

    @_builtins.property
    @pulumi.getter(name="versionName")
    def version_name(self) -> pulumi.Output[_builtins.str]:
        """
        The Model version.
        """
        return pulumi.get(self, "version_name")

