# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['BackupPolicyArgs', 'BackupPolicy']

@pulumi.input_type
class BackupPolicyArgs:
    def __init__(__self__, *,
                 db_cluster_id: pulumi.Input[_builtins.str],
                 backup_frequency: Optional[pulumi.Input[_builtins.str]] = None,
                 backup_retention_period: Optional[pulumi.Input[_builtins.str]] = None,
                 backup_retention_policy_on_cluster_deletion: Optional[pulumi.Input[_builtins.str]] = None,
                 data_level1_backup_frequency: Optional[pulumi.Input[_builtins.str]] = None,
                 data_level1_backup_periods: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 data_level1_backup_retention_period: Optional[pulumi.Input[_builtins.int]] = None,
                 data_level1_backup_time: Optional[pulumi.Input[_builtins.str]] = None,
                 data_level2_backup_another_region_region: Optional[pulumi.Input[_builtins.str]] = None,
                 data_level2_backup_another_region_retention_period: Optional[pulumi.Input[_builtins.int]] = None,
                 data_level2_backup_periods: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 data_level2_backup_retention_period: Optional[pulumi.Input[_builtins.int]] = None,
                 log_backup_another_region_region: Optional[pulumi.Input[_builtins.str]] = None,
                 log_backup_another_region_retention_period: Optional[pulumi.Input[_builtins.int]] = None,
                 log_backup_retention_period: Optional[pulumi.Input[_builtins.int]] = None,
                 preferred_backup_periods: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 preferred_backup_time: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a BackupPolicy resource.
        :param pulumi.Input[_builtins.str] db_cluster_id: The Id of cluster that can run database.
        :param pulumi.Input[_builtins.str] backup_frequency: The backup frequency. Valid values are `Normal`, `2/24H`, `3/24H`, `4/24H`.Default to `Normal`.
        :param pulumi.Input[_builtins.str] backup_retention_period: Cluster backup retention days, Fixed for 7 days, not modified.
        :param pulumi.Input[_builtins.str] backup_retention_policy_on_cluster_deletion: Specifies whether to retain backups when you delete a cluster. Valid values are `ALL`, `LATEST`, `NONE`. Default to `NONE`. Value options can refer to the latest docs [ModifyBackupPolicy](https://www.alibabacloud.com/help/en/polardb/latest/modifybackuppolicy)
        :param pulumi.Input[_builtins.str] data_level1_backup_frequency: The Id of cluster that can run database.The backup frequency. Valid values are `Normal`, `2/24H`, `3/24H`, `4/24H`.Default to `Normal`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] data_level1_backup_periods: PolarDB Cluster of level-1 backup period. Valid values: ["Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", "Sunday"].
               > **NOTE:** Note Select at least two values. Separate multiple values with commas (,).
        :param pulumi.Input[_builtins.int] data_level1_backup_retention_period: The retention period of level-1 backups. Valid values: 3 to 14. Unit: days.
        :param pulumi.Input[_builtins.str] data_level1_backup_time: The time period during which automatic backup is performed. The format is HH: MMZ HH: MMZ (UTC time), and the entered value must be an hour apart, such as 14:00z-15:00z.
        :param pulumi.Input[_builtins.str] data_level2_backup_another_region_region: PolarDB Cluster of level-2 backup is a cross regional backup area.
        :param pulumi.Input[_builtins.int] data_level2_backup_another_region_retention_period: PolarDB Cluster of level-2 backup cross region backup retention period. Valid values are `0`, `30 to 7300`, `-1`. Default to `0`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] data_level2_backup_periods: PolarDB Cluster of level-2 backup period. Valid values: ["Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", "Sunday"].
               > **NOTE:** Note Select at least two values. Separate multiple values with commas (,).
        :param pulumi.Input[_builtins.int] data_level2_backup_retention_period: The retention period of level-2 backups. Valid values are `0`, `30 to 7300`, `-1`. Default to `0`.
        :param pulumi.Input[_builtins.str] log_backup_another_region_region: The region in which you want to store cross-region log backups. For information about regions that support the cross-region backup feature, see [Overview.](https://www.alibabacloud.com/help/en/polardb/latest/backup-and-restoration-overview)
        :param pulumi.Input[_builtins.int] log_backup_another_region_retention_period: The retention period of cross-region log backups. Default value: OFF. Valid values are `0`, `30 to 7300`, `-1`.
               > **NOTE:** Note When you create a cluster, the default value of this parameter is 0.
        :param pulumi.Input[_builtins.int] log_backup_retention_period: The retention period of the log backups. Valid values are `3 to 7300`, `-1`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] preferred_backup_periods: PolarDB Cluster backup period. Valid values: ["Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", "Sunday"]. Default to ["Tuesday", "Thursday", "Saturday"].
        :param pulumi.Input[_builtins.str] preferred_backup_time: PolarDB Cluster backup time, in the format of HH:mmZ- HH:mmZ. Time setting interval is one hour. Default to "02:00Z-03:00Z". China time is 8 hours behind it.
        """
        pulumi.set(__self__, "db_cluster_id", db_cluster_id)
        if backup_frequency is not None:
            pulumi.set(__self__, "backup_frequency", backup_frequency)
        if backup_retention_period is not None:
            pulumi.set(__self__, "backup_retention_period", backup_retention_period)
        if backup_retention_policy_on_cluster_deletion is not None:
            pulumi.set(__self__, "backup_retention_policy_on_cluster_deletion", backup_retention_policy_on_cluster_deletion)
        if data_level1_backup_frequency is not None:
            pulumi.set(__self__, "data_level1_backup_frequency", data_level1_backup_frequency)
        if data_level1_backup_periods is not None:
            pulumi.set(__self__, "data_level1_backup_periods", data_level1_backup_periods)
        if data_level1_backup_retention_period is not None:
            pulumi.set(__self__, "data_level1_backup_retention_period", data_level1_backup_retention_period)
        if data_level1_backup_time is not None:
            pulumi.set(__self__, "data_level1_backup_time", data_level1_backup_time)
        if data_level2_backup_another_region_region is not None:
            pulumi.set(__self__, "data_level2_backup_another_region_region", data_level2_backup_another_region_region)
        if data_level2_backup_another_region_retention_period is not None:
            pulumi.set(__self__, "data_level2_backup_another_region_retention_period", data_level2_backup_another_region_retention_period)
        if data_level2_backup_periods is not None:
            pulumi.set(__self__, "data_level2_backup_periods", data_level2_backup_periods)
        if data_level2_backup_retention_period is not None:
            pulumi.set(__self__, "data_level2_backup_retention_period", data_level2_backup_retention_period)
        if log_backup_another_region_region is not None:
            pulumi.set(__self__, "log_backup_another_region_region", log_backup_another_region_region)
        if log_backup_another_region_retention_period is not None:
            pulumi.set(__self__, "log_backup_another_region_retention_period", log_backup_another_region_retention_period)
        if log_backup_retention_period is not None:
            pulumi.set(__self__, "log_backup_retention_period", log_backup_retention_period)
        if preferred_backup_periods is not None:
            pulumi.set(__self__, "preferred_backup_periods", preferred_backup_periods)
        if preferred_backup_time is not None:
            pulumi.set(__self__, "preferred_backup_time", preferred_backup_time)

    @_builtins.property
    @pulumi.getter(name="dbClusterId")
    def db_cluster_id(self) -> pulumi.Input[_builtins.str]:
        """
        The Id of cluster that can run database.
        """
        return pulumi.get(self, "db_cluster_id")

    @db_cluster_id.setter
    def db_cluster_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "db_cluster_id", value)

    @_builtins.property
    @pulumi.getter(name="backupFrequency")
    def backup_frequency(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The backup frequency. Valid values are `Normal`, `2/24H`, `3/24H`, `4/24H`.Default to `Normal`.
        """
        return pulumi.get(self, "backup_frequency")

    @backup_frequency.setter
    def backup_frequency(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backup_frequency", value)

    @_builtins.property
    @pulumi.getter(name="backupRetentionPeriod")
    def backup_retention_period(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Cluster backup retention days, Fixed for 7 days, not modified.
        """
        return pulumi.get(self, "backup_retention_period")

    @backup_retention_period.setter
    def backup_retention_period(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backup_retention_period", value)

    @_builtins.property
    @pulumi.getter(name="backupRetentionPolicyOnClusterDeletion")
    def backup_retention_policy_on_cluster_deletion(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether to retain backups when you delete a cluster. Valid values are `ALL`, `LATEST`, `NONE`. Default to `NONE`. Value options can refer to the latest docs [ModifyBackupPolicy](https://www.alibabacloud.com/help/en/polardb/latest/modifybackuppolicy)
        """
        return pulumi.get(self, "backup_retention_policy_on_cluster_deletion")

    @backup_retention_policy_on_cluster_deletion.setter
    def backup_retention_policy_on_cluster_deletion(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backup_retention_policy_on_cluster_deletion", value)

    @_builtins.property
    @pulumi.getter(name="dataLevel1BackupFrequency")
    def data_level1_backup_frequency(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Id of cluster that can run database.The backup frequency. Valid values are `Normal`, `2/24H`, `3/24H`, `4/24H`.Default to `Normal`.
        """
        return pulumi.get(self, "data_level1_backup_frequency")

    @data_level1_backup_frequency.setter
    def data_level1_backup_frequency(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "data_level1_backup_frequency", value)

    @_builtins.property
    @pulumi.getter(name="dataLevel1BackupPeriods")
    def data_level1_backup_periods(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        PolarDB Cluster of level-1 backup period. Valid values: ["Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", "Sunday"].
        > **NOTE:** Note Select at least two values. Separate multiple values with commas (,).
        """
        return pulumi.get(self, "data_level1_backup_periods")

    @data_level1_backup_periods.setter
    def data_level1_backup_periods(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "data_level1_backup_periods", value)

    @_builtins.property
    @pulumi.getter(name="dataLevel1BackupRetentionPeriod")
    def data_level1_backup_retention_period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The retention period of level-1 backups. Valid values: 3 to 14. Unit: days.
        """
        return pulumi.get(self, "data_level1_backup_retention_period")

    @data_level1_backup_retention_period.setter
    def data_level1_backup_retention_period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "data_level1_backup_retention_period", value)

    @_builtins.property
    @pulumi.getter(name="dataLevel1BackupTime")
    def data_level1_backup_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time period during which automatic backup is performed. The format is HH: MMZ HH: MMZ (UTC time), and the entered value must be an hour apart, such as 14:00z-15:00z.
        """
        return pulumi.get(self, "data_level1_backup_time")

    @data_level1_backup_time.setter
    def data_level1_backup_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "data_level1_backup_time", value)

    @_builtins.property
    @pulumi.getter(name="dataLevel2BackupAnotherRegionRegion")
    def data_level2_backup_another_region_region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        PolarDB Cluster of level-2 backup is a cross regional backup area.
        """
        return pulumi.get(self, "data_level2_backup_another_region_region")

    @data_level2_backup_another_region_region.setter
    def data_level2_backup_another_region_region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "data_level2_backup_another_region_region", value)

    @_builtins.property
    @pulumi.getter(name="dataLevel2BackupAnotherRegionRetentionPeriod")
    def data_level2_backup_another_region_retention_period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        PolarDB Cluster of level-2 backup cross region backup retention period. Valid values are `0`, `30 to 7300`, `-1`. Default to `0`.
        """
        return pulumi.get(self, "data_level2_backup_another_region_retention_period")

    @data_level2_backup_another_region_retention_period.setter
    def data_level2_backup_another_region_retention_period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "data_level2_backup_another_region_retention_period", value)

    @_builtins.property
    @pulumi.getter(name="dataLevel2BackupPeriods")
    def data_level2_backup_periods(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        PolarDB Cluster of level-2 backup period. Valid values: ["Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", "Sunday"].
        > **NOTE:** Note Select at least two values. Separate multiple values with commas (,).
        """
        return pulumi.get(self, "data_level2_backup_periods")

    @data_level2_backup_periods.setter
    def data_level2_backup_periods(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "data_level2_backup_periods", value)

    @_builtins.property
    @pulumi.getter(name="dataLevel2BackupRetentionPeriod")
    def data_level2_backup_retention_period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The retention period of level-2 backups. Valid values are `0`, `30 to 7300`, `-1`. Default to `0`.
        """
        return pulumi.get(self, "data_level2_backup_retention_period")

    @data_level2_backup_retention_period.setter
    def data_level2_backup_retention_period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "data_level2_backup_retention_period", value)

    @_builtins.property
    @pulumi.getter(name="logBackupAnotherRegionRegion")
    def log_backup_another_region_region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which you want to store cross-region log backups. For information about regions that support the cross-region backup feature, see [Overview.](https://www.alibabacloud.com/help/en/polardb/latest/backup-and-restoration-overview)
        """
        return pulumi.get(self, "log_backup_another_region_region")

    @log_backup_another_region_region.setter
    def log_backup_another_region_region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "log_backup_another_region_region", value)

    @_builtins.property
    @pulumi.getter(name="logBackupAnotherRegionRetentionPeriod")
    def log_backup_another_region_retention_period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The retention period of cross-region log backups. Default value: OFF. Valid values are `0`, `30 to 7300`, `-1`.
        > **NOTE:** Note When you create a cluster, the default value of this parameter is 0.
        """
        return pulumi.get(self, "log_backup_another_region_retention_period")

    @log_backup_another_region_retention_period.setter
    def log_backup_another_region_retention_period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "log_backup_another_region_retention_period", value)

    @_builtins.property
    @pulumi.getter(name="logBackupRetentionPeriod")
    def log_backup_retention_period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The retention period of the log backups. Valid values are `3 to 7300`, `-1`.
        """
        return pulumi.get(self, "log_backup_retention_period")

    @log_backup_retention_period.setter
    def log_backup_retention_period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "log_backup_retention_period", value)

    @_builtins.property
    @pulumi.getter(name="preferredBackupPeriods")
    def preferred_backup_periods(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        PolarDB Cluster backup period. Valid values: ["Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", "Sunday"]. Default to ["Tuesday", "Thursday", "Saturday"].
        """
        return pulumi.get(self, "preferred_backup_periods")

    @preferred_backup_periods.setter
    def preferred_backup_periods(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "preferred_backup_periods", value)

    @_builtins.property
    @pulumi.getter(name="preferredBackupTime")
    def preferred_backup_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        PolarDB Cluster backup time, in the format of HH:mmZ- HH:mmZ. Time setting interval is one hour. Default to "02:00Z-03:00Z". China time is 8 hours behind it.
        """
        return pulumi.get(self, "preferred_backup_time")

    @preferred_backup_time.setter
    def preferred_backup_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "preferred_backup_time", value)


@pulumi.input_type
class _BackupPolicyState:
    def __init__(__self__, *,
                 backup_frequency: Optional[pulumi.Input[_builtins.str]] = None,
                 backup_retention_period: Optional[pulumi.Input[_builtins.str]] = None,
                 backup_retention_policy_on_cluster_deletion: Optional[pulumi.Input[_builtins.str]] = None,
                 data_level1_backup_frequency: Optional[pulumi.Input[_builtins.str]] = None,
                 data_level1_backup_periods: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 data_level1_backup_retention_period: Optional[pulumi.Input[_builtins.int]] = None,
                 data_level1_backup_time: Optional[pulumi.Input[_builtins.str]] = None,
                 data_level2_backup_another_region_region: Optional[pulumi.Input[_builtins.str]] = None,
                 data_level2_backup_another_region_retention_period: Optional[pulumi.Input[_builtins.int]] = None,
                 data_level2_backup_periods: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 data_level2_backup_retention_period: Optional[pulumi.Input[_builtins.int]] = None,
                 db_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_backup_log: Optional[pulumi.Input[_builtins.int]] = None,
                 log_backup_another_region_region: Optional[pulumi.Input[_builtins.str]] = None,
                 log_backup_another_region_retention_period: Optional[pulumi.Input[_builtins.int]] = None,
                 log_backup_retention_period: Optional[pulumi.Input[_builtins.int]] = None,
                 preferred_backup_periods: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 preferred_backup_time: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering BackupPolicy resources.
        :param pulumi.Input[_builtins.str] backup_frequency: The backup frequency. Valid values are `Normal`, `2/24H`, `3/24H`, `4/24H`.Default to `Normal`.
        :param pulumi.Input[_builtins.str] backup_retention_period: Cluster backup retention days, Fixed for 7 days, not modified.
        :param pulumi.Input[_builtins.str] backup_retention_policy_on_cluster_deletion: Specifies whether to retain backups when you delete a cluster. Valid values are `ALL`, `LATEST`, `NONE`. Default to `NONE`. Value options can refer to the latest docs [ModifyBackupPolicy](https://www.alibabacloud.com/help/en/polardb/latest/modifybackuppolicy)
        :param pulumi.Input[_builtins.str] data_level1_backup_frequency: The Id of cluster that can run database.The backup frequency. Valid values are `Normal`, `2/24H`, `3/24H`, `4/24H`.Default to `Normal`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] data_level1_backup_periods: PolarDB Cluster of level-1 backup period. Valid values: ["Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", "Sunday"].
               > **NOTE:** Note Select at least two values. Separate multiple values with commas (,).
        :param pulumi.Input[_builtins.int] data_level1_backup_retention_period: The retention period of level-1 backups. Valid values: 3 to 14. Unit: days.
        :param pulumi.Input[_builtins.str] data_level1_backup_time: The time period during which automatic backup is performed. The format is HH: MMZ HH: MMZ (UTC time), and the entered value must be an hour apart, such as 14:00z-15:00z.
        :param pulumi.Input[_builtins.str] data_level2_backup_another_region_region: PolarDB Cluster of level-2 backup is a cross regional backup area.
        :param pulumi.Input[_builtins.int] data_level2_backup_another_region_retention_period: PolarDB Cluster of level-2 backup cross region backup retention period. Valid values are `0`, `30 to 7300`, `-1`. Default to `0`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] data_level2_backup_periods: PolarDB Cluster of level-2 backup period. Valid values: ["Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", "Sunday"].
               > **NOTE:** Note Select at least two values. Separate multiple values with commas (,).
        :param pulumi.Input[_builtins.int] data_level2_backup_retention_period: The retention period of level-2 backups. Valid values are `0`, `30 to 7300`, `-1`. Default to `0`.
        :param pulumi.Input[_builtins.str] db_cluster_id: The Id of cluster that can run database.
        :param pulumi.Input[_builtins.int] enable_backup_log: Indicates whether the log backup feature was enabled. Valid values are `0`, `1`. `1` By default, the log backup feature is enabled and cannot be disabled.
        :param pulumi.Input[_builtins.str] log_backup_another_region_region: The region in which you want to store cross-region log backups. For information about regions that support the cross-region backup feature, see [Overview.](https://www.alibabacloud.com/help/en/polardb/latest/backup-and-restoration-overview)
        :param pulumi.Input[_builtins.int] log_backup_another_region_retention_period: The retention period of cross-region log backups. Default value: OFF. Valid values are `0`, `30 to 7300`, `-1`.
               > **NOTE:** Note When you create a cluster, the default value of this parameter is 0.
        :param pulumi.Input[_builtins.int] log_backup_retention_period: The retention period of the log backups. Valid values are `3 to 7300`, `-1`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] preferred_backup_periods: PolarDB Cluster backup period. Valid values: ["Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", "Sunday"]. Default to ["Tuesday", "Thursday", "Saturday"].
        :param pulumi.Input[_builtins.str] preferred_backup_time: PolarDB Cluster backup time, in the format of HH:mmZ- HH:mmZ. Time setting interval is one hour. Default to "02:00Z-03:00Z". China time is 8 hours behind it.
        """
        if backup_frequency is not None:
            pulumi.set(__self__, "backup_frequency", backup_frequency)
        if backup_retention_period is not None:
            pulumi.set(__self__, "backup_retention_period", backup_retention_period)
        if backup_retention_policy_on_cluster_deletion is not None:
            pulumi.set(__self__, "backup_retention_policy_on_cluster_deletion", backup_retention_policy_on_cluster_deletion)
        if data_level1_backup_frequency is not None:
            pulumi.set(__self__, "data_level1_backup_frequency", data_level1_backup_frequency)
        if data_level1_backup_periods is not None:
            pulumi.set(__self__, "data_level1_backup_periods", data_level1_backup_periods)
        if data_level1_backup_retention_period is not None:
            pulumi.set(__self__, "data_level1_backup_retention_period", data_level1_backup_retention_period)
        if data_level1_backup_time is not None:
            pulumi.set(__self__, "data_level1_backup_time", data_level1_backup_time)
        if data_level2_backup_another_region_region is not None:
            pulumi.set(__self__, "data_level2_backup_another_region_region", data_level2_backup_another_region_region)
        if data_level2_backup_another_region_retention_period is not None:
            pulumi.set(__self__, "data_level2_backup_another_region_retention_period", data_level2_backup_another_region_retention_period)
        if data_level2_backup_periods is not None:
            pulumi.set(__self__, "data_level2_backup_periods", data_level2_backup_periods)
        if data_level2_backup_retention_period is not None:
            pulumi.set(__self__, "data_level2_backup_retention_period", data_level2_backup_retention_period)
        if db_cluster_id is not None:
            pulumi.set(__self__, "db_cluster_id", db_cluster_id)
        if enable_backup_log is not None:
            pulumi.set(__self__, "enable_backup_log", enable_backup_log)
        if log_backup_another_region_region is not None:
            pulumi.set(__self__, "log_backup_another_region_region", log_backup_another_region_region)
        if log_backup_another_region_retention_period is not None:
            pulumi.set(__self__, "log_backup_another_region_retention_period", log_backup_another_region_retention_period)
        if log_backup_retention_period is not None:
            pulumi.set(__self__, "log_backup_retention_period", log_backup_retention_period)
        if preferred_backup_periods is not None:
            pulumi.set(__self__, "preferred_backup_periods", preferred_backup_periods)
        if preferred_backup_time is not None:
            pulumi.set(__self__, "preferred_backup_time", preferred_backup_time)

    @_builtins.property
    @pulumi.getter(name="backupFrequency")
    def backup_frequency(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The backup frequency. Valid values are `Normal`, `2/24H`, `3/24H`, `4/24H`.Default to `Normal`.
        """
        return pulumi.get(self, "backup_frequency")

    @backup_frequency.setter
    def backup_frequency(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backup_frequency", value)

    @_builtins.property
    @pulumi.getter(name="backupRetentionPeriod")
    def backup_retention_period(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Cluster backup retention days, Fixed for 7 days, not modified.
        """
        return pulumi.get(self, "backup_retention_period")

    @backup_retention_period.setter
    def backup_retention_period(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backup_retention_period", value)

    @_builtins.property
    @pulumi.getter(name="backupRetentionPolicyOnClusterDeletion")
    def backup_retention_policy_on_cluster_deletion(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether to retain backups when you delete a cluster. Valid values are `ALL`, `LATEST`, `NONE`. Default to `NONE`. Value options can refer to the latest docs [ModifyBackupPolicy](https://www.alibabacloud.com/help/en/polardb/latest/modifybackuppolicy)
        """
        return pulumi.get(self, "backup_retention_policy_on_cluster_deletion")

    @backup_retention_policy_on_cluster_deletion.setter
    def backup_retention_policy_on_cluster_deletion(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backup_retention_policy_on_cluster_deletion", value)

    @_builtins.property
    @pulumi.getter(name="dataLevel1BackupFrequency")
    def data_level1_backup_frequency(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Id of cluster that can run database.The backup frequency. Valid values are `Normal`, `2/24H`, `3/24H`, `4/24H`.Default to `Normal`.
        """
        return pulumi.get(self, "data_level1_backup_frequency")

    @data_level1_backup_frequency.setter
    def data_level1_backup_frequency(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "data_level1_backup_frequency", value)

    @_builtins.property
    @pulumi.getter(name="dataLevel1BackupPeriods")
    def data_level1_backup_periods(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        PolarDB Cluster of level-1 backup period. Valid values: ["Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", "Sunday"].
        > **NOTE:** Note Select at least two values. Separate multiple values with commas (,).
        """
        return pulumi.get(self, "data_level1_backup_periods")

    @data_level1_backup_periods.setter
    def data_level1_backup_periods(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "data_level1_backup_periods", value)

    @_builtins.property
    @pulumi.getter(name="dataLevel1BackupRetentionPeriod")
    def data_level1_backup_retention_period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The retention period of level-1 backups. Valid values: 3 to 14. Unit: days.
        """
        return pulumi.get(self, "data_level1_backup_retention_period")

    @data_level1_backup_retention_period.setter
    def data_level1_backup_retention_period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "data_level1_backup_retention_period", value)

    @_builtins.property
    @pulumi.getter(name="dataLevel1BackupTime")
    def data_level1_backup_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time period during which automatic backup is performed. The format is HH: MMZ HH: MMZ (UTC time), and the entered value must be an hour apart, such as 14:00z-15:00z.
        """
        return pulumi.get(self, "data_level1_backup_time")

    @data_level1_backup_time.setter
    def data_level1_backup_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "data_level1_backup_time", value)

    @_builtins.property
    @pulumi.getter(name="dataLevel2BackupAnotherRegionRegion")
    def data_level2_backup_another_region_region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        PolarDB Cluster of level-2 backup is a cross regional backup area.
        """
        return pulumi.get(self, "data_level2_backup_another_region_region")

    @data_level2_backup_another_region_region.setter
    def data_level2_backup_another_region_region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "data_level2_backup_another_region_region", value)

    @_builtins.property
    @pulumi.getter(name="dataLevel2BackupAnotherRegionRetentionPeriod")
    def data_level2_backup_another_region_retention_period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        PolarDB Cluster of level-2 backup cross region backup retention period. Valid values are `0`, `30 to 7300`, `-1`. Default to `0`.
        """
        return pulumi.get(self, "data_level2_backup_another_region_retention_period")

    @data_level2_backup_another_region_retention_period.setter
    def data_level2_backup_another_region_retention_period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "data_level2_backup_another_region_retention_period", value)

    @_builtins.property
    @pulumi.getter(name="dataLevel2BackupPeriods")
    def data_level2_backup_periods(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        PolarDB Cluster of level-2 backup period. Valid values: ["Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", "Sunday"].
        > **NOTE:** Note Select at least two values. Separate multiple values with commas (,).
        """
        return pulumi.get(self, "data_level2_backup_periods")

    @data_level2_backup_periods.setter
    def data_level2_backup_periods(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "data_level2_backup_periods", value)

    @_builtins.property
    @pulumi.getter(name="dataLevel2BackupRetentionPeriod")
    def data_level2_backup_retention_period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The retention period of level-2 backups. Valid values are `0`, `30 to 7300`, `-1`. Default to `0`.
        """
        return pulumi.get(self, "data_level2_backup_retention_period")

    @data_level2_backup_retention_period.setter
    def data_level2_backup_retention_period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "data_level2_backup_retention_period", value)

    @_builtins.property
    @pulumi.getter(name="dbClusterId")
    def db_cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Id of cluster that can run database.
        """
        return pulumi.get(self, "db_cluster_id")

    @db_cluster_id.setter
    def db_cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_cluster_id", value)

    @_builtins.property
    @pulumi.getter(name="enableBackupLog")
    def enable_backup_log(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Indicates whether the log backup feature was enabled. Valid values are `0`, `1`. `1` By default, the log backup feature is enabled and cannot be disabled.
        """
        return pulumi.get(self, "enable_backup_log")

    @enable_backup_log.setter
    def enable_backup_log(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "enable_backup_log", value)

    @_builtins.property
    @pulumi.getter(name="logBackupAnotherRegionRegion")
    def log_backup_another_region_region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which you want to store cross-region log backups. For information about regions that support the cross-region backup feature, see [Overview.](https://www.alibabacloud.com/help/en/polardb/latest/backup-and-restoration-overview)
        """
        return pulumi.get(self, "log_backup_another_region_region")

    @log_backup_another_region_region.setter
    def log_backup_another_region_region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "log_backup_another_region_region", value)

    @_builtins.property
    @pulumi.getter(name="logBackupAnotherRegionRetentionPeriod")
    def log_backup_another_region_retention_period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The retention period of cross-region log backups. Default value: OFF. Valid values are `0`, `30 to 7300`, `-1`.
        > **NOTE:** Note When you create a cluster, the default value of this parameter is 0.
        """
        return pulumi.get(self, "log_backup_another_region_retention_period")

    @log_backup_another_region_retention_period.setter
    def log_backup_another_region_retention_period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "log_backup_another_region_retention_period", value)

    @_builtins.property
    @pulumi.getter(name="logBackupRetentionPeriod")
    def log_backup_retention_period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The retention period of the log backups. Valid values are `3 to 7300`, `-1`.
        """
        return pulumi.get(self, "log_backup_retention_period")

    @log_backup_retention_period.setter
    def log_backup_retention_period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "log_backup_retention_period", value)

    @_builtins.property
    @pulumi.getter(name="preferredBackupPeriods")
    def preferred_backup_periods(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        PolarDB Cluster backup period. Valid values: ["Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", "Sunday"]. Default to ["Tuesday", "Thursday", "Saturday"].
        """
        return pulumi.get(self, "preferred_backup_periods")

    @preferred_backup_periods.setter
    def preferred_backup_periods(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "preferred_backup_periods", value)

    @_builtins.property
    @pulumi.getter(name="preferredBackupTime")
    def preferred_backup_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        PolarDB Cluster backup time, in the format of HH:mmZ- HH:mmZ. Time setting interval is one hour. Default to "02:00Z-03:00Z". China time is 8 hours behind it.
        """
        return pulumi.get(self, "preferred_backup_time")

    @preferred_backup_time.setter
    def preferred_backup_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "preferred_backup_time", value)


@pulumi.type_token("alicloud:polardb/backupPolicy:BackupPolicy")
class BackupPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backup_frequency: Optional[pulumi.Input[_builtins.str]] = None,
                 backup_retention_period: Optional[pulumi.Input[_builtins.str]] = None,
                 backup_retention_policy_on_cluster_deletion: Optional[pulumi.Input[_builtins.str]] = None,
                 data_level1_backup_frequency: Optional[pulumi.Input[_builtins.str]] = None,
                 data_level1_backup_periods: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 data_level1_backup_retention_period: Optional[pulumi.Input[_builtins.int]] = None,
                 data_level1_backup_time: Optional[pulumi.Input[_builtins.str]] = None,
                 data_level2_backup_another_region_region: Optional[pulumi.Input[_builtins.str]] = None,
                 data_level2_backup_another_region_retention_period: Optional[pulumi.Input[_builtins.int]] = None,
                 data_level2_backup_periods: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 data_level2_backup_retention_period: Optional[pulumi.Input[_builtins.int]] = None,
                 db_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 log_backup_another_region_region: Optional[pulumi.Input[_builtins.str]] = None,
                 log_backup_another_region_retention_period: Optional[pulumi.Input[_builtins.int]] = None,
                 log_backup_retention_period: Optional[pulumi.Input[_builtins.int]] = None,
                 preferred_backup_periods: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 preferred_backup_time: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Import

        PolarDB backup policy can be imported using the id or cluster id, e.g.

        ```sh
        $ pulumi import alicloud:polardb/backupPolicy:BackupPolicy example "rm-12345678"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] backup_frequency: The backup frequency. Valid values are `Normal`, `2/24H`, `3/24H`, `4/24H`.Default to `Normal`.
        :param pulumi.Input[_builtins.str] backup_retention_period: Cluster backup retention days, Fixed for 7 days, not modified.
        :param pulumi.Input[_builtins.str] backup_retention_policy_on_cluster_deletion: Specifies whether to retain backups when you delete a cluster. Valid values are `ALL`, `LATEST`, `NONE`. Default to `NONE`. Value options can refer to the latest docs [ModifyBackupPolicy](https://www.alibabacloud.com/help/en/polardb/latest/modifybackuppolicy)
        :param pulumi.Input[_builtins.str] data_level1_backup_frequency: The Id of cluster that can run database.The backup frequency. Valid values are `Normal`, `2/24H`, `3/24H`, `4/24H`.Default to `Normal`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] data_level1_backup_periods: PolarDB Cluster of level-1 backup period. Valid values: ["Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", "Sunday"].
               > **NOTE:** Note Select at least two values. Separate multiple values with commas (,).
        :param pulumi.Input[_builtins.int] data_level1_backup_retention_period: The retention period of level-1 backups. Valid values: 3 to 14. Unit: days.
        :param pulumi.Input[_builtins.str] data_level1_backup_time: The time period during which automatic backup is performed. The format is HH: MMZ HH: MMZ (UTC time), and the entered value must be an hour apart, such as 14:00z-15:00z.
        :param pulumi.Input[_builtins.str] data_level2_backup_another_region_region: PolarDB Cluster of level-2 backup is a cross regional backup area.
        :param pulumi.Input[_builtins.int] data_level2_backup_another_region_retention_period: PolarDB Cluster of level-2 backup cross region backup retention period. Valid values are `0`, `30 to 7300`, `-1`. Default to `0`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] data_level2_backup_periods: PolarDB Cluster of level-2 backup period. Valid values: ["Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", "Sunday"].
               > **NOTE:** Note Select at least two values. Separate multiple values with commas (,).
        :param pulumi.Input[_builtins.int] data_level2_backup_retention_period: The retention period of level-2 backups. Valid values are `0`, `30 to 7300`, `-1`. Default to `0`.
        :param pulumi.Input[_builtins.str] db_cluster_id: The Id of cluster that can run database.
        :param pulumi.Input[_builtins.str] log_backup_another_region_region: The region in which you want to store cross-region log backups. For information about regions that support the cross-region backup feature, see [Overview.](https://www.alibabacloud.com/help/en/polardb/latest/backup-and-restoration-overview)
        :param pulumi.Input[_builtins.int] log_backup_another_region_retention_period: The retention period of cross-region log backups. Default value: OFF. Valid values are `0`, `30 to 7300`, `-1`.
               > **NOTE:** Note When you create a cluster, the default value of this parameter is 0.
        :param pulumi.Input[_builtins.int] log_backup_retention_period: The retention period of the log backups. Valid values are `3 to 7300`, `-1`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] preferred_backup_periods: PolarDB Cluster backup period. Valid values: ["Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", "Sunday"]. Default to ["Tuesday", "Thursday", "Saturday"].
        :param pulumi.Input[_builtins.str] preferred_backup_time: PolarDB Cluster backup time, in the format of HH:mmZ- HH:mmZ. Time setting interval is one hour. Default to "02:00Z-03:00Z". China time is 8 hours behind it.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BackupPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        PolarDB backup policy can be imported using the id or cluster id, e.g.

        ```sh
        $ pulumi import alicloud:polardb/backupPolicy:BackupPolicy example "rm-12345678"
        ```

        :param str resource_name: The name of the resource.
        :param BackupPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BackupPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backup_frequency: Optional[pulumi.Input[_builtins.str]] = None,
                 backup_retention_period: Optional[pulumi.Input[_builtins.str]] = None,
                 backup_retention_policy_on_cluster_deletion: Optional[pulumi.Input[_builtins.str]] = None,
                 data_level1_backup_frequency: Optional[pulumi.Input[_builtins.str]] = None,
                 data_level1_backup_periods: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 data_level1_backup_retention_period: Optional[pulumi.Input[_builtins.int]] = None,
                 data_level1_backup_time: Optional[pulumi.Input[_builtins.str]] = None,
                 data_level2_backup_another_region_region: Optional[pulumi.Input[_builtins.str]] = None,
                 data_level2_backup_another_region_retention_period: Optional[pulumi.Input[_builtins.int]] = None,
                 data_level2_backup_periods: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 data_level2_backup_retention_period: Optional[pulumi.Input[_builtins.int]] = None,
                 db_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 log_backup_another_region_region: Optional[pulumi.Input[_builtins.str]] = None,
                 log_backup_another_region_retention_period: Optional[pulumi.Input[_builtins.int]] = None,
                 log_backup_retention_period: Optional[pulumi.Input[_builtins.int]] = None,
                 preferred_backup_periods: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 preferred_backup_time: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BackupPolicyArgs.__new__(BackupPolicyArgs)

            __props__.__dict__["backup_frequency"] = backup_frequency
            __props__.__dict__["backup_retention_period"] = backup_retention_period
            __props__.__dict__["backup_retention_policy_on_cluster_deletion"] = backup_retention_policy_on_cluster_deletion
            __props__.__dict__["data_level1_backup_frequency"] = data_level1_backup_frequency
            __props__.__dict__["data_level1_backup_periods"] = data_level1_backup_periods
            __props__.__dict__["data_level1_backup_retention_period"] = data_level1_backup_retention_period
            __props__.__dict__["data_level1_backup_time"] = data_level1_backup_time
            __props__.__dict__["data_level2_backup_another_region_region"] = data_level2_backup_another_region_region
            __props__.__dict__["data_level2_backup_another_region_retention_period"] = data_level2_backup_another_region_retention_period
            __props__.__dict__["data_level2_backup_periods"] = data_level2_backup_periods
            __props__.__dict__["data_level2_backup_retention_period"] = data_level2_backup_retention_period
            if db_cluster_id is None and not opts.urn:
                raise TypeError("Missing required property 'db_cluster_id'")
            __props__.__dict__["db_cluster_id"] = db_cluster_id
            __props__.__dict__["log_backup_another_region_region"] = log_backup_another_region_region
            __props__.__dict__["log_backup_another_region_retention_period"] = log_backup_another_region_retention_period
            __props__.__dict__["log_backup_retention_period"] = log_backup_retention_period
            __props__.__dict__["preferred_backup_periods"] = preferred_backup_periods
            __props__.__dict__["preferred_backup_time"] = preferred_backup_time
            __props__.__dict__["enable_backup_log"] = None
        super(BackupPolicy, __self__).__init__(
            'alicloud:polardb/backupPolicy:BackupPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            backup_frequency: Optional[pulumi.Input[_builtins.str]] = None,
            backup_retention_period: Optional[pulumi.Input[_builtins.str]] = None,
            backup_retention_policy_on_cluster_deletion: Optional[pulumi.Input[_builtins.str]] = None,
            data_level1_backup_frequency: Optional[pulumi.Input[_builtins.str]] = None,
            data_level1_backup_periods: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            data_level1_backup_retention_period: Optional[pulumi.Input[_builtins.int]] = None,
            data_level1_backup_time: Optional[pulumi.Input[_builtins.str]] = None,
            data_level2_backup_another_region_region: Optional[pulumi.Input[_builtins.str]] = None,
            data_level2_backup_another_region_retention_period: Optional[pulumi.Input[_builtins.int]] = None,
            data_level2_backup_periods: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            data_level2_backup_retention_period: Optional[pulumi.Input[_builtins.int]] = None,
            db_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
            enable_backup_log: Optional[pulumi.Input[_builtins.int]] = None,
            log_backup_another_region_region: Optional[pulumi.Input[_builtins.str]] = None,
            log_backup_another_region_retention_period: Optional[pulumi.Input[_builtins.int]] = None,
            log_backup_retention_period: Optional[pulumi.Input[_builtins.int]] = None,
            preferred_backup_periods: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            preferred_backup_time: Optional[pulumi.Input[_builtins.str]] = None) -> 'BackupPolicy':
        """
        Get an existing BackupPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] backup_frequency: The backup frequency. Valid values are `Normal`, `2/24H`, `3/24H`, `4/24H`.Default to `Normal`.
        :param pulumi.Input[_builtins.str] backup_retention_period: Cluster backup retention days, Fixed for 7 days, not modified.
        :param pulumi.Input[_builtins.str] backup_retention_policy_on_cluster_deletion: Specifies whether to retain backups when you delete a cluster. Valid values are `ALL`, `LATEST`, `NONE`. Default to `NONE`. Value options can refer to the latest docs [ModifyBackupPolicy](https://www.alibabacloud.com/help/en/polardb/latest/modifybackuppolicy)
        :param pulumi.Input[_builtins.str] data_level1_backup_frequency: The Id of cluster that can run database.The backup frequency. Valid values are `Normal`, `2/24H`, `3/24H`, `4/24H`.Default to `Normal`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] data_level1_backup_periods: PolarDB Cluster of level-1 backup period. Valid values: ["Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", "Sunday"].
               > **NOTE:** Note Select at least two values. Separate multiple values with commas (,).
        :param pulumi.Input[_builtins.int] data_level1_backup_retention_period: The retention period of level-1 backups. Valid values: 3 to 14. Unit: days.
        :param pulumi.Input[_builtins.str] data_level1_backup_time: The time period during which automatic backup is performed. The format is HH: MMZ HH: MMZ (UTC time), and the entered value must be an hour apart, such as 14:00z-15:00z.
        :param pulumi.Input[_builtins.str] data_level2_backup_another_region_region: PolarDB Cluster of level-2 backup is a cross regional backup area.
        :param pulumi.Input[_builtins.int] data_level2_backup_another_region_retention_period: PolarDB Cluster of level-2 backup cross region backup retention period. Valid values are `0`, `30 to 7300`, `-1`. Default to `0`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] data_level2_backup_periods: PolarDB Cluster of level-2 backup period. Valid values: ["Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", "Sunday"].
               > **NOTE:** Note Select at least two values. Separate multiple values with commas (,).
        :param pulumi.Input[_builtins.int] data_level2_backup_retention_period: The retention period of level-2 backups. Valid values are `0`, `30 to 7300`, `-1`. Default to `0`.
        :param pulumi.Input[_builtins.str] db_cluster_id: The Id of cluster that can run database.
        :param pulumi.Input[_builtins.int] enable_backup_log: Indicates whether the log backup feature was enabled. Valid values are `0`, `1`. `1` By default, the log backup feature is enabled and cannot be disabled.
        :param pulumi.Input[_builtins.str] log_backup_another_region_region: The region in which you want to store cross-region log backups. For information about regions that support the cross-region backup feature, see [Overview.](https://www.alibabacloud.com/help/en/polardb/latest/backup-and-restoration-overview)
        :param pulumi.Input[_builtins.int] log_backup_another_region_retention_period: The retention period of cross-region log backups. Default value: OFF. Valid values are `0`, `30 to 7300`, `-1`.
               > **NOTE:** Note When you create a cluster, the default value of this parameter is 0.
        :param pulumi.Input[_builtins.int] log_backup_retention_period: The retention period of the log backups. Valid values are `3 to 7300`, `-1`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] preferred_backup_periods: PolarDB Cluster backup period. Valid values: ["Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", "Sunday"]. Default to ["Tuesday", "Thursday", "Saturday"].
        :param pulumi.Input[_builtins.str] preferred_backup_time: PolarDB Cluster backup time, in the format of HH:mmZ- HH:mmZ. Time setting interval is one hour. Default to "02:00Z-03:00Z". China time is 8 hours behind it.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BackupPolicyState.__new__(_BackupPolicyState)

        __props__.__dict__["backup_frequency"] = backup_frequency
        __props__.__dict__["backup_retention_period"] = backup_retention_period
        __props__.__dict__["backup_retention_policy_on_cluster_deletion"] = backup_retention_policy_on_cluster_deletion
        __props__.__dict__["data_level1_backup_frequency"] = data_level1_backup_frequency
        __props__.__dict__["data_level1_backup_periods"] = data_level1_backup_periods
        __props__.__dict__["data_level1_backup_retention_period"] = data_level1_backup_retention_period
        __props__.__dict__["data_level1_backup_time"] = data_level1_backup_time
        __props__.__dict__["data_level2_backup_another_region_region"] = data_level2_backup_another_region_region
        __props__.__dict__["data_level2_backup_another_region_retention_period"] = data_level2_backup_another_region_retention_period
        __props__.__dict__["data_level2_backup_periods"] = data_level2_backup_periods
        __props__.__dict__["data_level2_backup_retention_period"] = data_level2_backup_retention_period
        __props__.__dict__["db_cluster_id"] = db_cluster_id
        __props__.__dict__["enable_backup_log"] = enable_backup_log
        __props__.__dict__["log_backup_another_region_region"] = log_backup_another_region_region
        __props__.__dict__["log_backup_another_region_retention_period"] = log_backup_another_region_retention_period
        __props__.__dict__["log_backup_retention_period"] = log_backup_retention_period
        __props__.__dict__["preferred_backup_periods"] = preferred_backup_periods
        __props__.__dict__["preferred_backup_time"] = preferred_backup_time
        return BackupPolicy(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="backupFrequency")
    def backup_frequency(self) -> pulumi.Output[_builtins.str]:
        """
        The backup frequency. Valid values are `Normal`, `2/24H`, `3/24H`, `4/24H`.Default to `Normal`.
        """
        return pulumi.get(self, "backup_frequency")

    @_builtins.property
    @pulumi.getter(name="backupRetentionPeriod")
    def backup_retention_period(self) -> pulumi.Output[_builtins.str]:
        """
        Cluster backup retention days, Fixed for 7 days, not modified.
        """
        return pulumi.get(self, "backup_retention_period")

    @_builtins.property
    @pulumi.getter(name="backupRetentionPolicyOnClusterDeletion")
    def backup_retention_policy_on_cluster_deletion(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies whether to retain backups when you delete a cluster. Valid values are `ALL`, `LATEST`, `NONE`. Default to `NONE`. Value options can refer to the latest docs [ModifyBackupPolicy](https://www.alibabacloud.com/help/en/polardb/latest/modifybackuppolicy)
        """
        return pulumi.get(self, "backup_retention_policy_on_cluster_deletion")

    @_builtins.property
    @pulumi.getter(name="dataLevel1BackupFrequency")
    def data_level1_backup_frequency(self) -> pulumi.Output[_builtins.str]:
        """
        The Id of cluster that can run database.The backup frequency. Valid values are `Normal`, `2/24H`, `3/24H`, `4/24H`.Default to `Normal`.
        """
        return pulumi.get(self, "data_level1_backup_frequency")

    @_builtins.property
    @pulumi.getter(name="dataLevel1BackupPeriods")
    def data_level1_backup_periods(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        PolarDB Cluster of level-1 backup period. Valid values: ["Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", "Sunday"].
        > **NOTE:** Note Select at least two values. Separate multiple values with commas (,).
        """
        return pulumi.get(self, "data_level1_backup_periods")

    @_builtins.property
    @pulumi.getter(name="dataLevel1BackupRetentionPeriod")
    def data_level1_backup_retention_period(self) -> pulumi.Output[_builtins.int]:
        """
        The retention period of level-1 backups. Valid values: 3 to 14. Unit: days.
        """
        return pulumi.get(self, "data_level1_backup_retention_period")

    @_builtins.property
    @pulumi.getter(name="dataLevel1BackupTime")
    def data_level1_backup_time(self) -> pulumi.Output[_builtins.str]:
        """
        The time period during which automatic backup is performed. The format is HH: MMZ HH: MMZ (UTC time), and the entered value must be an hour apart, such as 14:00z-15:00z.
        """
        return pulumi.get(self, "data_level1_backup_time")

    @_builtins.property
    @pulumi.getter(name="dataLevel2BackupAnotherRegionRegion")
    def data_level2_backup_another_region_region(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        PolarDB Cluster of level-2 backup is a cross regional backup area.
        """
        return pulumi.get(self, "data_level2_backup_another_region_region")

    @_builtins.property
    @pulumi.getter(name="dataLevel2BackupAnotherRegionRetentionPeriod")
    def data_level2_backup_another_region_retention_period(self) -> pulumi.Output[_builtins.int]:
        """
        PolarDB Cluster of level-2 backup cross region backup retention period. Valid values are `0`, `30 to 7300`, `-1`. Default to `0`.
        """
        return pulumi.get(self, "data_level2_backup_another_region_retention_period")

    @_builtins.property
    @pulumi.getter(name="dataLevel2BackupPeriods")
    def data_level2_backup_periods(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        PolarDB Cluster of level-2 backup period. Valid values: ["Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", "Sunday"].
        > **NOTE:** Note Select at least two values. Separate multiple values with commas (,).
        """
        return pulumi.get(self, "data_level2_backup_periods")

    @_builtins.property
    @pulumi.getter(name="dataLevel2BackupRetentionPeriod")
    def data_level2_backup_retention_period(self) -> pulumi.Output[_builtins.int]:
        """
        The retention period of level-2 backups. Valid values are `0`, `30 to 7300`, `-1`. Default to `0`.
        """
        return pulumi.get(self, "data_level2_backup_retention_period")

    @_builtins.property
    @pulumi.getter(name="dbClusterId")
    def db_cluster_id(self) -> pulumi.Output[_builtins.str]:
        """
        The Id of cluster that can run database.
        """
        return pulumi.get(self, "db_cluster_id")

    @_builtins.property
    @pulumi.getter(name="enableBackupLog")
    def enable_backup_log(self) -> pulumi.Output[_builtins.int]:
        """
        Indicates whether the log backup feature was enabled. Valid values are `0`, `1`. `1` By default, the log backup feature is enabled and cannot be disabled.
        """
        return pulumi.get(self, "enable_backup_log")

    @_builtins.property
    @pulumi.getter(name="logBackupAnotherRegionRegion")
    def log_backup_another_region_region(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The region in which you want to store cross-region log backups. For information about regions that support the cross-region backup feature, see [Overview.](https://www.alibabacloud.com/help/en/polardb/latest/backup-and-restoration-overview)
        """
        return pulumi.get(self, "log_backup_another_region_region")

    @_builtins.property
    @pulumi.getter(name="logBackupAnotherRegionRetentionPeriod")
    def log_backup_another_region_retention_period(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The retention period of cross-region log backups. Default value: OFF. Valid values are `0`, `30 to 7300`, `-1`.
        > **NOTE:** Note When you create a cluster, the default value of this parameter is 0.
        """
        return pulumi.get(self, "log_backup_another_region_retention_period")

    @_builtins.property
    @pulumi.getter(name="logBackupRetentionPeriod")
    def log_backup_retention_period(self) -> pulumi.Output[_builtins.int]:
        """
        The retention period of the log backups. Valid values are `3 to 7300`, `-1`.
        """
        return pulumi.get(self, "log_backup_retention_period")

    @_builtins.property
    @pulumi.getter(name="preferredBackupPeriods")
    def preferred_backup_periods(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        PolarDB Cluster backup period. Valid values: ["Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", "Sunday"]. Default to ["Tuesday", "Thursday", "Saturday"].
        """
        return pulumi.get(self, "preferred_backup_periods")

    @_builtins.property
    @pulumi.getter(name="preferredBackupTime")
    def preferred_backup_time(self) -> pulumi.Output[_builtins.str]:
        """
        PolarDB Cluster backup time, in the format of HH:mmZ- HH:mmZ. Time setting interval is one hour. Default to "02:00Z-03:00Z". China time is 8 hours behind it.
        """
        return pulumi.get(self, "preferred_backup_time")

