# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetDatabasesResult',
    'AwaitableGetDatabasesResult',
    'get_databases',
    'get_databases_output',
]

@pulumi.output_type
class GetDatabasesResult:
    """
    A collection of values returned by getDatabases.
    """
    def __init__(__self__, databases=None, db_cluster_id=None, id=None, name_regex=None, names=None):
        if databases and not isinstance(databases, list):
            raise TypeError("Expected argument 'databases' to be a list")
        pulumi.set(__self__, "databases", databases)
        if db_cluster_id and not isinstance(db_cluster_id, str):
            raise TypeError("Expected argument 'db_cluster_id' to be a str")
        pulumi.set(__self__, "db_cluster_id", db_cluster_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if names and not isinstance(names, list):
            raise TypeError("Expected argument 'names' to be a list")
        pulumi.set(__self__, "names", names)

    @_builtins.property
    @pulumi.getter
    def databases(self) -> Sequence['outputs.GetDatabasesDatabaseResult']:
        """
        A list of PolarDB cluster databases. Each element contains the following attributes:
        """
        return pulumi.get(self, "databases")

    @_builtins.property
    @pulumi.getter(name="dbClusterId")
    def db_cluster_id(self) -> _builtins.str:
        return pulumi.get(self, "db_cluster_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "name_regex")

    @_builtins.property
    @pulumi.getter
    def names(self) -> Sequence[_builtins.str]:
        """
        database name of the cluster.
        """
        return pulumi.get(self, "names")


class AwaitableGetDatabasesResult(GetDatabasesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDatabasesResult(
            databases=self.databases,
            db_cluster_id=self.db_cluster_id,
            id=self.id,
            name_regex=self.name_regex,
            names=self.names)


def get_databases(db_cluster_id: Optional[_builtins.str] = None,
                  name_regex: Optional[_builtins.str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDatabasesResult:
    """
    The `polardb_get_databases` data source provides a collection of PolarDB cluster database available in Alibaba Cloud account.
    Filters support regular expression for the database name, searches by clusterId.

    > **NOTE:** Available since v1.70.0+.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    this = alicloud.polardb.get_node_classes(db_type="MySQL",
        db_version="8.0",
        pay_type="PostPaid",
        category="Normal")
    default_network = alicloud.vpc.Network("default",
        vpc_name="terraform-example",
        cidr_block="172.16.0.0/16")
    default_switch = alicloud.vpc.Switch("default",
        vpc_id=default_network.id,
        cidr_block="172.16.0.0/24",
        zone_id=this.classes[0].zone_id,
        vswitch_name="terraform-example")
    cluster = alicloud.polardb.Cluster("cluster",
        db_type="MySQL",
        db_version="8.0",
        pay_type="PostPaid",
        db_node_count=2,
        db_node_class=this.classes[0].supported_engines[0].available_resources[0].db_node_class,
        vswitch_id=default_switch.id)
    polardb_clusters_ds = alicloud.polardb.get_clusters_output(description_regex=cluster.description,
        status="Running")
    default_database = alicloud.polardb.Database("default",
        db_cluster_id=polardb_clusters_ds.clusters[0].id,
        db_name=polardb_clusters_ds.apply(lambda polardb_clusters_ds: f"tfaccountpri_{polardb_clusters_ds.clusters[0].id}"),
        db_description="from terraform")
    default = pulumi.Output.all(
        polardb_clusters_ds=polardb_clusters_ds,
        db_name=default_database.db_name
    ).apply(lambda resolved_outputs: alicloud.polardb.get_databases_output(db_cluster_id=polardb_clusters_ds.clusters[0].id,
        name_regex=resolved_outputs['db_name']))

    pulumi.export("database", default.databases[0].db_name)
    ```


    :param _builtins.str db_cluster_id: The polarDB cluster ID.
    :param _builtins.str name_regex: A regex string to filter results by database name.
    """
    __args__ = dict()
    __args__['dbClusterId'] = db_cluster_id
    __args__['nameRegex'] = name_regex
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:polardb/getDatabases:getDatabases', __args__, opts=opts, typ=GetDatabasesResult).value

    return AwaitableGetDatabasesResult(
        databases=pulumi.get(__ret__, 'databases'),
        db_cluster_id=pulumi.get(__ret__, 'db_cluster_id'),
        id=pulumi.get(__ret__, 'id'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        names=pulumi.get(__ret__, 'names'))
def get_databases_output(db_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                         name_regex: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDatabasesResult]:
    """
    The `polardb_get_databases` data source provides a collection of PolarDB cluster database available in Alibaba Cloud account.
    Filters support regular expression for the database name, searches by clusterId.

    > **NOTE:** Available since v1.70.0+.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    this = alicloud.polardb.get_node_classes(db_type="MySQL",
        db_version="8.0",
        pay_type="PostPaid",
        category="Normal")
    default_network = alicloud.vpc.Network("default",
        vpc_name="terraform-example",
        cidr_block="172.16.0.0/16")
    default_switch = alicloud.vpc.Switch("default",
        vpc_id=default_network.id,
        cidr_block="172.16.0.0/24",
        zone_id=this.classes[0].zone_id,
        vswitch_name="terraform-example")
    cluster = alicloud.polardb.Cluster("cluster",
        db_type="MySQL",
        db_version="8.0",
        pay_type="PostPaid",
        db_node_count=2,
        db_node_class=this.classes[0].supported_engines[0].available_resources[0].db_node_class,
        vswitch_id=default_switch.id)
    polardb_clusters_ds = alicloud.polardb.get_clusters_output(description_regex=cluster.description,
        status="Running")
    default_database = alicloud.polardb.Database("default",
        db_cluster_id=polardb_clusters_ds.clusters[0].id,
        db_name=polardb_clusters_ds.apply(lambda polardb_clusters_ds: f"tfaccountpri_{polardb_clusters_ds.clusters[0].id}"),
        db_description="from terraform")
    default = pulumi.Output.all(
        polardb_clusters_ds=polardb_clusters_ds,
        db_name=default_database.db_name
    ).apply(lambda resolved_outputs: alicloud.polardb.get_databases_output(db_cluster_id=polardb_clusters_ds.clusters[0].id,
        name_regex=resolved_outputs['db_name']))

    pulumi.export("database", default.databases[0].db_name)
    ```


    :param _builtins.str db_cluster_id: The polarDB cluster ID.
    :param _builtins.str name_regex: A regex string to filter results by database name.
    """
    __args__ = dict()
    __args__['dbClusterId'] = db_cluster_id
    __args__['nameRegex'] = name_regex
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:polardb/getDatabases:getDatabases', __args__, opts=opts, typ=GetDatabasesResult)
    return __ret__.apply(lambda __response__: GetDatabasesResult(
        databases=pulumi.get(__response__, 'databases'),
        db_cluster_id=pulumi.get(__response__, 'db_cluster_id'),
        id=pulumi.get(__response__, 'id'),
        name_regex=pulumi.get(__response__, 'name_regex'),
        names=pulumi.get(__response__, 'names')))
