# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['PrimaryEndpointArgs', 'PrimaryEndpoint']

@pulumi.input_type
class PrimaryEndpointArgs:
    def __init__(__self__, *,
                 db_cluster_id: pulumi.Input[_builtins.str],
                 connection_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 db_endpoint_description: Optional[pulumi.Input[_builtins.str]] = None,
                 net_type: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_auto_rotate: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_enabled: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a PrimaryEndpoint resource.
        :param pulumi.Input[_builtins.str] db_cluster_id: The Id of cluster that can run database.
        :param pulumi.Input[_builtins.str] connection_prefix: Prefix of the specified endpoint. The prefix must be 6 to 30 characters in length, and can contain lowercase letters, digits, and hyphens (-), must start with a letter and end with a digit or letter.
        :param pulumi.Input[_builtins.str] db_endpoint_description: The name of the endpoint.
        :param pulumi.Input[_builtins.str] net_type: The network type of the endpoint address.
        :param pulumi.Input[_builtins.str] port: Port of the specified endpoint. Valid values: 3000 to 5999.
        :param pulumi.Input[_builtins.str] ssl_auto_rotate: Specifies whether automatic rotation of SSL certificates is enabled. Valid values: `Enable`,`Disable`.
               **NOTE:** For a PolarDB for MySQL cluster, this parameter is required, and only one connection string in each endpoint can enable the ssl, for other notes, see [Configure SSL encryption](https://www.alibabacloud.com/help/doc-detail/153182.htm).
               For a PolarDB for PostgreSQL cluster or a PolarDB-O cluster, this parameter is not required, by default, SSL encryption is enabled for all endpoints.
        :param pulumi.Input[_builtins.str] ssl_enabled: Specifies how to modify the SSL encryption status. Valid values: `Disable`, `Enable`, `Update`.
        """
        pulumi.set(__self__, "db_cluster_id", db_cluster_id)
        if connection_prefix is not None:
            pulumi.set(__self__, "connection_prefix", connection_prefix)
        if db_endpoint_description is not None:
            pulumi.set(__self__, "db_endpoint_description", db_endpoint_description)
        if net_type is not None:
            pulumi.set(__self__, "net_type", net_type)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if ssl_auto_rotate is not None:
            pulumi.set(__self__, "ssl_auto_rotate", ssl_auto_rotate)
        if ssl_enabled is not None:
            pulumi.set(__self__, "ssl_enabled", ssl_enabled)

    @_builtins.property
    @pulumi.getter(name="dbClusterId")
    def db_cluster_id(self) -> pulumi.Input[_builtins.str]:
        """
        The Id of cluster that can run database.
        """
        return pulumi.get(self, "db_cluster_id")

    @db_cluster_id.setter
    def db_cluster_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "db_cluster_id", value)

    @_builtins.property
    @pulumi.getter(name="connectionPrefix")
    def connection_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Prefix of the specified endpoint. The prefix must be 6 to 30 characters in length, and can contain lowercase letters, digits, and hyphens (-), must start with a letter and end with a digit or letter.
        """
        return pulumi.get(self, "connection_prefix")

    @connection_prefix.setter
    def connection_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "connection_prefix", value)

    @_builtins.property
    @pulumi.getter(name="dbEndpointDescription")
    def db_endpoint_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the endpoint.
        """
        return pulumi.get(self, "db_endpoint_description")

    @db_endpoint_description.setter
    def db_endpoint_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_endpoint_description", value)

    @_builtins.property
    @pulumi.getter(name="netType")
    def net_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The network type of the endpoint address.
        """
        return pulumi.get(self, "net_type")

    @net_type.setter
    def net_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "net_type", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Port of the specified endpoint. Valid values: 3000 to 5999.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter(name="sslAutoRotate")
    def ssl_auto_rotate(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether automatic rotation of SSL certificates is enabled. Valid values: `Enable`,`Disable`.
        **NOTE:** For a PolarDB for MySQL cluster, this parameter is required, and only one connection string in each endpoint can enable the ssl, for other notes, see [Configure SSL encryption](https://www.alibabacloud.com/help/doc-detail/153182.htm).
        For a PolarDB for PostgreSQL cluster or a PolarDB-O cluster, this parameter is not required, by default, SSL encryption is enabled for all endpoints.
        """
        return pulumi.get(self, "ssl_auto_rotate")

    @ssl_auto_rotate.setter
    def ssl_auto_rotate(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ssl_auto_rotate", value)

    @_builtins.property
    @pulumi.getter(name="sslEnabled")
    def ssl_enabled(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies how to modify the SSL encryption status. Valid values: `Disable`, `Enable`, `Update`.
        """
        return pulumi.get(self, "ssl_enabled")

    @ssl_enabled.setter
    def ssl_enabled(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ssl_enabled", value)


@pulumi.input_type
class _PrimaryEndpointState:
    def __init__(__self__, *,
                 connection_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 db_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 db_endpoint_description: Optional[pulumi.Input[_builtins.str]] = None,
                 db_endpoint_id: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoint_type: Optional[pulumi.Input[_builtins.str]] = None,
                 net_type: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_auto_rotate: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_certificate_url: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_connection_string: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_enabled: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_expire_time: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering PrimaryEndpoint resources.
        :param pulumi.Input[_builtins.str] connection_prefix: Prefix of the specified endpoint. The prefix must be 6 to 30 characters in length, and can contain lowercase letters, digits, and hyphens (-), must start with a letter and end with a digit or letter.
        :param pulumi.Input[_builtins.str] db_cluster_id: The Id of cluster that can run database.
        :param pulumi.Input[_builtins.str] db_endpoint_description: The name of the endpoint.
        :param pulumi.Input[_builtins.str] db_endpoint_id: The ID of the cluster endpoint.
        :param pulumi.Input[_builtins.str] endpoint_type: Type of endpoint.
        :param pulumi.Input[_builtins.str] net_type: The network type of the endpoint address.
        :param pulumi.Input[_builtins.str] port: Port of the specified endpoint. Valid values: 3000 to 5999.
        :param pulumi.Input[_builtins.str] ssl_auto_rotate: Specifies whether automatic rotation of SSL certificates is enabled. Valid values: `Enable`,`Disable`.
               **NOTE:** For a PolarDB for MySQL cluster, this parameter is required, and only one connection string in each endpoint can enable the ssl, for other notes, see [Configure SSL encryption](https://www.alibabacloud.com/help/doc-detail/153182.htm).
               For a PolarDB for PostgreSQL cluster or a PolarDB-O cluster, this parameter is not required, by default, SSL encryption is enabled for all endpoints.
        :param pulumi.Input[_builtins.str] ssl_certificate_url: The specifies SSL certificate download link.
        :param pulumi.Input[_builtins.str] ssl_connection_string: The SSL connection string.
        :param pulumi.Input[_builtins.str] ssl_enabled: Specifies how to modify the SSL encryption status. Valid values: `Disable`, `Enable`, `Update`.
        :param pulumi.Input[_builtins.str] ssl_expire_time: The time when the SSL certificate expires. The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC.
        """
        if connection_prefix is not None:
            pulumi.set(__self__, "connection_prefix", connection_prefix)
        if db_cluster_id is not None:
            pulumi.set(__self__, "db_cluster_id", db_cluster_id)
        if db_endpoint_description is not None:
            pulumi.set(__self__, "db_endpoint_description", db_endpoint_description)
        if db_endpoint_id is not None:
            pulumi.set(__self__, "db_endpoint_id", db_endpoint_id)
        if endpoint_type is not None:
            pulumi.set(__self__, "endpoint_type", endpoint_type)
        if net_type is not None:
            pulumi.set(__self__, "net_type", net_type)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if ssl_auto_rotate is not None:
            pulumi.set(__self__, "ssl_auto_rotate", ssl_auto_rotate)
        if ssl_certificate_url is not None:
            pulumi.set(__self__, "ssl_certificate_url", ssl_certificate_url)
        if ssl_connection_string is not None:
            pulumi.set(__self__, "ssl_connection_string", ssl_connection_string)
        if ssl_enabled is not None:
            pulumi.set(__self__, "ssl_enabled", ssl_enabled)
        if ssl_expire_time is not None:
            pulumi.set(__self__, "ssl_expire_time", ssl_expire_time)

    @_builtins.property
    @pulumi.getter(name="connectionPrefix")
    def connection_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Prefix of the specified endpoint. The prefix must be 6 to 30 characters in length, and can contain lowercase letters, digits, and hyphens (-), must start with a letter and end with a digit or letter.
        """
        return pulumi.get(self, "connection_prefix")

    @connection_prefix.setter
    def connection_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "connection_prefix", value)

    @_builtins.property
    @pulumi.getter(name="dbClusterId")
    def db_cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Id of cluster that can run database.
        """
        return pulumi.get(self, "db_cluster_id")

    @db_cluster_id.setter
    def db_cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_cluster_id", value)

    @_builtins.property
    @pulumi.getter(name="dbEndpointDescription")
    def db_endpoint_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the endpoint.
        """
        return pulumi.get(self, "db_endpoint_description")

    @db_endpoint_description.setter
    def db_endpoint_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_endpoint_description", value)

    @_builtins.property
    @pulumi.getter(name="dbEndpointId")
    def db_endpoint_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the cluster endpoint.
        """
        return pulumi.get(self, "db_endpoint_id")

    @db_endpoint_id.setter
    def db_endpoint_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_endpoint_id", value)

    @_builtins.property
    @pulumi.getter(name="endpointType")
    def endpoint_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of endpoint.
        """
        return pulumi.get(self, "endpoint_type")

    @endpoint_type.setter
    def endpoint_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "endpoint_type", value)

    @_builtins.property
    @pulumi.getter(name="netType")
    def net_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The network type of the endpoint address.
        """
        return pulumi.get(self, "net_type")

    @net_type.setter
    def net_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "net_type", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Port of the specified endpoint. Valid values: 3000 to 5999.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter(name="sslAutoRotate")
    def ssl_auto_rotate(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether automatic rotation of SSL certificates is enabled. Valid values: `Enable`,`Disable`.
        **NOTE:** For a PolarDB for MySQL cluster, this parameter is required, and only one connection string in each endpoint can enable the ssl, for other notes, see [Configure SSL encryption](https://www.alibabacloud.com/help/doc-detail/153182.htm).
        For a PolarDB for PostgreSQL cluster or a PolarDB-O cluster, this parameter is not required, by default, SSL encryption is enabled for all endpoints.
        """
        return pulumi.get(self, "ssl_auto_rotate")

    @ssl_auto_rotate.setter
    def ssl_auto_rotate(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ssl_auto_rotate", value)

    @_builtins.property
    @pulumi.getter(name="sslCertificateUrl")
    def ssl_certificate_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The specifies SSL certificate download link.
        """
        return pulumi.get(self, "ssl_certificate_url")

    @ssl_certificate_url.setter
    def ssl_certificate_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ssl_certificate_url", value)

    @_builtins.property
    @pulumi.getter(name="sslConnectionString")
    def ssl_connection_string(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The SSL connection string.
        """
        return pulumi.get(self, "ssl_connection_string")

    @ssl_connection_string.setter
    def ssl_connection_string(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ssl_connection_string", value)

    @_builtins.property
    @pulumi.getter(name="sslEnabled")
    def ssl_enabled(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies how to modify the SSL encryption status. Valid values: `Disable`, `Enable`, `Update`.
        """
        return pulumi.get(self, "ssl_enabled")

    @ssl_enabled.setter
    def ssl_enabled(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ssl_enabled", value)

    @_builtins.property
    @pulumi.getter(name="sslExpireTime")
    def ssl_expire_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time when the SSL certificate expires. The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC.
        """
        return pulumi.get(self, "ssl_expire_time")

    @ssl_expire_time.setter
    def ssl_expire_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ssl_expire_time", value)


@pulumi.type_token("alicloud:polardb/primaryEndpoint:PrimaryEndpoint")
class PrimaryEndpoint(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 connection_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 db_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 db_endpoint_description: Optional[pulumi.Input[_builtins.str]] = None,
                 net_type: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_auto_rotate: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_enabled: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a PolarDB endpoint resource to manage primary endpoint of PolarDB cluster.

        > **NOTE:** Available since v1.217.0

        > **NOTE:** The default primary endpoint can not be created or deleted manually.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        default = alicloud.polardb.get_node_classes(db_type="MySQL",
            db_version="8.0",
            pay_type="PostPaid",
            category="Normal")
        default_network = alicloud.vpc.Network("default",
            vpc_name="terraform-example",
            cidr_block="172.16.0.0/16")
        default_switch = alicloud.vpc.Switch("default",
            vpc_id=default_network.id,
            cidr_block="172.16.0.0/24",
            zone_id=default.classes[0].zone_id,
            vswitch_name="terraform-example")
        default_cluster = alicloud.polardb.Cluster("default",
            db_type="MySQL",
            db_version="8.0",
            db_node_class=default.classes[0].supported_engines[0].available_resources[0].db_node_class,
            pay_type="PostPaid",
            vswitch_id=default_switch.id,
            description="terraform-example")
        default_primary_endpoint = alicloud.polardb.PrimaryEndpoint("default", db_cluster_id=default_cluster.id)
        ```

        ## Import

        PolarDB endpoint can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:polardb/primaryEndpoint:PrimaryEndpoint example pc-abc123456:pe-abc123456
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] connection_prefix: Prefix of the specified endpoint. The prefix must be 6 to 30 characters in length, and can contain lowercase letters, digits, and hyphens (-), must start with a letter and end with a digit or letter.
        :param pulumi.Input[_builtins.str] db_cluster_id: The Id of cluster that can run database.
        :param pulumi.Input[_builtins.str] db_endpoint_description: The name of the endpoint.
        :param pulumi.Input[_builtins.str] net_type: The network type of the endpoint address.
        :param pulumi.Input[_builtins.str] port: Port of the specified endpoint. Valid values: 3000 to 5999.
        :param pulumi.Input[_builtins.str] ssl_auto_rotate: Specifies whether automatic rotation of SSL certificates is enabled. Valid values: `Enable`,`Disable`.
               **NOTE:** For a PolarDB for MySQL cluster, this parameter is required, and only one connection string in each endpoint can enable the ssl, for other notes, see [Configure SSL encryption](https://www.alibabacloud.com/help/doc-detail/153182.htm).
               For a PolarDB for PostgreSQL cluster or a PolarDB-O cluster, this parameter is not required, by default, SSL encryption is enabled for all endpoints.
        :param pulumi.Input[_builtins.str] ssl_enabled: Specifies how to modify the SSL encryption status. Valid values: `Disable`, `Enable`, `Update`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PrimaryEndpointArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a PolarDB endpoint resource to manage primary endpoint of PolarDB cluster.

        > **NOTE:** Available since v1.217.0

        > **NOTE:** The default primary endpoint can not be created or deleted manually.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        default = alicloud.polardb.get_node_classes(db_type="MySQL",
            db_version="8.0",
            pay_type="PostPaid",
            category="Normal")
        default_network = alicloud.vpc.Network("default",
            vpc_name="terraform-example",
            cidr_block="172.16.0.0/16")
        default_switch = alicloud.vpc.Switch("default",
            vpc_id=default_network.id,
            cidr_block="172.16.0.0/24",
            zone_id=default.classes[0].zone_id,
            vswitch_name="terraform-example")
        default_cluster = alicloud.polardb.Cluster("default",
            db_type="MySQL",
            db_version="8.0",
            db_node_class=default.classes[0].supported_engines[0].available_resources[0].db_node_class,
            pay_type="PostPaid",
            vswitch_id=default_switch.id,
            description="terraform-example")
        default_primary_endpoint = alicloud.polardb.PrimaryEndpoint("default", db_cluster_id=default_cluster.id)
        ```

        ## Import

        PolarDB endpoint can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:polardb/primaryEndpoint:PrimaryEndpoint example pc-abc123456:pe-abc123456
        ```

        :param str resource_name: The name of the resource.
        :param PrimaryEndpointArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PrimaryEndpointArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 connection_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 db_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 db_endpoint_description: Optional[pulumi.Input[_builtins.str]] = None,
                 net_type: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_auto_rotate: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_enabled: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PrimaryEndpointArgs.__new__(PrimaryEndpointArgs)

            __props__.__dict__["connection_prefix"] = connection_prefix
            if db_cluster_id is None and not opts.urn:
                raise TypeError("Missing required property 'db_cluster_id'")
            __props__.__dict__["db_cluster_id"] = db_cluster_id
            __props__.__dict__["db_endpoint_description"] = db_endpoint_description
            __props__.__dict__["net_type"] = net_type
            __props__.__dict__["port"] = port
            __props__.__dict__["ssl_auto_rotate"] = ssl_auto_rotate
            __props__.__dict__["ssl_enabled"] = ssl_enabled
            __props__.__dict__["db_endpoint_id"] = None
            __props__.__dict__["endpoint_type"] = None
            __props__.__dict__["ssl_certificate_url"] = None
            __props__.__dict__["ssl_connection_string"] = None
            __props__.__dict__["ssl_expire_time"] = None
        super(PrimaryEndpoint, __self__).__init__(
            'alicloud:polardb/primaryEndpoint:PrimaryEndpoint',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            connection_prefix: Optional[pulumi.Input[_builtins.str]] = None,
            db_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
            db_endpoint_description: Optional[pulumi.Input[_builtins.str]] = None,
            db_endpoint_id: Optional[pulumi.Input[_builtins.str]] = None,
            endpoint_type: Optional[pulumi.Input[_builtins.str]] = None,
            net_type: Optional[pulumi.Input[_builtins.str]] = None,
            port: Optional[pulumi.Input[_builtins.str]] = None,
            ssl_auto_rotate: Optional[pulumi.Input[_builtins.str]] = None,
            ssl_certificate_url: Optional[pulumi.Input[_builtins.str]] = None,
            ssl_connection_string: Optional[pulumi.Input[_builtins.str]] = None,
            ssl_enabled: Optional[pulumi.Input[_builtins.str]] = None,
            ssl_expire_time: Optional[pulumi.Input[_builtins.str]] = None) -> 'PrimaryEndpoint':
        """
        Get an existing PrimaryEndpoint resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] connection_prefix: Prefix of the specified endpoint. The prefix must be 6 to 30 characters in length, and can contain lowercase letters, digits, and hyphens (-), must start with a letter and end with a digit or letter.
        :param pulumi.Input[_builtins.str] db_cluster_id: The Id of cluster that can run database.
        :param pulumi.Input[_builtins.str] db_endpoint_description: The name of the endpoint.
        :param pulumi.Input[_builtins.str] db_endpoint_id: The ID of the cluster endpoint.
        :param pulumi.Input[_builtins.str] endpoint_type: Type of endpoint.
        :param pulumi.Input[_builtins.str] net_type: The network type of the endpoint address.
        :param pulumi.Input[_builtins.str] port: Port of the specified endpoint. Valid values: 3000 to 5999.
        :param pulumi.Input[_builtins.str] ssl_auto_rotate: Specifies whether automatic rotation of SSL certificates is enabled. Valid values: `Enable`,`Disable`.
               **NOTE:** For a PolarDB for MySQL cluster, this parameter is required, and only one connection string in each endpoint can enable the ssl, for other notes, see [Configure SSL encryption](https://www.alibabacloud.com/help/doc-detail/153182.htm).
               For a PolarDB for PostgreSQL cluster or a PolarDB-O cluster, this parameter is not required, by default, SSL encryption is enabled for all endpoints.
        :param pulumi.Input[_builtins.str] ssl_certificate_url: The specifies SSL certificate download link.
        :param pulumi.Input[_builtins.str] ssl_connection_string: The SSL connection string.
        :param pulumi.Input[_builtins.str] ssl_enabled: Specifies how to modify the SSL encryption status. Valid values: `Disable`, `Enable`, `Update`.
        :param pulumi.Input[_builtins.str] ssl_expire_time: The time when the SSL certificate expires. The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PrimaryEndpointState.__new__(_PrimaryEndpointState)

        __props__.__dict__["connection_prefix"] = connection_prefix
        __props__.__dict__["db_cluster_id"] = db_cluster_id
        __props__.__dict__["db_endpoint_description"] = db_endpoint_description
        __props__.__dict__["db_endpoint_id"] = db_endpoint_id
        __props__.__dict__["endpoint_type"] = endpoint_type
        __props__.__dict__["net_type"] = net_type
        __props__.__dict__["port"] = port
        __props__.__dict__["ssl_auto_rotate"] = ssl_auto_rotate
        __props__.__dict__["ssl_certificate_url"] = ssl_certificate_url
        __props__.__dict__["ssl_connection_string"] = ssl_connection_string
        __props__.__dict__["ssl_enabled"] = ssl_enabled
        __props__.__dict__["ssl_expire_time"] = ssl_expire_time
        return PrimaryEndpoint(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="connectionPrefix")
    def connection_prefix(self) -> pulumi.Output[_builtins.str]:
        """
        Prefix of the specified endpoint. The prefix must be 6 to 30 characters in length, and can contain lowercase letters, digits, and hyphens (-), must start with a letter and end with a digit or letter.
        """
        return pulumi.get(self, "connection_prefix")

    @_builtins.property
    @pulumi.getter(name="dbClusterId")
    def db_cluster_id(self) -> pulumi.Output[_builtins.str]:
        """
        The Id of cluster that can run database.
        """
        return pulumi.get(self, "db_cluster_id")

    @_builtins.property
    @pulumi.getter(name="dbEndpointDescription")
    def db_endpoint_description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of the endpoint.
        """
        return pulumi.get(self, "db_endpoint_description")

    @_builtins.property
    @pulumi.getter(name="dbEndpointId")
    def db_endpoint_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the cluster endpoint.
        """
        return pulumi.get(self, "db_endpoint_id")

    @_builtins.property
    @pulumi.getter(name="endpointType")
    def endpoint_type(self) -> pulumi.Output[_builtins.str]:
        """
        Type of endpoint.
        """
        return pulumi.get(self, "endpoint_type")

    @_builtins.property
    @pulumi.getter(name="netType")
    def net_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The network type of the endpoint address.
        """
        return pulumi.get(self, "net_type")

    @_builtins.property
    @pulumi.getter
    def port(self) -> pulumi.Output[_builtins.str]:
        """
        Port of the specified endpoint. Valid values: 3000 to 5999.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="sslAutoRotate")
    def ssl_auto_rotate(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies whether automatic rotation of SSL certificates is enabled. Valid values: `Enable`,`Disable`.
        **NOTE:** For a PolarDB for MySQL cluster, this parameter is required, and only one connection string in each endpoint can enable the ssl, for other notes, see [Configure SSL encryption](https://www.alibabacloud.com/help/doc-detail/153182.htm).
        For a PolarDB for PostgreSQL cluster or a PolarDB-O cluster, this parameter is not required, by default, SSL encryption is enabled for all endpoints.
        """
        return pulumi.get(self, "ssl_auto_rotate")

    @_builtins.property
    @pulumi.getter(name="sslCertificateUrl")
    def ssl_certificate_url(self) -> pulumi.Output[_builtins.str]:
        """
        The specifies SSL certificate download link.
        """
        return pulumi.get(self, "ssl_certificate_url")

    @_builtins.property
    @pulumi.getter(name="sslConnectionString")
    def ssl_connection_string(self) -> pulumi.Output[_builtins.str]:
        """
        The SSL connection string.
        """
        return pulumi.get(self, "ssl_connection_string")

    @_builtins.property
    @pulumi.getter(name="sslEnabled")
    def ssl_enabled(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies how to modify the SSL encryption status. Valid values: `Disable`, `Enable`, `Update`.
        """
        return pulumi.get(self, "ssl_enabled")

    @_builtins.property
    @pulumi.getter(name="sslExpireTime")
    def ssl_expire_time(self) -> pulumi.Output[_builtins.str]:
        """
        The time when the SSL certificate expires. The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC.
        """
        return pulumi.get(self, "ssl_expire_time")

