# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetVpcEndpointsResult',
    'AwaitableGetVpcEndpointsResult',
    'get_vpc_endpoints',
    'get_vpc_endpoints_output',
]

@pulumi.output_type
class GetVpcEndpointsResult:
    """
    A collection of values returned by getVpcEndpoints.
    """
    def __init__(__self__, connection_status=None, enable_details=None, endpoints=None, id=None, ids=None, name_regex=None, names=None, output_file=None, service_name=None, status=None, tags=None, vpc_endpoint_name=None, vpc_id=None):
        if connection_status and not isinstance(connection_status, str):
            raise TypeError("Expected argument 'connection_status' to be a str")
        pulumi.set(__self__, "connection_status", connection_status)
        if enable_details and not isinstance(enable_details, bool):
            raise TypeError("Expected argument 'enable_details' to be a bool")
        pulumi.set(__self__, "enable_details", enable_details)
        if endpoints and not isinstance(endpoints, list):
            raise TypeError("Expected argument 'endpoints' to be a list")
        pulumi.set(__self__, "endpoints", endpoints)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if names and not isinstance(names, list):
            raise TypeError("Expected argument 'names' to be a list")
        pulumi.set(__self__, "names", names)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if service_name and not isinstance(service_name, str):
            raise TypeError("Expected argument 'service_name' to be a str")
        pulumi.set(__self__, "service_name", service_name)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if vpc_endpoint_name and not isinstance(vpc_endpoint_name, str):
            raise TypeError("Expected argument 'vpc_endpoint_name' to be a str")
        pulumi.set(__self__, "vpc_endpoint_name", vpc_endpoint_name)
        if vpc_id and not isinstance(vpc_id, str):
            raise TypeError("Expected argument 'vpc_id' to be a str")
        pulumi.set(__self__, "vpc_id", vpc_id)

    @_builtins.property
    @pulumi.getter(name="connectionStatus")
    def connection_status(self) -> Optional[_builtins.str]:
        """
        The status of Connection.
        """
        return pulumi.get(self, "connection_status")

    @_builtins.property
    @pulumi.getter(name="enableDetails")
    def enable_details(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "enable_details")

    @_builtins.property
    @pulumi.getter
    def endpoints(self) -> Sequence['outputs.GetVpcEndpointsEndpointResult']:
        """
        A list of Privatelink Vpc Endpoints. Each element contains the following attributes:
        """
        return pulumi.get(self, "endpoints")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "name_regex")

    @_builtins.property
    @pulumi.getter
    def names(self) -> Sequence[_builtins.str]:
        """
        A list of Vpc Endpoint names.
        """
        return pulumi.get(self, "names")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[_builtins.str]:
        """
        The name of the terminal node service associated with the terminal node.
        """
        return pulumi.get(self, "service_name")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        The status of Vpc Endpoint.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Tag tags of Vpc Endpoint.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="vpcEndpointName")
    def vpc_endpoint_name(self) -> Optional[_builtins.str]:
        """
        The name of Vpc Endpoint.
        """
        return pulumi.get(self, "vpc_endpoint_name")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[_builtins.str]:
        """
        The private network to which the terminal node belongs.
        """
        return pulumi.get(self, "vpc_id")


class AwaitableGetVpcEndpointsResult(GetVpcEndpointsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVpcEndpointsResult(
            connection_status=self.connection_status,
            enable_details=self.enable_details,
            endpoints=self.endpoints,
            id=self.id,
            ids=self.ids,
            name_regex=self.name_regex,
            names=self.names,
            output_file=self.output_file,
            service_name=self.service_name,
            status=self.status,
            tags=self.tags,
            vpc_endpoint_name=self.vpc_endpoint_name,
            vpc_id=self.vpc_id)


def get_vpc_endpoints(connection_status: Optional[_builtins.str] = None,
                      enable_details: Optional[_builtins.bool] = None,
                      ids: Optional[Sequence[_builtins.str]] = None,
                      name_regex: Optional[_builtins.str] = None,
                      output_file: Optional[_builtins.str] = None,
                      service_name: Optional[_builtins.str] = None,
                      status: Optional[_builtins.str] = None,
                      tags: Optional[Mapping[str, _builtins.str]] = None,
                      vpc_endpoint_name: Optional[_builtins.str] = None,
                      vpc_id: Optional[_builtins.str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVpcEndpointsResult:
    """
    This data source provides the Privatelink Vpc Endpoints of the current Alibaba Cloud user.

    > **NOTE:** Available since v1.109.0.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    example = alicloud.privatelink.get_vpc_endpoints(ids=["example_value"],
        name_regex="the_resource_name")
    pulumi.export("firstPrivatelinkVpcEndpointId", example.endpoints[0].id)
    ```


    :param _builtins.str connection_status: The status of Connection.
    :param _builtins.bool enable_details: Default to `false`. Set it to `true` can output more details about resource attributes.
    :param Sequence[_builtins.str] ids: A list of Vpc Endpoint IDs.
    :param _builtins.str name_regex: A regex string to filter results by Vpc Endpoint name.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str service_name: The name of the terminal node service associated with the terminal node.
    :param _builtins.str status: The status of Vpc Endpoint.
    :param Mapping[str, _builtins.str] tags: Query the instance bound to the tag. The format of the incoming value is `json` string, including `TagKey` and `TagValue`. `TagKey` cannot be null, and `TagValue` can be empty. Format example `{"key1":"value1"}`.
    :param _builtins.str vpc_endpoint_name: The name of Vpc Endpoint.
    :param _builtins.str vpc_id: The private network to which the terminal node belongs..
    """
    __args__ = dict()
    __args__['connectionStatus'] = connection_status
    __args__['enableDetails'] = enable_details
    __args__['ids'] = ids
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['serviceName'] = service_name
    __args__['status'] = status
    __args__['tags'] = tags
    __args__['vpcEndpointName'] = vpc_endpoint_name
    __args__['vpcId'] = vpc_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:privatelink/getVpcEndpoints:getVpcEndpoints', __args__, opts=opts, typ=GetVpcEndpointsResult).value

    return AwaitableGetVpcEndpointsResult(
        connection_status=pulumi.get(__ret__, 'connection_status'),
        enable_details=pulumi.get(__ret__, 'enable_details'),
        endpoints=pulumi.get(__ret__, 'endpoints'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        names=pulumi.get(__ret__, 'names'),
        output_file=pulumi.get(__ret__, 'output_file'),
        service_name=pulumi.get(__ret__, 'service_name'),
        status=pulumi.get(__ret__, 'status'),
        tags=pulumi.get(__ret__, 'tags'),
        vpc_endpoint_name=pulumi.get(__ret__, 'vpc_endpoint_name'),
        vpc_id=pulumi.get(__ret__, 'vpc_id'))
def get_vpc_endpoints_output(connection_status: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             enable_details: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                             ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                             name_regex: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             service_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             status: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             tags: Optional[pulumi.Input[Optional[Mapping[str, _builtins.str]]]] = None,
                             vpc_endpoint_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             vpc_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetVpcEndpointsResult]:
    """
    This data source provides the Privatelink Vpc Endpoints of the current Alibaba Cloud user.

    > **NOTE:** Available since v1.109.0.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    example = alicloud.privatelink.get_vpc_endpoints(ids=["example_value"],
        name_regex="the_resource_name")
    pulumi.export("firstPrivatelinkVpcEndpointId", example.endpoints[0].id)
    ```


    :param _builtins.str connection_status: The status of Connection.
    :param _builtins.bool enable_details: Default to `false`. Set it to `true` can output more details about resource attributes.
    :param Sequence[_builtins.str] ids: A list of Vpc Endpoint IDs.
    :param _builtins.str name_regex: A regex string to filter results by Vpc Endpoint name.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str service_name: The name of the terminal node service associated with the terminal node.
    :param _builtins.str status: The status of Vpc Endpoint.
    :param Mapping[str, _builtins.str] tags: Query the instance bound to the tag. The format of the incoming value is `json` string, including `TagKey` and `TagValue`. `TagKey` cannot be null, and `TagValue` can be empty. Format example `{"key1":"value1"}`.
    :param _builtins.str vpc_endpoint_name: The name of Vpc Endpoint.
    :param _builtins.str vpc_id: The private network to which the terminal node belongs..
    """
    __args__ = dict()
    __args__['connectionStatus'] = connection_status
    __args__['enableDetails'] = enable_details
    __args__['ids'] = ids
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['serviceName'] = service_name
    __args__['status'] = status
    __args__['tags'] = tags
    __args__['vpcEndpointName'] = vpc_endpoint_name
    __args__['vpcId'] = vpc_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:privatelink/getVpcEndpoints:getVpcEndpoints', __args__, opts=opts, typ=GetVpcEndpointsResult)
    return __ret__.apply(lambda __response__: GetVpcEndpointsResult(
        connection_status=pulumi.get(__response__, 'connection_status'),
        enable_details=pulumi.get(__response__, 'enable_details'),
        endpoints=pulumi.get(__response__, 'endpoints'),
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        name_regex=pulumi.get(__response__, 'name_regex'),
        names=pulumi.get(__response__, 'names'),
        output_file=pulumi.get(__response__, 'output_file'),
        service_name=pulumi.get(__response__, 'service_name'),
        status=pulumi.get(__response__, 'status'),
        tags=pulumi.get(__response__, 'tags'),
        vpc_endpoint_name=pulumi.get(__response__, 'vpc_endpoint_name'),
        vpc_id=pulumi.get(__response__, 'vpc_id')))
