# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['VpcEndpointServiceArgs', 'VpcEndpointService']

@pulumi.input_type
class VpcEndpointServiceArgs:
    def __init__(__self__, *,
                 address_ip_version: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_accept_connection: Optional[pulumi.Input[_builtins.bool]] = None,
                 connect_bandwidth: Optional[pulumi.Input[_builtins.int]] = None,
                 dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
                 payer: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 service_description: Optional[pulumi.Input[_builtins.str]] = None,
                 service_resource_type: Optional[pulumi.Input[_builtins.str]] = None,
                 service_support_ipv6: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 zone_affinity_enabled: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a VpcEndpointService resource.
        :param pulumi.Input[_builtins.str] address_ip_version: The IP address version.
        :param pulumi.Input[_builtins.bool] auto_accept_connection: Indicates whether the endpoint service automatically accepts endpoint connection requests. Valid values:
        :param pulumi.Input[_builtins.int] connect_bandwidth: The default bandwidth of the endpoint connection. Valid values: 100 to 10240. Unit: Mbit/s.
        :param pulumi.Input[_builtins.bool] dry_run: Specifies whether to perform only a dry run, without performing the actual request.
        :param pulumi.Input[_builtins.str] payer: The payer of the endpoint service. Valid values:
               - `Endpoint`: the service consumer.
               - `EndpointService`: the service provider.
        :param pulumi.Input[_builtins.str] resource_group_id: The resource group ID.
        :param pulumi.Input[_builtins.str] service_description: The description of the endpoint service.
        :param pulumi.Input[_builtins.str] service_resource_type: Service resource type, value:
        :param pulumi.Input[_builtins.bool] service_support_ipv6: Specifies whether to enable IPv6 for the endpoint service. Valid values:
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The list of tags.
        :param pulumi.Input[_builtins.bool] zone_affinity_enabled: Specifies whether to first resolve the domain name of the nearest endpoint that is associated with the endpoint service. Valid values:
        """
        if address_ip_version is not None:
            pulumi.set(__self__, "address_ip_version", address_ip_version)
        if auto_accept_connection is not None:
            pulumi.set(__self__, "auto_accept_connection", auto_accept_connection)
        if connect_bandwidth is not None:
            pulumi.set(__self__, "connect_bandwidth", connect_bandwidth)
        if dry_run is not None:
            pulumi.set(__self__, "dry_run", dry_run)
        if payer is not None:
            pulumi.set(__self__, "payer", payer)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if service_description is not None:
            pulumi.set(__self__, "service_description", service_description)
        if service_resource_type is not None:
            pulumi.set(__self__, "service_resource_type", service_resource_type)
        if service_support_ipv6 is not None:
            pulumi.set(__self__, "service_support_ipv6", service_support_ipv6)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if zone_affinity_enabled is not None:
            pulumi.set(__self__, "zone_affinity_enabled", zone_affinity_enabled)

    @_builtins.property
    @pulumi.getter(name="addressIpVersion")
    def address_ip_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IP address version.
        """
        return pulumi.get(self, "address_ip_version")

    @address_ip_version.setter
    def address_ip_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "address_ip_version", value)

    @_builtins.property
    @pulumi.getter(name="autoAcceptConnection")
    def auto_accept_connection(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether the endpoint service automatically accepts endpoint connection requests. Valid values:
        """
        return pulumi.get(self, "auto_accept_connection")

    @auto_accept_connection.setter
    def auto_accept_connection(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_accept_connection", value)

    @_builtins.property
    @pulumi.getter(name="connectBandwidth")
    def connect_bandwidth(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The default bandwidth of the endpoint connection. Valid values: 100 to 10240. Unit: Mbit/s.
        """
        return pulumi.get(self, "connect_bandwidth")

    @connect_bandwidth.setter
    def connect_bandwidth(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "connect_bandwidth", value)

    @_builtins.property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to perform only a dry run, without performing the actual request.
        """
        return pulumi.get(self, "dry_run")

    @dry_run.setter
    def dry_run(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "dry_run", value)

    @_builtins.property
    @pulumi.getter
    def payer(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The payer of the endpoint service. Valid values:
        - `Endpoint`: the service consumer.
        - `EndpointService`: the service provider.
        """
        return pulumi.get(self, "payer")

    @payer.setter
    def payer(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "payer", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource group ID.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter(name="serviceDescription")
    def service_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the endpoint service.
        """
        return pulumi.get(self, "service_description")

    @service_description.setter
    def service_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_description", value)

    @_builtins.property
    @pulumi.getter(name="serviceResourceType")
    def service_resource_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Service resource type, value:
        """
        return pulumi.get(self, "service_resource_type")

    @service_resource_type.setter
    def service_resource_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_resource_type", value)

    @_builtins.property
    @pulumi.getter(name="serviceSupportIpv6")
    def service_support_ipv6(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable IPv6 for the endpoint service. Valid values:
        """
        return pulumi.get(self, "service_support_ipv6")

    @service_support_ipv6.setter
    def service_support_ipv6(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "service_support_ipv6", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The list of tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="zoneAffinityEnabled")
    def zone_affinity_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to first resolve the domain name of the nearest endpoint that is associated with the endpoint service. Valid values:
        """
        return pulumi.get(self, "zone_affinity_enabled")

    @zone_affinity_enabled.setter
    def zone_affinity_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "zone_affinity_enabled", value)


@pulumi.input_type
class _VpcEndpointServiceState:
    def __init__(__self__, *,
                 address_ip_version: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_accept_connection: Optional[pulumi.Input[_builtins.bool]] = None,
                 connect_bandwidth: Optional[pulumi.Input[_builtins.int]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
                 payer: Optional[pulumi.Input[_builtins.str]] = None,
                 region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 service_business_status: Optional[pulumi.Input[_builtins.str]] = None,
                 service_description: Optional[pulumi.Input[_builtins.str]] = None,
                 service_domain: Optional[pulumi.Input[_builtins.str]] = None,
                 service_resource_type: Optional[pulumi.Input[_builtins.str]] = None,
                 service_support_ipv6: Optional[pulumi.Input[_builtins.bool]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc_endpoint_service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_affinity_enabled: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering VpcEndpointService resources.
        :param pulumi.Input[_builtins.str] address_ip_version: The IP address version.
        :param pulumi.Input[_builtins.bool] auto_accept_connection: Indicates whether the endpoint service automatically accepts endpoint connection requests. Valid values:
        :param pulumi.Input[_builtins.int] connect_bandwidth: The default bandwidth of the endpoint connection. Valid values: 100 to 10240. Unit: Mbit/s.
        :param pulumi.Input[_builtins.str] create_time: The time when the endpoint service was created.
        :param pulumi.Input[_builtins.bool] dry_run: Specifies whether to perform only a dry run, without performing the actual request.
        :param pulumi.Input[_builtins.str] payer: The payer of the endpoint service. Valid values:
               - `Endpoint`: the service consumer.
               - `EndpointService`: the service provider.
        :param pulumi.Input[_builtins.str] region_id: (Available since v1.235.0) The ID of the region to which the endpoint service belongs.
        :param pulumi.Input[_builtins.str] resource_group_id: The resource group ID.
        :param pulumi.Input[_builtins.str] service_business_status: The service state of the endpoint service.
        :param pulumi.Input[_builtins.str] service_description: The description of the endpoint service.
        :param pulumi.Input[_builtins.str] service_domain: The domain name of the endpoint service.
        :param pulumi.Input[_builtins.str] service_resource_type: Service resource type, value:
        :param pulumi.Input[_builtins.bool] service_support_ipv6: Specifies whether to enable IPv6 for the endpoint service. Valid values:
        :param pulumi.Input[_builtins.str] status: The state of the endpoint service.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The list of tags.
        :param pulumi.Input[_builtins.str] vpc_endpoint_service_name: The name of the endpoint service.
        :param pulumi.Input[_builtins.bool] zone_affinity_enabled: Specifies whether to first resolve the domain name of the nearest endpoint that is associated with the endpoint service. Valid values:
        """
        if address_ip_version is not None:
            pulumi.set(__self__, "address_ip_version", address_ip_version)
        if auto_accept_connection is not None:
            pulumi.set(__self__, "auto_accept_connection", auto_accept_connection)
        if connect_bandwidth is not None:
            pulumi.set(__self__, "connect_bandwidth", connect_bandwidth)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if dry_run is not None:
            pulumi.set(__self__, "dry_run", dry_run)
        if payer is not None:
            pulumi.set(__self__, "payer", payer)
        if region_id is not None:
            pulumi.set(__self__, "region_id", region_id)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if service_business_status is not None:
            pulumi.set(__self__, "service_business_status", service_business_status)
        if service_description is not None:
            pulumi.set(__self__, "service_description", service_description)
        if service_domain is not None:
            pulumi.set(__self__, "service_domain", service_domain)
        if service_resource_type is not None:
            pulumi.set(__self__, "service_resource_type", service_resource_type)
        if service_support_ipv6 is not None:
            pulumi.set(__self__, "service_support_ipv6", service_support_ipv6)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if vpc_endpoint_service_name is not None:
            pulumi.set(__self__, "vpc_endpoint_service_name", vpc_endpoint_service_name)
        if zone_affinity_enabled is not None:
            pulumi.set(__self__, "zone_affinity_enabled", zone_affinity_enabled)

    @_builtins.property
    @pulumi.getter(name="addressIpVersion")
    def address_ip_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IP address version.
        """
        return pulumi.get(self, "address_ip_version")

    @address_ip_version.setter
    def address_ip_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "address_ip_version", value)

    @_builtins.property
    @pulumi.getter(name="autoAcceptConnection")
    def auto_accept_connection(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether the endpoint service automatically accepts endpoint connection requests. Valid values:
        """
        return pulumi.get(self, "auto_accept_connection")

    @auto_accept_connection.setter
    def auto_accept_connection(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_accept_connection", value)

    @_builtins.property
    @pulumi.getter(name="connectBandwidth")
    def connect_bandwidth(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The default bandwidth of the endpoint connection. Valid values: 100 to 10240. Unit: Mbit/s.
        """
        return pulumi.get(self, "connect_bandwidth")

    @connect_bandwidth.setter
    def connect_bandwidth(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "connect_bandwidth", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time when the endpoint service was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to perform only a dry run, without performing the actual request.
        """
        return pulumi.get(self, "dry_run")

    @dry_run.setter
    def dry_run(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "dry_run", value)

    @_builtins.property
    @pulumi.getter
    def payer(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The payer of the endpoint service. Valid values:
        - `Endpoint`: the service consumer.
        - `EndpointService`: the service provider.
        """
        return pulumi.get(self, "payer")

    @payer.setter
    def payer(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "payer", value)

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Available since v1.235.0) The ID of the region to which the endpoint service belongs.
        """
        return pulumi.get(self, "region_id")

    @region_id.setter
    def region_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region_id", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource group ID.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter(name="serviceBusinessStatus")
    def service_business_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The service state of the endpoint service.
        """
        return pulumi.get(self, "service_business_status")

    @service_business_status.setter
    def service_business_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_business_status", value)

    @_builtins.property
    @pulumi.getter(name="serviceDescription")
    def service_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the endpoint service.
        """
        return pulumi.get(self, "service_description")

    @service_description.setter
    def service_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_description", value)

    @_builtins.property
    @pulumi.getter(name="serviceDomain")
    def service_domain(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The domain name of the endpoint service.
        """
        return pulumi.get(self, "service_domain")

    @service_domain.setter
    def service_domain(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_domain", value)

    @_builtins.property
    @pulumi.getter(name="serviceResourceType")
    def service_resource_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Service resource type, value:
        """
        return pulumi.get(self, "service_resource_type")

    @service_resource_type.setter
    def service_resource_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_resource_type", value)

    @_builtins.property
    @pulumi.getter(name="serviceSupportIpv6")
    def service_support_ipv6(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable IPv6 for the endpoint service. Valid values:
        """
        return pulumi.get(self, "service_support_ipv6")

    @service_support_ipv6.setter
    def service_support_ipv6(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "service_support_ipv6", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The state of the endpoint service.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The list of tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="vpcEndpointServiceName")
    def vpc_endpoint_service_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the endpoint service.
        """
        return pulumi.get(self, "vpc_endpoint_service_name")

    @vpc_endpoint_service_name.setter
    def vpc_endpoint_service_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_endpoint_service_name", value)

    @_builtins.property
    @pulumi.getter(name="zoneAffinityEnabled")
    def zone_affinity_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to first resolve the domain name of the nearest endpoint that is associated with the endpoint service. Valid values:
        """
        return pulumi.get(self, "zone_affinity_enabled")

    @zone_affinity_enabled.setter
    def zone_affinity_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "zone_affinity_enabled", value)


@pulumi.type_token("alicloud:privatelink/vpcEndpointService:VpcEndpointService")
class VpcEndpointService(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 address_ip_version: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_accept_connection: Optional[pulumi.Input[_builtins.bool]] = None,
                 connect_bandwidth: Optional[pulumi.Input[_builtins.int]] = None,
                 dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
                 payer: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 service_description: Optional[pulumi.Input[_builtins.str]] = None,
                 service_resource_type: Optional[pulumi.Input[_builtins.str]] = None,
                 service_support_ipv6: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 zone_affinity_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        Provides a Private Link Vpc Endpoint Service resource.

        For information about Private Link Vpc Endpoint Service and how to use it, see [What is Vpc Endpoint Service](https://www.alibabacloud.com/help/en/privatelink/latest/api-privatelink-2020-04-15-createvpcendpointservice).

        > **NOTE:** Available since v1.109.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf_example"
        example = alicloud.privatelink.VpcEndpointService("example",
            service_description=name,
            connect_bandwidth=103,
            auto_accept_connection=False)
        ```

        ## Import

        Private Link Vpc Endpoint Service can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:privatelink/vpcEndpointService:VpcEndpointService example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] address_ip_version: The IP address version.
        :param pulumi.Input[_builtins.bool] auto_accept_connection: Indicates whether the endpoint service automatically accepts endpoint connection requests. Valid values:
        :param pulumi.Input[_builtins.int] connect_bandwidth: The default bandwidth of the endpoint connection. Valid values: 100 to 10240. Unit: Mbit/s.
        :param pulumi.Input[_builtins.bool] dry_run: Specifies whether to perform only a dry run, without performing the actual request.
        :param pulumi.Input[_builtins.str] payer: The payer of the endpoint service. Valid values:
               - `Endpoint`: the service consumer.
               - `EndpointService`: the service provider.
        :param pulumi.Input[_builtins.str] resource_group_id: The resource group ID.
        :param pulumi.Input[_builtins.str] service_description: The description of the endpoint service.
        :param pulumi.Input[_builtins.str] service_resource_type: Service resource type, value:
        :param pulumi.Input[_builtins.bool] service_support_ipv6: Specifies whether to enable IPv6 for the endpoint service. Valid values:
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The list of tags.
        :param pulumi.Input[_builtins.bool] zone_affinity_enabled: Specifies whether to first resolve the domain name of the nearest endpoint that is associated with the endpoint service. Valid values:
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[VpcEndpointServiceArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Private Link Vpc Endpoint Service resource.

        For information about Private Link Vpc Endpoint Service and how to use it, see [What is Vpc Endpoint Service](https://www.alibabacloud.com/help/en/privatelink/latest/api-privatelink-2020-04-15-createvpcendpointservice).

        > **NOTE:** Available since v1.109.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf_example"
        example = alicloud.privatelink.VpcEndpointService("example",
            service_description=name,
            connect_bandwidth=103,
            auto_accept_connection=False)
        ```

        ## Import

        Private Link Vpc Endpoint Service can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:privatelink/vpcEndpointService:VpcEndpointService example <id>
        ```

        :param str resource_name: The name of the resource.
        :param VpcEndpointServiceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VpcEndpointServiceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 address_ip_version: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_accept_connection: Optional[pulumi.Input[_builtins.bool]] = None,
                 connect_bandwidth: Optional[pulumi.Input[_builtins.int]] = None,
                 dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
                 payer: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 service_description: Optional[pulumi.Input[_builtins.str]] = None,
                 service_resource_type: Optional[pulumi.Input[_builtins.str]] = None,
                 service_support_ipv6: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 zone_affinity_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VpcEndpointServiceArgs.__new__(VpcEndpointServiceArgs)

            __props__.__dict__["address_ip_version"] = address_ip_version
            __props__.__dict__["auto_accept_connection"] = auto_accept_connection
            __props__.__dict__["connect_bandwidth"] = connect_bandwidth
            __props__.__dict__["dry_run"] = dry_run
            __props__.__dict__["payer"] = payer
            __props__.__dict__["resource_group_id"] = resource_group_id
            __props__.__dict__["service_description"] = service_description
            __props__.__dict__["service_resource_type"] = service_resource_type
            __props__.__dict__["service_support_ipv6"] = service_support_ipv6
            __props__.__dict__["tags"] = tags
            __props__.__dict__["zone_affinity_enabled"] = zone_affinity_enabled
            __props__.__dict__["create_time"] = None
            __props__.__dict__["region_id"] = None
            __props__.__dict__["service_business_status"] = None
            __props__.__dict__["service_domain"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["vpc_endpoint_service_name"] = None
        super(VpcEndpointService, __self__).__init__(
            'alicloud:privatelink/vpcEndpointService:VpcEndpointService',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            address_ip_version: Optional[pulumi.Input[_builtins.str]] = None,
            auto_accept_connection: Optional[pulumi.Input[_builtins.bool]] = None,
            connect_bandwidth: Optional[pulumi.Input[_builtins.int]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
            payer: Optional[pulumi.Input[_builtins.str]] = None,
            region_id: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            service_business_status: Optional[pulumi.Input[_builtins.str]] = None,
            service_description: Optional[pulumi.Input[_builtins.str]] = None,
            service_domain: Optional[pulumi.Input[_builtins.str]] = None,
            service_resource_type: Optional[pulumi.Input[_builtins.str]] = None,
            service_support_ipv6: Optional[pulumi.Input[_builtins.bool]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            vpc_endpoint_service_name: Optional[pulumi.Input[_builtins.str]] = None,
            zone_affinity_enabled: Optional[pulumi.Input[_builtins.bool]] = None) -> 'VpcEndpointService':
        """
        Get an existing VpcEndpointService resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] address_ip_version: The IP address version.
        :param pulumi.Input[_builtins.bool] auto_accept_connection: Indicates whether the endpoint service automatically accepts endpoint connection requests. Valid values:
        :param pulumi.Input[_builtins.int] connect_bandwidth: The default bandwidth of the endpoint connection. Valid values: 100 to 10240. Unit: Mbit/s.
        :param pulumi.Input[_builtins.str] create_time: The time when the endpoint service was created.
        :param pulumi.Input[_builtins.bool] dry_run: Specifies whether to perform only a dry run, without performing the actual request.
        :param pulumi.Input[_builtins.str] payer: The payer of the endpoint service. Valid values:
               - `Endpoint`: the service consumer.
               - `EndpointService`: the service provider.
        :param pulumi.Input[_builtins.str] region_id: (Available since v1.235.0) The ID of the region to which the endpoint service belongs.
        :param pulumi.Input[_builtins.str] resource_group_id: The resource group ID.
        :param pulumi.Input[_builtins.str] service_business_status: The service state of the endpoint service.
        :param pulumi.Input[_builtins.str] service_description: The description of the endpoint service.
        :param pulumi.Input[_builtins.str] service_domain: The domain name of the endpoint service.
        :param pulumi.Input[_builtins.str] service_resource_type: Service resource type, value:
        :param pulumi.Input[_builtins.bool] service_support_ipv6: Specifies whether to enable IPv6 for the endpoint service. Valid values:
        :param pulumi.Input[_builtins.str] status: The state of the endpoint service.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The list of tags.
        :param pulumi.Input[_builtins.str] vpc_endpoint_service_name: The name of the endpoint service.
        :param pulumi.Input[_builtins.bool] zone_affinity_enabled: Specifies whether to first resolve the domain name of the nearest endpoint that is associated with the endpoint service. Valid values:
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VpcEndpointServiceState.__new__(_VpcEndpointServiceState)

        __props__.__dict__["address_ip_version"] = address_ip_version
        __props__.__dict__["auto_accept_connection"] = auto_accept_connection
        __props__.__dict__["connect_bandwidth"] = connect_bandwidth
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["dry_run"] = dry_run
        __props__.__dict__["payer"] = payer
        __props__.__dict__["region_id"] = region_id
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["service_business_status"] = service_business_status
        __props__.__dict__["service_description"] = service_description
        __props__.__dict__["service_domain"] = service_domain
        __props__.__dict__["service_resource_type"] = service_resource_type
        __props__.__dict__["service_support_ipv6"] = service_support_ipv6
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["vpc_endpoint_service_name"] = vpc_endpoint_service_name
        __props__.__dict__["zone_affinity_enabled"] = zone_affinity_enabled
        return VpcEndpointService(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="addressIpVersion")
    def address_ip_version(self) -> pulumi.Output[_builtins.str]:
        """
        The IP address version.
        """
        return pulumi.get(self, "address_ip_version")

    @_builtins.property
    @pulumi.getter(name="autoAcceptConnection")
    def auto_accept_connection(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Indicates whether the endpoint service automatically accepts endpoint connection requests. Valid values:
        """
        return pulumi.get(self, "auto_accept_connection")

    @_builtins.property
    @pulumi.getter(name="connectBandwidth")
    def connect_bandwidth(self) -> pulumi.Output[_builtins.int]:
        """
        The default bandwidth of the endpoint connection. Valid values: 100 to 10240. Unit: Mbit/s.
        """
        return pulumi.get(self, "connect_bandwidth")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The time when the endpoint service was created.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether to perform only a dry run, without performing the actual request.
        """
        return pulumi.get(self, "dry_run")

    @_builtins.property
    @pulumi.getter
    def payer(self) -> pulumi.Output[_builtins.str]:
        """
        The payer of the endpoint service. Valid values:
        - `Endpoint`: the service consumer.
        - `EndpointService`: the service provider.
        """
        return pulumi.get(self, "payer")

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> pulumi.Output[_builtins.str]:
        """
        (Available since v1.235.0) The ID of the region to which the endpoint service belongs.
        """
        return pulumi.get(self, "region_id")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The resource group ID.
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter(name="serviceBusinessStatus")
    def service_business_status(self) -> pulumi.Output[_builtins.str]:
        """
        The service state of the endpoint service.
        """
        return pulumi.get(self, "service_business_status")

    @_builtins.property
    @pulumi.getter(name="serviceDescription")
    def service_description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the endpoint service.
        """
        return pulumi.get(self, "service_description")

    @_builtins.property
    @pulumi.getter(name="serviceDomain")
    def service_domain(self) -> pulumi.Output[_builtins.str]:
        """
        The domain name of the endpoint service.
        """
        return pulumi.get(self, "service_domain")

    @_builtins.property
    @pulumi.getter(name="serviceResourceType")
    def service_resource_type(self) -> pulumi.Output[_builtins.str]:
        """
        Service resource type, value:
        """
        return pulumi.get(self, "service_resource_type")

    @_builtins.property
    @pulumi.getter(name="serviceSupportIpv6")
    def service_support_ipv6(self) -> pulumi.Output[_builtins.bool]:
        """
        Specifies whether to enable IPv6 for the endpoint service. Valid values:
        """
        return pulumi.get(self, "service_support_ipv6")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The state of the endpoint service.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        The list of tags.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="vpcEndpointServiceName")
    def vpc_endpoint_service_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the endpoint service.
        """
        return pulumi.get(self, "vpc_endpoint_service_name")

    @_builtins.property
    @pulumi.getter(name="zoneAffinityEnabled")
    def zone_affinity_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Specifies whether to first resolve the domain name of the nearest endpoint that is associated with the endpoint service. Valid values:
        """
        return pulumi.get(self, "zone_affinity_enabled")

