# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'ApplicationInfoDimension',
    'QuotaAlarmQuotaDimension',
    'QuotaApplicationDimension',
    'TemplateApplicationsDimension',
    'TemplateApplicationsQuotaApplicationDetail',
    'TemplateApplicationsQuotaApplicationDetailPeriod',
    'TemplateQuotaDimension',
    'GetApplicationInfosApplicationResult',
    'GetApplicationInfosApplicationDimensionResult',
    'GetApplicationInfosDimensionResult',
    'GetQuotaAlarmsAlarmResult',
    'GetQuotaAlarmsAlarmQuotaDimensionResult',
    'GetQuotaAlarmsQuotaDimensionResult',
    'GetQuotaApplicationsApplicationResult',
    'GetQuotaApplicationsApplicationDimensionResult',
    'GetQuotaApplicationsDimensionResult',
    'GetQuotasDimensionResult',
    'GetQuotasQuotaResult',
    'GetTemplateApplicationsApplicationResult',
    'GetTemplateApplicationsApplicationAuditStatusVoResult',
    'GetTemplateApplicationsApplicationDimensionResult',
]

@pulumi.output_type
class ApplicationInfoDimension(dict):
    def __init__(__self__, *,
                 key: Optional[_builtins.str] = None,
                 value: Optional[_builtins.str] = None):
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "value")


@pulumi.output_type
class QuotaAlarmQuotaDimension(dict):
    def __init__(__self__, *,
                 key: Optional[_builtins.str] = None,
                 value: Optional[_builtins.str] = None):
        """
        :param _builtins.str key: The Key of quota_dimensions.
        :param _builtins.str value: The Value of quota_dimensions.
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> Optional[_builtins.str]:
        """
        The Key of quota_dimensions.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.str]:
        """
        The Value of quota_dimensions.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class QuotaApplicationDimension(dict):
    def __init__(__self__, *,
                 key: Optional[_builtins.str] = None,
                 value: Optional[_builtins.str] = None):
        """
        :param _builtins.str key: The key of the dimension. You must configure `dimensions.N.key` and `dimensions.N.value` at the same time. The value range of N varies based on the number of dimensions that are supported by the related Alibaba Cloud service. You can call the [ListProductQuotaDimensions](https://next.api.aliyun.com/document/quotas/2020-05-10/ListProductQuotaDimensions) operation to query the dimensions that are supported by an Alibaba Cloud service. The number of elements in the returned array is N.
        :param _builtins.str value: The value of the dimension. You must configure `dimensions.N.key` and `dimensions.N.value` at the same time. The value range of N varies based on the number of dimensions that are supported by the related Alibaba Cloud service. You can call the [ListProductQuotaDimensions](https://next.api.aliyun.com/document/quotas/2020-05-10/ListProductQuotaDimensions) operation to query the dimensions that are supported by an Alibaba Cloud service. The number of elements in the returned array is N.
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> Optional[_builtins.str]:
        """
        The key of the dimension. You must configure `dimensions.N.key` and `dimensions.N.value` at the same time. The value range of N varies based on the number of dimensions that are supported by the related Alibaba Cloud service. You can call the [ListProductQuotaDimensions](https://next.api.aliyun.com/document/quotas/2020-05-10/ListProductQuotaDimensions) operation to query the dimensions that are supported by an Alibaba Cloud service. The number of elements in the returned array is N.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.str]:
        """
        The value of the dimension. You must configure `dimensions.N.key` and `dimensions.N.value` at the same time. The value range of N varies based on the number of dimensions that are supported by the related Alibaba Cloud service. You can call the [ListProductQuotaDimensions](https://next.api.aliyun.com/document/quotas/2020-05-10/ListProductQuotaDimensions) operation to query the dimensions that are supported by an Alibaba Cloud service. The number of elements in the returned array is N.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class TemplateApplicationsDimension(dict):
    def __init__(__self__, *,
                 key: Optional[_builtins.str] = None,
                 value: Optional[_builtins.str] = None):
        """
        :param _builtins.str key: Quota dimension Key.
        :param _builtins.str value: Quota dimension Value.
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> Optional[_builtins.str]:
        """
        Quota dimension Key.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.str]:
        """
        Quota dimension Value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class TemplateApplicationsQuotaApplicationDetail(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "aliyunUid":
            suggest = "aliyun_uid"
        elif key == "applicationId":
            suggest = "application_id"
        elif key == "approveValue":
            suggest = "approve_value"
        elif key == "auditReason":
            suggest = "audit_reason"
        elif key == "envLanguage":
            suggest = "env_language"
        elif key == "noticeType":
            suggest = "notice_type"
        elif key == "quotaArn":
            suggest = "quota_arn"
        elif key == "quotaDescription":
            suggest = "quota_description"
        elif key == "quotaName":
            suggest = "quota_name"
        elif key == "quotaUnit":
            suggest = "quota_unit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TemplateApplicationsQuotaApplicationDetail. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TemplateApplicationsQuotaApplicationDetail.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TemplateApplicationsQuotaApplicationDetail.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 aliyun_uid: Optional[_builtins.str] = None,
                 application_id: Optional[_builtins.str] = None,
                 approve_value: Optional[_builtins.float] = None,
                 audit_reason: Optional[_builtins.str] = None,
                 dimensions: Optional[Mapping[str, _builtins.str]] = None,
                 env_language: Optional[_builtins.str] = None,
                 notice_type: Optional[_builtins.int] = None,
                 period: Optional['outputs.TemplateApplicationsQuotaApplicationDetailPeriod'] = None,
                 quota_arn: Optional[_builtins.str] = None,
                 quota_description: Optional[_builtins.str] = None,
                 quota_name: Optional[_builtins.str] = None,
                 quota_unit: Optional[_builtins.str] = None,
                 reason: Optional[_builtins.str] = None,
                 status: Optional[_builtins.str] = None):
        """
        :param _builtins.str aliyun_uid: Alibaba Cloud account (primary account).
        :param _builtins.str application_id: The ID of the quota promotion request.
        :param _builtins.float approve_value: The approved quota value of the quota increase request.
        :param _builtins.str audit_reason: Approval comments on quota increase applications.
        :param Mapping[str, _builtins.str] dimensions: Quota dimension. See `dimensions` below.
        :param _builtins.str env_language: The language of the quota application result notification. Value:
               - zh (default): Chinese.
               - en: English.
        :param _builtins.int notice_type: Whether to send notification of quota application result. Value:
               - 0 (default): No.
               - 3: Yes.
        :param 'TemplateApplicationsQuotaApplicationDetailPeriodArgs' period: Quota calculation period.
        :param _builtins.str quota_arn: Quota ARN.
        :param _builtins.str quota_description: The quota description.
        :param _builtins.str quota_name: The quota name.
        :param _builtins.str quota_unit: Quota unit.
        :param _builtins.str reason: Reason for quota application.
               > **NOTE:**  The quota request is approved by the technical support of each cloud service. If you want to increase the chance of passing, please fill in a reasonable application value and detailed application reasons when applying for quota.
        :param _builtins.str status: The approval status of the quota promotion application. Value:
               - Disagree: reject.
               - Approve: approved.
               - Process: under review.
               - Cancel: Closed.
        """
        if aliyun_uid is not None:
            pulumi.set(__self__, "aliyun_uid", aliyun_uid)
        if application_id is not None:
            pulumi.set(__self__, "application_id", application_id)
        if approve_value is not None:
            pulumi.set(__self__, "approve_value", approve_value)
        if audit_reason is not None:
            pulumi.set(__self__, "audit_reason", audit_reason)
        if dimensions is not None:
            pulumi.set(__self__, "dimensions", dimensions)
        if env_language is not None:
            pulumi.set(__self__, "env_language", env_language)
        if notice_type is not None:
            pulumi.set(__self__, "notice_type", notice_type)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if quota_arn is not None:
            pulumi.set(__self__, "quota_arn", quota_arn)
        if quota_description is not None:
            pulumi.set(__self__, "quota_description", quota_description)
        if quota_name is not None:
            pulumi.set(__self__, "quota_name", quota_name)
        if quota_unit is not None:
            pulumi.set(__self__, "quota_unit", quota_unit)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="aliyunUid")
    def aliyun_uid(self) -> Optional[_builtins.str]:
        """
        Alibaba Cloud account (primary account).
        """
        return pulumi.get(self, "aliyun_uid")

    @_builtins.property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> Optional[_builtins.str]:
        """
        The ID of the quota promotion request.
        """
        return pulumi.get(self, "application_id")

    @_builtins.property
    @pulumi.getter(name="approveValue")
    def approve_value(self) -> Optional[_builtins.float]:
        """
        The approved quota value of the quota increase request.
        """
        return pulumi.get(self, "approve_value")

    @_builtins.property
    @pulumi.getter(name="auditReason")
    def audit_reason(self) -> Optional[_builtins.str]:
        """
        Approval comments on quota increase applications.
        """
        return pulumi.get(self, "audit_reason")

    @_builtins.property
    @pulumi.getter
    def dimensions(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Quota dimension. See `dimensions` below.
        """
        return pulumi.get(self, "dimensions")

    @_builtins.property
    @pulumi.getter(name="envLanguage")
    def env_language(self) -> Optional[_builtins.str]:
        """
        The language of the quota application result notification. Value:
        - zh (default): Chinese.
        - en: English.
        """
        return pulumi.get(self, "env_language")

    @_builtins.property
    @pulumi.getter(name="noticeType")
    def notice_type(self) -> Optional[_builtins.int]:
        """
        Whether to send notification of quota application result. Value:
        - 0 (default): No.
        - 3: Yes.
        """
        return pulumi.get(self, "notice_type")

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional['outputs.TemplateApplicationsQuotaApplicationDetailPeriod']:
        """
        Quota calculation period.
        """
        return pulumi.get(self, "period")

    @_builtins.property
    @pulumi.getter(name="quotaArn")
    def quota_arn(self) -> Optional[_builtins.str]:
        """
        Quota ARN.
        """
        return pulumi.get(self, "quota_arn")

    @_builtins.property
    @pulumi.getter(name="quotaDescription")
    def quota_description(self) -> Optional[_builtins.str]:
        """
        The quota description.
        """
        return pulumi.get(self, "quota_description")

    @_builtins.property
    @pulumi.getter(name="quotaName")
    def quota_name(self) -> Optional[_builtins.str]:
        """
        The quota name.
        """
        return pulumi.get(self, "quota_name")

    @_builtins.property
    @pulumi.getter(name="quotaUnit")
    def quota_unit(self) -> Optional[_builtins.str]:
        """
        Quota unit.
        """
        return pulumi.get(self, "quota_unit")

    @_builtins.property
    @pulumi.getter
    def reason(self) -> Optional[_builtins.str]:
        """
        Reason for quota application.
        > **NOTE:**  The quota request is approved by the technical support of each cloud service. If you want to increase the chance of passing, please fill in a reasonable application value and detailed application reasons when applying for quota.
        """
        return pulumi.get(self, "reason")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        The approval status of the quota promotion application. Value:
        - Disagree: reject.
        - Approve: approved.
        - Process: under review.
        - Cancel: Closed.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class TemplateApplicationsQuotaApplicationDetailPeriod(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "periodUnit":
            suggest = "period_unit"
        elif key == "periodValue":
            suggest = "period_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TemplateApplicationsQuotaApplicationDetailPeriod. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TemplateApplicationsQuotaApplicationDetailPeriod.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TemplateApplicationsQuotaApplicationDetailPeriod.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 period_unit: Optional[_builtins.str] = None,
                 period_value: Optional[_builtins.int] = None):
        """
        :param _builtins.str period_unit: Quota calculation cycle unit.
        :param _builtins.int period_value: The quota calculation period value.
        """
        if period_unit is not None:
            pulumi.set(__self__, "period_unit", period_unit)
        if period_value is not None:
            pulumi.set(__self__, "period_value", period_value)

    @_builtins.property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> Optional[_builtins.str]:
        """
        Quota calculation cycle unit.
        """
        return pulumi.get(self, "period_unit")

    @_builtins.property
    @pulumi.getter(name="periodValue")
    def period_value(self) -> Optional[_builtins.int]:
        """
        The quota calculation period value.
        """
        return pulumi.get(self, "period_value")


@pulumi.output_type
class TemplateQuotaDimension(dict):
    def __init__(__self__, *,
                 key: Optional[_builtins.str] = None,
                 value: Optional[_builtins.str] = None):
        """
        :param _builtins.str key: The Key of quota_dimensions.
        :param _builtins.str value: The Value of quota_dimensions.
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> Optional[_builtins.str]:
        """
        The Key of quota_dimensions.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.str]:
        """
        The Value of quota_dimensions.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetApplicationInfosApplicationResult(dict):
    def __init__(__self__, *,
                 application_id: _builtins.str,
                 approve_value: _builtins.str,
                 audit_reason: _builtins.str,
                 desire_value: _builtins.float,
                 dimensions: Sequence['outputs.GetApplicationInfosApplicationDimensionResult'],
                 effective_time: _builtins.str,
                 expire_time: _builtins.str,
                 id: _builtins.str,
                 notice_type: _builtins.int,
                 product_code: _builtins.str,
                 quota_action_code: _builtins.str,
                 quota_description: _builtins.str,
                 quota_name: _builtins.str,
                 quota_unit: _builtins.str,
                 reason: _builtins.str,
                 status: _builtins.str):
        pulumi.set(__self__, "application_id", application_id)
        pulumi.set(__self__, "approve_value", approve_value)
        pulumi.set(__self__, "audit_reason", audit_reason)
        pulumi.set(__self__, "desire_value", desire_value)
        pulumi.set(__self__, "dimensions", dimensions)
        pulumi.set(__self__, "effective_time", effective_time)
        pulumi.set(__self__, "expire_time", expire_time)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "notice_type", notice_type)
        pulumi.set(__self__, "product_code", product_code)
        pulumi.set(__self__, "quota_action_code", quota_action_code)
        pulumi.set(__self__, "quota_description", quota_description)
        pulumi.set(__self__, "quota_name", quota_name)
        pulumi.set(__self__, "quota_unit", quota_unit)
        pulumi.set(__self__, "reason", reason)
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> _builtins.str:
        return pulumi.get(self, "application_id")

    @_builtins.property
    @pulumi.getter(name="approveValue")
    def approve_value(self) -> _builtins.str:
        return pulumi.get(self, "approve_value")

    @_builtins.property
    @pulumi.getter(name="auditReason")
    def audit_reason(self) -> _builtins.str:
        return pulumi.get(self, "audit_reason")

    @_builtins.property
    @pulumi.getter(name="desireValue")
    def desire_value(self) -> _builtins.float:
        return pulumi.get(self, "desire_value")

    @_builtins.property
    @pulumi.getter
    def dimensions(self) -> Sequence['outputs.GetApplicationInfosApplicationDimensionResult']:
        return pulumi.get(self, "dimensions")

    @_builtins.property
    @pulumi.getter(name="effectiveTime")
    def effective_time(self) -> _builtins.str:
        return pulumi.get(self, "effective_time")

    @_builtins.property
    @pulumi.getter(name="expireTime")
    def expire_time(self) -> _builtins.str:
        return pulumi.get(self, "expire_time")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="noticeType")
    def notice_type(self) -> _builtins.int:
        return pulumi.get(self, "notice_type")

    @_builtins.property
    @pulumi.getter(name="productCode")
    def product_code(self) -> _builtins.str:
        return pulumi.get(self, "product_code")

    @_builtins.property
    @pulumi.getter(name="quotaActionCode")
    def quota_action_code(self) -> _builtins.str:
        return pulumi.get(self, "quota_action_code")

    @_builtins.property
    @pulumi.getter(name="quotaDescription")
    def quota_description(self) -> _builtins.str:
        return pulumi.get(self, "quota_description")

    @_builtins.property
    @pulumi.getter(name="quotaName")
    def quota_name(self) -> _builtins.str:
        return pulumi.get(self, "quota_name")

    @_builtins.property
    @pulumi.getter(name="quotaUnit")
    def quota_unit(self) -> _builtins.str:
        return pulumi.get(self, "quota_unit")

    @_builtins.property
    @pulumi.getter
    def reason(self) -> _builtins.str:
        return pulumi.get(self, "reason")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        return pulumi.get(self, "status")


@pulumi.output_type
class GetApplicationInfosApplicationDimensionResult(dict):
    def __init__(__self__, *,
                 key: _builtins.str,
                 value: _builtins.str):
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        return pulumi.get(self, "value")


@pulumi.output_type
class GetApplicationInfosDimensionResult(dict):
    def __init__(__self__, *,
                 key: Optional[_builtins.str] = None,
                 value: Optional[_builtins.str] = None):
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "value")


@pulumi.output_type
class GetQuotaAlarmsAlarmResult(dict):
    def __init__(__self__, *,
                 alarm_id: _builtins.str,
                 id: _builtins.str,
                 product_code: _builtins.str,
                 quota_action_code: _builtins.str,
                 quota_alarm_name: _builtins.str,
                 quota_dimensions: Sequence['outputs.GetQuotaAlarmsAlarmQuotaDimensionResult'],
                 threshold: _builtins.float,
                 threshold_percent: _builtins.float,
                 web_hook: _builtins.str):
        """
        :param _builtins.str alarm_id: The first ID of the resource.
        :param _builtins.str id: The ID of the Quota Alarm.
        :param _builtins.str product_code: The Product Code.
        :param _builtins.str quota_action_code: The Quota Action Code.
        :param _builtins.str quota_alarm_name: The name of Quota Alarm.
        :param Sequence['GetQuotaAlarmsAlarmQuotaDimensionArgs'] quota_dimensions: The Quota Dimensions.
        :param _builtins.float threshold: The threshold of Quota Alarm.
        :param _builtins.float threshold_percent: The threshold percent of Quota Alarm.
        :param _builtins.str web_hook: The WebHook of Quota Alarm.
        """
        pulumi.set(__self__, "alarm_id", alarm_id)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "product_code", product_code)
        pulumi.set(__self__, "quota_action_code", quota_action_code)
        pulumi.set(__self__, "quota_alarm_name", quota_alarm_name)
        pulumi.set(__self__, "quota_dimensions", quota_dimensions)
        pulumi.set(__self__, "threshold", threshold)
        pulumi.set(__self__, "threshold_percent", threshold_percent)
        pulumi.set(__self__, "web_hook", web_hook)

    @_builtins.property
    @pulumi.getter(name="alarmId")
    def alarm_id(self) -> _builtins.str:
        """
        The first ID of the resource.
        """
        return pulumi.get(self, "alarm_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Quota Alarm.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="productCode")
    def product_code(self) -> _builtins.str:
        """
        The Product Code.
        """
        return pulumi.get(self, "product_code")

    @_builtins.property
    @pulumi.getter(name="quotaActionCode")
    def quota_action_code(self) -> _builtins.str:
        """
        The Quota Action Code.
        """
        return pulumi.get(self, "quota_action_code")

    @_builtins.property
    @pulumi.getter(name="quotaAlarmName")
    def quota_alarm_name(self) -> _builtins.str:
        """
        The name of Quota Alarm.
        """
        return pulumi.get(self, "quota_alarm_name")

    @_builtins.property
    @pulumi.getter(name="quotaDimensions")
    def quota_dimensions(self) -> Sequence['outputs.GetQuotaAlarmsAlarmQuotaDimensionResult']:
        """
        The Quota Dimensions.
        """
        return pulumi.get(self, "quota_dimensions")

    @_builtins.property
    @pulumi.getter
    def threshold(self) -> _builtins.float:
        """
        The threshold of Quota Alarm.
        """
        return pulumi.get(self, "threshold")

    @_builtins.property
    @pulumi.getter(name="thresholdPercent")
    def threshold_percent(self) -> _builtins.float:
        """
        The threshold percent of Quota Alarm.
        """
        return pulumi.get(self, "threshold_percent")

    @_builtins.property
    @pulumi.getter(name="webHook")
    def web_hook(self) -> _builtins.str:
        """
        The WebHook of Quota Alarm.
        """
        return pulumi.get(self, "web_hook")


@pulumi.output_type
class GetQuotaAlarmsAlarmQuotaDimensionResult(dict):
    def __init__(__self__, *,
                 key: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str key: The key of quota_dimensions.
        :param _builtins.str value: The value of quota_dimensions.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        """
        The key of quota_dimensions.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        The value of quota_dimensions.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetQuotaAlarmsQuotaDimensionResult(dict):
    def __init__(__self__, *,
                 key: Optional[_builtins.str] = None,
                 value: Optional[_builtins.str] = None):
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "value")


@pulumi.output_type
class GetQuotaApplicationsApplicationResult(dict):
    def __init__(__self__, *,
                 application_id: _builtins.str,
                 approve_value: _builtins.str,
                 audit_reason: _builtins.str,
                 desire_value: _builtins.float,
                 dimensions: Sequence['outputs.GetQuotaApplicationsApplicationDimensionResult'],
                 effective_time: _builtins.str,
                 expire_time: _builtins.str,
                 id: _builtins.str,
                 notice_type: _builtins.int,
                 product_code: _builtins.str,
                 quota_action_code: _builtins.str,
                 quota_description: _builtins.str,
                 quota_name: _builtins.str,
                 quota_unit: _builtins.str,
                 reason: _builtins.str,
                 status: _builtins.str):
        """
        :param _builtins.str application_id: The first ID of the resource.
        :param _builtins.str approve_value: The approve value.
        :param _builtins.str audit_reason: The audit reason.
        :param _builtins.float desire_value: The desire value of the quota application.
        :param Sequence['GetQuotaApplicationsApplicationDimensionArgs'] dimensions: The quota dimensions.
        :param _builtins.str effective_time: The effective time.
        :param _builtins.str expire_time: The expire time.
        :param _builtins.str id: The ID of the Application Info.
        :param _builtins.int notice_type: The notice type.
        :param _builtins.str product_code: The product code.
        :param _builtins.str quota_action_code: The ID of quota action..
        :param _builtins.str quota_description: The description of the quota.
        :param _builtins.str quota_name: The name of the quota.
        :param _builtins.str quota_unit: The quota unit.
        :param _builtins.str reason: The reason of the quota application.
        :param _builtins.str status: The status of the quota application.
        """
        pulumi.set(__self__, "application_id", application_id)
        pulumi.set(__self__, "approve_value", approve_value)
        pulumi.set(__self__, "audit_reason", audit_reason)
        pulumi.set(__self__, "desire_value", desire_value)
        pulumi.set(__self__, "dimensions", dimensions)
        pulumi.set(__self__, "effective_time", effective_time)
        pulumi.set(__self__, "expire_time", expire_time)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "notice_type", notice_type)
        pulumi.set(__self__, "product_code", product_code)
        pulumi.set(__self__, "quota_action_code", quota_action_code)
        pulumi.set(__self__, "quota_description", quota_description)
        pulumi.set(__self__, "quota_name", quota_name)
        pulumi.set(__self__, "quota_unit", quota_unit)
        pulumi.set(__self__, "reason", reason)
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> _builtins.str:
        """
        The first ID of the resource.
        """
        return pulumi.get(self, "application_id")

    @_builtins.property
    @pulumi.getter(name="approveValue")
    def approve_value(self) -> _builtins.str:
        """
        The approve value.
        """
        return pulumi.get(self, "approve_value")

    @_builtins.property
    @pulumi.getter(name="auditReason")
    def audit_reason(self) -> _builtins.str:
        """
        The audit reason.
        """
        return pulumi.get(self, "audit_reason")

    @_builtins.property
    @pulumi.getter(name="desireValue")
    def desire_value(self) -> _builtins.float:
        """
        The desire value of the quota application.
        """
        return pulumi.get(self, "desire_value")

    @_builtins.property
    @pulumi.getter
    def dimensions(self) -> Sequence['outputs.GetQuotaApplicationsApplicationDimensionResult']:
        """
        The quota dimensions.
        """
        return pulumi.get(self, "dimensions")

    @_builtins.property
    @pulumi.getter(name="effectiveTime")
    def effective_time(self) -> _builtins.str:
        """
        The effective time.
        """
        return pulumi.get(self, "effective_time")

    @_builtins.property
    @pulumi.getter(name="expireTime")
    def expire_time(self) -> _builtins.str:
        """
        The expire time.
        """
        return pulumi.get(self, "expire_time")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Application Info.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="noticeType")
    def notice_type(self) -> _builtins.int:
        """
        The notice type.
        """
        return pulumi.get(self, "notice_type")

    @_builtins.property
    @pulumi.getter(name="productCode")
    def product_code(self) -> _builtins.str:
        """
        The product code.
        """
        return pulumi.get(self, "product_code")

    @_builtins.property
    @pulumi.getter(name="quotaActionCode")
    def quota_action_code(self) -> _builtins.str:
        """
        The ID of quota action..
        """
        return pulumi.get(self, "quota_action_code")

    @_builtins.property
    @pulumi.getter(name="quotaDescription")
    def quota_description(self) -> _builtins.str:
        """
        The description of the quota.
        """
        return pulumi.get(self, "quota_description")

    @_builtins.property
    @pulumi.getter(name="quotaName")
    def quota_name(self) -> _builtins.str:
        """
        The name of the quota.
        """
        return pulumi.get(self, "quota_name")

    @_builtins.property
    @pulumi.getter(name="quotaUnit")
    def quota_unit(self) -> _builtins.str:
        """
        The quota unit.
        """
        return pulumi.get(self, "quota_unit")

    @_builtins.property
    @pulumi.getter
    def reason(self) -> _builtins.str:
        """
        The reason of the quota application.
        """
        return pulumi.get(self, "reason")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the quota application.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetQuotaApplicationsApplicationDimensionResult(dict):
    def __init__(__self__, *,
                 key: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str key: The key of dimensions.
        :param _builtins.str value: The value of dimensions.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        """
        The key of dimensions.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        The value of dimensions.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetQuotaApplicationsDimensionResult(dict):
    def __init__(__self__, *,
                 key: Optional[_builtins.str] = None,
                 value: Optional[_builtins.str] = None):
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "value")


@pulumi.output_type
class GetQuotasDimensionResult(dict):
    def __init__(__self__, *,
                 key: Optional[_builtins.str] = None,
                 value: Optional[_builtins.str] = None):
        """
        :param _builtins.str key: The key of dimensions.
        :param _builtins.str value: The value of dimensions.
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> Optional[_builtins.str]:
        """
        The key of dimensions.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.str]:
        """
        The value of dimensions.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetQuotasQuotaResult(dict):
    def __init__(__self__, *,
                 adjustable: _builtins.bool,
                 applicable_ranges: Sequence[_builtins.str],
                 applicable_type: _builtins.str,
                 consumable: _builtins.bool,
                 id: _builtins.str,
                 quota_action_code: _builtins.str,
                 quota_description: _builtins.str,
                 quota_name: _builtins.str,
                 quota_type: _builtins.str,
                 quota_unit: _builtins.str,
                 total_quota: _builtins.float,
                 total_usage: _builtins.float,
                 unadjustable_detail: _builtins.str):
        """
        :param _builtins.bool adjustable: Is the quota adjustable.
        :param Sequence[_builtins.str] applicable_ranges: The range of quota adjustment.
        :param _builtins.str applicable_type: The type of quota.
        :param _builtins.bool consumable: Show used quota.
        :param _builtins.str id: The ID of the Quota.
        :param _builtins.str quota_action_code: The quota action code.
        :param _builtins.str quota_description: The quota description.
        :param _builtins.str quota_name: The quota name.
        :param _builtins.str quota_type: The quota type.
        :param _builtins.str quota_unit: The quota unit.
        :param _builtins.float total_quota: TotalQuota.
        :param _builtins.float total_usage: The total of usage.
        :param _builtins.str unadjustable_detail: The unadjustable detail.
        """
        pulumi.set(__self__, "adjustable", adjustable)
        pulumi.set(__self__, "applicable_ranges", applicable_ranges)
        pulumi.set(__self__, "applicable_type", applicable_type)
        pulumi.set(__self__, "consumable", consumable)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "quota_action_code", quota_action_code)
        pulumi.set(__self__, "quota_description", quota_description)
        pulumi.set(__self__, "quota_name", quota_name)
        pulumi.set(__self__, "quota_type", quota_type)
        pulumi.set(__self__, "quota_unit", quota_unit)
        pulumi.set(__self__, "total_quota", total_quota)
        pulumi.set(__self__, "total_usage", total_usage)
        pulumi.set(__self__, "unadjustable_detail", unadjustable_detail)

    @_builtins.property
    @pulumi.getter
    def adjustable(self) -> _builtins.bool:
        """
        Is the quota adjustable.
        """
        return pulumi.get(self, "adjustable")

    @_builtins.property
    @pulumi.getter(name="applicableRanges")
    def applicable_ranges(self) -> Sequence[_builtins.str]:
        """
        The range of quota adjustment.
        """
        return pulumi.get(self, "applicable_ranges")

    @_builtins.property
    @pulumi.getter(name="applicableType")
    def applicable_type(self) -> _builtins.str:
        """
        The type of quota.
        """
        return pulumi.get(self, "applicable_type")

    @_builtins.property
    @pulumi.getter
    def consumable(self) -> _builtins.bool:
        """
        Show used quota.
        """
        return pulumi.get(self, "consumable")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Quota.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="quotaActionCode")
    def quota_action_code(self) -> _builtins.str:
        """
        The quota action code.
        """
        return pulumi.get(self, "quota_action_code")

    @_builtins.property
    @pulumi.getter(name="quotaDescription")
    def quota_description(self) -> _builtins.str:
        """
        The quota description.
        """
        return pulumi.get(self, "quota_description")

    @_builtins.property
    @pulumi.getter(name="quotaName")
    def quota_name(self) -> _builtins.str:
        """
        The quota name.
        """
        return pulumi.get(self, "quota_name")

    @_builtins.property
    @pulumi.getter(name="quotaType")
    def quota_type(self) -> _builtins.str:
        """
        The quota type.
        """
        return pulumi.get(self, "quota_type")

    @_builtins.property
    @pulumi.getter(name="quotaUnit")
    def quota_unit(self) -> _builtins.str:
        """
        The quota unit.
        """
        return pulumi.get(self, "quota_unit")

    @_builtins.property
    @pulumi.getter(name="totalQuota")
    def total_quota(self) -> _builtins.float:
        """
        TotalQuota.
        """
        return pulumi.get(self, "total_quota")

    @_builtins.property
    @pulumi.getter(name="totalUsage")
    def total_usage(self) -> _builtins.float:
        """
        The total of usage.
        """
        return pulumi.get(self, "total_usage")

    @_builtins.property
    @pulumi.getter(name="unadjustableDetail")
    def unadjustable_detail(self) -> _builtins.str:
        """
        The unadjustable detail.
        """
        return pulumi.get(self, "unadjustable_detail")


@pulumi.output_type
class GetTemplateApplicationsApplicationResult(dict):
    def __init__(__self__, *,
                 aliyun_uids: Sequence[_builtins.str],
                 apply_time: _builtins.str,
                 audit_status_vos: Sequence['outputs.GetTemplateApplicationsApplicationAuditStatusVoResult'],
                 batch_quota_application_id: _builtins.str,
                 desire_value: _builtins.float,
                 dimensions: Sequence['outputs.GetTemplateApplicationsApplicationDimensionResult'],
                 effective_time: _builtins.str,
                 expire_time: _builtins.str,
                 id: _builtins.str,
                 product_code: _builtins.str,
                 quota_action_code: _builtins.str,
                 quota_category: _builtins.str,
                 reason: _builtins.str):
        """
        :param Sequence[_builtins.str] aliyun_uids: The list of Alibaba Cloud accounts (primary accounts) of the resource directory members to which the quota is applied.> Only 50 members can apply for quota increase in batch at a time. For more information about the members of the resource directory, see Query the list of all members in the resource directory.
        :param _builtins.str apply_time: The UTC time of the quota increase application.
        :param Sequence['GetTemplateApplicationsApplicationAuditStatusVoArgs'] audit_status_vos: Quantity of requisitions in different approval statuses.
        :param _builtins.str batch_quota_application_id: The ID of the quota application batch.
        :param _builtins.float desire_value: The value of the quota request.> The quota request is approved by the technical support of each cloud service. If you want to increase the chance of passing, please fill in a reasonable application value and detailed application reasons when applying for quota.
        :param Sequence['GetTemplateApplicationsApplicationDimensionArgs'] dimensions: Quota dimension.
        :param _builtins.str effective_time: The UTC time when the quota takes effect. This parameter applies only to the equity quota (WhiteListLabel).> If the current account does not select the effective time, the default is the submission time.
        :param _builtins.str expire_time: The UTC time when the quota expires. This parameter applies only to the equity quota (WhiteListLabel).> If No Expiration Time is selected for the current account, the expiration time is 99 years from the effective time of the current quota.
        :param _builtins.str id: The ID of the quota application batch.
        :param _builtins.str product_code: Cloud service name abbreviation.> For more information about cloud services that support quota centers, see Cloud services that support quota centers.
        :param _builtins.str quota_action_code: The quota ID.
        :param _builtins.str quota_category: The quota type. Value: `CommonQuota`, `FlowControl` and `WhiteListLabel`.
        :param _builtins.str reason: Reason for quota application.> The quota request is approved by the technical support of each cloud service. If you want to increase the chance of passing, please fill in a reasonable application value and detailed application reasons when applying for quota.
        """
        pulumi.set(__self__, "aliyun_uids", aliyun_uids)
        pulumi.set(__self__, "apply_time", apply_time)
        pulumi.set(__self__, "audit_status_vos", audit_status_vos)
        pulumi.set(__self__, "batch_quota_application_id", batch_quota_application_id)
        pulumi.set(__self__, "desire_value", desire_value)
        pulumi.set(__self__, "dimensions", dimensions)
        pulumi.set(__self__, "effective_time", effective_time)
        pulumi.set(__self__, "expire_time", expire_time)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "product_code", product_code)
        pulumi.set(__self__, "quota_action_code", quota_action_code)
        pulumi.set(__self__, "quota_category", quota_category)
        pulumi.set(__self__, "reason", reason)

    @_builtins.property
    @pulumi.getter(name="aliyunUids")
    def aliyun_uids(self) -> Sequence[_builtins.str]:
        """
        The list of Alibaba Cloud accounts (primary accounts) of the resource directory members to which the quota is applied.> Only 50 members can apply for quota increase in batch at a time. For more information about the members of the resource directory, see Query the list of all members in the resource directory.
        """
        return pulumi.get(self, "aliyun_uids")

    @_builtins.property
    @pulumi.getter(name="applyTime")
    def apply_time(self) -> _builtins.str:
        """
        The UTC time of the quota increase application.
        """
        return pulumi.get(self, "apply_time")

    @_builtins.property
    @pulumi.getter(name="auditStatusVos")
    def audit_status_vos(self) -> Sequence['outputs.GetTemplateApplicationsApplicationAuditStatusVoResult']:
        """
        Quantity of requisitions in different approval statuses.
        """
        return pulumi.get(self, "audit_status_vos")

    @_builtins.property
    @pulumi.getter(name="batchQuotaApplicationId")
    def batch_quota_application_id(self) -> _builtins.str:
        """
        The ID of the quota application batch.
        """
        return pulumi.get(self, "batch_quota_application_id")

    @_builtins.property
    @pulumi.getter(name="desireValue")
    def desire_value(self) -> _builtins.float:
        """
        The value of the quota request.> The quota request is approved by the technical support of each cloud service. If you want to increase the chance of passing, please fill in a reasonable application value and detailed application reasons when applying for quota.
        """
        return pulumi.get(self, "desire_value")

    @_builtins.property
    @pulumi.getter
    def dimensions(self) -> Sequence['outputs.GetTemplateApplicationsApplicationDimensionResult']:
        """
        Quota dimension.
        """
        return pulumi.get(self, "dimensions")

    @_builtins.property
    @pulumi.getter(name="effectiveTime")
    def effective_time(self) -> _builtins.str:
        """
        The UTC time when the quota takes effect. This parameter applies only to the equity quota (WhiteListLabel).> If the current account does not select the effective time, the default is the submission time.
        """
        return pulumi.get(self, "effective_time")

    @_builtins.property
    @pulumi.getter(name="expireTime")
    def expire_time(self) -> _builtins.str:
        """
        The UTC time when the quota expires. This parameter applies only to the equity quota (WhiteListLabel).> If No Expiration Time is selected for the current account, the expiration time is 99 years from the effective time of the current quota.
        """
        return pulumi.get(self, "expire_time")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the quota application batch.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="productCode")
    def product_code(self) -> _builtins.str:
        """
        Cloud service name abbreviation.> For more information about cloud services that support quota centers, see Cloud services that support quota centers.
        """
        return pulumi.get(self, "product_code")

    @_builtins.property
    @pulumi.getter(name="quotaActionCode")
    def quota_action_code(self) -> _builtins.str:
        """
        The quota ID.
        """
        return pulumi.get(self, "quota_action_code")

    @_builtins.property
    @pulumi.getter(name="quotaCategory")
    def quota_category(self) -> _builtins.str:
        """
        The quota type. Value: `CommonQuota`, `FlowControl` and `WhiteListLabel`.
        """
        return pulumi.get(self, "quota_category")

    @_builtins.property
    @pulumi.getter
    def reason(self) -> _builtins.str:
        """
        Reason for quota application.> The quota request is approved by the technical support of each cloud service. If you want to increase the chance of passing, please fill in a reasonable application value and detailed application reasons when applying for quota.
        """
        return pulumi.get(self, "reason")


@pulumi.output_type
class GetTemplateApplicationsApplicationAuditStatusVoResult(dict):
    def __init__(__self__, *,
                 count: _builtins.int,
                 status: _builtins.str):
        """
        :param _builtins.int count: Approval document quantity.
        :param _builtins.str status: The approval status of the quota promotion application. Value:-Disagree: reject.-Approve: approved.-Process: under review.-Cancel: Closed.
        """
        pulumi.set(__self__, "count", count)
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter
    def count(self) -> _builtins.int:
        """
        Approval document quantity.
        """
        return pulumi.get(self, "count")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The approval status of the quota promotion application. Value:-Disagree: reject.-Approve: approved.-Process: under review.-Cancel: Closed.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetTemplateApplicationsApplicationDimensionResult(dict):
    def __init__(__self__, *,
                 key: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str key: Quota dimension Key.
        :param _builtins.str value: Quota dimension Value.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        """
        Quota dimension Key.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        Quota dimension Value.
        """
        return pulumi.get(self, "value")


