# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetPoliciesResult',
    'AwaitableGetPoliciesResult',
    'get_policies',
    'get_policies_output',
]

@pulumi.output_type
class GetPoliciesResult:
    """
    A collection of values returned by getPolicies.
    """
    def __init__(__self__, enable_details=None, group_name=None, id=None, ids=None, name_regex=None, names=None, output_file=None, policies=None, role_name=None, type=None, user_name=None):
        if enable_details and not isinstance(enable_details, bool):
            raise TypeError("Expected argument 'enable_details' to be a bool")
        pulumi.set(__self__, "enable_details", enable_details)
        if group_name and not isinstance(group_name, str):
            raise TypeError("Expected argument 'group_name' to be a str")
        pulumi.set(__self__, "group_name", group_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if names and not isinstance(names, list):
            raise TypeError("Expected argument 'names' to be a list")
        pulumi.set(__self__, "names", names)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if policies and not isinstance(policies, list):
            raise TypeError("Expected argument 'policies' to be a list")
        pulumi.set(__self__, "policies", policies)
        if role_name and not isinstance(role_name, str):
            raise TypeError("Expected argument 'role_name' to be a str")
        pulumi.set(__self__, "role_name", role_name)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if user_name and not isinstance(user_name, str):
            raise TypeError("Expected argument 'user_name' to be a str")
        pulumi.set(__self__, "user_name", user_name)

    @_builtins.property
    @pulumi.getter(name="enableDetails")
    def enable_details(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "enable_details")

    @_builtins.property
    @pulumi.getter(name="groupName")
    def group_name(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "group_name")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "name_regex")

    @_builtins.property
    @pulumi.getter
    def names(self) -> Sequence[_builtins.str]:
        """
        A list of ram group names.
        """
        return pulumi.get(self, "names")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")

    @_builtins.property
    @pulumi.getter
    def policies(self) -> Sequence['outputs.GetPoliciesPolicyResult']:
        """
        A list of policies. Each element contains the following attributes:
        """
        return pulumi.get(self, "policies")

    @_builtins.property
    @pulumi.getter(name="roleName")
    def role_name(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "role_name")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        Type of the policy.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[_builtins.str]:
        """
        The user name of  policy.
        """
        return pulumi.get(self, "user_name")


class AwaitableGetPoliciesResult(GetPoliciesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPoliciesResult(
            enable_details=self.enable_details,
            group_name=self.group_name,
            id=self.id,
            ids=self.ids,
            name_regex=self.name_regex,
            names=self.names,
            output_file=self.output_file,
            policies=self.policies,
            role_name=self.role_name,
            type=self.type,
            user_name=self.user_name)


def get_policies(enable_details: Optional[_builtins.bool] = None,
                 group_name: Optional[_builtins.str] = None,
                 ids: Optional[Sequence[_builtins.str]] = None,
                 name_regex: Optional[_builtins.str] = None,
                 output_file: Optional[_builtins.str] = None,
                 role_name: Optional[_builtins.str] = None,
                 type: Optional[_builtins.str] = None,
                 user_name: Optional[_builtins.str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPoliciesResult:
    """
    This data source provides a list of RAM policies in an Alibaba Cloud account according to the specified filters.

    > **NOTE:** Available since v1.0.0+.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud
    import pulumi_random as random

    default = random.index.Integer("default",
        min=10000,
        max=99999)
    group = alicloud.ram.Group("group",
        name=f"groupName-{default['result']}",
        comments="this is a group comments.")
    policy = alicloud.ram.Policy("policy",
        policy_name=f"tf-example-{default['result']}",
        policy_document=\"\"\"    {
          "Statement": [
            {
              "Action": [
                "oss:ListObjects",
                "oss:GetObject"
              ],
              "Effect": "Allow",
              "Resource": [
                "acs:oss:*:*:mybucket",
                "acs:oss:*:*:mybucket/*"
              ]
            }
          ],
            "Version": "1"
        }
    \"\"\",
        description="this is a policy test")
    attach = alicloud.ram.GroupPolicyAttachment("attach",
        policy_name=policy.policy_name,
        policy_type=policy.type,
        group_name=group.name)
    policies_ds = alicloud.ram.get_policies_output(group_name=attach.group_name,
        type="Custom")
    pulumi.export("firstPolicyName", policies_ds.policies[0].name)
    ```


    :param _builtins.bool enable_details: Default to `true`. Set it to true can output more details.
    :param _builtins.str group_name: Filter results by a specific group name. Returned policies are attached to the specified group.
    :param Sequence[_builtins.str] ids: A list of ram group IDs.
    :param _builtins.str name_regex: A regex string to filter resulting policies by name.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str role_name: Filter results by a specific role name. Returned policies are attached to the specified role.
    :param _builtins.str type: Filter results by a specific policy type. Valid values are `Custom` and `System`.
    :param _builtins.str user_name: Filter results by a specific user name. Returned policies are attached to the specified user.
    """
    __args__ = dict()
    __args__['enableDetails'] = enable_details
    __args__['groupName'] = group_name
    __args__['ids'] = ids
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['roleName'] = role_name
    __args__['type'] = type
    __args__['userName'] = user_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:ram/getPolicies:getPolicies', __args__, opts=opts, typ=GetPoliciesResult).value

    return AwaitableGetPoliciesResult(
        enable_details=pulumi.get(__ret__, 'enable_details'),
        group_name=pulumi.get(__ret__, 'group_name'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        names=pulumi.get(__ret__, 'names'),
        output_file=pulumi.get(__ret__, 'output_file'),
        policies=pulumi.get(__ret__, 'policies'),
        role_name=pulumi.get(__ret__, 'role_name'),
        type=pulumi.get(__ret__, 'type'),
        user_name=pulumi.get(__ret__, 'user_name'))
def get_policies_output(enable_details: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                        group_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                        name_regex: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        role_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        user_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetPoliciesResult]:
    """
    This data source provides a list of RAM policies in an Alibaba Cloud account according to the specified filters.

    > **NOTE:** Available since v1.0.0+.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud
    import pulumi_random as random

    default = random.index.Integer("default",
        min=10000,
        max=99999)
    group = alicloud.ram.Group("group",
        name=f"groupName-{default['result']}",
        comments="this is a group comments.")
    policy = alicloud.ram.Policy("policy",
        policy_name=f"tf-example-{default['result']}",
        policy_document=\"\"\"    {
          "Statement": [
            {
              "Action": [
                "oss:ListObjects",
                "oss:GetObject"
              ],
              "Effect": "Allow",
              "Resource": [
                "acs:oss:*:*:mybucket",
                "acs:oss:*:*:mybucket/*"
              ]
            }
          ],
            "Version": "1"
        }
    \"\"\",
        description="this is a policy test")
    attach = alicloud.ram.GroupPolicyAttachment("attach",
        policy_name=policy.policy_name,
        policy_type=policy.type,
        group_name=group.name)
    policies_ds = alicloud.ram.get_policies_output(group_name=attach.group_name,
        type="Custom")
    pulumi.export("firstPolicyName", policies_ds.policies[0].name)
    ```


    :param _builtins.bool enable_details: Default to `true`. Set it to true can output more details.
    :param _builtins.str group_name: Filter results by a specific group name. Returned policies are attached to the specified group.
    :param Sequence[_builtins.str] ids: A list of ram group IDs.
    :param _builtins.str name_regex: A regex string to filter resulting policies by name.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str role_name: Filter results by a specific role name. Returned policies are attached to the specified role.
    :param _builtins.str type: Filter results by a specific policy type. Valid values are `Custom` and `System`.
    :param _builtins.str user_name: Filter results by a specific user name. Returned policies are attached to the specified user.
    """
    __args__ = dict()
    __args__['enableDetails'] = enable_details
    __args__['groupName'] = group_name
    __args__['ids'] = ids
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['roleName'] = role_name
    __args__['type'] = type
    __args__['userName'] = user_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:ram/getPolicies:getPolicies', __args__, opts=opts, typ=GetPoliciesResult)
    return __ret__.apply(lambda __response__: GetPoliciesResult(
        enable_details=pulumi.get(__response__, 'enable_details'),
        group_name=pulumi.get(__response__, 'group_name'),
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        name_regex=pulumi.get(__response__, 'name_regex'),
        names=pulumi.get(__response__, 'names'),
        output_file=pulumi.get(__response__, 'output_file'),
        policies=pulumi.get(__response__, 'policies'),
        role_name=pulumi.get(__response__, 'role_name'),
        type=pulumi.get(__response__, 'type'),
        user_name=pulumi.get(__response__, 'user_name')))
