# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['BackupPolicyArgs', 'BackupPolicy']

@pulumi.input_type
class BackupPolicyArgs:
    def __init__(__self__, *,
                 instance_id: pulumi.Input[_builtins.str],
                 archive_backup_keep_count: Optional[pulumi.Input[_builtins.int]] = None,
                 archive_backup_keep_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 archive_backup_retention_period: Optional[pulumi.Input[_builtins.int]] = None,
                 backup_interval: Optional[pulumi.Input[_builtins.str]] = None,
                 backup_method: Optional[pulumi.Input[_builtins.str]] = None,
                 backup_periods: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 backup_priority: Optional[pulumi.Input[_builtins.int]] = None,
                 backup_retention_period: Optional[pulumi.Input[_builtins.int]] = None,
                 backup_time: Optional[pulumi.Input[_builtins.str]] = None,
                 category: Optional[pulumi.Input[_builtins.str]] = None,
                 compress_type: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_backup_log: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_increment_data_backup: Optional[pulumi.Input[_builtins.bool]] = None,
                 high_space_usage_protection: Optional[pulumi.Input[_builtins.str]] = None,
                 local_log_retention_hours: Optional[pulumi.Input[_builtins.int]] = None,
                 local_log_retention_space: Optional[pulumi.Input[_builtins.int]] = None,
                 log_backup: Optional[pulumi.Input[_builtins.bool]] = None,
                 log_backup_frequency: Optional[pulumi.Input[_builtins.str]] = None,
                 log_backup_local_retention_number: Optional[pulumi.Input[_builtins.int]] = None,
                 log_backup_retention_period: Optional[pulumi.Input[_builtins.int]] = None,
                 log_retention_period: Optional[pulumi.Input[_builtins.int]] = None,
                 preferred_backup_periods: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 preferred_backup_time: Optional[pulumi.Input[_builtins.str]] = None,
                 released_keep_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 retention_period: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a BackupPolicy resource.
        :param pulumi.Input[_builtins.str] instance_id: The Id of instance that can run database.
        :param pulumi.Input[_builtins.int] archive_backup_keep_count: Instance archive backup keep count. Valid when the `enable_backup_log` is `true` and instance is mysql local disk. When `archive_backup_keep_policy` is `ByMonth` Valid values: [1-31]. When `archive_backup_keep_policy` is `ByWeek` Valid values: [1-7].
        :param pulumi.Input[_builtins.str] archive_backup_keep_policy: Instance archive backup keep policy. Valid when the `enable_backup_log` is `true` and instance is mysql local disk. Valid values are `ByMonth`, `ByWeek`, `KeepAll`.
        :param pulumi.Input[_builtins.int] archive_backup_retention_period: Instance archive backup retention days. Valid when the `enable_backup_log` is `true` and instance is mysql local disk. Valid values: [30-1095], and `archive_backup_retention_period` must larger than `backup_retention_period` 730.
        :param pulumi.Input[_builtins.str] backup_interval: The frequency at which you want to perform a snapshot backup on the instance. Valid values:
               - -1: No backup frequencies are specified.
               - 30: A snapshot backup is performed once every 30 minutes.
               - 60: A snapshot backup is performed once every 60 minutes.
               - 120: A snapshot backup is performed once every 120 minutes.
               - 240: A snapshot backup is performed once every 240 minutes.
               - 360: A snapshot backup is performed once every 360 minutes.
               - 480: A snapshot backup is performed once every 480 minutes.
               - 720: A snapshot backup is performed once every 720 minutes.
        :param pulumi.Input[_builtins.str] backup_method: The backup method of the instance. Valid values:
               - Physical: physical backup
               - Snapshot: snapshot backup
               ->**NOTE:** This parameter takes effect only on instances that run SQL Server with cloud disks. This parameter takes effect only when BackupPolicyMode is set to DataBackupPolicy.
               
               > **NOTE:** Currently, the SQLServer instance does not support to modify `log_backup_retention_period`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] backup_periods: It has been deprecated from version 1.69.0, and use field 'preferred_backup_period' instead.
        :param pulumi.Input[_builtins.int] backup_priority: Specifies whether the backup settings of a secondary instance are configured. Valid values:
               - 1: secondary instance preferred
               - 2: primary instance preferred
               ->**NOTE:** This parameter is suitable only for instances that run SQL Server on RDS Cluster Edition. This parameter takes effect only when BackupMethod is set to Physical. If BackupMethod is set to Snapshot, backups are forcefully performed on the primary instance that runs SQL Server on RDS Cluster Edition.
        :param pulumi.Input[_builtins.int] backup_retention_period: Instance backup retention days. Valid values: [7-730]. Default to 7. But mysql local disk is unlimited.
        :param pulumi.Input[_builtins.str] backup_time: It has been deprecated from version 1.69.0, and use field 'preferred_backup_time' instead.
        :param pulumi.Input[_builtins.str] category: Whether to enable second level backup.Valid values are `Flash`, `Standard`, Note:It only takes effect when the BackupPolicyMode parameter is DataBackupPolicy.
               > **NOTE:** You can configure a backup policy by using this parameter and the PreferredBackupPeriod parameter. For example, if you set the PreferredBackupPeriod parameter to Saturday,Sunday and the BackupInterval parameter to -1, a snapshot backup is performed on every Saturday and Sunday.If the instance runs PostgreSQL, the BackupInterval parameter is supported only when the instance is equipped with standard SSDs or enhanced SSDs (ESSDs).This parameter takes effect only when you set the BackupPolicyMode parameter to DataBackupPolicy.
        :param pulumi.Input[_builtins.str] compress_type: The compress type of instance policy. Valid values are `1`, `4`, `8`.
        :param pulumi.Input[_builtins.bool] enable_backup_log: Whether to backup instance log. Valid values are `true`, `false`, Default to `true`. Note: The 'Basic Edition' category Rds instance does not support setting log backup. [What is Basic Edition](https://www.alibabacloud.com/help/doc-detail/48980.htm).
        :param pulumi.Input[_builtins.bool] enable_increment_data_backup: Specifies whether to enable incremental backup. Valid values:
               - false (default): disables the feature.
               - true: enables the feature.
               ->**NOTE:** This parameter takes effect only on instances that run SQL Server with cloud disks. This parameter takes effect only when BackupPolicyMode is set to DataBackupPolicy.
        :param pulumi.Input[_builtins.str] high_space_usage_protection: Instance high space usage protection policy. Valid when the `enable_backup_log` is `true`. Valid values are `Enable`, `Disable`.
        :param pulumi.Input[_builtins.int] local_log_retention_hours: Instance log backup local retention hours. Valid when the `enable_backup_log` is `true`. Valid values: [0-7*24].
        :param pulumi.Input[_builtins.int] local_log_retention_space: Instance log backup local retention space. Valid when the `enable_backup_log` is `true`. Valid values: [0-50].
        :param pulumi.Input[_builtins.bool] log_backup: It has been deprecated from version 1.68.0, and use field 'enable_backup_log' instead.
        :param pulumi.Input[_builtins.str] log_backup_frequency: Instance log backup frequency. Valid when the instance engine is `SQLServer`. Valid values are `LogInterval`.
        :param pulumi.Input[_builtins.int] log_backup_local_retention_number: The number of binary log files that you want to retain on the instance. Default value: 60. Valid values: 6 to 100.
               ->**NOTE:** This parameter takes effect only when you set the BackupPolicyMode parameter to LogBackupPolicy. If the instance runs MySQL, you can set this parameter to -1. The value -1 specifies that an unlimited number of binary log files can be retained on the instance.
        :param pulumi.Input[_builtins.int] log_backup_retention_period: Instance log backup retention days. Valid when the `enable_backup_log` is `1`. Valid values: [7-730]. Default to 7. It cannot be larger than `backup_retention_period`.
        :param pulumi.Input[_builtins.int] log_retention_period: It has been deprecated from version 1.69.0, and use field 'log_backup_retention_period' instead.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] preferred_backup_periods: DB Instance backup period. Please set at least two days to ensure backing up at least twice a week. Valid values: [Monday, Tuesday, Wednesday, Thursday, Friday, Saturday, Sunday].
        :param pulumi.Input[_builtins.str] preferred_backup_time: DB instance backup time, in the format of HH:mmZ- HH:mmZ. Time setting interval is one hour. Default to "02:00Z-03:00Z". China time is 8 hours behind it.
        :param pulumi.Input[_builtins.str] released_keep_policy: The policy based on which ApsaraDB RDS retains archived backup files if the instance is released. Default value: None. Valid values:
               * **None**: No archived backup files are retained.
               * **Lastest**: Only the most recent archived backup file is retained.
               * **All**: All archived backup files are retained.
        :param pulumi.Input[_builtins.int] retention_period: It has been deprecated from version 1.69.0, and use field 'backup_retention_period' instead.
        """
        pulumi.set(__self__, "instance_id", instance_id)
        if archive_backup_keep_count is not None:
            pulumi.set(__self__, "archive_backup_keep_count", archive_backup_keep_count)
        if archive_backup_keep_policy is not None:
            pulumi.set(__self__, "archive_backup_keep_policy", archive_backup_keep_policy)
        if archive_backup_retention_period is not None:
            pulumi.set(__self__, "archive_backup_retention_period", archive_backup_retention_period)
        if backup_interval is not None:
            pulumi.set(__self__, "backup_interval", backup_interval)
        if backup_method is not None:
            pulumi.set(__self__, "backup_method", backup_method)
        if backup_periods is not None:
            warnings.warn("""Attribute 'backup_period' has been deprecated from version 1.69.0. Use `preferred_backup_period` instead""", DeprecationWarning)
            pulumi.log.warn("""backup_periods is deprecated: Attribute 'backup_period' has been deprecated from version 1.69.0. Use `preferred_backup_period` instead""")
        if backup_periods is not None:
            pulumi.set(__self__, "backup_periods", backup_periods)
        if backup_priority is not None:
            pulumi.set(__self__, "backup_priority", backup_priority)
        if backup_retention_period is not None:
            pulumi.set(__self__, "backup_retention_period", backup_retention_period)
        if backup_time is not None:
            warnings.warn("""Attribute 'backup_time' has been deprecated from version 1.69.0. Use `preferred_backup_time` instead""", DeprecationWarning)
            pulumi.log.warn("""backup_time is deprecated: Attribute 'backup_time' has been deprecated from version 1.69.0. Use `preferred_backup_time` instead""")
        if backup_time is not None:
            pulumi.set(__self__, "backup_time", backup_time)
        if category is not None:
            pulumi.set(__self__, "category", category)
        if compress_type is not None:
            pulumi.set(__self__, "compress_type", compress_type)
        if enable_backup_log is not None:
            pulumi.set(__self__, "enable_backup_log", enable_backup_log)
        if enable_increment_data_backup is not None:
            pulumi.set(__self__, "enable_increment_data_backup", enable_increment_data_backup)
        if high_space_usage_protection is not None:
            pulumi.set(__self__, "high_space_usage_protection", high_space_usage_protection)
        if local_log_retention_hours is not None:
            pulumi.set(__self__, "local_log_retention_hours", local_log_retention_hours)
        if local_log_retention_space is not None:
            pulumi.set(__self__, "local_log_retention_space", local_log_retention_space)
        if log_backup is not None:
            warnings.warn("""Attribute 'log_backup' has been deprecated from version 1.68.0. Use `enable_backup_log` instead""", DeprecationWarning)
            pulumi.log.warn("""log_backup is deprecated: Attribute 'log_backup' has been deprecated from version 1.68.0. Use `enable_backup_log` instead""")
        if log_backup is not None:
            pulumi.set(__self__, "log_backup", log_backup)
        if log_backup_frequency is not None:
            pulumi.set(__self__, "log_backup_frequency", log_backup_frequency)
        if log_backup_local_retention_number is not None:
            pulumi.set(__self__, "log_backup_local_retention_number", log_backup_local_retention_number)
        if log_backup_retention_period is not None:
            pulumi.set(__self__, "log_backup_retention_period", log_backup_retention_period)
        if log_retention_period is not None:
            warnings.warn("""Attribute 'log_retention_period' has been deprecated from version 1.69.0. Use `log_backup_retention_period` instead""", DeprecationWarning)
            pulumi.log.warn("""log_retention_period is deprecated: Attribute 'log_retention_period' has been deprecated from version 1.69.0. Use `log_backup_retention_period` instead""")
        if log_retention_period is not None:
            pulumi.set(__self__, "log_retention_period", log_retention_period)
        if preferred_backup_periods is not None:
            pulumi.set(__self__, "preferred_backup_periods", preferred_backup_periods)
        if preferred_backup_time is not None:
            pulumi.set(__self__, "preferred_backup_time", preferred_backup_time)
        if released_keep_policy is not None:
            pulumi.set(__self__, "released_keep_policy", released_keep_policy)
        if retention_period is not None:
            warnings.warn("""Attribute 'retention_period' has been deprecated from version 1.69.0. Use `backup_retention_period` instead""", DeprecationWarning)
            pulumi.log.warn("""retention_period is deprecated: Attribute 'retention_period' has been deprecated from version 1.69.0. Use `backup_retention_period` instead""")
        if retention_period is not None:
            pulumi.set(__self__, "retention_period", retention_period)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[_builtins.str]:
        """
        The Id of instance that can run database.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="archiveBackupKeepCount")
    def archive_backup_keep_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Instance archive backup keep count. Valid when the `enable_backup_log` is `true` and instance is mysql local disk. When `archive_backup_keep_policy` is `ByMonth` Valid values: [1-31]. When `archive_backup_keep_policy` is `ByWeek` Valid values: [1-7].
        """
        return pulumi.get(self, "archive_backup_keep_count")

    @archive_backup_keep_count.setter
    def archive_backup_keep_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "archive_backup_keep_count", value)

    @_builtins.property
    @pulumi.getter(name="archiveBackupKeepPolicy")
    def archive_backup_keep_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Instance archive backup keep policy. Valid when the `enable_backup_log` is `true` and instance is mysql local disk. Valid values are `ByMonth`, `ByWeek`, `KeepAll`.
        """
        return pulumi.get(self, "archive_backup_keep_policy")

    @archive_backup_keep_policy.setter
    def archive_backup_keep_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "archive_backup_keep_policy", value)

    @_builtins.property
    @pulumi.getter(name="archiveBackupRetentionPeriod")
    def archive_backup_retention_period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Instance archive backup retention days. Valid when the `enable_backup_log` is `true` and instance is mysql local disk. Valid values: [30-1095], and `archive_backup_retention_period` must larger than `backup_retention_period` 730.
        """
        return pulumi.get(self, "archive_backup_retention_period")

    @archive_backup_retention_period.setter
    def archive_backup_retention_period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "archive_backup_retention_period", value)

    @_builtins.property
    @pulumi.getter(name="backupInterval")
    def backup_interval(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The frequency at which you want to perform a snapshot backup on the instance. Valid values:
        - -1: No backup frequencies are specified.
        - 30: A snapshot backup is performed once every 30 minutes.
        - 60: A snapshot backup is performed once every 60 minutes.
        - 120: A snapshot backup is performed once every 120 minutes.
        - 240: A snapshot backup is performed once every 240 minutes.
        - 360: A snapshot backup is performed once every 360 minutes.
        - 480: A snapshot backup is performed once every 480 minutes.
        - 720: A snapshot backup is performed once every 720 minutes.
        """
        return pulumi.get(self, "backup_interval")

    @backup_interval.setter
    def backup_interval(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backup_interval", value)

    @_builtins.property
    @pulumi.getter(name="backupMethod")
    def backup_method(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The backup method of the instance. Valid values:
        - Physical: physical backup
        - Snapshot: snapshot backup
        ->**NOTE:** This parameter takes effect only on instances that run SQL Server with cloud disks. This parameter takes effect only when BackupPolicyMode is set to DataBackupPolicy.

        > **NOTE:** Currently, the SQLServer instance does not support to modify `log_backup_retention_period`.
        """
        return pulumi.get(self, "backup_method")

    @backup_method.setter
    def backup_method(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backup_method", value)

    @_builtins.property
    @pulumi.getter(name="backupPeriods")
    @_utilities.deprecated("""Attribute 'backup_period' has been deprecated from version 1.69.0. Use `preferred_backup_period` instead""")
    def backup_periods(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        It has been deprecated from version 1.69.0, and use field 'preferred_backup_period' instead.
        """
        return pulumi.get(self, "backup_periods")

    @backup_periods.setter
    def backup_periods(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "backup_periods", value)

    @_builtins.property
    @pulumi.getter(name="backupPriority")
    def backup_priority(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies whether the backup settings of a secondary instance are configured. Valid values:
        - 1: secondary instance preferred
        - 2: primary instance preferred
        ->**NOTE:** This parameter is suitable only for instances that run SQL Server on RDS Cluster Edition. This parameter takes effect only when BackupMethod is set to Physical. If BackupMethod is set to Snapshot, backups are forcefully performed on the primary instance that runs SQL Server on RDS Cluster Edition.
        """
        return pulumi.get(self, "backup_priority")

    @backup_priority.setter
    def backup_priority(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "backup_priority", value)

    @_builtins.property
    @pulumi.getter(name="backupRetentionPeriod")
    def backup_retention_period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Instance backup retention days. Valid values: [7-730]. Default to 7. But mysql local disk is unlimited.
        """
        return pulumi.get(self, "backup_retention_period")

    @backup_retention_period.setter
    def backup_retention_period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "backup_retention_period", value)

    @_builtins.property
    @pulumi.getter(name="backupTime")
    @_utilities.deprecated("""Attribute 'backup_time' has been deprecated from version 1.69.0. Use `preferred_backup_time` instead""")
    def backup_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        It has been deprecated from version 1.69.0, and use field 'preferred_backup_time' instead.
        """
        return pulumi.get(self, "backup_time")

    @backup_time.setter
    def backup_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backup_time", value)

    @_builtins.property
    @pulumi.getter
    def category(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether to enable second level backup.Valid values are `Flash`, `Standard`, Note:It only takes effect when the BackupPolicyMode parameter is DataBackupPolicy.
        > **NOTE:** You can configure a backup policy by using this parameter and the PreferredBackupPeriod parameter. For example, if you set the PreferredBackupPeriod parameter to Saturday,Sunday and the BackupInterval parameter to -1, a snapshot backup is performed on every Saturday and Sunday.If the instance runs PostgreSQL, the BackupInterval parameter is supported only when the instance is equipped with standard SSDs or enhanced SSDs (ESSDs).This parameter takes effect only when you set the BackupPolicyMode parameter to DataBackupPolicy.
        """
        return pulumi.get(self, "category")

    @category.setter
    def category(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "category", value)

    @_builtins.property
    @pulumi.getter(name="compressType")
    def compress_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The compress type of instance policy. Valid values are `1`, `4`, `8`.
        """
        return pulumi.get(self, "compress_type")

    @compress_type.setter
    def compress_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compress_type", value)

    @_builtins.property
    @pulumi.getter(name="enableBackupLog")
    def enable_backup_log(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to backup instance log. Valid values are `true`, `false`, Default to `true`. Note: The 'Basic Edition' category Rds instance does not support setting log backup. [What is Basic Edition](https://www.alibabacloud.com/help/doc-detail/48980.htm).
        """
        return pulumi.get(self, "enable_backup_log")

    @enable_backup_log.setter
    def enable_backup_log(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_backup_log", value)

    @_builtins.property
    @pulumi.getter(name="enableIncrementDataBackup")
    def enable_increment_data_backup(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable incremental backup. Valid values:
        - false (default): disables the feature.
        - true: enables the feature.
        ->**NOTE:** This parameter takes effect only on instances that run SQL Server with cloud disks. This parameter takes effect only when BackupPolicyMode is set to DataBackupPolicy.
        """
        return pulumi.get(self, "enable_increment_data_backup")

    @enable_increment_data_backup.setter
    def enable_increment_data_backup(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_increment_data_backup", value)

    @_builtins.property
    @pulumi.getter(name="highSpaceUsageProtection")
    def high_space_usage_protection(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Instance high space usage protection policy. Valid when the `enable_backup_log` is `true`. Valid values are `Enable`, `Disable`.
        """
        return pulumi.get(self, "high_space_usage_protection")

    @high_space_usage_protection.setter
    def high_space_usage_protection(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "high_space_usage_protection", value)

    @_builtins.property
    @pulumi.getter(name="localLogRetentionHours")
    def local_log_retention_hours(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Instance log backup local retention hours. Valid when the `enable_backup_log` is `true`. Valid values: [0-7*24].
        """
        return pulumi.get(self, "local_log_retention_hours")

    @local_log_retention_hours.setter
    def local_log_retention_hours(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "local_log_retention_hours", value)

    @_builtins.property
    @pulumi.getter(name="localLogRetentionSpace")
    def local_log_retention_space(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Instance log backup local retention space. Valid when the `enable_backup_log` is `true`. Valid values: [0-50].
        """
        return pulumi.get(self, "local_log_retention_space")

    @local_log_retention_space.setter
    def local_log_retention_space(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "local_log_retention_space", value)

    @_builtins.property
    @pulumi.getter(name="logBackup")
    @_utilities.deprecated("""Attribute 'log_backup' has been deprecated from version 1.68.0. Use `enable_backup_log` instead""")
    def log_backup(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        It has been deprecated from version 1.68.0, and use field 'enable_backup_log' instead.
        """
        return pulumi.get(self, "log_backup")

    @log_backup.setter
    def log_backup(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "log_backup", value)

    @_builtins.property
    @pulumi.getter(name="logBackupFrequency")
    def log_backup_frequency(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Instance log backup frequency. Valid when the instance engine is `SQLServer`. Valid values are `LogInterval`.
        """
        return pulumi.get(self, "log_backup_frequency")

    @log_backup_frequency.setter
    def log_backup_frequency(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "log_backup_frequency", value)

    @_builtins.property
    @pulumi.getter(name="logBackupLocalRetentionNumber")
    def log_backup_local_retention_number(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of binary log files that you want to retain on the instance. Default value: 60. Valid values: 6 to 100.
        ->**NOTE:** This parameter takes effect only when you set the BackupPolicyMode parameter to LogBackupPolicy. If the instance runs MySQL, you can set this parameter to -1. The value -1 specifies that an unlimited number of binary log files can be retained on the instance.
        """
        return pulumi.get(self, "log_backup_local_retention_number")

    @log_backup_local_retention_number.setter
    def log_backup_local_retention_number(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "log_backup_local_retention_number", value)

    @_builtins.property
    @pulumi.getter(name="logBackupRetentionPeriod")
    def log_backup_retention_period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Instance log backup retention days. Valid when the `enable_backup_log` is `1`. Valid values: [7-730]. Default to 7. It cannot be larger than `backup_retention_period`.
        """
        return pulumi.get(self, "log_backup_retention_period")

    @log_backup_retention_period.setter
    def log_backup_retention_period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "log_backup_retention_period", value)

    @_builtins.property
    @pulumi.getter(name="logRetentionPeriod")
    @_utilities.deprecated("""Attribute 'log_retention_period' has been deprecated from version 1.69.0. Use `log_backup_retention_period` instead""")
    def log_retention_period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        It has been deprecated from version 1.69.0, and use field 'log_backup_retention_period' instead.
        """
        return pulumi.get(self, "log_retention_period")

    @log_retention_period.setter
    def log_retention_period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "log_retention_period", value)

    @_builtins.property
    @pulumi.getter(name="preferredBackupPeriods")
    def preferred_backup_periods(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        DB Instance backup period. Please set at least two days to ensure backing up at least twice a week. Valid values: [Monday, Tuesday, Wednesday, Thursday, Friday, Saturday, Sunday].
        """
        return pulumi.get(self, "preferred_backup_periods")

    @preferred_backup_periods.setter
    def preferred_backup_periods(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "preferred_backup_periods", value)

    @_builtins.property
    @pulumi.getter(name="preferredBackupTime")
    def preferred_backup_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        DB instance backup time, in the format of HH:mmZ- HH:mmZ. Time setting interval is one hour. Default to "02:00Z-03:00Z". China time is 8 hours behind it.
        """
        return pulumi.get(self, "preferred_backup_time")

    @preferred_backup_time.setter
    def preferred_backup_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "preferred_backup_time", value)

    @_builtins.property
    @pulumi.getter(name="releasedKeepPolicy")
    def released_keep_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The policy based on which ApsaraDB RDS retains archived backup files if the instance is released. Default value: None. Valid values:
        * **None**: No archived backup files are retained.
        * **Lastest**: Only the most recent archived backup file is retained.
        * **All**: All archived backup files are retained.
        """
        return pulumi.get(self, "released_keep_policy")

    @released_keep_policy.setter
    def released_keep_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "released_keep_policy", value)

    @_builtins.property
    @pulumi.getter(name="retentionPeriod")
    @_utilities.deprecated("""Attribute 'retention_period' has been deprecated from version 1.69.0. Use `backup_retention_period` instead""")
    def retention_period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        It has been deprecated from version 1.69.0, and use field 'backup_retention_period' instead.
        """
        return pulumi.get(self, "retention_period")

    @retention_period.setter
    def retention_period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "retention_period", value)


@pulumi.input_type
class _BackupPolicyState:
    def __init__(__self__, *,
                 archive_backup_keep_count: Optional[pulumi.Input[_builtins.int]] = None,
                 archive_backup_keep_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 archive_backup_retention_period: Optional[pulumi.Input[_builtins.int]] = None,
                 backup_interval: Optional[pulumi.Input[_builtins.str]] = None,
                 backup_method: Optional[pulumi.Input[_builtins.str]] = None,
                 backup_periods: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 backup_priority: Optional[pulumi.Input[_builtins.int]] = None,
                 backup_retention_period: Optional[pulumi.Input[_builtins.int]] = None,
                 backup_time: Optional[pulumi.Input[_builtins.str]] = None,
                 category: Optional[pulumi.Input[_builtins.str]] = None,
                 compress_type: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_backup_log: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_increment_data_backup: Optional[pulumi.Input[_builtins.bool]] = None,
                 high_space_usage_protection: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 local_log_retention_hours: Optional[pulumi.Input[_builtins.int]] = None,
                 local_log_retention_space: Optional[pulumi.Input[_builtins.int]] = None,
                 log_backup: Optional[pulumi.Input[_builtins.bool]] = None,
                 log_backup_frequency: Optional[pulumi.Input[_builtins.str]] = None,
                 log_backup_local_retention_number: Optional[pulumi.Input[_builtins.int]] = None,
                 log_backup_retention_period: Optional[pulumi.Input[_builtins.int]] = None,
                 log_retention_period: Optional[pulumi.Input[_builtins.int]] = None,
                 preferred_backup_periods: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 preferred_backup_time: Optional[pulumi.Input[_builtins.str]] = None,
                 released_keep_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 retention_period: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering BackupPolicy resources.
        :param pulumi.Input[_builtins.int] archive_backup_keep_count: Instance archive backup keep count. Valid when the `enable_backup_log` is `true` and instance is mysql local disk. When `archive_backup_keep_policy` is `ByMonth` Valid values: [1-31]. When `archive_backup_keep_policy` is `ByWeek` Valid values: [1-7].
        :param pulumi.Input[_builtins.str] archive_backup_keep_policy: Instance archive backup keep policy. Valid when the `enable_backup_log` is `true` and instance is mysql local disk. Valid values are `ByMonth`, `ByWeek`, `KeepAll`.
        :param pulumi.Input[_builtins.int] archive_backup_retention_period: Instance archive backup retention days. Valid when the `enable_backup_log` is `true` and instance is mysql local disk. Valid values: [30-1095], and `archive_backup_retention_period` must larger than `backup_retention_period` 730.
        :param pulumi.Input[_builtins.str] backup_interval: The frequency at which you want to perform a snapshot backup on the instance. Valid values:
               - -1: No backup frequencies are specified.
               - 30: A snapshot backup is performed once every 30 minutes.
               - 60: A snapshot backup is performed once every 60 minutes.
               - 120: A snapshot backup is performed once every 120 minutes.
               - 240: A snapshot backup is performed once every 240 minutes.
               - 360: A snapshot backup is performed once every 360 minutes.
               - 480: A snapshot backup is performed once every 480 minutes.
               - 720: A snapshot backup is performed once every 720 minutes.
        :param pulumi.Input[_builtins.str] backup_method: The backup method of the instance. Valid values:
               - Physical: physical backup
               - Snapshot: snapshot backup
               ->**NOTE:** This parameter takes effect only on instances that run SQL Server with cloud disks. This parameter takes effect only when BackupPolicyMode is set to DataBackupPolicy.
               
               > **NOTE:** Currently, the SQLServer instance does not support to modify `log_backup_retention_period`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] backup_periods: It has been deprecated from version 1.69.0, and use field 'preferred_backup_period' instead.
        :param pulumi.Input[_builtins.int] backup_priority: Specifies whether the backup settings of a secondary instance are configured. Valid values:
               - 1: secondary instance preferred
               - 2: primary instance preferred
               ->**NOTE:** This parameter is suitable only for instances that run SQL Server on RDS Cluster Edition. This parameter takes effect only when BackupMethod is set to Physical. If BackupMethod is set to Snapshot, backups are forcefully performed on the primary instance that runs SQL Server on RDS Cluster Edition.
        :param pulumi.Input[_builtins.int] backup_retention_period: Instance backup retention days. Valid values: [7-730]. Default to 7. But mysql local disk is unlimited.
        :param pulumi.Input[_builtins.str] backup_time: It has been deprecated from version 1.69.0, and use field 'preferred_backup_time' instead.
        :param pulumi.Input[_builtins.str] category: Whether to enable second level backup.Valid values are `Flash`, `Standard`, Note:It only takes effect when the BackupPolicyMode parameter is DataBackupPolicy.
               > **NOTE:** You can configure a backup policy by using this parameter and the PreferredBackupPeriod parameter. For example, if you set the PreferredBackupPeriod parameter to Saturday,Sunday and the BackupInterval parameter to -1, a snapshot backup is performed on every Saturday and Sunday.If the instance runs PostgreSQL, the BackupInterval parameter is supported only when the instance is equipped with standard SSDs or enhanced SSDs (ESSDs).This parameter takes effect only when you set the BackupPolicyMode parameter to DataBackupPolicy.
        :param pulumi.Input[_builtins.str] compress_type: The compress type of instance policy. Valid values are `1`, `4`, `8`.
        :param pulumi.Input[_builtins.bool] enable_backup_log: Whether to backup instance log. Valid values are `true`, `false`, Default to `true`. Note: The 'Basic Edition' category Rds instance does not support setting log backup. [What is Basic Edition](https://www.alibabacloud.com/help/doc-detail/48980.htm).
        :param pulumi.Input[_builtins.bool] enable_increment_data_backup: Specifies whether to enable incremental backup. Valid values:
               - false (default): disables the feature.
               - true: enables the feature.
               ->**NOTE:** This parameter takes effect only on instances that run SQL Server with cloud disks. This parameter takes effect only when BackupPolicyMode is set to DataBackupPolicy.
        :param pulumi.Input[_builtins.str] high_space_usage_protection: Instance high space usage protection policy. Valid when the `enable_backup_log` is `true`. Valid values are `Enable`, `Disable`.
        :param pulumi.Input[_builtins.str] instance_id: The Id of instance that can run database.
        :param pulumi.Input[_builtins.int] local_log_retention_hours: Instance log backup local retention hours. Valid when the `enable_backup_log` is `true`. Valid values: [0-7*24].
        :param pulumi.Input[_builtins.int] local_log_retention_space: Instance log backup local retention space. Valid when the `enable_backup_log` is `true`. Valid values: [0-50].
        :param pulumi.Input[_builtins.bool] log_backup: It has been deprecated from version 1.68.0, and use field 'enable_backup_log' instead.
        :param pulumi.Input[_builtins.str] log_backup_frequency: Instance log backup frequency. Valid when the instance engine is `SQLServer`. Valid values are `LogInterval`.
        :param pulumi.Input[_builtins.int] log_backup_local_retention_number: The number of binary log files that you want to retain on the instance. Default value: 60. Valid values: 6 to 100.
               ->**NOTE:** This parameter takes effect only when you set the BackupPolicyMode parameter to LogBackupPolicy. If the instance runs MySQL, you can set this parameter to -1. The value -1 specifies that an unlimited number of binary log files can be retained on the instance.
        :param pulumi.Input[_builtins.int] log_backup_retention_period: Instance log backup retention days. Valid when the `enable_backup_log` is `1`. Valid values: [7-730]. Default to 7. It cannot be larger than `backup_retention_period`.
        :param pulumi.Input[_builtins.int] log_retention_period: It has been deprecated from version 1.69.0, and use field 'log_backup_retention_period' instead.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] preferred_backup_periods: DB Instance backup period. Please set at least two days to ensure backing up at least twice a week. Valid values: [Monday, Tuesday, Wednesday, Thursday, Friday, Saturday, Sunday].
        :param pulumi.Input[_builtins.str] preferred_backup_time: DB instance backup time, in the format of HH:mmZ- HH:mmZ. Time setting interval is one hour. Default to "02:00Z-03:00Z". China time is 8 hours behind it.
        :param pulumi.Input[_builtins.str] released_keep_policy: The policy based on which ApsaraDB RDS retains archived backup files if the instance is released. Default value: None. Valid values:
               * **None**: No archived backup files are retained.
               * **Lastest**: Only the most recent archived backup file is retained.
               * **All**: All archived backup files are retained.
        :param pulumi.Input[_builtins.int] retention_period: It has been deprecated from version 1.69.0, and use field 'backup_retention_period' instead.
        """
        if archive_backup_keep_count is not None:
            pulumi.set(__self__, "archive_backup_keep_count", archive_backup_keep_count)
        if archive_backup_keep_policy is not None:
            pulumi.set(__self__, "archive_backup_keep_policy", archive_backup_keep_policy)
        if archive_backup_retention_period is not None:
            pulumi.set(__self__, "archive_backup_retention_period", archive_backup_retention_period)
        if backup_interval is not None:
            pulumi.set(__self__, "backup_interval", backup_interval)
        if backup_method is not None:
            pulumi.set(__self__, "backup_method", backup_method)
        if backup_periods is not None:
            warnings.warn("""Attribute 'backup_period' has been deprecated from version 1.69.0. Use `preferred_backup_period` instead""", DeprecationWarning)
            pulumi.log.warn("""backup_periods is deprecated: Attribute 'backup_period' has been deprecated from version 1.69.0. Use `preferred_backup_period` instead""")
        if backup_periods is not None:
            pulumi.set(__self__, "backup_periods", backup_periods)
        if backup_priority is not None:
            pulumi.set(__self__, "backup_priority", backup_priority)
        if backup_retention_period is not None:
            pulumi.set(__self__, "backup_retention_period", backup_retention_period)
        if backup_time is not None:
            warnings.warn("""Attribute 'backup_time' has been deprecated from version 1.69.0. Use `preferred_backup_time` instead""", DeprecationWarning)
            pulumi.log.warn("""backup_time is deprecated: Attribute 'backup_time' has been deprecated from version 1.69.0. Use `preferred_backup_time` instead""")
        if backup_time is not None:
            pulumi.set(__self__, "backup_time", backup_time)
        if category is not None:
            pulumi.set(__self__, "category", category)
        if compress_type is not None:
            pulumi.set(__self__, "compress_type", compress_type)
        if enable_backup_log is not None:
            pulumi.set(__self__, "enable_backup_log", enable_backup_log)
        if enable_increment_data_backup is not None:
            pulumi.set(__self__, "enable_increment_data_backup", enable_increment_data_backup)
        if high_space_usage_protection is not None:
            pulumi.set(__self__, "high_space_usage_protection", high_space_usage_protection)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if local_log_retention_hours is not None:
            pulumi.set(__self__, "local_log_retention_hours", local_log_retention_hours)
        if local_log_retention_space is not None:
            pulumi.set(__self__, "local_log_retention_space", local_log_retention_space)
        if log_backup is not None:
            warnings.warn("""Attribute 'log_backup' has been deprecated from version 1.68.0. Use `enable_backup_log` instead""", DeprecationWarning)
            pulumi.log.warn("""log_backup is deprecated: Attribute 'log_backup' has been deprecated from version 1.68.0. Use `enable_backup_log` instead""")
        if log_backup is not None:
            pulumi.set(__self__, "log_backup", log_backup)
        if log_backup_frequency is not None:
            pulumi.set(__self__, "log_backup_frequency", log_backup_frequency)
        if log_backup_local_retention_number is not None:
            pulumi.set(__self__, "log_backup_local_retention_number", log_backup_local_retention_number)
        if log_backup_retention_period is not None:
            pulumi.set(__self__, "log_backup_retention_period", log_backup_retention_period)
        if log_retention_period is not None:
            warnings.warn("""Attribute 'log_retention_period' has been deprecated from version 1.69.0. Use `log_backup_retention_period` instead""", DeprecationWarning)
            pulumi.log.warn("""log_retention_period is deprecated: Attribute 'log_retention_period' has been deprecated from version 1.69.0. Use `log_backup_retention_period` instead""")
        if log_retention_period is not None:
            pulumi.set(__self__, "log_retention_period", log_retention_period)
        if preferred_backup_periods is not None:
            pulumi.set(__self__, "preferred_backup_periods", preferred_backup_periods)
        if preferred_backup_time is not None:
            pulumi.set(__self__, "preferred_backup_time", preferred_backup_time)
        if released_keep_policy is not None:
            pulumi.set(__self__, "released_keep_policy", released_keep_policy)
        if retention_period is not None:
            warnings.warn("""Attribute 'retention_period' has been deprecated from version 1.69.0. Use `backup_retention_period` instead""", DeprecationWarning)
            pulumi.log.warn("""retention_period is deprecated: Attribute 'retention_period' has been deprecated from version 1.69.0. Use `backup_retention_period` instead""")
        if retention_period is not None:
            pulumi.set(__self__, "retention_period", retention_period)

    @_builtins.property
    @pulumi.getter(name="archiveBackupKeepCount")
    def archive_backup_keep_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Instance archive backup keep count. Valid when the `enable_backup_log` is `true` and instance is mysql local disk. When `archive_backup_keep_policy` is `ByMonth` Valid values: [1-31]. When `archive_backup_keep_policy` is `ByWeek` Valid values: [1-7].
        """
        return pulumi.get(self, "archive_backup_keep_count")

    @archive_backup_keep_count.setter
    def archive_backup_keep_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "archive_backup_keep_count", value)

    @_builtins.property
    @pulumi.getter(name="archiveBackupKeepPolicy")
    def archive_backup_keep_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Instance archive backup keep policy. Valid when the `enable_backup_log` is `true` and instance is mysql local disk. Valid values are `ByMonth`, `ByWeek`, `KeepAll`.
        """
        return pulumi.get(self, "archive_backup_keep_policy")

    @archive_backup_keep_policy.setter
    def archive_backup_keep_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "archive_backup_keep_policy", value)

    @_builtins.property
    @pulumi.getter(name="archiveBackupRetentionPeriod")
    def archive_backup_retention_period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Instance archive backup retention days. Valid when the `enable_backup_log` is `true` and instance is mysql local disk. Valid values: [30-1095], and `archive_backup_retention_period` must larger than `backup_retention_period` 730.
        """
        return pulumi.get(self, "archive_backup_retention_period")

    @archive_backup_retention_period.setter
    def archive_backup_retention_period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "archive_backup_retention_period", value)

    @_builtins.property
    @pulumi.getter(name="backupInterval")
    def backup_interval(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The frequency at which you want to perform a snapshot backup on the instance. Valid values:
        - -1: No backup frequencies are specified.
        - 30: A snapshot backup is performed once every 30 minutes.
        - 60: A snapshot backup is performed once every 60 minutes.
        - 120: A snapshot backup is performed once every 120 minutes.
        - 240: A snapshot backup is performed once every 240 minutes.
        - 360: A snapshot backup is performed once every 360 minutes.
        - 480: A snapshot backup is performed once every 480 minutes.
        - 720: A snapshot backup is performed once every 720 minutes.
        """
        return pulumi.get(self, "backup_interval")

    @backup_interval.setter
    def backup_interval(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backup_interval", value)

    @_builtins.property
    @pulumi.getter(name="backupMethod")
    def backup_method(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The backup method of the instance. Valid values:
        - Physical: physical backup
        - Snapshot: snapshot backup
        ->**NOTE:** This parameter takes effect only on instances that run SQL Server with cloud disks. This parameter takes effect only when BackupPolicyMode is set to DataBackupPolicy.

        > **NOTE:** Currently, the SQLServer instance does not support to modify `log_backup_retention_period`.
        """
        return pulumi.get(self, "backup_method")

    @backup_method.setter
    def backup_method(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backup_method", value)

    @_builtins.property
    @pulumi.getter(name="backupPeriods")
    @_utilities.deprecated("""Attribute 'backup_period' has been deprecated from version 1.69.0. Use `preferred_backup_period` instead""")
    def backup_periods(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        It has been deprecated from version 1.69.0, and use field 'preferred_backup_period' instead.
        """
        return pulumi.get(self, "backup_periods")

    @backup_periods.setter
    def backup_periods(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "backup_periods", value)

    @_builtins.property
    @pulumi.getter(name="backupPriority")
    def backup_priority(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies whether the backup settings of a secondary instance are configured. Valid values:
        - 1: secondary instance preferred
        - 2: primary instance preferred
        ->**NOTE:** This parameter is suitable only for instances that run SQL Server on RDS Cluster Edition. This parameter takes effect only when BackupMethod is set to Physical. If BackupMethod is set to Snapshot, backups are forcefully performed on the primary instance that runs SQL Server on RDS Cluster Edition.
        """
        return pulumi.get(self, "backup_priority")

    @backup_priority.setter
    def backup_priority(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "backup_priority", value)

    @_builtins.property
    @pulumi.getter(name="backupRetentionPeriod")
    def backup_retention_period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Instance backup retention days. Valid values: [7-730]. Default to 7. But mysql local disk is unlimited.
        """
        return pulumi.get(self, "backup_retention_period")

    @backup_retention_period.setter
    def backup_retention_period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "backup_retention_period", value)

    @_builtins.property
    @pulumi.getter(name="backupTime")
    @_utilities.deprecated("""Attribute 'backup_time' has been deprecated from version 1.69.0. Use `preferred_backup_time` instead""")
    def backup_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        It has been deprecated from version 1.69.0, and use field 'preferred_backup_time' instead.
        """
        return pulumi.get(self, "backup_time")

    @backup_time.setter
    def backup_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backup_time", value)

    @_builtins.property
    @pulumi.getter
    def category(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether to enable second level backup.Valid values are `Flash`, `Standard`, Note:It only takes effect when the BackupPolicyMode parameter is DataBackupPolicy.
        > **NOTE:** You can configure a backup policy by using this parameter and the PreferredBackupPeriod parameter. For example, if you set the PreferredBackupPeriod parameter to Saturday,Sunday and the BackupInterval parameter to -1, a snapshot backup is performed on every Saturday and Sunday.If the instance runs PostgreSQL, the BackupInterval parameter is supported only when the instance is equipped with standard SSDs or enhanced SSDs (ESSDs).This parameter takes effect only when you set the BackupPolicyMode parameter to DataBackupPolicy.
        """
        return pulumi.get(self, "category")

    @category.setter
    def category(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "category", value)

    @_builtins.property
    @pulumi.getter(name="compressType")
    def compress_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The compress type of instance policy. Valid values are `1`, `4`, `8`.
        """
        return pulumi.get(self, "compress_type")

    @compress_type.setter
    def compress_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compress_type", value)

    @_builtins.property
    @pulumi.getter(name="enableBackupLog")
    def enable_backup_log(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to backup instance log. Valid values are `true`, `false`, Default to `true`. Note: The 'Basic Edition' category Rds instance does not support setting log backup. [What is Basic Edition](https://www.alibabacloud.com/help/doc-detail/48980.htm).
        """
        return pulumi.get(self, "enable_backup_log")

    @enable_backup_log.setter
    def enable_backup_log(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_backup_log", value)

    @_builtins.property
    @pulumi.getter(name="enableIncrementDataBackup")
    def enable_increment_data_backup(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable incremental backup. Valid values:
        - false (default): disables the feature.
        - true: enables the feature.
        ->**NOTE:** This parameter takes effect only on instances that run SQL Server with cloud disks. This parameter takes effect only when BackupPolicyMode is set to DataBackupPolicy.
        """
        return pulumi.get(self, "enable_increment_data_backup")

    @enable_increment_data_backup.setter
    def enable_increment_data_backup(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_increment_data_backup", value)

    @_builtins.property
    @pulumi.getter(name="highSpaceUsageProtection")
    def high_space_usage_protection(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Instance high space usage protection policy. Valid when the `enable_backup_log` is `true`. Valid values are `Enable`, `Disable`.
        """
        return pulumi.get(self, "high_space_usage_protection")

    @high_space_usage_protection.setter
    def high_space_usage_protection(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "high_space_usage_protection", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Id of instance that can run database.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="localLogRetentionHours")
    def local_log_retention_hours(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Instance log backup local retention hours. Valid when the `enable_backup_log` is `true`. Valid values: [0-7*24].
        """
        return pulumi.get(self, "local_log_retention_hours")

    @local_log_retention_hours.setter
    def local_log_retention_hours(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "local_log_retention_hours", value)

    @_builtins.property
    @pulumi.getter(name="localLogRetentionSpace")
    def local_log_retention_space(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Instance log backup local retention space. Valid when the `enable_backup_log` is `true`. Valid values: [0-50].
        """
        return pulumi.get(self, "local_log_retention_space")

    @local_log_retention_space.setter
    def local_log_retention_space(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "local_log_retention_space", value)

    @_builtins.property
    @pulumi.getter(name="logBackup")
    @_utilities.deprecated("""Attribute 'log_backup' has been deprecated from version 1.68.0. Use `enable_backup_log` instead""")
    def log_backup(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        It has been deprecated from version 1.68.0, and use field 'enable_backup_log' instead.
        """
        return pulumi.get(self, "log_backup")

    @log_backup.setter
    def log_backup(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "log_backup", value)

    @_builtins.property
    @pulumi.getter(name="logBackupFrequency")
    def log_backup_frequency(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Instance log backup frequency. Valid when the instance engine is `SQLServer`. Valid values are `LogInterval`.
        """
        return pulumi.get(self, "log_backup_frequency")

    @log_backup_frequency.setter
    def log_backup_frequency(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "log_backup_frequency", value)

    @_builtins.property
    @pulumi.getter(name="logBackupLocalRetentionNumber")
    def log_backup_local_retention_number(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of binary log files that you want to retain on the instance. Default value: 60. Valid values: 6 to 100.
        ->**NOTE:** This parameter takes effect only when you set the BackupPolicyMode parameter to LogBackupPolicy. If the instance runs MySQL, you can set this parameter to -1. The value -1 specifies that an unlimited number of binary log files can be retained on the instance.
        """
        return pulumi.get(self, "log_backup_local_retention_number")

    @log_backup_local_retention_number.setter
    def log_backup_local_retention_number(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "log_backup_local_retention_number", value)

    @_builtins.property
    @pulumi.getter(name="logBackupRetentionPeriod")
    def log_backup_retention_period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Instance log backup retention days. Valid when the `enable_backup_log` is `1`. Valid values: [7-730]. Default to 7. It cannot be larger than `backup_retention_period`.
        """
        return pulumi.get(self, "log_backup_retention_period")

    @log_backup_retention_period.setter
    def log_backup_retention_period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "log_backup_retention_period", value)

    @_builtins.property
    @pulumi.getter(name="logRetentionPeriod")
    @_utilities.deprecated("""Attribute 'log_retention_period' has been deprecated from version 1.69.0. Use `log_backup_retention_period` instead""")
    def log_retention_period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        It has been deprecated from version 1.69.0, and use field 'log_backup_retention_period' instead.
        """
        return pulumi.get(self, "log_retention_period")

    @log_retention_period.setter
    def log_retention_period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "log_retention_period", value)

    @_builtins.property
    @pulumi.getter(name="preferredBackupPeriods")
    def preferred_backup_periods(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        DB Instance backup period. Please set at least two days to ensure backing up at least twice a week. Valid values: [Monday, Tuesday, Wednesday, Thursday, Friday, Saturday, Sunday].
        """
        return pulumi.get(self, "preferred_backup_periods")

    @preferred_backup_periods.setter
    def preferred_backup_periods(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "preferred_backup_periods", value)

    @_builtins.property
    @pulumi.getter(name="preferredBackupTime")
    def preferred_backup_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        DB instance backup time, in the format of HH:mmZ- HH:mmZ. Time setting interval is one hour. Default to "02:00Z-03:00Z". China time is 8 hours behind it.
        """
        return pulumi.get(self, "preferred_backup_time")

    @preferred_backup_time.setter
    def preferred_backup_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "preferred_backup_time", value)

    @_builtins.property
    @pulumi.getter(name="releasedKeepPolicy")
    def released_keep_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The policy based on which ApsaraDB RDS retains archived backup files if the instance is released. Default value: None. Valid values:
        * **None**: No archived backup files are retained.
        * **Lastest**: Only the most recent archived backup file is retained.
        * **All**: All archived backup files are retained.
        """
        return pulumi.get(self, "released_keep_policy")

    @released_keep_policy.setter
    def released_keep_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "released_keep_policy", value)

    @_builtins.property
    @pulumi.getter(name="retentionPeriod")
    @_utilities.deprecated("""Attribute 'retention_period' has been deprecated from version 1.69.0. Use `backup_retention_period` instead""")
    def retention_period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        It has been deprecated from version 1.69.0, and use field 'backup_retention_period' instead.
        """
        return pulumi.get(self, "retention_period")

    @retention_period.setter
    def retention_period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "retention_period", value)


@pulumi.type_token("alicloud:rds/backupPolicy:BackupPolicy")
class BackupPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 archive_backup_keep_count: Optional[pulumi.Input[_builtins.int]] = None,
                 archive_backup_keep_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 archive_backup_retention_period: Optional[pulumi.Input[_builtins.int]] = None,
                 backup_interval: Optional[pulumi.Input[_builtins.str]] = None,
                 backup_method: Optional[pulumi.Input[_builtins.str]] = None,
                 backup_periods: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 backup_priority: Optional[pulumi.Input[_builtins.int]] = None,
                 backup_retention_period: Optional[pulumi.Input[_builtins.int]] = None,
                 backup_time: Optional[pulumi.Input[_builtins.str]] = None,
                 category: Optional[pulumi.Input[_builtins.str]] = None,
                 compress_type: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_backup_log: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_increment_data_backup: Optional[pulumi.Input[_builtins.bool]] = None,
                 high_space_usage_protection: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 local_log_retention_hours: Optional[pulumi.Input[_builtins.int]] = None,
                 local_log_retention_space: Optional[pulumi.Input[_builtins.int]] = None,
                 log_backup: Optional[pulumi.Input[_builtins.bool]] = None,
                 log_backup_frequency: Optional[pulumi.Input[_builtins.str]] = None,
                 log_backup_local_retention_number: Optional[pulumi.Input[_builtins.int]] = None,
                 log_backup_retention_period: Optional[pulumi.Input[_builtins.int]] = None,
                 log_retention_period: Optional[pulumi.Input[_builtins.int]] = None,
                 preferred_backup_periods: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 preferred_backup_time: Optional[pulumi.Input[_builtins.str]] = None,
                 released_keep_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 retention_period: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        Provides an RDS instance backup policy resource and used to configure instance backup policy, see [What is DB Backup Policy](https://www.alibabacloud.com/help/en/apsaradb-for-rds/latest/api-rds-2014-08-15-modifybackuppolicy).

        > **NOTE:** Each DB instance has a backup policy and it will be set default values when destroying the resource.

        > **NOTE:** Available since v1.5.0.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        default = alicloud.rds.get_zones(engine="MySQL",
            engine_version="5.6")
        default_network = alicloud.vpc.Network("default",
            vpc_name=name,
            cidr_block="172.16.0.0/16")
        default_switch = alicloud.vpc.Switch("default",
            vpc_id=default_network.id,
            cidr_block="172.16.0.0/24",
            zone_id=default.zones[0].id,
            vswitch_name=name)
        instance = alicloud.rds.Instance("instance",
            engine="MySQL",
            engine_version="5.6",
            instance_type="rds.mysql.s1.small",
            instance_storage=10,
            vswitch_id=default_switch.id,
            instance_name=name)
        policy = alicloud.rds.BackupPolicy("policy", instance_id=instance.id)
        ```

        ## Import

        RDS backup policy can be imported using the id or instance id, e.g.

        ```sh
        $ pulumi import alicloud:rds/backupPolicy:BackupPolicy example "rm-12345678"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] archive_backup_keep_count: Instance archive backup keep count. Valid when the `enable_backup_log` is `true` and instance is mysql local disk. When `archive_backup_keep_policy` is `ByMonth` Valid values: [1-31]. When `archive_backup_keep_policy` is `ByWeek` Valid values: [1-7].
        :param pulumi.Input[_builtins.str] archive_backup_keep_policy: Instance archive backup keep policy. Valid when the `enable_backup_log` is `true` and instance is mysql local disk. Valid values are `ByMonth`, `ByWeek`, `KeepAll`.
        :param pulumi.Input[_builtins.int] archive_backup_retention_period: Instance archive backup retention days. Valid when the `enable_backup_log` is `true` and instance is mysql local disk. Valid values: [30-1095], and `archive_backup_retention_period` must larger than `backup_retention_period` 730.
        :param pulumi.Input[_builtins.str] backup_interval: The frequency at which you want to perform a snapshot backup on the instance. Valid values:
               - -1: No backup frequencies are specified.
               - 30: A snapshot backup is performed once every 30 minutes.
               - 60: A snapshot backup is performed once every 60 minutes.
               - 120: A snapshot backup is performed once every 120 minutes.
               - 240: A snapshot backup is performed once every 240 minutes.
               - 360: A snapshot backup is performed once every 360 minutes.
               - 480: A snapshot backup is performed once every 480 minutes.
               - 720: A snapshot backup is performed once every 720 minutes.
        :param pulumi.Input[_builtins.str] backup_method: The backup method of the instance. Valid values:
               - Physical: physical backup
               - Snapshot: snapshot backup
               ->**NOTE:** This parameter takes effect only on instances that run SQL Server with cloud disks. This parameter takes effect only when BackupPolicyMode is set to DataBackupPolicy.
               
               > **NOTE:** Currently, the SQLServer instance does not support to modify `log_backup_retention_period`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] backup_periods: It has been deprecated from version 1.69.0, and use field 'preferred_backup_period' instead.
        :param pulumi.Input[_builtins.int] backup_priority: Specifies whether the backup settings of a secondary instance are configured. Valid values:
               - 1: secondary instance preferred
               - 2: primary instance preferred
               ->**NOTE:** This parameter is suitable only for instances that run SQL Server on RDS Cluster Edition. This parameter takes effect only when BackupMethod is set to Physical. If BackupMethod is set to Snapshot, backups are forcefully performed on the primary instance that runs SQL Server on RDS Cluster Edition.
        :param pulumi.Input[_builtins.int] backup_retention_period: Instance backup retention days. Valid values: [7-730]. Default to 7. But mysql local disk is unlimited.
        :param pulumi.Input[_builtins.str] backup_time: It has been deprecated from version 1.69.0, and use field 'preferred_backup_time' instead.
        :param pulumi.Input[_builtins.str] category: Whether to enable second level backup.Valid values are `Flash`, `Standard`, Note:It only takes effect when the BackupPolicyMode parameter is DataBackupPolicy.
               > **NOTE:** You can configure a backup policy by using this parameter and the PreferredBackupPeriod parameter. For example, if you set the PreferredBackupPeriod parameter to Saturday,Sunday and the BackupInterval parameter to -1, a snapshot backup is performed on every Saturday and Sunday.If the instance runs PostgreSQL, the BackupInterval parameter is supported only when the instance is equipped with standard SSDs or enhanced SSDs (ESSDs).This parameter takes effect only when you set the BackupPolicyMode parameter to DataBackupPolicy.
        :param pulumi.Input[_builtins.str] compress_type: The compress type of instance policy. Valid values are `1`, `4`, `8`.
        :param pulumi.Input[_builtins.bool] enable_backup_log: Whether to backup instance log. Valid values are `true`, `false`, Default to `true`. Note: The 'Basic Edition' category Rds instance does not support setting log backup. [What is Basic Edition](https://www.alibabacloud.com/help/doc-detail/48980.htm).
        :param pulumi.Input[_builtins.bool] enable_increment_data_backup: Specifies whether to enable incremental backup. Valid values:
               - false (default): disables the feature.
               - true: enables the feature.
               ->**NOTE:** This parameter takes effect only on instances that run SQL Server with cloud disks. This parameter takes effect only when BackupPolicyMode is set to DataBackupPolicy.
        :param pulumi.Input[_builtins.str] high_space_usage_protection: Instance high space usage protection policy. Valid when the `enable_backup_log` is `true`. Valid values are `Enable`, `Disable`.
        :param pulumi.Input[_builtins.str] instance_id: The Id of instance that can run database.
        :param pulumi.Input[_builtins.int] local_log_retention_hours: Instance log backup local retention hours. Valid when the `enable_backup_log` is `true`. Valid values: [0-7*24].
        :param pulumi.Input[_builtins.int] local_log_retention_space: Instance log backup local retention space. Valid when the `enable_backup_log` is `true`. Valid values: [0-50].
        :param pulumi.Input[_builtins.bool] log_backup: It has been deprecated from version 1.68.0, and use field 'enable_backup_log' instead.
        :param pulumi.Input[_builtins.str] log_backup_frequency: Instance log backup frequency. Valid when the instance engine is `SQLServer`. Valid values are `LogInterval`.
        :param pulumi.Input[_builtins.int] log_backup_local_retention_number: The number of binary log files that you want to retain on the instance. Default value: 60. Valid values: 6 to 100.
               ->**NOTE:** This parameter takes effect only when you set the BackupPolicyMode parameter to LogBackupPolicy. If the instance runs MySQL, you can set this parameter to -1. The value -1 specifies that an unlimited number of binary log files can be retained on the instance.
        :param pulumi.Input[_builtins.int] log_backup_retention_period: Instance log backup retention days. Valid when the `enable_backup_log` is `1`. Valid values: [7-730]. Default to 7. It cannot be larger than `backup_retention_period`.
        :param pulumi.Input[_builtins.int] log_retention_period: It has been deprecated from version 1.69.0, and use field 'log_backup_retention_period' instead.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] preferred_backup_periods: DB Instance backup period. Please set at least two days to ensure backing up at least twice a week. Valid values: [Monday, Tuesday, Wednesday, Thursday, Friday, Saturday, Sunday].
        :param pulumi.Input[_builtins.str] preferred_backup_time: DB instance backup time, in the format of HH:mmZ- HH:mmZ. Time setting interval is one hour. Default to "02:00Z-03:00Z". China time is 8 hours behind it.
        :param pulumi.Input[_builtins.str] released_keep_policy: The policy based on which ApsaraDB RDS retains archived backup files if the instance is released. Default value: None. Valid values:
               * **None**: No archived backup files are retained.
               * **Lastest**: Only the most recent archived backup file is retained.
               * **All**: All archived backup files are retained.
        :param pulumi.Input[_builtins.int] retention_period: It has been deprecated from version 1.69.0, and use field 'backup_retention_period' instead.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BackupPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an RDS instance backup policy resource and used to configure instance backup policy, see [What is DB Backup Policy](https://www.alibabacloud.com/help/en/apsaradb-for-rds/latest/api-rds-2014-08-15-modifybackuppolicy).

        > **NOTE:** Each DB instance has a backup policy and it will be set default values when destroying the resource.

        > **NOTE:** Available since v1.5.0.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        default = alicloud.rds.get_zones(engine="MySQL",
            engine_version="5.6")
        default_network = alicloud.vpc.Network("default",
            vpc_name=name,
            cidr_block="172.16.0.0/16")
        default_switch = alicloud.vpc.Switch("default",
            vpc_id=default_network.id,
            cidr_block="172.16.0.0/24",
            zone_id=default.zones[0].id,
            vswitch_name=name)
        instance = alicloud.rds.Instance("instance",
            engine="MySQL",
            engine_version="5.6",
            instance_type="rds.mysql.s1.small",
            instance_storage=10,
            vswitch_id=default_switch.id,
            instance_name=name)
        policy = alicloud.rds.BackupPolicy("policy", instance_id=instance.id)
        ```

        ## Import

        RDS backup policy can be imported using the id or instance id, e.g.

        ```sh
        $ pulumi import alicloud:rds/backupPolicy:BackupPolicy example "rm-12345678"
        ```

        :param str resource_name: The name of the resource.
        :param BackupPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BackupPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 archive_backup_keep_count: Optional[pulumi.Input[_builtins.int]] = None,
                 archive_backup_keep_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 archive_backup_retention_period: Optional[pulumi.Input[_builtins.int]] = None,
                 backup_interval: Optional[pulumi.Input[_builtins.str]] = None,
                 backup_method: Optional[pulumi.Input[_builtins.str]] = None,
                 backup_periods: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 backup_priority: Optional[pulumi.Input[_builtins.int]] = None,
                 backup_retention_period: Optional[pulumi.Input[_builtins.int]] = None,
                 backup_time: Optional[pulumi.Input[_builtins.str]] = None,
                 category: Optional[pulumi.Input[_builtins.str]] = None,
                 compress_type: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_backup_log: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_increment_data_backup: Optional[pulumi.Input[_builtins.bool]] = None,
                 high_space_usage_protection: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 local_log_retention_hours: Optional[pulumi.Input[_builtins.int]] = None,
                 local_log_retention_space: Optional[pulumi.Input[_builtins.int]] = None,
                 log_backup: Optional[pulumi.Input[_builtins.bool]] = None,
                 log_backup_frequency: Optional[pulumi.Input[_builtins.str]] = None,
                 log_backup_local_retention_number: Optional[pulumi.Input[_builtins.int]] = None,
                 log_backup_retention_period: Optional[pulumi.Input[_builtins.int]] = None,
                 log_retention_period: Optional[pulumi.Input[_builtins.int]] = None,
                 preferred_backup_periods: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 preferred_backup_time: Optional[pulumi.Input[_builtins.str]] = None,
                 released_keep_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 retention_period: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BackupPolicyArgs.__new__(BackupPolicyArgs)

            __props__.__dict__["archive_backup_keep_count"] = archive_backup_keep_count
            __props__.__dict__["archive_backup_keep_policy"] = archive_backup_keep_policy
            __props__.__dict__["archive_backup_retention_period"] = archive_backup_retention_period
            __props__.__dict__["backup_interval"] = backup_interval
            __props__.__dict__["backup_method"] = backup_method
            __props__.__dict__["backup_periods"] = backup_periods
            __props__.__dict__["backup_priority"] = backup_priority
            __props__.__dict__["backup_retention_period"] = backup_retention_period
            __props__.__dict__["backup_time"] = backup_time
            __props__.__dict__["category"] = category
            __props__.__dict__["compress_type"] = compress_type
            __props__.__dict__["enable_backup_log"] = enable_backup_log
            __props__.__dict__["enable_increment_data_backup"] = enable_increment_data_backup
            __props__.__dict__["high_space_usage_protection"] = high_space_usage_protection
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["local_log_retention_hours"] = local_log_retention_hours
            __props__.__dict__["local_log_retention_space"] = local_log_retention_space
            __props__.__dict__["log_backup"] = log_backup
            __props__.__dict__["log_backup_frequency"] = log_backup_frequency
            __props__.__dict__["log_backup_local_retention_number"] = log_backup_local_retention_number
            __props__.__dict__["log_backup_retention_period"] = log_backup_retention_period
            __props__.__dict__["log_retention_period"] = log_retention_period
            __props__.__dict__["preferred_backup_periods"] = preferred_backup_periods
            __props__.__dict__["preferred_backup_time"] = preferred_backup_time
            __props__.__dict__["released_keep_policy"] = released_keep_policy
            __props__.__dict__["retention_period"] = retention_period
        super(BackupPolicy, __self__).__init__(
            'alicloud:rds/backupPolicy:BackupPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            archive_backup_keep_count: Optional[pulumi.Input[_builtins.int]] = None,
            archive_backup_keep_policy: Optional[pulumi.Input[_builtins.str]] = None,
            archive_backup_retention_period: Optional[pulumi.Input[_builtins.int]] = None,
            backup_interval: Optional[pulumi.Input[_builtins.str]] = None,
            backup_method: Optional[pulumi.Input[_builtins.str]] = None,
            backup_periods: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            backup_priority: Optional[pulumi.Input[_builtins.int]] = None,
            backup_retention_period: Optional[pulumi.Input[_builtins.int]] = None,
            backup_time: Optional[pulumi.Input[_builtins.str]] = None,
            category: Optional[pulumi.Input[_builtins.str]] = None,
            compress_type: Optional[pulumi.Input[_builtins.str]] = None,
            enable_backup_log: Optional[pulumi.Input[_builtins.bool]] = None,
            enable_increment_data_backup: Optional[pulumi.Input[_builtins.bool]] = None,
            high_space_usage_protection: Optional[pulumi.Input[_builtins.str]] = None,
            instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            local_log_retention_hours: Optional[pulumi.Input[_builtins.int]] = None,
            local_log_retention_space: Optional[pulumi.Input[_builtins.int]] = None,
            log_backup: Optional[pulumi.Input[_builtins.bool]] = None,
            log_backup_frequency: Optional[pulumi.Input[_builtins.str]] = None,
            log_backup_local_retention_number: Optional[pulumi.Input[_builtins.int]] = None,
            log_backup_retention_period: Optional[pulumi.Input[_builtins.int]] = None,
            log_retention_period: Optional[pulumi.Input[_builtins.int]] = None,
            preferred_backup_periods: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            preferred_backup_time: Optional[pulumi.Input[_builtins.str]] = None,
            released_keep_policy: Optional[pulumi.Input[_builtins.str]] = None,
            retention_period: Optional[pulumi.Input[_builtins.int]] = None) -> 'BackupPolicy':
        """
        Get an existing BackupPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] archive_backup_keep_count: Instance archive backup keep count. Valid when the `enable_backup_log` is `true` and instance is mysql local disk. When `archive_backup_keep_policy` is `ByMonth` Valid values: [1-31]. When `archive_backup_keep_policy` is `ByWeek` Valid values: [1-7].
        :param pulumi.Input[_builtins.str] archive_backup_keep_policy: Instance archive backup keep policy. Valid when the `enable_backup_log` is `true` and instance is mysql local disk. Valid values are `ByMonth`, `ByWeek`, `KeepAll`.
        :param pulumi.Input[_builtins.int] archive_backup_retention_period: Instance archive backup retention days. Valid when the `enable_backup_log` is `true` and instance is mysql local disk. Valid values: [30-1095], and `archive_backup_retention_period` must larger than `backup_retention_period` 730.
        :param pulumi.Input[_builtins.str] backup_interval: The frequency at which you want to perform a snapshot backup on the instance. Valid values:
               - -1: No backup frequencies are specified.
               - 30: A snapshot backup is performed once every 30 minutes.
               - 60: A snapshot backup is performed once every 60 minutes.
               - 120: A snapshot backup is performed once every 120 minutes.
               - 240: A snapshot backup is performed once every 240 minutes.
               - 360: A snapshot backup is performed once every 360 minutes.
               - 480: A snapshot backup is performed once every 480 minutes.
               - 720: A snapshot backup is performed once every 720 minutes.
        :param pulumi.Input[_builtins.str] backup_method: The backup method of the instance. Valid values:
               - Physical: physical backup
               - Snapshot: snapshot backup
               ->**NOTE:** This parameter takes effect only on instances that run SQL Server with cloud disks. This parameter takes effect only when BackupPolicyMode is set to DataBackupPolicy.
               
               > **NOTE:** Currently, the SQLServer instance does not support to modify `log_backup_retention_period`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] backup_periods: It has been deprecated from version 1.69.0, and use field 'preferred_backup_period' instead.
        :param pulumi.Input[_builtins.int] backup_priority: Specifies whether the backup settings of a secondary instance are configured. Valid values:
               - 1: secondary instance preferred
               - 2: primary instance preferred
               ->**NOTE:** This parameter is suitable only for instances that run SQL Server on RDS Cluster Edition. This parameter takes effect only when BackupMethod is set to Physical. If BackupMethod is set to Snapshot, backups are forcefully performed on the primary instance that runs SQL Server on RDS Cluster Edition.
        :param pulumi.Input[_builtins.int] backup_retention_period: Instance backup retention days. Valid values: [7-730]. Default to 7. But mysql local disk is unlimited.
        :param pulumi.Input[_builtins.str] backup_time: It has been deprecated from version 1.69.0, and use field 'preferred_backup_time' instead.
        :param pulumi.Input[_builtins.str] category: Whether to enable second level backup.Valid values are `Flash`, `Standard`, Note:It only takes effect when the BackupPolicyMode parameter is DataBackupPolicy.
               > **NOTE:** You can configure a backup policy by using this parameter and the PreferredBackupPeriod parameter. For example, if you set the PreferredBackupPeriod parameter to Saturday,Sunday and the BackupInterval parameter to -1, a snapshot backup is performed on every Saturday and Sunday.If the instance runs PostgreSQL, the BackupInterval parameter is supported only when the instance is equipped with standard SSDs or enhanced SSDs (ESSDs).This parameter takes effect only when you set the BackupPolicyMode parameter to DataBackupPolicy.
        :param pulumi.Input[_builtins.str] compress_type: The compress type of instance policy. Valid values are `1`, `4`, `8`.
        :param pulumi.Input[_builtins.bool] enable_backup_log: Whether to backup instance log. Valid values are `true`, `false`, Default to `true`. Note: The 'Basic Edition' category Rds instance does not support setting log backup. [What is Basic Edition](https://www.alibabacloud.com/help/doc-detail/48980.htm).
        :param pulumi.Input[_builtins.bool] enable_increment_data_backup: Specifies whether to enable incremental backup. Valid values:
               - false (default): disables the feature.
               - true: enables the feature.
               ->**NOTE:** This parameter takes effect only on instances that run SQL Server with cloud disks. This parameter takes effect only when BackupPolicyMode is set to DataBackupPolicy.
        :param pulumi.Input[_builtins.str] high_space_usage_protection: Instance high space usage protection policy. Valid when the `enable_backup_log` is `true`. Valid values are `Enable`, `Disable`.
        :param pulumi.Input[_builtins.str] instance_id: The Id of instance that can run database.
        :param pulumi.Input[_builtins.int] local_log_retention_hours: Instance log backup local retention hours. Valid when the `enable_backup_log` is `true`. Valid values: [0-7*24].
        :param pulumi.Input[_builtins.int] local_log_retention_space: Instance log backup local retention space. Valid when the `enable_backup_log` is `true`. Valid values: [0-50].
        :param pulumi.Input[_builtins.bool] log_backup: It has been deprecated from version 1.68.0, and use field 'enable_backup_log' instead.
        :param pulumi.Input[_builtins.str] log_backup_frequency: Instance log backup frequency. Valid when the instance engine is `SQLServer`. Valid values are `LogInterval`.
        :param pulumi.Input[_builtins.int] log_backup_local_retention_number: The number of binary log files that you want to retain on the instance. Default value: 60. Valid values: 6 to 100.
               ->**NOTE:** This parameter takes effect only when you set the BackupPolicyMode parameter to LogBackupPolicy. If the instance runs MySQL, you can set this parameter to -1. The value -1 specifies that an unlimited number of binary log files can be retained on the instance.
        :param pulumi.Input[_builtins.int] log_backup_retention_period: Instance log backup retention days. Valid when the `enable_backup_log` is `1`. Valid values: [7-730]. Default to 7. It cannot be larger than `backup_retention_period`.
        :param pulumi.Input[_builtins.int] log_retention_period: It has been deprecated from version 1.69.0, and use field 'log_backup_retention_period' instead.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] preferred_backup_periods: DB Instance backup period. Please set at least two days to ensure backing up at least twice a week. Valid values: [Monday, Tuesday, Wednesday, Thursday, Friday, Saturday, Sunday].
        :param pulumi.Input[_builtins.str] preferred_backup_time: DB instance backup time, in the format of HH:mmZ- HH:mmZ. Time setting interval is one hour. Default to "02:00Z-03:00Z". China time is 8 hours behind it.
        :param pulumi.Input[_builtins.str] released_keep_policy: The policy based on which ApsaraDB RDS retains archived backup files if the instance is released. Default value: None. Valid values:
               * **None**: No archived backup files are retained.
               * **Lastest**: Only the most recent archived backup file is retained.
               * **All**: All archived backup files are retained.
        :param pulumi.Input[_builtins.int] retention_period: It has been deprecated from version 1.69.0, and use field 'backup_retention_period' instead.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BackupPolicyState.__new__(_BackupPolicyState)

        __props__.__dict__["archive_backup_keep_count"] = archive_backup_keep_count
        __props__.__dict__["archive_backup_keep_policy"] = archive_backup_keep_policy
        __props__.__dict__["archive_backup_retention_period"] = archive_backup_retention_period
        __props__.__dict__["backup_interval"] = backup_interval
        __props__.__dict__["backup_method"] = backup_method
        __props__.__dict__["backup_periods"] = backup_periods
        __props__.__dict__["backup_priority"] = backup_priority
        __props__.__dict__["backup_retention_period"] = backup_retention_period
        __props__.__dict__["backup_time"] = backup_time
        __props__.__dict__["category"] = category
        __props__.__dict__["compress_type"] = compress_type
        __props__.__dict__["enable_backup_log"] = enable_backup_log
        __props__.__dict__["enable_increment_data_backup"] = enable_increment_data_backup
        __props__.__dict__["high_space_usage_protection"] = high_space_usage_protection
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["local_log_retention_hours"] = local_log_retention_hours
        __props__.__dict__["local_log_retention_space"] = local_log_retention_space
        __props__.__dict__["log_backup"] = log_backup
        __props__.__dict__["log_backup_frequency"] = log_backup_frequency
        __props__.__dict__["log_backup_local_retention_number"] = log_backup_local_retention_number
        __props__.__dict__["log_backup_retention_period"] = log_backup_retention_period
        __props__.__dict__["log_retention_period"] = log_retention_period
        __props__.__dict__["preferred_backup_periods"] = preferred_backup_periods
        __props__.__dict__["preferred_backup_time"] = preferred_backup_time
        __props__.__dict__["released_keep_policy"] = released_keep_policy
        __props__.__dict__["retention_period"] = retention_period
        return BackupPolicy(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="archiveBackupKeepCount")
    def archive_backup_keep_count(self) -> pulumi.Output[_builtins.int]:
        """
        Instance archive backup keep count. Valid when the `enable_backup_log` is `true` and instance is mysql local disk. When `archive_backup_keep_policy` is `ByMonth` Valid values: [1-31]. When `archive_backup_keep_policy` is `ByWeek` Valid values: [1-7].
        """
        return pulumi.get(self, "archive_backup_keep_count")

    @_builtins.property
    @pulumi.getter(name="archiveBackupKeepPolicy")
    def archive_backup_keep_policy(self) -> pulumi.Output[_builtins.str]:
        """
        Instance archive backup keep policy. Valid when the `enable_backup_log` is `true` and instance is mysql local disk. Valid values are `ByMonth`, `ByWeek`, `KeepAll`.
        """
        return pulumi.get(self, "archive_backup_keep_policy")

    @_builtins.property
    @pulumi.getter(name="archiveBackupRetentionPeriod")
    def archive_backup_retention_period(self) -> pulumi.Output[_builtins.int]:
        """
        Instance archive backup retention days. Valid when the `enable_backup_log` is `true` and instance is mysql local disk. Valid values: [30-1095], and `archive_backup_retention_period` must larger than `backup_retention_period` 730.
        """
        return pulumi.get(self, "archive_backup_retention_period")

    @_builtins.property
    @pulumi.getter(name="backupInterval")
    def backup_interval(self) -> pulumi.Output[_builtins.str]:
        """
        The frequency at which you want to perform a snapshot backup on the instance. Valid values:
        - -1: No backup frequencies are specified.
        - 30: A snapshot backup is performed once every 30 minutes.
        - 60: A snapshot backup is performed once every 60 minutes.
        - 120: A snapshot backup is performed once every 120 minutes.
        - 240: A snapshot backup is performed once every 240 minutes.
        - 360: A snapshot backup is performed once every 360 minutes.
        - 480: A snapshot backup is performed once every 480 minutes.
        - 720: A snapshot backup is performed once every 720 minutes.
        """
        return pulumi.get(self, "backup_interval")

    @_builtins.property
    @pulumi.getter(name="backupMethod")
    def backup_method(self) -> pulumi.Output[_builtins.str]:
        """
        The backup method of the instance. Valid values:
        - Physical: physical backup
        - Snapshot: snapshot backup
        ->**NOTE:** This parameter takes effect only on instances that run SQL Server with cloud disks. This parameter takes effect only when BackupPolicyMode is set to DataBackupPolicy.

        > **NOTE:** Currently, the SQLServer instance does not support to modify `log_backup_retention_period`.
        """
        return pulumi.get(self, "backup_method")

    @_builtins.property
    @pulumi.getter(name="backupPeriods")
    @_utilities.deprecated("""Attribute 'backup_period' has been deprecated from version 1.69.0. Use `preferred_backup_period` instead""")
    def backup_periods(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        It has been deprecated from version 1.69.0, and use field 'preferred_backup_period' instead.
        """
        return pulumi.get(self, "backup_periods")

    @_builtins.property
    @pulumi.getter(name="backupPriority")
    def backup_priority(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Specifies whether the backup settings of a secondary instance are configured. Valid values:
        - 1: secondary instance preferred
        - 2: primary instance preferred
        ->**NOTE:** This parameter is suitable only for instances that run SQL Server on RDS Cluster Edition. This parameter takes effect only when BackupMethod is set to Physical. If BackupMethod is set to Snapshot, backups are forcefully performed on the primary instance that runs SQL Server on RDS Cluster Edition.
        """
        return pulumi.get(self, "backup_priority")

    @_builtins.property
    @pulumi.getter(name="backupRetentionPeriod")
    def backup_retention_period(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Instance backup retention days. Valid values: [7-730]. Default to 7. But mysql local disk is unlimited.
        """
        return pulumi.get(self, "backup_retention_period")

    @_builtins.property
    @pulumi.getter(name="backupTime")
    @_utilities.deprecated("""Attribute 'backup_time' has been deprecated from version 1.69.0. Use `preferred_backup_time` instead""")
    def backup_time(self) -> pulumi.Output[_builtins.str]:
        """
        It has been deprecated from version 1.69.0, and use field 'preferred_backup_time' instead.
        """
        return pulumi.get(self, "backup_time")

    @_builtins.property
    @pulumi.getter
    def category(self) -> pulumi.Output[_builtins.str]:
        """
        Whether to enable second level backup.Valid values are `Flash`, `Standard`, Note:It only takes effect when the BackupPolicyMode parameter is DataBackupPolicy.
        > **NOTE:** You can configure a backup policy by using this parameter and the PreferredBackupPeriod parameter. For example, if you set the PreferredBackupPeriod parameter to Saturday,Sunday and the BackupInterval parameter to -1, a snapshot backup is performed on every Saturday and Sunday.If the instance runs PostgreSQL, the BackupInterval parameter is supported only when the instance is equipped with standard SSDs or enhanced SSDs (ESSDs).This parameter takes effect only when you set the BackupPolicyMode parameter to DataBackupPolicy.
        """
        return pulumi.get(self, "category")

    @_builtins.property
    @pulumi.getter(name="compressType")
    def compress_type(self) -> pulumi.Output[_builtins.str]:
        """
        The compress type of instance policy. Valid values are `1`, `4`, `8`.
        """
        return pulumi.get(self, "compress_type")

    @_builtins.property
    @pulumi.getter(name="enableBackupLog")
    def enable_backup_log(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether to backup instance log. Valid values are `true`, `false`, Default to `true`. Note: The 'Basic Edition' category Rds instance does not support setting log backup. [What is Basic Edition](https://www.alibabacloud.com/help/doc-detail/48980.htm).
        """
        return pulumi.get(self, "enable_backup_log")

    @_builtins.property
    @pulumi.getter(name="enableIncrementDataBackup")
    def enable_increment_data_backup(self) -> pulumi.Output[_builtins.bool]:
        """
        Specifies whether to enable incremental backup. Valid values:
        - false (default): disables the feature.
        - true: enables the feature.
        ->**NOTE:** This parameter takes effect only on instances that run SQL Server with cloud disks. This parameter takes effect only when BackupPolicyMode is set to DataBackupPolicy.
        """
        return pulumi.get(self, "enable_increment_data_backup")

    @_builtins.property
    @pulumi.getter(name="highSpaceUsageProtection")
    def high_space_usage_protection(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Instance high space usage protection policy. Valid when the `enable_backup_log` is `true`. Valid values are `Enable`, `Disable`.
        """
        return pulumi.get(self, "high_space_usage_protection")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        The Id of instance that can run database.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter(name="localLogRetentionHours")
    def local_log_retention_hours(self) -> pulumi.Output[_builtins.int]:
        """
        Instance log backup local retention hours. Valid when the `enable_backup_log` is `true`. Valid values: [0-7*24].
        """
        return pulumi.get(self, "local_log_retention_hours")

    @_builtins.property
    @pulumi.getter(name="localLogRetentionSpace")
    def local_log_retention_space(self) -> pulumi.Output[_builtins.int]:
        """
        Instance log backup local retention space. Valid when the `enable_backup_log` is `true`. Valid values: [0-50].
        """
        return pulumi.get(self, "local_log_retention_space")

    @_builtins.property
    @pulumi.getter(name="logBackup")
    @_utilities.deprecated("""Attribute 'log_backup' has been deprecated from version 1.68.0. Use `enable_backup_log` instead""")
    def log_backup(self) -> pulumi.Output[_builtins.bool]:
        """
        It has been deprecated from version 1.68.0, and use field 'enable_backup_log' instead.
        """
        return pulumi.get(self, "log_backup")

    @_builtins.property
    @pulumi.getter(name="logBackupFrequency")
    def log_backup_frequency(self) -> pulumi.Output[_builtins.str]:
        """
        Instance log backup frequency. Valid when the instance engine is `SQLServer`. Valid values are `LogInterval`.
        """
        return pulumi.get(self, "log_backup_frequency")

    @_builtins.property
    @pulumi.getter(name="logBackupLocalRetentionNumber")
    def log_backup_local_retention_number(self) -> pulumi.Output[_builtins.int]:
        """
        The number of binary log files that you want to retain on the instance. Default value: 60. Valid values: 6 to 100.
        ->**NOTE:** This parameter takes effect only when you set the BackupPolicyMode parameter to LogBackupPolicy. If the instance runs MySQL, you can set this parameter to -1. The value -1 specifies that an unlimited number of binary log files can be retained on the instance.
        """
        return pulumi.get(self, "log_backup_local_retention_number")

    @_builtins.property
    @pulumi.getter(name="logBackupRetentionPeriod")
    def log_backup_retention_period(self) -> pulumi.Output[_builtins.int]:
        """
        Instance log backup retention days. Valid when the `enable_backup_log` is `1`. Valid values: [7-730]. Default to 7. It cannot be larger than `backup_retention_period`.
        """
        return pulumi.get(self, "log_backup_retention_period")

    @_builtins.property
    @pulumi.getter(name="logRetentionPeriod")
    @_utilities.deprecated("""Attribute 'log_retention_period' has been deprecated from version 1.69.0. Use `log_backup_retention_period` instead""")
    def log_retention_period(self) -> pulumi.Output[_builtins.int]:
        """
        It has been deprecated from version 1.69.0, and use field 'log_backup_retention_period' instead.
        """
        return pulumi.get(self, "log_retention_period")

    @_builtins.property
    @pulumi.getter(name="preferredBackupPeriods")
    def preferred_backup_periods(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        DB Instance backup period. Please set at least two days to ensure backing up at least twice a week. Valid values: [Monday, Tuesday, Wednesday, Thursday, Friday, Saturday, Sunday].
        """
        return pulumi.get(self, "preferred_backup_periods")

    @_builtins.property
    @pulumi.getter(name="preferredBackupTime")
    def preferred_backup_time(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        DB instance backup time, in the format of HH:mmZ- HH:mmZ. Time setting interval is one hour. Default to "02:00Z-03:00Z". China time is 8 hours behind it.
        """
        return pulumi.get(self, "preferred_backup_time")

    @_builtins.property
    @pulumi.getter(name="releasedKeepPolicy")
    def released_keep_policy(self) -> pulumi.Output[_builtins.str]:
        """
        The policy based on which ApsaraDB RDS retains archived backup files if the instance is released. Default value: None. Valid values:
        * **None**: No archived backup files are retained.
        * **Lastest**: Only the most recent archived backup file is retained.
        * **All**: All archived backup files are retained.
        """
        return pulumi.get(self, "released_keep_policy")

    @_builtins.property
    @pulumi.getter(name="retentionPeriod")
    @_utilities.deprecated("""Attribute 'retention_period' has been deprecated from version 1.69.0. Use `backup_retention_period` instead""")
    def retention_period(self) -> pulumi.Output[_builtins.int]:
        """
        It has been deprecated from version 1.69.0, and use field 'backup_retention_period' instead.
        """
        return pulumi.get(self, "retention_period")

