# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ConsumerGroupArgs', 'ConsumerGroup']

@pulumi.input_type
class ConsumerGroupArgs:
    def __init__(__self__, *,
                 consume_retry_policy: pulumi.Input['ConsumerGroupConsumeRetryPolicyArgs'],
                 consumer_group_id: pulumi.Input[_builtins.str],
                 instance_id: pulumi.Input[_builtins.str],
                 delivery_order_type: Optional[pulumi.Input[_builtins.str]] = None,
                 max_receive_tps: Optional[pulumi.Input[_builtins.int]] = None,
                 remark: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ConsumerGroup resource.
        :param pulumi.Input['ConsumerGroupConsumeRetryPolicyArgs'] consume_retry_policy: Consumption retry strategy. See `consume_retry_policy` below.
        :param pulumi.Input[_builtins.str] consumer_group_id: The first ID of the resource.
        :param pulumi.Input[_builtins.str] instance_id: Instance ID.
        :param pulumi.Input[_builtins.str] delivery_order_type: Delivery order.
        :param pulumi.Input[_builtins.int] max_receive_tps: Maximum received message tps.
        :param pulumi.Input[_builtins.str] remark: Custom remarks.
        """
        pulumi.set(__self__, "consume_retry_policy", consume_retry_policy)
        pulumi.set(__self__, "consumer_group_id", consumer_group_id)
        pulumi.set(__self__, "instance_id", instance_id)
        if delivery_order_type is not None:
            pulumi.set(__self__, "delivery_order_type", delivery_order_type)
        if max_receive_tps is not None:
            pulumi.set(__self__, "max_receive_tps", max_receive_tps)
        if remark is not None:
            pulumi.set(__self__, "remark", remark)

    @_builtins.property
    @pulumi.getter(name="consumeRetryPolicy")
    def consume_retry_policy(self) -> pulumi.Input['ConsumerGroupConsumeRetryPolicyArgs']:
        """
        Consumption retry strategy. See `consume_retry_policy` below.
        """
        return pulumi.get(self, "consume_retry_policy")

    @consume_retry_policy.setter
    def consume_retry_policy(self, value: pulumi.Input['ConsumerGroupConsumeRetryPolicyArgs']):
        pulumi.set(self, "consume_retry_policy", value)

    @_builtins.property
    @pulumi.getter(name="consumerGroupId")
    def consumer_group_id(self) -> pulumi.Input[_builtins.str]:
        """
        The first ID of the resource.
        """
        return pulumi.get(self, "consumer_group_id")

    @consumer_group_id.setter
    def consumer_group_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "consumer_group_id", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[_builtins.str]:
        """
        Instance ID.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="deliveryOrderType")
    def delivery_order_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Delivery order.
        """
        return pulumi.get(self, "delivery_order_type")

    @delivery_order_type.setter
    def delivery_order_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "delivery_order_type", value)

    @_builtins.property
    @pulumi.getter(name="maxReceiveTps")
    def max_receive_tps(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Maximum received message tps.
        """
        return pulumi.get(self, "max_receive_tps")

    @max_receive_tps.setter
    def max_receive_tps(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_receive_tps", value)

    @_builtins.property
    @pulumi.getter
    def remark(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Custom remarks.
        """
        return pulumi.get(self, "remark")

    @remark.setter
    def remark(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "remark", value)


@pulumi.input_type
class _ConsumerGroupState:
    def __init__(__self__, *,
                 consume_retry_policy: Optional[pulumi.Input['ConsumerGroupConsumeRetryPolicyArgs']] = None,
                 consumer_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 delivery_order_type: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 max_receive_tps: Optional[pulumi.Input[_builtins.int]] = None,
                 region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 remark: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ConsumerGroup resources.
        :param pulumi.Input['ConsumerGroupConsumeRetryPolicyArgs'] consume_retry_policy: Consumption retry strategy. See `consume_retry_policy` below.
        :param pulumi.Input[_builtins.str] consumer_group_id: The first ID of the resource.
        :param pulumi.Input[_builtins.str] create_time: The creation time of the resource.
        :param pulumi.Input[_builtins.str] delivery_order_type: Delivery order.
        :param pulumi.Input[_builtins.str] instance_id: Instance ID.
        :param pulumi.Input[_builtins.int] max_receive_tps: Maximum received message tps.
        :param pulumi.Input[_builtins.str] region_id: (Available since v1.247.0) The ID of the region in which the instance resides.
        :param pulumi.Input[_builtins.str] remark: Custom remarks.
        :param pulumi.Input[_builtins.str] status: The status of the resource.
        """
        if consume_retry_policy is not None:
            pulumi.set(__self__, "consume_retry_policy", consume_retry_policy)
        if consumer_group_id is not None:
            pulumi.set(__self__, "consumer_group_id", consumer_group_id)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if delivery_order_type is not None:
            pulumi.set(__self__, "delivery_order_type", delivery_order_type)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if max_receive_tps is not None:
            pulumi.set(__self__, "max_receive_tps", max_receive_tps)
        if region_id is not None:
            pulumi.set(__self__, "region_id", region_id)
        if remark is not None:
            pulumi.set(__self__, "remark", remark)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="consumeRetryPolicy")
    def consume_retry_policy(self) -> Optional[pulumi.Input['ConsumerGroupConsumeRetryPolicyArgs']]:
        """
        Consumption retry strategy. See `consume_retry_policy` below.
        """
        return pulumi.get(self, "consume_retry_policy")

    @consume_retry_policy.setter
    def consume_retry_policy(self, value: Optional[pulumi.Input['ConsumerGroupConsumeRetryPolicyArgs']]):
        pulumi.set(self, "consume_retry_policy", value)

    @_builtins.property
    @pulumi.getter(name="consumerGroupId")
    def consumer_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The first ID of the resource.
        """
        return pulumi.get(self, "consumer_group_id")

    @consumer_group_id.setter
    def consumer_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "consumer_group_id", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation time of the resource.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="deliveryOrderType")
    def delivery_order_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Delivery order.
        """
        return pulumi.get(self, "delivery_order_type")

    @delivery_order_type.setter
    def delivery_order_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "delivery_order_type", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Instance ID.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="maxReceiveTps")
    def max_receive_tps(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Maximum received message tps.
        """
        return pulumi.get(self, "max_receive_tps")

    @max_receive_tps.setter
    def max_receive_tps(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_receive_tps", value)

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Available since v1.247.0) The ID of the region in which the instance resides.
        """
        return pulumi.get(self, "region_id")

    @region_id.setter
    def region_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region_id", value)

    @_builtins.property
    @pulumi.getter
    def remark(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Custom remarks.
        """
        return pulumi.get(self, "remark")

    @remark.setter
    def remark(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "remark", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the resource.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.type_token("alicloud:rocketmq/consumerGroup:ConsumerGroup")
class ConsumerGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 consume_retry_policy: Optional[pulumi.Input[Union['ConsumerGroupConsumeRetryPolicyArgs', 'ConsumerGroupConsumeRetryPolicyArgsDict']]] = None,
                 consumer_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 delivery_order_type: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 max_receive_tps: Optional[pulumi.Input[_builtins.int]] = None,
                 remark: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a RocketMQ Consumer Group resource.

        For information about RocketMQ Consumer Group and how to use it, see [What is Consumer Group](https://www.alibabacloud.com/help/en/apsaramq-for-rocketmq/cloud-message-queue-rocketmq-5-x-series/developer-reference/api-rocketmq-2022-08-01-createconsumergroup).

        > **NOTE:** Available since v1.212.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.get_zones(available_resource_creation="VSwitch")
        create_vpc = alicloud.vpc.Network("createVpc",
            description="example",
            cidr_block="172.16.0.0/12",
            vpc_name=name)
        create_vswitch = alicloud.vpc.Switch("createVswitch",
            description="example",
            vpc_id=create_vpc.id,
            zone_id=default.zones[0].id,
            cidr_block="172.16.0.0/24",
            vswitch_name=name)
        create_instance = alicloud.rocketmq.RocketMQInstance("createInstance",
            product_info={
                "msg_process_spec": "rmq.u2.10xlarge",
                "send_receive_ratio": 0.3,
                "message_retention_time": 70,
            },
            service_code="rmq",
            payment_type="PayAsYouGo",
            instance_name=name,
            sub_series_code="cluster_ha",
            remark="example",
            ip_whitelists=[
                "192.168.0.0/16",
                "10.10.0.0/16",
                "172.168.0.0/16",
            ],
            software={
                "maintain_time": "02:00-06:00",
            },
            tags={
                "Created": "TF",
                "For": "example",
            },
            series_code="ultimate",
            network_info={
                "vpc_info": {
                    "vpc_id": create_vpc.id,
                    "vswitches": [{
                        "vswitch_id": create_vswitch.id,
                    }],
                },
                "internet_info": {
                    "internet_spec": "enable",
                    "flow_out_type": "payByBandwidth",
                    "flow_out_bandwidth": 30,
                },
            })
        default_consumer_group = alicloud.rocketmq.ConsumerGroup("default",
            consumer_group_id=name,
            instance_id=create_instance.id,
            consume_retry_policy={
                "retry_policy": "DefaultRetryPolicy",
                "max_retry_times": 10,
            },
            delivery_order_type="Concurrently",
            remark="example")
        ```

        ## Import

        RocketMQ Consumer Group can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:rocketmq/consumerGroup:ConsumerGroup example <instance_id>:<consumer_group_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ConsumerGroupConsumeRetryPolicyArgs', 'ConsumerGroupConsumeRetryPolicyArgsDict']] consume_retry_policy: Consumption retry strategy. See `consume_retry_policy` below.
        :param pulumi.Input[_builtins.str] consumer_group_id: The first ID of the resource.
        :param pulumi.Input[_builtins.str] delivery_order_type: Delivery order.
        :param pulumi.Input[_builtins.str] instance_id: Instance ID.
        :param pulumi.Input[_builtins.int] max_receive_tps: Maximum received message tps.
        :param pulumi.Input[_builtins.str] remark: Custom remarks.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ConsumerGroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a RocketMQ Consumer Group resource.

        For information about RocketMQ Consumer Group and how to use it, see [What is Consumer Group](https://www.alibabacloud.com/help/en/apsaramq-for-rocketmq/cloud-message-queue-rocketmq-5-x-series/developer-reference/api-rocketmq-2022-08-01-createconsumergroup).

        > **NOTE:** Available since v1.212.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.get_zones(available_resource_creation="VSwitch")
        create_vpc = alicloud.vpc.Network("createVpc",
            description="example",
            cidr_block="172.16.0.0/12",
            vpc_name=name)
        create_vswitch = alicloud.vpc.Switch("createVswitch",
            description="example",
            vpc_id=create_vpc.id,
            zone_id=default.zones[0].id,
            cidr_block="172.16.0.0/24",
            vswitch_name=name)
        create_instance = alicloud.rocketmq.RocketMQInstance("createInstance",
            product_info={
                "msg_process_spec": "rmq.u2.10xlarge",
                "send_receive_ratio": 0.3,
                "message_retention_time": 70,
            },
            service_code="rmq",
            payment_type="PayAsYouGo",
            instance_name=name,
            sub_series_code="cluster_ha",
            remark="example",
            ip_whitelists=[
                "192.168.0.0/16",
                "10.10.0.0/16",
                "172.168.0.0/16",
            ],
            software={
                "maintain_time": "02:00-06:00",
            },
            tags={
                "Created": "TF",
                "For": "example",
            },
            series_code="ultimate",
            network_info={
                "vpc_info": {
                    "vpc_id": create_vpc.id,
                    "vswitches": [{
                        "vswitch_id": create_vswitch.id,
                    }],
                },
                "internet_info": {
                    "internet_spec": "enable",
                    "flow_out_type": "payByBandwidth",
                    "flow_out_bandwidth": 30,
                },
            })
        default_consumer_group = alicloud.rocketmq.ConsumerGroup("default",
            consumer_group_id=name,
            instance_id=create_instance.id,
            consume_retry_policy={
                "retry_policy": "DefaultRetryPolicy",
                "max_retry_times": 10,
            },
            delivery_order_type="Concurrently",
            remark="example")
        ```

        ## Import

        RocketMQ Consumer Group can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:rocketmq/consumerGroup:ConsumerGroup example <instance_id>:<consumer_group_id>
        ```

        :param str resource_name: The name of the resource.
        :param ConsumerGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ConsumerGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 consume_retry_policy: Optional[pulumi.Input[Union['ConsumerGroupConsumeRetryPolicyArgs', 'ConsumerGroupConsumeRetryPolicyArgsDict']]] = None,
                 consumer_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 delivery_order_type: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 max_receive_tps: Optional[pulumi.Input[_builtins.int]] = None,
                 remark: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ConsumerGroupArgs.__new__(ConsumerGroupArgs)

            if consume_retry_policy is None and not opts.urn:
                raise TypeError("Missing required property 'consume_retry_policy'")
            __props__.__dict__["consume_retry_policy"] = consume_retry_policy
            if consumer_group_id is None and not opts.urn:
                raise TypeError("Missing required property 'consumer_group_id'")
            __props__.__dict__["consumer_group_id"] = consumer_group_id
            __props__.__dict__["delivery_order_type"] = delivery_order_type
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["max_receive_tps"] = max_receive_tps
            __props__.__dict__["remark"] = remark
            __props__.__dict__["create_time"] = None
            __props__.__dict__["region_id"] = None
            __props__.__dict__["status"] = None
        super(ConsumerGroup, __self__).__init__(
            'alicloud:rocketmq/consumerGroup:ConsumerGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            consume_retry_policy: Optional[pulumi.Input[Union['ConsumerGroupConsumeRetryPolicyArgs', 'ConsumerGroupConsumeRetryPolicyArgsDict']]] = None,
            consumer_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            delivery_order_type: Optional[pulumi.Input[_builtins.str]] = None,
            instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            max_receive_tps: Optional[pulumi.Input[_builtins.int]] = None,
            region_id: Optional[pulumi.Input[_builtins.str]] = None,
            remark: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None) -> 'ConsumerGroup':
        """
        Get an existing ConsumerGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ConsumerGroupConsumeRetryPolicyArgs', 'ConsumerGroupConsumeRetryPolicyArgsDict']] consume_retry_policy: Consumption retry strategy. See `consume_retry_policy` below.
        :param pulumi.Input[_builtins.str] consumer_group_id: The first ID of the resource.
        :param pulumi.Input[_builtins.str] create_time: The creation time of the resource.
        :param pulumi.Input[_builtins.str] delivery_order_type: Delivery order.
        :param pulumi.Input[_builtins.str] instance_id: Instance ID.
        :param pulumi.Input[_builtins.int] max_receive_tps: Maximum received message tps.
        :param pulumi.Input[_builtins.str] region_id: (Available since v1.247.0) The ID of the region in which the instance resides.
        :param pulumi.Input[_builtins.str] remark: Custom remarks.
        :param pulumi.Input[_builtins.str] status: The status of the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ConsumerGroupState.__new__(_ConsumerGroupState)

        __props__.__dict__["consume_retry_policy"] = consume_retry_policy
        __props__.__dict__["consumer_group_id"] = consumer_group_id
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["delivery_order_type"] = delivery_order_type
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["max_receive_tps"] = max_receive_tps
        __props__.__dict__["region_id"] = region_id
        __props__.__dict__["remark"] = remark
        __props__.__dict__["status"] = status
        return ConsumerGroup(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="consumeRetryPolicy")
    def consume_retry_policy(self) -> pulumi.Output['outputs.ConsumerGroupConsumeRetryPolicy']:
        """
        Consumption retry strategy. See `consume_retry_policy` below.
        """
        return pulumi.get(self, "consume_retry_policy")

    @_builtins.property
    @pulumi.getter(name="consumerGroupId")
    def consumer_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The first ID of the resource.
        """
        return pulumi.get(self, "consumer_group_id")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The creation time of the resource.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="deliveryOrderType")
    def delivery_order_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Delivery order.
        """
        return pulumi.get(self, "delivery_order_type")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        Instance ID.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter(name="maxReceiveTps")
    def max_receive_tps(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Maximum received message tps.
        """
        return pulumi.get(self, "max_receive_tps")

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> pulumi.Output[_builtins.str]:
        """
        (Available since v1.247.0) The ID of the region in which the instance resides.
        """
        return pulumi.get(self, "region_id")

    @_builtins.property
    @pulumi.getter
    def remark(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Custom remarks.
        """
        return pulumi.get(self, "remark")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the resource.
        """
        return pulumi.get(self, "status")

