# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'DbClusterDesiredParam',
    'DbClusterParamChangeLog',
    'DbInstanceDesiredSecurityIpList',
    'DbInstanceInstanceNetInfo',
    'DbInstanceInstanceNetInfoPortList',
    'DbInstanceSecurityIpList',
    'GetDbClustersClusterResult',
    'GetDbClustersClusterParamResult',
    'GetDbClustersClusterParamChangeLogResult',
    'GetDbInstancesInstanceResult',
]

@pulumi.output_type
class DbClusterDesiredParam(dict):
    def __init__(__self__, *,
                 name: Optional[_builtins.str] = None,
                 value: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: Parameter name.
        :param _builtins.str value: The new value of Parameter.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Parameter name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.str]:
        """
        The new value of Parameter.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class DbClusterParamChangeLog(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "configId":
            suggest = "config_id"
        elif key == "gmtCreated":
            suggest = "gmt_created"
        elif key == "gmtModified":
            suggest = "gmt_modified"
        elif key == "isApplied":
            suggest = "is_applied"
        elif key == "newValue":
            suggest = "new_value"
        elif key == "oldValue":
            suggest = "old_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DbClusterParamChangeLog. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DbClusterParamChangeLog.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DbClusterParamChangeLog.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 config_id: Optional[_builtins.int] = None,
                 gmt_created: Optional[_builtins.str] = None,
                 gmt_modified: Optional[_builtins.str] = None,
                 is_applied: Optional[_builtins.bool] = None,
                 name: Optional[_builtins.str] = None,
                 new_value: Optional[_builtins.str] = None,
                 old_value: Optional[_builtins.str] = None):
        """
        :param _builtins.int config_id: The id of parameter change.
        :param _builtins.str gmt_created: When the parameter change is created.
        :param _builtins.str gmt_modified: When the parameter change is modified.
        :param _builtins.bool is_applied: Whether the parameter changing is applied.
        :param _builtins.str name: Changed parameter name.
        :param _builtins.str new_value: The new value of parameter.
        :param _builtins.str old_value: The old value of parameter.
        """
        if config_id is not None:
            pulumi.set(__self__, "config_id", config_id)
        if gmt_created is not None:
            pulumi.set(__self__, "gmt_created", gmt_created)
        if gmt_modified is not None:
            pulumi.set(__self__, "gmt_modified", gmt_modified)
        if is_applied is not None:
            pulumi.set(__self__, "is_applied", is_applied)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if new_value is not None:
            pulumi.set(__self__, "new_value", new_value)
        if old_value is not None:
            pulumi.set(__self__, "old_value", old_value)

    @_builtins.property
    @pulumi.getter(name="configId")
    def config_id(self) -> Optional[_builtins.int]:
        """
        The id of parameter change.
        """
        return pulumi.get(self, "config_id")

    @_builtins.property
    @pulumi.getter(name="gmtCreated")
    def gmt_created(self) -> Optional[_builtins.str]:
        """
        When the parameter change is created.
        """
        return pulumi.get(self, "gmt_created")

    @_builtins.property
    @pulumi.getter(name="gmtModified")
    def gmt_modified(self) -> Optional[_builtins.str]:
        """
        When the parameter change is modified.
        """
        return pulumi.get(self, "gmt_modified")

    @_builtins.property
    @pulumi.getter(name="isApplied")
    def is_applied(self) -> Optional[_builtins.bool]:
        """
        Whether the parameter changing is applied.
        """
        return pulumi.get(self, "is_applied")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Changed parameter name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="newValue")
    def new_value(self) -> Optional[_builtins.str]:
        """
        The new value of parameter.
        """
        return pulumi.get(self, "new_value")

    @_builtins.property
    @pulumi.getter(name="oldValue")
    def old_value(self) -> Optional[_builtins.str]:
        """
        The old value of parameter.
        """
        return pulumi.get(self, "old_value")


@pulumi.output_type
class DbInstanceDesiredSecurityIpList(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "groupName":
            suggest = "group_name"
        elif key == "securityIpList":
            suggest = "security_ip_list"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DbInstanceDesiredSecurityIpList. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DbInstanceDesiredSecurityIpList.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DbInstanceDesiredSecurityIpList.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 group_name: Optional[_builtins.str] = None,
                 security_ip_list: Optional[_builtins.str] = None):
        """
        :param _builtins.str group_name: Security group name.
        :param _builtins.str security_ip_list: The IP list of Security group. Each single IP value should be Separated by comma.
        """
        if group_name is not None:
            pulumi.set(__self__, "group_name", group_name)
        if security_ip_list is not None:
            pulumi.set(__self__, "security_ip_list", security_ip_list)

    @_builtins.property
    @pulumi.getter(name="groupName")
    def group_name(self) -> Optional[_builtins.str]:
        """
        Security group name.
        """
        return pulumi.get(self, "group_name")

    @_builtins.property
    @pulumi.getter(name="securityIpList")
    def security_ip_list(self) -> Optional[_builtins.str]:
        """
        The IP list of Security group. Each single IP value should be Separated by comma.
        """
        return pulumi.get(self, "security_ip_list")


@pulumi.output_type
class DbInstanceInstanceNetInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectionString":
            suggest = "connection_string"
        elif key == "dbIp":
            suggest = "db_ip"
        elif key == "netType":
            suggest = "net_type"
        elif key == "portLists":
            suggest = "port_lists"
        elif key == "vpcInstanceId":
            suggest = "vpc_instance_id"
        elif key == "vswitchId":
            suggest = "vswitch_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DbInstanceInstanceNetInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DbInstanceInstanceNetInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DbInstanceInstanceNetInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connection_string: Optional[_builtins.str] = None,
                 db_ip: Optional[_builtins.str] = None,
                 net_type: Optional[_builtins.str] = None,
                 port_lists: Optional[Sequence['outputs.DbInstanceInstanceNetInfoPortList']] = None,
                 vpc_instance_id: Optional[_builtins.str] = None,
                 vswitch_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str connection_string: The connection string of the instance.
        :param _builtins.str db_ip: The IP address of the instance.
        :param _builtins.str net_type: The network type of the instance.
        :param Sequence['DbInstanceInstanceNetInfoPortListArgs'] port_lists: A list for port provides SelectDB service.
        :param _builtins.str vpc_instance_id: The VPC ID.
        :param _builtins.str vswitch_id: The ID of vswitch for DBInstance.
        """
        if connection_string is not None:
            pulumi.set(__self__, "connection_string", connection_string)
        if db_ip is not None:
            pulumi.set(__self__, "db_ip", db_ip)
        if net_type is not None:
            pulumi.set(__self__, "net_type", net_type)
        if port_lists is not None:
            pulumi.set(__self__, "port_lists", port_lists)
        if vpc_instance_id is not None:
            pulumi.set(__self__, "vpc_instance_id", vpc_instance_id)
        if vswitch_id is not None:
            pulumi.set(__self__, "vswitch_id", vswitch_id)

    @_builtins.property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> Optional[_builtins.str]:
        """
        The connection string of the instance.
        """
        return pulumi.get(self, "connection_string")

    @_builtins.property
    @pulumi.getter(name="dbIp")
    def db_ip(self) -> Optional[_builtins.str]:
        """
        The IP address of the instance.
        """
        return pulumi.get(self, "db_ip")

    @_builtins.property
    @pulumi.getter(name="netType")
    def net_type(self) -> Optional[_builtins.str]:
        """
        The network type of the instance.
        """
        return pulumi.get(self, "net_type")

    @_builtins.property
    @pulumi.getter(name="portLists")
    def port_lists(self) -> Optional[Sequence['outputs.DbInstanceInstanceNetInfoPortList']]:
        """
        A list for port provides SelectDB service.
        """
        return pulumi.get(self, "port_lists")

    @_builtins.property
    @pulumi.getter(name="vpcInstanceId")
    def vpc_instance_id(self) -> Optional[_builtins.str]:
        """
        The VPC ID.
        """
        return pulumi.get(self, "vpc_instance_id")

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> Optional[_builtins.str]:
        """
        The ID of vswitch for DBInstance.
        """
        return pulumi.get(self, "vswitch_id")


@pulumi.output_type
class DbInstanceInstanceNetInfoPortList(dict):
    def __init__(__self__, *,
                 port: Optional[_builtins.str] = None,
                 protocol: Optional[_builtins.str] = None):
        """
        :param _builtins.str port: The port that is used to connect.
        :param _builtins.str protocol: The protocol of the port.
        """
        if port is not None:
            pulumi.set(__self__, "port", port)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.str]:
        """
        The port that is used to connect.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> Optional[_builtins.str]:
        """
        The protocol of the port.
        """
        return pulumi.get(self, "protocol")


@pulumi.output_type
class DbInstanceSecurityIpList(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "groupName":
            suggest = "group_name"
        elif key == "groupTag":
            suggest = "group_tag"
        elif key == "listNetType":
            suggest = "list_net_type"
        elif key == "securityIpList":
            suggest = "security_ip_list"
        elif key == "securityIpType":
            suggest = "security_ip_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DbInstanceSecurityIpList. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DbInstanceSecurityIpList.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DbInstanceSecurityIpList.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 group_name: Optional[_builtins.str] = None,
                 group_tag: Optional[_builtins.str] = None,
                 list_net_type: Optional[_builtins.str] = None,
                 security_ip_list: Optional[_builtins.str] = None,
                 security_ip_type: Optional[_builtins.str] = None):
        """
        :param _builtins.str group_name: Security group name.
        :param _builtins.str group_tag: The tag of Security group.
        :param _builtins.str list_net_type: The network type of Security group.
        :param _builtins.str security_ip_list: The IP list of Security group. Each single IP value should be Separated by comma.
        :param _builtins.str security_ip_type: The IP address type. Valid values: `ipv4`, `ipv6` (not supported).
        """
        if group_name is not None:
            pulumi.set(__self__, "group_name", group_name)
        if group_tag is not None:
            pulumi.set(__self__, "group_tag", group_tag)
        if list_net_type is not None:
            pulumi.set(__self__, "list_net_type", list_net_type)
        if security_ip_list is not None:
            pulumi.set(__self__, "security_ip_list", security_ip_list)
        if security_ip_type is not None:
            pulumi.set(__self__, "security_ip_type", security_ip_type)

    @_builtins.property
    @pulumi.getter(name="groupName")
    def group_name(self) -> Optional[_builtins.str]:
        """
        Security group name.
        """
        return pulumi.get(self, "group_name")

    @_builtins.property
    @pulumi.getter(name="groupTag")
    def group_tag(self) -> Optional[_builtins.str]:
        """
        The tag of Security group.
        """
        return pulumi.get(self, "group_tag")

    @_builtins.property
    @pulumi.getter(name="listNetType")
    def list_net_type(self) -> Optional[_builtins.str]:
        """
        The network type of Security group.
        """
        return pulumi.get(self, "list_net_type")

    @_builtins.property
    @pulumi.getter(name="securityIpList")
    def security_ip_list(self) -> Optional[_builtins.str]:
        """
        The IP list of Security group. Each single IP value should be Separated by comma.
        """
        return pulumi.get(self, "security_ip_list")

    @_builtins.property
    @pulumi.getter(name="securityIpType")
    def security_ip_type(self) -> Optional[_builtins.str]:
        """
        The IP address type. Valid values: `ipv4`, `ipv6` (not supported).
        """
        return pulumi.get(self, "security_ip_type")


@pulumi.output_type
class GetDbClustersClusterResult(dict):
    def __init__(__self__, *,
                 cache_size: _builtins.int,
                 cpu: _builtins.int,
                 create_time: _builtins.str,
                 db_cluster_class: _builtins.str,
                 db_cluster_description: _builtins.str,
                 db_cluster_id: _builtins.str,
                 db_instance_id: _builtins.str,
                 engine: _builtins.str,
                 engine_version: _builtins.str,
                 id: _builtins.str,
                 memory: _builtins.int,
                 param_change_logs: Sequence['outputs.GetDbClustersClusterParamChangeLogResult'],
                 params: Sequence['outputs.GetDbClustersClusterParamResult'],
                 payment_type: _builtins.str,
                 region_id: _builtins.str,
                 status: _builtins.str,
                 vpc_id: _builtins.str,
                 zone_id: _builtins.str):
        """
        :param _builtins.int cache_size: The cache size for DBCluster.
        :param _builtins.int cpu: The cpu resource amount of DBCluster. Depends on `db_cluster_class`.
        :param _builtins.str create_time: The creation time of the resource.
        :param _builtins.str db_cluster_class: The DBCluster class. db_cluster_class has a range of class from `selectdb.xlarge` to `selectdb.256xlarge`.
        :param _builtins.str db_cluster_description: The DBCluster description.
        :param _builtins.str db_cluster_id: The cluster ID.
        :param _builtins.str db_instance_id: The instance ID.
        :param _builtins.str engine: The Engine of the DBCluster.
        :param _builtins.str engine_version: The engine version of the DBCluster.
        :param _builtins.int memory: The memory resource amount of DBCluster. Depends on `db_cluster_class`.
        :param Sequence['GetDbClustersClusterParamChangeLogArgs'] param_change_logs: The configuration change logs of parameters.
        :param Sequence['GetDbClustersClusterParamArgs'] params: The details about each parameter in DBCluster returned.
        :param _builtins.str payment_type: The payment type of the resource. Valid values: `PayAsYouGo`,`Subscription`.
        :param _builtins.str region_id: The ID of region for the cluster.
        :param _builtins.str status: The status of the DBCluster. Valid values: `ACTIVATION`,`CREATING`,`DELETING`,`RESTARTING`,`ORDER_PREPARING`.
        :param _builtins.str vpc_id: The ID of the VPC for the cluster.
        :param _builtins.str zone_id: The ID of zone for the cluster.
        """
        pulumi.set(__self__, "cache_size", cache_size)
        pulumi.set(__self__, "cpu", cpu)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "db_cluster_class", db_cluster_class)
        pulumi.set(__self__, "db_cluster_description", db_cluster_description)
        pulumi.set(__self__, "db_cluster_id", db_cluster_id)
        pulumi.set(__self__, "db_instance_id", db_instance_id)
        pulumi.set(__self__, "engine", engine)
        pulumi.set(__self__, "engine_version", engine_version)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "memory", memory)
        pulumi.set(__self__, "param_change_logs", param_change_logs)
        pulumi.set(__self__, "params", params)
        pulumi.set(__self__, "payment_type", payment_type)
        pulumi.set(__self__, "region_id", region_id)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "vpc_id", vpc_id)
        pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter(name="cacheSize")
    def cache_size(self) -> _builtins.int:
        """
        The cache size for DBCluster.
        """
        return pulumi.get(self, "cache_size")

    @_builtins.property
    @pulumi.getter
    def cpu(self) -> _builtins.int:
        """
        The cpu resource amount of DBCluster. Depends on `db_cluster_class`.
        """
        return pulumi.get(self, "cpu")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        """
        The creation time of the resource.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="dbClusterClass")
    def db_cluster_class(self) -> _builtins.str:
        """
        The DBCluster class. db_cluster_class has a range of class from `selectdb.xlarge` to `selectdb.256xlarge`.
        """
        return pulumi.get(self, "db_cluster_class")

    @_builtins.property
    @pulumi.getter(name="dbClusterDescription")
    def db_cluster_description(self) -> _builtins.str:
        """
        The DBCluster description.
        """
        return pulumi.get(self, "db_cluster_description")

    @_builtins.property
    @pulumi.getter(name="dbClusterId")
    def db_cluster_id(self) -> _builtins.str:
        """
        The cluster ID.
        """
        return pulumi.get(self, "db_cluster_id")

    @_builtins.property
    @pulumi.getter(name="dbInstanceId")
    def db_instance_id(self) -> _builtins.str:
        """
        The instance ID.
        """
        return pulumi.get(self, "db_instance_id")

    @_builtins.property
    @pulumi.getter
    def engine(self) -> _builtins.str:
        """
        The Engine of the DBCluster.
        """
        return pulumi.get(self, "engine")

    @_builtins.property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> _builtins.str:
        """
        The engine version of the DBCluster.
        """
        return pulumi.get(self, "engine_version")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def memory(self) -> _builtins.int:
        """
        The memory resource amount of DBCluster. Depends on `db_cluster_class`.
        """
        return pulumi.get(self, "memory")

    @_builtins.property
    @pulumi.getter(name="paramChangeLogs")
    def param_change_logs(self) -> Sequence['outputs.GetDbClustersClusterParamChangeLogResult']:
        """
        The configuration change logs of parameters.
        """
        return pulumi.get(self, "param_change_logs")

    @_builtins.property
    @pulumi.getter
    def params(self) -> Sequence['outputs.GetDbClustersClusterParamResult']:
        """
        The details about each parameter in DBCluster returned.
        """
        return pulumi.get(self, "params")

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> _builtins.str:
        """
        The payment type of the resource. Valid values: `PayAsYouGo`,`Subscription`.
        """
        return pulumi.get(self, "payment_type")

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> _builtins.str:
        """
        The ID of region for the cluster.
        """
        return pulumi.get(self, "region_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the DBCluster. Valid values: `ACTIVATION`,`CREATING`,`DELETING`,`RESTARTING`,`ORDER_PREPARING`.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> _builtins.str:
        """
        The ID of the VPC for the cluster.
        """
        return pulumi.get(self, "vpc_id")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> _builtins.str:
        """
        The ID of zone for the cluster.
        """
        return pulumi.get(self, "zone_id")


@pulumi.output_type
class GetDbClustersClusterParamResult(dict):
    def __init__(__self__, *,
                 comment: _builtins.str,
                 default_value: _builtins.str,
                 is_dynamic: _builtins.int,
                 is_user_modifiable: _builtins.int,
                 name: _builtins.str,
                 optional: _builtins.str,
                 param_category: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str comment: The comments on the parameter.
        :param _builtins.str default_value: The default value of the parameter.
        :param _builtins.int is_dynamic: Indicates whether the parameter immediately takes effect without requiring a restart.
        :param _builtins.int is_user_modifiable: Indicates whether the parameter is modifiable.
        :param _builtins.str name: Changed parameter name.
        :param _builtins.str optional: The value range of the parameter.
        :param _builtins.str param_category: The category of the parameter.
        :param _builtins.str value: The new value of Parameter.
        """
        pulumi.set(__self__, "comment", comment)
        pulumi.set(__self__, "default_value", default_value)
        pulumi.set(__self__, "is_dynamic", is_dynamic)
        pulumi.set(__self__, "is_user_modifiable", is_user_modifiable)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "optional", optional)
        pulumi.set(__self__, "param_category", param_category)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> _builtins.str:
        """
        The comments on the parameter.
        """
        return pulumi.get(self, "comment")

    @_builtins.property
    @pulumi.getter(name="defaultValue")
    def default_value(self) -> _builtins.str:
        """
        The default value of the parameter.
        """
        return pulumi.get(self, "default_value")

    @_builtins.property
    @pulumi.getter(name="isDynamic")
    def is_dynamic(self) -> _builtins.int:
        """
        Indicates whether the parameter immediately takes effect without requiring a restart.
        """
        return pulumi.get(self, "is_dynamic")

    @_builtins.property
    @pulumi.getter(name="isUserModifiable")
    def is_user_modifiable(self) -> _builtins.int:
        """
        Indicates whether the parameter is modifiable.
        """
        return pulumi.get(self, "is_user_modifiable")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Changed parameter name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def optional(self) -> _builtins.str:
        """
        The value range of the parameter.
        """
        return pulumi.get(self, "optional")

    @_builtins.property
    @pulumi.getter(name="paramCategory")
    def param_category(self) -> _builtins.str:
        """
        The category of the parameter.
        """
        return pulumi.get(self, "param_category")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        The new value of Parameter.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetDbClustersClusterParamChangeLogResult(dict):
    def __init__(__self__, *,
                 config_id: _builtins.int,
                 gmt_created: _builtins.str,
                 gmt_modified: _builtins.str,
                 is_applied: _builtins.int,
                 name: _builtins.str,
                 new_value: _builtins.str,
                 old_value: _builtins.str):
        """
        :param _builtins.int config_id: The id of parameter change.
        :param _builtins.str gmt_created: When the parameter change is created.
        :param _builtins.str gmt_modified: When the parameter change is modified.
        :param _builtins.int is_applied: Whether the parameter changing is applied.
        :param _builtins.str name: Changed parameter name.
        :param _builtins.str new_value: The new value of parameter.
        :param _builtins.str old_value: The old value of parameter.
        """
        pulumi.set(__self__, "config_id", config_id)
        pulumi.set(__self__, "gmt_created", gmt_created)
        pulumi.set(__self__, "gmt_modified", gmt_modified)
        pulumi.set(__self__, "is_applied", is_applied)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "new_value", new_value)
        pulumi.set(__self__, "old_value", old_value)

    @_builtins.property
    @pulumi.getter(name="configId")
    def config_id(self) -> _builtins.int:
        """
        The id of parameter change.
        """
        return pulumi.get(self, "config_id")

    @_builtins.property
    @pulumi.getter(name="gmtCreated")
    def gmt_created(self) -> _builtins.str:
        """
        When the parameter change is created.
        """
        return pulumi.get(self, "gmt_created")

    @_builtins.property
    @pulumi.getter(name="gmtModified")
    def gmt_modified(self) -> _builtins.str:
        """
        When the parameter change is modified.
        """
        return pulumi.get(self, "gmt_modified")

    @_builtins.property
    @pulumi.getter(name="isApplied")
    def is_applied(self) -> _builtins.int:
        """
        Whether the parameter changing is applied.
        """
        return pulumi.get(self, "is_applied")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Changed parameter name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="newValue")
    def new_value(self) -> _builtins.str:
        """
        The new value of parameter.
        """
        return pulumi.get(self, "new_value")

    @_builtins.property
    @pulumi.getter(name="oldValue")
    def old_value(self) -> _builtins.str:
        """
        The old value of parameter.
        """
        return pulumi.get(self, "old_value")


@pulumi.output_type
class GetDbInstancesInstanceResult(dict):
    def __init__(__self__, *,
                 cache_size_postpaid: _builtins.int,
                 cache_size_prepaid: _builtins.int,
                 cluster_count_postpaid: _builtins.int,
                 cluster_count_prepaid: _builtins.int,
                 cpu_postpaid: _builtins.int,
                 cpu_prepaid: _builtins.int,
                 db_instance_description: _builtins.str,
                 db_instance_id: _builtins.str,
                 engine: _builtins.str,
                 engine_minor_version: _builtins.str,
                 engine_version: _builtins.str,
                 gmt_created: _builtins.str,
                 gmt_expired: _builtins.str,
                 gmt_modified: _builtins.str,
                 id: _builtins.str,
                 lock_mode: _builtins.str,
                 lock_reason: _builtins.str,
                 memory_postpaid: _builtins.int,
                 memory_prepaid: _builtins.int,
                 payment_type: _builtins.str,
                 region_id: _builtins.str,
                 status: _builtins.str,
                 sub_domain: _builtins.str,
                 vpc_id: _builtins.str,
                 vswitch_id: _builtins.str,
                 zone_id: _builtins.str):
        """
        :param _builtins.int cache_size_postpaid: The sum of cache size for every `PayAsYouGo` clusters in DBInstance.
        :param _builtins.int cache_size_prepaid: The sum of cache size for every `Subscription` clusters in DBInstance.
        :param _builtins.int cluster_count_postpaid: The sum of cluster counts for `PayAsYouGo` clusters in DBInstance.
        :param _builtins.int cluster_count_prepaid: The sum of cluster counts for `Subscription` clusters in DBInstance.
        :param _builtins.int cpu_postpaid: The sum of cpu resource amount for every `PayAsYouGo` clusters in DBInstance.
        :param _builtins.int cpu_prepaid: The sum of cpu resource amount for every `Subscription` clusters in DBInstance.
        :param _builtins.str db_instance_description: The DBInstance description.
        :param _builtins.str db_instance_id: The instance ID.
        :param _builtins.str engine: The Engine of the DBInstance.
        :param _builtins.str engine_minor_version: The engine minor version of the DBInstance.
        :param _builtins.str engine_version: The engine version of the DBInstance.
        :param _builtins.str gmt_created: The time when DBInstance is created.
        :param _builtins.str gmt_expired: The time when DBInstance will be expired. Available on `Subscription` DBInstance.
        :param _builtins.str gmt_modified: The time when DBInstance is modified.
        :param _builtins.str lock_mode: The lock mode of the instance. Set the value to lock, which specifies that the instance is locked when it automatically expires or has an overdue payment.
        :param _builtins.str lock_reason: The reason why the instance is locked.
        :param _builtins.int memory_postpaid: The sum of memory resource amount offor every `PayAsYouGo` clusters in DBInstance.
        :param _builtins.int memory_prepaid: The sum of memory resource amount offor every `Subscription` clusters in DBInstance.
        :param _builtins.str payment_type: The payment type of the resource. Valid values: `PayAsYouGo`,`Subscription`.
        :param _builtins.str region_id: The ID of region for DBInstance.
        :param _builtins.str status: The status of the DBInstance. Valid values: `ACTIVATION`,`CREATING`,`DELETING`,`RESTARTING`,`ORDER_PREPARING`.
        :param _builtins.str sub_domain: The sub domain of DBInstance.
        :param _builtins.str vpc_id: The ID of the VPC for DBInstance.
        :param _builtins.str vswitch_id: The ID of vswitch for DBInstance.
        :param _builtins.str zone_id: The ID of zone for DBInstance.
        """
        pulumi.set(__self__, "cache_size_postpaid", cache_size_postpaid)
        pulumi.set(__self__, "cache_size_prepaid", cache_size_prepaid)
        pulumi.set(__self__, "cluster_count_postpaid", cluster_count_postpaid)
        pulumi.set(__self__, "cluster_count_prepaid", cluster_count_prepaid)
        pulumi.set(__self__, "cpu_postpaid", cpu_postpaid)
        pulumi.set(__self__, "cpu_prepaid", cpu_prepaid)
        pulumi.set(__self__, "db_instance_description", db_instance_description)
        pulumi.set(__self__, "db_instance_id", db_instance_id)
        pulumi.set(__self__, "engine", engine)
        pulumi.set(__self__, "engine_minor_version", engine_minor_version)
        pulumi.set(__self__, "engine_version", engine_version)
        pulumi.set(__self__, "gmt_created", gmt_created)
        pulumi.set(__self__, "gmt_expired", gmt_expired)
        pulumi.set(__self__, "gmt_modified", gmt_modified)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "lock_mode", lock_mode)
        pulumi.set(__self__, "lock_reason", lock_reason)
        pulumi.set(__self__, "memory_postpaid", memory_postpaid)
        pulumi.set(__self__, "memory_prepaid", memory_prepaid)
        pulumi.set(__self__, "payment_type", payment_type)
        pulumi.set(__self__, "region_id", region_id)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "sub_domain", sub_domain)
        pulumi.set(__self__, "vpc_id", vpc_id)
        pulumi.set(__self__, "vswitch_id", vswitch_id)
        pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter(name="cacheSizePostpaid")
    def cache_size_postpaid(self) -> _builtins.int:
        """
        The sum of cache size for every `PayAsYouGo` clusters in DBInstance.
        """
        return pulumi.get(self, "cache_size_postpaid")

    @_builtins.property
    @pulumi.getter(name="cacheSizePrepaid")
    def cache_size_prepaid(self) -> _builtins.int:
        """
        The sum of cache size for every `Subscription` clusters in DBInstance.
        """
        return pulumi.get(self, "cache_size_prepaid")

    @_builtins.property
    @pulumi.getter(name="clusterCountPostpaid")
    def cluster_count_postpaid(self) -> _builtins.int:
        """
        The sum of cluster counts for `PayAsYouGo` clusters in DBInstance.
        """
        return pulumi.get(self, "cluster_count_postpaid")

    @_builtins.property
    @pulumi.getter(name="clusterCountPrepaid")
    def cluster_count_prepaid(self) -> _builtins.int:
        """
        The sum of cluster counts for `Subscription` clusters in DBInstance.
        """
        return pulumi.get(self, "cluster_count_prepaid")

    @_builtins.property
    @pulumi.getter(name="cpuPostpaid")
    def cpu_postpaid(self) -> _builtins.int:
        """
        The sum of cpu resource amount for every `PayAsYouGo` clusters in DBInstance.
        """
        return pulumi.get(self, "cpu_postpaid")

    @_builtins.property
    @pulumi.getter(name="cpuPrepaid")
    def cpu_prepaid(self) -> _builtins.int:
        """
        The sum of cpu resource amount for every `Subscription` clusters in DBInstance.
        """
        return pulumi.get(self, "cpu_prepaid")

    @_builtins.property
    @pulumi.getter(name="dbInstanceDescription")
    def db_instance_description(self) -> _builtins.str:
        """
        The DBInstance description.
        """
        return pulumi.get(self, "db_instance_description")

    @_builtins.property
    @pulumi.getter(name="dbInstanceId")
    def db_instance_id(self) -> _builtins.str:
        """
        The instance ID.
        """
        return pulumi.get(self, "db_instance_id")

    @_builtins.property
    @pulumi.getter
    def engine(self) -> _builtins.str:
        """
        The Engine of the DBInstance.
        """
        return pulumi.get(self, "engine")

    @_builtins.property
    @pulumi.getter(name="engineMinorVersion")
    def engine_minor_version(self) -> _builtins.str:
        """
        The engine minor version of the DBInstance.
        """
        return pulumi.get(self, "engine_minor_version")

    @_builtins.property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> _builtins.str:
        """
        The engine version of the DBInstance.
        """
        return pulumi.get(self, "engine_version")

    @_builtins.property
    @pulumi.getter(name="gmtCreated")
    def gmt_created(self) -> _builtins.str:
        """
        The time when DBInstance is created.
        """
        return pulumi.get(self, "gmt_created")

    @_builtins.property
    @pulumi.getter(name="gmtExpired")
    def gmt_expired(self) -> _builtins.str:
        """
        The time when DBInstance will be expired. Available on `Subscription` DBInstance.
        """
        return pulumi.get(self, "gmt_expired")

    @_builtins.property
    @pulumi.getter(name="gmtModified")
    def gmt_modified(self) -> _builtins.str:
        """
        The time when DBInstance is modified.
        """
        return pulumi.get(self, "gmt_modified")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="lockMode")
    def lock_mode(self) -> _builtins.str:
        """
        The lock mode of the instance. Set the value to lock, which specifies that the instance is locked when it automatically expires or has an overdue payment.
        """
        return pulumi.get(self, "lock_mode")

    @_builtins.property
    @pulumi.getter(name="lockReason")
    def lock_reason(self) -> _builtins.str:
        """
        The reason why the instance is locked.
        """
        return pulumi.get(self, "lock_reason")

    @_builtins.property
    @pulumi.getter(name="memoryPostpaid")
    def memory_postpaid(self) -> _builtins.int:
        """
        The sum of memory resource amount offor every `PayAsYouGo` clusters in DBInstance.
        """
        return pulumi.get(self, "memory_postpaid")

    @_builtins.property
    @pulumi.getter(name="memoryPrepaid")
    def memory_prepaid(self) -> _builtins.int:
        """
        The sum of memory resource amount offor every `Subscription` clusters in DBInstance.
        """
        return pulumi.get(self, "memory_prepaid")

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> _builtins.str:
        """
        The payment type of the resource. Valid values: `PayAsYouGo`,`Subscription`.
        """
        return pulumi.get(self, "payment_type")

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> _builtins.str:
        """
        The ID of region for DBInstance.
        """
        return pulumi.get(self, "region_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the DBInstance. Valid values: `ACTIVATION`,`CREATING`,`DELETING`,`RESTARTING`,`ORDER_PREPARING`.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="subDomain")
    def sub_domain(self) -> _builtins.str:
        """
        The sub domain of DBInstance.
        """
        return pulumi.get(self, "sub_domain")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> _builtins.str:
        """
        The ID of the VPC for DBInstance.
        """
        return pulumi.get(self, "vpc_id")

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> _builtins.str:
        """
        The ID of vswitch for DBInstance.
        """
        return pulumi.get(self, "vswitch_id")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> _builtins.str:
        """
        The ID of zone for DBInstance.
        """
        return pulumi.get(self, "zone_id")


