# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'AclEntryList',
    'BackendServerBackendServer',
    'ListenerXForwardedFor',
    'MasterSlaveServerGroupServer',
    'ServerGroupServer',
    'GetAclsAclResult',
    'GetAclsAclEntryListResult',
    'GetAclsAclRelatedListenerResult',
    'GetApplicationLoadBalancersBalancerResult',
    'GetApplicationLoadBalancersBalancerBackendServerResult',
    'GetApplicationLoadBalancersBalancerListenerPortsAndProtocalResult',
    'GetApplicationLoadBalancersBalancerListenerPortsAndProtocolResult',
    'GetApplicationLoadBalancersSlbResult',
    'GetAttachmentsSlbAttachmentResult',
    'GetBackendServersBackendServerResult',
    'GetCaCertificatesCertificateResult',
    'GetDomainExtensionsExtensionResult',
    'GetListenersSlbListenerResult',
    'GetLoadBalancersBalancerResult',
    'GetLoadBalancersBalancerBackendServerResult',
    'GetLoadBalancersBalancerListenerPortsAndProtocalResult',
    'GetLoadBalancersBalancerListenerPortsAndProtocolResult',
    'GetLoadBalancersSlbResult',
    'GetMasterSlaveServerGroupsGroupResult',
    'GetMasterSlaveServerGroupsGroupServerResult',
    'GetRulesSlbRuleResult',
    'GetServerCertificatesCertificateResult',
    'GetServerGroupsSlbServerGroupResult',
    'GetServerGroupsSlbServerGroupServerResult',
    'GetTlsCipherPoliciesPolicyResult',
    'GetTlsCipherPoliciesPolicyRelateListenerResult',
    'GetZonesZoneResult',
    'GetZonesZoneSupportedResourceResult',
]

@pulumi.output_type
class AclEntryList(dict):
    def __init__(__self__, *,
                 comment: Optional[_builtins.str] = None,
                 entry: Optional[_builtins.str] = None):
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if entry is not None:
            pulumi.set(__self__, "entry", entry)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "comment")

    @_builtins.property
    @pulumi.getter
    def entry(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "entry")


@pulumi.output_type
class BackendServerBackendServer(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "serverId":
            suggest = "server_id"
        elif key == "serverIp":
            suggest = "server_ip"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BackendServerBackendServer. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BackendServerBackendServer.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BackendServerBackendServer.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 server_id: _builtins.str,
                 weight: _builtins.int,
                 server_ip: Optional[_builtins.str] = None,
                 type: Optional[_builtins.str] = None):
        pulumi.set(__self__, "server_id", server_id)
        pulumi.set(__self__, "weight", weight)
        if server_ip is not None:
            pulumi.set(__self__, "server_ip", server_ip)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="serverId")
    def server_id(self) -> _builtins.str:
        return pulumi.get(self, "server_id")

    @_builtins.property
    @pulumi.getter
    def weight(self) -> _builtins.int:
        return pulumi.get(self, "weight")

    @_builtins.property
    @pulumi.getter(name="serverIp")
    def server_ip(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "server_ip")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "type")


@pulumi.output_type
class ListenerXForwardedFor(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "retriveClientIp":
            suggest = "retrive_client_ip"
        elif key == "retriveSlbId":
            suggest = "retrive_slb_id"
        elif key == "retriveSlbIp":
            suggest = "retrive_slb_ip"
        elif key == "retriveSlbProto":
            suggest = "retrive_slb_proto"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ListenerXForwardedFor. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ListenerXForwardedFor.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ListenerXForwardedFor.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 retrive_client_ip: Optional[_builtins.bool] = None,
                 retrive_slb_id: Optional[_builtins.bool] = None,
                 retrive_slb_ip: Optional[_builtins.bool] = None,
                 retrive_slb_proto: Optional[_builtins.bool] = None):
        """
        :param _builtins.bool retrive_client_ip: Whether to retrieve the client ip.
        :param _builtins.bool retrive_slb_id: Indicates whether the SLB-ID header is used to retrieve the ID of the CLB instance. Default value: `false`. Valid values: `true`, `false`.
        :param _builtins.bool retrive_slb_ip: Indicates whether the SLB-IP header is used to retrieve the virtual IP address (VIP) requested by the client. Default value: `false`. Valid values: `true`, `false`.
        :param _builtins.bool retrive_slb_proto: Specifies whether to use the X-Forwarded-Proto header to retrieve the listener protocol. Default value: `false`. Valid values: `true`, `false`.
        """
        if retrive_client_ip is not None:
            pulumi.set(__self__, "retrive_client_ip", retrive_client_ip)
        if retrive_slb_id is not None:
            pulumi.set(__self__, "retrive_slb_id", retrive_slb_id)
        if retrive_slb_ip is not None:
            pulumi.set(__self__, "retrive_slb_ip", retrive_slb_ip)
        if retrive_slb_proto is not None:
            pulumi.set(__self__, "retrive_slb_proto", retrive_slb_proto)

    @_builtins.property
    @pulumi.getter(name="retriveClientIp")
    def retrive_client_ip(self) -> Optional[_builtins.bool]:
        """
        Whether to retrieve the client ip.
        """
        return pulumi.get(self, "retrive_client_ip")

    @_builtins.property
    @pulumi.getter(name="retriveSlbId")
    def retrive_slb_id(self) -> Optional[_builtins.bool]:
        """
        Indicates whether the SLB-ID header is used to retrieve the ID of the CLB instance. Default value: `false`. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "retrive_slb_id")

    @_builtins.property
    @pulumi.getter(name="retriveSlbIp")
    def retrive_slb_ip(self) -> Optional[_builtins.bool]:
        """
        Indicates whether the SLB-IP header is used to retrieve the virtual IP address (VIP) requested by the client. Default value: `false`. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "retrive_slb_ip")

    @_builtins.property
    @pulumi.getter(name="retriveSlbProto")
    def retrive_slb_proto(self) -> Optional[_builtins.bool]:
        """
        Specifies whether to use the X-Forwarded-Proto header to retrieve the listener protocol. Default value: `false`. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "retrive_slb_proto")


@pulumi.output_type
class MasterSlaveServerGroupServer(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "serverId":
            suggest = "server_id"
        elif key == "isBackup":
            suggest = "is_backup"
        elif key == "serverType":
            suggest = "server_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MasterSlaveServerGroupServer. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MasterSlaveServerGroupServer.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MasterSlaveServerGroupServer.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 port: _builtins.int,
                 server_id: _builtins.str,
                 is_backup: Optional[_builtins.int] = None,
                 server_type: Optional[_builtins.str] = None,
                 type: Optional[_builtins.str] = None,
                 weight: Optional[_builtins.int] = None):
        """
        :param _builtins.int port: The port used by the backend server. Valid value range: [1-65535].
        :param _builtins.str server_id: A list backend server ID (ECS instance ID).
        :param _builtins.int is_backup: Determine if the server is executing. Valid value 0, 1.
        :param _builtins.str server_type: The server type of the backend server. Valid value Master, Slave.
        :param _builtins.str type: Type of the backend server. Valid value ecs, eni. Default to eni.
        :param _builtins.int weight: Weight of the backend server. Valid value range: [0-100]. Default to 100.
        """
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "server_id", server_id)
        if is_backup is not None:
            pulumi.set(__self__, "is_backup", is_backup)
        if server_type is not None:
            pulumi.set(__self__, "server_type", server_type)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        The port used by the backend server. Valid value range: [1-65535].
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="serverId")
    def server_id(self) -> _builtins.str:
        """
        A list backend server ID (ECS instance ID).
        """
        return pulumi.get(self, "server_id")

    @_builtins.property
    @pulumi.getter(name="isBackup")
    def is_backup(self) -> Optional[_builtins.int]:
        """
        Determine if the server is executing. Valid value 0, 1.
        """
        return pulumi.get(self, "is_backup")

    @_builtins.property
    @pulumi.getter(name="serverType")
    def server_type(self) -> Optional[_builtins.str]:
        """
        The server type of the backend server. Valid value Master, Slave.
        """
        return pulumi.get(self, "server_type")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        Type of the backend server. Valid value ecs, eni. Default to eni.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def weight(self) -> Optional[_builtins.int]:
        """
        Weight of the backend server. Valid value range: [0-100]. Default to 100.
        """
        return pulumi.get(self, "weight")


@pulumi.output_type
class ServerGroupServer(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "serverIds":
            suggest = "server_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerGroupServer. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerGroupServer.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerGroupServer.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 port: _builtins.int,
                 server_ids: Sequence[_builtins.str],
                 type: Optional[_builtins.str] = None,
                 weight: Optional[_builtins.int] = None):
        """
        :param _builtins.int port: The port used by the backend server. Valid values: `1` to `65535`.
        :param Sequence[_builtins.str] server_ids: The list of Elastic Compute Service (ECS) Ids or Elastic Network Interface (ENI) Ids.
        :param _builtins.str type: Specify the type of the backend server. Default value: `ecs`. Valid values: `ecs`, `eni`.
        :param _builtins.int weight: Weight of the backend server. Default value: `100`. Valid values: `0` to `100`.
        """
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "server_ids", server_ids)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        The port used by the backend server. Valid values: `1` to `65535`.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="serverIds")
    def server_ids(self) -> Sequence[_builtins.str]:
        """
        The list of Elastic Compute Service (ECS) Ids or Elastic Network Interface (ENI) Ids.
        """
        return pulumi.get(self, "server_ids")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        Specify the type of the backend server. Default value: `ecs`. Valid values: `ecs`, `eni`.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def weight(self) -> Optional[_builtins.int]:
        """
        Weight of the backend server. Default value: `100`. Valid values: `0` to `100`.
        """
        return pulumi.get(self, "weight")


@pulumi.output_type
class GetAclsAclResult(dict):
    def __init__(__self__, *,
                 entry_lists: Sequence['outputs.GetAclsAclEntryListResult'],
                 id: _builtins.str,
                 ip_version: _builtins.str,
                 name: _builtins.str,
                 related_listeners: Sequence['outputs.GetAclsAclRelatedListenerResult'],
                 resource_group_id: _builtins.str,
                 tags: Optional[Mapping[str, _builtins.str]] = None):
        """
        :param Sequence['GetAclsAclEntryListArgs'] entry_lists: A list of entry (IP addresses or CIDR blocks).  Each entry contains two sub-fields as `Entry Block` follows.
        :param _builtins.str id: Acl ID.
        :param _builtins.str name: Acl name.
        :param Sequence['GetAclsAclRelatedListenerArgs'] related_listeners: A list of listener are attached by the acl.  Each listener contains four sub-fields as `Listener Block` follows.
        :param _builtins.str resource_group_id: The Id of resource group which acl belongs.
        :param Mapping[str, _builtins.str] tags: A mapping of tags to assign to the resource.
        """
        pulumi.set(__self__, "entry_lists", entry_lists)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "ip_version", ip_version)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "related_listeners", related_listeners)
        pulumi.set(__self__, "resource_group_id", resource_group_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="entryLists")
    def entry_lists(self) -> Sequence['outputs.GetAclsAclEntryListResult']:
        """
        A list of entry (IP addresses or CIDR blocks).  Each entry contains two sub-fields as `Entry Block` follows.
        """
        return pulumi.get(self, "entry_lists")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        Acl ID.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> _builtins.str:
        return pulumi.get(self, "ip_version")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Acl name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="relatedListeners")
    def related_listeners(self) -> Sequence['outputs.GetAclsAclRelatedListenerResult']:
        """
        A list of listener are attached by the acl.  Each listener contains four sub-fields as `Listener Block` follows.
        """
        return pulumi.get(self, "related_listeners")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> _builtins.str:
        """
        The Id of resource group which acl belongs.
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class GetAclsAclEntryListResult(dict):
    def __init__(__self__, *,
                 comment: _builtins.str,
                 entry: _builtins.str):
        pulumi.set(__self__, "comment", comment)
        pulumi.set(__self__, "entry", entry)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> _builtins.str:
        return pulumi.get(self, "comment")

    @_builtins.property
    @pulumi.getter
    def entry(self) -> _builtins.str:
        return pulumi.get(self, "entry")


@pulumi.output_type
class GetAclsAclRelatedListenerResult(dict):
    def __init__(__self__, *,
                 acl_type: _builtins.str,
                 frontend_port: _builtins.int,
                 load_balancer_id: _builtins.str,
                 protocol: _builtins.str):
        pulumi.set(__self__, "acl_type", acl_type)
        pulumi.set(__self__, "frontend_port", frontend_port)
        pulumi.set(__self__, "load_balancer_id", load_balancer_id)
        pulumi.set(__self__, "protocol", protocol)

    @_builtins.property
    @pulumi.getter(name="aclType")
    def acl_type(self) -> _builtins.str:
        return pulumi.get(self, "acl_type")

    @_builtins.property
    @pulumi.getter(name="frontendPort")
    def frontend_port(self) -> _builtins.int:
        return pulumi.get(self, "frontend_port")

    @_builtins.property
    @pulumi.getter(name="loadBalancerId")
    def load_balancer_id(self) -> _builtins.str:
        return pulumi.get(self, "load_balancer_id")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> _builtins.str:
        return pulumi.get(self, "protocol")


@pulumi.output_type
class GetApplicationLoadBalancersBalancerResult(dict):
    def __init__(__self__, *,
                 address: _builtins.str,
                 address_ip_version: _builtins.str,
                 address_type: _builtins.str,
                 auto_release_time: _builtins.int,
                 backend_servers: Sequence['outputs.GetApplicationLoadBalancersBalancerBackendServerResult'],
                 bandwidth: _builtins.int,
                 create_time_stamp: _builtins.int,
                 delete_protection: _builtins.str,
                 end_time: _builtins.str,
                 end_time_stamp: _builtins.int,
                 id: _builtins.str,
                 internet_charge_type: _builtins.str,
                 listener_ports_and_protocals: Sequence['outputs.GetApplicationLoadBalancersBalancerListenerPortsAndProtocalResult'],
                 listener_ports_and_protocols: Sequence['outputs.GetApplicationLoadBalancersBalancerListenerPortsAndProtocolResult'],
                 load_balancer_id: _builtins.str,
                 load_balancer_name: _builtins.str,
                 load_balancer_spec: _builtins.str,
                 master_zone_id: _builtins.str,
                 modification_protection_reason: _builtins.str,
                 modification_protection_status: _builtins.str,
                 network_type: _builtins.str,
                 payment_type: _builtins.str,
                 region_id_alias: _builtins.str,
                 renewal_cyc_unit: _builtins.str,
                 renewal_duration: _builtins.int,
                 renewal_status: _builtins.str,
                 resource_group_id: _builtins.str,
                 slave_zone_id: _builtins.str,
                 status: _builtins.str,
                 tags: Mapping[str, _builtins.str],
                 vpc_id: _builtins.str,
                 vswitch_id: _builtins.str):
        """
        :param _builtins.str address: Service address of the SLBs.
        :param _builtins.str address_ip_version: The address ip version. Valid values `ipv4` and `ipv6`.
        :param _builtins.str address_type: The address type of the SLB. Valid values `internet` and `intranet`.
        :param _builtins.int auto_release_time: The auto release time.
        :param Sequence['GetApplicationLoadBalancersBalancerBackendServerArgs'] backend_servers: The backend servers of the SLB.
        :param _builtins.int bandwidth: The bandwidth of the SLB.
        :param _builtins.int create_time_stamp: The create time stamp of the SLB.
        :param _builtins.str delete_protection: Whether the SLB should delete protection.
        :param _builtins.str end_time: The end time of the SLB.
        :param _builtins.int end_time_stamp: The end time stamp of the SLB.
        :param _builtins.str id: ID of the SLB.
        :param _builtins.str internet_charge_type: The internet charge type. Valid values `PayByBandwidth` and `PayByTraffic`.
        :param Sequence['GetApplicationLoadBalancersBalancerListenerPortsAndProtocalArgs'] listener_ports_and_protocals: The listener ports and protocal of the SLB.
        :param Sequence['GetApplicationLoadBalancersBalancerListenerPortsAndProtocolArgs'] listener_ports_and_protocols: The listener ports and protocol of the SLB.
        :param _builtins.str load_balancer_id: Thd ID of the SLB.
        :param _builtins.str load_balancer_name: The name of the SLB.
        :param _builtins.str load_balancer_spec: The specification of the SLB.
        :param _builtins.str master_zone_id: The master zone id of the SLB.
        :param _builtins.str modification_protection_reason: The reason of modification protection.
        :param _builtins.str modification_protection_status: The status of modification protection.
        :param _builtins.str network_type: Network type of the SLBs. Valid values: `vpc` and `classic`.
        :param _builtins.str payment_type: The payment type of SLB. Valid values `PayAsYouGo` and `Subscription`.
        :param _builtins.str region_id_alias: Region ID the SLB belongs to.
        :param _builtins.str renewal_cyc_unit: The renewal cyc unit of the SLB.
        :param _builtins.int renewal_duration: The renewal duration of the SLB.
        :param _builtins.str renewal_status: The renewal status of the SLB.
        :param _builtins.str resource_group_id: The Id of resource group which SLB belongs.
        :param _builtins.str slave_zone_id: The slave zone id of the SLB.
        :param _builtins.str status: SLB current status. Possible values: `inactive`, `active` and `locked`.
        :param Mapping[str, _builtins.str] tags: A map of tags assigned to the SLB instances. The `tags` can have a maximum of 5 tag. It must be in the format:
        :param _builtins.str vpc_id: ID of the VPC linked to the SLBs.
        :param _builtins.str vswitch_id: ID of the vSwitch linked to the SLBs.
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "address_ip_version", address_ip_version)
        pulumi.set(__self__, "address_type", address_type)
        pulumi.set(__self__, "auto_release_time", auto_release_time)
        pulumi.set(__self__, "backend_servers", backend_servers)
        pulumi.set(__self__, "bandwidth", bandwidth)
        pulumi.set(__self__, "create_time_stamp", create_time_stamp)
        pulumi.set(__self__, "delete_protection", delete_protection)
        pulumi.set(__self__, "end_time", end_time)
        pulumi.set(__self__, "end_time_stamp", end_time_stamp)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "internet_charge_type", internet_charge_type)
        pulumi.set(__self__, "listener_ports_and_protocals", listener_ports_and_protocals)
        pulumi.set(__self__, "listener_ports_and_protocols", listener_ports_and_protocols)
        pulumi.set(__self__, "load_balancer_id", load_balancer_id)
        pulumi.set(__self__, "load_balancer_name", load_balancer_name)
        pulumi.set(__self__, "load_balancer_spec", load_balancer_spec)
        pulumi.set(__self__, "master_zone_id", master_zone_id)
        pulumi.set(__self__, "modification_protection_reason", modification_protection_reason)
        pulumi.set(__self__, "modification_protection_status", modification_protection_status)
        pulumi.set(__self__, "network_type", network_type)
        pulumi.set(__self__, "payment_type", payment_type)
        pulumi.set(__self__, "region_id_alias", region_id_alias)
        pulumi.set(__self__, "renewal_cyc_unit", renewal_cyc_unit)
        pulumi.set(__self__, "renewal_duration", renewal_duration)
        pulumi.set(__self__, "renewal_status", renewal_status)
        pulumi.set(__self__, "resource_group_id", resource_group_id)
        pulumi.set(__self__, "slave_zone_id", slave_zone_id)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "vpc_id", vpc_id)
        pulumi.set(__self__, "vswitch_id", vswitch_id)

    @_builtins.property
    @pulumi.getter
    def address(self) -> _builtins.str:
        """
        Service address of the SLBs.
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter(name="addressIpVersion")
    def address_ip_version(self) -> _builtins.str:
        """
        The address ip version. Valid values `ipv4` and `ipv6`.
        """
        return pulumi.get(self, "address_ip_version")

    @_builtins.property
    @pulumi.getter(name="addressType")
    def address_type(self) -> _builtins.str:
        """
        The address type of the SLB. Valid values `internet` and `intranet`.
        """
        return pulumi.get(self, "address_type")

    @_builtins.property
    @pulumi.getter(name="autoReleaseTime")
    def auto_release_time(self) -> _builtins.int:
        """
        The auto release time.
        """
        return pulumi.get(self, "auto_release_time")

    @_builtins.property
    @pulumi.getter(name="backendServers")
    def backend_servers(self) -> Sequence['outputs.GetApplicationLoadBalancersBalancerBackendServerResult']:
        """
        The backend servers of the SLB.
        """
        return pulumi.get(self, "backend_servers")

    @_builtins.property
    @pulumi.getter
    def bandwidth(self) -> _builtins.int:
        """
        The bandwidth of the SLB.
        """
        return pulumi.get(self, "bandwidth")

    @_builtins.property
    @pulumi.getter(name="createTimeStamp")
    def create_time_stamp(self) -> _builtins.int:
        """
        The create time stamp of the SLB.
        """
        return pulumi.get(self, "create_time_stamp")

    @_builtins.property
    @pulumi.getter(name="deleteProtection")
    def delete_protection(self) -> _builtins.str:
        """
        Whether the SLB should delete protection.
        """
        return pulumi.get(self, "delete_protection")

    @_builtins.property
    @pulumi.getter(name="endTime")
    def end_time(self) -> _builtins.str:
        """
        The end time of the SLB.
        """
        return pulumi.get(self, "end_time")

    @_builtins.property
    @pulumi.getter(name="endTimeStamp")
    def end_time_stamp(self) -> _builtins.int:
        """
        The end time stamp of the SLB.
        """
        return pulumi.get(self, "end_time_stamp")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        ID of the SLB.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="internetChargeType")
    def internet_charge_type(self) -> _builtins.str:
        """
        The internet charge type. Valid values `PayByBandwidth` and `PayByTraffic`.
        """
        return pulumi.get(self, "internet_charge_type")

    @_builtins.property
    @pulumi.getter(name="listenerPortsAndProtocals")
    def listener_ports_and_protocals(self) -> Sequence['outputs.GetApplicationLoadBalancersBalancerListenerPortsAndProtocalResult']:
        """
        The listener ports and protocal of the SLB.
        """
        return pulumi.get(self, "listener_ports_and_protocals")

    @_builtins.property
    @pulumi.getter(name="listenerPortsAndProtocols")
    def listener_ports_and_protocols(self) -> Sequence['outputs.GetApplicationLoadBalancersBalancerListenerPortsAndProtocolResult']:
        """
        The listener ports and protocol of the SLB.
        """
        return pulumi.get(self, "listener_ports_and_protocols")

    @_builtins.property
    @pulumi.getter(name="loadBalancerId")
    def load_balancer_id(self) -> _builtins.str:
        """
        Thd ID of the SLB.
        """
        return pulumi.get(self, "load_balancer_id")

    @_builtins.property
    @pulumi.getter(name="loadBalancerName")
    def load_balancer_name(self) -> _builtins.str:
        """
        The name of the SLB.
        """
        return pulumi.get(self, "load_balancer_name")

    @_builtins.property
    @pulumi.getter(name="loadBalancerSpec")
    def load_balancer_spec(self) -> _builtins.str:
        """
        The specification of the SLB.
        """
        return pulumi.get(self, "load_balancer_spec")

    @_builtins.property
    @pulumi.getter(name="masterZoneId")
    def master_zone_id(self) -> _builtins.str:
        """
        The master zone id of the SLB.
        """
        return pulumi.get(self, "master_zone_id")

    @_builtins.property
    @pulumi.getter(name="modificationProtectionReason")
    def modification_protection_reason(self) -> _builtins.str:
        """
        The reason of modification protection.
        """
        return pulumi.get(self, "modification_protection_reason")

    @_builtins.property
    @pulumi.getter(name="modificationProtectionStatus")
    def modification_protection_status(self) -> _builtins.str:
        """
        The status of modification protection.
        """
        return pulumi.get(self, "modification_protection_status")

    @_builtins.property
    @pulumi.getter(name="networkType")
    def network_type(self) -> _builtins.str:
        """
        Network type of the SLBs. Valid values: `vpc` and `classic`.
        """
        return pulumi.get(self, "network_type")

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> _builtins.str:
        """
        The payment type of SLB. Valid values `PayAsYouGo` and `Subscription`.
        """
        return pulumi.get(self, "payment_type")

    @_builtins.property
    @pulumi.getter(name="regionIdAlias")
    def region_id_alias(self) -> _builtins.str:
        """
        Region ID the SLB belongs to.
        """
        return pulumi.get(self, "region_id_alias")

    @_builtins.property
    @pulumi.getter(name="renewalCycUnit")
    def renewal_cyc_unit(self) -> _builtins.str:
        """
        The renewal cyc unit of the SLB.
        """
        return pulumi.get(self, "renewal_cyc_unit")

    @_builtins.property
    @pulumi.getter(name="renewalDuration")
    def renewal_duration(self) -> _builtins.int:
        """
        The renewal duration of the SLB.
        """
        return pulumi.get(self, "renewal_duration")

    @_builtins.property
    @pulumi.getter(name="renewalStatus")
    def renewal_status(self) -> _builtins.str:
        """
        The renewal status of the SLB.
        """
        return pulumi.get(self, "renewal_status")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> _builtins.str:
        """
        The Id of resource group which SLB belongs.
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter(name="slaveZoneId")
    def slave_zone_id(self) -> _builtins.str:
        """
        The slave zone id of the SLB.
        """
        return pulumi.get(self, "slave_zone_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        SLB current status. Possible values: `inactive`, `active` and `locked`.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        A map of tags assigned to the SLB instances. The `tags` can have a maximum of 5 tag. It must be in the format:
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> _builtins.str:
        """
        ID of the VPC linked to the SLBs.
        """
        return pulumi.get(self, "vpc_id")

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> _builtins.str:
        """
        ID of the vSwitch linked to the SLBs.
        """
        return pulumi.get(self, "vswitch_id")


@pulumi.output_type
class GetApplicationLoadBalancersBalancerBackendServerResult(dict):
    def __init__(__self__, *,
                 description: _builtins.str,
                 server_id: _builtins.str,
                 type: _builtins.str,
                 weight: _builtins.int):
        """
        :param _builtins.str description: The description of protocol.
        :param _builtins.str server_id: The server ID.
        :param _builtins.str type: The type of servers.
        :param _builtins.int weight: The weight of servers.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "server_id", server_id)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "weight", weight)

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of protocol.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="serverId")
    def server_id(self) -> _builtins.str:
        """
        The server ID.
        """
        return pulumi.get(self, "server_id")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of servers.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def weight(self) -> _builtins.int:
        """
        The weight of servers.
        """
        return pulumi.get(self, "weight")


@pulumi.output_type
class GetApplicationLoadBalancersBalancerListenerPortsAndProtocalResult(dict):
    def __init__(__self__, *,
                 listener_port: _builtins.int,
                 listener_protocal: _builtins.str):
        """
        :param _builtins.int listener_port: The listener port.
        :param _builtins.str listener_protocal: The listener protoal.
        """
        pulumi.set(__self__, "listener_port", listener_port)
        pulumi.set(__self__, "listener_protocal", listener_protocal)

    @_builtins.property
    @pulumi.getter(name="listenerPort")
    def listener_port(self) -> _builtins.int:
        """
        The listener port.
        """
        return pulumi.get(self, "listener_port")

    @_builtins.property
    @pulumi.getter(name="listenerProtocal")
    def listener_protocal(self) -> _builtins.str:
        """
        The listener protoal.
        """
        return pulumi.get(self, "listener_protocal")


@pulumi.output_type
class GetApplicationLoadBalancersBalancerListenerPortsAndProtocolResult(dict):
    def __init__(__self__, *,
                 description: _builtins.str,
                 forward_port: _builtins.int,
                 listener_forward: _builtins.str,
                 listener_port: _builtins.int,
                 listener_protocol: _builtins.str):
        """
        :param _builtins.str description: The description of protocol.
        :param _builtins.int forward_port: The forward port.
        :param _builtins.str listener_forward: The listener forward.
        :param _builtins.int listener_port: The listener port.
        :param _builtins.str listener_protocol: The listener protocol.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "forward_port", forward_port)
        pulumi.set(__self__, "listener_forward", listener_forward)
        pulumi.set(__self__, "listener_port", listener_port)
        pulumi.set(__self__, "listener_protocol", listener_protocol)

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of protocol.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="forwardPort")
    def forward_port(self) -> _builtins.int:
        """
        The forward port.
        """
        return pulumi.get(self, "forward_port")

    @_builtins.property
    @pulumi.getter(name="listenerForward")
    def listener_forward(self) -> _builtins.str:
        """
        The listener forward.
        """
        return pulumi.get(self, "listener_forward")

    @_builtins.property
    @pulumi.getter(name="listenerPort")
    def listener_port(self) -> _builtins.int:
        """
        The listener port.
        """
        return pulumi.get(self, "listener_port")

    @_builtins.property
    @pulumi.getter(name="listenerProtocol")
    def listener_protocol(self) -> _builtins.str:
        """
        The listener protocol.
        """
        return pulumi.get(self, "listener_protocol")


@pulumi.output_type
class GetApplicationLoadBalancersSlbResult(dict):
    def __init__(__self__, *,
                 address: _builtins.str,
                 creation_time: _builtins.str,
                 id: _builtins.str,
                 internet: _builtins.bool,
                 master_availability_zone: _builtins.str,
                 name: _builtins.str,
                 network_type: _builtins.str,
                 region_id: _builtins.str,
                 slave_availability_zone: _builtins.str,
                 status: _builtins.str,
                 tags: Mapping[str, _builtins.str],
                 vpc_id: _builtins.str,
                 vswitch_id: _builtins.str):
        """
        :param _builtins.str address: Service address of the SLBs.
        :param _builtins.str id: ID of the SLB.
        :param _builtins.str network_type: Network type of the SLBs. Valid values: `vpc` and `classic`.
        :param _builtins.str status: SLB current status. Possible values: `inactive`, `active` and `locked`.
        :param Mapping[str, _builtins.str] tags: A map of tags assigned to the SLB instances. The `tags` can have a maximum of 5 tag. It must be in the format:
        :param _builtins.str vpc_id: ID of the VPC linked to the SLBs.
        :param _builtins.str vswitch_id: ID of the vSwitch linked to the SLBs.
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "creation_time", creation_time)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "internet", internet)
        pulumi.set(__self__, "master_availability_zone", master_availability_zone)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "network_type", network_type)
        pulumi.set(__self__, "region_id", region_id)
        pulumi.set(__self__, "slave_availability_zone", slave_availability_zone)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "vpc_id", vpc_id)
        pulumi.set(__self__, "vswitch_id", vswitch_id)

    @_builtins.property
    @pulumi.getter
    def address(self) -> _builtins.str:
        """
        Service address of the SLBs.
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> _builtins.str:
        return pulumi.get(self, "creation_time")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        ID of the SLB.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def internet(self) -> _builtins.bool:
        return pulumi.get(self, "internet")

    @_builtins.property
    @pulumi.getter(name="masterAvailabilityZone")
    def master_availability_zone(self) -> _builtins.str:
        return pulumi.get(self, "master_availability_zone")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="networkType")
    def network_type(self) -> _builtins.str:
        """
        Network type of the SLBs. Valid values: `vpc` and `classic`.
        """
        return pulumi.get(self, "network_type")

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> _builtins.str:
        return pulumi.get(self, "region_id")

    @_builtins.property
    @pulumi.getter(name="slaveAvailabilityZone")
    def slave_availability_zone(self) -> _builtins.str:
        return pulumi.get(self, "slave_availability_zone")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        SLB current status. Possible values: `inactive`, `active` and `locked`.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        A map of tags assigned to the SLB instances. The `tags` can have a maximum of 5 tag. It must be in the format:
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> _builtins.str:
        """
        ID of the VPC linked to the SLBs.
        """
        return pulumi.get(self, "vpc_id")

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> _builtins.str:
        """
        ID of the vSwitch linked to the SLBs.
        """
        return pulumi.get(self, "vswitch_id")


@pulumi.output_type
class GetAttachmentsSlbAttachmentResult(dict):
    def __init__(__self__, *,
                 instance_id: _builtins.str,
                 weight: _builtins.int):
        """
        :param _builtins.str instance_id: ID of the attached ECS instance.
        :param _builtins.int weight: Weight associated to the ECS instance.
        """
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "weight", weight)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> _builtins.str:
        """
        ID of the attached ECS instance.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter
    def weight(self) -> _builtins.int:
        """
        Weight associated to the ECS instance.
        """
        return pulumi.get(self, "weight")


@pulumi.output_type
class GetBackendServersBackendServerResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 server_type: _builtins.str,
                 weight: _builtins.int):
        """
        :param _builtins.str id: backend server ID.
        :param _builtins.str server_type: Type of the backend server.
        :param _builtins.int weight: Weight associated to the ECS instance.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "server_type", server_type)
        pulumi.set(__self__, "weight", weight)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        backend server ID.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="serverType")
    def server_type(self) -> _builtins.str:
        """
        Type of the backend server.
        """
        return pulumi.get(self, "server_type")

    @_builtins.property
    @pulumi.getter
    def weight(self) -> _builtins.int:
        """
        Weight associated to the ECS instance.
        """
        return pulumi.get(self, "weight")


@pulumi.output_type
class GetCaCertificatesCertificateResult(dict):
    def __init__(__self__, *,
                 ca_certificate_id: _builtins.str,
                 ca_certificate_name: _builtins.str,
                 common_name: _builtins.str,
                 created_timestamp: _builtins.int,
                 expired_time: _builtins.str,
                 expired_timestamp: _builtins.int,
                 fingerprint: _builtins.str,
                 id: _builtins.str,
                 name: _builtins.str,
                 resource_group_id: _builtins.str,
                 tags: Mapping[str, _builtins.str]):
        """
        :param _builtins.str ca_certificate_id: (Available in v1.123.1+) CA certificate ID.
        :param _builtins.str ca_certificate_name: (Available in v1.123.1+) CA certificate name.
        :param _builtins.str common_name: CA certificate common name.
        :param _builtins.int created_timestamp: CA certificate created timestamp.
        :param _builtins.str expired_time: CA certificate expired time.
        :param _builtins.int expired_timestamp: CA certificate expired timestamp.
        :param _builtins.str fingerprint: CA certificate fingerprint.
        :param _builtins.str id: CA certificate ID.
        :param _builtins.str name: (Deprecated from v1.123.1) Deprecated and replace by `ca_certificate_name`.
        :param _builtins.str resource_group_id: The Id of resource group which ca certificates belongs.
        :param Mapping[str, _builtins.str] tags: A mapping of tags to assign to the resource.
        """
        pulumi.set(__self__, "ca_certificate_id", ca_certificate_id)
        pulumi.set(__self__, "ca_certificate_name", ca_certificate_name)
        pulumi.set(__self__, "common_name", common_name)
        pulumi.set(__self__, "created_timestamp", created_timestamp)
        pulumi.set(__self__, "expired_time", expired_time)
        pulumi.set(__self__, "expired_timestamp", expired_timestamp)
        pulumi.set(__self__, "fingerprint", fingerprint)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "resource_group_id", resource_group_id)
        pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="caCertificateId")
    def ca_certificate_id(self) -> _builtins.str:
        """
        (Available in v1.123.1+) CA certificate ID.
        """
        return pulumi.get(self, "ca_certificate_id")

    @_builtins.property
    @pulumi.getter(name="caCertificateName")
    def ca_certificate_name(self) -> _builtins.str:
        """
        (Available in v1.123.1+) CA certificate name.
        """
        return pulumi.get(self, "ca_certificate_name")

    @_builtins.property
    @pulumi.getter(name="commonName")
    def common_name(self) -> _builtins.str:
        """
        CA certificate common name.
        """
        return pulumi.get(self, "common_name")

    @_builtins.property
    @pulumi.getter(name="createdTimestamp")
    def created_timestamp(self) -> _builtins.int:
        """
        CA certificate created timestamp.
        """
        return pulumi.get(self, "created_timestamp")

    @_builtins.property
    @pulumi.getter(name="expiredTime")
    def expired_time(self) -> _builtins.str:
        """
        CA certificate expired time.
        """
        return pulumi.get(self, "expired_time")

    @_builtins.property
    @pulumi.getter(name="expiredTimestamp")
    def expired_timestamp(self) -> _builtins.int:
        """
        CA certificate expired timestamp.
        """
        return pulumi.get(self, "expired_timestamp")

    @_builtins.property
    @pulumi.getter
    def fingerprint(self) -> _builtins.str:
        """
        CA certificate fingerprint.
        """
        return pulumi.get(self, "fingerprint")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        CA certificate ID.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        (Deprecated from v1.123.1) Deprecated and replace by `ca_certificate_name`.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> _builtins.str:
        """
        The Id of resource group which ca certificates belongs.
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class GetDomainExtensionsExtensionResult(dict):
    def __init__(__self__, *,
                 domain: _builtins.str,
                 id: _builtins.str,
                 server_certificate_id: _builtins.str):
        """
        :param _builtins.str domain: The domain name.
        :param _builtins.str id: The ID of the domain extension.
        :param _builtins.str server_certificate_id: The ID of the certificate used by the domain name.
        """
        pulumi.set(__self__, "domain", domain)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "server_certificate_id", server_certificate_id)

    @_builtins.property
    @pulumi.getter
    def domain(self) -> _builtins.str:
        """
        The domain name.
        """
        return pulumi.get(self, "domain")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the domain extension.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="serverCertificateId")
    def server_certificate_id(self) -> _builtins.str:
        """
        The ID of the certificate used by the domain name.
        """
        return pulumi.get(self, "server_certificate_id")


@pulumi.output_type
class GetListenersSlbListenerResult(dict):
    def __init__(__self__, *,
                 backend_port: _builtins.int,
                 bandwidth: _builtins.int,
                 ca_certificate_id: _builtins.str,
                 cookie: _builtins.str,
                 cookie_timeout: _builtins.int,
                 description: _builtins.str,
                 enable_http2: _builtins.str,
                 established_timeout: _builtins.int,
                 frontend_port: _builtins.int,
                 gzip: _builtins.str,
                 health_check: _builtins.str,
                 health_check_connect_port: _builtins.int,
                 health_check_connect_timeout: _builtins.int,
                 health_check_domain: _builtins.str,
                 health_check_http_code: _builtins.str,
                 health_check_interval: _builtins.int,
                 health_check_timeout: _builtins.int,
                 health_check_type: _builtins.str,
                 health_check_uri: _builtins.str,
                 healthy_threshold: _builtins.int,
                 idle_timeout: _builtins.int,
                 master_slave_server_group_id: _builtins.str,
                 persistence_timeout: _builtins.int,
                 protocol: _builtins.str,
                 proxy_protocol_v2_enabled: _builtins.bool,
                 request_timeout: _builtins.int,
                 scheduler: _builtins.str,
                 security_status: _builtins.str,
                 server_certificate_id: _builtins.str,
                 server_group_id: _builtins.str,
                 ssl_certificate_id: _builtins.str,
                 status: _builtins.str,
                 sticky_session: _builtins.str,
                 sticky_session_type: _builtins.str,
                 tls_cipher_policy: _builtins.str,
                 unhealthy_threshold: _builtins.int,
                 x_forwarded_for: _builtins.str,
                 x_forwarded_for_slb_id: _builtins.str,
                 x_forwarded_for_slb_ip: _builtins.str,
                 x_forwarded_for_slb_proto: _builtins.str):
        """
        :param _builtins.int backend_port: Port opened on the backend server to receive requests.
        :param _builtins.int bandwidth: Peak bandwidth. If the value is set to -1, the listener is not limited by bandwidth.
        :param _builtins.str ca_certificate_id: ID of the CA certificate (only required when two-way authentication is used). Only available when the protocol is `https`.
        :param _builtins.str cookie: Cookie configured by the backend server. Only available when the sticky_session_type is `server`.
        :param _builtins.int cookie_timeout: Cookie timeout in seconds. Only available when the sticky_session_type is `insert`.
        :param _builtins.str description: The description of slb listener.
        :param _builtins.str enable_http2: Whether to enable https listener support http2 or not. Valid values are `on` and `off`. Default to `on`.
        :param _builtins.int established_timeout: Connection timeout in seconds for the Layer 4 TCP listener. Only available when the protocol is `tcp`.
        :param _builtins.int frontend_port: Filter listeners by the specified frontend port.
        :param _builtins.str gzip: Indicate whether Gzip compression is enabled or not. Possible values are `on` and `off`. Only available when the protocol is `http` or `https`.
        :param _builtins.str health_check: Indicate whether health check is enabled of not. Possible values are `on` and `off`.
        :param _builtins.int health_check_connect_port: Port used for health check.
        :param _builtins.int health_check_connect_timeout: Amount of time in seconds to wait for the response for a health check.
        :param _builtins.str health_check_domain: Domain name used for health check. The SLB sends HTTP head requests to the backend server, the domain is useful when the backend server verifies the host field in the requests. Only available when the protocol is `http`, `https` or `tcp` (in this case health_check_type must be `http`).
        :param _builtins.str health_check_http_code: HTTP status codes indicating that the health check is normal. It can contain several comma-separated values such as "http_2xx,http_3xx". Only available when the protocol is `http`, `https` or `tcp` (in this case health_check_type must be `http`).
        :param _builtins.int health_check_interval: Time interval between two consecutive health checks.
        :param _builtins.int health_check_timeout: Amount of time in seconds to wait for the response from a health check. If an ECS instance sends no response within the specified timeout period, the health check fails. Only available when the protocol is `http` or `https`.
        :param _builtins.str health_check_type: Health check method. Possible values are `tcp` and `http`. Only available when the protocol is `tcp`.
        :param _builtins.str health_check_uri: URI used for health check. Only available when the protocol is `http`, `https` or `tcp` (in this case health_check_type must be `http`).
        :param _builtins.int healthy_threshold: Number of consecutive successes of health check performed on the same ECS instance (from failure to success).
        :param _builtins.int idle_timeout: Timeout of http or https listener established connection idle timeout. Valid value range: [1-60] in seconds. Default to 15.
        :param _builtins.str master_slave_server_group_id: ID of the active/standby server group.
        :param _builtins.int persistence_timeout: Timeout value of the TCP connection in seconds. If the value is 0, the session persistence function is disabled. Only available when the protocol is `tcp`.
        :param _builtins.str protocol: Filter listeners by the specified protocol. Valid values: `http`, `https`, `tcp` and `udp`.
        :param _builtins.bool proxy_protocol_v2_enabled: Whether to support carrying the client source address to the backend server through the Proxy Protocol. Valid values are `true` and `false`. Default to `false`.
        :param _builtins.int request_timeout: Timeout of http or https listener request (which does not get response from backend) timeout. Valid value range: [1-180] in seconds. Default to 60.
        :param _builtins.str scheduler: Algorithm used to distribute traffic. Possible values: `wrr` (weighted round robin), `wlc` (weighted least connection) and `rr` (round robin).
        :param _builtins.str security_status: Security status. Only available when the protocol is `https`.
        :param _builtins.str server_group_id: ID of the linked VServer group.
        :param _builtins.str ssl_certificate_id: ID of the server certificate. Only available when the protocol is `https`.
        :param _builtins.str status: Listener status.
        :param _builtins.str sticky_session: Indicate whether session persistence is enabled or not. If enabled, all session requests from the same client are sent to the same backend server. Possible values are `on` and `off`. Only available when the protocol is `http` or `https`.
        :param _builtins.str sticky_session_type: Method used to handle the cookie. Possible values are `insert` (cookie added to the response) and `server` (cookie set by the backend server). Only available when the protocol is `http` or `https` and sticky_session is `on`.
        :param _builtins.str tls_cipher_policy: Https listener TLS cipher policy. Valid values are `tls_cipher_policy_1_0`, `tls_cipher_policy_1_1`, `tls_cipher_policy_1_2`, `tls_cipher_policy_1_2_strict`. Default to `tls_cipher_policy_1_0`.
        :param _builtins.int unhealthy_threshold: Number of consecutive failures of health check performed on the same ECS instance (from success to failure).
        :param _builtins.str x_forwarded_for: Indicate whether the HTTP header field "X-Forwarded-For" is added or not; it allows the backend server to know about the user's IP address. Possible values are `on` and `off`. Only available when the protocol is `http` or `https`.
        :param _builtins.str x_forwarded_for_slb_id: Indicate whether the HTTP header field "X-Forwarded-For_SLBID" is added or not; it allows the backend server to know about the SLB ID. Possible values are `on` and `off`. Only available when the protocol is `http` or `https`.
        :param _builtins.str x_forwarded_for_slb_ip: Indicate whether the HTTP header field "X-Forwarded-For_SLBIP" is added or not; it allows the backend server to know about the SLB IP address. Possible values are `on` and `off`. Only available when the protocol is `http` or `https`.
        :param _builtins.str x_forwarded_for_slb_proto: Indicate whether the HTTP header field "X-Forwarded-For_proto" is added or not; it allows the backend server to know about the user's protocol. Possible values are `on` and `off`. Only available when the protocol is `http` or `https`.
        """
        pulumi.set(__self__, "backend_port", backend_port)
        pulumi.set(__self__, "bandwidth", bandwidth)
        pulumi.set(__self__, "ca_certificate_id", ca_certificate_id)
        pulumi.set(__self__, "cookie", cookie)
        pulumi.set(__self__, "cookie_timeout", cookie_timeout)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "enable_http2", enable_http2)
        pulumi.set(__self__, "established_timeout", established_timeout)
        pulumi.set(__self__, "frontend_port", frontend_port)
        pulumi.set(__self__, "gzip", gzip)
        pulumi.set(__self__, "health_check", health_check)
        pulumi.set(__self__, "health_check_connect_port", health_check_connect_port)
        pulumi.set(__self__, "health_check_connect_timeout", health_check_connect_timeout)
        pulumi.set(__self__, "health_check_domain", health_check_domain)
        pulumi.set(__self__, "health_check_http_code", health_check_http_code)
        pulumi.set(__self__, "health_check_interval", health_check_interval)
        pulumi.set(__self__, "health_check_timeout", health_check_timeout)
        pulumi.set(__self__, "health_check_type", health_check_type)
        pulumi.set(__self__, "health_check_uri", health_check_uri)
        pulumi.set(__self__, "healthy_threshold", healthy_threshold)
        pulumi.set(__self__, "idle_timeout", idle_timeout)
        pulumi.set(__self__, "master_slave_server_group_id", master_slave_server_group_id)
        pulumi.set(__self__, "persistence_timeout", persistence_timeout)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "proxy_protocol_v2_enabled", proxy_protocol_v2_enabled)
        pulumi.set(__self__, "request_timeout", request_timeout)
        pulumi.set(__self__, "scheduler", scheduler)
        pulumi.set(__self__, "security_status", security_status)
        pulumi.set(__self__, "server_certificate_id", server_certificate_id)
        pulumi.set(__self__, "server_group_id", server_group_id)
        pulumi.set(__self__, "ssl_certificate_id", ssl_certificate_id)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "sticky_session", sticky_session)
        pulumi.set(__self__, "sticky_session_type", sticky_session_type)
        pulumi.set(__self__, "tls_cipher_policy", tls_cipher_policy)
        pulumi.set(__self__, "unhealthy_threshold", unhealthy_threshold)
        pulumi.set(__self__, "x_forwarded_for", x_forwarded_for)
        pulumi.set(__self__, "x_forwarded_for_slb_id", x_forwarded_for_slb_id)
        pulumi.set(__self__, "x_forwarded_for_slb_ip", x_forwarded_for_slb_ip)
        pulumi.set(__self__, "x_forwarded_for_slb_proto", x_forwarded_for_slb_proto)

    @_builtins.property
    @pulumi.getter(name="backendPort")
    def backend_port(self) -> _builtins.int:
        """
        Port opened on the backend server to receive requests.
        """
        return pulumi.get(self, "backend_port")

    @_builtins.property
    @pulumi.getter
    def bandwidth(self) -> _builtins.int:
        """
        Peak bandwidth. If the value is set to -1, the listener is not limited by bandwidth.
        """
        return pulumi.get(self, "bandwidth")

    @_builtins.property
    @pulumi.getter(name="caCertificateId")
    def ca_certificate_id(self) -> _builtins.str:
        """
        ID of the CA certificate (only required when two-way authentication is used). Only available when the protocol is `https`.
        """
        return pulumi.get(self, "ca_certificate_id")

    @_builtins.property
    @pulumi.getter
    def cookie(self) -> _builtins.str:
        """
        Cookie configured by the backend server. Only available when the sticky_session_type is `server`.
        """
        return pulumi.get(self, "cookie")

    @_builtins.property
    @pulumi.getter(name="cookieTimeout")
    def cookie_timeout(self) -> _builtins.int:
        """
        Cookie timeout in seconds. Only available when the sticky_session_type is `insert`.
        """
        return pulumi.get(self, "cookie_timeout")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of slb listener.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="enableHttp2")
    def enable_http2(self) -> _builtins.str:
        """
        Whether to enable https listener support http2 or not. Valid values are `on` and `off`. Default to `on`.
        """
        return pulumi.get(self, "enable_http2")

    @_builtins.property
    @pulumi.getter(name="establishedTimeout")
    def established_timeout(self) -> _builtins.int:
        """
        Connection timeout in seconds for the Layer 4 TCP listener. Only available when the protocol is `tcp`.
        """
        return pulumi.get(self, "established_timeout")

    @_builtins.property
    @pulumi.getter(name="frontendPort")
    def frontend_port(self) -> _builtins.int:
        """
        Filter listeners by the specified frontend port.
        """
        return pulumi.get(self, "frontend_port")

    @_builtins.property
    @pulumi.getter
    def gzip(self) -> _builtins.str:
        """
        Indicate whether Gzip compression is enabled or not. Possible values are `on` and `off`. Only available when the protocol is `http` or `https`.
        """
        return pulumi.get(self, "gzip")

    @_builtins.property
    @pulumi.getter(name="healthCheck")
    def health_check(self) -> _builtins.str:
        """
        Indicate whether health check is enabled of not. Possible values are `on` and `off`.
        """
        return pulumi.get(self, "health_check")

    @_builtins.property
    @pulumi.getter(name="healthCheckConnectPort")
    def health_check_connect_port(self) -> _builtins.int:
        """
        Port used for health check.
        """
        return pulumi.get(self, "health_check_connect_port")

    @_builtins.property
    @pulumi.getter(name="healthCheckConnectTimeout")
    def health_check_connect_timeout(self) -> _builtins.int:
        """
        Amount of time in seconds to wait for the response for a health check.
        """
        return pulumi.get(self, "health_check_connect_timeout")

    @_builtins.property
    @pulumi.getter(name="healthCheckDomain")
    def health_check_domain(self) -> _builtins.str:
        """
        Domain name used for health check. The SLB sends HTTP head requests to the backend server, the domain is useful when the backend server verifies the host field in the requests. Only available when the protocol is `http`, `https` or `tcp` (in this case health_check_type must be `http`).
        """
        return pulumi.get(self, "health_check_domain")

    @_builtins.property
    @pulumi.getter(name="healthCheckHttpCode")
    def health_check_http_code(self) -> _builtins.str:
        """
        HTTP status codes indicating that the health check is normal. It can contain several comma-separated values such as "http_2xx,http_3xx". Only available when the protocol is `http`, `https` or `tcp` (in this case health_check_type must be `http`).
        """
        return pulumi.get(self, "health_check_http_code")

    @_builtins.property
    @pulumi.getter(name="healthCheckInterval")
    def health_check_interval(self) -> _builtins.int:
        """
        Time interval between two consecutive health checks.
        """
        return pulumi.get(self, "health_check_interval")

    @_builtins.property
    @pulumi.getter(name="healthCheckTimeout")
    def health_check_timeout(self) -> _builtins.int:
        """
        Amount of time in seconds to wait for the response from a health check. If an ECS instance sends no response within the specified timeout period, the health check fails. Only available when the protocol is `http` or `https`.
        """
        return pulumi.get(self, "health_check_timeout")

    @_builtins.property
    @pulumi.getter(name="healthCheckType")
    def health_check_type(self) -> _builtins.str:
        """
        Health check method. Possible values are `tcp` and `http`. Only available when the protocol is `tcp`.
        """
        return pulumi.get(self, "health_check_type")

    @_builtins.property
    @pulumi.getter(name="healthCheckUri")
    def health_check_uri(self) -> _builtins.str:
        """
        URI used for health check. Only available when the protocol is `http`, `https` or `tcp` (in this case health_check_type must be `http`).
        """
        return pulumi.get(self, "health_check_uri")

    @_builtins.property
    @pulumi.getter(name="healthyThreshold")
    def healthy_threshold(self) -> _builtins.int:
        """
        Number of consecutive successes of health check performed on the same ECS instance (from failure to success).
        """
        return pulumi.get(self, "healthy_threshold")

    @_builtins.property
    @pulumi.getter(name="idleTimeout")
    def idle_timeout(self) -> _builtins.int:
        """
        Timeout of http or https listener established connection idle timeout. Valid value range: [1-60] in seconds. Default to 15.
        """
        return pulumi.get(self, "idle_timeout")

    @_builtins.property
    @pulumi.getter(name="masterSlaveServerGroupId")
    def master_slave_server_group_id(self) -> _builtins.str:
        """
        ID of the active/standby server group.
        """
        return pulumi.get(self, "master_slave_server_group_id")

    @_builtins.property
    @pulumi.getter(name="persistenceTimeout")
    def persistence_timeout(self) -> _builtins.int:
        """
        Timeout value of the TCP connection in seconds. If the value is 0, the session persistence function is disabled. Only available when the protocol is `tcp`.
        """
        return pulumi.get(self, "persistence_timeout")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> _builtins.str:
        """
        Filter listeners by the specified protocol. Valid values: `http`, `https`, `tcp` and `udp`.
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter(name="proxyProtocolV2Enabled")
    def proxy_protocol_v2_enabled(self) -> _builtins.bool:
        """
        Whether to support carrying the client source address to the backend server through the Proxy Protocol. Valid values are `true` and `false`. Default to `false`.
        """
        return pulumi.get(self, "proxy_protocol_v2_enabled")

    @_builtins.property
    @pulumi.getter(name="requestTimeout")
    def request_timeout(self) -> _builtins.int:
        """
        Timeout of http or https listener request (which does not get response from backend) timeout. Valid value range: [1-180] in seconds. Default to 60.
        """
        return pulumi.get(self, "request_timeout")

    @_builtins.property
    @pulumi.getter
    def scheduler(self) -> _builtins.str:
        """
        Algorithm used to distribute traffic. Possible values: `wrr` (weighted round robin), `wlc` (weighted least connection) and `rr` (round robin).
        """
        return pulumi.get(self, "scheduler")

    @_builtins.property
    @pulumi.getter(name="securityStatus")
    def security_status(self) -> _builtins.str:
        """
        Security status. Only available when the protocol is `https`.
        """
        return pulumi.get(self, "security_status")

    @_builtins.property
    @pulumi.getter(name="serverCertificateId")
    def server_certificate_id(self) -> _builtins.str:
        return pulumi.get(self, "server_certificate_id")

    @_builtins.property
    @pulumi.getter(name="serverGroupId")
    def server_group_id(self) -> _builtins.str:
        """
        ID of the linked VServer group.
        """
        return pulumi.get(self, "server_group_id")

    @_builtins.property
    @pulumi.getter(name="sslCertificateId")
    def ssl_certificate_id(self) -> _builtins.str:
        """
        ID of the server certificate. Only available when the protocol is `https`.
        """
        return pulumi.get(self, "ssl_certificate_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Listener status.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="stickySession")
    def sticky_session(self) -> _builtins.str:
        """
        Indicate whether session persistence is enabled or not. If enabled, all session requests from the same client are sent to the same backend server. Possible values are `on` and `off`. Only available when the protocol is `http` or `https`.
        """
        return pulumi.get(self, "sticky_session")

    @_builtins.property
    @pulumi.getter(name="stickySessionType")
    def sticky_session_type(self) -> _builtins.str:
        """
        Method used to handle the cookie. Possible values are `insert` (cookie added to the response) and `server` (cookie set by the backend server). Only available when the protocol is `http` or `https` and sticky_session is `on`.
        """
        return pulumi.get(self, "sticky_session_type")

    @_builtins.property
    @pulumi.getter(name="tlsCipherPolicy")
    def tls_cipher_policy(self) -> _builtins.str:
        """
        Https listener TLS cipher policy. Valid values are `tls_cipher_policy_1_0`, `tls_cipher_policy_1_1`, `tls_cipher_policy_1_2`, `tls_cipher_policy_1_2_strict`. Default to `tls_cipher_policy_1_0`.
        """
        return pulumi.get(self, "tls_cipher_policy")

    @_builtins.property
    @pulumi.getter(name="unhealthyThreshold")
    def unhealthy_threshold(self) -> _builtins.int:
        """
        Number of consecutive failures of health check performed on the same ECS instance (from success to failure).
        """
        return pulumi.get(self, "unhealthy_threshold")

    @_builtins.property
    @pulumi.getter(name="xForwardedFor")
    def x_forwarded_for(self) -> _builtins.str:
        """
        Indicate whether the HTTP header field "X-Forwarded-For" is added or not; it allows the backend server to know about the user's IP address. Possible values are `on` and `off`. Only available when the protocol is `http` or `https`.
        """
        return pulumi.get(self, "x_forwarded_for")

    @_builtins.property
    @pulumi.getter(name="xForwardedForSlbId")
    def x_forwarded_for_slb_id(self) -> _builtins.str:
        """
        Indicate whether the HTTP header field "X-Forwarded-For_SLBID" is added or not; it allows the backend server to know about the SLB ID. Possible values are `on` and `off`. Only available when the protocol is `http` or `https`.
        """
        return pulumi.get(self, "x_forwarded_for_slb_id")

    @_builtins.property
    @pulumi.getter(name="xForwardedForSlbIp")
    def x_forwarded_for_slb_ip(self) -> _builtins.str:
        """
        Indicate whether the HTTP header field "X-Forwarded-For_SLBIP" is added or not; it allows the backend server to know about the SLB IP address. Possible values are `on` and `off`. Only available when the protocol is `http` or `https`.
        """
        return pulumi.get(self, "x_forwarded_for_slb_ip")

    @_builtins.property
    @pulumi.getter(name="xForwardedForSlbProto")
    def x_forwarded_for_slb_proto(self) -> _builtins.str:
        """
        Indicate whether the HTTP header field "X-Forwarded-For_proto" is added or not; it allows the backend server to know about the user's protocol. Possible values are `on` and `off`. Only available when the protocol is `http` or `https`.
        """
        return pulumi.get(self, "x_forwarded_for_slb_proto")


@pulumi.output_type
class GetLoadBalancersBalancerResult(dict):
    def __init__(__self__, *,
                 address: _builtins.str,
                 address_ip_version: _builtins.str,
                 address_type: _builtins.str,
                 auto_release_time: _builtins.int,
                 backend_servers: Sequence['outputs.GetLoadBalancersBalancerBackendServerResult'],
                 bandwidth: _builtins.int,
                 create_time_stamp: _builtins.int,
                 delete_protection: _builtins.str,
                 end_time: _builtins.str,
                 end_time_stamp: _builtins.int,
                 id: _builtins.str,
                 internet_charge_type: _builtins.str,
                 listener_ports_and_protocals: Sequence['outputs.GetLoadBalancersBalancerListenerPortsAndProtocalResult'],
                 listener_ports_and_protocols: Sequence['outputs.GetLoadBalancersBalancerListenerPortsAndProtocolResult'],
                 load_balancer_id: _builtins.str,
                 load_balancer_name: _builtins.str,
                 load_balancer_spec: _builtins.str,
                 master_zone_id: _builtins.str,
                 modification_protection_reason: _builtins.str,
                 modification_protection_status: _builtins.str,
                 network_type: _builtins.str,
                 payment_type: _builtins.str,
                 region_id_alias: _builtins.str,
                 renewal_cyc_unit: _builtins.str,
                 renewal_duration: _builtins.int,
                 renewal_status: _builtins.str,
                 resource_group_id: _builtins.str,
                 slave_zone_id: _builtins.str,
                 status: _builtins.str,
                 tags: Mapping[str, _builtins.str],
                 vpc_id: _builtins.str,
                 vswitch_id: _builtins.str):
        """
        :param _builtins.str address: Service address of the SLBs.
        :param _builtins.str id: ID of the SLB.
        :param _builtins.str network_type: Network type of the SLBs. Valid values: `vpc` and `classic`.
        :param _builtins.str resource_group_id: The Id of resource group which SLB belongs.
        :param _builtins.str status: SLB current status. Possible values: `inactive`, `active` and `locked`.
        :param Mapping[str, _builtins.str] tags: A map of tags assigned to the SLB instances. The `tags` can have a maximum of 5 tag. It must be in the format:
               ```python
               import pulumi
               import pulumi_alicloud as alicloud
               
               tagged_instances = alicloud.slb.get_load_balancers(tags={
                   "tagKey1": "tagValue1",
                   "tagKey2": "tagValue2",
               })
               ```
        :param _builtins.str vpc_id: ID of the VPC linked to the SLBs.
        :param _builtins.str vswitch_id: ID of the vSwitch linked to the SLBs.
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "address_ip_version", address_ip_version)
        pulumi.set(__self__, "address_type", address_type)
        pulumi.set(__self__, "auto_release_time", auto_release_time)
        pulumi.set(__self__, "backend_servers", backend_servers)
        pulumi.set(__self__, "bandwidth", bandwidth)
        pulumi.set(__self__, "create_time_stamp", create_time_stamp)
        pulumi.set(__self__, "delete_protection", delete_protection)
        pulumi.set(__self__, "end_time", end_time)
        pulumi.set(__self__, "end_time_stamp", end_time_stamp)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "internet_charge_type", internet_charge_type)
        pulumi.set(__self__, "listener_ports_and_protocals", listener_ports_and_protocals)
        pulumi.set(__self__, "listener_ports_and_protocols", listener_ports_and_protocols)
        pulumi.set(__self__, "load_balancer_id", load_balancer_id)
        pulumi.set(__self__, "load_balancer_name", load_balancer_name)
        pulumi.set(__self__, "load_balancer_spec", load_balancer_spec)
        pulumi.set(__self__, "master_zone_id", master_zone_id)
        pulumi.set(__self__, "modification_protection_reason", modification_protection_reason)
        pulumi.set(__self__, "modification_protection_status", modification_protection_status)
        pulumi.set(__self__, "network_type", network_type)
        pulumi.set(__self__, "payment_type", payment_type)
        pulumi.set(__self__, "region_id_alias", region_id_alias)
        pulumi.set(__self__, "renewal_cyc_unit", renewal_cyc_unit)
        pulumi.set(__self__, "renewal_duration", renewal_duration)
        pulumi.set(__self__, "renewal_status", renewal_status)
        pulumi.set(__self__, "resource_group_id", resource_group_id)
        pulumi.set(__self__, "slave_zone_id", slave_zone_id)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "vpc_id", vpc_id)
        pulumi.set(__self__, "vswitch_id", vswitch_id)

    @_builtins.property
    @pulumi.getter
    def address(self) -> _builtins.str:
        """
        Service address of the SLBs.
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter(name="addressIpVersion")
    def address_ip_version(self) -> _builtins.str:
        return pulumi.get(self, "address_ip_version")

    @_builtins.property
    @pulumi.getter(name="addressType")
    def address_type(self) -> _builtins.str:
        return pulumi.get(self, "address_type")

    @_builtins.property
    @pulumi.getter(name="autoReleaseTime")
    def auto_release_time(self) -> _builtins.int:
        return pulumi.get(self, "auto_release_time")

    @_builtins.property
    @pulumi.getter(name="backendServers")
    def backend_servers(self) -> Sequence['outputs.GetLoadBalancersBalancerBackendServerResult']:
        return pulumi.get(self, "backend_servers")

    @_builtins.property
    @pulumi.getter
    def bandwidth(self) -> _builtins.int:
        return pulumi.get(self, "bandwidth")

    @_builtins.property
    @pulumi.getter(name="createTimeStamp")
    def create_time_stamp(self) -> _builtins.int:
        return pulumi.get(self, "create_time_stamp")

    @_builtins.property
    @pulumi.getter(name="deleteProtection")
    def delete_protection(self) -> _builtins.str:
        return pulumi.get(self, "delete_protection")

    @_builtins.property
    @pulumi.getter(name="endTime")
    def end_time(self) -> _builtins.str:
        return pulumi.get(self, "end_time")

    @_builtins.property
    @pulumi.getter(name="endTimeStamp")
    def end_time_stamp(self) -> _builtins.int:
        return pulumi.get(self, "end_time_stamp")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        ID of the SLB.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="internetChargeType")
    def internet_charge_type(self) -> _builtins.str:
        return pulumi.get(self, "internet_charge_type")

    @_builtins.property
    @pulumi.getter(name="listenerPortsAndProtocals")
    def listener_ports_and_protocals(self) -> Sequence['outputs.GetLoadBalancersBalancerListenerPortsAndProtocalResult']:
        return pulumi.get(self, "listener_ports_and_protocals")

    @_builtins.property
    @pulumi.getter(name="listenerPortsAndProtocols")
    def listener_ports_and_protocols(self) -> Sequence['outputs.GetLoadBalancersBalancerListenerPortsAndProtocolResult']:
        return pulumi.get(self, "listener_ports_and_protocols")

    @_builtins.property
    @pulumi.getter(name="loadBalancerId")
    def load_balancer_id(self) -> _builtins.str:
        return pulumi.get(self, "load_balancer_id")

    @_builtins.property
    @pulumi.getter(name="loadBalancerName")
    def load_balancer_name(self) -> _builtins.str:
        return pulumi.get(self, "load_balancer_name")

    @_builtins.property
    @pulumi.getter(name="loadBalancerSpec")
    def load_balancer_spec(self) -> _builtins.str:
        return pulumi.get(self, "load_balancer_spec")

    @_builtins.property
    @pulumi.getter(name="masterZoneId")
    def master_zone_id(self) -> _builtins.str:
        return pulumi.get(self, "master_zone_id")

    @_builtins.property
    @pulumi.getter(name="modificationProtectionReason")
    def modification_protection_reason(self) -> _builtins.str:
        return pulumi.get(self, "modification_protection_reason")

    @_builtins.property
    @pulumi.getter(name="modificationProtectionStatus")
    def modification_protection_status(self) -> _builtins.str:
        return pulumi.get(self, "modification_protection_status")

    @_builtins.property
    @pulumi.getter(name="networkType")
    def network_type(self) -> _builtins.str:
        """
        Network type of the SLBs. Valid values: `vpc` and `classic`.
        """
        return pulumi.get(self, "network_type")

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> _builtins.str:
        return pulumi.get(self, "payment_type")

    @_builtins.property
    @pulumi.getter(name="regionIdAlias")
    def region_id_alias(self) -> _builtins.str:
        return pulumi.get(self, "region_id_alias")

    @_builtins.property
    @pulumi.getter(name="renewalCycUnit")
    def renewal_cyc_unit(self) -> _builtins.str:
        return pulumi.get(self, "renewal_cyc_unit")

    @_builtins.property
    @pulumi.getter(name="renewalDuration")
    def renewal_duration(self) -> _builtins.int:
        return pulumi.get(self, "renewal_duration")

    @_builtins.property
    @pulumi.getter(name="renewalStatus")
    def renewal_status(self) -> _builtins.str:
        return pulumi.get(self, "renewal_status")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> _builtins.str:
        """
        The Id of resource group which SLB belongs.
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter(name="slaveZoneId")
    def slave_zone_id(self) -> _builtins.str:
        return pulumi.get(self, "slave_zone_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        SLB current status. Possible values: `inactive`, `active` and `locked`.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        A map of tags assigned to the SLB instances. The `tags` can have a maximum of 5 tag. It must be in the format:
        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        tagged_instances = alicloud.slb.get_load_balancers(tags={
            "tagKey1": "tagValue1",
            "tagKey2": "tagValue2",
        })
        ```
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> _builtins.str:
        """
        ID of the VPC linked to the SLBs.
        """
        return pulumi.get(self, "vpc_id")

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> _builtins.str:
        """
        ID of the vSwitch linked to the SLBs.
        """
        return pulumi.get(self, "vswitch_id")


@pulumi.output_type
class GetLoadBalancersBalancerBackendServerResult(dict):
    def __init__(__self__, *,
                 description: _builtins.str,
                 server_id: _builtins.str,
                 type: _builtins.str,
                 weight: _builtins.int):
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "server_id", server_id)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "weight", weight)

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="serverId")
    def server_id(self) -> _builtins.str:
        return pulumi.get(self, "server_id")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def weight(self) -> _builtins.int:
        return pulumi.get(self, "weight")


@pulumi.output_type
class GetLoadBalancersBalancerListenerPortsAndProtocalResult(dict):
    def __init__(__self__, *,
                 listener_port: _builtins.int,
                 listener_protocal: _builtins.str):
        pulumi.set(__self__, "listener_port", listener_port)
        pulumi.set(__self__, "listener_protocal", listener_protocal)

    @_builtins.property
    @pulumi.getter(name="listenerPort")
    def listener_port(self) -> _builtins.int:
        return pulumi.get(self, "listener_port")

    @_builtins.property
    @pulumi.getter(name="listenerProtocal")
    def listener_protocal(self) -> _builtins.str:
        return pulumi.get(self, "listener_protocal")


@pulumi.output_type
class GetLoadBalancersBalancerListenerPortsAndProtocolResult(dict):
    def __init__(__self__, *,
                 description: _builtins.str,
                 forward_port: _builtins.int,
                 listener_forward: _builtins.str,
                 listener_port: _builtins.int,
                 listener_protocol: _builtins.str):
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "forward_port", forward_port)
        pulumi.set(__self__, "listener_forward", listener_forward)
        pulumi.set(__self__, "listener_port", listener_port)
        pulumi.set(__self__, "listener_protocol", listener_protocol)

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="forwardPort")
    def forward_port(self) -> _builtins.int:
        return pulumi.get(self, "forward_port")

    @_builtins.property
    @pulumi.getter(name="listenerForward")
    def listener_forward(self) -> _builtins.str:
        return pulumi.get(self, "listener_forward")

    @_builtins.property
    @pulumi.getter(name="listenerPort")
    def listener_port(self) -> _builtins.int:
        return pulumi.get(self, "listener_port")

    @_builtins.property
    @pulumi.getter(name="listenerProtocol")
    def listener_protocol(self) -> _builtins.str:
        return pulumi.get(self, "listener_protocol")


@pulumi.output_type
class GetLoadBalancersSlbResult(dict):
    def __init__(__self__, *,
                 address: _builtins.str,
                 creation_time: _builtins.str,
                 id: _builtins.str,
                 internet: _builtins.bool,
                 master_availability_zone: _builtins.str,
                 name: _builtins.str,
                 network_type: _builtins.str,
                 region_id: _builtins.str,
                 slave_availability_zone: _builtins.str,
                 status: _builtins.str,
                 tags: Mapping[str, _builtins.str],
                 vpc_id: _builtins.str,
                 vswitch_id: _builtins.str):
        """
        :param _builtins.str address: Service address of the SLBs.
        :param _builtins.str creation_time: SLB creation time.
        :param _builtins.str id: ID of the SLB.
        :param _builtins.bool internet: SLB addressType: internet if `true`, intranet if `false`. Must be `false` when `network_type` is `vpc`.
        :param _builtins.str master_availability_zone: Master availability zone of the SLBs.
        :param _builtins.str name: SLB name.
        :param _builtins.str network_type: Network type of the SLBs. Valid values: `vpc` and `classic`.
        :param _builtins.str region_id: Region ID the SLB belongs to.
        :param _builtins.str slave_availability_zone: Slave availability zone of the SLBs.
        :param _builtins.str status: SLB current status. Possible values: `inactive`, `active` and `locked`.
        :param Mapping[str, _builtins.str] tags: A map of tags assigned to the SLB instances. The `tags` can have a maximum of 5 tag. It must be in the format:
               ```python
               import pulumi
               import pulumi_alicloud as alicloud
               
               tagged_instances = alicloud.slb.get_load_balancers(tags={
                   "tagKey1": "tagValue1",
                   "tagKey2": "tagValue2",
               })
               ```
        :param _builtins.str vpc_id: ID of the VPC linked to the SLBs.
        :param _builtins.str vswitch_id: ID of the vSwitch linked to the SLBs.
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "creation_time", creation_time)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "internet", internet)
        pulumi.set(__self__, "master_availability_zone", master_availability_zone)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "network_type", network_type)
        pulumi.set(__self__, "region_id", region_id)
        pulumi.set(__self__, "slave_availability_zone", slave_availability_zone)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "vpc_id", vpc_id)
        pulumi.set(__self__, "vswitch_id", vswitch_id)

    @_builtins.property
    @pulumi.getter
    def address(self) -> _builtins.str:
        """
        Service address of the SLBs.
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> _builtins.str:
        """
        SLB creation time.
        """
        return pulumi.get(self, "creation_time")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        ID of the SLB.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def internet(self) -> _builtins.bool:
        """
        SLB addressType: internet if `true`, intranet if `false`. Must be `false` when `network_type` is `vpc`.
        """
        return pulumi.get(self, "internet")

    @_builtins.property
    @pulumi.getter(name="masterAvailabilityZone")
    def master_availability_zone(self) -> _builtins.str:
        """
        Master availability zone of the SLBs.
        """
        return pulumi.get(self, "master_availability_zone")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        SLB name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="networkType")
    def network_type(self) -> _builtins.str:
        """
        Network type of the SLBs. Valid values: `vpc` and `classic`.
        """
        return pulumi.get(self, "network_type")

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> _builtins.str:
        """
        Region ID the SLB belongs to.
        """
        return pulumi.get(self, "region_id")

    @_builtins.property
    @pulumi.getter(name="slaveAvailabilityZone")
    def slave_availability_zone(self) -> _builtins.str:
        """
        Slave availability zone of the SLBs.
        """
        return pulumi.get(self, "slave_availability_zone")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        SLB current status. Possible values: `inactive`, `active` and `locked`.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        A map of tags assigned to the SLB instances. The `tags` can have a maximum of 5 tag. It must be in the format:
        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        tagged_instances = alicloud.slb.get_load_balancers(tags={
            "tagKey1": "tagValue1",
            "tagKey2": "tagValue2",
        })
        ```
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> _builtins.str:
        """
        ID of the VPC linked to the SLBs.
        """
        return pulumi.get(self, "vpc_id")

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> _builtins.str:
        """
        ID of the vSwitch linked to the SLBs.
        """
        return pulumi.get(self, "vswitch_id")


@pulumi.output_type
class GetMasterSlaveServerGroupsGroupResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 name: _builtins.str,
                 servers: Sequence['outputs.GetMasterSlaveServerGroupsGroupServerResult']):
        """
        :param _builtins.str id: master slave server group ID.
        :param _builtins.str name: master slave server group name.
        :param Sequence['GetMasterSlaveServerGroupsGroupServerArgs'] servers: ECS instances associated to the group. Each element contains the following attributes:
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "servers", servers)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        master slave server group ID.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        master slave server group name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def servers(self) -> Sequence['outputs.GetMasterSlaveServerGroupsGroupServerResult']:
        """
        ECS instances associated to the group. Each element contains the following attributes:
        """
        return pulumi.get(self, "servers")


@pulumi.output_type
class GetMasterSlaveServerGroupsGroupServerResult(dict):
    def __init__(__self__, *,
                 instance_id: _builtins.str,
                 is_backup: _builtins.int,
                 port: _builtins.int,
                 server_type: _builtins.str,
                 weight: _builtins.int):
        """
        :param _builtins.str instance_id: ID of the attached ECS instance.
        :param _builtins.int is_backup: (Removed from v1.63.0) Determine if the server is executing.
        :param _builtins.int port: The port used by the master slave server group.
        :param _builtins.str server_type: The server type of the attached ECS instance.
        :param _builtins.int weight: Weight associated to the ECS instance.
        """
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "is_backup", is_backup)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "server_type", server_type)
        pulumi.set(__self__, "weight", weight)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> _builtins.str:
        """
        ID of the attached ECS instance.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter(name="isBackup")
    def is_backup(self) -> _builtins.int:
        """
        (Removed from v1.63.0) Determine if the server is executing.
        """
        return pulumi.get(self, "is_backup")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        The port used by the master slave server group.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="serverType")
    def server_type(self) -> _builtins.str:
        """
        The server type of the attached ECS instance.
        """
        return pulumi.get(self, "server_type")

    @_builtins.property
    @pulumi.getter
    def weight(self) -> _builtins.int:
        """
        Weight associated to the ECS instance.
        """
        return pulumi.get(self, "weight")


@pulumi.output_type
class GetRulesSlbRuleResult(dict):
    def __init__(__self__, *,
                 domain: _builtins.str,
                 id: _builtins.str,
                 name: _builtins.str,
                 server_group_id: _builtins.str,
                 url: _builtins.str):
        """
        :param _builtins.str domain: Domain name in the HTTP request where the rule applies (e.g. "*.aliyun.com").
        :param _builtins.str id: Rule ID.
        :param _builtins.str name: Rule name.
        :param _builtins.str server_group_id: ID of the linked VServer group.
        :param _builtins.str url: Path in the HTTP request where the rule applies (e.g. "/image").
        """
        pulumi.set(__self__, "domain", domain)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "server_group_id", server_group_id)
        pulumi.set(__self__, "url", url)

    @_builtins.property
    @pulumi.getter
    def domain(self) -> _builtins.str:
        """
        Domain name in the HTTP request where the rule applies (e.g. "*.aliyun.com").
        """
        return pulumi.get(self, "domain")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        Rule ID.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Rule name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="serverGroupId")
    def server_group_id(self) -> _builtins.str:
        """
        ID of the linked VServer group.
        """
        return pulumi.get(self, "server_group_id")

    @_builtins.property
    @pulumi.getter
    def url(self) -> _builtins.str:
        """
        Path in the HTTP request where the rule applies (e.g. "/image").
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class GetServerCertificatesCertificateResult(dict):
    def __init__(__self__, *,
                 alicloud_certificate_id: _builtins.str,
                 alicloud_certificate_name: _builtins.str,
                 common_name: _builtins.str,
                 created_time: _builtins.str,
                 created_timestamp: _builtins.int,
                 expired_time: _builtins.str,
                 expired_timestamp: _builtins.int,
                 fingerprint: _builtins.str,
                 id: _builtins.str,
                 is_alicloud_certificate: _builtins.bool,
                 name: _builtins.str,
                 subject_alternative_names: Sequence[_builtins.str],
                 resource_group_id: Optional[_builtins.str] = None,
                 tags: Optional[Mapping[str, _builtins.str]] = None):
        """
        :param _builtins.str alicloud_certificate_id: Id of server certificate issued by alibaba cloud.
        :param _builtins.str alicloud_certificate_name: Name of server certificate issued by alibaba cloud.
        :param _builtins.str common_name: Server certificate common name.
        :param _builtins.str created_time: Server certificate created time.
        :param _builtins.int created_timestamp: Server certificate created timestamp.
        :param _builtins.str expired_time: Server certificate expired time.
        :param _builtins.int expired_timestamp: Server certificate expired timestamp.
        :param _builtins.str fingerprint: Server certificate fingerprint.
        :param _builtins.str id: Server certificate ID.
        :param _builtins.bool is_alicloud_certificate: Is server certificate issued by alibaba cloud or not.
        :param _builtins.str name: Server certificate name.
        :param Sequence[_builtins.str] subject_alternative_names: Server certificate subject alternative name list.
        :param _builtins.str resource_group_id: The Id of resource group which the slb server certificates belongs.
        :param Mapping[str, _builtins.str] tags: A mapping of tags to assign to the resource.
        """
        pulumi.set(__self__, "alicloud_certificate_id", alicloud_certificate_id)
        pulumi.set(__self__, "alicloud_certificate_name", alicloud_certificate_name)
        pulumi.set(__self__, "common_name", common_name)
        pulumi.set(__self__, "created_time", created_time)
        pulumi.set(__self__, "created_timestamp", created_timestamp)
        pulumi.set(__self__, "expired_time", expired_time)
        pulumi.set(__self__, "expired_timestamp", expired_timestamp)
        pulumi.set(__self__, "fingerprint", fingerprint)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_alicloud_certificate", is_alicloud_certificate)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "subject_alternative_names", subject_alternative_names)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="alicloudCertificateId")
    def alicloud_certificate_id(self) -> _builtins.str:
        """
        Id of server certificate issued by alibaba cloud.
        """
        return pulumi.get(self, "alicloud_certificate_id")

    @_builtins.property
    @pulumi.getter(name="alicloudCertificateName")
    def alicloud_certificate_name(self) -> _builtins.str:
        """
        Name of server certificate issued by alibaba cloud.
        """
        return pulumi.get(self, "alicloud_certificate_name")

    @_builtins.property
    @pulumi.getter(name="commonName")
    def common_name(self) -> _builtins.str:
        """
        Server certificate common name.
        """
        return pulumi.get(self, "common_name")

    @_builtins.property
    @pulumi.getter(name="createdTime")
    def created_time(self) -> _builtins.str:
        """
        Server certificate created time.
        """
        return pulumi.get(self, "created_time")

    @_builtins.property
    @pulumi.getter(name="createdTimestamp")
    def created_timestamp(self) -> _builtins.int:
        """
        Server certificate created timestamp.
        """
        return pulumi.get(self, "created_timestamp")

    @_builtins.property
    @pulumi.getter(name="expiredTime")
    def expired_time(self) -> _builtins.str:
        """
        Server certificate expired time.
        """
        return pulumi.get(self, "expired_time")

    @_builtins.property
    @pulumi.getter(name="expiredTimestamp")
    def expired_timestamp(self) -> _builtins.int:
        """
        Server certificate expired timestamp.
        """
        return pulumi.get(self, "expired_timestamp")

    @_builtins.property
    @pulumi.getter
    def fingerprint(self) -> _builtins.str:
        """
        Server certificate fingerprint.
        """
        return pulumi.get(self, "fingerprint")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        Server certificate ID.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isAlicloudCertificate")
    def is_alicloud_certificate(self) -> _builtins.bool:
        """
        Is server certificate issued by alibaba cloud or not.
        """
        return pulumi.get(self, "is_alicloud_certificate")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Server certificate name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="subjectAlternativeNames")
    def subject_alternative_names(self) -> Sequence[_builtins.str]:
        """
        Server certificate subject alternative name list.
        """
        return pulumi.get(self, "subject_alternative_names")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[_builtins.str]:
        """
        The Id of resource group which the slb server certificates belongs.
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class GetServerGroupsSlbServerGroupResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 name: _builtins.str,
                 servers: Sequence['outputs.GetServerGroupsSlbServerGroupServerResult']):
        """
        :param _builtins.str id: VServer group ID.
        :param _builtins.str name: VServer group name.
        :param Sequence['GetServerGroupsSlbServerGroupServerArgs'] servers: ECS instances associated to the group. Each element contains the following attributes:
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "servers", servers)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        VServer group ID.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        VServer group name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def servers(self) -> Sequence['outputs.GetServerGroupsSlbServerGroupServerResult']:
        """
        ECS instances associated to the group. Each element contains the following attributes:
        """
        return pulumi.get(self, "servers")


@pulumi.output_type
class GetServerGroupsSlbServerGroupServerResult(dict):
    def __init__(__self__, *,
                 instance_id: _builtins.str,
                 weight: _builtins.int):
        """
        :param _builtins.str instance_id: ID of the attached ECS instance.
        :param _builtins.int weight: Weight associated to the ECS instance.
        """
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "weight", weight)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> _builtins.str:
        """
        ID of the attached ECS instance.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter
    def weight(self) -> _builtins.int:
        """
        Weight associated to the ECS instance.
        """
        return pulumi.get(self, "weight")


@pulumi.output_type
class GetTlsCipherPoliciesPolicyResult(dict):
    def __init__(__self__, *,
                 ciphers: Sequence[_builtins.str],
                 create_time: _builtins.str,
                 id: _builtins.str,
                 relate_listeners: Sequence['outputs.GetTlsCipherPoliciesPolicyRelateListenerResult'],
                 status: _builtins.str,
                 tls_cipher_policy_id: _builtins.str,
                 tls_cipher_policy_name: _builtins.str,
                 tls_versions: Sequence[_builtins.str]):
        """
        :param Sequence[_builtins.str] ciphers: The encryption algorithms supported. It depends on the value of `tls_versions`.
        :param _builtins.str create_time: The creation time timestamp.
        :param _builtins.str id: The ID of the Tls Cipher Policy.
        :param Sequence['GetTlsCipherPoliciesPolicyRelateListenerArgs'] relate_listeners: Array of Relate Listeners.
        :param _builtins.str status: TLS policy instance state.
        :param _builtins.str tls_cipher_policy_id: The ID of TLS cipher policy.
        :param _builtins.str tls_cipher_policy_name: TLS policy name. Length is from 2 to 128, or in both the English and Chinese characters must be with an uppercase/lowercase letter or a Chinese character and the beginning, may contain numbers, in dot `.`, underscore `_` or dash `-`.
        :param Sequence[_builtins.str] tls_versions: The version of TLS protocol.
        """
        pulumi.set(__self__, "ciphers", ciphers)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "relate_listeners", relate_listeners)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "tls_cipher_policy_id", tls_cipher_policy_id)
        pulumi.set(__self__, "tls_cipher_policy_name", tls_cipher_policy_name)
        pulumi.set(__self__, "tls_versions", tls_versions)

    @_builtins.property
    @pulumi.getter
    def ciphers(self) -> Sequence[_builtins.str]:
        """
        The encryption algorithms supported. It depends on the value of `tls_versions`.
        """
        return pulumi.get(self, "ciphers")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        """
        The creation time timestamp.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Tls Cipher Policy.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="relateListeners")
    def relate_listeners(self) -> Sequence['outputs.GetTlsCipherPoliciesPolicyRelateListenerResult']:
        """
        Array of Relate Listeners.
        """
        return pulumi.get(self, "relate_listeners")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        TLS policy instance state.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="tlsCipherPolicyId")
    def tls_cipher_policy_id(self) -> _builtins.str:
        """
        The ID of TLS cipher policy.
        """
        return pulumi.get(self, "tls_cipher_policy_id")

    @_builtins.property
    @pulumi.getter(name="tlsCipherPolicyName")
    def tls_cipher_policy_name(self) -> _builtins.str:
        """
        TLS policy name. Length is from 2 to 128, or in both the English and Chinese characters must be with an uppercase/lowercase letter or a Chinese character and the beginning, may contain numbers, in dot `.`, underscore `_` or dash `-`.
        """
        return pulumi.get(self, "tls_cipher_policy_name")

    @_builtins.property
    @pulumi.getter(name="tlsVersions")
    def tls_versions(self) -> Sequence[_builtins.str]:
        """
        The version of TLS protocol.
        """
        return pulumi.get(self, "tls_versions")


@pulumi.output_type
class GetTlsCipherPoliciesPolicyRelateListenerResult(dict):
    def __init__(__self__, *,
                 load_balancer_id: _builtins.str,
                 port: _builtins.int,
                 protocol: _builtins.str):
        """
        :param _builtins.str load_balancer_id: The ID of SLB instance.
        :param _builtins.int port: Listening port. Valid value: 1 to 65535.
        :param _builtins.str protocol: Snooping protocols. Valid values: `TCP`, `UDP`, `HTTP`, or `HTTPS`.
        """
        pulumi.set(__self__, "load_balancer_id", load_balancer_id)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "protocol", protocol)

    @_builtins.property
    @pulumi.getter(name="loadBalancerId")
    def load_balancer_id(self) -> _builtins.str:
        """
        The ID of SLB instance.
        """
        return pulumi.get(self, "load_balancer_id")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        Listening port. Valid value: 1 to 65535.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> _builtins.str:
        """
        Snooping protocols. Valid values: `TCP`, `UDP`, `HTTP`, or `HTTPS`.
        """
        return pulumi.get(self, "protocol")


@pulumi.output_type
class GetZonesZoneResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 master_zone_id: _builtins.str,
                 slave_zone_id: _builtins.str,
                 slb_slave_zone_ids: Sequence[_builtins.str],
                 supported_resources: Sequence['outputs.GetZonesZoneSupportedResourceResult']):
        """
        :param _builtins.str id: ID of the zone. It is same as `master_zone_id`.
        :param _builtins.str master_zone_id: The primary zone.
        :param _builtins.str slave_zone_id: The secondary zone.
        :param Sequence[_builtins.str] slb_slave_zone_ids: (Deprecated from 1.157.0) A list of slb slave zone ids in which the slb master zone. 
               It has been deprecated from v1.157.0 and use `slave_zone_id` instead.
        :param Sequence['GetZonesZoneSupportedResourceArgs'] supported_resources: (Available in 1.154.0+)A list of available resource which the slb master zone supported.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "master_zone_id", master_zone_id)
        pulumi.set(__self__, "slave_zone_id", slave_zone_id)
        pulumi.set(__self__, "slb_slave_zone_ids", slb_slave_zone_ids)
        pulumi.set(__self__, "supported_resources", supported_resources)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        ID of the zone. It is same as `master_zone_id`.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="masterZoneId")
    def master_zone_id(self) -> _builtins.str:
        """
        The primary zone.
        """
        return pulumi.get(self, "master_zone_id")

    @_builtins.property
    @pulumi.getter(name="slaveZoneId")
    def slave_zone_id(self) -> _builtins.str:
        """
        The secondary zone.
        """
        return pulumi.get(self, "slave_zone_id")

    @_builtins.property
    @pulumi.getter(name="slbSlaveZoneIds")
    @_utilities.deprecated("""the attribute slb_slave_zone_ids has been deprecated from version 1.157.0 and use slave_zone_id instead.""")
    def slb_slave_zone_ids(self) -> Sequence[_builtins.str]:
        """
        (Deprecated from 1.157.0) A list of slb slave zone ids in which the slb master zone. 
        It has been deprecated from v1.157.0 and use `slave_zone_id` instead.
        """
        return pulumi.get(self, "slb_slave_zone_ids")

    @_builtins.property
    @pulumi.getter(name="supportedResources")
    def supported_resources(self) -> Sequence['outputs.GetZonesZoneSupportedResourceResult']:
        """
        (Available in 1.154.0+)A list of available resource which the slb master zone supported.
        """
        return pulumi.get(self, "supported_resources")


@pulumi.output_type
class GetZonesZoneSupportedResourceResult(dict):
    def __init__(__self__, *,
                 address_ip_version: _builtins.str,
                 address_type: _builtins.str):
        """
        :param _builtins.str address_ip_version: The type of IP address.
        :param _builtins.str address_type: The type of network.
        """
        pulumi.set(__self__, "address_ip_version", address_ip_version)
        pulumi.set(__self__, "address_type", address_type)

    @_builtins.property
    @pulumi.getter(name="addressIpVersion")
    def address_ip_version(self) -> _builtins.str:
        """
        The type of IP address.
        """
        return pulumi.get(self, "address_ip_version")

    @_builtins.property
    @pulumi.getter(name="addressType")
    def address_type(self) -> _builtins.str:
        """
        The type of network.
        """
        return pulumi.get(self, "address_type")


