# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ClientFileProtectArgs', 'ClientFileProtect']

@pulumi.input_type
class ClientFileProtectArgs:
    def __init__(__self__, *,
                 file_ops: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 file_paths: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 proc_paths: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 rule_action: pulumi.Input[_builtins.str],
                 rule_name: pulumi.Input[_builtins.str],
                 alert_level: Optional[pulumi.Input[_builtins.int]] = None,
                 status: Optional[pulumi.Input[_builtins.int]] = None,
                 switch_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ClientFileProtect resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] file_ops: file operation.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] file_paths: file path.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] proc_paths: process path.
        :param pulumi.Input[_builtins.str] rule_action: rule action, pass or alert.
        :param pulumi.Input[_builtins.str] rule_name: ruleName.
        :param pulumi.Input[_builtins.int] alert_level: 0 no alert 1 info 2 suspicious 3 critical.
        :param pulumi.Input[_builtins.int] status: rule status 0 is disable 1 is enable.
        :param pulumi.Input[_builtins.str] switch_id: switch id.
        """
        pulumi.set(__self__, "file_ops", file_ops)
        pulumi.set(__self__, "file_paths", file_paths)
        pulumi.set(__self__, "proc_paths", proc_paths)
        pulumi.set(__self__, "rule_action", rule_action)
        pulumi.set(__self__, "rule_name", rule_name)
        if alert_level is not None:
            pulumi.set(__self__, "alert_level", alert_level)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if switch_id is not None:
            pulumi.set(__self__, "switch_id", switch_id)

    @_builtins.property
    @pulumi.getter(name="fileOps")
    def file_ops(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        file operation.
        """
        return pulumi.get(self, "file_ops")

    @file_ops.setter
    def file_ops(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "file_ops", value)

    @_builtins.property
    @pulumi.getter(name="filePaths")
    def file_paths(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        file path.
        """
        return pulumi.get(self, "file_paths")

    @file_paths.setter
    def file_paths(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "file_paths", value)

    @_builtins.property
    @pulumi.getter(name="procPaths")
    def proc_paths(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        process path.
        """
        return pulumi.get(self, "proc_paths")

    @proc_paths.setter
    def proc_paths(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "proc_paths", value)

    @_builtins.property
    @pulumi.getter(name="ruleAction")
    def rule_action(self) -> pulumi.Input[_builtins.str]:
        """
        rule action, pass or alert.
        """
        return pulumi.get(self, "rule_action")

    @rule_action.setter
    def rule_action(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "rule_action", value)

    @_builtins.property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> pulumi.Input[_builtins.str]:
        """
        ruleName.
        """
        return pulumi.get(self, "rule_name")

    @rule_name.setter
    def rule_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "rule_name", value)

    @_builtins.property
    @pulumi.getter(name="alertLevel")
    def alert_level(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        0 no alert 1 info 2 suspicious 3 critical.
        """
        return pulumi.get(self, "alert_level")

    @alert_level.setter
    def alert_level(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "alert_level", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        rule status 0 is disable 1 is enable.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="switchId")
    def switch_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        switch id.
        """
        return pulumi.get(self, "switch_id")

    @switch_id.setter
    def switch_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "switch_id", value)


@pulumi.input_type
class _ClientFileProtectState:
    def __init__(__self__, *,
                 alert_level: Optional[pulumi.Input[_builtins.int]] = None,
                 file_ops: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 file_paths: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 proc_paths: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 rule_action: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_name: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.int]] = None,
                 switch_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ClientFileProtect resources.
        :param pulumi.Input[_builtins.int] alert_level: 0 no alert 1 info 2 suspicious 3 critical.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] file_ops: file operation.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] file_paths: file path.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] proc_paths: process path.
        :param pulumi.Input[_builtins.str] rule_action: rule action, pass or alert.
        :param pulumi.Input[_builtins.str] rule_name: ruleName.
        :param pulumi.Input[_builtins.int] status: rule status 0 is disable 1 is enable.
        :param pulumi.Input[_builtins.str] switch_id: switch id.
        """
        if alert_level is not None:
            pulumi.set(__self__, "alert_level", alert_level)
        if file_ops is not None:
            pulumi.set(__self__, "file_ops", file_ops)
        if file_paths is not None:
            pulumi.set(__self__, "file_paths", file_paths)
        if proc_paths is not None:
            pulumi.set(__self__, "proc_paths", proc_paths)
        if rule_action is not None:
            pulumi.set(__self__, "rule_action", rule_action)
        if rule_name is not None:
            pulumi.set(__self__, "rule_name", rule_name)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if switch_id is not None:
            pulumi.set(__self__, "switch_id", switch_id)

    @_builtins.property
    @pulumi.getter(name="alertLevel")
    def alert_level(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        0 no alert 1 info 2 suspicious 3 critical.
        """
        return pulumi.get(self, "alert_level")

    @alert_level.setter
    def alert_level(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "alert_level", value)

    @_builtins.property
    @pulumi.getter(name="fileOps")
    def file_ops(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        file operation.
        """
        return pulumi.get(self, "file_ops")

    @file_ops.setter
    def file_ops(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "file_ops", value)

    @_builtins.property
    @pulumi.getter(name="filePaths")
    def file_paths(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        file path.
        """
        return pulumi.get(self, "file_paths")

    @file_paths.setter
    def file_paths(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "file_paths", value)

    @_builtins.property
    @pulumi.getter(name="procPaths")
    def proc_paths(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        process path.
        """
        return pulumi.get(self, "proc_paths")

    @proc_paths.setter
    def proc_paths(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "proc_paths", value)

    @_builtins.property
    @pulumi.getter(name="ruleAction")
    def rule_action(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        rule action, pass or alert.
        """
        return pulumi.get(self, "rule_action")

    @rule_action.setter
    def rule_action(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rule_action", value)

    @_builtins.property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ruleName.
        """
        return pulumi.get(self, "rule_name")

    @rule_name.setter
    def rule_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rule_name", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        rule status 0 is disable 1 is enable.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="switchId")
    def switch_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        switch id.
        """
        return pulumi.get(self, "switch_id")

    @switch_id.setter
    def switch_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "switch_id", value)


@pulumi.type_token("alicloud:threatdetection/clientFileProtect:ClientFileProtect")
class ClientFileProtect(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alert_level: Optional[pulumi.Input[_builtins.int]] = None,
                 file_ops: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 file_paths: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 proc_paths: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 rule_action: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_name: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.int]] = None,
                 switch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Threat Detection Client File Protect resource. Client core file protection event monitoring, including file reading and writing, deletion, and permission change.

        For information about Threat Detection Client File Protect and how to use it, see [What is Client File Protect](https://www.alibabacloud.com/help/zh/security-center/developer-reference/api-sas-2018-12-03-createfileprotectrule).

        > **NOTE:** Available since v1.212.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.threatdetection.ClientFileProtect("default",
            status=0,
            file_paths=["/usr/local"],
            file_ops=["CREATE"],
            rule_action="pass",
            proc_paths=["/usr/local"],
            alert_level=0,
            switch_id="FILE_PROTECT_RULE_SWITCH_TYPE_1693474122929",
            rule_name="rule_example")
        ```

        ## Import

        Threat Detection Client File Protect can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:threatdetection/clientFileProtect:ClientFileProtect example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] alert_level: 0 no alert 1 info 2 suspicious 3 critical.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] file_ops: file operation.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] file_paths: file path.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] proc_paths: process path.
        :param pulumi.Input[_builtins.str] rule_action: rule action, pass or alert.
        :param pulumi.Input[_builtins.str] rule_name: ruleName.
        :param pulumi.Input[_builtins.int] status: rule status 0 is disable 1 is enable.
        :param pulumi.Input[_builtins.str] switch_id: switch id.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ClientFileProtectArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Threat Detection Client File Protect resource. Client core file protection event monitoring, including file reading and writing, deletion, and permission change.

        For information about Threat Detection Client File Protect and how to use it, see [What is Client File Protect](https://www.alibabacloud.com/help/zh/security-center/developer-reference/api-sas-2018-12-03-createfileprotectrule).

        > **NOTE:** Available since v1.212.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.threatdetection.ClientFileProtect("default",
            status=0,
            file_paths=["/usr/local"],
            file_ops=["CREATE"],
            rule_action="pass",
            proc_paths=["/usr/local"],
            alert_level=0,
            switch_id="FILE_PROTECT_RULE_SWITCH_TYPE_1693474122929",
            rule_name="rule_example")
        ```

        ## Import

        Threat Detection Client File Protect can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:threatdetection/clientFileProtect:ClientFileProtect example <id>
        ```

        :param str resource_name: The name of the resource.
        :param ClientFileProtectArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ClientFileProtectArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alert_level: Optional[pulumi.Input[_builtins.int]] = None,
                 file_ops: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 file_paths: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 proc_paths: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 rule_action: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_name: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.int]] = None,
                 switch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ClientFileProtectArgs.__new__(ClientFileProtectArgs)

            __props__.__dict__["alert_level"] = alert_level
            if file_ops is None and not opts.urn:
                raise TypeError("Missing required property 'file_ops'")
            __props__.__dict__["file_ops"] = file_ops
            if file_paths is None and not opts.urn:
                raise TypeError("Missing required property 'file_paths'")
            __props__.__dict__["file_paths"] = file_paths
            if proc_paths is None and not opts.urn:
                raise TypeError("Missing required property 'proc_paths'")
            __props__.__dict__["proc_paths"] = proc_paths
            if rule_action is None and not opts.urn:
                raise TypeError("Missing required property 'rule_action'")
            __props__.__dict__["rule_action"] = rule_action
            if rule_name is None and not opts.urn:
                raise TypeError("Missing required property 'rule_name'")
            __props__.__dict__["rule_name"] = rule_name
            __props__.__dict__["status"] = status
            __props__.__dict__["switch_id"] = switch_id
        super(ClientFileProtect, __self__).__init__(
            'alicloud:threatdetection/clientFileProtect:ClientFileProtect',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            alert_level: Optional[pulumi.Input[_builtins.int]] = None,
            file_ops: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            file_paths: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            proc_paths: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            rule_action: Optional[pulumi.Input[_builtins.str]] = None,
            rule_name: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.int]] = None,
            switch_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'ClientFileProtect':
        """
        Get an existing ClientFileProtect resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] alert_level: 0 no alert 1 info 2 suspicious 3 critical.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] file_ops: file operation.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] file_paths: file path.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] proc_paths: process path.
        :param pulumi.Input[_builtins.str] rule_action: rule action, pass or alert.
        :param pulumi.Input[_builtins.str] rule_name: ruleName.
        :param pulumi.Input[_builtins.int] status: rule status 0 is disable 1 is enable.
        :param pulumi.Input[_builtins.str] switch_id: switch id.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ClientFileProtectState.__new__(_ClientFileProtectState)

        __props__.__dict__["alert_level"] = alert_level
        __props__.__dict__["file_ops"] = file_ops
        __props__.__dict__["file_paths"] = file_paths
        __props__.__dict__["proc_paths"] = proc_paths
        __props__.__dict__["rule_action"] = rule_action
        __props__.__dict__["rule_name"] = rule_name
        __props__.__dict__["status"] = status
        __props__.__dict__["switch_id"] = switch_id
        return ClientFileProtect(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="alertLevel")
    def alert_level(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        0 no alert 1 info 2 suspicious 3 critical.
        """
        return pulumi.get(self, "alert_level")

    @_builtins.property
    @pulumi.getter(name="fileOps")
    def file_ops(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        file operation.
        """
        return pulumi.get(self, "file_ops")

    @_builtins.property
    @pulumi.getter(name="filePaths")
    def file_paths(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        file path.
        """
        return pulumi.get(self, "file_paths")

    @_builtins.property
    @pulumi.getter(name="procPaths")
    def proc_paths(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        process path.
        """
        return pulumi.get(self, "proc_paths")

    @_builtins.property
    @pulumi.getter(name="ruleAction")
    def rule_action(self) -> pulumi.Output[_builtins.str]:
        """
        rule action, pass or alert.
        """
        return pulumi.get(self, "rule_action")

    @_builtins.property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> pulumi.Output[_builtins.str]:
        """
        ruleName.
        """
        return pulumi.get(self, "rule_name")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.int]:
        """
        rule status 0 is disable 1 is enable.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="switchId")
    def switch_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        switch id.
        """
        return pulumi.get(self, "switch_id")

