# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['GatewayRouteTableAttachmentArgs', 'GatewayRouteTableAttachment']

@pulumi.input_type
class GatewayRouteTableAttachmentArgs:
    def __init__(__self__, *,
                 ipv4_gateway_id: pulumi.Input[_builtins.str],
                 route_table_id: pulumi.Input[_builtins.str],
                 dry_run: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a GatewayRouteTableAttachment resource.
        :param pulumi.Input[_builtins.str] ipv4_gateway_id: The ID of the IPv4 Gateway instance.
        :param pulumi.Input[_builtins.str] route_table_id: The ID of the Gateway route table to be bound.
        :param pulumi.Input[_builtins.bool] dry_run: Specifies whether to only precheck this request. Default value: `false`.
        """
        pulumi.set(__self__, "ipv4_gateway_id", ipv4_gateway_id)
        pulumi.set(__self__, "route_table_id", route_table_id)
        if dry_run is not None:
            pulumi.set(__self__, "dry_run", dry_run)

    @_builtins.property
    @pulumi.getter(name="ipv4GatewayId")
    def ipv4_gateway_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the IPv4 Gateway instance.
        """
        return pulumi.get(self, "ipv4_gateway_id")

    @ipv4_gateway_id.setter
    def ipv4_gateway_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "ipv4_gateway_id", value)

    @_builtins.property
    @pulumi.getter(name="routeTableId")
    def route_table_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Gateway route table to be bound.
        """
        return pulumi.get(self, "route_table_id")

    @route_table_id.setter
    def route_table_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "route_table_id", value)

    @_builtins.property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to only precheck this request. Default value: `false`.
        """
        return pulumi.get(self, "dry_run")

    @dry_run.setter
    def dry_run(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "dry_run", value)


@pulumi.input_type
class _GatewayRouteTableAttachmentState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
                 ipv4_gateway_id: Optional[pulumi.Input[_builtins.str]] = None,
                 route_table_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering GatewayRouteTableAttachment resources.
        :param pulumi.Input[_builtins.str] create_time: The creation time of the resource.
        :param pulumi.Input[_builtins.bool] dry_run: Specifies whether to only precheck this request. Default value: `false`.
        :param pulumi.Input[_builtins.str] ipv4_gateway_id: The ID of the IPv4 Gateway instance.
        :param pulumi.Input[_builtins.str] route_table_id: The ID of the Gateway route table to be bound.
        :param pulumi.Input[_builtins.str] status: The status of the IPv4 Gateway instance. Value:
               - **Creating**: The function is being created.
               - **Created**: Created and available.
               - **Modifying**: is being modified.
               - **Deleting**: Deleting.
               - **Deleted**: Deleted.
               - **Activating**: enabled.
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if dry_run is not None:
            pulumi.set(__self__, "dry_run", dry_run)
        if ipv4_gateway_id is not None:
            pulumi.set(__self__, "ipv4_gateway_id", ipv4_gateway_id)
        if route_table_id is not None:
            pulumi.set(__self__, "route_table_id", route_table_id)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation time of the resource.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to only precheck this request. Default value: `false`.
        """
        return pulumi.get(self, "dry_run")

    @dry_run.setter
    def dry_run(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "dry_run", value)

    @_builtins.property
    @pulumi.getter(name="ipv4GatewayId")
    def ipv4_gateway_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the IPv4 Gateway instance.
        """
        return pulumi.get(self, "ipv4_gateway_id")

    @ipv4_gateway_id.setter
    def ipv4_gateway_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipv4_gateway_id", value)

    @_builtins.property
    @pulumi.getter(name="routeTableId")
    def route_table_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Gateway route table to be bound.
        """
        return pulumi.get(self, "route_table_id")

    @route_table_id.setter
    def route_table_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "route_table_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the IPv4 Gateway instance. Value:
        - **Creating**: The function is being created.
        - **Created**: Created and available.
        - **Modifying**: is being modified.
        - **Deleting**: Deleting.
        - **Deleted**: Deleted.
        - **Activating**: enabled.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.type_token("alicloud:vpc/gatewayRouteTableAttachment:GatewayRouteTableAttachment")
class GatewayRouteTableAttachment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
                 ipv4_gateway_id: Optional[pulumi.Input[_builtins.str]] = None,
                 route_table_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a VPC Gateway Route Table Attachment resource.

        For information about VPC Gateway Route Table Attachment and how to use it, see [What is Gateway Route Table Attachment](https://www.alibabacloud.com/help/doc-detail/174112.htm).

        > **NOTE:** Available since v1.194.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        example = alicloud.vpc.Network("example",
            cidr_block="172.16.0.0/12",
            vpc_name="terraform-example")
        example_route_table = alicloud.vpc.RouteTable("example",
            vpc_id=example.id,
            route_table_name="terraform-example",
            description="terraform-example",
            associate_type="Gateway")
        example_ipv4_gateway = alicloud.vpc.Ipv4Gateway("example",
            ipv4_gateway_name="terraform-example",
            vpc_id=example.id,
            enabled=True)
        example_gateway_route_table_attachment = alicloud.vpc.GatewayRouteTableAttachment("example",
            ipv4_gateway_id=example_ipv4_gateway.id,
            route_table_id=example_route_table.id)
        ```

        ## Import

        VPC Gateway Route Table Attachment can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:vpc/gatewayRouteTableAttachment:GatewayRouteTableAttachment example <route_table_id>:<ipv4_gateway_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] dry_run: Specifies whether to only precheck this request. Default value: `false`.
        :param pulumi.Input[_builtins.str] ipv4_gateway_id: The ID of the IPv4 Gateway instance.
        :param pulumi.Input[_builtins.str] route_table_id: The ID of the Gateway route table to be bound.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GatewayRouteTableAttachmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a VPC Gateway Route Table Attachment resource.

        For information about VPC Gateway Route Table Attachment and how to use it, see [What is Gateway Route Table Attachment](https://www.alibabacloud.com/help/doc-detail/174112.htm).

        > **NOTE:** Available since v1.194.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        example = alicloud.vpc.Network("example",
            cidr_block="172.16.0.0/12",
            vpc_name="terraform-example")
        example_route_table = alicloud.vpc.RouteTable("example",
            vpc_id=example.id,
            route_table_name="terraform-example",
            description="terraform-example",
            associate_type="Gateway")
        example_ipv4_gateway = alicloud.vpc.Ipv4Gateway("example",
            ipv4_gateway_name="terraform-example",
            vpc_id=example.id,
            enabled=True)
        example_gateway_route_table_attachment = alicloud.vpc.GatewayRouteTableAttachment("example",
            ipv4_gateway_id=example_ipv4_gateway.id,
            route_table_id=example_route_table.id)
        ```

        ## Import

        VPC Gateway Route Table Attachment can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:vpc/gatewayRouteTableAttachment:GatewayRouteTableAttachment example <route_table_id>:<ipv4_gateway_id>
        ```

        :param str resource_name: The name of the resource.
        :param GatewayRouteTableAttachmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GatewayRouteTableAttachmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
                 ipv4_gateway_id: Optional[pulumi.Input[_builtins.str]] = None,
                 route_table_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GatewayRouteTableAttachmentArgs.__new__(GatewayRouteTableAttachmentArgs)

            __props__.__dict__["dry_run"] = dry_run
            if ipv4_gateway_id is None and not opts.urn:
                raise TypeError("Missing required property 'ipv4_gateway_id'")
            __props__.__dict__["ipv4_gateway_id"] = ipv4_gateway_id
            if route_table_id is None and not opts.urn:
                raise TypeError("Missing required property 'route_table_id'")
            __props__.__dict__["route_table_id"] = route_table_id
            __props__.__dict__["create_time"] = None
            __props__.__dict__["status"] = None
        super(GatewayRouteTableAttachment, __self__).__init__(
            'alicloud:vpc/gatewayRouteTableAttachment:GatewayRouteTableAttachment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
            ipv4_gateway_id: Optional[pulumi.Input[_builtins.str]] = None,
            route_table_id: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None) -> 'GatewayRouteTableAttachment':
        """
        Get an existing GatewayRouteTableAttachment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] create_time: The creation time of the resource.
        :param pulumi.Input[_builtins.bool] dry_run: Specifies whether to only precheck this request. Default value: `false`.
        :param pulumi.Input[_builtins.str] ipv4_gateway_id: The ID of the IPv4 Gateway instance.
        :param pulumi.Input[_builtins.str] route_table_id: The ID of the Gateway route table to be bound.
        :param pulumi.Input[_builtins.str] status: The status of the IPv4 Gateway instance. Value:
               - **Creating**: The function is being created.
               - **Created**: Created and available.
               - **Modifying**: is being modified.
               - **Deleting**: Deleting.
               - **Deleted**: Deleted.
               - **Activating**: enabled.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GatewayRouteTableAttachmentState.__new__(_GatewayRouteTableAttachmentState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["dry_run"] = dry_run
        __props__.__dict__["ipv4_gateway_id"] = ipv4_gateway_id
        __props__.__dict__["route_table_id"] = route_table_id
        __props__.__dict__["status"] = status
        return GatewayRouteTableAttachment(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The creation time of the resource.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether to only precheck this request. Default value: `false`.
        """
        return pulumi.get(self, "dry_run")

    @_builtins.property
    @pulumi.getter(name="ipv4GatewayId")
    def ipv4_gateway_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the IPv4 Gateway instance.
        """
        return pulumi.get(self, "ipv4_gateway_id")

    @_builtins.property
    @pulumi.getter(name="routeTableId")
    def route_table_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Gateway route table to be bound.
        """
        return pulumi.get(self, "route_table_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the IPv4 Gateway instance. Value:
        - **Creating**: The function is being created.
        - **Created**: Created and available.
        - **Modifying**: is being modified.
        - **Deleting**: Deleting.
        - **Deleted**: Deleted.
        - **Activating**: enabled.
        """
        return pulumi.get(self, "status")

