# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ConnectionArgs', 'Connection']

@pulumi.input_type
class ConnectionArgs:
    def __init__(__self__, *,
                 local_subnets: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 remote_subnets: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 vpn_gateway_id: pulumi.Input[_builtins.str],
                 auto_config_route: Optional[pulumi.Input[_builtins.bool]] = None,
                 bgp_config: Optional[pulumi.Input['ConnectionBgpConfigArgs']] = None,
                 customer_gateway_id: Optional[pulumi.Input[_builtins.str]] = None,
                 effect_immediately: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_dpd: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_nat_traversal: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_tunnels_bgp: Optional[pulumi.Input[_builtins.bool]] = None,
                 health_check_config: Optional[pulumi.Input['ConnectionHealthCheckConfigArgs']] = None,
                 ike_config: Optional[pulumi.Input['ConnectionIkeConfigArgs']] = None,
                 ipsec_config: Optional[pulumi.Input['ConnectionIpsecConfigArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_type: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tunnel_options_specifications: Optional[pulumi.Input[Sequence[pulumi.Input['ConnectionTunnelOptionsSpecificationArgs']]]] = None,
                 vpn_connection_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Connection resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] local_subnets: The CIDR block of the VPC to be connected with the local data center. This parameter is used for phase-two negotiation.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] remote_subnets: The CIDR block of the local data center. This parameter is used for phase-two negotiation.
        :param pulumi.Input[_builtins.str] vpn_gateway_id: The ID of the VPN gateway.
        :param pulumi.Input[_builtins.bool] auto_config_route: Whether to configure routing automatically. Value:
               - **true**: Automatically configure routes.
               - **false**: does not automatically configure routes.
        :param pulumi.Input['ConnectionBgpConfigArgs'] bgp_config: vpnBgp configuration. See `bgp_config` below.
        :param pulumi.Input[_builtins.str] customer_gateway_id: The ID of the customer gateway.
        :param pulumi.Input[_builtins.bool] effect_immediately: Indicates whether IPsec-VPN negotiations are initiated immediately. Valid values.
        :param pulumi.Input[_builtins.bool] enable_dpd: Wether enable Dpd detection.
        :param pulumi.Input[_builtins.bool] enable_nat_traversal: enable nat traversal.
        :param pulumi.Input[_builtins.bool] enable_tunnels_bgp: Enable tunnel bgp.
        :param pulumi.Input['ConnectionHealthCheckConfigArgs'] health_check_config: Health Check information. See `health_check_config` below.
        :param pulumi.Input['ConnectionIkeConfigArgs'] ike_config: The configuration of Phase 1 negotiations. See `ike_config` below.
        :param pulumi.Input['ConnectionIpsecConfigArgs'] ipsec_config: IPsec configuration. See `ipsec_config` below.
        :param pulumi.Input[_builtins.str] name: . Field 'name' has been deprecated from provider version 1.216.0. New field 'vpn_connection_name' instead.
        :param pulumi.Input[_builtins.str] network_type: The network type of the IPsec connection. Value:
               - **public**: public network, indicating that the IPsec connection establishes an encrypted communication channel through the public network.
               - **private**: private network, indicating that the IPsec connection establishes an encrypted communication channel through the private network.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Tags.
        :param pulumi.Input[Sequence[pulumi.Input['ConnectionTunnelOptionsSpecificationArgs']]] tunnel_options_specifications: The tunnel options of IPsec. See `tunnel_options_specification` below.
        :param pulumi.Input[_builtins.str] vpn_connection_name: The name of the IPsec-VPN connection.
        """
        pulumi.set(__self__, "local_subnets", local_subnets)
        pulumi.set(__self__, "remote_subnets", remote_subnets)
        pulumi.set(__self__, "vpn_gateway_id", vpn_gateway_id)
        if auto_config_route is not None:
            pulumi.set(__self__, "auto_config_route", auto_config_route)
        if bgp_config is not None:
            pulumi.set(__self__, "bgp_config", bgp_config)
        if customer_gateway_id is not None:
            pulumi.set(__self__, "customer_gateway_id", customer_gateway_id)
        if effect_immediately is not None:
            pulumi.set(__self__, "effect_immediately", effect_immediately)
        if enable_dpd is not None:
            pulumi.set(__self__, "enable_dpd", enable_dpd)
        if enable_nat_traversal is not None:
            pulumi.set(__self__, "enable_nat_traversal", enable_nat_traversal)
        if enable_tunnels_bgp is not None:
            pulumi.set(__self__, "enable_tunnels_bgp", enable_tunnels_bgp)
        if health_check_config is not None:
            pulumi.set(__self__, "health_check_config", health_check_config)
        if ike_config is not None:
            pulumi.set(__self__, "ike_config", ike_config)
        if ipsec_config is not None:
            pulumi.set(__self__, "ipsec_config", ipsec_config)
        if name is not None:
            warnings.warn("""Field 'name' has been deprecated since provider version 1.216.0. New field 'vpn_connection_name' instead.""", DeprecationWarning)
            pulumi.log.warn("""name is deprecated: Field 'name' has been deprecated since provider version 1.216.0. New field 'vpn_connection_name' instead.""")
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_type is not None:
            pulumi.set(__self__, "network_type", network_type)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tunnel_options_specifications is not None:
            pulumi.set(__self__, "tunnel_options_specifications", tunnel_options_specifications)
        if vpn_connection_name is not None:
            pulumi.set(__self__, "vpn_connection_name", vpn_connection_name)

    @_builtins.property
    @pulumi.getter(name="localSubnets")
    def local_subnets(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        The CIDR block of the VPC to be connected with the local data center. This parameter is used for phase-two negotiation.
        """
        return pulumi.get(self, "local_subnets")

    @local_subnets.setter
    def local_subnets(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "local_subnets", value)

    @_builtins.property
    @pulumi.getter(name="remoteSubnets")
    def remote_subnets(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        The CIDR block of the local data center. This parameter is used for phase-two negotiation.
        """
        return pulumi.get(self, "remote_subnets")

    @remote_subnets.setter
    def remote_subnets(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "remote_subnets", value)

    @_builtins.property
    @pulumi.getter(name="vpnGatewayId")
    def vpn_gateway_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the VPN gateway.
        """
        return pulumi.get(self, "vpn_gateway_id")

    @vpn_gateway_id.setter
    def vpn_gateway_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vpn_gateway_id", value)

    @_builtins.property
    @pulumi.getter(name="autoConfigRoute")
    def auto_config_route(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to configure routing automatically. Value:
        - **true**: Automatically configure routes.
        - **false**: does not automatically configure routes.
        """
        return pulumi.get(self, "auto_config_route")

    @auto_config_route.setter
    def auto_config_route(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_config_route", value)

    @_builtins.property
    @pulumi.getter(name="bgpConfig")
    def bgp_config(self) -> Optional[pulumi.Input['ConnectionBgpConfigArgs']]:
        """
        vpnBgp configuration. See `bgp_config` below.
        """
        return pulumi.get(self, "bgp_config")

    @bgp_config.setter
    def bgp_config(self, value: Optional[pulumi.Input['ConnectionBgpConfigArgs']]):
        pulumi.set(self, "bgp_config", value)

    @_builtins.property
    @pulumi.getter(name="customerGatewayId")
    def customer_gateway_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the customer gateway.
        """
        return pulumi.get(self, "customer_gateway_id")

    @customer_gateway_id.setter
    def customer_gateway_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "customer_gateway_id", value)

    @_builtins.property
    @pulumi.getter(name="effectImmediately")
    def effect_immediately(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether IPsec-VPN negotiations are initiated immediately. Valid values.
        """
        return pulumi.get(self, "effect_immediately")

    @effect_immediately.setter
    def effect_immediately(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "effect_immediately", value)

    @_builtins.property
    @pulumi.getter(name="enableDpd")
    def enable_dpd(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Wether enable Dpd detection.
        """
        return pulumi.get(self, "enable_dpd")

    @enable_dpd.setter
    def enable_dpd(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_dpd", value)

    @_builtins.property
    @pulumi.getter(name="enableNatTraversal")
    def enable_nat_traversal(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        enable nat traversal.
        """
        return pulumi.get(self, "enable_nat_traversal")

    @enable_nat_traversal.setter
    def enable_nat_traversal(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_nat_traversal", value)

    @_builtins.property
    @pulumi.getter(name="enableTunnelsBgp")
    def enable_tunnels_bgp(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable tunnel bgp.
        """
        return pulumi.get(self, "enable_tunnels_bgp")

    @enable_tunnels_bgp.setter
    def enable_tunnels_bgp(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_tunnels_bgp", value)

    @_builtins.property
    @pulumi.getter(name="healthCheckConfig")
    def health_check_config(self) -> Optional[pulumi.Input['ConnectionHealthCheckConfigArgs']]:
        """
        Health Check information. See `health_check_config` below.
        """
        return pulumi.get(self, "health_check_config")

    @health_check_config.setter
    def health_check_config(self, value: Optional[pulumi.Input['ConnectionHealthCheckConfigArgs']]):
        pulumi.set(self, "health_check_config", value)

    @_builtins.property
    @pulumi.getter(name="ikeConfig")
    def ike_config(self) -> Optional[pulumi.Input['ConnectionIkeConfigArgs']]:
        """
        The configuration of Phase 1 negotiations. See `ike_config` below.
        """
        return pulumi.get(self, "ike_config")

    @ike_config.setter
    def ike_config(self, value: Optional[pulumi.Input['ConnectionIkeConfigArgs']]):
        pulumi.set(self, "ike_config", value)

    @_builtins.property
    @pulumi.getter(name="ipsecConfig")
    def ipsec_config(self) -> Optional[pulumi.Input['ConnectionIpsecConfigArgs']]:
        """
        IPsec configuration. See `ipsec_config` below.
        """
        return pulumi.get(self, "ipsec_config")

    @ipsec_config.setter
    def ipsec_config(self, value: Optional[pulumi.Input['ConnectionIpsecConfigArgs']]):
        pulumi.set(self, "ipsec_config", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field 'name' has been deprecated since provider version 1.216.0. New field 'vpn_connection_name' instead.""")
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        . Field 'name' has been deprecated from provider version 1.216.0. New field 'vpn_connection_name' instead.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networkType")
    def network_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The network type of the IPsec connection. Value:
        - **public**: public network, indicating that the IPsec connection establishes an encrypted communication channel through the public network.
        - **private**: private network, indicating that the IPsec connection establishes an encrypted communication channel through the private network.
        """
        return pulumi.get(self, "network_type")

    @network_type.setter
    def network_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_type", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tunnelOptionsSpecifications")
    def tunnel_options_specifications(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConnectionTunnelOptionsSpecificationArgs']]]]:
        """
        The tunnel options of IPsec. See `tunnel_options_specification` below.
        """
        return pulumi.get(self, "tunnel_options_specifications")

    @tunnel_options_specifications.setter
    def tunnel_options_specifications(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConnectionTunnelOptionsSpecificationArgs']]]]):
        pulumi.set(self, "tunnel_options_specifications", value)

    @_builtins.property
    @pulumi.getter(name="vpnConnectionName")
    def vpn_connection_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the IPsec-VPN connection.
        """
        return pulumi.get(self, "vpn_connection_name")

    @vpn_connection_name.setter
    def vpn_connection_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpn_connection_name", value)


@pulumi.input_type
class _ConnectionState:
    def __init__(__self__, *,
                 auto_config_route: Optional[pulumi.Input[_builtins.bool]] = None,
                 bgp_config: Optional[pulumi.Input['ConnectionBgpConfigArgs']] = None,
                 create_time: Optional[pulumi.Input[_builtins.int]] = None,
                 customer_gateway_id: Optional[pulumi.Input[_builtins.str]] = None,
                 effect_immediately: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_dpd: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_nat_traversal: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_tunnels_bgp: Optional[pulumi.Input[_builtins.bool]] = None,
                 health_check_config: Optional[pulumi.Input['ConnectionHealthCheckConfigArgs']] = None,
                 ike_config: Optional[pulumi.Input['ConnectionIkeConfigArgs']] = None,
                 ipsec_config: Optional[pulumi.Input['ConnectionIpsecConfigArgs']] = None,
                 local_subnets: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_type: Optional[pulumi.Input[_builtins.str]] = None,
                 remote_subnets: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tunnel_options_specifications: Optional[pulumi.Input[Sequence[pulumi.Input['ConnectionTunnelOptionsSpecificationArgs']]]] = None,
                 vpn_connection_name: Optional[pulumi.Input[_builtins.str]] = None,
                 vpn_gateway_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Connection resources.
        :param pulumi.Input[_builtins.bool] auto_config_route: Whether to configure routing automatically. Value:
               - **true**: Automatically configure routes.
               - **false**: does not automatically configure routes.
        :param pulumi.Input['ConnectionBgpConfigArgs'] bgp_config: vpnBgp configuration. See `bgp_config` below.
        :param pulumi.Input[_builtins.int] create_time: The time when the IPsec-VPN connection was created.
        :param pulumi.Input[_builtins.str] customer_gateway_id: The ID of the customer gateway.
        :param pulumi.Input[_builtins.bool] effect_immediately: Indicates whether IPsec-VPN negotiations are initiated immediately. Valid values.
        :param pulumi.Input[_builtins.bool] enable_dpd: Wether enable Dpd detection.
        :param pulumi.Input[_builtins.bool] enable_nat_traversal: enable nat traversal.
        :param pulumi.Input[_builtins.bool] enable_tunnels_bgp: Enable tunnel bgp.
        :param pulumi.Input['ConnectionHealthCheckConfigArgs'] health_check_config: Health Check information. See `health_check_config` below.
        :param pulumi.Input['ConnectionIkeConfigArgs'] ike_config: The configuration of Phase 1 negotiations. See `ike_config` below.
        :param pulumi.Input['ConnectionIpsecConfigArgs'] ipsec_config: IPsec configuration. See `ipsec_config` below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] local_subnets: The CIDR block of the VPC to be connected with the local data center. This parameter is used for phase-two negotiation.
        :param pulumi.Input[_builtins.str] name: . Field 'name' has been deprecated from provider version 1.216.0. New field 'vpn_connection_name' instead.
        :param pulumi.Input[_builtins.str] network_type: The network type of the IPsec connection. Value:
               - **public**: public network, indicating that the IPsec connection establishes an encrypted communication channel through the public network.
               - **private**: private network, indicating that the IPsec connection establishes an encrypted communication channel through the private network.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] remote_subnets: The CIDR block of the local data center. This parameter is used for phase-two negotiation.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group.
        :param pulumi.Input[_builtins.str] status: The negotiation status of Tunnel.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Tags.
        :param pulumi.Input[Sequence[pulumi.Input['ConnectionTunnelOptionsSpecificationArgs']]] tunnel_options_specifications: The tunnel options of IPsec. See `tunnel_options_specification` below.
        :param pulumi.Input[_builtins.str] vpn_connection_name: The name of the IPsec-VPN connection.
        :param pulumi.Input[_builtins.str] vpn_gateway_id: The ID of the VPN gateway.
        """
        if auto_config_route is not None:
            pulumi.set(__self__, "auto_config_route", auto_config_route)
        if bgp_config is not None:
            pulumi.set(__self__, "bgp_config", bgp_config)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if customer_gateway_id is not None:
            pulumi.set(__self__, "customer_gateway_id", customer_gateway_id)
        if effect_immediately is not None:
            pulumi.set(__self__, "effect_immediately", effect_immediately)
        if enable_dpd is not None:
            pulumi.set(__self__, "enable_dpd", enable_dpd)
        if enable_nat_traversal is not None:
            pulumi.set(__self__, "enable_nat_traversal", enable_nat_traversal)
        if enable_tunnels_bgp is not None:
            pulumi.set(__self__, "enable_tunnels_bgp", enable_tunnels_bgp)
        if health_check_config is not None:
            pulumi.set(__self__, "health_check_config", health_check_config)
        if ike_config is not None:
            pulumi.set(__self__, "ike_config", ike_config)
        if ipsec_config is not None:
            pulumi.set(__self__, "ipsec_config", ipsec_config)
        if local_subnets is not None:
            pulumi.set(__self__, "local_subnets", local_subnets)
        if name is not None:
            warnings.warn("""Field 'name' has been deprecated since provider version 1.216.0. New field 'vpn_connection_name' instead.""", DeprecationWarning)
            pulumi.log.warn("""name is deprecated: Field 'name' has been deprecated since provider version 1.216.0. New field 'vpn_connection_name' instead.""")
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_type is not None:
            pulumi.set(__self__, "network_type", network_type)
        if remote_subnets is not None:
            pulumi.set(__self__, "remote_subnets", remote_subnets)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tunnel_options_specifications is not None:
            pulumi.set(__self__, "tunnel_options_specifications", tunnel_options_specifications)
        if vpn_connection_name is not None:
            pulumi.set(__self__, "vpn_connection_name", vpn_connection_name)
        if vpn_gateway_id is not None:
            pulumi.set(__self__, "vpn_gateway_id", vpn_gateway_id)

    @_builtins.property
    @pulumi.getter(name="autoConfigRoute")
    def auto_config_route(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to configure routing automatically. Value:
        - **true**: Automatically configure routes.
        - **false**: does not automatically configure routes.
        """
        return pulumi.get(self, "auto_config_route")

    @auto_config_route.setter
    def auto_config_route(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_config_route", value)

    @_builtins.property
    @pulumi.getter(name="bgpConfig")
    def bgp_config(self) -> Optional[pulumi.Input['ConnectionBgpConfigArgs']]:
        """
        vpnBgp configuration. See `bgp_config` below.
        """
        return pulumi.get(self, "bgp_config")

    @bgp_config.setter
    def bgp_config(self, value: Optional[pulumi.Input['ConnectionBgpConfigArgs']]):
        pulumi.set(self, "bgp_config", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The time when the IPsec-VPN connection was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="customerGatewayId")
    def customer_gateway_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the customer gateway.
        """
        return pulumi.get(self, "customer_gateway_id")

    @customer_gateway_id.setter
    def customer_gateway_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "customer_gateway_id", value)

    @_builtins.property
    @pulumi.getter(name="effectImmediately")
    def effect_immediately(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether IPsec-VPN negotiations are initiated immediately. Valid values.
        """
        return pulumi.get(self, "effect_immediately")

    @effect_immediately.setter
    def effect_immediately(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "effect_immediately", value)

    @_builtins.property
    @pulumi.getter(name="enableDpd")
    def enable_dpd(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Wether enable Dpd detection.
        """
        return pulumi.get(self, "enable_dpd")

    @enable_dpd.setter
    def enable_dpd(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_dpd", value)

    @_builtins.property
    @pulumi.getter(name="enableNatTraversal")
    def enable_nat_traversal(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        enable nat traversal.
        """
        return pulumi.get(self, "enable_nat_traversal")

    @enable_nat_traversal.setter
    def enable_nat_traversal(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_nat_traversal", value)

    @_builtins.property
    @pulumi.getter(name="enableTunnelsBgp")
    def enable_tunnels_bgp(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable tunnel bgp.
        """
        return pulumi.get(self, "enable_tunnels_bgp")

    @enable_tunnels_bgp.setter
    def enable_tunnels_bgp(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_tunnels_bgp", value)

    @_builtins.property
    @pulumi.getter(name="healthCheckConfig")
    def health_check_config(self) -> Optional[pulumi.Input['ConnectionHealthCheckConfigArgs']]:
        """
        Health Check information. See `health_check_config` below.
        """
        return pulumi.get(self, "health_check_config")

    @health_check_config.setter
    def health_check_config(self, value: Optional[pulumi.Input['ConnectionHealthCheckConfigArgs']]):
        pulumi.set(self, "health_check_config", value)

    @_builtins.property
    @pulumi.getter(name="ikeConfig")
    def ike_config(self) -> Optional[pulumi.Input['ConnectionIkeConfigArgs']]:
        """
        The configuration of Phase 1 negotiations. See `ike_config` below.
        """
        return pulumi.get(self, "ike_config")

    @ike_config.setter
    def ike_config(self, value: Optional[pulumi.Input['ConnectionIkeConfigArgs']]):
        pulumi.set(self, "ike_config", value)

    @_builtins.property
    @pulumi.getter(name="ipsecConfig")
    def ipsec_config(self) -> Optional[pulumi.Input['ConnectionIpsecConfigArgs']]:
        """
        IPsec configuration. See `ipsec_config` below.
        """
        return pulumi.get(self, "ipsec_config")

    @ipsec_config.setter
    def ipsec_config(self, value: Optional[pulumi.Input['ConnectionIpsecConfigArgs']]):
        pulumi.set(self, "ipsec_config", value)

    @_builtins.property
    @pulumi.getter(name="localSubnets")
    def local_subnets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The CIDR block of the VPC to be connected with the local data center. This parameter is used for phase-two negotiation.
        """
        return pulumi.get(self, "local_subnets")

    @local_subnets.setter
    def local_subnets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "local_subnets", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field 'name' has been deprecated since provider version 1.216.0. New field 'vpn_connection_name' instead.""")
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        . Field 'name' has been deprecated from provider version 1.216.0. New field 'vpn_connection_name' instead.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networkType")
    def network_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The network type of the IPsec connection. Value:
        - **public**: public network, indicating that the IPsec connection establishes an encrypted communication channel through the public network.
        - **private**: private network, indicating that the IPsec connection establishes an encrypted communication channel through the private network.
        """
        return pulumi.get(self, "network_type")

    @network_type.setter
    def network_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_type", value)

    @_builtins.property
    @pulumi.getter(name="remoteSubnets")
    def remote_subnets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The CIDR block of the local data center. This parameter is used for phase-two negotiation.
        """
        return pulumi.get(self, "remote_subnets")

    @remote_subnets.setter
    def remote_subnets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "remote_subnets", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The negotiation status of Tunnel.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tunnelOptionsSpecifications")
    def tunnel_options_specifications(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConnectionTunnelOptionsSpecificationArgs']]]]:
        """
        The tunnel options of IPsec. See `tunnel_options_specification` below.
        """
        return pulumi.get(self, "tunnel_options_specifications")

    @tunnel_options_specifications.setter
    def tunnel_options_specifications(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConnectionTunnelOptionsSpecificationArgs']]]]):
        pulumi.set(self, "tunnel_options_specifications", value)

    @_builtins.property
    @pulumi.getter(name="vpnConnectionName")
    def vpn_connection_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the IPsec-VPN connection.
        """
        return pulumi.get(self, "vpn_connection_name")

    @vpn_connection_name.setter
    def vpn_connection_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpn_connection_name", value)

    @_builtins.property
    @pulumi.getter(name="vpnGatewayId")
    def vpn_gateway_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the VPN gateway.
        """
        return pulumi.get(self, "vpn_gateway_id")

    @vpn_gateway_id.setter
    def vpn_gateway_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpn_gateway_id", value)


@pulumi.type_token("alicloud:vpn/connection:Connection")
class Connection(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_config_route: Optional[pulumi.Input[_builtins.bool]] = None,
                 bgp_config: Optional[pulumi.Input[Union['ConnectionBgpConfigArgs', 'ConnectionBgpConfigArgsDict']]] = None,
                 customer_gateway_id: Optional[pulumi.Input[_builtins.str]] = None,
                 effect_immediately: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_dpd: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_nat_traversal: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_tunnels_bgp: Optional[pulumi.Input[_builtins.bool]] = None,
                 health_check_config: Optional[pulumi.Input[Union['ConnectionHealthCheckConfigArgs', 'ConnectionHealthCheckConfigArgsDict']]] = None,
                 ike_config: Optional[pulumi.Input[Union['ConnectionIkeConfigArgs', 'ConnectionIkeConfigArgsDict']]] = None,
                 ipsec_config: Optional[pulumi.Input[Union['ConnectionIpsecConfigArgs', 'ConnectionIpsecConfigArgsDict']]] = None,
                 local_subnets: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_type: Optional[pulumi.Input[_builtins.str]] = None,
                 remote_subnets: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tunnel_options_specifications: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ConnectionTunnelOptionsSpecificationArgs', 'ConnectionTunnelOptionsSpecificationArgsDict']]]]] = None,
                 vpn_connection_name: Optional[pulumi.Input[_builtins.str]] = None,
                 vpn_gateway_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        Basic Usage

        [IPsec-VPN connections support the dual-tunnel mode](https://www.alibabacloud.com/help/en/vpn/product-overview/ipsec-vpn-connections-support-the-dual-tunnel-mode)

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        spec = config.get("spec")
        if spec is None:
            spec = "5"
        default = alicloud.vpn.get_gateway_zones(spec="5M")
        default_network = alicloud.vpc.Network("default",
            cidr_block="172.16.0.0/16",
            vpc_name=name)
        default0 = alicloud.vpc.Switch("default0",
            cidr_block="172.16.0.0/24",
            vpc_id=default_network.id,
            zone_id=default.ids[0])
        default1 = alicloud.vpc.Switch("default1",
            cidr_block="172.16.1.0/24",
            vpc_id=default_network.id,
            zone_id=default.ids[1])
        h_a__vpn = alicloud.vpn.Gateway("HA-VPN",
            vpn_type="Normal",
            disaster_recovery_vswitch_id=default1.id,
            vpn_gateway_name=name,
            vswitch_id=default0.id,
            auto_pay=True,
            vpc_id=default_network.id,
            network_type="public",
            payment_type="Subscription",
            enable_ipsec=True,
            bandwidth=spec)
        default_customer_gateway = alicloud.vpn.CustomerGateway("defaultCustomerGateway",
            description="defaultCustomerGateway",
            ip_address="2.2.2.5",
            asn="2224",
            customer_gateway_name=name)
        change_customer_gateway = alicloud.vpn.CustomerGateway("changeCustomerGateway",
            description="changeCustomerGateway",
            ip_address="2.2.2.6",
            asn="2225",
            customer_gateway_name=name)
        default_connection = alicloud.vpn.Connection("default",
            vpn_gateway_id=h_a__vpn.id,
            vpn_connection_name=name,
            local_subnets=["3.0.0.0/24"],
            remote_subnets=[
                "10.0.0.0/24",
                "10.0.1.0/24",
            ],
            tags={
                "Created": "TF",
                "For": "example",
            },
            enable_tunnels_bgp=True,
            tunnel_options_specifications=[
                {
                    "tunnel_ipsec_config": {
                        "ipsec_auth_alg": "md5",
                        "ipsec_enc_alg": "aes256",
                        "ipsec_lifetime": 16400,
                        "ipsec_pfs": "group5",
                    },
                    "customer_gateway_id": default_customer_gateway.id,
                    "role": "master",
                    "tunnel_bgp_config": {
                        "local_asn": "1219002",
                        "tunnel_cidr": "169.254.30.0/30",
                        "local_bgp_ip": "169.254.30.1",
                    },
                    "tunnel_ike_config": {
                        "ike_mode": "aggressive",
                        "ike_version": "ikev2",
                        "local_id": "localid_tunnel2",
                        "psk": "12345678",
                        "remote_id": "remote2",
                        "ike_auth_alg": "md5",
                        "ike_enc_alg": "aes256",
                        "ike_lifetime": 3600,
                        "ike_pfs": "group14",
                    },
                },
                {
                    "tunnel_ike_config": {
                        "remote_id": "remote24",
                        "ike_enc_alg": "aes256",
                        "ike_lifetime": 27000,
                        "ike_mode": "aggressive",
                        "ike_pfs": "group5",
                        "ike_auth_alg": "md5",
                        "ike_version": "ikev2",
                        "local_id": "localid_tunnel2",
                        "psk": "12345678",
                    },
                    "tunnel_ipsec_config": {
                        "ipsec_lifetime": 2700,
                        "ipsec_pfs": "group14",
                        "ipsec_auth_alg": "md5",
                        "ipsec_enc_alg": "aes256",
                    },
                    "customer_gateway_id": default_customer_gateway.id,
                    "role": "slave",
                    "tunnel_bgp_config": {
                        "local_asn": "1219002",
                        "local_bgp_ip": "169.254.40.1",
                        "tunnel_cidr": "169.254.40.0/30",
                    },
                },
            ])
        ```

        ## Import

        VPN connection can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:vpn/connection:Connection example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] auto_config_route: Whether to configure routing automatically. Value:
               - **true**: Automatically configure routes.
               - **false**: does not automatically configure routes.
        :param pulumi.Input[Union['ConnectionBgpConfigArgs', 'ConnectionBgpConfigArgsDict']] bgp_config: vpnBgp configuration. See `bgp_config` below.
        :param pulumi.Input[_builtins.str] customer_gateway_id: The ID of the customer gateway.
        :param pulumi.Input[_builtins.bool] effect_immediately: Indicates whether IPsec-VPN negotiations are initiated immediately. Valid values.
        :param pulumi.Input[_builtins.bool] enable_dpd: Wether enable Dpd detection.
        :param pulumi.Input[_builtins.bool] enable_nat_traversal: enable nat traversal.
        :param pulumi.Input[_builtins.bool] enable_tunnels_bgp: Enable tunnel bgp.
        :param pulumi.Input[Union['ConnectionHealthCheckConfigArgs', 'ConnectionHealthCheckConfigArgsDict']] health_check_config: Health Check information. See `health_check_config` below.
        :param pulumi.Input[Union['ConnectionIkeConfigArgs', 'ConnectionIkeConfigArgsDict']] ike_config: The configuration of Phase 1 negotiations. See `ike_config` below.
        :param pulumi.Input[Union['ConnectionIpsecConfigArgs', 'ConnectionIpsecConfigArgsDict']] ipsec_config: IPsec configuration. See `ipsec_config` below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] local_subnets: The CIDR block of the VPC to be connected with the local data center. This parameter is used for phase-two negotiation.
        :param pulumi.Input[_builtins.str] name: . Field 'name' has been deprecated from provider version 1.216.0. New field 'vpn_connection_name' instead.
        :param pulumi.Input[_builtins.str] network_type: The network type of the IPsec connection. Value:
               - **public**: public network, indicating that the IPsec connection establishes an encrypted communication channel through the public network.
               - **private**: private network, indicating that the IPsec connection establishes an encrypted communication channel through the private network.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] remote_subnets: The CIDR block of the local data center. This parameter is used for phase-two negotiation.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Tags.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ConnectionTunnelOptionsSpecificationArgs', 'ConnectionTunnelOptionsSpecificationArgsDict']]]] tunnel_options_specifications: The tunnel options of IPsec. See `tunnel_options_specification` below.
        :param pulumi.Input[_builtins.str] vpn_connection_name: The name of the IPsec-VPN connection.
        :param pulumi.Input[_builtins.str] vpn_gateway_id: The ID of the VPN gateway.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ConnectionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        Basic Usage

        [IPsec-VPN connections support the dual-tunnel mode](https://www.alibabacloud.com/help/en/vpn/product-overview/ipsec-vpn-connections-support-the-dual-tunnel-mode)

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        spec = config.get("spec")
        if spec is None:
            spec = "5"
        default = alicloud.vpn.get_gateway_zones(spec="5M")
        default_network = alicloud.vpc.Network("default",
            cidr_block="172.16.0.0/16",
            vpc_name=name)
        default0 = alicloud.vpc.Switch("default0",
            cidr_block="172.16.0.0/24",
            vpc_id=default_network.id,
            zone_id=default.ids[0])
        default1 = alicloud.vpc.Switch("default1",
            cidr_block="172.16.1.0/24",
            vpc_id=default_network.id,
            zone_id=default.ids[1])
        h_a__vpn = alicloud.vpn.Gateway("HA-VPN",
            vpn_type="Normal",
            disaster_recovery_vswitch_id=default1.id,
            vpn_gateway_name=name,
            vswitch_id=default0.id,
            auto_pay=True,
            vpc_id=default_network.id,
            network_type="public",
            payment_type="Subscription",
            enable_ipsec=True,
            bandwidth=spec)
        default_customer_gateway = alicloud.vpn.CustomerGateway("defaultCustomerGateway",
            description="defaultCustomerGateway",
            ip_address="2.2.2.5",
            asn="2224",
            customer_gateway_name=name)
        change_customer_gateway = alicloud.vpn.CustomerGateway("changeCustomerGateway",
            description="changeCustomerGateway",
            ip_address="2.2.2.6",
            asn="2225",
            customer_gateway_name=name)
        default_connection = alicloud.vpn.Connection("default",
            vpn_gateway_id=h_a__vpn.id,
            vpn_connection_name=name,
            local_subnets=["3.0.0.0/24"],
            remote_subnets=[
                "10.0.0.0/24",
                "10.0.1.0/24",
            ],
            tags={
                "Created": "TF",
                "For": "example",
            },
            enable_tunnels_bgp=True,
            tunnel_options_specifications=[
                {
                    "tunnel_ipsec_config": {
                        "ipsec_auth_alg": "md5",
                        "ipsec_enc_alg": "aes256",
                        "ipsec_lifetime": 16400,
                        "ipsec_pfs": "group5",
                    },
                    "customer_gateway_id": default_customer_gateway.id,
                    "role": "master",
                    "tunnel_bgp_config": {
                        "local_asn": "1219002",
                        "tunnel_cidr": "169.254.30.0/30",
                        "local_bgp_ip": "169.254.30.1",
                    },
                    "tunnel_ike_config": {
                        "ike_mode": "aggressive",
                        "ike_version": "ikev2",
                        "local_id": "localid_tunnel2",
                        "psk": "12345678",
                        "remote_id": "remote2",
                        "ike_auth_alg": "md5",
                        "ike_enc_alg": "aes256",
                        "ike_lifetime": 3600,
                        "ike_pfs": "group14",
                    },
                },
                {
                    "tunnel_ike_config": {
                        "remote_id": "remote24",
                        "ike_enc_alg": "aes256",
                        "ike_lifetime": 27000,
                        "ike_mode": "aggressive",
                        "ike_pfs": "group5",
                        "ike_auth_alg": "md5",
                        "ike_version": "ikev2",
                        "local_id": "localid_tunnel2",
                        "psk": "12345678",
                    },
                    "tunnel_ipsec_config": {
                        "ipsec_lifetime": 2700,
                        "ipsec_pfs": "group14",
                        "ipsec_auth_alg": "md5",
                        "ipsec_enc_alg": "aes256",
                    },
                    "customer_gateway_id": default_customer_gateway.id,
                    "role": "slave",
                    "tunnel_bgp_config": {
                        "local_asn": "1219002",
                        "local_bgp_ip": "169.254.40.1",
                        "tunnel_cidr": "169.254.40.0/30",
                    },
                },
            ])
        ```

        ## Import

        VPN connection can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:vpn/connection:Connection example <id>
        ```

        :param str resource_name: The name of the resource.
        :param ConnectionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ConnectionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_config_route: Optional[pulumi.Input[_builtins.bool]] = None,
                 bgp_config: Optional[pulumi.Input[Union['ConnectionBgpConfigArgs', 'ConnectionBgpConfigArgsDict']]] = None,
                 customer_gateway_id: Optional[pulumi.Input[_builtins.str]] = None,
                 effect_immediately: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_dpd: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_nat_traversal: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_tunnels_bgp: Optional[pulumi.Input[_builtins.bool]] = None,
                 health_check_config: Optional[pulumi.Input[Union['ConnectionHealthCheckConfigArgs', 'ConnectionHealthCheckConfigArgsDict']]] = None,
                 ike_config: Optional[pulumi.Input[Union['ConnectionIkeConfigArgs', 'ConnectionIkeConfigArgsDict']]] = None,
                 ipsec_config: Optional[pulumi.Input[Union['ConnectionIpsecConfigArgs', 'ConnectionIpsecConfigArgsDict']]] = None,
                 local_subnets: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_type: Optional[pulumi.Input[_builtins.str]] = None,
                 remote_subnets: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tunnel_options_specifications: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ConnectionTunnelOptionsSpecificationArgs', 'ConnectionTunnelOptionsSpecificationArgsDict']]]]] = None,
                 vpn_connection_name: Optional[pulumi.Input[_builtins.str]] = None,
                 vpn_gateway_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ConnectionArgs.__new__(ConnectionArgs)

            __props__.__dict__["auto_config_route"] = auto_config_route
            __props__.__dict__["bgp_config"] = bgp_config
            __props__.__dict__["customer_gateway_id"] = customer_gateway_id
            __props__.__dict__["effect_immediately"] = effect_immediately
            __props__.__dict__["enable_dpd"] = enable_dpd
            __props__.__dict__["enable_nat_traversal"] = enable_nat_traversal
            __props__.__dict__["enable_tunnels_bgp"] = enable_tunnels_bgp
            __props__.__dict__["health_check_config"] = health_check_config
            __props__.__dict__["ike_config"] = ike_config
            __props__.__dict__["ipsec_config"] = ipsec_config
            if local_subnets is None and not opts.urn:
                raise TypeError("Missing required property 'local_subnets'")
            __props__.__dict__["local_subnets"] = local_subnets
            __props__.__dict__["name"] = name
            __props__.__dict__["network_type"] = network_type
            if remote_subnets is None and not opts.urn:
                raise TypeError("Missing required property 'remote_subnets'")
            __props__.__dict__["remote_subnets"] = remote_subnets
            __props__.__dict__["tags"] = tags
            __props__.__dict__["tunnel_options_specifications"] = tunnel_options_specifications
            __props__.__dict__["vpn_connection_name"] = vpn_connection_name
            if vpn_gateway_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpn_gateway_id'")
            __props__.__dict__["vpn_gateway_id"] = vpn_gateway_id
            __props__.__dict__["create_time"] = None
            __props__.__dict__["resource_group_id"] = None
            __props__.__dict__["status"] = None
        super(Connection, __self__).__init__(
            'alicloud:vpn/connection:Connection',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auto_config_route: Optional[pulumi.Input[_builtins.bool]] = None,
            bgp_config: Optional[pulumi.Input[Union['ConnectionBgpConfigArgs', 'ConnectionBgpConfigArgsDict']]] = None,
            create_time: Optional[pulumi.Input[_builtins.int]] = None,
            customer_gateway_id: Optional[pulumi.Input[_builtins.str]] = None,
            effect_immediately: Optional[pulumi.Input[_builtins.bool]] = None,
            enable_dpd: Optional[pulumi.Input[_builtins.bool]] = None,
            enable_nat_traversal: Optional[pulumi.Input[_builtins.bool]] = None,
            enable_tunnels_bgp: Optional[pulumi.Input[_builtins.bool]] = None,
            health_check_config: Optional[pulumi.Input[Union['ConnectionHealthCheckConfigArgs', 'ConnectionHealthCheckConfigArgsDict']]] = None,
            ike_config: Optional[pulumi.Input[Union['ConnectionIkeConfigArgs', 'ConnectionIkeConfigArgsDict']]] = None,
            ipsec_config: Optional[pulumi.Input[Union['ConnectionIpsecConfigArgs', 'ConnectionIpsecConfigArgsDict']]] = None,
            local_subnets: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            network_type: Optional[pulumi.Input[_builtins.str]] = None,
            remote_subnets: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tunnel_options_specifications: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ConnectionTunnelOptionsSpecificationArgs', 'ConnectionTunnelOptionsSpecificationArgsDict']]]]] = None,
            vpn_connection_name: Optional[pulumi.Input[_builtins.str]] = None,
            vpn_gateway_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'Connection':
        """
        Get an existing Connection resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] auto_config_route: Whether to configure routing automatically. Value:
               - **true**: Automatically configure routes.
               - **false**: does not automatically configure routes.
        :param pulumi.Input[Union['ConnectionBgpConfigArgs', 'ConnectionBgpConfigArgsDict']] bgp_config: vpnBgp configuration. See `bgp_config` below.
        :param pulumi.Input[_builtins.int] create_time: The time when the IPsec-VPN connection was created.
        :param pulumi.Input[_builtins.str] customer_gateway_id: The ID of the customer gateway.
        :param pulumi.Input[_builtins.bool] effect_immediately: Indicates whether IPsec-VPN negotiations are initiated immediately. Valid values.
        :param pulumi.Input[_builtins.bool] enable_dpd: Wether enable Dpd detection.
        :param pulumi.Input[_builtins.bool] enable_nat_traversal: enable nat traversal.
        :param pulumi.Input[_builtins.bool] enable_tunnels_bgp: Enable tunnel bgp.
        :param pulumi.Input[Union['ConnectionHealthCheckConfigArgs', 'ConnectionHealthCheckConfigArgsDict']] health_check_config: Health Check information. See `health_check_config` below.
        :param pulumi.Input[Union['ConnectionIkeConfigArgs', 'ConnectionIkeConfigArgsDict']] ike_config: The configuration of Phase 1 negotiations. See `ike_config` below.
        :param pulumi.Input[Union['ConnectionIpsecConfigArgs', 'ConnectionIpsecConfigArgsDict']] ipsec_config: IPsec configuration. See `ipsec_config` below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] local_subnets: The CIDR block of the VPC to be connected with the local data center. This parameter is used for phase-two negotiation.
        :param pulumi.Input[_builtins.str] name: . Field 'name' has been deprecated from provider version 1.216.0. New field 'vpn_connection_name' instead.
        :param pulumi.Input[_builtins.str] network_type: The network type of the IPsec connection. Value:
               - **public**: public network, indicating that the IPsec connection establishes an encrypted communication channel through the public network.
               - **private**: private network, indicating that the IPsec connection establishes an encrypted communication channel through the private network.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] remote_subnets: The CIDR block of the local data center. This parameter is used for phase-two negotiation.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group.
        :param pulumi.Input[_builtins.str] status: The negotiation status of Tunnel.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Tags.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ConnectionTunnelOptionsSpecificationArgs', 'ConnectionTunnelOptionsSpecificationArgsDict']]]] tunnel_options_specifications: The tunnel options of IPsec. See `tunnel_options_specification` below.
        :param pulumi.Input[_builtins.str] vpn_connection_name: The name of the IPsec-VPN connection.
        :param pulumi.Input[_builtins.str] vpn_gateway_id: The ID of the VPN gateway.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ConnectionState.__new__(_ConnectionState)

        __props__.__dict__["auto_config_route"] = auto_config_route
        __props__.__dict__["bgp_config"] = bgp_config
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["customer_gateway_id"] = customer_gateway_id
        __props__.__dict__["effect_immediately"] = effect_immediately
        __props__.__dict__["enable_dpd"] = enable_dpd
        __props__.__dict__["enable_nat_traversal"] = enable_nat_traversal
        __props__.__dict__["enable_tunnels_bgp"] = enable_tunnels_bgp
        __props__.__dict__["health_check_config"] = health_check_config
        __props__.__dict__["ike_config"] = ike_config
        __props__.__dict__["ipsec_config"] = ipsec_config
        __props__.__dict__["local_subnets"] = local_subnets
        __props__.__dict__["name"] = name
        __props__.__dict__["network_type"] = network_type
        __props__.__dict__["remote_subnets"] = remote_subnets
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tunnel_options_specifications"] = tunnel_options_specifications
        __props__.__dict__["vpn_connection_name"] = vpn_connection_name
        __props__.__dict__["vpn_gateway_id"] = vpn_gateway_id
        return Connection(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="autoConfigRoute")
    def auto_config_route(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to configure routing automatically. Value:
        - **true**: Automatically configure routes.
        - **false**: does not automatically configure routes.
        """
        return pulumi.get(self, "auto_config_route")

    @_builtins.property
    @pulumi.getter(name="bgpConfig")
    def bgp_config(self) -> pulumi.Output['outputs.ConnectionBgpConfig']:
        """
        vpnBgp configuration. See `bgp_config` below.
        """
        return pulumi.get(self, "bgp_config")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.int]:
        """
        The time when the IPsec-VPN connection was created.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="customerGatewayId")
    def customer_gateway_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the customer gateway.
        """
        return pulumi.get(self, "customer_gateway_id")

    @_builtins.property
    @pulumi.getter(name="effectImmediately")
    def effect_immediately(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Indicates whether IPsec-VPN negotiations are initiated immediately. Valid values.
        """
        return pulumi.get(self, "effect_immediately")

    @_builtins.property
    @pulumi.getter(name="enableDpd")
    def enable_dpd(self) -> pulumi.Output[_builtins.bool]:
        """
        Wether enable Dpd detection.
        """
        return pulumi.get(self, "enable_dpd")

    @_builtins.property
    @pulumi.getter(name="enableNatTraversal")
    def enable_nat_traversal(self) -> pulumi.Output[_builtins.bool]:
        """
        enable nat traversal.
        """
        return pulumi.get(self, "enable_nat_traversal")

    @_builtins.property
    @pulumi.getter(name="enableTunnelsBgp")
    def enable_tunnels_bgp(self) -> pulumi.Output[_builtins.bool]:
        """
        Enable tunnel bgp.
        """
        return pulumi.get(self, "enable_tunnels_bgp")

    @_builtins.property
    @pulumi.getter(name="healthCheckConfig")
    def health_check_config(self) -> pulumi.Output['outputs.ConnectionHealthCheckConfig']:
        """
        Health Check information. See `health_check_config` below.
        """
        return pulumi.get(self, "health_check_config")

    @_builtins.property
    @pulumi.getter(name="ikeConfig")
    def ike_config(self) -> pulumi.Output['outputs.ConnectionIkeConfig']:
        """
        The configuration of Phase 1 negotiations. See `ike_config` below.
        """
        return pulumi.get(self, "ike_config")

    @_builtins.property
    @pulumi.getter(name="ipsecConfig")
    def ipsec_config(self) -> pulumi.Output['outputs.ConnectionIpsecConfig']:
        """
        IPsec configuration. See `ipsec_config` below.
        """
        return pulumi.get(self, "ipsec_config")

    @_builtins.property
    @pulumi.getter(name="localSubnets")
    def local_subnets(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The CIDR block of the VPC to be connected with the local data center. This parameter is used for phase-two negotiation.
        """
        return pulumi.get(self, "local_subnets")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field 'name' has been deprecated since provider version 1.216.0. New field 'vpn_connection_name' instead.""")
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        . Field 'name' has been deprecated from provider version 1.216.0. New field 'vpn_connection_name' instead.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="networkType")
    def network_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The network type of the IPsec connection. Value:
        - **public**: public network, indicating that the IPsec connection establishes an encrypted communication channel through the public network.
        - **private**: private network, indicating that the IPsec connection establishes an encrypted communication channel through the private network.
        """
        return pulumi.get(self, "network_type")

    @_builtins.property
    @pulumi.getter(name="remoteSubnets")
    def remote_subnets(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The CIDR block of the local data center. This parameter is used for phase-two negotiation.
        """
        return pulumi.get(self, "remote_subnets")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The negotiation status of Tunnel.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Tags.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tunnelOptionsSpecifications")
    def tunnel_options_specifications(self) -> pulumi.Output[Optional[Sequence['outputs.ConnectionTunnelOptionsSpecification']]]:
        """
        The tunnel options of IPsec. See `tunnel_options_specification` below.
        """
        return pulumi.get(self, "tunnel_options_specifications")

    @_builtins.property
    @pulumi.getter(name="vpnConnectionName")
    def vpn_connection_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the IPsec-VPN connection.
        """
        return pulumi.get(self, "vpn_connection_name")

    @_builtins.property
    @pulumi.getter(name="vpnGatewayId")
    def vpn_gateway_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the VPN gateway.
        """
        return pulumi.get(self, "vpn_gateway_id")

