# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['GatewayArgs', 'Gateway']

@pulumi.input_type
class GatewayArgs:
    def __init__(__self__, *,
                 bandwidth: pulumi.Input[_builtins.int],
                 vpc_id: pulumi.Input[_builtins.str],
                 auto_pay: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_propagate: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disaster_recovery_vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_ipsec: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_ssl: Optional[pulumi.Input[_builtins.bool]] = None,
                 instance_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_type: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_connections: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpn_gateway_name: Optional[pulumi.Input[_builtins.str]] = None,
                 vpn_type: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Gateway resource.
        :param pulumi.Input[_builtins.int] bandwidth: The Bandwidth specification of the VPN gateway. Unit: Mbps.  If you want to create a public VPN gateway, the value is 5, 10, 20, 50, 100, 200, 500, or 1000. If you want to create a private VPN gateway, the value is 200 or 1000.
        :param pulumi.Input[_builtins.str] vpc_id: The ID of the VPC to which the VPN gateway belongs.
        :param pulumi.Input[_builtins.bool] auto_pay: Whether to pay automatically. Default value: `true`. Valid values:
        :param pulumi.Input[_builtins.bool] auto_propagate: Whether to automatically propagate the BGP route to the VPC. Value:  true: Propagate automatically.  false: does not propagate automatically.
        :param pulumi.Input[_builtins.str] description: The description of the VPN gateway.
        :param pulumi.Input[_builtins.str] disaster_recovery_vswitch_id: The ID of the backup VSwitch to which the VPN gateway is attached.
        :param pulumi.Input[_builtins.bool] enable_ipsec: Enable or Disable IPSec VPN. At least one type of VPN should be enabled.
        :param pulumi.Input[_builtins.bool] enable_ssl: Enable or Disable SSL VPN.  At least one type of VPN should be enabled.
               
               The following arguments will be discarded. Please use new fields as soon as possible:
        :param pulumi.Input[_builtins.str] instance_charge_type: . Field 'instance_charge_type' has been deprecated from provider version 1.216.0. New field 'payment_type' instead.
        :param pulumi.Input[_builtins.str] name: . Field 'name' has been deprecated from provider version 1.216.0. New field 'vpn_gateway_name' instead.
        :param pulumi.Input[_builtins.str] network_type: The network type of the VPN gateway. Value:  public (default): public VPN gateway. private: private network VPN gateway.
        :param pulumi.Input[_builtins.str] payment_type: Type of payment. Value: Subscription: prepaid PayAsYouGo: Post-paid.
        :param pulumi.Input[_builtins.int] period: The filed is only required while the InstanceChargeType is PrePaid. Valid values: [1-9, 12, 24, 36]. Default to 1.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group.
        :param pulumi.Input[_builtins.int] ssl_connections: Maximum number of clients.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The Tag of.
        :param pulumi.Input[_builtins.str] vpn_gateway_name: The name of the VPN gateway.
        :param pulumi.Input[_builtins.str] vpn_type: The VPN gateway type. Value:  Normal (default): Normal type. NationalStandard: National Secret type.
        :param pulumi.Input[_builtins.str] vswitch_id: The ID of the VSwitch to which the VPN gateway is attached.
        """
        pulumi.set(__self__, "bandwidth", bandwidth)
        pulumi.set(__self__, "vpc_id", vpc_id)
        if auto_pay is not None:
            pulumi.set(__self__, "auto_pay", auto_pay)
        if auto_propagate is not None:
            pulumi.set(__self__, "auto_propagate", auto_propagate)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disaster_recovery_vswitch_id is not None:
            pulumi.set(__self__, "disaster_recovery_vswitch_id", disaster_recovery_vswitch_id)
        if enable_ipsec is not None:
            pulumi.set(__self__, "enable_ipsec", enable_ipsec)
        if enable_ssl is not None:
            pulumi.set(__self__, "enable_ssl", enable_ssl)
        if instance_charge_type is not None:
            warnings.warn("""Field 'instance_charge_type' has been deprecated since provider version 1.215.0. New field 'payment_type' instead.""", DeprecationWarning)
            pulumi.log.warn("""instance_charge_type is deprecated: Field 'instance_charge_type' has been deprecated since provider version 1.215.0. New field 'payment_type' instead.""")
        if instance_charge_type is not None:
            pulumi.set(__self__, "instance_charge_type", instance_charge_type)
        if name is not None:
            warnings.warn("""Field 'name' has been deprecated since provider version 1.215.0. New field 'vpn_gateway_name' instead.""", DeprecationWarning)
            pulumi.log.warn("""name is deprecated: Field 'name' has been deprecated since provider version 1.215.0. New field 'vpn_gateway_name' instead.""")
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_type is not None:
            pulumi.set(__self__, "network_type", network_type)
        if payment_type is not None:
            pulumi.set(__self__, "payment_type", payment_type)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if ssl_connections is not None:
            pulumi.set(__self__, "ssl_connections", ssl_connections)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if vpn_gateway_name is not None:
            pulumi.set(__self__, "vpn_gateway_name", vpn_gateway_name)
        if vpn_type is not None:
            pulumi.set(__self__, "vpn_type", vpn_type)
        if vswitch_id is not None:
            pulumi.set(__self__, "vswitch_id", vswitch_id)

    @_builtins.property
    @pulumi.getter
    def bandwidth(self) -> pulumi.Input[_builtins.int]:
        """
        The Bandwidth specification of the VPN gateway. Unit: Mbps.  If you want to create a public VPN gateway, the value is 5, 10, 20, 50, 100, 200, 500, or 1000. If you want to create a private VPN gateway, the value is 200 or 1000.
        """
        return pulumi.get(self, "bandwidth")

    @bandwidth.setter
    def bandwidth(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "bandwidth", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the VPC to which the VPN gateway belongs.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vpc_id", value)

    @_builtins.property
    @pulumi.getter(name="autoPay")
    def auto_pay(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to pay automatically. Default value: `true`. Valid values:
        """
        return pulumi.get(self, "auto_pay")

    @auto_pay.setter
    def auto_pay(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_pay", value)

    @_builtins.property
    @pulumi.getter(name="autoPropagate")
    def auto_propagate(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to automatically propagate the BGP route to the VPC. Value:  true: Propagate automatically.  false: does not propagate automatically.
        """
        return pulumi.get(self, "auto_propagate")

    @auto_propagate.setter
    def auto_propagate(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_propagate", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the VPN gateway.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="disasterRecoveryVswitchId")
    def disaster_recovery_vswitch_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the backup VSwitch to which the VPN gateway is attached.
        """
        return pulumi.get(self, "disaster_recovery_vswitch_id")

    @disaster_recovery_vswitch_id.setter
    def disaster_recovery_vswitch_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "disaster_recovery_vswitch_id", value)

    @_builtins.property
    @pulumi.getter(name="enableIpsec")
    def enable_ipsec(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable or Disable IPSec VPN. At least one type of VPN should be enabled.
        """
        return pulumi.get(self, "enable_ipsec")

    @enable_ipsec.setter
    def enable_ipsec(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_ipsec", value)

    @_builtins.property
    @pulumi.getter(name="enableSsl")
    def enable_ssl(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable or Disable SSL VPN.  At least one type of VPN should be enabled.

        The following arguments will be discarded. Please use new fields as soon as possible:
        """
        return pulumi.get(self, "enable_ssl")

    @enable_ssl.setter
    def enable_ssl(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_ssl", value)

    @_builtins.property
    @pulumi.getter(name="instanceChargeType")
    @_utilities.deprecated("""Field 'instance_charge_type' has been deprecated since provider version 1.215.0. New field 'payment_type' instead.""")
    def instance_charge_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        . Field 'instance_charge_type' has been deprecated from provider version 1.216.0. New field 'payment_type' instead.
        """
        return pulumi.get(self, "instance_charge_type")

    @instance_charge_type.setter
    def instance_charge_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_charge_type", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field 'name' has been deprecated since provider version 1.215.0. New field 'vpn_gateway_name' instead.""")
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        . Field 'name' has been deprecated from provider version 1.216.0. New field 'vpn_gateway_name' instead.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networkType")
    def network_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The network type of the VPN gateway. Value:  public (default): public VPN gateway. private: private network VPN gateway.
        """
        return pulumi.get(self, "network_type")

    @network_type.setter
    def network_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_type", value)

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of payment. Value: Subscription: prepaid PayAsYouGo: Post-paid.
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "payment_type", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The filed is only required while the InstanceChargeType is PrePaid. Valid values: [1-9, 12, 24, 36]. Default to 1.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter(name="sslConnections")
    def ssl_connections(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Maximum number of clients.
        """
        return pulumi.get(self, "ssl_connections")

    @ssl_connections.setter
    def ssl_connections(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ssl_connections", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The Tag of.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="vpnGatewayName")
    def vpn_gateway_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the VPN gateway.
        """
        return pulumi.get(self, "vpn_gateway_name")

    @vpn_gateway_name.setter
    def vpn_gateway_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpn_gateway_name", value)

    @_builtins.property
    @pulumi.getter(name="vpnType")
    def vpn_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The VPN gateway type. Value:  Normal (default): Normal type. NationalStandard: National Secret type.
        """
        return pulumi.get(self, "vpn_type")

    @vpn_type.setter
    def vpn_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpn_type", value)

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the VSwitch to which the VPN gateway is attached.
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vswitch_id", value)


@pulumi.input_type
class _GatewayState:
    def __init__(__self__, *,
                 auto_pay: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_propagate: Optional[pulumi.Input[_builtins.bool]] = None,
                 bandwidth: Optional[pulumi.Input[_builtins.int]] = None,
                 business_status: Optional[pulumi.Input[_builtins.str]] = None,
                 create_time: Optional[pulumi.Input[_builtins.int]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disaster_recovery_internet_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 disaster_recovery_vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_ipsec: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_ssl: Optional[pulumi.Input[_builtins.bool]] = None,
                 instance_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 internet_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_type: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_connections: Optional[pulumi.Input[_builtins.int]] = None,
                 ssl_vpn_internet_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vpn_gateway_name: Optional[pulumi.Input[_builtins.str]] = None,
                 vpn_type: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Gateway resources.
        :param pulumi.Input[_builtins.bool] auto_pay: Whether to pay automatically. Default value: `true`. Valid values:
        :param pulumi.Input[_builtins.bool] auto_propagate: Whether to automatically propagate the BGP route to the VPC. Value:  true: Propagate automatically.  false: does not propagate automatically.
        :param pulumi.Input[_builtins.int] bandwidth: The Bandwidth specification of the VPN gateway. Unit: Mbps.  If you want to create a public VPN gateway, the value is 5, 10, 20, 50, 100, 200, 500, or 1000. If you want to create a private VPN gateway, the value is 200 or 1000.
        :param pulumi.Input[_builtins.str] business_status: The business status of the VPN gateway.
        :param pulumi.Input[_builtins.int] create_time: The time when the VPN gateway was created.
        :param pulumi.Input[_builtins.str] description: The description of the VPN gateway.
        :param pulumi.Input[_builtins.str] disaster_recovery_internet_ip: The backup public IP address of the VPN gateway. The second IP address assigned by the system to create an IPsec-VPN connection. This parameter is returned only when the VPN gateway supports the dual-tunnel mode.
        :param pulumi.Input[_builtins.str] disaster_recovery_vswitch_id: The ID of the backup VSwitch to which the VPN gateway is attached.
        :param pulumi.Input[_builtins.bool] enable_ipsec: Enable or Disable IPSec VPN. At least one type of VPN should be enabled.
        :param pulumi.Input[_builtins.bool] enable_ssl: Enable or Disable SSL VPN.  At least one type of VPN should be enabled.
               
               The following arguments will be discarded. Please use new fields as soon as possible:
        :param pulumi.Input[_builtins.str] instance_charge_type: . Field 'instance_charge_type' has been deprecated from provider version 1.216.0. New field 'payment_type' instead.
        :param pulumi.Input[_builtins.str] internet_ip: The internet ip of the VPN.
        :param pulumi.Input[_builtins.str] name: . Field 'name' has been deprecated from provider version 1.216.0. New field 'vpn_gateway_name' instead.
        :param pulumi.Input[_builtins.str] network_type: The network type of the VPN gateway. Value:  public (default): public VPN gateway. private: private network VPN gateway.
        :param pulumi.Input[_builtins.str] payment_type: Type of payment. Value: Subscription: prepaid PayAsYouGo: Post-paid.
        :param pulumi.Input[_builtins.int] period: The filed is only required while the InstanceChargeType is PrePaid. Valid values: [1-9, 12, 24, 36]. Default to 1.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group.
        :param pulumi.Input[_builtins.int] ssl_connections: Maximum number of clients.
        :param pulumi.Input[_builtins.str] ssl_vpn_internet_ip: The IP address of the SSL-VPN connection. This parameter is returned only when the VPN gateway is a public VPN gateway and supports only the single-tunnel mode. In addition, the VPN gateway must have the SSL-VPN feature enabled.
        :param pulumi.Input[_builtins.str] status: The status of the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The Tag of.
        :param pulumi.Input[_builtins.str] vpc_id: The ID of the VPC to which the VPN gateway belongs.
        :param pulumi.Input[_builtins.str] vpn_gateway_name: The name of the VPN gateway.
        :param pulumi.Input[_builtins.str] vpn_type: The VPN gateway type. Value:  Normal (default): Normal type. NationalStandard: National Secret type.
        :param pulumi.Input[_builtins.str] vswitch_id: The ID of the VSwitch to which the VPN gateway is attached.
        """
        if auto_pay is not None:
            pulumi.set(__self__, "auto_pay", auto_pay)
        if auto_propagate is not None:
            pulumi.set(__self__, "auto_propagate", auto_propagate)
        if bandwidth is not None:
            pulumi.set(__self__, "bandwidth", bandwidth)
        if business_status is not None:
            pulumi.set(__self__, "business_status", business_status)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disaster_recovery_internet_ip is not None:
            pulumi.set(__self__, "disaster_recovery_internet_ip", disaster_recovery_internet_ip)
        if disaster_recovery_vswitch_id is not None:
            pulumi.set(__self__, "disaster_recovery_vswitch_id", disaster_recovery_vswitch_id)
        if enable_ipsec is not None:
            pulumi.set(__self__, "enable_ipsec", enable_ipsec)
        if enable_ssl is not None:
            pulumi.set(__self__, "enable_ssl", enable_ssl)
        if instance_charge_type is not None:
            warnings.warn("""Field 'instance_charge_type' has been deprecated since provider version 1.215.0. New field 'payment_type' instead.""", DeprecationWarning)
            pulumi.log.warn("""instance_charge_type is deprecated: Field 'instance_charge_type' has been deprecated since provider version 1.215.0. New field 'payment_type' instead.""")
        if instance_charge_type is not None:
            pulumi.set(__self__, "instance_charge_type", instance_charge_type)
        if internet_ip is not None:
            pulumi.set(__self__, "internet_ip", internet_ip)
        if name is not None:
            warnings.warn("""Field 'name' has been deprecated since provider version 1.215.0. New field 'vpn_gateway_name' instead.""", DeprecationWarning)
            pulumi.log.warn("""name is deprecated: Field 'name' has been deprecated since provider version 1.215.0. New field 'vpn_gateway_name' instead.""")
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_type is not None:
            pulumi.set(__self__, "network_type", network_type)
        if payment_type is not None:
            pulumi.set(__self__, "payment_type", payment_type)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if ssl_connections is not None:
            pulumi.set(__self__, "ssl_connections", ssl_connections)
        if ssl_vpn_internet_ip is not None:
            pulumi.set(__self__, "ssl_vpn_internet_ip", ssl_vpn_internet_ip)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if vpn_gateway_name is not None:
            pulumi.set(__self__, "vpn_gateway_name", vpn_gateway_name)
        if vpn_type is not None:
            pulumi.set(__self__, "vpn_type", vpn_type)
        if vswitch_id is not None:
            pulumi.set(__self__, "vswitch_id", vswitch_id)

    @_builtins.property
    @pulumi.getter(name="autoPay")
    def auto_pay(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to pay automatically. Default value: `true`. Valid values:
        """
        return pulumi.get(self, "auto_pay")

    @auto_pay.setter
    def auto_pay(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_pay", value)

    @_builtins.property
    @pulumi.getter(name="autoPropagate")
    def auto_propagate(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to automatically propagate the BGP route to the VPC. Value:  true: Propagate automatically.  false: does not propagate automatically.
        """
        return pulumi.get(self, "auto_propagate")

    @auto_propagate.setter
    def auto_propagate(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_propagate", value)

    @_builtins.property
    @pulumi.getter
    def bandwidth(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The Bandwidth specification of the VPN gateway. Unit: Mbps.  If you want to create a public VPN gateway, the value is 5, 10, 20, 50, 100, 200, 500, or 1000. If you want to create a private VPN gateway, the value is 200 or 1000.
        """
        return pulumi.get(self, "bandwidth")

    @bandwidth.setter
    def bandwidth(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "bandwidth", value)

    @_builtins.property
    @pulumi.getter(name="businessStatus")
    def business_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The business status of the VPN gateway.
        """
        return pulumi.get(self, "business_status")

    @business_status.setter
    def business_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "business_status", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The time when the VPN gateway was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the VPN gateway.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="disasterRecoveryInternetIp")
    def disaster_recovery_internet_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The backup public IP address of the VPN gateway. The second IP address assigned by the system to create an IPsec-VPN connection. This parameter is returned only when the VPN gateway supports the dual-tunnel mode.
        """
        return pulumi.get(self, "disaster_recovery_internet_ip")

    @disaster_recovery_internet_ip.setter
    def disaster_recovery_internet_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "disaster_recovery_internet_ip", value)

    @_builtins.property
    @pulumi.getter(name="disasterRecoveryVswitchId")
    def disaster_recovery_vswitch_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the backup VSwitch to which the VPN gateway is attached.
        """
        return pulumi.get(self, "disaster_recovery_vswitch_id")

    @disaster_recovery_vswitch_id.setter
    def disaster_recovery_vswitch_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "disaster_recovery_vswitch_id", value)

    @_builtins.property
    @pulumi.getter(name="enableIpsec")
    def enable_ipsec(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable or Disable IPSec VPN. At least one type of VPN should be enabled.
        """
        return pulumi.get(self, "enable_ipsec")

    @enable_ipsec.setter
    def enable_ipsec(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_ipsec", value)

    @_builtins.property
    @pulumi.getter(name="enableSsl")
    def enable_ssl(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable or Disable SSL VPN.  At least one type of VPN should be enabled.

        The following arguments will be discarded. Please use new fields as soon as possible:
        """
        return pulumi.get(self, "enable_ssl")

    @enable_ssl.setter
    def enable_ssl(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_ssl", value)

    @_builtins.property
    @pulumi.getter(name="instanceChargeType")
    @_utilities.deprecated("""Field 'instance_charge_type' has been deprecated since provider version 1.215.0. New field 'payment_type' instead.""")
    def instance_charge_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        . Field 'instance_charge_type' has been deprecated from provider version 1.216.0. New field 'payment_type' instead.
        """
        return pulumi.get(self, "instance_charge_type")

    @instance_charge_type.setter
    def instance_charge_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_charge_type", value)

    @_builtins.property
    @pulumi.getter(name="internetIp")
    def internet_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The internet ip of the VPN.
        """
        return pulumi.get(self, "internet_ip")

    @internet_ip.setter
    def internet_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "internet_ip", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field 'name' has been deprecated since provider version 1.215.0. New field 'vpn_gateway_name' instead.""")
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        . Field 'name' has been deprecated from provider version 1.216.0. New field 'vpn_gateway_name' instead.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networkType")
    def network_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The network type of the VPN gateway. Value:  public (default): public VPN gateway. private: private network VPN gateway.
        """
        return pulumi.get(self, "network_type")

    @network_type.setter
    def network_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_type", value)

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of payment. Value: Subscription: prepaid PayAsYouGo: Post-paid.
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "payment_type", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The filed is only required while the InstanceChargeType is PrePaid. Valid values: [1-9, 12, 24, 36]. Default to 1.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter(name="sslConnections")
    def ssl_connections(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Maximum number of clients.
        """
        return pulumi.get(self, "ssl_connections")

    @ssl_connections.setter
    def ssl_connections(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ssl_connections", value)

    @_builtins.property
    @pulumi.getter(name="sslVpnInternetIp")
    def ssl_vpn_internet_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IP address of the SSL-VPN connection. This parameter is returned only when the VPN gateway is a public VPN gateway and supports only the single-tunnel mode. In addition, the VPN gateway must have the SSL-VPN feature enabled.
        """
        return pulumi.get(self, "ssl_vpn_internet_ip")

    @ssl_vpn_internet_ip.setter
    def ssl_vpn_internet_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ssl_vpn_internet_ip", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the resource.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The Tag of.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the VPC to which the VPN gateway belongs.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)

    @_builtins.property
    @pulumi.getter(name="vpnGatewayName")
    def vpn_gateway_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the VPN gateway.
        """
        return pulumi.get(self, "vpn_gateway_name")

    @vpn_gateway_name.setter
    def vpn_gateway_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpn_gateway_name", value)

    @_builtins.property
    @pulumi.getter(name="vpnType")
    def vpn_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The VPN gateway type. Value:  Normal (default): Normal type. NationalStandard: National Secret type.
        """
        return pulumi.get(self, "vpn_type")

    @vpn_type.setter
    def vpn_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpn_type", value)

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the VSwitch to which the VPN gateway is attached.
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vswitch_id", value)


@pulumi.type_token("alicloud:vpn/gateway:Gateway")
class Gateway(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_pay: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_propagate: Optional[pulumi.Input[_builtins.bool]] = None,
                 bandwidth: Optional[pulumi.Input[_builtins.int]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disaster_recovery_vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_ipsec: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_ssl: Optional[pulumi.Input[_builtins.bool]] = None,
                 instance_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_type: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_connections: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vpn_gateway_name: Optional[pulumi.Input[_builtins.str]] = None,
                 vpn_type: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Import

        VPN gateway can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:vpn/gateway:Gateway example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] auto_pay: Whether to pay automatically. Default value: `true`. Valid values:
        :param pulumi.Input[_builtins.bool] auto_propagate: Whether to automatically propagate the BGP route to the VPC. Value:  true: Propagate automatically.  false: does not propagate automatically.
        :param pulumi.Input[_builtins.int] bandwidth: The Bandwidth specification of the VPN gateway. Unit: Mbps.  If you want to create a public VPN gateway, the value is 5, 10, 20, 50, 100, 200, 500, or 1000. If you want to create a private VPN gateway, the value is 200 or 1000.
        :param pulumi.Input[_builtins.str] description: The description of the VPN gateway.
        :param pulumi.Input[_builtins.str] disaster_recovery_vswitch_id: The ID of the backup VSwitch to which the VPN gateway is attached.
        :param pulumi.Input[_builtins.bool] enable_ipsec: Enable or Disable IPSec VPN. At least one type of VPN should be enabled.
        :param pulumi.Input[_builtins.bool] enable_ssl: Enable or Disable SSL VPN.  At least one type of VPN should be enabled.
               
               The following arguments will be discarded. Please use new fields as soon as possible:
        :param pulumi.Input[_builtins.str] instance_charge_type: . Field 'instance_charge_type' has been deprecated from provider version 1.216.0. New field 'payment_type' instead.
        :param pulumi.Input[_builtins.str] name: . Field 'name' has been deprecated from provider version 1.216.0. New field 'vpn_gateway_name' instead.
        :param pulumi.Input[_builtins.str] network_type: The network type of the VPN gateway. Value:  public (default): public VPN gateway. private: private network VPN gateway.
        :param pulumi.Input[_builtins.str] payment_type: Type of payment. Value: Subscription: prepaid PayAsYouGo: Post-paid.
        :param pulumi.Input[_builtins.int] period: The filed is only required while the InstanceChargeType is PrePaid. Valid values: [1-9, 12, 24, 36]. Default to 1.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group.
        :param pulumi.Input[_builtins.int] ssl_connections: Maximum number of clients.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The Tag of.
        :param pulumi.Input[_builtins.str] vpc_id: The ID of the VPC to which the VPN gateway belongs.
        :param pulumi.Input[_builtins.str] vpn_gateway_name: The name of the VPN gateway.
        :param pulumi.Input[_builtins.str] vpn_type: The VPN gateway type. Value:  Normal (default): Normal type. NationalStandard: National Secret type.
        :param pulumi.Input[_builtins.str] vswitch_id: The ID of the VSwitch to which the VPN gateway is attached.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GatewayArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        VPN gateway can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:vpn/gateway:Gateway example <id>
        ```

        :param str resource_name: The name of the resource.
        :param GatewayArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GatewayArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_pay: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_propagate: Optional[pulumi.Input[_builtins.bool]] = None,
                 bandwidth: Optional[pulumi.Input[_builtins.int]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disaster_recovery_vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_ipsec: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_ssl: Optional[pulumi.Input[_builtins.bool]] = None,
                 instance_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_type: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_connections: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vpn_gateway_name: Optional[pulumi.Input[_builtins.str]] = None,
                 vpn_type: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GatewayArgs.__new__(GatewayArgs)

            __props__.__dict__["auto_pay"] = auto_pay
            __props__.__dict__["auto_propagate"] = auto_propagate
            if bandwidth is None and not opts.urn:
                raise TypeError("Missing required property 'bandwidth'")
            __props__.__dict__["bandwidth"] = bandwidth
            __props__.__dict__["description"] = description
            __props__.__dict__["disaster_recovery_vswitch_id"] = disaster_recovery_vswitch_id
            __props__.__dict__["enable_ipsec"] = enable_ipsec
            __props__.__dict__["enable_ssl"] = enable_ssl
            __props__.__dict__["instance_charge_type"] = instance_charge_type
            __props__.__dict__["name"] = name
            __props__.__dict__["network_type"] = network_type
            __props__.__dict__["payment_type"] = payment_type
            __props__.__dict__["period"] = period
            __props__.__dict__["resource_group_id"] = resource_group_id
            __props__.__dict__["ssl_connections"] = ssl_connections
            __props__.__dict__["tags"] = tags
            if vpc_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_id'")
            __props__.__dict__["vpc_id"] = vpc_id
            __props__.__dict__["vpn_gateway_name"] = vpn_gateway_name
            __props__.__dict__["vpn_type"] = vpn_type
            __props__.__dict__["vswitch_id"] = vswitch_id
            __props__.__dict__["business_status"] = None
            __props__.__dict__["create_time"] = None
            __props__.__dict__["disaster_recovery_internet_ip"] = None
            __props__.__dict__["internet_ip"] = None
            __props__.__dict__["ssl_vpn_internet_ip"] = None
            __props__.__dict__["status"] = None
        super(Gateway, __self__).__init__(
            'alicloud:vpn/gateway:Gateway',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auto_pay: Optional[pulumi.Input[_builtins.bool]] = None,
            auto_propagate: Optional[pulumi.Input[_builtins.bool]] = None,
            bandwidth: Optional[pulumi.Input[_builtins.int]] = None,
            business_status: Optional[pulumi.Input[_builtins.str]] = None,
            create_time: Optional[pulumi.Input[_builtins.int]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            disaster_recovery_internet_ip: Optional[pulumi.Input[_builtins.str]] = None,
            disaster_recovery_vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
            enable_ipsec: Optional[pulumi.Input[_builtins.bool]] = None,
            enable_ssl: Optional[pulumi.Input[_builtins.bool]] = None,
            instance_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
            internet_ip: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            network_type: Optional[pulumi.Input[_builtins.str]] = None,
            payment_type: Optional[pulumi.Input[_builtins.str]] = None,
            period: Optional[pulumi.Input[_builtins.int]] = None,
            resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            ssl_connections: Optional[pulumi.Input[_builtins.int]] = None,
            ssl_vpn_internet_ip: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
            vpn_gateway_name: Optional[pulumi.Input[_builtins.str]] = None,
            vpn_type: Optional[pulumi.Input[_builtins.str]] = None,
            vswitch_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'Gateway':
        """
        Get an existing Gateway resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] auto_pay: Whether to pay automatically. Default value: `true`. Valid values:
        :param pulumi.Input[_builtins.bool] auto_propagate: Whether to automatically propagate the BGP route to the VPC. Value:  true: Propagate automatically.  false: does not propagate automatically.
        :param pulumi.Input[_builtins.int] bandwidth: The Bandwidth specification of the VPN gateway. Unit: Mbps.  If you want to create a public VPN gateway, the value is 5, 10, 20, 50, 100, 200, 500, or 1000. If you want to create a private VPN gateway, the value is 200 or 1000.
        :param pulumi.Input[_builtins.str] business_status: The business status of the VPN gateway.
        :param pulumi.Input[_builtins.int] create_time: The time when the VPN gateway was created.
        :param pulumi.Input[_builtins.str] description: The description of the VPN gateway.
        :param pulumi.Input[_builtins.str] disaster_recovery_internet_ip: The backup public IP address of the VPN gateway. The second IP address assigned by the system to create an IPsec-VPN connection. This parameter is returned only when the VPN gateway supports the dual-tunnel mode.
        :param pulumi.Input[_builtins.str] disaster_recovery_vswitch_id: The ID of the backup VSwitch to which the VPN gateway is attached.
        :param pulumi.Input[_builtins.bool] enable_ipsec: Enable or Disable IPSec VPN. At least one type of VPN should be enabled.
        :param pulumi.Input[_builtins.bool] enable_ssl: Enable or Disable SSL VPN.  At least one type of VPN should be enabled.
               
               The following arguments will be discarded. Please use new fields as soon as possible:
        :param pulumi.Input[_builtins.str] instance_charge_type: . Field 'instance_charge_type' has been deprecated from provider version 1.216.0. New field 'payment_type' instead.
        :param pulumi.Input[_builtins.str] internet_ip: The internet ip of the VPN.
        :param pulumi.Input[_builtins.str] name: . Field 'name' has been deprecated from provider version 1.216.0. New field 'vpn_gateway_name' instead.
        :param pulumi.Input[_builtins.str] network_type: The network type of the VPN gateway. Value:  public (default): public VPN gateway. private: private network VPN gateway.
        :param pulumi.Input[_builtins.str] payment_type: Type of payment. Value: Subscription: prepaid PayAsYouGo: Post-paid.
        :param pulumi.Input[_builtins.int] period: The filed is only required while the InstanceChargeType is PrePaid. Valid values: [1-9, 12, 24, 36]. Default to 1.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group.
        :param pulumi.Input[_builtins.int] ssl_connections: Maximum number of clients.
        :param pulumi.Input[_builtins.str] ssl_vpn_internet_ip: The IP address of the SSL-VPN connection. This parameter is returned only when the VPN gateway is a public VPN gateway and supports only the single-tunnel mode. In addition, the VPN gateway must have the SSL-VPN feature enabled.
        :param pulumi.Input[_builtins.str] status: The status of the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The Tag of.
        :param pulumi.Input[_builtins.str] vpc_id: The ID of the VPC to which the VPN gateway belongs.
        :param pulumi.Input[_builtins.str] vpn_gateway_name: The name of the VPN gateway.
        :param pulumi.Input[_builtins.str] vpn_type: The VPN gateway type. Value:  Normal (default): Normal type. NationalStandard: National Secret type.
        :param pulumi.Input[_builtins.str] vswitch_id: The ID of the VSwitch to which the VPN gateway is attached.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GatewayState.__new__(_GatewayState)

        __props__.__dict__["auto_pay"] = auto_pay
        __props__.__dict__["auto_propagate"] = auto_propagate
        __props__.__dict__["bandwidth"] = bandwidth
        __props__.__dict__["business_status"] = business_status
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["description"] = description
        __props__.__dict__["disaster_recovery_internet_ip"] = disaster_recovery_internet_ip
        __props__.__dict__["disaster_recovery_vswitch_id"] = disaster_recovery_vswitch_id
        __props__.__dict__["enable_ipsec"] = enable_ipsec
        __props__.__dict__["enable_ssl"] = enable_ssl
        __props__.__dict__["instance_charge_type"] = instance_charge_type
        __props__.__dict__["internet_ip"] = internet_ip
        __props__.__dict__["name"] = name
        __props__.__dict__["network_type"] = network_type
        __props__.__dict__["payment_type"] = payment_type
        __props__.__dict__["period"] = period
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["ssl_connections"] = ssl_connections
        __props__.__dict__["ssl_vpn_internet_ip"] = ssl_vpn_internet_ip
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["vpc_id"] = vpc_id
        __props__.__dict__["vpn_gateway_name"] = vpn_gateway_name
        __props__.__dict__["vpn_type"] = vpn_type
        __props__.__dict__["vswitch_id"] = vswitch_id
        return Gateway(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="autoPay")
    def auto_pay(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to pay automatically. Default value: `true`. Valid values:
        """
        return pulumi.get(self, "auto_pay")

    @_builtins.property
    @pulumi.getter(name="autoPropagate")
    def auto_propagate(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to automatically propagate the BGP route to the VPC. Value:  true: Propagate automatically.  false: does not propagate automatically.
        """
        return pulumi.get(self, "auto_propagate")

    @_builtins.property
    @pulumi.getter
    def bandwidth(self) -> pulumi.Output[_builtins.int]:
        """
        The Bandwidth specification of the VPN gateway. Unit: Mbps.  If you want to create a public VPN gateway, the value is 5, 10, 20, 50, 100, 200, 500, or 1000. If you want to create a private VPN gateway, the value is 200 or 1000.
        """
        return pulumi.get(self, "bandwidth")

    @_builtins.property
    @pulumi.getter(name="businessStatus")
    def business_status(self) -> pulumi.Output[_builtins.str]:
        """
        The business status of the VPN gateway.
        """
        return pulumi.get(self, "business_status")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.int]:
        """
        The time when the VPN gateway was created.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the VPN gateway.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="disasterRecoveryInternetIp")
    def disaster_recovery_internet_ip(self) -> pulumi.Output[_builtins.str]:
        """
        The backup public IP address of the VPN gateway. The second IP address assigned by the system to create an IPsec-VPN connection. This parameter is returned only when the VPN gateway supports the dual-tunnel mode.
        """
        return pulumi.get(self, "disaster_recovery_internet_ip")

    @_builtins.property
    @pulumi.getter(name="disasterRecoveryVswitchId")
    def disaster_recovery_vswitch_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the backup VSwitch to which the VPN gateway is attached.
        """
        return pulumi.get(self, "disaster_recovery_vswitch_id")

    @_builtins.property
    @pulumi.getter(name="enableIpsec")
    def enable_ipsec(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Enable or Disable IPSec VPN. At least one type of VPN should be enabled.
        """
        return pulumi.get(self, "enable_ipsec")

    @_builtins.property
    @pulumi.getter(name="enableSsl")
    def enable_ssl(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Enable or Disable SSL VPN.  At least one type of VPN should be enabled.

        The following arguments will be discarded. Please use new fields as soon as possible:
        """
        return pulumi.get(self, "enable_ssl")

    @_builtins.property
    @pulumi.getter(name="instanceChargeType")
    @_utilities.deprecated("""Field 'instance_charge_type' has been deprecated since provider version 1.215.0. New field 'payment_type' instead.""")
    def instance_charge_type(self) -> pulumi.Output[_builtins.str]:
        """
        . Field 'instance_charge_type' has been deprecated from provider version 1.216.0. New field 'payment_type' instead.
        """
        return pulumi.get(self, "instance_charge_type")

    @_builtins.property
    @pulumi.getter(name="internetIp")
    def internet_ip(self) -> pulumi.Output[_builtins.str]:
        """
        The internet ip of the VPN.
        """
        return pulumi.get(self, "internet_ip")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field 'name' has been deprecated since provider version 1.215.0. New field 'vpn_gateway_name' instead.""")
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        . Field 'name' has been deprecated from provider version 1.216.0. New field 'vpn_gateway_name' instead.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="networkType")
    def network_type(self) -> pulumi.Output[_builtins.str]:
        """
        The network type of the VPN gateway. Value:  public (default): public VPN gateway. private: private network VPN gateway.
        """
        return pulumi.get(self, "network_type")

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> pulumi.Output[_builtins.str]:
        """
        Type of payment. Value: Subscription: prepaid PayAsYouGo: Post-paid.
        """
        return pulumi.get(self, "payment_type")

    @_builtins.property
    @pulumi.getter
    def period(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The filed is only required while the InstanceChargeType is PrePaid. Valid values: [1-9, 12, 24, 36]. Default to 1.
        """
        return pulumi.get(self, "period")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter(name="sslConnections")
    def ssl_connections(self) -> pulumi.Output[_builtins.int]:
        """
        Maximum number of clients.
        """
        return pulumi.get(self, "ssl_connections")

    @_builtins.property
    @pulumi.getter(name="sslVpnInternetIp")
    def ssl_vpn_internet_ip(self) -> pulumi.Output[_builtins.str]:
        """
        The IP address of the SSL-VPN connection. This parameter is returned only when the VPN gateway is a public VPN gateway and supports only the single-tunnel mode. In addition, the VPN gateway must have the SSL-VPN feature enabled.
        """
        return pulumi.get(self, "ssl_vpn_internet_ip")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the resource.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        The Tag of.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the VPC to which the VPN gateway belongs.
        """
        return pulumi.get(self, "vpc_id")

    @_builtins.property
    @pulumi.getter(name="vpnGatewayName")
    def vpn_gateway_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the VPN gateway.
        """
        return pulumi.get(self, "vpn_gateway_name")

    @_builtins.property
    @pulumi.getter(name="vpnType")
    def vpn_type(self) -> pulumi.Output[_builtins.str]:
        """
        The VPN gateway type. Value:  Normal (default): Normal type. NationalStandard: National Secret type.
        """
        return pulumi.get(self, "vpn_type")

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the VSwitch to which the VPN gateway is attached.
        """
        return pulumi.get(self, "vswitch_id")

