# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['GatewayVpnAttachmentArgs', 'GatewayVpnAttachment']

@pulumi.input_type
class GatewayVpnAttachmentArgs:
    def __init__(__self__, *,
                 local_subnet: pulumi.Input[_builtins.str],
                 remote_subnet: pulumi.Input[_builtins.str],
                 bgp_config: Optional[pulumi.Input['GatewayVpnAttachmentBgpConfigArgs']] = None,
                 customer_gateway_id: Optional[pulumi.Input[_builtins.str]] = None,
                 effect_immediately: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_dpd: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_nat_traversal: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_tunnels_bgp: Optional[pulumi.Input[_builtins.bool]] = None,
                 health_check_config: Optional[pulumi.Input['GatewayVpnAttachmentHealthCheckConfigArgs']] = None,
                 ike_config: Optional[pulumi.Input['GatewayVpnAttachmentIkeConfigArgs']] = None,
                 ipsec_config: Optional[pulumi.Input['GatewayVpnAttachmentIpsecConfigArgs']] = None,
                 network_type: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tunnel_options_specifications: Optional[pulumi.Input[Sequence[pulumi.Input['GatewayVpnAttachmentTunnelOptionsSpecificationArgs']]]] = None,
                 vpn_attachment_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a GatewayVpnAttachment resource.
        :param pulumi.Input[_builtins.str] local_subnet: The CIDR block on the VPC side. The CIDR block is used in Phase 2 negotiations.Separate multiple CIDR blocks with commas (,). Example: 192.168.1.0/24,192.168.2.0/24.The following routing modes are supported:
               - If you set LocalSubnet and RemoteSubnet to 0.0.0.0/0, the routing mode of the IPsec-VPN connection is set to Destination Routing Mode.
               - If you set LocalSubnet and RemoteSubnet to specific CIDR blocks, the routing mode of the IPsec-VPN connection is set to Protected Data Flows.
        :param pulumi.Input[_builtins.str] remote_subnet: The CIDR block on the data center side. This CIDR block is used in Phase 2 negotiations.Separate multiple CIDR blocks with commas (,). Example: 192.168.3.0/24,192.168.4.0/24.The following routing modes are supported:
               - If you set LocalSubnet and RemoteSubnet to 0.0.0.0/0, the routing mode of the IPsec-VPN connection is set to Destination Routing Mode.
               - If you set LocalSubnet and RemoteSubnet to specific CIDR blocks, the routing mode of the IPsec-VPN connection is set to Protected Data Flows.
        :param pulumi.Input['GatewayVpnAttachmentBgpConfigArgs'] bgp_config: Bgp configuration information.
               - This parameter is supported when you create an vpn attachment in single-tunnel mode. See `bgp_config` below.
        :param pulumi.Input[_builtins.str] customer_gateway_id: Customer gateway ID.
               - This parameter is required when creating a single-tunnel mode vpn attachment.
        :param pulumi.Input[_builtins.bool] effect_immediately: Specifies whether to immediately start IPsec negotiations after the configuration takes effect. Valid values:
        :param pulumi.Input[_builtins.bool] enable_dpd: This parameter is supported if you create an vpn attachment in single-tunnel mode.
               Whether to enable the DPD (peer survival detection) function.
               - true (default): enables DPD. The initiator of the IPsec-VPN connection sends DPD packets to check the existence and availability of the peer. If no feedback is received from the peer within the specified period of time, the connection fails. In this case, ISAKMP SA and IPsec SA are deleted along with the security tunnel.
               - false: disables DPD. The initiator of the IPsec-VPN connection does not send DPD packets.
        :param pulumi.Input[_builtins.bool] enable_nat_traversal: This parameter is supported if you create an vpn attachment in single-tunnel mode.
               Specifies whether to enable NAT traversal. Valid values:
               - true (default): enables NAT traversal. After NAT traversal is enabled, the initiator does not check the UDP ports during IKE negotiations and can automatically discover NAT gateway devices along the vpn attachment tunnel.
               - false: disables NAT traversal.
        :param pulumi.Input[_builtins.bool] enable_tunnels_bgp: You can configure this parameter when you create a vpn attachment in dual-tunnel mode.Whether to enable the BGP function for the tunnel. Value: `true` or `false` (default).
               
               > **NOTE:**  before adding BGP configuration, we recommend that you understand the working mechanism and usage restrictions of the BGP dynamic routing function.
        :param pulumi.Input['GatewayVpnAttachmentHealthCheckConfigArgs'] health_check_config: This parameter is supported if you create an vpn attachment in single-tunnel mode.
               Health check configuration information. See `health_check_config` below.
        :param pulumi.Input['GatewayVpnAttachmentIkeConfigArgs'] ike_config: The configurations of Phase 1 negotiations. 
               - This parameter is supported if you create an vpn attachment in single-tunnel mode. See `ike_config` below.
        :param pulumi.Input['GatewayVpnAttachmentIpsecConfigArgs'] ipsec_config: Configuration negotiated in the second stage. 
               - This parameter is supported if you create an vpn attachment in single-tunnel mode. See `ipsec_config` below.
        :param pulumi.Input[_builtins.str] network_type: network type
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Tags
        :param pulumi.Input[Sequence[pulumi.Input['GatewayVpnAttachmentTunnelOptionsSpecificationArgs']]] tunnel_options_specifications: Configure the tunnel.
               - You can configure parameters in the `tunnel_options_specification` array when you create a vpn attachment in dual-tunnel mode.
               - When creating a vpn attachment in dual-tunnel mode, you must add both tunnels for the vpn attachment to ensure that the vpn attachment has link redundancy. Only two tunnels can be added to a vpn attachment. See `tunnel_options_specification` below.
        :param pulumi.Input[_builtins.str] vpn_attachment_name: vpn attachment name
        """
        pulumi.set(__self__, "local_subnet", local_subnet)
        pulumi.set(__self__, "remote_subnet", remote_subnet)
        if bgp_config is not None:
            pulumi.set(__self__, "bgp_config", bgp_config)
        if customer_gateway_id is not None:
            pulumi.set(__self__, "customer_gateway_id", customer_gateway_id)
        if effect_immediately is not None:
            pulumi.set(__self__, "effect_immediately", effect_immediately)
        if enable_dpd is not None:
            pulumi.set(__self__, "enable_dpd", enable_dpd)
        if enable_nat_traversal is not None:
            pulumi.set(__self__, "enable_nat_traversal", enable_nat_traversal)
        if enable_tunnels_bgp is not None:
            pulumi.set(__self__, "enable_tunnels_bgp", enable_tunnels_bgp)
        if health_check_config is not None:
            pulumi.set(__self__, "health_check_config", health_check_config)
        if ike_config is not None:
            pulumi.set(__self__, "ike_config", ike_config)
        if ipsec_config is not None:
            pulumi.set(__self__, "ipsec_config", ipsec_config)
        if network_type is not None:
            pulumi.set(__self__, "network_type", network_type)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tunnel_options_specifications is not None:
            pulumi.set(__self__, "tunnel_options_specifications", tunnel_options_specifications)
        if vpn_attachment_name is not None:
            pulumi.set(__self__, "vpn_attachment_name", vpn_attachment_name)

    @_builtins.property
    @pulumi.getter(name="localSubnet")
    def local_subnet(self) -> pulumi.Input[_builtins.str]:
        """
        The CIDR block on the VPC side. The CIDR block is used in Phase 2 negotiations.Separate multiple CIDR blocks with commas (,). Example: 192.168.1.0/24,192.168.2.0/24.The following routing modes are supported:
        - If you set LocalSubnet and RemoteSubnet to 0.0.0.0/0, the routing mode of the IPsec-VPN connection is set to Destination Routing Mode.
        - If you set LocalSubnet and RemoteSubnet to specific CIDR blocks, the routing mode of the IPsec-VPN connection is set to Protected Data Flows.
        """
        return pulumi.get(self, "local_subnet")

    @local_subnet.setter
    def local_subnet(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "local_subnet", value)

    @_builtins.property
    @pulumi.getter(name="remoteSubnet")
    def remote_subnet(self) -> pulumi.Input[_builtins.str]:
        """
        The CIDR block on the data center side. This CIDR block is used in Phase 2 negotiations.Separate multiple CIDR blocks with commas (,). Example: 192.168.3.0/24,192.168.4.0/24.The following routing modes are supported:
        - If you set LocalSubnet and RemoteSubnet to 0.0.0.0/0, the routing mode of the IPsec-VPN connection is set to Destination Routing Mode.
        - If you set LocalSubnet and RemoteSubnet to specific CIDR blocks, the routing mode of the IPsec-VPN connection is set to Protected Data Flows.
        """
        return pulumi.get(self, "remote_subnet")

    @remote_subnet.setter
    def remote_subnet(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "remote_subnet", value)

    @_builtins.property
    @pulumi.getter(name="bgpConfig")
    def bgp_config(self) -> Optional[pulumi.Input['GatewayVpnAttachmentBgpConfigArgs']]:
        """
        Bgp configuration information.
        - This parameter is supported when you create an vpn attachment in single-tunnel mode. See `bgp_config` below.
        """
        return pulumi.get(self, "bgp_config")

    @bgp_config.setter
    def bgp_config(self, value: Optional[pulumi.Input['GatewayVpnAttachmentBgpConfigArgs']]):
        pulumi.set(self, "bgp_config", value)

    @_builtins.property
    @pulumi.getter(name="customerGatewayId")
    def customer_gateway_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Customer gateway ID.
        - This parameter is required when creating a single-tunnel mode vpn attachment.
        """
        return pulumi.get(self, "customer_gateway_id")

    @customer_gateway_id.setter
    def customer_gateway_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "customer_gateway_id", value)

    @_builtins.property
    @pulumi.getter(name="effectImmediately")
    def effect_immediately(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to immediately start IPsec negotiations after the configuration takes effect. Valid values:
        """
        return pulumi.get(self, "effect_immediately")

    @effect_immediately.setter
    def effect_immediately(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "effect_immediately", value)

    @_builtins.property
    @pulumi.getter(name="enableDpd")
    def enable_dpd(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        This parameter is supported if you create an vpn attachment in single-tunnel mode.
        Whether to enable the DPD (peer survival detection) function.
        - true (default): enables DPD. The initiator of the IPsec-VPN connection sends DPD packets to check the existence and availability of the peer. If no feedback is received from the peer within the specified period of time, the connection fails. In this case, ISAKMP SA and IPsec SA are deleted along with the security tunnel.
        - false: disables DPD. The initiator of the IPsec-VPN connection does not send DPD packets.
        """
        return pulumi.get(self, "enable_dpd")

    @enable_dpd.setter
    def enable_dpd(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_dpd", value)

    @_builtins.property
    @pulumi.getter(name="enableNatTraversal")
    def enable_nat_traversal(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        This parameter is supported if you create an vpn attachment in single-tunnel mode.
        Specifies whether to enable NAT traversal. Valid values:
        - true (default): enables NAT traversal. After NAT traversal is enabled, the initiator does not check the UDP ports during IKE negotiations and can automatically discover NAT gateway devices along the vpn attachment tunnel.
        - false: disables NAT traversal.
        """
        return pulumi.get(self, "enable_nat_traversal")

    @enable_nat_traversal.setter
    def enable_nat_traversal(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_nat_traversal", value)

    @_builtins.property
    @pulumi.getter(name="enableTunnelsBgp")
    def enable_tunnels_bgp(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        You can configure this parameter when you create a vpn attachment in dual-tunnel mode.Whether to enable the BGP function for the tunnel. Value: `true` or `false` (default).

        > **NOTE:**  before adding BGP configuration, we recommend that you understand the working mechanism and usage restrictions of the BGP dynamic routing function.
        """
        return pulumi.get(self, "enable_tunnels_bgp")

    @enable_tunnels_bgp.setter
    def enable_tunnels_bgp(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_tunnels_bgp", value)

    @_builtins.property
    @pulumi.getter(name="healthCheckConfig")
    def health_check_config(self) -> Optional[pulumi.Input['GatewayVpnAttachmentHealthCheckConfigArgs']]:
        """
        This parameter is supported if you create an vpn attachment in single-tunnel mode.
        Health check configuration information. See `health_check_config` below.
        """
        return pulumi.get(self, "health_check_config")

    @health_check_config.setter
    def health_check_config(self, value: Optional[pulumi.Input['GatewayVpnAttachmentHealthCheckConfigArgs']]):
        pulumi.set(self, "health_check_config", value)

    @_builtins.property
    @pulumi.getter(name="ikeConfig")
    def ike_config(self) -> Optional[pulumi.Input['GatewayVpnAttachmentIkeConfigArgs']]:
        """
        The configurations of Phase 1 negotiations. 
        - This parameter is supported if you create an vpn attachment in single-tunnel mode. See `ike_config` below.
        """
        return pulumi.get(self, "ike_config")

    @ike_config.setter
    def ike_config(self, value: Optional[pulumi.Input['GatewayVpnAttachmentIkeConfigArgs']]):
        pulumi.set(self, "ike_config", value)

    @_builtins.property
    @pulumi.getter(name="ipsecConfig")
    def ipsec_config(self) -> Optional[pulumi.Input['GatewayVpnAttachmentIpsecConfigArgs']]:
        """
        Configuration negotiated in the second stage. 
        - This parameter is supported if you create an vpn attachment in single-tunnel mode. See `ipsec_config` below.
        """
        return pulumi.get(self, "ipsec_config")

    @ipsec_config.setter
    def ipsec_config(self, value: Optional[pulumi.Input['GatewayVpnAttachmentIpsecConfigArgs']]):
        pulumi.set(self, "ipsec_config", value)

    @_builtins.property
    @pulumi.getter(name="networkType")
    def network_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        network type
        """
        return pulumi.get(self, "network_type")

    @network_type.setter
    def network_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_type", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource group
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Tags
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tunnelOptionsSpecifications")
    def tunnel_options_specifications(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GatewayVpnAttachmentTunnelOptionsSpecificationArgs']]]]:
        """
        Configure the tunnel.
        - You can configure parameters in the `tunnel_options_specification` array when you create a vpn attachment in dual-tunnel mode.
        - When creating a vpn attachment in dual-tunnel mode, you must add both tunnels for the vpn attachment to ensure that the vpn attachment has link redundancy. Only two tunnels can be added to a vpn attachment. See `tunnel_options_specification` below.
        """
        return pulumi.get(self, "tunnel_options_specifications")

    @tunnel_options_specifications.setter
    def tunnel_options_specifications(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GatewayVpnAttachmentTunnelOptionsSpecificationArgs']]]]):
        pulumi.set(self, "tunnel_options_specifications", value)

    @_builtins.property
    @pulumi.getter(name="vpnAttachmentName")
    def vpn_attachment_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        vpn attachment name
        """
        return pulumi.get(self, "vpn_attachment_name")

    @vpn_attachment_name.setter
    def vpn_attachment_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpn_attachment_name", value)


@pulumi.input_type
class _GatewayVpnAttachmentState:
    def __init__(__self__, *,
                 bgp_config: Optional[pulumi.Input['GatewayVpnAttachmentBgpConfigArgs']] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 customer_gateway_id: Optional[pulumi.Input[_builtins.str]] = None,
                 effect_immediately: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_dpd: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_nat_traversal: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_tunnels_bgp: Optional[pulumi.Input[_builtins.bool]] = None,
                 health_check_config: Optional[pulumi.Input['GatewayVpnAttachmentHealthCheckConfigArgs']] = None,
                 ike_config: Optional[pulumi.Input['GatewayVpnAttachmentIkeConfigArgs']] = None,
                 ipsec_config: Optional[pulumi.Input['GatewayVpnAttachmentIpsecConfigArgs']] = None,
                 local_subnet: Optional[pulumi.Input[_builtins.str]] = None,
                 network_type: Optional[pulumi.Input[_builtins.str]] = None,
                 remote_subnet: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tunnel_options_specifications: Optional[pulumi.Input[Sequence[pulumi.Input['GatewayVpnAttachmentTunnelOptionsSpecificationArgs']]]] = None,
                 vpn_attachment_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering GatewayVpnAttachment resources.
        :param pulumi.Input['GatewayVpnAttachmentBgpConfigArgs'] bgp_config: Bgp configuration information.
               - This parameter is supported when you create an vpn attachment in single-tunnel mode. See `bgp_config` below.
        :param pulumi.Input[_builtins.str] create_time: The creation time of the resource
        :param pulumi.Input[_builtins.str] customer_gateway_id: Customer gateway ID.
               - This parameter is required when creating a single-tunnel mode vpn attachment.
        :param pulumi.Input[_builtins.bool] effect_immediately: Specifies whether to immediately start IPsec negotiations after the configuration takes effect. Valid values:
        :param pulumi.Input[_builtins.bool] enable_dpd: This parameter is supported if you create an vpn attachment in single-tunnel mode.
               Whether to enable the DPD (peer survival detection) function.
               - true (default): enables DPD. The initiator of the IPsec-VPN connection sends DPD packets to check the existence and availability of the peer. If no feedback is received from the peer within the specified period of time, the connection fails. In this case, ISAKMP SA and IPsec SA are deleted along with the security tunnel.
               - false: disables DPD. The initiator of the IPsec-VPN connection does not send DPD packets.
        :param pulumi.Input[_builtins.bool] enable_nat_traversal: This parameter is supported if you create an vpn attachment in single-tunnel mode.
               Specifies whether to enable NAT traversal. Valid values:
               - true (default): enables NAT traversal. After NAT traversal is enabled, the initiator does not check the UDP ports during IKE negotiations and can automatically discover NAT gateway devices along the vpn attachment tunnel.
               - false: disables NAT traversal.
        :param pulumi.Input[_builtins.bool] enable_tunnels_bgp: You can configure this parameter when you create a vpn attachment in dual-tunnel mode.Whether to enable the BGP function for the tunnel. Value: `true` or `false` (default).
               
               > **NOTE:**  before adding BGP configuration, we recommend that you understand the working mechanism and usage restrictions of the BGP dynamic routing function.
        :param pulumi.Input['GatewayVpnAttachmentHealthCheckConfigArgs'] health_check_config: This parameter is supported if you create an vpn attachment in single-tunnel mode.
               Health check configuration information. See `health_check_config` below.
        :param pulumi.Input['GatewayVpnAttachmentIkeConfigArgs'] ike_config: The configurations of Phase 1 negotiations. 
               - This parameter is supported if you create an vpn attachment in single-tunnel mode. See `ike_config` below.
        :param pulumi.Input['GatewayVpnAttachmentIpsecConfigArgs'] ipsec_config: Configuration negotiated in the second stage. 
               - This parameter is supported if you create an vpn attachment in single-tunnel mode. See `ipsec_config` below.
        :param pulumi.Input[_builtins.str] local_subnet: The CIDR block on the VPC side. The CIDR block is used in Phase 2 negotiations.Separate multiple CIDR blocks with commas (,). Example: 192.168.1.0/24,192.168.2.0/24.The following routing modes are supported:
               - If you set LocalSubnet and RemoteSubnet to 0.0.0.0/0, the routing mode of the IPsec-VPN connection is set to Destination Routing Mode.
               - If you set LocalSubnet and RemoteSubnet to specific CIDR blocks, the routing mode of the IPsec-VPN connection is set to Protected Data Flows.
        :param pulumi.Input[_builtins.str] network_type: network type
        :param pulumi.Input[_builtins.str] remote_subnet: The CIDR block on the data center side. This CIDR block is used in Phase 2 negotiations.Separate multiple CIDR blocks with commas (,). Example: 192.168.3.0/24,192.168.4.0/24.The following routing modes are supported:
               - If you set LocalSubnet and RemoteSubnet to 0.0.0.0/0, the routing mode of the IPsec-VPN connection is set to Destination Routing Mode.
               - If you set LocalSubnet and RemoteSubnet to specific CIDR blocks, the routing mode of the IPsec-VPN connection is set to Protected Data Flows.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group
        :param pulumi.Input[_builtins.str] status: The negotiation status of Tunnel.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Tags
        :param pulumi.Input[Sequence[pulumi.Input['GatewayVpnAttachmentTunnelOptionsSpecificationArgs']]] tunnel_options_specifications: Configure the tunnel.
               - You can configure parameters in the `tunnel_options_specification` array when you create a vpn attachment in dual-tunnel mode.
               - When creating a vpn attachment in dual-tunnel mode, you must add both tunnels for the vpn attachment to ensure that the vpn attachment has link redundancy. Only two tunnels can be added to a vpn attachment. See `tunnel_options_specification` below.
        :param pulumi.Input[_builtins.str] vpn_attachment_name: vpn attachment name
        """
        if bgp_config is not None:
            pulumi.set(__self__, "bgp_config", bgp_config)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if customer_gateway_id is not None:
            pulumi.set(__self__, "customer_gateway_id", customer_gateway_id)
        if effect_immediately is not None:
            pulumi.set(__self__, "effect_immediately", effect_immediately)
        if enable_dpd is not None:
            pulumi.set(__self__, "enable_dpd", enable_dpd)
        if enable_nat_traversal is not None:
            pulumi.set(__self__, "enable_nat_traversal", enable_nat_traversal)
        if enable_tunnels_bgp is not None:
            pulumi.set(__self__, "enable_tunnels_bgp", enable_tunnels_bgp)
        if health_check_config is not None:
            pulumi.set(__self__, "health_check_config", health_check_config)
        if ike_config is not None:
            pulumi.set(__self__, "ike_config", ike_config)
        if ipsec_config is not None:
            pulumi.set(__self__, "ipsec_config", ipsec_config)
        if local_subnet is not None:
            pulumi.set(__self__, "local_subnet", local_subnet)
        if network_type is not None:
            pulumi.set(__self__, "network_type", network_type)
        if remote_subnet is not None:
            pulumi.set(__self__, "remote_subnet", remote_subnet)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tunnel_options_specifications is not None:
            pulumi.set(__self__, "tunnel_options_specifications", tunnel_options_specifications)
        if vpn_attachment_name is not None:
            pulumi.set(__self__, "vpn_attachment_name", vpn_attachment_name)

    @_builtins.property
    @pulumi.getter(name="bgpConfig")
    def bgp_config(self) -> Optional[pulumi.Input['GatewayVpnAttachmentBgpConfigArgs']]:
        """
        Bgp configuration information.
        - This parameter is supported when you create an vpn attachment in single-tunnel mode. See `bgp_config` below.
        """
        return pulumi.get(self, "bgp_config")

    @bgp_config.setter
    def bgp_config(self, value: Optional[pulumi.Input['GatewayVpnAttachmentBgpConfigArgs']]):
        pulumi.set(self, "bgp_config", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation time of the resource
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="customerGatewayId")
    def customer_gateway_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Customer gateway ID.
        - This parameter is required when creating a single-tunnel mode vpn attachment.
        """
        return pulumi.get(self, "customer_gateway_id")

    @customer_gateway_id.setter
    def customer_gateway_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "customer_gateway_id", value)

    @_builtins.property
    @pulumi.getter(name="effectImmediately")
    def effect_immediately(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to immediately start IPsec negotiations after the configuration takes effect. Valid values:
        """
        return pulumi.get(self, "effect_immediately")

    @effect_immediately.setter
    def effect_immediately(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "effect_immediately", value)

    @_builtins.property
    @pulumi.getter(name="enableDpd")
    def enable_dpd(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        This parameter is supported if you create an vpn attachment in single-tunnel mode.
        Whether to enable the DPD (peer survival detection) function.
        - true (default): enables DPD. The initiator of the IPsec-VPN connection sends DPD packets to check the existence and availability of the peer. If no feedback is received from the peer within the specified period of time, the connection fails. In this case, ISAKMP SA and IPsec SA are deleted along with the security tunnel.
        - false: disables DPD. The initiator of the IPsec-VPN connection does not send DPD packets.
        """
        return pulumi.get(self, "enable_dpd")

    @enable_dpd.setter
    def enable_dpd(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_dpd", value)

    @_builtins.property
    @pulumi.getter(name="enableNatTraversal")
    def enable_nat_traversal(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        This parameter is supported if you create an vpn attachment in single-tunnel mode.
        Specifies whether to enable NAT traversal. Valid values:
        - true (default): enables NAT traversal. After NAT traversal is enabled, the initiator does not check the UDP ports during IKE negotiations and can automatically discover NAT gateway devices along the vpn attachment tunnel.
        - false: disables NAT traversal.
        """
        return pulumi.get(self, "enable_nat_traversal")

    @enable_nat_traversal.setter
    def enable_nat_traversal(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_nat_traversal", value)

    @_builtins.property
    @pulumi.getter(name="enableTunnelsBgp")
    def enable_tunnels_bgp(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        You can configure this parameter when you create a vpn attachment in dual-tunnel mode.Whether to enable the BGP function for the tunnel. Value: `true` or `false` (default).

        > **NOTE:**  before adding BGP configuration, we recommend that you understand the working mechanism and usage restrictions of the BGP dynamic routing function.
        """
        return pulumi.get(self, "enable_tunnels_bgp")

    @enable_tunnels_bgp.setter
    def enable_tunnels_bgp(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_tunnels_bgp", value)

    @_builtins.property
    @pulumi.getter(name="healthCheckConfig")
    def health_check_config(self) -> Optional[pulumi.Input['GatewayVpnAttachmentHealthCheckConfigArgs']]:
        """
        This parameter is supported if you create an vpn attachment in single-tunnel mode.
        Health check configuration information. See `health_check_config` below.
        """
        return pulumi.get(self, "health_check_config")

    @health_check_config.setter
    def health_check_config(self, value: Optional[pulumi.Input['GatewayVpnAttachmentHealthCheckConfigArgs']]):
        pulumi.set(self, "health_check_config", value)

    @_builtins.property
    @pulumi.getter(name="ikeConfig")
    def ike_config(self) -> Optional[pulumi.Input['GatewayVpnAttachmentIkeConfigArgs']]:
        """
        The configurations of Phase 1 negotiations. 
        - This parameter is supported if you create an vpn attachment in single-tunnel mode. See `ike_config` below.
        """
        return pulumi.get(self, "ike_config")

    @ike_config.setter
    def ike_config(self, value: Optional[pulumi.Input['GatewayVpnAttachmentIkeConfigArgs']]):
        pulumi.set(self, "ike_config", value)

    @_builtins.property
    @pulumi.getter(name="ipsecConfig")
    def ipsec_config(self) -> Optional[pulumi.Input['GatewayVpnAttachmentIpsecConfigArgs']]:
        """
        Configuration negotiated in the second stage. 
        - This parameter is supported if you create an vpn attachment in single-tunnel mode. See `ipsec_config` below.
        """
        return pulumi.get(self, "ipsec_config")

    @ipsec_config.setter
    def ipsec_config(self, value: Optional[pulumi.Input['GatewayVpnAttachmentIpsecConfigArgs']]):
        pulumi.set(self, "ipsec_config", value)

    @_builtins.property
    @pulumi.getter(name="localSubnet")
    def local_subnet(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The CIDR block on the VPC side. The CIDR block is used in Phase 2 negotiations.Separate multiple CIDR blocks with commas (,). Example: 192.168.1.0/24,192.168.2.0/24.The following routing modes are supported:
        - If you set LocalSubnet and RemoteSubnet to 0.0.0.0/0, the routing mode of the IPsec-VPN connection is set to Destination Routing Mode.
        - If you set LocalSubnet and RemoteSubnet to specific CIDR blocks, the routing mode of the IPsec-VPN connection is set to Protected Data Flows.
        """
        return pulumi.get(self, "local_subnet")

    @local_subnet.setter
    def local_subnet(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "local_subnet", value)

    @_builtins.property
    @pulumi.getter(name="networkType")
    def network_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        network type
        """
        return pulumi.get(self, "network_type")

    @network_type.setter
    def network_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_type", value)

    @_builtins.property
    @pulumi.getter(name="remoteSubnet")
    def remote_subnet(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The CIDR block on the data center side. This CIDR block is used in Phase 2 negotiations.Separate multiple CIDR blocks with commas (,). Example: 192.168.3.0/24,192.168.4.0/24.The following routing modes are supported:
        - If you set LocalSubnet and RemoteSubnet to 0.0.0.0/0, the routing mode of the IPsec-VPN connection is set to Destination Routing Mode.
        - If you set LocalSubnet and RemoteSubnet to specific CIDR blocks, the routing mode of the IPsec-VPN connection is set to Protected Data Flows.
        """
        return pulumi.get(self, "remote_subnet")

    @remote_subnet.setter
    def remote_subnet(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "remote_subnet", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource group
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The negotiation status of Tunnel.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Tags
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tunnelOptionsSpecifications")
    def tunnel_options_specifications(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GatewayVpnAttachmentTunnelOptionsSpecificationArgs']]]]:
        """
        Configure the tunnel.
        - You can configure parameters in the `tunnel_options_specification` array when you create a vpn attachment in dual-tunnel mode.
        - When creating a vpn attachment in dual-tunnel mode, you must add both tunnels for the vpn attachment to ensure that the vpn attachment has link redundancy. Only two tunnels can be added to a vpn attachment. See `tunnel_options_specification` below.
        """
        return pulumi.get(self, "tunnel_options_specifications")

    @tunnel_options_specifications.setter
    def tunnel_options_specifications(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GatewayVpnAttachmentTunnelOptionsSpecificationArgs']]]]):
        pulumi.set(self, "tunnel_options_specifications", value)

    @_builtins.property
    @pulumi.getter(name="vpnAttachmentName")
    def vpn_attachment_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        vpn attachment name
        """
        return pulumi.get(self, "vpn_attachment_name")

    @vpn_attachment_name.setter
    def vpn_attachment_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpn_attachment_name", value)


@pulumi.type_token("alicloud:vpn/gatewayVpnAttachment:GatewayVpnAttachment")
class GatewayVpnAttachment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bgp_config: Optional[pulumi.Input[Union['GatewayVpnAttachmentBgpConfigArgs', 'GatewayVpnAttachmentBgpConfigArgsDict']]] = None,
                 customer_gateway_id: Optional[pulumi.Input[_builtins.str]] = None,
                 effect_immediately: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_dpd: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_nat_traversal: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_tunnels_bgp: Optional[pulumi.Input[_builtins.bool]] = None,
                 health_check_config: Optional[pulumi.Input[Union['GatewayVpnAttachmentHealthCheckConfigArgs', 'GatewayVpnAttachmentHealthCheckConfigArgsDict']]] = None,
                 ike_config: Optional[pulumi.Input[Union['GatewayVpnAttachmentIkeConfigArgs', 'GatewayVpnAttachmentIkeConfigArgsDict']]] = None,
                 ipsec_config: Optional[pulumi.Input[Union['GatewayVpnAttachmentIpsecConfigArgs', 'GatewayVpnAttachmentIpsecConfigArgsDict']]] = None,
                 local_subnet: Optional[pulumi.Input[_builtins.str]] = None,
                 network_type: Optional[pulumi.Input[_builtins.str]] = None,
                 remote_subnet: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tunnel_options_specifications: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GatewayVpnAttachmentTunnelOptionsSpecificationArgs', 'GatewayVpnAttachmentTunnelOptionsSpecificationArgsDict']]]]] = None,
                 vpn_attachment_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a VPN Gateway Vpn Attachment resource.

        VpnAttachment has been upgraded to dual-tunnel mode. When you create a VpnAttachment in dual tunnel mode, you can configure the following request parameters in addition to the required parameters: vpn_attachment_name, network_type, effectImmediately, tags array, resource_group_id, tunnel_options_specification array, and enable_tunnels_bgp.

        For information about VPN Gateway Vpn Attachment and how to use it, see [What is Vpn Attachment](https://www.alibabacloud.com/help/zh/virtual-private-cloud/latest/createvpnattachment).

        > **NOTE:** Available since v1.181.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        default = alicloud.vpn.CustomerGateway("default",
            customer_gateway_name=name,
            ip_address="42.104.22.210",
            asn="45014",
            description=name)
        default_gateway_vpn_attachment = alicloud.vpn.GatewayVpnAttachment("default",
            customer_gateway_id=default.id,
            network_type="public",
            local_subnet="0.0.0.0/0",
            remote_subnet="0.0.0.0/0",
            effect_immediately=False,
            ike_config={
                "ike_auth_alg": "md5",
                "ike_enc_alg": "des",
                "ike_version": "ikev2",
                "ike_mode": "main",
                "ike_lifetime": 86400,
                "psk": "tf-testvpn2",
                "ike_pfs": "group1",
                "remote_id": "testbob2",
                "local_id": "testalice2",
            },
            ipsec_config={
                "ipsec_pfs": "group5",
                "ipsec_enc_alg": "des",
                "ipsec_auth_alg": "md5",
                "ipsec_lifetime": 86400,
            },
            bgp_config={
                "enable": True,
                "local_asn": 45014,
                "tunnel_cidr": "169.254.11.0/30",
                "local_bgp_ip": "169.254.11.1",
            },
            health_check_config={
                "enable": True,
                "sip": "192.168.1.1",
                "dip": "10.0.0.1",
                "interval": 10,
                "retry": 10,
                "policy": "revoke_route",
            },
            enable_dpd=True,
            enable_nat_traversal=True,
            vpn_attachment_name=name)
        ```

        Dual Tunnel Mode Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf_example"
        default = alicloud.resourcemanager.get_resource_groups()
        cgw1 = alicloud.vpn.CustomerGateway("cgw1",
            ip_address="2.2.2.2",
            asn="1219001")
        cgw2 = alicloud.vpn.CustomerGateway("cgw2",
            ip_address="43.43.3.22",
            asn="44331",
            customer_gateway_name="example_amp")
        default_gateway_vpn_attachment = alicloud.vpn.GatewayVpnAttachment("default",
            local_subnet="0.0.0.0/0",
            enable_tunnels_bgp=True,
            vpn_attachment_name="tfaccvpngateway25800",
            tunnel_options_specifications=[
                {
                    "tunnel_ipsec_config": {
                        "ipsec_lifetime": 86200,
                        "ipsec_pfs": "group5",
                        "ipsec_auth_alg": "md5",
                        "ipsec_enc_alg": "aes",
                    },
                    "customer_gateway_id": cgw1.id,
                    "enable_dpd": True,
                    "enable_nat_traversal": True,
                    "tunnel_index": 1,
                    "tunnel_bgp_config": {
                        "local_asn": 1219001,
                        "local_bgp_ip": "169.254.10.1",
                        "tunnel_cidr": "169.254.10.0/30",
                    },
                    "tunnel_ike_config": {
                        "ike_mode": "main",
                        "ike_version": "ikev1",
                        "psk": "12345678",
                        "remote_id": "2.2.2.2",
                        "ike_auth_alg": "md5",
                        "ike_enc_alg": "aes",
                        "ike_lifetime": 86100,
                        "ike_pfs": "group2",
                        "local_id": "1.1.1.1",
                    },
                },
                {
                    "tunnel_ipsec_config": {
                        "ipsec_enc_alg": "aes",
                        "ipsec_lifetime": 86400,
                        "ipsec_pfs": "group5",
                        "ipsec_auth_alg": "sha256",
                    },
                    "customer_gateway_id": cgw1.id,
                    "enable_dpd": True,
                    "enable_nat_traversal": True,
                    "tunnel_index": 2,
                    "tunnel_bgp_config": {
                        "local_asn": 1219001,
                        "local_bgp_ip": "169.254.20.1",
                        "tunnel_cidr": "169.254.20.0/30",
                    },
                    "tunnel_ike_config": {
                        "local_id": "4.4.4.4",
                        "remote_id": "5.5.5.5",
                        "ike_lifetime": 86400,
                        "ike_mode": "main",
                        "ike_pfs": "group5",
                        "ike_version": "ikev2",
                        "ike_auth_alg": "md5",
                        "ike_enc_alg": "aes",
                        "psk": "32333442",
                    },
                },
            ],
            remote_subnet="0.0.0.0/0",
            network_type="public",
            resource_group_id=default.ids[0])
        ```

        ## Import

        VPN Gateway Vpn Attachment can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:vpn/gatewayVpnAttachment:GatewayVpnAttachment example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['GatewayVpnAttachmentBgpConfigArgs', 'GatewayVpnAttachmentBgpConfigArgsDict']] bgp_config: Bgp configuration information.
               - This parameter is supported when you create an vpn attachment in single-tunnel mode. See `bgp_config` below.
        :param pulumi.Input[_builtins.str] customer_gateway_id: Customer gateway ID.
               - This parameter is required when creating a single-tunnel mode vpn attachment.
        :param pulumi.Input[_builtins.bool] effect_immediately: Specifies whether to immediately start IPsec negotiations after the configuration takes effect. Valid values:
        :param pulumi.Input[_builtins.bool] enable_dpd: This parameter is supported if you create an vpn attachment in single-tunnel mode.
               Whether to enable the DPD (peer survival detection) function.
               - true (default): enables DPD. The initiator of the IPsec-VPN connection sends DPD packets to check the existence and availability of the peer. If no feedback is received from the peer within the specified period of time, the connection fails. In this case, ISAKMP SA and IPsec SA are deleted along with the security tunnel.
               - false: disables DPD. The initiator of the IPsec-VPN connection does not send DPD packets.
        :param pulumi.Input[_builtins.bool] enable_nat_traversal: This parameter is supported if you create an vpn attachment in single-tunnel mode.
               Specifies whether to enable NAT traversal. Valid values:
               - true (default): enables NAT traversal. After NAT traversal is enabled, the initiator does not check the UDP ports during IKE negotiations and can automatically discover NAT gateway devices along the vpn attachment tunnel.
               - false: disables NAT traversal.
        :param pulumi.Input[_builtins.bool] enable_tunnels_bgp: You can configure this parameter when you create a vpn attachment in dual-tunnel mode.Whether to enable the BGP function for the tunnel. Value: `true` or `false` (default).
               
               > **NOTE:**  before adding BGP configuration, we recommend that you understand the working mechanism and usage restrictions of the BGP dynamic routing function.
        :param pulumi.Input[Union['GatewayVpnAttachmentHealthCheckConfigArgs', 'GatewayVpnAttachmentHealthCheckConfigArgsDict']] health_check_config: This parameter is supported if you create an vpn attachment in single-tunnel mode.
               Health check configuration information. See `health_check_config` below.
        :param pulumi.Input[Union['GatewayVpnAttachmentIkeConfigArgs', 'GatewayVpnAttachmentIkeConfigArgsDict']] ike_config: The configurations of Phase 1 negotiations. 
               - This parameter is supported if you create an vpn attachment in single-tunnel mode. See `ike_config` below.
        :param pulumi.Input[Union['GatewayVpnAttachmentIpsecConfigArgs', 'GatewayVpnAttachmentIpsecConfigArgsDict']] ipsec_config: Configuration negotiated in the second stage. 
               - This parameter is supported if you create an vpn attachment in single-tunnel mode. See `ipsec_config` below.
        :param pulumi.Input[_builtins.str] local_subnet: The CIDR block on the VPC side. The CIDR block is used in Phase 2 negotiations.Separate multiple CIDR blocks with commas (,). Example: 192.168.1.0/24,192.168.2.0/24.The following routing modes are supported:
               - If you set LocalSubnet and RemoteSubnet to 0.0.0.0/0, the routing mode of the IPsec-VPN connection is set to Destination Routing Mode.
               - If you set LocalSubnet and RemoteSubnet to specific CIDR blocks, the routing mode of the IPsec-VPN connection is set to Protected Data Flows.
        :param pulumi.Input[_builtins.str] network_type: network type
        :param pulumi.Input[_builtins.str] remote_subnet: The CIDR block on the data center side. This CIDR block is used in Phase 2 negotiations.Separate multiple CIDR blocks with commas (,). Example: 192.168.3.0/24,192.168.4.0/24.The following routing modes are supported:
               - If you set LocalSubnet and RemoteSubnet to 0.0.0.0/0, the routing mode of the IPsec-VPN connection is set to Destination Routing Mode.
               - If you set LocalSubnet and RemoteSubnet to specific CIDR blocks, the routing mode of the IPsec-VPN connection is set to Protected Data Flows.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Tags
        :param pulumi.Input[Sequence[pulumi.Input[Union['GatewayVpnAttachmentTunnelOptionsSpecificationArgs', 'GatewayVpnAttachmentTunnelOptionsSpecificationArgsDict']]]] tunnel_options_specifications: Configure the tunnel.
               - You can configure parameters in the `tunnel_options_specification` array when you create a vpn attachment in dual-tunnel mode.
               - When creating a vpn attachment in dual-tunnel mode, you must add both tunnels for the vpn attachment to ensure that the vpn attachment has link redundancy. Only two tunnels can be added to a vpn attachment. See `tunnel_options_specification` below.
        :param pulumi.Input[_builtins.str] vpn_attachment_name: vpn attachment name
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GatewayVpnAttachmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a VPN Gateway Vpn Attachment resource.

        VpnAttachment has been upgraded to dual-tunnel mode. When you create a VpnAttachment in dual tunnel mode, you can configure the following request parameters in addition to the required parameters: vpn_attachment_name, network_type, effectImmediately, tags array, resource_group_id, tunnel_options_specification array, and enable_tunnels_bgp.

        For information about VPN Gateway Vpn Attachment and how to use it, see [What is Vpn Attachment](https://www.alibabacloud.com/help/zh/virtual-private-cloud/latest/createvpnattachment).

        > **NOTE:** Available since v1.181.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        default = alicloud.vpn.CustomerGateway("default",
            customer_gateway_name=name,
            ip_address="42.104.22.210",
            asn="45014",
            description=name)
        default_gateway_vpn_attachment = alicloud.vpn.GatewayVpnAttachment("default",
            customer_gateway_id=default.id,
            network_type="public",
            local_subnet="0.0.0.0/0",
            remote_subnet="0.0.0.0/0",
            effect_immediately=False,
            ike_config={
                "ike_auth_alg": "md5",
                "ike_enc_alg": "des",
                "ike_version": "ikev2",
                "ike_mode": "main",
                "ike_lifetime": 86400,
                "psk": "tf-testvpn2",
                "ike_pfs": "group1",
                "remote_id": "testbob2",
                "local_id": "testalice2",
            },
            ipsec_config={
                "ipsec_pfs": "group5",
                "ipsec_enc_alg": "des",
                "ipsec_auth_alg": "md5",
                "ipsec_lifetime": 86400,
            },
            bgp_config={
                "enable": True,
                "local_asn": 45014,
                "tunnel_cidr": "169.254.11.0/30",
                "local_bgp_ip": "169.254.11.1",
            },
            health_check_config={
                "enable": True,
                "sip": "192.168.1.1",
                "dip": "10.0.0.1",
                "interval": 10,
                "retry": 10,
                "policy": "revoke_route",
            },
            enable_dpd=True,
            enable_nat_traversal=True,
            vpn_attachment_name=name)
        ```

        Dual Tunnel Mode Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf_example"
        default = alicloud.resourcemanager.get_resource_groups()
        cgw1 = alicloud.vpn.CustomerGateway("cgw1",
            ip_address="2.2.2.2",
            asn="1219001")
        cgw2 = alicloud.vpn.CustomerGateway("cgw2",
            ip_address="43.43.3.22",
            asn="44331",
            customer_gateway_name="example_amp")
        default_gateway_vpn_attachment = alicloud.vpn.GatewayVpnAttachment("default",
            local_subnet="0.0.0.0/0",
            enable_tunnels_bgp=True,
            vpn_attachment_name="tfaccvpngateway25800",
            tunnel_options_specifications=[
                {
                    "tunnel_ipsec_config": {
                        "ipsec_lifetime": 86200,
                        "ipsec_pfs": "group5",
                        "ipsec_auth_alg": "md5",
                        "ipsec_enc_alg": "aes",
                    },
                    "customer_gateway_id": cgw1.id,
                    "enable_dpd": True,
                    "enable_nat_traversal": True,
                    "tunnel_index": 1,
                    "tunnel_bgp_config": {
                        "local_asn": 1219001,
                        "local_bgp_ip": "169.254.10.1",
                        "tunnel_cidr": "169.254.10.0/30",
                    },
                    "tunnel_ike_config": {
                        "ike_mode": "main",
                        "ike_version": "ikev1",
                        "psk": "12345678",
                        "remote_id": "2.2.2.2",
                        "ike_auth_alg": "md5",
                        "ike_enc_alg": "aes",
                        "ike_lifetime": 86100,
                        "ike_pfs": "group2",
                        "local_id": "1.1.1.1",
                    },
                },
                {
                    "tunnel_ipsec_config": {
                        "ipsec_enc_alg": "aes",
                        "ipsec_lifetime": 86400,
                        "ipsec_pfs": "group5",
                        "ipsec_auth_alg": "sha256",
                    },
                    "customer_gateway_id": cgw1.id,
                    "enable_dpd": True,
                    "enable_nat_traversal": True,
                    "tunnel_index": 2,
                    "tunnel_bgp_config": {
                        "local_asn": 1219001,
                        "local_bgp_ip": "169.254.20.1",
                        "tunnel_cidr": "169.254.20.0/30",
                    },
                    "tunnel_ike_config": {
                        "local_id": "4.4.4.4",
                        "remote_id": "5.5.5.5",
                        "ike_lifetime": 86400,
                        "ike_mode": "main",
                        "ike_pfs": "group5",
                        "ike_version": "ikev2",
                        "ike_auth_alg": "md5",
                        "ike_enc_alg": "aes",
                        "psk": "32333442",
                    },
                },
            ],
            remote_subnet="0.0.0.0/0",
            network_type="public",
            resource_group_id=default.ids[0])
        ```

        ## Import

        VPN Gateway Vpn Attachment can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:vpn/gatewayVpnAttachment:GatewayVpnAttachment example <id>
        ```

        :param str resource_name: The name of the resource.
        :param GatewayVpnAttachmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GatewayVpnAttachmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bgp_config: Optional[pulumi.Input[Union['GatewayVpnAttachmentBgpConfigArgs', 'GatewayVpnAttachmentBgpConfigArgsDict']]] = None,
                 customer_gateway_id: Optional[pulumi.Input[_builtins.str]] = None,
                 effect_immediately: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_dpd: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_nat_traversal: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_tunnels_bgp: Optional[pulumi.Input[_builtins.bool]] = None,
                 health_check_config: Optional[pulumi.Input[Union['GatewayVpnAttachmentHealthCheckConfigArgs', 'GatewayVpnAttachmentHealthCheckConfigArgsDict']]] = None,
                 ike_config: Optional[pulumi.Input[Union['GatewayVpnAttachmentIkeConfigArgs', 'GatewayVpnAttachmentIkeConfigArgsDict']]] = None,
                 ipsec_config: Optional[pulumi.Input[Union['GatewayVpnAttachmentIpsecConfigArgs', 'GatewayVpnAttachmentIpsecConfigArgsDict']]] = None,
                 local_subnet: Optional[pulumi.Input[_builtins.str]] = None,
                 network_type: Optional[pulumi.Input[_builtins.str]] = None,
                 remote_subnet: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tunnel_options_specifications: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GatewayVpnAttachmentTunnelOptionsSpecificationArgs', 'GatewayVpnAttachmentTunnelOptionsSpecificationArgsDict']]]]] = None,
                 vpn_attachment_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GatewayVpnAttachmentArgs.__new__(GatewayVpnAttachmentArgs)

            __props__.__dict__["bgp_config"] = bgp_config
            __props__.__dict__["customer_gateway_id"] = customer_gateway_id
            __props__.__dict__["effect_immediately"] = effect_immediately
            __props__.__dict__["enable_dpd"] = enable_dpd
            __props__.__dict__["enable_nat_traversal"] = enable_nat_traversal
            __props__.__dict__["enable_tunnels_bgp"] = enable_tunnels_bgp
            __props__.__dict__["health_check_config"] = health_check_config
            __props__.__dict__["ike_config"] = ike_config
            __props__.__dict__["ipsec_config"] = ipsec_config
            if local_subnet is None and not opts.urn:
                raise TypeError("Missing required property 'local_subnet'")
            __props__.__dict__["local_subnet"] = local_subnet
            __props__.__dict__["network_type"] = network_type
            if remote_subnet is None and not opts.urn:
                raise TypeError("Missing required property 'remote_subnet'")
            __props__.__dict__["remote_subnet"] = remote_subnet
            __props__.__dict__["resource_group_id"] = resource_group_id
            __props__.__dict__["tags"] = tags
            __props__.__dict__["tunnel_options_specifications"] = tunnel_options_specifications
            __props__.__dict__["vpn_attachment_name"] = vpn_attachment_name
            __props__.__dict__["create_time"] = None
            __props__.__dict__["status"] = None
        super(GatewayVpnAttachment, __self__).__init__(
            'alicloud:vpn/gatewayVpnAttachment:GatewayVpnAttachment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            bgp_config: Optional[pulumi.Input[Union['GatewayVpnAttachmentBgpConfigArgs', 'GatewayVpnAttachmentBgpConfigArgsDict']]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            customer_gateway_id: Optional[pulumi.Input[_builtins.str]] = None,
            effect_immediately: Optional[pulumi.Input[_builtins.bool]] = None,
            enable_dpd: Optional[pulumi.Input[_builtins.bool]] = None,
            enable_nat_traversal: Optional[pulumi.Input[_builtins.bool]] = None,
            enable_tunnels_bgp: Optional[pulumi.Input[_builtins.bool]] = None,
            health_check_config: Optional[pulumi.Input[Union['GatewayVpnAttachmentHealthCheckConfigArgs', 'GatewayVpnAttachmentHealthCheckConfigArgsDict']]] = None,
            ike_config: Optional[pulumi.Input[Union['GatewayVpnAttachmentIkeConfigArgs', 'GatewayVpnAttachmentIkeConfigArgsDict']]] = None,
            ipsec_config: Optional[pulumi.Input[Union['GatewayVpnAttachmentIpsecConfigArgs', 'GatewayVpnAttachmentIpsecConfigArgsDict']]] = None,
            local_subnet: Optional[pulumi.Input[_builtins.str]] = None,
            network_type: Optional[pulumi.Input[_builtins.str]] = None,
            remote_subnet: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tunnel_options_specifications: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GatewayVpnAttachmentTunnelOptionsSpecificationArgs', 'GatewayVpnAttachmentTunnelOptionsSpecificationArgsDict']]]]] = None,
            vpn_attachment_name: Optional[pulumi.Input[_builtins.str]] = None) -> 'GatewayVpnAttachment':
        """
        Get an existing GatewayVpnAttachment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['GatewayVpnAttachmentBgpConfigArgs', 'GatewayVpnAttachmentBgpConfigArgsDict']] bgp_config: Bgp configuration information.
               - This parameter is supported when you create an vpn attachment in single-tunnel mode. See `bgp_config` below.
        :param pulumi.Input[_builtins.str] create_time: The creation time of the resource
        :param pulumi.Input[_builtins.str] customer_gateway_id: Customer gateway ID.
               - This parameter is required when creating a single-tunnel mode vpn attachment.
        :param pulumi.Input[_builtins.bool] effect_immediately: Specifies whether to immediately start IPsec negotiations after the configuration takes effect. Valid values:
        :param pulumi.Input[_builtins.bool] enable_dpd: This parameter is supported if you create an vpn attachment in single-tunnel mode.
               Whether to enable the DPD (peer survival detection) function.
               - true (default): enables DPD. The initiator of the IPsec-VPN connection sends DPD packets to check the existence and availability of the peer. If no feedback is received from the peer within the specified period of time, the connection fails. In this case, ISAKMP SA and IPsec SA are deleted along with the security tunnel.
               - false: disables DPD. The initiator of the IPsec-VPN connection does not send DPD packets.
        :param pulumi.Input[_builtins.bool] enable_nat_traversal: This parameter is supported if you create an vpn attachment in single-tunnel mode.
               Specifies whether to enable NAT traversal. Valid values:
               - true (default): enables NAT traversal. After NAT traversal is enabled, the initiator does not check the UDP ports during IKE negotiations and can automatically discover NAT gateway devices along the vpn attachment tunnel.
               - false: disables NAT traversal.
        :param pulumi.Input[_builtins.bool] enable_tunnels_bgp: You can configure this parameter when you create a vpn attachment in dual-tunnel mode.Whether to enable the BGP function for the tunnel. Value: `true` or `false` (default).
               
               > **NOTE:**  before adding BGP configuration, we recommend that you understand the working mechanism and usage restrictions of the BGP dynamic routing function.
        :param pulumi.Input[Union['GatewayVpnAttachmentHealthCheckConfigArgs', 'GatewayVpnAttachmentHealthCheckConfigArgsDict']] health_check_config: This parameter is supported if you create an vpn attachment in single-tunnel mode.
               Health check configuration information. See `health_check_config` below.
        :param pulumi.Input[Union['GatewayVpnAttachmentIkeConfigArgs', 'GatewayVpnAttachmentIkeConfigArgsDict']] ike_config: The configurations of Phase 1 negotiations. 
               - This parameter is supported if you create an vpn attachment in single-tunnel mode. See `ike_config` below.
        :param pulumi.Input[Union['GatewayVpnAttachmentIpsecConfigArgs', 'GatewayVpnAttachmentIpsecConfigArgsDict']] ipsec_config: Configuration negotiated in the second stage. 
               - This parameter is supported if you create an vpn attachment in single-tunnel mode. See `ipsec_config` below.
        :param pulumi.Input[_builtins.str] local_subnet: The CIDR block on the VPC side. The CIDR block is used in Phase 2 negotiations.Separate multiple CIDR blocks with commas (,). Example: 192.168.1.0/24,192.168.2.0/24.The following routing modes are supported:
               - If you set LocalSubnet and RemoteSubnet to 0.0.0.0/0, the routing mode of the IPsec-VPN connection is set to Destination Routing Mode.
               - If you set LocalSubnet and RemoteSubnet to specific CIDR blocks, the routing mode of the IPsec-VPN connection is set to Protected Data Flows.
        :param pulumi.Input[_builtins.str] network_type: network type
        :param pulumi.Input[_builtins.str] remote_subnet: The CIDR block on the data center side. This CIDR block is used in Phase 2 negotiations.Separate multiple CIDR blocks with commas (,). Example: 192.168.3.0/24,192.168.4.0/24.The following routing modes are supported:
               - If you set LocalSubnet and RemoteSubnet to 0.0.0.0/0, the routing mode of the IPsec-VPN connection is set to Destination Routing Mode.
               - If you set LocalSubnet and RemoteSubnet to specific CIDR blocks, the routing mode of the IPsec-VPN connection is set to Protected Data Flows.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group
        :param pulumi.Input[_builtins.str] status: The negotiation status of Tunnel.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Tags
        :param pulumi.Input[Sequence[pulumi.Input[Union['GatewayVpnAttachmentTunnelOptionsSpecificationArgs', 'GatewayVpnAttachmentTunnelOptionsSpecificationArgsDict']]]] tunnel_options_specifications: Configure the tunnel.
               - You can configure parameters in the `tunnel_options_specification` array when you create a vpn attachment in dual-tunnel mode.
               - When creating a vpn attachment in dual-tunnel mode, you must add both tunnels for the vpn attachment to ensure that the vpn attachment has link redundancy. Only two tunnels can be added to a vpn attachment. See `tunnel_options_specification` below.
        :param pulumi.Input[_builtins.str] vpn_attachment_name: vpn attachment name
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GatewayVpnAttachmentState.__new__(_GatewayVpnAttachmentState)

        __props__.__dict__["bgp_config"] = bgp_config
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["customer_gateway_id"] = customer_gateway_id
        __props__.__dict__["effect_immediately"] = effect_immediately
        __props__.__dict__["enable_dpd"] = enable_dpd
        __props__.__dict__["enable_nat_traversal"] = enable_nat_traversal
        __props__.__dict__["enable_tunnels_bgp"] = enable_tunnels_bgp
        __props__.__dict__["health_check_config"] = health_check_config
        __props__.__dict__["ike_config"] = ike_config
        __props__.__dict__["ipsec_config"] = ipsec_config
        __props__.__dict__["local_subnet"] = local_subnet
        __props__.__dict__["network_type"] = network_type
        __props__.__dict__["remote_subnet"] = remote_subnet
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tunnel_options_specifications"] = tunnel_options_specifications
        __props__.__dict__["vpn_attachment_name"] = vpn_attachment_name
        return GatewayVpnAttachment(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="bgpConfig")
    def bgp_config(self) -> pulumi.Output['outputs.GatewayVpnAttachmentBgpConfig']:
        """
        Bgp configuration information.
        - This parameter is supported when you create an vpn attachment in single-tunnel mode. See `bgp_config` below.
        """
        return pulumi.get(self, "bgp_config")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The creation time of the resource
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="customerGatewayId")
    def customer_gateway_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Customer gateway ID.
        - This parameter is required when creating a single-tunnel mode vpn attachment.
        """
        return pulumi.get(self, "customer_gateway_id")

    @_builtins.property
    @pulumi.getter(name="effectImmediately")
    def effect_immediately(self) -> pulumi.Output[_builtins.bool]:
        """
        Specifies whether to immediately start IPsec negotiations after the configuration takes effect. Valid values:
        """
        return pulumi.get(self, "effect_immediately")

    @_builtins.property
    @pulumi.getter(name="enableDpd")
    def enable_dpd(self) -> pulumi.Output[_builtins.bool]:
        """
        This parameter is supported if you create an vpn attachment in single-tunnel mode.
        Whether to enable the DPD (peer survival detection) function.
        - true (default): enables DPD. The initiator of the IPsec-VPN connection sends DPD packets to check the existence and availability of the peer. If no feedback is received from the peer within the specified period of time, the connection fails. In this case, ISAKMP SA and IPsec SA are deleted along with the security tunnel.
        - false: disables DPD. The initiator of the IPsec-VPN connection does not send DPD packets.
        """
        return pulumi.get(self, "enable_dpd")

    @_builtins.property
    @pulumi.getter(name="enableNatTraversal")
    def enable_nat_traversal(self) -> pulumi.Output[_builtins.bool]:
        """
        This parameter is supported if you create an vpn attachment in single-tunnel mode.
        Specifies whether to enable NAT traversal. Valid values:
        - true (default): enables NAT traversal. After NAT traversal is enabled, the initiator does not check the UDP ports during IKE negotiations and can automatically discover NAT gateway devices along the vpn attachment tunnel.
        - false: disables NAT traversal.
        """
        return pulumi.get(self, "enable_nat_traversal")

    @_builtins.property
    @pulumi.getter(name="enableTunnelsBgp")
    def enable_tunnels_bgp(self) -> pulumi.Output[_builtins.bool]:
        """
        You can configure this parameter when you create a vpn attachment in dual-tunnel mode.Whether to enable the BGP function for the tunnel. Value: `true` or `false` (default).

        > **NOTE:**  before adding BGP configuration, we recommend that you understand the working mechanism and usage restrictions of the BGP dynamic routing function.
        """
        return pulumi.get(self, "enable_tunnels_bgp")

    @_builtins.property
    @pulumi.getter(name="healthCheckConfig")
    def health_check_config(self) -> pulumi.Output['outputs.GatewayVpnAttachmentHealthCheckConfig']:
        """
        This parameter is supported if you create an vpn attachment in single-tunnel mode.
        Health check configuration information. See `health_check_config` below.
        """
        return pulumi.get(self, "health_check_config")

    @_builtins.property
    @pulumi.getter(name="ikeConfig")
    def ike_config(self) -> pulumi.Output['outputs.GatewayVpnAttachmentIkeConfig']:
        """
        The configurations of Phase 1 negotiations. 
        - This parameter is supported if you create an vpn attachment in single-tunnel mode. See `ike_config` below.
        """
        return pulumi.get(self, "ike_config")

    @_builtins.property
    @pulumi.getter(name="ipsecConfig")
    def ipsec_config(self) -> pulumi.Output['outputs.GatewayVpnAttachmentIpsecConfig']:
        """
        Configuration negotiated in the second stage. 
        - This parameter is supported if you create an vpn attachment in single-tunnel mode. See `ipsec_config` below.
        """
        return pulumi.get(self, "ipsec_config")

    @_builtins.property
    @pulumi.getter(name="localSubnet")
    def local_subnet(self) -> pulumi.Output[_builtins.str]:
        """
        The CIDR block on the VPC side. The CIDR block is used in Phase 2 negotiations.Separate multiple CIDR blocks with commas (,). Example: 192.168.1.0/24,192.168.2.0/24.The following routing modes are supported:
        - If you set LocalSubnet and RemoteSubnet to 0.0.0.0/0, the routing mode of the IPsec-VPN connection is set to Destination Routing Mode.
        - If you set LocalSubnet and RemoteSubnet to specific CIDR blocks, the routing mode of the IPsec-VPN connection is set to Protected Data Flows.
        """
        return pulumi.get(self, "local_subnet")

    @_builtins.property
    @pulumi.getter(name="networkType")
    def network_type(self) -> pulumi.Output[_builtins.str]:
        """
        network type
        """
        return pulumi.get(self, "network_type")

    @_builtins.property
    @pulumi.getter(name="remoteSubnet")
    def remote_subnet(self) -> pulumi.Output[_builtins.str]:
        """
        The CIDR block on the data center side. This CIDR block is used in Phase 2 negotiations.Separate multiple CIDR blocks with commas (,). Example: 192.168.3.0/24,192.168.4.0/24.The following routing modes are supported:
        - If you set LocalSubnet and RemoteSubnet to 0.0.0.0/0, the routing mode of the IPsec-VPN connection is set to Destination Routing Mode.
        - If you set LocalSubnet and RemoteSubnet to specific CIDR blocks, the routing mode of the IPsec-VPN connection is set to Protected Data Flows.
        """
        return pulumi.get(self, "remote_subnet")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the resource group
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The negotiation status of Tunnel.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Tags
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tunnelOptionsSpecifications")
    def tunnel_options_specifications(self) -> pulumi.Output[Sequence['outputs.GatewayVpnAttachmentTunnelOptionsSpecification']]:
        """
        Configure the tunnel.
        - You can configure parameters in the `tunnel_options_specification` array when you create a vpn attachment in dual-tunnel mode.
        - When creating a vpn attachment in dual-tunnel mode, you must add both tunnels for the vpn attachment to ensure that the vpn attachment has link redundancy. Only two tunnels can be added to a vpn attachment. See `tunnel_options_specification` below.
        """
        return pulumi.get(self, "tunnel_options_specifications")

    @_builtins.property
    @pulumi.getter(name="vpnAttachmentName")
    def vpn_attachment_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        vpn attachment name
        """
        return pulumi.get(self, "vpn_attachment_name")

