# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetGatewayVcoRoutesResult',
    'AwaitableGetGatewayVcoRoutesResult',
    'get_gateway_vco_routes',
    'get_gateway_vco_routes_output',
]

@pulumi.output_type
class GetGatewayVcoRoutesResult:
    """
    A collection of values returned by getGatewayVcoRoutes.
    """
    def __init__(__self__, id=None, ids=None, output_file=None, page_number=None, page_size=None, route_entry_type=None, routes=None, status=None, vpn_connection_id=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if page_number and not isinstance(page_number, int):
            raise TypeError("Expected argument 'page_number' to be a int")
        pulumi.set(__self__, "page_number", page_number)
        if page_size and not isinstance(page_size, int):
            raise TypeError("Expected argument 'page_size' to be a int")
        pulumi.set(__self__, "page_size", page_size)
        if route_entry_type and not isinstance(route_entry_type, str):
            raise TypeError("Expected argument 'route_entry_type' to be a str")
        pulumi.set(__self__, "route_entry_type", route_entry_type)
        if routes and not isinstance(routes, list):
            raise TypeError("Expected argument 'routes' to be a list")
        pulumi.set(__self__, "routes", routes)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if vpn_connection_id and not isinstance(vpn_connection_id, str):
            raise TypeError("Expected argument 'vpn_connection_id' to be a str")
        pulumi.set(__self__, "vpn_connection_id", vpn_connection_id)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")

    @_builtins.property
    @pulumi.getter(name="pageNumber")
    def page_number(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "page_number")

    @_builtins.property
    @pulumi.getter(name="pageSize")
    def page_size(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "page_size")

    @_builtins.property
    @pulumi.getter(name="routeEntryType")
    def route_entry_type(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "route_entry_type")

    @_builtins.property
    @pulumi.getter
    def routes(self) -> Sequence['outputs.GetGatewayVcoRoutesRouteResult']:
        """
        A list of Vpn Gateway Vco Routes. Each element contains the following attributes:
        """
        return pulumi.get(self, "routes")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        The status of the vpn route entry.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="vpnConnectionId")
    def vpn_connection_id(self) -> _builtins.str:
        """
        The id of the vpn connection.
        """
        return pulumi.get(self, "vpn_connection_id")


class AwaitableGetGatewayVcoRoutesResult(GetGatewayVcoRoutesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetGatewayVcoRoutesResult(
            id=self.id,
            ids=self.ids,
            output_file=self.output_file,
            page_number=self.page_number,
            page_size=self.page_size,
            route_entry_type=self.route_entry_type,
            routes=self.routes,
            status=self.status,
            vpn_connection_id=self.vpn_connection_id)


def get_gateway_vco_routes(ids: Optional[Sequence[_builtins.str]] = None,
                           output_file: Optional[_builtins.str] = None,
                           page_number: Optional[_builtins.int] = None,
                           page_size: Optional[_builtins.int] = None,
                           route_entry_type: Optional[_builtins.str] = None,
                           status: Optional[_builtins.str] = None,
                           vpn_connection_id: Optional[_builtins.str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetGatewayVcoRoutesResult:
    """
    This data source provides the Vpn Gateway Vco Routes of the current Alibaba Cloud user.

    > **NOTE:** Available since v1.183.0.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    default_instance = alicloud.cen.Instance("default", cen_instance_name=name)
    default_transit_router = alicloud.cen.TransitRouter("default",
        cen_id=default_instance.id,
        transit_router_description="desd",
        transit_router_name=name)
    default = alicloud.cen.get_transit_router_available_resources()
    default_customer_gateway = alicloud.vpn.CustomerGateway("default",
        name=name,
        ip_address="42.104.22.210",
        asn="45014",
        description="testAccVpnConnectionDesc")
    default_gateway_vpn_attachment = alicloud.vpn.GatewayVpnAttachment("default",
        customer_gateway_id=default_customer_gateway.id,
        network_type="public",
        local_subnet="0.0.0.0/0",
        remote_subnet="0.0.0.0/0",
        effect_immediately=False,
        ike_config={
            "ike_auth_alg": "md5",
            "ike_enc_alg": "des",
            "ike_version": "ikev2",
            "ike_mode": "main",
            "ike_lifetime": 86400,
            "psk": "tf-testvpn2",
            "ike_pfs": "group1",
            "remote_id": "testbob2",
            "local_id": "testalice2",
        },
        ipsec_config={
            "ipsec_pfs": "group5",
            "ipsec_enc_alg": "des",
            "ipsec_auth_alg": "md5",
            "ipsec_lifetime": 86400,
        },
        bgp_config={
            "enable": True,
            "local_asn": 45014,
            "tunnel_cidr": "169.254.11.0/30",
            "local_bgp_ip": "169.254.11.1",
        },
        health_check_config={
            "enable": True,
            "sip": "192.168.1.1",
            "dip": "10.0.0.1",
            "interval": 10,
            "retry": 10,
            "policy": "revoke_route",
        },
        enable_dpd=True,
        enable_nat_traversal=True,
        vpn_attachment_name=name)
    default_transit_router_vpn_attachment = alicloud.cen.TransitRouterVpnAttachment("default",
        auto_publish_route_enabled=False,
        transit_router_attachment_description=name,
        transit_router_attachment_name=name,
        cen_id=default_transit_router.cen_id,
        transit_router_id=default_transit_router.transit_router_id,
        vpn_id=default_gateway_vpn_attachment.id,
        zones=[{
            "zone_id": default.resources[0].master_zones[0],
        }])
    default_gateway_vco_route = alicloud.vpn.GatewayVcoRoute("default",
        route_dest="192.168.12.0/24",
        next_hop=default_transit_router_vpn_attachment.vpn_id,
        vpn_connection_id=default_transit_router_vpn_attachment.vpn_id,
        weight=100)
    default_get_gateway_vco_routes = alicloud.vpn.get_gateway_vco_routes_output(vpn_connection_id=default_transit_router_vpn_attachment.vpn_id)
    pulumi.export("vpnGatewayVcoRouteId1", ids["routes"][0]["id"])
    ```


    :param Sequence[_builtins.str] ids: A list of Vco Route IDs.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str route_entry_type: The Routing input type. Valid values: `custom`, `bgp`.
    :param _builtins.str status: The status of the vpn route entry. Valid values: `normal`, `published`.
    :param _builtins.str vpn_connection_id: The id of the vpn connection.
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['outputFile'] = output_file
    __args__['pageNumber'] = page_number
    __args__['pageSize'] = page_size
    __args__['routeEntryType'] = route_entry_type
    __args__['status'] = status
    __args__['vpnConnectionId'] = vpn_connection_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:vpn/getGatewayVcoRoutes:getGatewayVcoRoutes', __args__, opts=opts, typ=GetGatewayVcoRoutesResult).value

    return AwaitableGetGatewayVcoRoutesResult(
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        output_file=pulumi.get(__ret__, 'output_file'),
        page_number=pulumi.get(__ret__, 'page_number'),
        page_size=pulumi.get(__ret__, 'page_size'),
        route_entry_type=pulumi.get(__ret__, 'route_entry_type'),
        routes=pulumi.get(__ret__, 'routes'),
        status=pulumi.get(__ret__, 'status'),
        vpn_connection_id=pulumi.get(__ret__, 'vpn_connection_id'))
def get_gateway_vco_routes_output(ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                                  output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                  page_number: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                                  page_size: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                                  route_entry_type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                  status: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                  vpn_connection_id: Optional[pulumi.Input[_builtins.str]] = None,
                                  opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetGatewayVcoRoutesResult]:
    """
    This data source provides the Vpn Gateway Vco Routes of the current Alibaba Cloud user.

    > **NOTE:** Available since v1.183.0.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    default_instance = alicloud.cen.Instance("default", cen_instance_name=name)
    default_transit_router = alicloud.cen.TransitRouter("default",
        cen_id=default_instance.id,
        transit_router_description="desd",
        transit_router_name=name)
    default = alicloud.cen.get_transit_router_available_resources()
    default_customer_gateway = alicloud.vpn.CustomerGateway("default",
        name=name,
        ip_address="42.104.22.210",
        asn="45014",
        description="testAccVpnConnectionDesc")
    default_gateway_vpn_attachment = alicloud.vpn.GatewayVpnAttachment("default",
        customer_gateway_id=default_customer_gateway.id,
        network_type="public",
        local_subnet="0.0.0.0/0",
        remote_subnet="0.0.0.0/0",
        effect_immediately=False,
        ike_config={
            "ike_auth_alg": "md5",
            "ike_enc_alg": "des",
            "ike_version": "ikev2",
            "ike_mode": "main",
            "ike_lifetime": 86400,
            "psk": "tf-testvpn2",
            "ike_pfs": "group1",
            "remote_id": "testbob2",
            "local_id": "testalice2",
        },
        ipsec_config={
            "ipsec_pfs": "group5",
            "ipsec_enc_alg": "des",
            "ipsec_auth_alg": "md5",
            "ipsec_lifetime": 86400,
        },
        bgp_config={
            "enable": True,
            "local_asn": 45014,
            "tunnel_cidr": "169.254.11.0/30",
            "local_bgp_ip": "169.254.11.1",
        },
        health_check_config={
            "enable": True,
            "sip": "192.168.1.1",
            "dip": "10.0.0.1",
            "interval": 10,
            "retry": 10,
            "policy": "revoke_route",
        },
        enable_dpd=True,
        enable_nat_traversal=True,
        vpn_attachment_name=name)
    default_transit_router_vpn_attachment = alicloud.cen.TransitRouterVpnAttachment("default",
        auto_publish_route_enabled=False,
        transit_router_attachment_description=name,
        transit_router_attachment_name=name,
        cen_id=default_transit_router.cen_id,
        transit_router_id=default_transit_router.transit_router_id,
        vpn_id=default_gateway_vpn_attachment.id,
        zones=[{
            "zone_id": default.resources[0].master_zones[0],
        }])
    default_gateway_vco_route = alicloud.vpn.GatewayVcoRoute("default",
        route_dest="192.168.12.0/24",
        next_hop=default_transit_router_vpn_attachment.vpn_id,
        vpn_connection_id=default_transit_router_vpn_attachment.vpn_id,
        weight=100)
    default_get_gateway_vco_routes = alicloud.vpn.get_gateway_vco_routes_output(vpn_connection_id=default_transit_router_vpn_attachment.vpn_id)
    pulumi.export("vpnGatewayVcoRouteId1", ids["routes"][0]["id"])
    ```


    :param Sequence[_builtins.str] ids: A list of Vco Route IDs.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str route_entry_type: The Routing input type. Valid values: `custom`, `bgp`.
    :param _builtins.str status: The status of the vpn route entry. Valid values: `normal`, `published`.
    :param _builtins.str vpn_connection_id: The id of the vpn connection.
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['outputFile'] = output_file
    __args__['pageNumber'] = page_number
    __args__['pageSize'] = page_size
    __args__['routeEntryType'] = route_entry_type
    __args__['status'] = status
    __args__['vpnConnectionId'] = vpn_connection_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:vpn/getGatewayVcoRoutes:getGatewayVcoRoutes', __args__, opts=opts, typ=GetGatewayVcoRoutesResult)
    return __ret__.apply(lambda __response__: GetGatewayVcoRoutesResult(
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        output_file=pulumi.get(__response__, 'output_file'),
        page_number=pulumi.get(__response__, 'page_number'),
        page_size=pulumi.get(__response__, 'page_size'),
        route_entry_type=pulumi.get(__response__, 'route_entry_type'),
        routes=pulumi.get(__response__, 'routes'),
        status=pulumi.get(__response__, 'status'),
        vpn_connection_id=pulumi.get(__response__, 'vpn_connection_id')))
