# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'ConnectionBgpConfig',
    'ConnectionHealthCheckConfig',
    'ConnectionIkeConfig',
    'ConnectionIpsecConfig',
    'ConnectionTunnelOptionsSpecification',
    'ConnectionTunnelOptionsSpecificationTunnelBgpConfig',
    'ConnectionTunnelOptionsSpecificationTunnelIkeConfig',
    'ConnectionTunnelOptionsSpecificationTunnelIpsecConfig',
    'GatewayVpnAttachmentBgpConfig',
    'GatewayVpnAttachmentHealthCheckConfig',
    'GatewayVpnAttachmentIkeConfig',
    'GatewayVpnAttachmentIpsecConfig',
    'GatewayVpnAttachmentTunnelOptionsSpecification',
    'GatewayVpnAttachmentTunnelOptionsSpecificationTunnelBgpConfig',
    'GatewayVpnAttachmentTunnelOptionsSpecificationTunnelIkeConfig',
    'GatewayVpnAttachmentTunnelOptionsSpecificationTunnelIpsecConfig',
    'IpsecServerIkeConfig',
    'IpsecServerIpsecConfig',
    'GetConnectionsConnectionResult',
    'GetConnectionsConnectionIkeConfigResult',
    'GetConnectionsConnectionIpsecConfigResult',
    'GetConnectionsConnectionTunnelOptionsSpecificationResult',
    'GetConnectionsConnectionTunnelOptionsSpecificationTunnelBgpConfigResult',
    'GetConnectionsConnectionTunnelOptionsSpecificationTunnelIkeConfigResult',
    'GetConnectionsConnectionTunnelOptionsSpecificationTunnelIpsecConfigResult',
    'GetConnectionsConnectionVcoHealthCheckResult',
    'GetConnectionsConnectionVpnBgpConfigResult',
    'GetCustomerGatewaysGatewayResult',
    'GetGatewayVcoRoutesRouteResult',
    'GetGatewayVpnAttachmentsAttachmentResult',
    'GetGatewayVpnAttachmentsAttachmentBgpConfigResult',
    'GetGatewayVpnAttachmentsAttachmentHealthCheckConfigResult',
    'GetGatewayVpnAttachmentsAttachmentIkeConfigResult',
    'GetGatewayVpnAttachmentsAttachmentIpsecConfigResult',
    'GetGatewayVpnAttachmentsAttachmentTunnelOptionsSpecificationResult',
    'GetGatewayVpnAttachmentsAttachmentTunnelOptionsSpecificationTunnelBgpConfigResult',
    'GetGatewayVpnAttachmentsAttachmentTunnelOptionsSpecificationTunnelIkeConfigResult',
    'GetGatewayVpnAttachmentsAttachmentTunnelOptionsSpecificationTunnelIpsecConfigResult',
    'GetGatewayZonesZoneResult',
    'GetGatewaysGatewayResult',
]

@pulumi.output_type
class ConnectionBgpConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "localAsn":
            suggest = "local_asn"
        elif key == "localBgpIp":
            suggest = "local_bgp_ip"
        elif key == "tunnelCidr":
            suggest = "tunnel_cidr"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionBgpConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionBgpConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionBgpConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable: Optional[_builtins.bool] = None,
                 local_asn: Optional[_builtins.str] = None,
                 local_bgp_ip: Optional[_builtins.str] = None,
                 status: Optional[_builtins.str] = None,
                 tunnel_cidr: Optional[_builtins.str] = None):
        """
        :param _builtins.bool enable: specifies whether to enable BGP. Valid values: true and false (default).
        :param _builtins.str local_asn: the autonomous system number (ASN) on the Alibaba Cloud side. 
               Valid values: 1 to 4294967295. Default value: 45104. You can enter a value in two segments separated by a period (.).
               Each segment is 16 bits in length. Enter the number in each segment in decimal format.
               For example, if you enter 123.456, the ASN is 8061384. The ASN is calculated by using the following formula: 123 × 65536 + 456 = 8061384.
        :param _builtins.str local_bgp_ip: the BGP address on the Alibaba Cloud side. It must be an IP address that falls within the CIDR block of the IPsec tunnel.
        :param _builtins.str status: The negotiation status of Tunnel.
        :param _builtins.str tunnel_cidr: The CIDR block of the IPsec tunnel. The CIDR block must belong to 169.254.0.0/16 and the subnet mask is 30 bits in length.
        """
        if enable is not None:
            pulumi.set(__self__, "enable", enable)
        if local_asn is not None:
            pulumi.set(__self__, "local_asn", local_asn)
        if local_bgp_ip is not None:
            pulumi.set(__self__, "local_bgp_ip", local_bgp_ip)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tunnel_cidr is not None:
            pulumi.set(__self__, "tunnel_cidr", tunnel_cidr)

    @_builtins.property
    @pulumi.getter
    def enable(self) -> Optional[_builtins.bool]:
        """
        specifies whether to enable BGP. Valid values: true and false (default).
        """
        return pulumi.get(self, "enable")

    @_builtins.property
    @pulumi.getter(name="localAsn")
    def local_asn(self) -> Optional[_builtins.str]:
        """
        the autonomous system number (ASN) on the Alibaba Cloud side. 
        Valid values: 1 to 4294967295. Default value: 45104. You can enter a value in two segments separated by a period (.).
        Each segment is 16 bits in length. Enter the number in each segment in decimal format.
        For example, if you enter 123.456, the ASN is 8061384. The ASN is calculated by using the following formula: 123 × 65536 + 456 = 8061384.
        """
        return pulumi.get(self, "local_asn")

    @_builtins.property
    @pulumi.getter(name="localBgpIp")
    def local_bgp_ip(self) -> Optional[_builtins.str]:
        """
        the BGP address on the Alibaba Cloud side. It must be an IP address that falls within the CIDR block of the IPsec tunnel.
        """
        return pulumi.get(self, "local_bgp_ip")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        The negotiation status of Tunnel.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="tunnelCidr")
    def tunnel_cidr(self) -> Optional[_builtins.str]:
        """
        The CIDR block of the IPsec tunnel. The CIDR block must belong to 169.254.0.0/16 and the subnet mask is 30 bits in length.
        """
        return pulumi.get(self, "tunnel_cidr")


@pulumi.output_type
class ConnectionHealthCheckConfig(dict):
    def __init__(__self__, *,
                 dip: Optional[_builtins.str] = None,
                 enable: Optional[_builtins.bool] = None,
                 interval: Optional[_builtins.int] = None,
                 retry: Optional[_builtins.int] = None,
                 sip: Optional[_builtins.str] = None):
        """
        :param _builtins.str dip: the destination IP address configured for health checks.
        :param _builtins.bool enable: specifies whether to enable health checks. Valid values: true and false. Default value: false.
        :param _builtins.int interval: the time interval of health check retries. Unit: seconds. Default value: 3.
        :param _builtins.int retry: the maximum number of health check retries. Default value: 3.
        :param _builtins.str sip: the source IP address that is used for health checks.
        """
        if dip is not None:
            pulumi.set(__self__, "dip", dip)
        if enable is not None:
            pulumi.set(__self__, "enable", enable)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if retry is not None:
            pulumi.set(__self__, "retry", retry)
        if sip is not None:
            pulumi.set(__self__, "sip", sip)

    @_builtins.property
    @pulumi.getter
    def dip(self) -> Optional[_builtins.str]:
        """
        the destination IP address configured for health checks.
        """
        return pulumi.get(self, "dip")

    @_builtins.property
    @pulumi.getter
    def enable(self) -> Optional[_builtins.bool]:
        """
        specifies whether to enable health checks. Valid values: true and false. Default value: false.
        """
        return pulumi.get(self, "enable")

    @_builtins.property
    @pulumi.getter
    def interval(self) -> Optional[_builtins.int]:
        """
        the time interval of health check retries. Unit: seconds. Default value: 3.
        """
        return pulumi.get(self, "interval")

    @_builtins.property
    @pulumi.getter
    def retry(self) -> Optional[_builtins.int]:
        """
        the maximum number of health check retries. Default value: 3.
        """
        return pulumi.get(self, "retry")

    @_builtins.property
    @pulumi.getter
    def sip(self) -> Optional[_builtins.str]:
        """
        the source IP address that is used for health checks.
        """
        return pulumi.get(self, "sip")


@pulumi.output_type
class ConnectionIkeConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ikeAuthAlg":
            suggest = "ike_auth_alg"
        elif key == "ikeEncAlg":
            suggest = "ike_enc_alg"
        elif key == "ikeLifetime":
            suggest = "ike_lifetime"
        elif key == "ikeLocalId":
            suggest = "ike_local_id"
        elif key == "ikeMode":
            suggest = "ike_mode"
        elif key == "ikePfs":
            suggest = "ike_pfs"
        elif key == "ikeRemoteId":
            suggest = "ike_remote_id"
        elif key == "ikeVersion":
            suggest = "ike_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionIkeConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionIkeConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionIkeConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ike_auth_alg: Optional[_builtins.str] = None,
                 ike_enc_alg: Optional[_builtins.str] = None,
                 ike_lifetime: Optional[_builtins.int] = None,
                 ike_local_id: Optional[_builtins.str] = None,
                 ike_mode: Optional[_builtins.str] = None,
                 ike_pfs: Optional[_builtins.str] = None,
                 ike_remote_id: Optional[_builtins.str] = None,
                 ike_version: Optional[_builtins.str] = None,
                 psk: Optional[_builtins.str] = None):
        """
        :param _builtins.str ike_auth_alg: the authentication algorithm that is used in Phase 1 negotiations. Valid values: md5, sha1, sha2
        :param _builtins.str ike_enc_alg: the encryption algorithm that is used in Phase 1 negotiations. Valid values: aes, aes192, aes256, des, and 3des. Default value: aes.
        :param _builtins.int ike_lifetime: the SA lifetime as a result of Phase 1 negotiations. Unit: seconds. Valid values: 0 to 86400. Default value: 86400.
        :param _builtins.str ike_local_id: the identifier of the VPN gateway. It can contain at most 100 characters. The default value is the IP address of the VPN gateway.
        :param _builtins.str ike_mode: the negotiation mode of IKE. Valid values: main and aggressive. Default value: main.
               - main: This mode offers higher security during negotiations.
               - aggressive: This mode supports faster negotiations and a higher success rate.
        :param _builtins.str ike_pfs: the Diffie-Hellman key exchange algorithm that is used in Phase 1 negotiations. Valid values: group1, group2, group5, and group14. Default value: group2.
        :param _builtins.str ike_remote_id: the identifier of the customer gateway. It can contain at most 100 characters. The default value is the IP address of the customer gateway.
        :param _builtins.str ike_version: the version of the Internet Key Exchange (IKE) protocol. Valid values: ikev1 and ikev2. Default value: ikev1.
               Compared with IKEv1, IKEv2 simplifies the security association (SA) negotiation process and provides better support for scenarios with multiple CIDR blocks.
        :param _builtins.str psk: the pre-shared key that is used for identity authentication between the VPN gateway and the on-premises data center. The key must be 1 to 100 characters in length and can contain digits, letters, and the following special characters: ~!\\`@#$%^&*()_-+={}[]|;:',.<>/? If you do not specify a pre-shared key, the system randomly generates a 16-bit string as the pre-shared key. You can call the DescribeVpnConnection operation to query the pre-shared key that is automatically generated by the system.
        """
        if ike_auth_alg is not None:
            pulumi.set(__self__, "ike_auth_alg", ike_auth_alg)
        if ike_enc_alg is not None:
            pulumi.set(__self__, "ike_enc_alg", ike_enc_alg)
        if ike_lifetime is not None:
            pulumi.set(__self__, "ike_lifetime", ike_lifetime)
        if ike_local_id is not None:
            pulumi.set(__self__, "ike_local_id", ike_local_id)
        if ike_mode is not None:
            pulumi.set(__self__, "ike_mode", ike_mode)
        if ike_pfs is not None:
            pulumi.set(__self__, "ike_pfs", ike_pfs)
        if ike_remote_id is not None:
            pulumi.set(__self__, "ike_remote_id", ike_remote_id)
        if ike_version is not None:
            pulumi.set(__self__, "ike_version", ike_version)
        if psk is not None:
            pulumi.set(__self__, "psk", psk)

    @_builtins.property
    @pulumi.getter(name="ikeAuthAlg")
    def ike_auth_alg(self) -> Optional[_builtins.str]:
        """
        the authentication algorithm that is used in Phase 1 negotiations. Valid values: md5, sha1, sha2
        """
        return pulumi.get(self, "ike_auth_alg")

    @_builtins.property
    @pulumi.getter(name="ikeEncAlg")
    def ike_enc_alg(self) -> Optional[_builtins.str]:
        """
        the encryption algorithm that is used in Phase 1 negotiations. Valid values: aes, aes192, aes256, des, and 3des. Default value: aes.
        """
        return pulumi.get(self, "ike_enc_alg")

    @_builtins.property
    @pulumi.getter(name="ikeLifetime")
    def ike_lifetime(self) -> Optional[_builtins.int]:
        """
        the SA lifetime as a result of Phase 1 negotiations. Unit: seconds. Valid values: 0 to 86400. Default value: 86400.
        """
        return pulumi.get(self, "ike_lifetime")

    @_builtins.property
    @pulumi.getter(name="ikeLocalId")
    def ike_local_id(self) -> Optional[_builtins.str]:
        """
        the identifier of the VPN gateway. It can contain at most 100 characters. The default value is the IP address of the VPN gateway.
        """
        return pulumi.get(self, "ike_local_id")

    @_builtins.property
    @pulumi.getter(name="ikeMode")
    def ike_mode(self) -> Optional[_builtins.str]:
        """
        the negotiation mode of IKE. Valid values: main and aggressive. Default value: main.
        - main: This mode offers higher security during negotiations.
        - aggressive: This mode supports faster negotiations and a higher success rate.
        """
        return pulumi.get(self, "ike_mode")

    @_builtins.property
    @pulumi.getter(name="ikePfs")
    def ike_pfs(self) -> Optional[_builtins.str]:
        """
        the Diffie-Hellman key exchange algorithm that is used in Phase 1 negotiations. Valid values: group1, group2, group5, and group14. Default value: group2.
        """
        return pulumi.get(self, "ike_pfs")

    @_builtins.property
    @pulumi.getter(name="ikeRemoteId")
    def ike_remote_id(self) -> Optional[_builtins.str]:
        """
        the identifier of the customer gateway. It can contain at most 100 characters. The default value is the IP address of the customer gateway.
        """
        return pulumi.get(self, "ike_remote_id")

    @_builtins.property
    @pulumi.getter(name="ikeVersion")
    def ike_version(self) -> Optional[_builtins.str]:
        """
        the version of the Internet Key Exchange (IKE) protocol. Valid values: ikev1 and ikev2. Default value: ikev1.
        Compared with IKEv1, IKEv2 simplifies the security association (SA) negotiation process and provides better support for scenarios with multiple CIDR blocks.
        """
        return pulumi.get(self, "ike_version")

    @_builtins.property
    @pulumi.getter
    def psk(self) -> Optional[_builtins.str]:
        """
        the pre-shared key that is used for identity authentication between the VPN gateway and the on-premises data center. The key must be 1 to 100 characters in length and can contain digits, letters, and the following special characters: ~!\\`@#$%^&*()_-+={}[]|;:',.<>/? If you do not specify a pre-shared key, the system randomly generates a 16-bit string as the pre-shared key. You can call the DescribeVpnConnection operation to query the pre-shared key that is automatically generated by the system.
        """
        return pulumi.get(self, "psk")


@pulumi.output_type
class ConnectionIpsecConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipsecAuthAlg":
            suggest = "ipsec_auth_alg"
        elif key == "ipsecEncAlg":
            suggest = "ipsec_enc_alg"
        elif key == "ipsecLifetime":
            suggest = "ipsec_lifetime"
        elif key == "ipsecPfs":
            suggest = "ipsec_pfs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionIpsecConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionIpsecConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionIpsecConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ipsec_auth_alg: Optional[_builtins.str] = None,
                 ipsec_enc_alg: Optional[_builtins.str] = None,
                 ipsec_lifetime: Optional[_builtins.int] = None,
                 ipsec_pfs: Optional[_builtins.str] = None):
        """
        :param _builtins.str ipsec_auth_alg: the authentication algorithm that is used in Phase 2 negotiations. Valid values: md5, sha1, sha256, sha384, and sha512. Default value: md5.
        :param _builtins.str ipsec_enc_alg: the encryption algorithm that is used in Phase 2 negotiations. Valid values: aes, aes192, aes256, des, and 3des. Default value: aes.
        :param _builtins.int ipsec_lifetime: the SA lifetime that is determined by Phase 2 negotiations. Unit: seconds. Valid values: 0 to 86400. Default value: 86400.
        :param _builtins.str ipsec_pfs: the DH key exchange algorithm that is used in Phase 2 negotiations. Valid values: disabled, group1, group2, group5, and group14. Default value: group2.
        """
        if ipsec_auth_alg is not None:
            pulumi.set(__self__, "ipsec_auth_alg", ipsec_auth_alg)
        if ipsec_enc_alg is not None:
            pulumi.set(__self__, "ipsec_enc_alg", ipsec_enc_alg)
        if ipsec_lifetime is not None:
            pulumi.set(__self__, "ipsec_lifetime", ipsec_lifetime)
        if ipsec_pfs is not None:
            pulumi.set(__self__, "ipsec_pfs", ipsec_pfs)

    @_builtins.property
    @pulumi.getter(name="ipsecAuthAlg")
    def ipsec_auth_alg(self) -> Optional[_builtins.str]:
        """
        the authentication algorithm that is used in Phase 2 negotiations. Valid values: md5, sha1, sha256, sha384, and sha512. Default value: md5.
        """
        return pulumi.get(self, "ipsec_auth_alg")

    @_builtins.property
    @pulumi.getter(name="ipsecEncAlg")
    def ipsec_enc_alg(self) -> Optional[_builtins.str]:
        """
        the encryption algorithm that is used in Phase 2 negotiations. Valid values: aes, aes192, aes256, des, and 3des. Default value: aes.
        """
        return pulumi.get(self, "ipsec_enc_alg")

    @_builtins.property
    @pulumi.getter(name="ipsecLifetime")
    def ipsec_lifetime(self) -> Optional[_builtins.int]:
        """
        the SA lifetime that is determined by Phase 2 negotiations. Unit: seconds. Valid values: 0 to 86400. Default value: 86400.
        """
        return pulumi.get(self, "ipsec_lifetime")

    @_builtins.property
    @pulumi.getter(name="ipsecPfs")
    def ipsec_pfs(self) -> Optional[_builtins.str]:
        """
        the DH key exchange algorithm that is used in Phase 2 negotiations. Valid values: disabled, group1, group2, group5, and group14. Default value: group2.
        """
        return pulumi.get(self, "ipsec_pfs")


@pulumi.output_type
class ConnectionTunnelOptionsSpecification(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customerGatewayId":
            suggest = "customer_gateway_id"
        elif key == "enableDpd":
            suggest = "enable_dpd"
        elif key == "enableNatTraversal":
            suggest = "enable_nat_traversal"
        elif key == "internetIp":
            suggest = "internet_ip"
        elif key == "tunnelBgpConfig":
            suggest = "tunnel_bgp_config"
        elif key == "tunnelId":
            suggest = "tunnel_id"
        elif key == "tunnelIkeConfig":
            suggest = "tunnel_ike_config"
        elif key == "tunnelIpsecConfig":
            suggest = "tunnel_ipsec_config"
        elif key == "zoneNo":
            suggest = "zone_no"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionTunnelOptionsSpecification. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionTunnelOptionsSpecification.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionTunnelOptionsSpecification.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 customer_gateway_id: Optional[_builtins.str] = None,
                 enable_dpd: Optional[_builtins.bool] = None,
                 enable_nat_traversal: Optional[_builtins.bool] = None,
                 internet_ip: Optional[_builtins.str] = None,
                 role: Optional[_builtins.str] = None,
                 state: Optional[_builtins.str] = None,
                 status: Optional[_builtins.str] = None,
                 tunnel_bgp_config: Optional['outputs.ConnectionTunnelOptionsSpecificationTunnelBgpConfig'] = None,
                 tunnel_id: Optional[_builtins.str] = None,
                 tunnel_ike_config: Optional['outputs.ConnectionTunnelOptionsSpecificationTunnelIkeConfig'] = None,
                 tunnel_ipsec_config: Optional['outputs.ConnectionTunnelOptionsSpecificationTunnelIpsecConfig'] = None,
                 zone_no: Optional[_builtins.str] = None):
        """
        :param _builtins.str customer_gateway_id: The ID of the customer gateway in Tunnel.
        :param _builtins.bool enable_dpd: Wether enable Dpd detection.
        :param _builtins.bool enable_nat_traversal: enable nat traversal.
        :param _builtins.str internet_ip: The local internet IP in Tunnel.
        :param _builtins.str role: The role of Tunnel.
        :param _builtins.str state: The state of Tunnel.
        :param _builtins.str status: The negotiation status of Tunnel.
        :param 'ConnectionTunnelOptionsSpecificationTunnelBgpConfigArgs' tunnel_bgp_config: The bgp config of Tunnel. See `tunnel_bgp_config` below.
        :param _builtins.str tunnel_id: The tunnel ID of IPsec-VPN connection.
        :param 'ConnectionTunnelOptionsSpecificationTunnelIkeConfigArgs' tunnel_ike_config: The configuration of Phase 1 negotiations in Tunnel. See `tunnel_ike_config` below.
        :param 'ConnectionTunnelOptionsSpecificationTunnelIpsecConfigArgs' tunnel_ipsec_config: IPsec configuration in Tunnel. See `tunnel_ipsec_config` below.
        :param _builtins.str zone_no: The zoneNo of tunnel.
        """
        if customer_gateway_id is not None:
            pulumi.set(__self__, "customer_gateway_id", customer_gateway_id)
        if enable_dpd is not None:
            pulumi.set(__self__, "enable_dpd", enable_dpd)
        if enable_nat_traversal is not None:
            pulumi.set(__self__, "enable_nat_traversal", enable_nat_traversal)
        if internet_ip is not None:
            pulumi.set(__self__, "internet_ip", internet_ip)
        if role is not None:
            pulumi.set(__self__, "role", role)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tunnel_bgp_config is not None:
            pulumi.set(__self__, "tunnel_bgp_config", tunnel_bgp_config)
        if tunnel_id is not None:
            pulumi.set(__self__, "tunnel_id", tunnel_id)
        if tunnel_ike_config is not None:
            pulumi.set(__self__, "tunnel_ike_config", tunnel_ike_config)
        if tunnel_ipsec_config is not None:
            pulumi.set(__self__, "tunnel_ipsec_config", tunnel_ipsec_config)
        if zone_no is not None:
            pulumi.set(__self__, "zone_no", zone_no)

    @_builtins.property
    @pulumi.getter(name="customerGatewayId")
    def customer_gateway_id(self) -> Optional[_builtins.str]:
        """
        The ID of the customer gateway in Tunnel.
        """
        return pulumi.get(self, "customer_gateway_id")

    @_builtins.property
    @pulumi.getter(name="enableDpd")
    def enable_dpd(self) -> Optional[_builtins.bool]:
        """
        Wether enable Dpd detection.
        """
        return pulumi.get(self, "enable_dpd")

    @_builtins.property
    @pulumi.getter(name="enableNatTraversal")
    def enable_nat_traversal(self) -> Optional[_builtins.bool]:
        """
        enable nat traversal.
        """
        return pulumi.get(self, "enable_nat_traversal")

    @_builtins.property
    @pulumi.getter(name="internetIp")
    def internet_ip(self) -> Optional[_builtins.str]:
        """
        The local internet IP in Tunnel.
        """
        return pulumi.get(self, "internet_ip")

    @_builtins.property
    @pulumi.getter
    def role(self) -> Optional[_builtins.str]:
        """
        The role of Tunnel.
        """
        return pulumi.get(self, "role")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        The state of Tunnel.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        The negotiation status of Tunnel.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="tunnelBgpConfig")
    def tunnel_bgp_config(self) -> Optional['outputs.ConnectionTunnelOptionsSpecificationTunnelBgpConfig']:
        """
        The bgp config of Tunnel. See `tunnel_bgp_config` below.
        """
        return pulumi.get(self, "tunnel_bgp_config")

    @_builtins.property
    @pulumi.getter(name="tunnelId")
    def tunnel_id(self) -> Optional[_builtins.str]:
        """
        The tunnel ID of IPsec-VPN connection.
        """
        return pulumi.get(self, "tunnel_id")

    @_builtins.property
    @pulumi.getter(name="tunnelIkeConfig")
    def tunnel_ike_config(self) -> Optional['outputs.ConnectionTunnelOptionsSpecificationTunnelIkeConfig']:
        """
        The configuration of Phase 1 negotiations in Tunnel. See `tunnel_ike_config` below.
        """
        return pulumi.get(self, "tunnel_ike_config")

    @_builtins.property
    @pulumi.getter(name="tunnelIpsecConfig")
    def tunnel_ipsec_config(self) -> Optional['outputs.ConnectionTunnelOptionsSpecificationTunnelIpsecConfig']:
        """
        IPsec configuration in Tunnel. See `tunnel_ipsec_config` below.
        """
        return pulumi.get(self, "tunnel_ipsec_config")

    @_builtins.property
    @pulumi.getter(name="zoneNo")
    def zone_no(self) -> Optional[_builtins.str]:
        """
        The zoneNo of tunnel.
        """
        return pulumi.get(self, "zone_no")


@pulumi.output_type
class ConnectionTunnelOptionsSpecificationTunnelBgpConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bgpStatus":
            suggest = "bgp_status"
        elif key == "localAsn":
            suggest = "local_asn"
        elif key == "localBgpIp":
            suggest = "local_bgp_ip"
        elif key == "peerAsn":
            suggest = "peer_asn"
        elif key == "peerBgpIp":
            suggest = "peer_bgp_ip"
        elif key == "tunnelCidr":
            suggest = "tunnel_cidr"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionTunnelOptionsSpecificationTunnelBgpConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionTunnelOptionsSpecificationTunnelBgpConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionTunnelOptionsSpecificationTunnelBgpConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bgp_status: Optional[_builtins.str] = None,
                 local_asn: Optional[_builtins.str] = None,
                 local_bgp_ip: Optional[_builtins.str] = None,
                 peer_asn: Optional[_builtins.str] = None,
                 peer_bgp_ip: Optional[_builtins.str] = None,
                 tunnel_cidr: Optional[_builtins.str] = None):
        """
        :param _builtins.str bgp_status: Whether BGP function is turned on.
        :param _builtins.str peer_asn: Peer asn.
        :param _builtins.str peer_bgp_ip: Peer bgp ip.
        """
        if bgp_status is not None:
            pulumi.set(__self__, "bgp_status", bgp_status)
        if local_asn is not None:
            pulumi.set(__self__, "local_asn", local_asn)
        if local_bgp_ip is not None:
            pulumi.set(__self__, "local_bgp_ip", local_bgp_ip)
        if peer_asn is not None:
            pulumi.set(__self__, "peer_asn", peer_asn)
        if peer_bgp_ip is not None:
            pulumi.set(__self__, "peer_bgp_ip", peer_bgp_ip)
        if tunnel_cidr is not None:
            pulumi.set(__self__, "tunnel_cidr", tunnel_cidr)

    @_builtins.property
    @pulumi.getter(name="bgpStatus")
    def bgp_status(self) -> Optional[_builtins.str]:
        """
        Whether BGP function is turned on.
        """
        return pulumi.get(self, "bgp_status")

    @_builtins.property
    @pulumi.getter(name="localAsn")
    def local_asn(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "local_asn")

    @_builtins.property
    @pulumi.getter(name="localBgpIp")
    def local_bgp_ip(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "local_bgp_ip")

    @_builtins.property
    @pulumi.getter(name="peerAsn")
    def peer_asn(self) -> Optional[_builtins.str]:
        """
        Peer asn.
        """
        return pulumi.get(self, "peer_asn")

    @_builtins.property
    @pulumi.getter(name="peerBgpIp")
    def peer_bgp_ip(self) -> Optional[_builtins.str]:
        """
        Peer bgp ip.
        """
        return pulumi.get(self, "peer_bgp_ip")

    @_builtins.property
    @pulumi.getter(name="tunnelCidr")
    def tunnel_cidr(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "tunnel_cidr")


@pulumi.output_type
class ConnectionTunnelOptionsSpecificationTunnelIkeConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ikeAuthAlg":
            suggest = "ike_auth_alg"
        elif key == "ikeEncAlg":
            suggest = "ike_enc_alg"
        elif key == "ikeLifetime":
            suggest = "ike_lifetime"
        elif key == "ikeMode":
            suggest = "ike_mode"
        elif key == "ikePfs":
            suggest = "ike_pfs"
        elif key == "ikeVersion":
            suggest = "ike_version"
        elif key == "localId":
            suggest = "local_id"
        elif key == "remoteId":
            suggest = "remote_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionTunnelOptionsSpecificationTunnelIkeConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionTunnelOptionsSpecificationTunnelIkeConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionTunnelOptionsSpecificationTunnelIkeConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ike_auth_alg: Optional[_builtins.str] = None,
                 ike_enc_alg: Optional[_builtins.str] = None,
                 ike_lifetime: Optional[_builtins.int] = None,
                 ike_mode: Optional[_builtins.str] = None,
                 ike_pfs: Optional[_builtins.str] = None,
                 ike_version: Optional[_builtins.str] = None,
                 local_id: Optional[_builtins.str] = None,
                 psk: Optional[_builtins.str] = None,
                 remote_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str local_id: The identifier of the tunnel on the Alibaba Cloud side, which is used in Phase 1 negotiations. It can contain at most 100 characters. The default value is the IP address of the tunnel.
               LocalId supports fully qualified domain names (FQDNs). If you use an FQDN, we recommend that you set the negotiation mode to aggressive.
        :param _builtins.str remote_id: The identifier of the tunnel peer, which is used in Phase 1 negotiations. It can contain at most 100 characters. The default value is the IP address of the customer gateway that is associated with the tunnel.
               RemoteId supports FQDNs. If you use an FQDN, we recommend that you set the negotiation mode to aggressive.
        """
        if ike_auth_alg is not None:
            pulumi.set(__self__, "ike_auth_alg", ike_auth_alg)
        if ike_enc_alg is not None:
            pulumi.set(__self__, "ike_enc_alg", ike_enc_alg)
        if ike_lifetime is not None:
            pulumi.set(__self__, "ike_lifetime", ike_lifetime)
        if ike_mode is not None:
            pulumi.set(__self__, "ike_mode", ike_mode)
        if ike_pfs is not None:
            pulumi.set(__self__, "ike_pfs", ike_pfs)
        if ike_version is not None:
            pulumi.set(__self__, "ike_version", ike_version)
        if local_id is not None:
            pulumi.set(__self__, "local_id", local_id)
        if psk is not None:
            pulumi.set(__self__, "psk", psk)
        if remote_id is not None:
            pulumi.set(__self__, "remote_id", remote_id)

    @_builtins.property
    @pulumi.getter(name="ikeAuthAlg")
    def ike_auth_alg(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "ike_auth_alg")

    @_builtins.property
    @pulumi.getter(name="ikeEncAlg")
    def ike_enc_alg(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "ike_enc_alg")

    @_builtins.property
    @pulumi.getter(name="ikeLifetime")
    def ike_lifetime(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "ike_lifetime")

    @_builtins.property
    @pulumi.getter(name="ikeMode")
    def ike_mode(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "ike_mode")

    @_builtins.property
    @pulumi.getter(name="ikePfs")
    def ike_pfs(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "ike_pfs")

    @_builtins.property
    @pulumi.getter(name="ikeVersion")
    def ike_version(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "ike_version")

    @_builtins.property
    @pulumi.getter(name="localId")
    def local_id(self) -> Optional[_builtins.str]:
        """
        The identifier of the tunnel on the Alibaba Cloud side, which is used in Phase 1 negotiations. It can contain at most 100 characters. The default value is the IP address of the tunnel.
        LocalId supports fully qualified domain names (FQDNs). If you use an FQDN, we recommend that you set the negotiation mode to aggressive.
        """
        return pulumi.get(self, "local_id")

    @_builtins.property
    @pulumi.getter
    def psk(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "psk")

    @_builtins.property
    @pulumi.getter(name="remoteId")
    def remote_id(self) -> Optional[_builtins.str]:
        """
        The identifier of the tunnel peer, which is used in Phase 1 negotiations. It can contain at most 100 characters. The default value is the IP address of the customer gateway that is associated with the tunnel.
        RemoteId supports FQDNs. If you use an FQDN, we recommend that you set the negotiation mode to aggressive.
        """
        return pulumi.get(self, "remote_id")


@pulumi.output_type
class ConnectionTunnelOptionsSpecificationTunnelIpsecConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipsecAuthAlg":
            suggest = "ipsec_auth_alg"
        elif key == "ipsecEncAlg":
            suggest = "ipsec_enc_alg"
        elif key == "ipsecLifetime":
            suggest = "ipsec_lifetime"
        elif key == "ipsecPfs":
            suggest = "ipsec_pfs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionTunnelOptionsSpecificationTunnelIpsecConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionTunnelOptionsSpecificationTunnelIpsecConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionTunnelOptionsSpecificationTunnelIpsecConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ipsec_auth_alg: Optional[_builtins.str] = None,
                 ipsec_enc_alg: Optional[_builtins.str] = None,
                 ipsec_lifetime: Optional[_builtins.int] = None,
                 ipsec_pfs: Optional[_builtins.str] = None):
        if ipsec_auth_alg is not None:
            pulumi.set(__self__, "ipsec_auth_alg", ipsec_auth_alg)
        if ipsec_enc_alg is not None:
            pulumi.set(__self__, "ipsec_enc_alg", ipsec_enc_alg)
        if ipsec_lifetime is not None:
            pulumi.set(__self__, "ipsec_lifetime", ipsec_lifetime)
        if ipsec_pfs is not None:
            pulumi.set(__self__, "ipsec_pfs", ipsec_pfs)

    @_builtins.property
    @pulumi.getter(name="ipsecAuthAlg")
    def ipsec_auth_alg(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "ipsec_auth_alg")

    @_builtins.property
    @pulumi.getter(name="ipsecEncAlg")
    def ipsec_enc_alg(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "ipsec_enc_alg")

    @_builtins.property
    @pulumi.getter(name="ipsecLifetime")
    def ipsec_lifetime(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "ipsec_lifetime")

    @_builtins.property
    @pulumi.getter(name="ipsecPfs")
    def ipsec_pfs(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "ipsec_pfs")


@pulumi.output_type
class GatewayVpnAttachmentBgpConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "localAsn":
            suggest = "local_asn"
        elif key == "localBgpIp":
            suggest = "local_bgp_ip"
        elif key == "tunnelCidr":
            suggest = "tunnel_cidr"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GatewayVpnAttachmentBgpConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GatewayVpnAttachmentBgpConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GatewayVpnAttachmentBgpConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable: Optional[_builtins.bool] = None,
                 local_asn: Optional[_builtins.int] = None,
                 local_bgp_ip: Optional[_builtins.str] = None,
                 status: Optional[_builtins.str] = None,
                 tunnel_cidr: Optional[_builtins.str] = None):
        """
        :param _builtins.bool enable: Whether to enable the BGP function. Valid values: true or false (default).
        :param _builtins.int local_asn: The autonomous system number on the Alibaba Cloud side. The value range of autonomous system number is 1~4294967295. Default value: 45104
        :param _builtins.str local_bgp_ip: The BGP address on the Alibaba Cloud side. This address is an IP address in the IPsec tunnel network segment.
               - Before adding the BGP configuration, we recommend that you understand the working mechanism and usage restrictions of the BGP dynamic routing function. For more information, see BGP Dynamic Routing Bulletin.
               - We recommend that you use the private number of the autonomous system number to establish a BGP connection with Alibaba Cloud. Please refer to the documentation for the private number range of the autonomous system number.
        :param _builtins.str status: The negotiation status of Tunnel.
        :param _builtins.str tunnel_cidr: IPsec tunnel network segment. This network segment must be a network segment with a mask length of 30 within 169.254.0.0/16
        """
        if enable is not None:
            pulumi.set(__self__, "enable", enable)
        if local_asn is not None:
            pulumi.set(__self__, "local_asn", local_asn)
        if local_bgp_ip is not None:
            pulumi.set(__self__, "local_bgp_ip", local_bgp_ip)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tunnel_cidr is not None:
            pulumi.set(__self__, "tunnel_cidr", tunnel_cidr)

    @_builtins.property
    @pulumi.getter
    def enable(self) -> Optional[_builtins.bool]:
        """
        Whether to enable the BGP function. Valid values: true or false (default).
        """
        return pulumi.get(self, "enable")

    @_builtins.property
    @pulumi.getter(name="localAsn")
    def local_asn(self) -> Optional[_builtins.int]:
        """
        The autonomous system number on the Alibaba Cloud side. The value range of autonomous system number is 1~4294967295. Default value: 45104
        """
        return pulumi.get(self, "local_asn")

    @_builtins.property
    @pulumi.getter(name="localBgpIp")
    def local_bgp_ip(self) -> Optional[_builtins.str]:
        """
        The BGP address on the Alibaba Cloud side. This address is an IP address in the IPsec tunnel network segment.
        - Before adding the BGP configuration, we recommend that you understand the working mechanism and usage restrictions of the BGP dynamic routing function. For more information, see BGP Dynamic Routing Bulletin.
        - We recommend that you use the private number of the autonomous system number to establish a BGP connection with Alibaba Cloud. Please refer to the documentation for the private number range of the autonomous system number.
        """
        return pulumi.get(self, "local_bgp_ip")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        The negotiation status of Tunnel.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="tunnelCidr")
    def tunnel_cidr(self) -> Optional[_builtins.str]:
        """
        IPsec tunnel network segment. This network segment must be a network segment with a mask length of 30 within 169.254.0.0/16
        """
        return pulumi.get(self, "tunnel_cidr")


@pulumi.output_type
class GatewayVpnAttachmentHealthCheckConfig(dict):
    def __init__(__self__, *,
                 dip: Optional[_builtins.str] = None,
                 enable: Optional[_builtins.bool] = None,
                 interval: Optional[_builtins.int] = None,
                 policy: Optional[_builtins.str] = None,
                 retry: Optional[_builtins.int] = None,
                 sip: Optional[_builtins.str] = None,
                 status: Optional[_builtins.str] = None):
        """
        :param _builtins.str dip: Target IP.
        :param _builtins.bool enable: Whether health check is enabled:-`false`: not enabled. - `true`: enabled.
        :param _builtins.int interval: The health check retry interval, in seconds.
        :param _builtins.str policy: Whether to revoke the published route when the health check fails
        :param _builtins.int retry: Number of retries for health check.
        :param _builtins.str sip: SOURCE IP.
        :param _builtins.str status: The negotiation status of Tunnel.
        """
        if dip is not None:
            pulumi.set(__self__, "dip", dip)
        if enable is not None:
            pulumi.set(__self__, "enable", enable)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if policy is not None:
            pulumi.set(__self__, "policy", policy)
        if retry is not None:
            pulumi.set(__self__, "retry", retry)
        if sip is not None:
            pulumi.set(__self__, "sip", sip)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter
    def dip(self) -> Optional[_builtins.str]:
        """
        Target IP.
        """
        return pulumi.get(self, "dip")

    @_builtins.property
    @pulumi.getter
    def enable(self) -> Optional[_builtins.bool]:
        """
        Whether health check is enabled:-`false`: not enabled. - `true`: enabled.
        """
        return pulumi.get(self, "enable")

    @_builtins.property
    @pulumi.getter
    def interval(self) -> Optional[_builtins.int]:
        """
        The health check retry interval, in seconds.
        """
        return pulumi.get(self, "interval")

    @_builtins.property
    @pulumi.getter
    def policy(self) -> Optional[_builtins.str]:
        """
        Whether to revoke the published route when the health check fails
        """
        return pulumi.get(self, "policy")

    @_builtins.property
    @pulumi.getter
    def retry(self) -> Optional[_builtins.int]:
        """
        Number of retries for health check.
        """
        return pulumi.get(self, "retry")

    @_builtins.property
    @pulumi.getter
    def sip(self) -> Optional[_builtins.str]:
        """
        SOURCE IP.
        """
        return pulumi.get(self, "sip")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        The negotiation status of Tunnel.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GatewayVpnAttachmentIkeConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ikeAuthAlg":
            suggest = "ike_auth_alg"
        elif key == "ikeEncAlg":
            suggest = "ike_enc_alg"
        elif key == "ikeLifetime":
            suggest = "ike_lifetime"
        elif key == "ikeMode":
            suggest = "ike_mode"
        elif key == "ikePfs":
            suggest = "ike_pfs"
        elif key == "ikeVersion":
            suggest = "ike_version"
        elif key == "localId":
            suggest = "local_id"
        elif key == "remoteId":
            suggest = "remote_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GatewayVpnAttachmentIkeConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GatewayVpnAttachmentIkeConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GatewayVpnAttachmentIkeConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ike_auth_alg: Optional[_builtins.str] = None,
                 ike_enc_alg: Optional[_builtins.str] = None,
                 ike_lifetime: Optional[_builtins.int] = None,
                 ike_mode: Optional[_builtins.str] = None,
                 ike_pfs: Optional[_builtins.str] = None,
                 ike_version: Optional[_builtins.str] = None,
                 local_id: Optional[_builtins.str] = None,
                 psk: Optional[_builtins.str] = None,
                 remote_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str ike_auth_alg: The authentication algorithm negotiated in the first stage. Valid values: md5, sha1, sha256, sha384, sha512. Default value: md5.
        :param _builtins.str ike_enc_alg: The encryption algorithm that is used in Phase 1 negotiations. Valid values: aes, aes192, aes256, des, and 3des. Default value: aes.
        :param _builtins.int ike_lifetime: The SA lifetime as a result of Phase 1 negotiations. Unit: seconds. Valid values: 0 to 86400. Default value: 86400.
        :param _builtins.str ike_mode: IKE mode, the negotiation mode. Valid values: main and aggressive. Default value: main.
        :param _builtins.str ike_pfs: The Diffie-Hellman key exchange algorithm used in the first stage negotiation. Valid values: group1, group2, group5, or group14. Default value: group2.
        :param _builtins.str ike_version: The version of the IKE protocol. Value: ikev1 or ikev2. Default value: ikev1.
        :param _builtins.str local_id: The identifier on the Alibaba Cloud side of the IPsec connection. The length is limited to 100 characters. The default value is leftId-not-exist
        :param _builtins.str psk: A pre-shared key for authentication between the VPN gateway and the local data center. The key length is 1~100 characters.
               - If you do not specify a pre-shared key, the system randomly generates a 16-bit string as the pre-shared key.
               - The pre-shared key of the IPsec-VPN connection must be the same as the authentication key of the on-premises data center. Otherwise, connections between the on-premises data center and the VPN gateway cannot be established.
        :param _builtins.str remote_id: The identifier of the IPsec connection to the local data center. The length is limited to 100 characters. The default value is the IP address of the user gateway.
        """
        if ike_auth_alg is not None:
            pulumi.set(__self__, "ike_auth_alg", ike_auth_alg)
        if ike_enc_alg is not None:
            pulumi.set(__self__, "ike_enc_alg", ike_enc_alg)
        if ike_lifetime is not None:
            pulumi.set(__self__, "ike_lifetime", ike_lifetime)
        if ike_mode is not None:
            pulumi.set(__self__, "ike_mode", ike_mode)
        if ike_pfs is not None:
            pulumi.set(__self__, "ike_pfs", ike_pfs)
        if ike_version is not None:
            pulumi.set(__self__, "ike_version", ike_version)
        if local_id is not None:
            pulumi.set(__self__, "local_id", local_id)
        if psk is not None:
            pulumi.set(__self__, "psk", psk)
        if remote_id is not None:
            pulumi.set(__self__, "remote_id", remote_id)

    @_builtins.property
    @pulumi.getter(name="ikeAuthAlg")
    def ike_auth_alg(self) -> Optional[_builtins.str]:
        """
        The authentication algorithm negotiated in the first stage. Valid values: md5, sha1, sha256, sha384, sha512. Default value: md5.
        """
        return pulumi.get(self, "ike_auth_alg")

    @_builtins.property
    @pulumi.getter(name="ikeEncAlg")
    def ike_enc_alg(self) -> Optional[_builtins.str]:
        """
        The encryption algorithm that is used in Phase 1 negotiations. Valid values: aes, aes192, aes256, des, and 3des. Default value: aes.
        """
        return pulumi.get(self, "ike_enc_alg")

    @_builtins.property
    @pulumi.getter(name="ikeLifetime")
    def ike_lifetime(self) -> Optional[_builtins.int]:
        """
        The SA lifetime as a result of Phase 1 negotiations. Unit: seconds. Valid values: 0 to 86400. Default value: 86400.
        """
        return pulumi.get(self, "ike_lifetime")

    @_builtins.property
    @pulumi.getter(name="ikeMode")
    def ike_mode(self) -> Optional[_builtins.str]:
        """
        IKE mode, the negotiation mode. Valid values: main and aggressive. Default value: main.
        """
        return pulumi.get(self, "ike_mode")

    @_builtins.property
    @pulumi.getter(name="ikePfs")
    def ike_pfs(self) -> Optional[_builtins.str]:
        """
        The Diffie-Hellman key exchange algorithm used in the first stage negotiation. Valid values: group1, group2, group5, or group14. Default value: group2.
        """
        return pulumi.get(self, "ike_pfs")

    @_builtins.property
    @pulumi.getter(name="ikeVersion")
    def ike_version(self) -> Optional[_builtins.str]:
        """
        The version of the IKE protocol. Value: ikev1 or ikev2. Default value: ikev1.
        """
        return pulumi.get(self, "ike_version")

    @_builtins.property
    @pulumi.getter(name="localId")
    def local_id(self) -> Optional[_builtins.str]:
        """
        The identifier on the Alibaba Cloud side of the IPsec connection. The length is limited to 100 characters. The default value is leftId-not-exist
        """
        return pulumi.get(self, "local_id")

    @_builtins.property
    @pulumi.getter
    def psk(self) -> Optional[_builtins.str]:
        """
        A pre-shared key for authentication between the VPN gateway and the local data center. The key length is 1~100 characters.
        - If you do not specify a pre-shared key, the system randomly generates a 16-bit string as the pre-shared key.
        - The pre-shared key of the IPsec-VPN connection must be the same as the authentication key of the on-premises data center. Otherwise, connections between the on-premises data center and the VPN gateway cannot be established.
        """
        return pulumi.get(self, "psk")

    @_builtins.property
    @pulumi.getter(name="remoteId")
    def remote_id(self) -> Optional[_builtins.str]:
        """
        The identifier of the IPsec connection to the local data center. The length is limited to 100 characters. The default value is the IP address of the user gateway.
        """
        return pulumi.get(self, "remote_id")


@pulumi.output_type
class GatewayVpnAttachmentIpsecConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipsecAuthAlg":
            suggest = "ipsec_auth_alg"
        elif key == "ipsecEncAlg":
            suggest = "ipsec_enc_alg"
        elif key == "ipsecLifetime":
            suggest = "ipsec_lifetime"
        elif key == "ipsecPfs":
            suggest = "ipsec_pfs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GatewayVpnAttachmentIpsecConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GatewayVpnAttachmentIpsecConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GatewayVpnAttachmentIpsecConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ipsec_auth_alg: Optional[_builtins.str] = None,
                 ipsec_enc_alg: Optional[_builtins.str] = None,
                 ipsec_lifetime: Optional[_builtins.int] = None,
                 ipsec_pfs: Optional[_builtins.str] = None):
        """
        :param _builtins.str ipsec_auth_alg: The authentication algorithm negotiated in the second stage. Valid values: md5, sha1, sha256, sha384, sha512. Default value: MD5.
        :param _builtins.str ipsec_enc_alg: The encryption algorithm negotiated in the second stage. Valid values: aes, aes192, aes256, des, or 3des. Default value: aes.
        :param _builtins.int ipsec_lifetime: The life cycle of SA negotiated in the second stage. Unit: seconds. Value range: 0~86400. Default value: 86400.
        :param _builtins.str ipsec_pfs: Diffie-Hellman Key Exchange Algorithm Used in Second Stage Negotiation
        """
        if ipsec_auth_alg is not None:
            pulumi.set(__self__, "ipsec_auth_alg", ipsec_auth_alg)
        if ipsec_enc_alg is not None:
            pulumi.set(__self__, "ipsec_enc_alg", ipsec_enc_alg)
        if ipsec_lifetime is not None:
            pulumi.set(__self__, "ipsec_lifetime", ipsec_lifetime)
        if ipsec_pfs is not None:
            pulumi.set(__self__, "ipsec_pfs", ipsec_pfs)

    @_builtins.property
    @pulumi.getter(name="ipsecAuthAlg")
    def ipsec_auth_alg(self) -> Optional[_builtins.str]:
        """
        The authentication algorithm negotiated in the second stage. Valid values: md5, sha1, sha256, sha384, sha512. Default value: MD5.
        """
        return pulumi.get(self, "ipsec_auth_alg")

    @_builtins.property
    @pulumi.getter(name="ipsecEncAlg")
    def ipsec_enc_alg(self) -> Optional[_builtins.str]:
        """
        The encryption algorithm negotiated in the second stage. Valid values: aes, aes192, aes256, des, or 3des. Default value: aes.
        """
        return pulumi.get(self, "ipsec_enc_alg")

    @_builtins.property
    @pulumi.getter(name="ipsecLifetime")
    def ipsec_lifetime(self) -> Optional[_builtins.int]:
        """
        The life cycle of SA negotiated in the second stage. Unit: seconds. Value range: 0~86400. Default value: 86400.
        """
        return pulumi.get(self, "ipsec_lifetime")

    @_builtins.property
    @pulumi.getter(name="ipsecPfs")
    def ipsec_pfs(self) -> Optional[_builtins.str]:
        """
        Diffie-Hellman Key Exchange Algorithm Used in Second Stage Negotiation
        """
        return pulumi.get(self, "ipsec_pfs")


@pulumi.output_type
class GatewayVpnAttachmentTunnelOptionsSpecification(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customerGatewayId":
            suggest = "customer_gateway_id"
        elif key == "tunnelIndex":
            suggest = "tunnel_index"
        elif key == "enableDpd":
            suggest = "enable_dpd"
        elif key == "enableNatTraversal":
            suggest = "enable_nat_traversal"
        elif key == "internetIp":
            suggest = "internet_ip"
        elif key == "tunnelBgpConfig":
            suggest = "tunnel_bgp_config"
        elif key == "tunnelId":
            suggest = "tunnel_id"
        elif key == "tunnelIkeConfig":
            suggest = "tunnel_ike_config"
        elif key == "tunnelIpsecConfig":
            suggest = "tunnel_ipsec_config"
        elif key == "zoneNo":
            suggest = "zone_no"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GatewayVpnAttachmentTunnelOptionsSpecification. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GatewayVpnAttachmentTunnelOptionsSpecification.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GatewayVpnAttachmentTunnelOptionsSpecification.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 customer_gateway_id: _builtins.str,
                 tunnel_index: _builtins.int,
                 enable_dpd: Optional[_builtins.bool] = None,
                 enable_nat_traversal: Optional[_builtins.bool] = None,
                 internet_ip: Optional[_builtins.str] = None,
                 role: Optional[_builtins.str] = None,
                 state: Optional[_builtins.str] = None,
                 status: Optional[_builtins.str] = None,
                 tunnel_bgp_config: Optional['outputs.GatewayVpnAttachmentTunnelOptionsSpecificationTunnelBgpConfig'] = None,
                 tunnel_id: Optional[_builtins.str] = None,
                 tunnel_ike_config: Optional['outputs.GatewayVpnAttachmentTunnelOptionsSpecificationTunnelIkeConfig'] = None,
                 tunnel_ipsec_config: Optional['outputs.GatewayVpnAttachmentTunnelOptionsSpecificationTunnelIpsecConfig'] = None,
                 zone_no: Optional[_builtins.str] = None):
        """
        :param _builtins.str customer_gateway_id: The ID of the user gateway associated with the tunnel.
               
               > **NOTE:**  This parameter is required when creating a dual-tunnel mode IPsec-VPN connection.
        :param _builtins.int tunnel_index: The order in which the tunnel was created.
        :param _builtins.bool enable_dpd: Whether the DPD (peer alive detection) function is enabled for the tunnel. Value:
        :param _builtins.bool enable_nat_traversal: Whether the NAT crossing function is enabled for the tunnel. Value:
        :param _builtins.str internet_ip: The local internet IP in Tunnel.
        :param _builtins.str role: The role of Tunnel.
        :param _builtins.str state: The state of Tunnel.
        :param _builtins.str status: The negotiation status of Tunnel.
        :param 'GatewayVpnAttachmentTunnelOptionsSpecificationTunnelBgpConfigArgs' tunnel_bgp_config: Add the BGP configuration for the tunnel.
               
               > **NOTE:**  After you enable the BGP function for IPsec connections (that is, specify `EnableTunnelsBgp` as `true`), you must configure this parameter.
               See `tunnel_bgp_config` below.
        :param _builtins.str tunnel_id: The tunnel ID of IPsec-VPN connection.
        :param 'GatewayVpnAttachmentTunnelOptionsSpecificationTunnelIkeConfigArgs' tunnel_ike_config: Configuration information for the first phase negotiation. See `tunnel_ike_config` below.
        :param 'GatewayVpnAttachmentTunnelOptionsSpecificationTunnelIpsecConfigArgs' tunnel_ipsec_config: Configuration information for the second-stage negotiation. See `tunnel_ipsec_config` below.
        :param _builtins.str zone_no: The zoneNo of tunnel.
        """
        pulumi.set(__self__, "customer_gateway_id", customer_gateway_id)
        pulumi.set(__self__, "tunnel_index", tunnel_index)
        if enable_dpd is not None:
            pulumi.set(__self__, "enable_dpd", enable_dpd)
        if enable_nat_traversal is not None:
            pulumi.set(__self__, "enable_nat_traversal", enable_nat_traversal)
        if internet_ip is not None:
            pulumi.set(__self__, "internet_ip", internet_ip)
        if role is not None:
            pulumi.set(__self__, "role", role)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tunnel_bgp_config is not None:
            pulumi.set(__self__, "tunnel_bgp_config", tunnel_bgp_config)
        if tunnel_id is not None:
            pulumi.set(__self__, "tunnel_id", tunnel_id)
        if tunnel_ike_config is not None:
            pulumi.set(__self__, "tunnel_ike_config", tunnel_ike_config)
        if tunnel_ipsec_config is not None:
            pulumi.set(__self__, "tunnel_ipsec_config", tunnel_ipsec_config)
        if zone_no is not None:
            pulumi.set(__self__, "zone_no", zone_no)

    @_builtins.property
    @pulumi.getter(name="customerGatewayId")
    def customer_gateway_id(self) -> _builtins.str:
        """
        The ID of the user gateway associated with the tunnel.

        > **NOTE:**  This parameter is required when creating a dual-tunnel mode IPsec-VPN connection.
        """
        return pulumi.get(self, "customer_gateway_id")

    @_builtins.property
    @pulumi.getter(name="tunnelIndex")
    def tunnel_index(self) -> _builtins.int:
        """
        The order in which the tunnel was created.
        """
        return pulumi.get(self, "tunnel_index")

    @_builtins.property
    @pulumi.getter(name="enableDpd")
    def enable_dpd(self) -> Optional[_builtins.bool]:
        """
        Whether the DPD (peer alive detection) function is enabled for the tunnel. Value:
        """
        return pulumi.get(self, "enable_dpd")

    @_builtins.property
    @pulumi.getter(name="enableNatTraversal")
    def enable_nat_traversal(self) -> Optional[_builtins.bool]:
        """
        Whether the NAT crossing function is enabled for the tunnel. Value:
        """
        return pulumi.get(self, "enable_nat_traversal")

    @_builtins.property
    @pulumi.getter(name="internetIp")
    def internet_ip(self) -> Optional[_builtins.str]:
        """
        The local internet IP in Tunnel.
        """
        return pulumi.get(self, "internet_ip")

    @_builtins.property
    @pulumi.getter
    def role(self) -> Optional[_builtins.str]:
        """
        The role of Tunnel.
        """
        return pulumi.get(self, "role")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        The state of Tunnel.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        The negotiation status of Tunnel.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="tunnelBgpConfig")
    def tunnel_bgp_config(self) -> Optional['outputs.GatewayVpnAttachmentTunnelOptionsSpecificationTunnelBgpConfig']:
        """
        Add the BGP configuration for the tunnel.

        > **NOTE:**  After you enable the BGP function for IPsec connections (that is, specify `EnableTunnelsBgp` as `true`), you must configure this parameter.
        See `tunnel_bgp_config` below.
        """
        return pulumi.get(self, "tunnel_bgp_config")

    @_builtins.property
    @pulumi.getter(name="tunnelId")
    def tunnel_id(self) -> Optional[_builtins.str]:
        """
        The tunnel ID of IPsec-VPN connection.
        """
        return pulumi.get(self, "tunnel_id")

    @_builtins.property
    @pulumi.getter(name="tunnelIkeConfig")
    def tunnel_ike_config(self) -> Optional['outputs.GatewayVpnAttachmentTunnelOptionsSpecificationTunnelIkeConfig']:
        """
        Configuration information for the first phase negotiation. See `tunnel_ike_config` below.
        """
        return pulumi.get(self, "tunnel_ike_config")

    @_builtins.property
    @pulumi.getter(name="tunnelIpsecConfig")
    def tunnel_ipsec_config(self) -> Optional['outputs.GatewayVpnAttachmentTunnelOptionsSpecificationTunnelIpsecConfig']:
        """
        Configuration information for the second-stage negotiation. See `tunnel_ipsec_config` below.
        """
        return pulumi.get(self, "tunnel_ipsec_config")

    @_builtins.property
    @pulumi.getter(name="zoneNo")
    def zone_no(self) -> Optional[_builtins.str]:
        """
        The zoneNo of tunnel.
        """
        return pulumi.get(self, "zone_no")


@pulumi.output_type
class GatewayVpnAttachmentTunnelOptionsSpecificationTunnelBgpConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bgpStatus":
            suggest = "bgp_status"
        elif key == "localAsn":
            suggest = "local_asn"
        elif key == "localBgpIp":
            suggest = "local_bgp_ip"
        elif key == "peerAsn":
            suggest = "peer_asn"
        elif key == "peerBgpIp":
            suggest = "peer_bgp_ip"
        elif key == "tunnelCidr":
            suggest = "tunnel_cidr"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GatewayVpnAttachmentTunnelOptionsSpecificationTunnelBgpConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GatewayVpnAttachmentTunnelOptionsSpecificationTunnelBgpConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GatewayVpnAttachmentTunnelOptionsSpecificationTunnelBgpConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bgp_status: Optional[_builtins.str] = None,
                 local_asn: Optional[_builtins.int] = None,
                 local_bgp_ip: Optional[_builtins.str] = None,
                 peer_asn: Optional[_builtins.str] = None,
                 peer_bgp_ip: Optional[_builtins.str] = None,
                 tunnel_cidr: Optional[_builtins.str] = None):
        """
        :param _builtins.str bgp_status: BGP status.
        :param _builtins.str peer_asn: Peer asn.
        :param _builtins.str peer_bgp_ip: Peer bgp ip.
        """
        if bgp_status is not None:
            pulumi.set(__self__, "bgp_status", bgp_status)
        if local_asn is not None:
            pulumi.set(__self__, "local_asn", local_asn)
        if local_bgp_ip is not None:
            pulumi.set(__self__, "local_bgp_ip", local_bgp_ip)
        if peer_asn is not None:
            pulumi.set(__self__, "peer_asn", peer_asn)
        if peer_bgp_ip is not None:
            pulumi.set(__self__, "peer_bgp_ip", peer_bgp_ip)
        if tunnel_cidr is not None:
            pulumi.set(__self__, "tunnel_cidr", tunnel_cidr)

    @_builtins.property
    @pulumi.getter(name="bgpStatus")
    def bgp_status(self) -> Optional[_builtins.str]:
        """
        BGP status.
        """
        return pulumi.get(self, "bgp_status")

    @_builtins.property
    @pulumi.getter(name="localAsn")
    def local_asn(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "local_asn")

    @_builtins.property
    @pulumi.getter(name="localBgpIp")
    def local_bgp_ip(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "local_bgp_ip")

    @_builtins.property
    @pulumi.getter(name="peerAsn")
    def peer_asn(self) -> Optional[_builtins.str]:
        """
        Peer asn.
        """
        return pulumi.get(self, "peer_asn")

    @_builtins.property
    @pulumi.getter(name="peerBgpIp")
    def peer_bgp_ip(self) -> Optional[_builtins.str]:
        """
        Peer bgp ip.
        """
        return pulumi.get(self, "peer_bgp_ip")

    @_builtins.property
    @pulumi.getter(name="tunnelCidr")
    def tunnel_cidr(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "tunnel_cidr")


@pulumi.output_type
class GatewayVpnAttachmentTunnelOptionsSpecificationTunnelIkeConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ikeAuthAlg":
            suggest = "ike_auth_alg"
        elif key == "ikeEncAlg":
            suggest = "ike_enc_alg"
        elif key == "ikeLifetime":
            suggest = "ike_lifetime"
        elif key == "ikeMode":
            suggest = "ike_mode"
        elif key == "ikePfs":
            suggest = "ike_pfs"
        elif key == "ikeVersion":
            suggest = "ike_version"
        elif key == "localId":
            suggest = "local_id"
        elif key == "remoteId":
            suggest = "remote_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GatewayVpnAttachmentTunnelOptionsSpecificationTunnelIkeConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GatewayVpnAttachmentTunnelOptionsSpecificationTunnelIkeConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GatewayVpnAttachmentTunnelOptionsSpecificationTunnelIkeConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ike_auth_alg: Optional[_builtins.str] = None,
                 ike_enc_alg: Optional[_builtins.str] = None,
                 ike_lifetime: Optional[_builtins.int] = None,
                 ike_mode: Optional[_builtins.str] = None,
                 ike_pfs: Optional[_builtins.str] = None,
                 ike_version: Optional[_builtins.str] = None,
                 local_id: Optional[_builtins.str] = None,
                 psk: Optional[_builtins.str] = None,
                 remote_id: Optional[_builtins.str] = None):
        if ike_auth_alg is not None:
            pulumi.set(__self__, "ike_auth_alg", ike_auth_alg)
        if ike_enc_alg is not None:
            pulumi.set(__self__, "ike_enc_alg", ike_enc_alg)
        if ike_lifetime is not None:
            pulumi.set(__self__, "ike_lifetime", ike_lifetime)
        if ike_mode is not None:
            pulumi.set(__self__, "ike_mode", ike_mode)
        if ike_pfs is not None:
            pulumi.set(__self__, "ike_pfs", ike_pfs)
        if ike_version is not None:
            pulumi.set(__self__, "ike_version", ike_version)
        if local_id is not None:
            pulumi.set(__self__, "local_id", local_id)
        if psk is not None:
            pulumi.set(__self__, "psk", psk)
        if remote_id is not None:
            pulumi.set(__self__, "remote_id", remote_id)

    @_builtins.property
    @pulumi.getter(name="ikeAuthAlg")
    def ike_auth_alg(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "ike_auth_alg")

    @_builtins.property
    @pulumi.getter(name="ikeEncAlg")
    def ike_enc_alg(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "ike_enc_alg")

    @_builtins.property
    @pulumi.getter(name="ikeLifetime")
    def ike_lifetime(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "ike_lifetime")

    @_builtins.property
    @pulumi.getter(name="ikeMode")
    def ike_mode(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "ike_mode")

    @_builtins.property
    @pulumi.getter(name="ikePfs")
    def ike_pfs(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "ike_pfs")

    @_builtins.property
    @pulumi.getter(name="ikeVersion")
    def ike_version(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "ike_version")

    @_builtins.property
    @pulumi.getter(name="localId")
    def local_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "local_id")

    @_builtins.property
    @pulumi.getter
    def psk(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "psk")

    @_builtins.property
    @pulumi.getter(name="remoteId")
    def remote_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "remote_id")


@pulumi.output_type
class GatewayVpnAttachmentTunnelOptionsSpecificationTunnelIpsecConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipsecAuthAlg":
            suggest = "ipsec_auth_alg"
        elif key == "ipsecEncAlg":
            suggest = "ipsec_enc_alg"
        elif key == "ipsecLifetime":
            suggest = "ipsec_lifetime"
        elif key == "ipsecPfs":
            suggest = "ipsec_pfs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GatewayVpnAttachmentTunnelOptionsSpecificationTunnelIpsecConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GatewayVpnAttachmentTunnelOptionsSpecificationTunnelIpsecConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GatewayVpnAttachmentTunnelOptionsSpecificationTunnelIpsecConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ipsec_auth_alg: Optional[_builtins.str] = None,
                 ipsec_enc_alg: Optional[_builtins.str] = None,
                 ipsec_lifetime: Optional[_builtins.int] = None,
                 ipsec_pfs: Optional[_builtins.str] = None):
        if ipsec_auth_alg is not None:
            pulumi.set(__self__, "ipsec_auth_alg", ipsec_auth_alg)
        if ipsec_enc_alg is not None:
            pulumi.set(__self__, "ipsec_enc_alg", ipsec_enc_alg)
        if ipsec_lifetime is not None:
            pulumi.set(__self__, "ipsec_lifetime", ipsec_lifetime)
        if ipsec_pfs is not None:
            pulumi.set(__self__, "ipsec_pfs", ipsec_pfs)

    @_builtins.property
    @pulumi.getter(name="ipsecAuthAlg")
    def ipsec_auth_alg(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "ipsec_auth_alg")

    @_builtins.property
    @pulumi.getter(name="ipsecEncAlg")
    def ipsec_enc_alg(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "ipsec_enc_alg")

    @_builtins.property
    @pulumi.getter(name="ipsecLifetime")
    def ipsec_lifetime(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "ipsec_lifetime")

    @_builtins.property
    @pulumi.getter(name="ipsecPfs")
    def ipsec_pfs(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "ipsec_pfs")


@pulumi.output_type
class IpsecServerIkeConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ikeAuthAlg":
            suggest = "ike_auth_alg"
        elif key == "ikeEncAlg":
            suggest = "ike_enc_alg"
        elif key == "ikeLifetime":
            suggest = "ike_lifetime"
        elif key == "ikeMode":
            suggest = "ike_mode"
        elif key == "ikePfs":
            suggest = "ike_pfs"
        elif key == "ikeVersion":
            suggest = "ike_version"
        elif key == "localId":
            suggest = "local_id"
        elif key == "remoteId":
            suggest = "remote_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IpsecServerIkeConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IpsecServerIkeConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IpsecServerIkeConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ike_auth_alg: Optional[_builtins.str] = None,
                 ike_enc_alg: Optional[_builtins.str] = None,
                 ike_lifetime: Optional[_builtins.int] = None,
                 ike_mode: Optional[_builtins.str] = None,
                 ike_pfs: Optional[_builtins.str] = None,
                 ike_version: Optional[_builtins.str] = None,
                 local_id: Optional[_builtins.str] = None,
                 remote_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str ike_auth_alg: The authentication algorithm that is used in Phase 1 negotiations. Default value: `sha1`.
        :param _builtins.str ike_enc_alg: The encryption algorithm that is used in Phase 1 negotiations. Default value: `aes`.
        :param _builtins.int ike_lifetime: IkeLifetime: the SA lifetime determined by Phase 1 negotiations. Valid values: `0` to `86400`. Default value: `86400`. Unit: `seconds`.
        :param _builtins.str ike_mode: The IKE negotiation mode. Default value: `main`.
        :param _builtins.str ike_pfs: The Diffie-Hellman key exchange algorithm that is used in Phase 1 negotiations. Default value: `group2`.
        :param _builtins.str ike_version: The IKE version. Valid values: `ikev1` and `ikev2`. Default value: `ikev2`.
        :param _builtins.str local_id: The identifier of the IPsec server. The value can be a fully qualified domain name (FQDN) or an IP address. The default value is the public IP address of the VPN gateway.
        :param _builtins.str remote_id: The identifier of the customer gateway. The value can be an FQDN or an IP address. By default, this parameter is not specified.
        """
        if ike_auth_alg is not None:
            pulumi.set(__self__, "ike_auth_alg", ike_auth_alg)
        if ike_enc_alg is not None:
            pulumi.set(__self__, "ike_enc_alg", ike_enc_alg)
        if ike_lifetime is not None:
            pulumi.set(__self__, "ike_lifetime", ike_lifetime)
        if ike_mode is not None:
            pulumi.set(__self__, "ike_mode", ike_mode)
        if ike_pfs is not None:
            pulumi.set(__self__, "ike_pfs", ike_pfs)
        if ike_version is not None:
            pulumi.set(__self__, "ike_version", ike_version)
        if local_id is not None:
            pulumi.set(__self__, "local_id", local_id)
        if remote_id is not None:
            pulumi.set(__self__, "remote_id", remote_id)

    @_builtins.property
    @pulumi.getter(name="ikeAuthAlg")
    def ike_auth_alg(self) -> Optional[_builtins.str]:
        """
        The authentication algorithm that is used in Phase 1 negotiations. Default value: `sha1`.
        """
        return pulumi.get(self, "ike_auth_alg")

    @_builtins.property
    @pulumi.getter(name="ikeEncAlg")
    def ike_enc_alg(self) -> Optional[_builtins.str]:
        """
        The encryption algorithm that is used in Phase 1 negotiations. Default value: `aes`.
        """
        return pulumi.get(self, "ike_enc_alg")

    @_builtins.property
    @pulumi.getter(name="ikeLifetime")
    def ike_lifetime(self) -> Optional[_builtins.int]:
        """
        IkeLifetime: the SA lifetime determined by Phase 1 negotiations. Valid values: `0` to `86400`. Default value: `86400`. Unit: `seconds`.
        """
        return pulumi.get(self, "ike_lifetime")

    @_builtins.property
    @pulumi.getter(name="ikeMode")
    def ike_mode(self) -> Optional[_builtins.str]:
        """
        The IKE negotiation mode. Default value: `main`.
        """
        return pulumi.get(self, "ike_mode")

    @_builtins.property
    @pulumi.getter(name="ikePfs")
    def ike_pfs(self) -> Optional[_builtins.str]:
        """
        The Diffie-Hellman key exchange algorithm that is used in Phase 1 negotiations. Default value: `group2`.
        """
        return pulumi.get(self, "ike_pfs")

    @_builtins.property
    @pulumi.getter(name="ikeVersion")
    def ike_version(self) -> Optional[_builtins.str]:
        """
        The IKE version. Valid values: `ikev1` and `ikev2`. Default value: `ikev2`.
        """
        return pulumi.get(self, "ike_version")

    @_builtins.property
    @pulumi.getter(name="localId")
    def local_id(self) -> Optional[_builtins.str]:
        """
        The identifier of the IPsec server. The value can be a fully qualified domain name (FQDN) or an IP address. The default value is the public IP address of the VPN gateway.
        """
        return pulumi.get(self, "local_id")

    @_builtins.property
    @pulumi.getter(name="remoteId")
    def remote_id(self) -> Optional[_builtins.str]:
        """
        The identifier of the customer gateway. The value can be an FQDN or an IP address. By default, this parameter is not specified.
        """
        return pulumi.get(self, "remote_id")


@pulumi.output_type
class IpsecServerIpsecConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipsecAuthAlg":
            suggest = "ipsec_auth_alg"
        elif key == "ipsecEncAlg":
            suggest = "ipsec_enc_alg"
        elif key == "ipsecLifetime":
            suggest = "ipsec_lifetime"
        elif key == "ipsecPfs":
            suggest = "ipsec_pfs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IpsecServerIpsecConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IpsecServerIpsecConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IpsecServerIpsecConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ipsec_auth_alg: Optional[_builtins.str] = None,
                 ipsec_enc_alg: Optional[_builtins.str] = None,
                 ipsec_lifetime: Optional[_builtins.int] = None,
                 ipsec_pfs: Optional[_builtins.str] = None):
        """
        :param _builtins.str ipsec_auth_alg: The authentication algorithm that is used in Phase 2 negotiations. Default value: `sha1`.
        :param _builtins.str ipsec_enc_alg: The encryption algorithm that is used in Phase 2 negotiations. Default value: `aes`.
        :param _builtins.int ipsec_lifetime: The SA lifetime determined by Phase 2 negotiations. Valid values: `0` to `86400`. Default value: `86400`. Unit: `seconds`.
        :param _builtins.str ipsec_pfs: Forwards packets of all protocols. The Diffie-Hellman key exchange algorithm used in Phase 2 negotiations. Default value: `group2`.
        """
        if ipsec_auth_alg is not None:
            pulumi.set(__self__, "ipsec_auth_alg", ipsec_auth_alg)
        if ipsec_enc_alg is not None:
            pulumi.set(__self__, "ipsec_enc_alg", ipsec_enc_alg)
        if ipsec_lifetime is not None:
            pulumi.set(__self__, "ipsec_lifetime", ipsec_lifetime)
        if ipsec_pfs is not None:
            pulumi.set(__self__, "ipsec_pfs", ipsec_pfs)

    @_builtins.property
    @pulumi.getter(name="ipsecAuthAlg")
    def ipsec_auth_alg(self) -> Optional[_builtins.str]:
        """
        The authentication algorithm that is used in Phase 2 negotiations. Default value: `sha1`.
        """
        return pulumi.get(self, "ipsec_auth_alg")

    @_builtins.property
    @pulumi.getter(name="ipsecEncAlg")
    def ipsec_enc_alg(self) -> Optional[_builtins.str]:
        """
        The encryption algorithm that is used in Phase 2 negotiations. Default value: `aes`.
        """
        return pulumi.get(self, "ipsec_enc_alg")

    @_builtins.property
    @pulumi.getter(name="ipsecLifetime")
    def ipsec_lifetime(self) -> Optional[_builtins.int]:
        """
        The SA lifetime determined by Phase 2 negotiations. Valid values: `0` to `86400`. Default value: `86400`. Unit: `seconds`.
        """
        return pulumi.get(self, "ipsec_lifetime")

    @_builtins.property
    @pulumi.getter(name="ipsecPfs")
    def ipsec_pfs(self) -> Optional[_builtins.str]:
        """
        Forwards packets of all protocols. The Diffie-Hellman key exchange algorithm used in Phase 2 negotiations. Default value: `group2`.
        """
        return pulumi.get(self, "ipsec_pfs")


@pulumi.output_type
class GetConnectionsConnectionResult(dict):
    def __init__(__self__, *,
                 create_time: _builtins.str,
                 customer_gateway_id: _builtins.str,
                 effect_immediately: _builtins.bool,
                 enable_dpd: _builtins.bool,
                 enable_nat_traversal: _builtins.bool,
                 enable_tunnels_bgp: _builtins.bool,
                 id: _builtins.str,
                 local_subnet: _builtins.str,
                 name: _builtins.str,
                 remote_subnet: _builtins.str,
                 status: _builtins.str,
                 tunnel_options_specifications: Sequence['outputs.GetConnectionsConnectionTunnelOptionsSpecificationResult'],
                 vpn_gateway_id: _builtins.str,
                 ike_configs: Optional[Sequence['outputs.GetConnectionsConnectionIkeConfigResult']] = None,
                 ipsec_configs: Optional[Sequence['outputs.GetConnectionsConnectionIpsecConfigResult']] = None,
                 vco_health_checks: Optional[Sequence['outputs.GetConnectionsConnectionVcoHealthCheckResult']] = None,
                 vpn_bgp_configs: Optional[Sequence['outputs.GetConnectionsConnectionVpnBgpConfigResult']] = None):
        """
        :param _builtins.str customer_gateway_id: Use the VPN customer gateway ID as the search key.
        :param _builtins.bool enable_dpd: Wether enable Dpd detection.
        :param _builtins.bool enable_nat_traversal: enable nat traversal.
        :param _builtins.bool enable_tunnels_bgp: Enable tunnel bgp.
        :param _builtins.str id: ID of the VPN connection.
        :param _builtins.str local_subnet: The local subnet of the VPN connection.
        :param _builtins.str name: The name of the VPN connection.
        :param _builtins.str remote_subnet: The remote subnet of the VPN connection.
        :param _builtins.str status: The negotiation status of the BGP routing protocol. Valid values: `success`, `false`.
        :param Sequence['GetConnectionsConnectionTunnelOptionsSpecificationArgs'] tunnel_options_specifications: The tunnel_options_specification supports the following:
        :param _builtins.str vpn_gateway_id: Use the VPN gateway ID as the search key.
        :param Sequence['GetConnectionsConnectionIkeConfigArgs'] ike_configs: The ike_config mapping supports the following:
        :param Sequence['GetConnectionsConnectionIpsecConfigArgs'] ipsec_configs: The ipsec_config mapping supports the following:
        :param Sequence['GetConnectionsConnectionVpnBgpConfigArgs'] vpn_bgp_configs: The vpn_bgp_config mapping supports the following:
        """
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "customer_gateway_id", customer_gateway_id)
        pulumi.set(__self__, "effect_immediately", effect_immediately)
        pulumi.set(__self__, "enable_dpd", enable_dpd)
        pulumi.set(__self__, "enable_nat_traversal", enable_nat_traversal)
        pulumi.set(__self__, "enable_tunnels_bgp", enable_tunnels_bgp)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "local_subnet", local_subnet)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "remote_subnet", remote_subnet)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "tunnel_options_specifications", tunnel_options_specifications)
        pulumi.set(__self__, "vpn_gateway_id", vpn_gateway_id)
        if ike_configs is not None:
            pulumi.set(__self__, "ike_configs", ike_configs)
        if ipsec_configs is not None:
            pulumi.set(__self__, "ipsec_configs", ipsec_configs)
        if vco_health_checks is not None:
            pulumi.set(__self__, "vco_health_checks", vco_health_checks)
        if vpn_bgp_configs is not None:
            pulumi.set(__self__, "vpn_bgp_configs", vpn_bgp_configs)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="customerGatewayId")
    def customer_gateway_id(self) -> _builtins.str:
        """
        Use the VPN customer gateway ID as the search key.
        """
        return pulumi.get(self, "customer_gateway_id")

    @_builtins.property
    @pulumi.getter(name="effectImmediately")
    def effect_immediately(self) -> _builtins.bool:
        return pulumi.get(self, "effect_immediately")

    @_builtins.property
    @pulumi.getter(name="enableDpd")
    def enable_dpd(self) -> _builtins.bool:
        """
        Wether enable Dpd detection.
        """
        return pulumi.get(self, "enable_dpd")

    @_builtins.property
    @pulumi.getter(name="enableNatTraversal")
    def enable_nat_traversal(self) -> _builtins.bool:
        """
        enable nat traversal.
        """
        return pulumi.get(self, "enable_nat_traversal")

    @_builtins.property
    @pulumi.getter(name="enableTunnelsBgp")
    def enable_tunnels_bgp(self) -> _builtins.bool:
        """
        Enable tunnel bgp.
        """
        return pulumi.get(self, "enable_tunnels_bgp")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        ID of the VPN connection.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="localSubnet")
    def local_subnet(self) -> _builtins.str:
        """
        The local subnet of the VPN connection.
        """
        return pulumi.get(self, "local_subnet")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the VPN connection.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="remoteSubnet")
    def remote_subnet(self) -> _builtins.str:
        """
        The remote subnet of the VPN connection.
        """
        return pulumi.get(self, "remote_subnet")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The negotiation status of the BGP routing protocol. Valid values: `success`, `false`.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="tunnelOptionsSpecifications")
    def tunnel_options_specifications(self) -> Sequence['outputs.GetConnectionsConnectionTunnelOptionsSpecificationResult']:
        """
        The tunnel_options_specification supports the following:
        """
        return pulumi.get(self, "tunnel_options_specifications")

    @_builtins.property
    @pulumi.getter(name="vpnGatewayId")
    def vpn_gateway_id(self) -> _builtins.str:
        """
        Use the VPN gateway ID as the search key.
        """
        return pulumi.get(self, "vpn_gateway_id")

    @_builtins.property
    @pulumi.getter(name="ikeConfigs")
    def ike_configs(self) -> Optional[Sequence['outputs.GetConnectionsConnectionIkeConfigResult']]:
        """
        The ike_config mapping supports the following:
        """
        return pulumi.get(self, "ike_configs")

    @_builtins.property
    @pulumi.getter(name="ipsecConfigs")
    def ipsec_configs(self) -> Optional[Sequence['outputs.GetConnectionsConnectionIpsecConfigResult']]:
        """
        The ipsec_config mapping supports the following:
        """
        return pulumi.get(self, "ipsec_configs")

    @_builtins.property
    @pulumi.getter(name="vcoHealthChecks")
    def vco_health_checks(self) -> Optional[Sequence['outputs.GetConnectionsConnectionVcoHealthCheckResult']]:
        return pulumi.get(self, "vco_health_checks")

    @_builtins.property
    @pulumi.getter(name="vpnBgpConfigs")
    def vpn_bgp_configs(self) -> Optional[Sequence['outputs.GetConnectionsConnectionVpnBgpConfigResult']]:
        """
        The vpn_bgp_config mapping supports the following:
        """
        return pulumi.get(self, "vpn_bgp_configs")


@pulumi.output_type
class GetConnectionsConnectionIkeConfigResult(dict):
    def __init__(__self__, *,
                 ike_auth_alg: Optional[_builtins.str] = None,
                 ike_enc_alg: Optional[_builtins.str] = None,
                 ike_lifetime: Optional[_builtins.int] = None,
                 ike_local_id: Optional[_builtins.str] = None,
                 ike_mode: Optional[_builtins.str] = None,
                 ike_pfs: Optional[_builtins.str] = None,
                 ike_remote_id: Optional[_builtins.str] = None,
                 ike_version: Optional[_builtins.str] = None,
                 psk: Optional[_builtins.str] = None):
        """
        :param _builtins.str ike_auth_alg: IKE auth Algorithm.
        :param _builtins.str ike_enc_alg: IKE encript algorithm.
        :param _builtins.int ike_lifetime: IKE lifetime.
        :param _builtins.str ike_local_id: The identification of the VPN gateway.
        :param _builtins.str ike_mode: IKE Mode.
        :param _builtins.str ike_pfs: DH Group.
        :param _builtins.str ike_remote_id: The identification of the customer gateway.
        :param _builtins.str ike_version: IKE Version.
        :param _builtins.str psk: Preshared secret key.
        """
        if ike_auth_alg is not None:
            pulumi.set(__self__, "ike_auth_alg", ike_auth_alg)
        if ike_enc_alg is not None:
            pulumi.set(__self__, "ike_enc_alg", ike_enc_alg)
        if ike_lifetime is not None:
            pulumi.set(__self__, "ike_lifetime", ike_lifetime)
        if ike_local_id is not None:
            pulumi.set(__self__, "ike_local_id", ike_local_id)
        if ike_mode is not None:
            pulumi.set(__self__, "ike_mode", ike_mode)
        if ike_pfs is not None:
            pulumi.set(__self__, "ike_pfs", ike_pfs)
        if ike_remote_id is not None:
            pulumi.set(__self__, "ike_remote_id", ike_remote_id)
        if ike_version is not None:
            pulumi.set(__self__, "ike_version", ike_version)
        if psk is not None:
            pulumi.set(__self__, "psk", psk)

    @_builtins.property
    @pulumi.getter(name="ikeAuthAlg")
    def ike_auth_alg(self) -> Optional[_builtins.str]:
        """
        IKE auth Algorithm.
        """
        return pulumi.get(self, "ike_auth_alg")

    @_builtins.property
    @pulumi.getter(name="ikeEncAlg")
    def ike_enc_alg(self) -> Optional[_builtins.str]:
        """
        IKE encript algorithm.
        """
        return pulumi.get(self, "ike_enc_alg")

    @_builtins.property
    @pulumi.getter(name="ikeLifetime")
    def ike_lifetime(self) -> Optional[_builtins.int]:
        """
        IKE lifetime.
        """
        return pulumi.get(self, "ike_lifetime")

    @_builtins.property
    @pulumi.getter(name="ikeLocalId")
    def ike_local_id(self) -> Optional[_builtins.str]:
        """
        The identification of the VPN gateway.
        """
        return pulumi.get(self, "ike_local_id")

    @_builtins.property
    @pulumi.getter(name="ikeMode")
    def ike_mode(self) -> Optional[_builtins.str]:
        """
        IKE Mode.
        """
        return pulumi.get(self, "ike_mode")

    @_builtins.property
    @pulumi.getter(name="ikePfs")
    def ike_pfs(self) -> Optional[_builtins.str]:
        """
        DH Group.
        """
        return pulumi.get(self, "ike_pfs")

    @_builtins.property
    @pulumi.getter(name="ikeRemoteId")
    def ike_remote_id(self) -> Optional[_builtins.str]:
        """
        The identification of the customer gateway.
        """
        return pulumi.get(self, "ike_remote_id")

    @_builtins.property
    @pulumi.getter(name="ikeVersion")
    def ike_version(self) -> Optional[_builtins.str]:
        """
        IKE Version.
        """
        return pulumi.get(self, "ike_version")

    @_builtins.property
    @pulumi.getter
    def psk(self) -> Optional[_builtins.str]:
        """
        Preshared secret key.
        """
        return pulumi.get(self, "psk")


@pulumi.output_type
class GetConnectionsConnectionIpsecConfigResult(dict):
    def __init__(__self__, *,
                 ipsec_auth_alg: Optional[_builtins.str] = None,
                 ipsec_enc_alg: Optional[_builtins.str] = None,
                 ipsec_lifetime: Optional[_builtins.int] = None,
                 ipsec_pfs: Optional[_builtins.str] = None):
        """
        :param _builtins.str ipsec_auth_alg: IPsec Auth algorithm.
        :param _builtins.str ipsec_enc_alg: IPsec Encript algorithm.
        :param _builtins.int ipsec_lifetime: IPsec lifetime.
        :param _builtins.str ipsec_pfs: DH Group.
        """
        if ipsec_auth_alg is not None:
            pulumi.set(__self__, "ipsec_auth_alg", ipsec_auth_alg)
        if ipsec_enc_alg is not None:
            pulumi.set(__self__, "ipsec_enc_alg", ipsec_enc_alg)
        if ipsec_lifetime is not None:
            pulumi.set(__self__, "ipsec_lifetime", ipsec_lifetime)
        if ipsec_pfs is not None:
            pulumi.set(__self__, "ipsec_pfs", ipsec_pfs)

    @_builtins.property
    @pulumi.getter(name="ipsecAuthAlg")
    def ipsec_auth_alg(self) -> Optional[_builtins.str]:
        """
        IPsec Auth algorithm.
        """
        return pulumi.get(self, "ipsec_auth_alg")

    @_builtins.property
    @pulumi.getter(name="ipsecEncAlg")
    def ipsec_enc_alg(self) -> Optional[_builtins.str]:
        """
        IPsec Encript algorithm.
        """
        return pulumi.get(self, "ipsec_enc_alg")

    @_builtins.property
    @pulumi.getter(name="ipsecLifetime")
    def ipsec_lifetime(self) -> Optional[_builtins.int]:
        """
        IPsec lifetime.
        """
        return pulumi.get(self, "ipsec_lifetime")

    @_builtins.property
    @pulumi.getter(name="ipsecPfs")
    def ipsec_pfs(self) -> Optional[_builtins.str]:
        """
        DH Group.
        """
        return pulumi.get(self, "ipsec_pfs")


@pulumi.output_type
class GetConnectionsConnectionTunnelOptionsSpecificationResult(dict):
    def __init__(__self__, *,
                 customer_gateway_id: _builtins.str,
                 enable_dpd: _builtins.bool,
                 enable_nat_traversal: _builtins.bool,
                 internet_ip: _builtins.str,
                 role: _builtins.str,
                 state: _builtins.str,
                 status: _builtins.str,
                 tunnel_bgp_config: 'outputs.GetConnectionsConnectionTunnelOptionsSpecificationTunnelBgpConfigResult',
                 tunnel_id: _builtins.str,
                 tunnel_ike_config: 'outputs.GetConnectionsConnectionTunnelOptionsSpecificationTunnelIkeConfigResult',
                 tunnel_ipsec_config: 'outputs.GetConnectionsConnectionTunnelOptionsSpecificationTunnelIpsecConfigResult',
                 zone_no: _builtins.str):
        """
        :param _builtins.str customer_gateway_id: Use the VPN customer gateway ID as the search key.
        :param _builtins.bool enable_dpd: Wether enable Dpd detection.
        :param _builtins.bool enable_nat_traversal: enable nat traversal.
        :param _builtins.str role: The role of Tunnel.
        :param _builtins.str status: The negotiation status of the BGP routing protocol. Valid values: `success`, `false`.
        :param 'GetConnectionsConnectionTunnelOptionsSpecificationTunnelBgpConfigArgs' tunnel_bgp_config: The bgp config of Tunnel.
        :param 'GetConnectionsConnectionTunnelOptionsSpecificationTunnelIkeConfigArgs' tunnel_ike_config: The configuration of Phase 1 negotiations in Tunnel.
        :param 'GetConnectionsConnectionTunnelOptionsSpecificationTunnelIpsecConfigArgs' tunnel_ipsec_config: IPsec configuration in Tunnel.
        """
        pulumi.set(__self__, "customer_gateway_id", customer_gateway_id)
        pulumi.set(__self__, "enable_dpd", enable_dpd)
        pulumi.set(__self__, "enable_nat_traversal", enable_nat_traversal)
        pulumi.set(__self__, "internet_ip", internet_ip)
        pulumi.set(__self__, "role", role)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "tunnel_bgp_config", tunnel_bgp_config)
        pulumi.set(__self__, "tunnel_id", tunnel_id)
        pulumi.set(__self__, "tunnel_ike_config", tunnel_ike_config)
        pulumi.set(__self__, "tunnel_ipsec_config", tunnel_ipsec_config)
        pulumi.set(__self__, "zone_no", zone_no)

    @_builtins.property
    @pulumi.getter(name="customerGatewayId")
    def customer_gateway_id(self) -> _builtins.str:
        """
        Use the VPN customer gateway ID as the search key.
        """
        return pulumi.get(self, "customer_gateway_id")

    @_builtins.property
    @pulumi.getter(name="enableDpd")
    def enable_dpd(self) -> _builtins.bool:
        """
        Wether enable Dpd detection.
        """
        return pulumi.get(self, "enable_dpd")

    @_builtins.property
    @pulumi.getter(name="enableNatTraversal")
    def enable_nat_traversal(self) -> _builtins.bool:
        """
        enable nat traversal.
        """
        return pulumi.get(self, "enable_nat_traversal")

    @_builtins.property
    @pulumi.getter(name="internetIp")
    def internet_ip(self) -> _builtins.str:
        return pulumi.get(self, "internet_ip")

    @_builtins.property
    @pulumi.getter
    def role(self) -> _builtins.str:
        """
        The role of Tunnel.
        """
        return pulumi.get(self, "role")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The negotiation status of the BGP routing protocol. Valid values: `success`, `false`.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="tunnelBgpConfig")
    def tunnel_bgp_config(self) -> 'outputs.GetConnectionsConnectionTunnelOptionsSpecificationTunnelBgpConfigResult':
        """
        The bgp config of Tunnel.
        """
        return pulumi.get(self, "tunnel_bgp_config")

    @_builtins.property
    @pulumi.getter(name="tunnelId")
    def tunnel_id(self) -> _builtins.str:
        return pulumi.get(self, "tunnel_id")

    @_builtins.property
    @pulumi.getter(name="tunnelIkeConfig")
    def tunnel_ike_config(self) -> 'outputs.GetConnectionsConnectionTunnelOptionsSpecificationTunnelIkeConfigResult':
        """
        The configuration of Phase 1 negotiations in Tunnel.
        """
        return pulumi.get(self, "tunnel_ike_config")

    @_builtins.property
    @pulumi.getter(name="tunnelIpsecConfig")
    def tunnel_ipsec_config(self) -> 'outputs.GetConnectionsConnectionTunnelOptionsSpecificationTunnelIpsecConfigResult':
        """
        IPsec configuration in Tunnel.
        """
        return pulumi.get(self, "tunnel_ipsec_config")

    @_builtins.property
    @pulumi.getter(name="zoneNo")
    def zone_no(self) -> _builtins.str:
        return pulumi.get(self, "zone_no")


@pulumi.output_type
class GetConnectionsConnectionTunnelOptionsSpecificationTunnelBgpConfigResult(dict):
    def __init__(__self__, *,
                 bgp_status: _builtins.str,
                 local_asn: _builtins.str,
                 local_bgp_ip: _builtins.str,
                 peer_asn: _builtins.str,
                 peer_bgp_ip: _builtins.str,
                 tunnel_cidr: _builtins.str):
        """
        :param _builtins.str local_asn: Local asn.
        :param _builtins.str local_bgp_ip: Local bgp IP.
        :param _builtins.str peer_asn: The counterpart autonomous system number.
        :param _builtins.str peer_bgp_ip: The BGP address on the other side.
        :param _builtins.str tunnel_cidr: BGP Tunnel CIDR.
        """
        pulumi.set(__self__, "bgp_status", bgp_status)
        pulumi.set(__self__, "local_asn", local_asn)
        pulumi.set(__self__, "local_bgp_ip", local_bgp_ip)
        pulumi.set(__self__, "peer_asn", peer_asn)
        pulumi.set(__self__, "peer_bgp_ip", peer_bgp_ip)
        pulumi.set(__self__, "tunnel_cidr", tunnel_cidr)

    @_builtins.property
    @pulumi.getter(name="bgpStatus")
    def bgp_status(self) -> _builtins.str:
        return pulumi.get(self, "bgp_status")

    @_builtins.property
    @pulumi.getter(name="localAsn")
    def local_asn(self) -> _builtins.str:
        """
        Local asn.
        """
        return pulumi.get(self, "local_asn")

    @_builtins.property
    @pulumi.getter(name="localBgpIp")
    def local_bgp_ip(self) -> _builtins.str:
        """
        Local bgp IP.
        """
        return pulumi.get(self, "local_bgp_ip")

    @_builtins.property
    @pulumi.getter(name="peerAsn")
    def peer_asn(self) -> _builtins.str:
        """
        The counterpart autonomous system number.
        """
        return pulumi.get(self, "peer_asn")

    @_builtins.property
    @pulumi.getter(name="peerBgpIp")
    def peer_bgp_ip(self) -> _builtins.str:
        """
        The BGP address on the other side.
        """
        return pulumi.get(self, "peer_bgp_ip")

    @_builtins.property
    @pulumi.getter(name="tunnelCidr")
    def tunnel_cidr(self) -> _builtins.str:
        """
        BGP Tunnel CIDR.
        """
        return pulumi.get(self, "tunnel_cidr")


@pulumi.output_type
class GetConnectionsConnectionTunnelOptionsSpecificationTunnelIkeConfigResult(dict):
    def __init__(__self__, *,
                 ike_auth_alg: _builtins.str,
                 ike_enc_alg: _builtins.str,
                 ike_lifetime: _builtins.int,
                 ike_mode: _builtins.str,
                 ike_pfs: _builtins.str,
                 ike_version: _builtins.str,
                 local_id: _builtins.str,
                 psk: _builtins.str,
                 remote_id: _builtins.str):
        """
        :param _builtins.str ike_auth_alg: IKE auth Algorithm.
        :param _builtins.str ike_enc_alg: IKE encript algorithm.
        :param _builtins.int ike_lifetime: IKE lifetime.
        :param _builtins.str ike_mode: IKE Mode.
        :param _builtins.str ike_pfs: DH Group.
        :param _builtins.str ike_version: IKE Version.
        :param _builtins.str local_id: The local Id.
        :param _builtins.str psk: Preshared secret key.
        :param _builtins.str remote_id: Remote ID.
        """
        pulumi.set(__self__, "ike_auth_alg", ike_auth_alg)
        pulumi.set(__self__, "ike_enc_alg", ike_enc_alg)
        pulumi.set(__self__, "ike_lifetime", ike_lifetime)
        pulumi.set(__self__, "ike_mode", ike_mode)
        pulumi.set(__self__, "ike_pfs", ike_pfs)
        pulumi.set(__self__, "ike_version", ike_version)
        pulumi.set(__self__, "local_id", local_id)
        pulumi.set(__self__, "psk", psk)
        pulumi.set(__self__, "remote_id", remote_id)

    @_builtins.property
    @pulumi.getter(name="ikeAuthAlg")
    def ike_auth_alg(self) -> _builtins.str:
        """
        IKE auth Algorithm.
        """
        return pulumi.get(self, "ike_auth_alg")

    @_builtins.property
    @pulumi.getter(name="ikeEncAlg")
    def ike_enc_alg(self) -> _builtins.str:
        """
        IKE encript algorithm.
        """
        return pulumi.get(self, "ike_enc_alg")

    @_builtins.property
    @pulumi.getter(name="ikeLifetime")
    def ike_lifetime(self) -> _builtins.int:
        """
        IKE lifetime.
        """
        return pulumi.get(self, "ike_lifetime")

    @_builtins.property
    @pulumi.getter(name="ikeMode")
    def ike_mode(self) -> _builtins.str:
        """
        IKE Mode.
        """
        return pulumi.get(self, "ike_mode")

    @_builtins.property
    @pulumi.getter(name="ikePfs")
    def ike_pfs(self) -> _builtins.str:
        """
        DH Group.
        """
        return pulumi.get(self, "ike_pfs")

    @_builtins.property
    @pulumi.getter(name="ikeVersion")
    def ike_version(self) -> _builtins.str:
        """
        IKE Version.
        """
        return pulumi.get(self, "ike_version")

    @_builtins.property
    @pulumi.getter(name="localId")
    def local_id(self) -> _builtins.str:
        """
        The local Id.
        """
        return pulumi.get(self, "local_id")

    @_builtins.property
    @pulumi.getter
    def psk(self) -> _builtins.str:
        """
        Preshared secret key.
        """
        return pulumi.get(self, "psk")

    @_builtins.property
    @pulumi.getter(name="remoteId")
    def remote_id(self) -> _builtins.str:
        """
        Remote ID.
        """
        return pulumi.get(self, "remote_id")


@pulumi.output_type
class GetConnectionsConnectionTunnelOptionsSpecificationTunnelIpsecConfigResult(dict):
    def __init__(__self__, *,
                 ipsec_auth_alg: _builtins.str,
                 ipsec_enc_alg: _builtins.str,
                 ipsec_lifetime: _builtins.int,
                 ipsec_pfs: _builtins.str):
        """
        :param _builtins.str ipsec_auth_alg: IPsec Auth algorithm.
        :param _builtins.str ipsec_enc_alg: IPsec Encript algorithm.
        :param _builtins.int ipsec_lifetime: IPsec lifetime.
        :param _builtins.str ipsec_pfs: DH Group.
        """
        pulumi.set(__self__, "ipsec_auth_alg", ipsec_auth_alg)
        pulumi.set(__self__, "ipsec_enc_alg", ipsec_enc_alg)
        pulumi.set(__self__, "ipsec_lifetime", ipsec_lifetime)
        pulumi.set(__self__, "ipsec_pfs", ipsec_pfs)

    @_builtins.property
    @pulumi.getter(name="ipsecAuthAlg")
    def ipsec_auth_alg(self) -> _builtins.str:
        """
        IPsec Auth algorithm.
        """
        return pulumi.get(self, "ipsec_auth_alg")

    @_builtins.property
    @pulumi.getter(name="ipsecEncAlg")
    def ipsec_enc_alg(self) -> _builtins.str:
        """
        IPsec Encript algorithm.
        """
        return pulumi.get(self, "ipsec_enc_alg")

    @_builtins.property
    @pulumi.getter(name="ipsecLifetime")
    def ipsec_lifetime(self) -> _builtins.int:
        """
        IPsec lifetime.
        """
        return pulumi.get(self, "ipsec_lifetime")

    @_builtins.property
    @pulumi.getter(name="ipsecPfs")
    def ipsec_pfs(self) -> _builtins.str:
        """
        DH Group.
        """
        return pulumi.get(self, "ipsec_pfs")


@pulumi.output_type
class GetConnectionsConnectionVcoHealthCheckResult(dict):
    def __init__(__self__, *,
                 dip: Optional[_builtins.str] = None,
                 enable: Optional[_builtins.str] = None,
                 interval: Optional[_builtins.int] = None,
                 retry: Optional[_builtins.int] = None,
                 sip: Optional[_builtins.str] = None,
                 status: Optional[_builtins.str] = None):
        """
        :param _builtins.str dip: The destination ip address.
        :param _builtins.str enable: The health check on status. Valid values: `true`, `false`.
        :param _builtins.int interval: The time interval between health checks.
        :param _builtins.int retry: The number of retries for health checks issued.
        :param _builtins.str sip: The source ip address.
        :param _builtins.str status: The negotiation status of the BGP routing protocol. Valid values: `success`, `false`.
        """
        if dip is not None:
            pulumi.set(__self__, "dip", dip)
        if enable is not None:
            pulumi.set(__self__, "enable", enable)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if retry is not None:
            pulumi.set(__self__, "retry", retry)
        if sip is not None:
            pulumi.set(__self__, "sip", sip)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter
    def dip(self) -> Optional[_builtins.str]:
        """
        The destination ip address.
        """
        return pulumi.get(self, "dip")

    @_builtins.property
    @pulumi.getter
    def enable(self) -> Optional[_builtins.str]:
        """
        The health check on status. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "enable")

    @_builtins.property
    @pulumi.getter
    def interval(self) -> Optional[_builtins.int]:
        """
        The time interval between health checks.
        """
        return pulumi.get(self, "interval")

    @_builtins.property
    @pulumi.getter
    def retry(self) -> Optional[_builtins.int]:
        """
        The number of retries for health checks issued.
        """
        return pulumi.get(self, "retry")

    @_builtins.property
    @pulumi.getter
    def sip(self) -> Optional[_builtins.str]:
        """
        The source ip address.
        """
        return pulumi.get(self, "sip")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        The negotiation status of the BGP routing protocol. Valid values: `success`, `false`.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetConnectionsConnectionVpnBgpConfigResult(dict):
    def __init__(__self__, *,
                 auth_key: Optional[_builtins.str] = None,
                 local_asn: Optional[_builtins.int] = None,
                 local_bgp_ip: Optional[_builtins.str] = None,
                 peer_asn: Optional[_builtins.int] = None,
                 peer_bgp_ip: Optional[_builtins.str] = None,
                 status: Optional[_builtins.str] = None,
                 tunnel_cidr: Optional[_builtins.str] = None):
        """
        :param _builtins.str auth_key: The authentication keys for BGP routing protocols.
        :param _builtins.int local_asn: Local asn.
        :param _builtins.str local_bgp_ip: Local bgp IP.
        :param _builtins.int peer_asn: The counterpart autonomous system number.
        :param _builtins.str peer_bgp_ip: The BGP address on the other side.
        :param _builtins.str status: The negotiation status of the BGP routing protocol. Valid values: `success`, `false`.
        :param _builtins.str tunnel_cidr: BGP Tunnel CIDR.
        """
        if auth_key is not None:
            pulumi.set(__self__, "auth_key", auth_key)
        if local_asn is not None:
            pulumi.set(__self__, "local_asn", local_asn)
        if local_bgp_ip is not None:
            pulumi.set(__self__, "local_bgp_ip", local_bgp_ip)
        if peer_asn is not None:
            pulumi.set(__self__, "peer_asn", peer_asn)
        if peer_bgp_ip is not None:
            pulumi.set(__self__, "peer_bgp_ip", peer_bgp_ip)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tunnel_cidr is not None:
            pulumi.set(__self__, "tunnel_cidr", tunnel_cidr)

    @_builtins.property
    @pulumi.getter(name="authKey")
    def auth_key(self) -> Optional[_builtins.str]:
        """
        The authentication keys for BGP routing protocols.
        """
        return pulumi.get(self, "auth_key")

    @_builtins.property
    @pulumi.getter(name="localAsn")
    def local_asn(self) -> Optional[_builtins.int]:
        """
        Local asn.
        """
        return pulumi.get(self, "local_asn")

    @_builtins.property
    @pulumi.getter(name="localBgpIp")
    def local_bgp_ip(self) -> Optional[_builtins.str]:
        """
        Local bgp IP.
        """
        return pulumi.get(self, "local_bgp_ip")

    @_builtins.property
    @pulumi.getter(name="peerAsn")
    def peer_asn(self) -> Optional[_builtins.int]:
        """
        The counterpart autonomous system number.
        """
        return pulumi.get(self, "peer_asn")

    @_builtins.property
    @pulumi.getter(name="peerBgpIp")
    def peer_bgp_ip(self) -> Optional[_builtins.str]:
        """
        The BGP address on the other side.
        """
        return pulumi.get(self, "peer_bgp_ip")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        The negotiation status of the BGP routing protocol. Valid values: `success`, `false`.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="tunnelCidr")
    def tunnel_cidr(self) -> Optional[_builtins.str]:
        """
        BGP Tunnel CIDR.
        """
        return pulumi.get(self, "tunnel_cidr")


@pulumi.output_type
class GetCustomerGatewaysGatewayResult(dict):
    def __init__(__self__, *,
                 asn: _builtins.int,
                 create_time: _builtins.str,
                 description: _builtins.str,
                 id: _builtins.str,
                 ip_address: _builtins.str,
                 name: _builtins.str):
        """
        :param _builtins.int asn: The autonomous system number of the local data center gateway device of the VPN customer gateway.
        :param _builtins.str create_time: The creation time of the VPN customer gateway.
        :param _builtins.str description: The description of the VPN customer gateway.
        :param _builtins.str id: ID of the VPN customer gateway .
        :param _builtins.str ip_address: The ip address of the VPN customer gateway.
        :param _builtins.str name: The name of the VPN customer gateway.
        """
        pulumi.set(__self__, "asn", asn)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def asn(self) -> _builtins.int:
        """
        The autonomous system number of the local data center gateway device of the VPN customer gateway.
        """
        return pulumi.get(self, "asn")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        """
        The creation time of the VPN customer gateway.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the VPN customer gateway.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        ID of the VPN customer gateway .
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> _builtins.str:
        """
        The ip address of the VPN customer gateway.
        """
        return pulumi.get(self, "ip_address")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the VPN customer gateway.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetGatewayVcoRoutesRouteResult(dict):
    def __init__(__self__, *,
                 as_path: _builtins.str,
                 create_time: _builtins.str,
                 id: _builtins.str,
                 next_hop: _builtins.str,
                 route_dest: _builtins.str,
                 source: _builtins.str,
                 status: _builtins.str,
                 vpn_connection_id: _builtins.str,
                 weight: _builtins.int):
        """
        :param _builtins.str as_path: List of autonomous system numbers through which BGP routing entries pass.
        :param _builtins.str create_time: The creation time of the VPN destination route.
        :param _builtins.str id: The ID of the Vpn Gateway Vco Routes.
        :param _builtins.str next_hop: The next hop of the destination route.
        :param _builtins.str route_dest: The destination network segment of the destination route.
        :param _builtins.str source: The source CIDR block of the destination route.
        :param _builtins.str status: The status of the vpn route entry. Valid values: `normal`, `published`.
        :param _builtins.str vpn_connection_id: The id of the vpn connection.
        :param _builtins.int weight: The weight value of the destination route.
        """
        pulumi.set(__self__, "as_path", as_path)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "next_hop", next_hop)
        pulumi.set(__self__, "route_dest", route_dest)
        pulumi.set(__self__, "source", source)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "vpn_connection_id", vpn_connection_id)
        pulumi.set(__self__, "weight", weight)

    @_builtins.property
    @pulumi.getter(name="asPath")
    def as_path(self) -> _builtins.str:
        """
        List of autonomous system numbers through which BGP routing entries pass.
        """
        return pulumi.get(self, "as_path")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        """
        The creation time of the VPN destination route.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Vpn Gateway Vco Routes.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="nextHop")
    def next_hop(self) -> _builtins.str:
        """
        The next hop of the destination route.
        """
        return pulumi.get(self, "next_hop")

    @_builtins.property
    @pulumi.getter(name="routeDest")
    def route_dest(self) -> _builtins.str:
        """
        The destination network segment of the destination route.
        """
        return pulumi.get(self, "route_dest")

    @_builtins.property
    @pulumi.getter
    def source(self) -> _builtins.str:
        """
        The source CIDR block of the destination route.
        """
        return pulumi.get(self, "source")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the vpn route entry. Valid values: `normal`, `published`.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="vpnConnectionId")
    def vpn_connection_id(self) -> _builtins.str:
        """
        The id of the vpn connection.
        """
        return pulumi.get(self, "vpn_connection_id")

    @_builtins.property
    @pulumi.getter
    def weight(self) -> _builtins.int:
        """
        The weight value of the destination route.
        """
        return pulumi.get(self, "weight")


@pulumi.output_type
class GetGatewayVpnAttachmentsAttachmentResult(dict):
    def __init__(__self__, *,
                 attach_type: _builtins.str,
                 bgp_configs: Sequence['outputs.GetGatewayVpnAttachmentsAttachmentBgpConfigResult'],
                 connection_status: _builtins.str,
                 create_time: _builtins.str,
                 customer_gateway_id: _builtins.str,
                 effect_immediately: _builtins.bool,
                 enable_dpd: _builtins.bool,
                 enable_nat_traversal: _builtins.bool,
                 enable_tunnels_bgp: _builtins.bool,
                 health_check_configs: Sequence['outputs.GetGatewayVpnAttachmentsAttachmentHealthCheckConfigResult'],
                 id: _builtins.str,
                 ike_configs: Sequence['outputs.GetGatewayVpnAttachmentsAttachmentIkeConfigResult'],
                 internet_ip: _builtins.str,
                 ipsec_configs: Sequence['outputs.GetGatewayVpnAttachmentsAttachmentIpsecConfigResult'],
                 local_subnet: _builtins.str,
                 network_type: _builtins.str,
                 remote_subnet: _builtins.str,
                 resource_group_id: _builtins.str,
                 status: _builtins.str,
                 tags: Mapping[str, _builtins.str],
                 tunnel_options_specifications: Sequence['outputs.GetGatewayVpnAttachmentsAttachmentTunnelOptionsSpecificationResult'],
                 vpn_attachment_name: _builtins.str,
                 vpn_connection_id: _builtins.str):
        """
        :param _builtins.str attach_type: attach type- **CEN**: indicates that the IPsec-VPN connection is associated with a transit router of a Cloud Enterprise Network (CEN) instance.- **NO_ASSOCIATED**: indicates that the IPsec-VPN connection is not associated with any resource.
        :param Sequence['GetGatewayVpnAttachmentsAttachmentBgpConfigArgs'] bgp_configs: Bgp configuration information.- This parameter is supported when you create an vpn attachment in single-tunnel mode.
        :param _builtins.str connection_status: IPsec connection status- **ike_sa_not_established**: Phase 1 negotiations failed.- **ike_sa_established**: Phase 1 negotiations succeeded.- **ipsec_sa_not_established**: Phase 2 negotiations failed.- **ipsec_sa_established**: Phase 2 negotiations succeeded.
        :param _builtins.str create_time: The creation time of the resource
        :param _builtins.str customer_gateway_id: The ID of the user gateway associated with the tunnel.> This parameter is required when creating a dual-tunnel mode IPsec-VPN connection.
        :param _builtins.bool effect_immediately: Specifies whether to immediately start IPsec negotiations after the configuration takes effect. Valid values:- **true**: immediately starts IPsec negotiations after the configuration is complete.- **false** (default): starts IPsec negotiations when inbound traffic is received.
        :param _builtins.bool enable_dpd: Whether the DPD (peer alive detection) function is enabled for the tunnel. Value:-**true** (default): enable the DPD function. IPsec initiator will send DPD message to check whether the peer device is alive. If the peer device does not receive a correct response within the set time, it is considered that the peer has been disconnected. IPsec will delete ISAKMP SA and the corresponding IPsec SA, and the security tunnel will also be deleted.-**false**: If the DPD function is disabled, the IPsec initiator does not send DPD detection packets.
        :param _builtins.bool enable_nat_traversal: Whether the NAT crossing function is enabled for the tunnel. Value:-**true** (default): Enables the NAT Traversal function. When enabled, the IKE negotiation process deletes the verification process of the UDP port number and realizes the discovery function of the NAT gateway device in the tunnel.-**false**: does not enable the NAT Traversal function.
        :param _builtins.bool enable_tunnels_bgp: You can configure this parameter when you create a vpn attachment in dual-tunnel mode.Whether to enable the BGP function for the tunnel. Value: **true** or **false** (default).> before adding BGP configuration, we recommend that you understand the working mechanism and usage restrictions of the BGP dynamic routing function.
        :param Sequence['GetGatewayVpnAttachmentsAttachmentHealthCheckConfigArgs'] health_check_configs: This parameter is supported if you create an vpn attachment in single-tunnel mode.Health check configuration information.
        :param _builtins.str id: The ID of the resource supplied above.
        :param Sequence['GetGatewayVpnAttachmentsAttachmentIkeConfigArgs'] ike_configs: The configurations of Phase 1 negotiations. - This parameter is supported if you create an vpn attachment in single-tunnel mode.
        :param _builtins.str internet_ip: The local internet IP in Tunnel.
        :param Sequence['GetGatewayVpnAttachmentsAttachmentIpsecConfigArgs'] ipsec_configs: Configuration negotiated in the second stage. - This parameter is supported if you create an vpn attachment in single-tunnel mode.
        :param _builtins.str local_subnet: The CIDR block on the VPC side. The CIDR block is used in Phase 2 negotiations.Separate multiple CIDR blocks with commas (,). Example: 192.168.1.0/24,192.168.2.0/24.The following routing modes are supported:- If you set LocalSubnet and RemoteSubnet to 0.0.0.0/0, the routing mode of the IPsec-VPN connection is set to Destination Routing Mode.- If you set LocalSubnet and RemoteSubnet to specific CIDR blocks, the routing mode of the IPsec-VPN connection is set to Protected Data Flows.
        :param _builtins.str network_type: network type- **public** (default)- **private**
        :param _builtins.str remote_subnet: The CIDR block on the data center side. This CIDR block is used in Phase 2 negotiations.Separate multiple CIDR blocks with commas (,). Example: 192.168.3.0/24,192.168.4.0/24.The following routing modes are supported:- If you set LocalSubnet and RemoteSubnet to 0.0.0.0/0, the routing mode of the IPsec-VPN connection is set to Destination Routing Mode.- If you set LocalSubnet and RemoteSubnet to specific CIDR blocks, the routing mode of the IPsec-VPN connection is set to Protected Data Flows.
        :param _builtins.str resource_group_id: The ID of the resource group
        :param _builtins.str status: The status of the resource. Valid values: `init`, `active`, `attaching`, `attached`, `detaching`, `financialLocked`, `provisioning`, `updating`, `upgrading`, `deleted`.
        :param Mapping[str, _builtins.str] tags: Tags
        :param Sequence['GetGatewayVpnAttachmentsAttachmentTunnelOptionsSpecificationArgs'] tunnel_options_specifications: Configure the tunnel.-You can configure parameters in the **tunnel_options_specification** array when you create a vpn attachment in dual-tunnel mode.-When creating a vpn attachment in dual-tunnel mode, you must add both tunnels for the vpn attachment to ensure that the vpn attachment has link redundancy. Only two tunnels can be added to a vpn attachment.
        :param _builtins.str vpn_attachment_name: vpn attachment name
        :param _builtins.str vpn_connection_id: The first ID of the resource
        """
        pulumi.set(__self__, "attach_type", attach_type)
        pulumi.set(__self__, "bgp_configs", bgp_configs)
        pulumi.set(__self__, "connection_status", connection_status)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "customer_gateway_id", customer_gateway_id)
        pulumi.set(__self__, "effect_immediately", effect_immediately)
        pulumi.set(__self__, "enable_dpd", enable_dpd)
        pulumi.set(__self__, "enable_nat_traversal", enable_nat_traversal)
        pulumi.set(__self__, "enable_tunnels_bgp", enable_tunnels_bgp)
        pulumi.set(__self__, "health_check_configs", health_check_configs)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "ike_configs", ike_configs)
        pulumi.set(__self__, "internet_ip", internet_ip)
        pulumi.set(__self__, "ipsec_configs", ipsec_configs)
        pulumi.set(__self__, "local_subnet", local_subnet)
        pulumi.set(__self__, "network_type", network_type)
        pulumi.set(__self__, "remote_subnet", remote_subnet)
        pulumi.set(__self__, "resource_group_id", resource_group_id)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "tunnel_options_specifications", tunnel_options_specifications)
        pulumi.set(__self__, "vpn_attachment_name", vpn_attachment_name)
        pulumi.set(__self__, "vpn_connection_id", vpn_connection_id)

    @_builtins.property
    @pulumi.getter(name="attachType")
    def attach_type(self) -> _builtins.str:
        """
        attach type- **CEN**: indicates that the IPsec-VPN connection is associated with a transit router of a Cloud Enterprise Network (CEN) instance.- **NO_ASSOCIATED**: indicates that the IPsec-VPN connection is not associated with any resource.
        """
        return pulumi.get(self, "attach_type")

    @_builtins.property
    @pulumi.getter(name="bgpConfigs")
    def bgp_configs(self) -> Sequence['outputs.GetGatewayVpnAttachmentsAttachmentBgpConfigResult']:
        """
        Bgp configuration information.- This parameter is supported when you create an vpn attachment in single-tunnel mode.
        """
        return pulumi.get(self, "bgp_configs")

    @_builtins.property
    @pulumi.getter(name="connectionStatus")
    def connection_status(self) -> _builtins.str:
        """
        IPsec connection status- **ike_sa_not_established**: Phase 1 negotiations failed.- **ike_sa_established**: Phase 1 negotiations succeeded.- **ipsec_sa_not_established**: Phase 2 negotiations failed.- **ipsec_sa_established**: Phase 2 negotiations succeeded.
        """
        return pulumi.get(self, "connection_status")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        """
        The creation time of the resource
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="customerGatewayId")
    def customer_gateway_id(self) -> _builtins.str:
        """
        The ID of the user gateway associated with the tunnel.> This parameter is required when creating a dual-tunnel mode IPsec-VPN connection.
        """
        return pulumi.get(self, "customer_gateway_id")

    @_builtins.property
    @pulumi.getter(name="effectImmediately")
    def effect_immediately(self) -> _builtins.bool:
        """
        Specifies whether to immediately start IPsec negotiations after the configuration takes effect. Valid values:- **true**: immediately starts IPsec negotiations after the configuration is complete.- **false** (default): starts IPsec negotiations when inbound traffic is received.
        """
        return pulumi.get(self, "effect_immediately")

    @_builtins.property
    @pulumi.getter(name="enableDpd")
    def enable_dpd(self) -> _builtins.bool:
        """
        Whether the DPD (peer alive detection) function is enabled for the tunnel. Value:-**true** (default): enable the DPD function. IPsec initiator will send DPD message to check whether the peer device is alive. If the peer device does not receive a correct response within the set time, it is considered that the peer has been disconnected. IPsec will delete ISAKMP SA and the corresponding IPsec SA, and the security tunnel will also be deleted.-**false**: If the DPD function is disabled, the IPsec initiator does not send DPD detection packets.
        """
        return pulumi.get(self, "enable_dpd")

    @_builtins.property
    @pulumi.getter(name="enableNatTraversal")
    def enable_nat_traversal(self) -> _builtins.bool:
        """
        Whether the NAT crossing function is enabled for the tunnel. Value:-**true** (default): Enables the NAT Traversal function. When enabled, the IKE negotiation process deletes the verification process of the UDP port number and realizes the discovery function of the NAT gateway device in the tunnel.-**false**: does not enable the NAT Traversal function.
        """
        return pulumi.get(self, "enable_nat_traversal")

    @_builtins.property
    @pulumi.getter(name="enableTunnelsBgp")
    def enable_tunnels_bgp(self) -> _builtins.bool:
        """
        You can configure this parameter when you create a vpn attachment in dual-tunnel mode.Whether to enable the BGP function for the tunnel. Value: **true** or **false** (default).> before adding BGP configuration, we recommend that you understand the working mechanism and usage restrictions of the BGP dynamic routing function.
        """
        return pulumi.get(self, "enable_tunnels_bgp")

    @_builtins.property
    @pulumi.getter(name="healthCheckConfigs")
    def health_check_configs(self) -> Sequence['outputs.GetGatewayVpnAttachmentsAttachmentHealthCheckConfigResult']:
        """
        This parameter is supported if you create an vpn attachment in single-tunnel mode.Health check configuration information.
        """
        return pulumi.get(self, "health_check_configs")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the resource supplied above.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="ikeConfigs")
    def ike_configs(self) -> Sequence['outputs.GetGatewayVpnAttachmentsAttachmentIkeConfigResult']:
        """
        The configurations of Phase 1 negotiations. - This parameter is supported if you create an vpn attachment in single-tunnel mode.
        """
        return pulumi.get(self, "ike_configs")

    @_builtins.property
    @pulumi.getter(name="internetIp")
    def internet_ip(self) -> _builtins.str:
        """
        The local internet IP in Tunnel.
        """
        return pulumi.get(self, "internet_ip")

    @_builtins.property
    @pulumi.getter(name="ipsecConfigs")
    def ipsec_configs(self) -> Sequence['outputs.GetGatewayVpnAttachmentsAttachmentIpsecConfigResult']:
        """
        Configuration negotiated in the second stage. - This parameter is supported if you create an vpn attachment in single-tunnel mode.
        """
        return pulumi.get(self, "ipsec_configs")

    @_builtins.property
    @pulumi.getter(name="localSubnet")
    def local_subnet(self) -> _builtins.str:
        """
        The CIDR block on the VPC side. The CIDR block is used in Phase 2 negotiations.Separate multiple CIDR blocks with commas (,). Example: 192.168.1.0/24,192.168.2.0/24.The following routing modes are supported:- If you set LocalSubnet and RemoteSubnet to 0.0.0.0/0, the routing mode of the IPsec-VPN connection is set to Destination Routing Mode.- If you set LocalSubnet and RemoteSubnet to specific CIDR blocks, the routing mode of the IPsec-VPN connection is set to Protected Data Flows.
        """
        return pulumi.get(self, "local_subnet")

    @_builtins.property
    @pulumi.getter(name="networkType")
    def network_type(self) -> _builtins.str:
        """
        network type- **public** (default)- **private**
        """
        return pulumi.get(self, "network_type")

    @_builtins.property
    @pulumi.getter(name="remoteSubnet")
    def remote_subnet(self) -> _builtins.str:
        """
        The CIDR block on the data center side. This CIDR block is used in Phase 2 negotiations.Separate multiple CIDR blocks with commas (,). Example: 192.168.3.0/24,192.168.4.0/24.The following routing modes are supported:- If you set LocalSubnet and RemoteSubnet to 0.0.0.0/0, the routing mode of the IPsec-VPN connection is set to Destination Routing Mode.- If you set LocalSubnet and RemoteSubnet to specific CIDR blocks, the routing mode of the IPsec-VPN connection is set to Protected Data Flows.
        """
        return pulumi.get(self, "remote_subnet")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> _builtins.str:
        """
        The ID of the resource group
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the resource. Valid values: `init`, `active`, `attaching`, `attached`, `detaching`, `financialLocked`, `provisioning`, `updating`, `upgrading`, `deleted`.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        Tags
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tunnelOptionsSpecifications")
    def tunnel_options_specifications(self) -> Sequence['outputs.GetGatewayVpnAttachmentsAttachmentTunnelOptionsSpecificationResult']:
        """
        Configure the tunnel.-You can configure parameters in the **tunnel_options_specification** array when you create a vpn attachment in dual-tunnel mode.-When creating a vpn attachment in dual-tunnel mode, you must add both tunnels for the vpn attachment to ensure that the vpn attachment has link redundancy. Only two tunnels can be added to a vpn attachment.
        """
        return pulumi.get(self, "tunnel_options_specifications")

    @_builtins.property
    @pulumi.getter(name="vpnAttachmentName")
    def vpn_attachment_name(self) -> _builtins.str:
        """
        vpn attachment name
        """
        return pulumi.get(self, "vpn_attachment_name")

    @_builtins.property
    @pulumi.getter(name="vpnConnectionId")
    def vpn_connection_id(self) -> _builtins.str:
        """
        The first ID of the resource
        """
        return pulumi.get(self, "vpn_connection_id")


@pulumi.output_type
class GetGatewayVpnAttachmentsAttachmentBgpConfigResult(dict):
    def __init__(__self__, *,
                 local_asn: _builtins.int,
                 local_bgp_ip: _builtins.str,
                 status: _builtins.str,
                 tunnel_cidr: _builtins.str):
        """
        :param _builtins.int local_asn: The number of the local (Alibaba Cloud) autonomous system of the tunnel. The value range of the autonomous system number is **1** to **4294967295**. Default value: **45104**.> We recommend that you use the private number of the autonomous system number to establish a BGP connection with Alibaba Cloud. The private number range of the autonomous system number please consult the document yourself.
        :param _builtins.str local_bgp_ip: The local BGP address of the tunnel (on the Alibaba Cloud side). This address is an IP address in the BGP network segment.
        :param _builtins.str status: The status of the resource. Valid values: `init`, `active`, `attaching`, `attached`, `detaching`, `financialLocked`, `provisioning`, `updating`, `upgrading`, `deleted`.
        :param _builtins.str tunnel_cidr: The BGP network segment of the tunnel. The network segment must be a network segment with a mask length of 30 in 169.254.0.0/16, and cannot be 169.254.0.0/30, 169.254.1.0/30, 169.254.2.0/30, 169.254.3.0/30, 169.254.4.0/30, 169.254.5.0/30, 169.254.6.0/30, and 169.254.169.252/30.> the network segments of two tunnels under an IPsec connection cannot be the same.
        """
        pulumi.set(__self__, "local_asn", local_asn)
        pulumi.set(__self__, "local_bgp_ip", local_bgp_ip)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "tunnel_cidr", tunnel_cidr)

    @_builtins.property
    @pulumi.getter(name="localAsn")
    def local_asn(self) -> _builtins.int:
        """
        The number of the local (Alibaba Cloud) autonomous system of the tunnel. The value range of the autonomous system number is **1** to **4294967295**. Default value: **45104**.> We recommend that you use the private number of the autonomous system number to establish a BGP connection with Alibaba Cloud. The private number range of the autonomous system number please consult the document yourself.
        """
        return pulumi.get(self, "local_asn")

    @_builtins.property
    @pulumi.getter(name="localBgpIp")
    def local_bgp_ip(self) -> _builtins.str:
        """
        The local BGP address of the tunnel (on the Alibaba Cloud side). This address is an IP address in the BGP network segment.
        """
        return pulumi.get(self, "local_bgp_ip")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the resource. Valid values: `init`, `active`, `attaching`, `attached`, `detaching`, `financialLocked`, `provisioning`, `updating`, `upgrading`, `deleted`.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="tunnelCidr")
    def tunnel_cidr(self) -> _builtins.str:
        """
        The BGP network segment of the tunnel. The network segment must be a network segment with a mask length of 30 in 169.254.0.0/16, and cannot be 169.254.0.0/30, 169.254.1.0/30, 169.254.2.0/30, 169.254.3.0/30, 169.254.4.0/30, 169.254.5.0/30, 169.254.6.0/30, and 169.254.169.252/30.> the network segments of two tunnels under an IPsec connection cannot be the same.
        """
        return pulumi.get(self, "tunnel_cidr")


@pulumi.output_type
class GetGatewayVpnAttachmentsAttachmentHealthCheckConfigResult(dict):
    def __init__(__self__, *,
                 dip: _builtins.str,
                 enable: _builtins.bool,
                 interval: _builtins.int,
                 policy: _builtins.str,
                 retry: _builtins.int,
                 sip: _builtins.str,
                 status: _builtins.str):
        """
        :param _builtins.str dip: Target IP.
        :param _builtins.bool enable: Whether health check is enabled:-**false**: not enabled. -**true**: enabled.
        :param _builtins.int interval: The health check retry interval, in seconds.
        :param _builtins.str policy: Whether to revoke the published route when the health check fails- **revoke_route**(default): withdraws published routes.- **reserve_route**: does not withdraw published routes.
        :param _builtins.int retry: Number of retries for health check.
        :param _builtins.str sip: SOURCE IP.
        :param _builtins.str status: The status of the resource. Valid values: `init`, `active`, `attaching`, `attached`, `detaching`, `financialLocked`, `provisioning`, `updating`, `upgrading`, `deleted`.
        """
        pulumi.set(__self__, "dip", dip)
        pulumi.set(__self__, "enable", enable)
        pulumi.set(__self__, "interval", interval)
        pulumi.set(__self__, "policy", policy)
        pulumi.set(__self__, "retry", retry)
        pulumi.set(__self__, "sip", sip)
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter
    def dip(self) -> _builtins.str:
        """
        Target IP.
        """
        return pulumi.get(self, "dip")

    @_builtins.property
    @pulumi.getter
    def enable(self) -> _builtins.bool:
        """
        Whether health check is enabled:-**false**: not enabled. -**true**: enabled.
        """
        return pulumi.get(self, "enable")

    @_builtins.property
    @pulumi.getter
    def interval(self) -> _builtins.int:
        """
        The health check retry interval, in seconds.
        """
        return pulumi.get(self, "interval")

    @_builtins.property
    @pulumi.getter
    def policy(self) -> _builtins.str:
        """
        Whether to revoke the published route when the health check fails- **revoke_route**(default): withdraws published routes.- **reserve_route**: does not withdraw published routes.
        """
        return pulumi.get(self, "policy")

    @_builtins.property
    @pulumi.getter
    def retry(self) -> _builtins.int:
        """
        Number of retries for health check.
        """
        return pulumi.get(self, "retry")

    @_builtins.property
    @pulumi.getter
    def sip(self) -> _builtins.str:
        """
        SOURCE IP.
        """
        return pulumi.get(self, "sip")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the resource. Valid values: `init`, `active`, `attaching`, `attached`, `detaching`, `financialLocked`, `provisioning`, `updating`, `upgrading`, `deleted`.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetGatewayVpnAttachmentsAttachmentIkeConfigResult(dict):
    def __init__(__self__, *,
                 ike_auth_alg: _builtins.str,
                 ike_enc_alg: _builtins.str,
                 ike_lifetime: _builtins.int,
                 ike_mode: _builtins.str,
                 ike_pfs: _builtins.str,
                 ike_version: _builtins.str,
                 local_id: _builtins.str,
                 psk: _builtins.str,
                 remote_id: _builtins.str):
        """
        :param _builtins.str ike_auth_alg: The authentication algorithm negotiated in the first stage. Values: **md5**, **sha1**, **sha256**, **sha384**, **sha512**. Default value: **sha1**.
        :param _builtins.str ike_enc_alg: The encryption algorithm negotiated in the first stage. Value: **aes**, **aes192**, **aes256**, **des**, or **3des**. Default value: **aes**.
        :param _builtins.int ike_lifetime: The life cycle of SA negotiated in the first stage. Unit: seconds.Value range: **0** to **86400**. Default value: **86400**.
        :param _builtins.str ike_mode: IKE version of the negotiation mode. Value: **main** or **aggressive**. Default value: **main**.-**main**: main mode, high security during negotiation.-**aggressive**: Savage mode, fast negotiation and high negotiation success rate.
        :param _builtins.str ike_pfs: The first stage negotiates the Diffie-Hellman key exchange algorithm used. Default value: **group2**.Values: **group1**, **group2**, **group5**, **group14**.
        :param _builtins.str ike_version: Version of the IKE protocol. Value: **ikev1** or **ikev2**. Default value: **ikev2**.Compared with IKEv1, IKEv2 simplifies the SA negotiation process and provides better support for multiple network segments.
        :param _builtins.str local_id: The identifier of the local end of the tunnel (Alibaba Cloud side), which is used for the first phase of negotiation. The length is limited to 100 characters and cannot contain spaces. The default value is the IP address of the tunnel.**LocalId** supports the FQDN format. If you use the FQDN format, we recommend that you select **aggressive** (barbaric mode) as the negotiation mode.
        :param _builtins.str psk: The pre-shared key is used for identity authentication between the tunnel and the tunnel peer.-The key can be 1 to 100 characters in length. It supports numbers, upper and lower case English letters, and characters on the right. It cannot contain spaces. '''~! \\'@#$%^& *()_-+ ={}[]|;:',./? '''-If you do not specify a pre-shared key, the system randomly generates a 16-bit string as the pre-shared key. > The pre-shared key of the tunnel and the tunnel peer must be the same, otherwise the system cannot establish the tunnel normally.
        :param _builtins.str remote_id: Identifier of the tunnel peer, which is used for the first-stage negotiation. The length is limited to 100 characters and cannot contain spaces. The default value is the IP address of the user gateway associated with the tunnel.- **RemoteId** supports the FQDN format. If you use the FQDN format, we recommend that you select **aggressive** (barbaric mode) as the negotiation mode.
        """
        pulumi.set(__self__, "ike_auth_alg", ike_auth_alg)
        pulumi.set(__self__, "ike_enc_alg", ike_enc_alg)
        pulumi.set(__self__, "ike_lifetime", ike_lifetime)
        pulumi.set(__self__, "ike_mode", ike_mode)
        pulumi.set(__self__, "ike_pfs", ike_pfs)
        pulumi.set(__self__, "ike_version", ike_version)
        pulumi.set(__self__, "local_id", local_id)
        pulumi.set(__self__, "psk", psk)
        pulumi.set(__self__, "remote_id", remote_id)

    @_builtins.property
    @pulumi.getter(name="ikeAuthAlg")
    def ike_auth_alg(self) -> _builtins.str:
        """
        The authentication algorithm negotiated in the first stage. Values: **md5**, **sha1**, **sha256**, **sha384**, **sha512**. Default value: **sha1**.
        """
        return pulumi.get(self, "ike_auth_alg")

    @_builtins.property
    @pulumi.getter(name="ikeEncAlg")
    def ike_enc_alg(self) -> _builtins.str:
        """
        The encryption algorithm negotiated in the first stage. Value: **aes**, **aes192**, **aes256**, **des**, or **3des**. Default value: **aes**.
        """
        return pulumi.get(self, "ike_enc_alg")

    @_builtins.property
    @pulumi.getter(name="ikeLifetime")
    def ike_lifetime(self) -> _builtins.int:
        """
        The life cycle of SA negotiated in the first stage. Unit: seconds.Value range: **0** to **86400**. Default value: **86400**.
        """
        return pulumi.get(self, "ike_lifetime")

    @_builtins.property
    @pulumi.getter(name="ikeMode")
    def ike_mode(self) -> _builtins.str:
        """
        IKE version of the negotiation mode. Value: **main** or **aggressive**. Default value: **main**.-**main**: main mode, high security during negotiation.-**aggressive**: Savage mode, fast negotiation and high negotiation success rate.
        """
        return pulumi.get(self, "ike_mode")

    @_builtins.property
    @pulumi.getter(name="ikePfs")
    def ike_pfs(self) -> _builtins.str:
        """
        The first stage negotiates the Diffie-Hellman key exchange algorithm used. Default value: **group2**.Values: **group1**, **group2**, **group5**, **group14**.
        """
        return pulumi.get(self, "ike_pfs")

    @_builtins.property
    @pulumi.getter(name="ikeVersion")
    def ike_version(self) -> _builtins.str:
        """
        Version of the IKE protocol. Value: **ikev1** or **ikev2**. Default value: **ikev2**.Compared with IKEv1, IKEv2 simplifies the SA negotiation process and provides better support for multiple network segments.
        """
        return pulumi.get(self, "ike_version")

    @_builtins.property
    @pulumi.getter(name="localId")
    def local_id(self) -> _builtins.str:
        """
        The identifier of the local end of the tunnel (Alibaba Cloud side), which is used for the first phase of negotiation. The length is limited to 100 characters and cannot contain spaces. The default value is the IP address of the tunnel.**LocalId** supports the FQDN format. If you use the FQDN format, we recommend that you select **aggressive** (barbaric mode) as the negotiation mode.
        """
        return pulumi.get(self, "local_id")

    @_builtins.property
    @pulumi.getter
    def psk(self) -> _builtins.str:
        """
        The pre-shared key is used for identity authentication between the tunnel and the tunnel peer.-The key can be 1 to 100 characters in length. It supports numbers, upper and lower case English letters, and characters on the right. It cannot contain spaces. '''~! \\'@#$%^& *()_-+ ={}[]|;:',./? '''-If you do not specify a pre-shared key, the system randomly generates a 16-bit string as the pre-shared key. > The pre-shared key of the tunnel and the tunnel peer must be the same, otherwise the system cannot establish the tunnel normally.
        """
        return pulumi.get(self, "psk")

    @_builtins.property
    @pulumi.getter(name="remoteId")
    def remote_id(self) -> _builtins.str:
        """
        Identifier of the tunnel peer, which is used for the first-stage negotiation. The length is limited to 100 characters and cannot contain spaces. The default value is the IP address of the user gateway associated with the tunnel.- **RemoteId** supports the FQDN format. If you use the FQDN format, we recommend that you select **aggressive** (barbaric mode) as the negotiation mode.
        """
        return pulumi.get(self, "remote_id")


@pulumi.output_type
class GetGatewayVpnAttachmentsAttachmentIpsecConfigResult(dict):
    def __init__(__self__, *,
                 ipsec_auth_alg: _builtins.str,
                 ipsec_enc_alg: _builtins.str,
                 ipsec_lifetime: _builtins.int,
                 ipsec_pfs: _builtins.str):
        """
        :param _builtins.str ipsec_auth_alg: The second stage negotiated authentication algorithm.Values: **md5**, **sha1**, **sha256**, **sha384**, **sha512**. Default value: **sha1**.
        :param _builtins.str ipsec_enc_alg: The encryption algorithm negotiated in the second stage. Value: **aes**, **aes192**, **aes256**, **des**, or **3des**. Default value: **aes**.
        :param _builtins.int ipsec_lifetime: The life cycle of SA negotiated in the second stage. Unit: seconds.Value range: **0** to **86400**. Default value: **86400**.
        :param _builtins.str ipsec_pfs: The second stage negotiates the Diffie-Hellman key exchange algorithm used. Default value: **group2**.Values: **disabled**, **group1**, **group2**, **group5**, **group14**.
        """
        pulumi.set(__self__, "ipsec_auth_alg", ipsec_auth_alg)
        pulumi.set(__self__, "ipsec_enc_alg", ipsec_enc_alg)
        pulumi.set(__self__, "ipsec_lifetime", ipsec_lifetime)
        pulumi.set(__self__, "ipsec_pfs", ipsec_pfs)

    @_builtins.property
    @pulumi.getter(name="ipsecAuthAlg")
    def ipsec_auth_alg(self) -> _builtins.str:
        """
        The second stage negotiated authentication algorithm.Values: **md5**, **sha1**, **sha256**, **sha384**, **sha512**. Default value: **sha1**.
        """
        return pulumi.get(self, "ipsec_auth_alg")

    @_builtins.property
    @pulumi.getter(name="ipsecEncAlg")
    def ipsec_enc_alg(self) -> _builtins.str:
        """
        The encryption algorithm negotiated in the second stage. Value: **aes**, **aes192**, **aes256**, **des**, or **3des**. Default value: **aes**.
        """
        return pulumi.get(self, "ipsec_enc_alg")

    @_builtins.property
    @pulumi.getter(name="ipsecLifetime")
    def ipsec_lifetime(self) -> _builtins.int:
        """
        The life cycle of SA negotiated in the second stage. Unit: seconds.Value range: **0** to **86400**. Default value: **86400**.
        """
        return pulumi.get(self, "ipsec_lifetime")

    @_builtins.property
    @pulumi.getter(name="ipsecPfs")
    def ipsec_pfs(self) -> _builtins.str:
        """
        The second stage negotiates the Diffie-Hellman key exchange algorithm used. Default value: **group2**.Values: **disabled**, **group1**, **group2**, **group5**, **group14**.
        """
        return pulumi.get(self, "ipsec_pfs")


@pulumi.output_type
class GetGatewayVpnAttachmentsAttachmentTunnelOptionsSpecificationResult(dict):
    def __init__(__self__, *,
                 customer_gateway_id: _builtins.str,
                 enable_dpd: _builtins.bool,
                 enable_nat_traversal: _builtins.bool,
                 internet_ip: _builtins.str,
                 role: _builtins.str,
                 state: _builtins.str,
                 status: _builtins.str,
                 tunnel_bgp_config: 'outputs.GetGatewayVpnAttachmentsAttachmentTunnelOptionsSpecificationTunnelBgpConfigResult',
                 tunnel_id: _builtins.str,
                 tunnel_ike_config: 'outputs.GetGatewayVpnAttachmentsAttachmentTunnelOptionsSpecificationTunnelIkeConfigResult',
                 tunnel_index: _builtins.int,
                 tunnel_ipsec_config: 'outputs.GetGatewayVpnAttachmentsAttachmentTunnelOptionsSpecificationTunnelIpsecConfigResult',
                 zone_no: _builtins.str):
        """
        :param _builtins.str customer_gateway_id: The ID of the user gateway associated with the tunnel.> This parameter is required when creating a dual-tunnel mode IPsec-VPN connection.
        :param _builtins.bool enable_dpd: Whether the DPD (peer alive detection) function is enabled for the tunnel. Value:-**true** (default): enable the DPD function. IPsec initiator will send DPD message to check whether the peer device is alive. If the peer device does not receive a correct response within the set time, it is considered that the peer has been disconnected. IPsec will delete ISAKMP SA and the corresponding IPsec SA, and the security tunnel will also be deleted.-**false**: If the DPD function is disabled, the IPsec initiator does not send DPD detection packets.
        :param _builtins.bool enable_nat_traversal: Whether the NAT crossing function is enabled for the tunnel. Value:-**true** (default): Enables the NAT Traversal function. When enabled, the IKE negotiation process deletes the verification process of the UDP port number and realizes the discovery function of the NAT gateway device in the tunnel.-**false**: does not enable the NAT Traversal function.
        :param _builtins.str internet_ip: The local internet IP in Tunnel.
        :param _builtins.str role: The role of Tunnel.
        :param _builtins.str state: The state of Tunnel.
        :param _builtins.str status: The status of the resource. Valid values: `init`, `active`, `attaching`, `attached`, `detaching`, `financialLocked`, `provisioning`, `updating`, `upgrading`, `deleted`.
        :param 'GetGatewayVpnAttachmentsAttachmentTunnelOptionsSpecificationTunnelBgpConfigArgs' tunnel_bgp_config: Add the BGP configuration for the tunnel.> After you enable the BGP function for IPsec connections (that is, specify **EnableTunnelsBgp** as **true**), you must configure this parameter.
        :param _builtins.str tunnel_id: The tunnel ID of IPsec-VPN connection.
        :param 'GetGatewayVpnAttachmentsAttachmentTunnelOptionsSpecificationTunnelIkeConfigArgs' tunnel_ike_config: Configuration information for the first phase negotiation.
        :param _builtins.int tunnel_index: The order in which the tunnel was created.-**1**: First tunnel.-**2**: The second tunnel.
        :param 'GetGatewayVpnAttachmentsAttachmentTunnelOptionsSpecificationTunnelIpsecConfigArgs' tunnel_ipsec_config: Configuration information for the second-stage negotiation.
        :param _builtins.str zone_no: The zoneNo of tunnel.
        """
        pulumi.set(__self__, "customer_gateway_id", customer_gateway_id)
        pulumi.set(__self__, "enable_dpd", enable_dpd)
        pulumi.set(__self__, "enable_nat_traversal", enable_nat_traversal)
        pulumi.set(__self__, "internet_ip", internet_ip)
        pulumi.set(__self__, "role", role)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "tunnel_bgp_config", tunnel_bgp_config)
        pulumi.set(__self__, "tunnel_id", tunnel_id)
        pulumi.set(__self__, "tunnel_ike_config", tunnel_ike_config)
        pulumi.set(__self__, "tunnel_index", tunnel_index)
        pulumi.set(__self__, "tunnel_ipsec_config", tunnel_ipsec_config)
        pulumi.set(__self__, "zone_no", zone_no)

    @_builtins.property
    @pulumi.getter(name="customerGatewayId")
    def customer_gateway_id(self) -> _builtins.str:
        """
        The ID of the user gateway associated with the tunnel.> This parameter is required when creating a dual-tunnel mode IPsec-VPN connection.
        """
        return pulumi.get(self, "customer_gateway_id")

    @_builtins.property
    @pulumi.getter(name="enableDpd")
    def enable_dpd(self) -> _builtins.bool:
        """
        Whether the DPD (peer alive detection) function is enabled for the tunnel. Value:-**true** (default): enable the DPD function. IPsec initiator will send DPD message to check whether the peer device is alive. If the peer device does not receive a correct response within the set time, it is considered that the peer has been disconnected. IPsec will delete ISAKMP SA and the corresponding IPsec SA, and the security tunnel will also be deleted.-**false**: If the DPD function is disabled, the IPsec initiator does not send DPD detection packets.
        """
        return pulumi.get(self, "enable_dpd")

    @_builtins.property
    @pulumi.getter(name="enableNatTraversal")
    def enable_nat_traversal(self) -> _builtins.bool:
        """
        Whether the NAT crossing function is enabled for the tunnel. Value:-**true** (default): Enables the NAT Traversal function. When enabled, the IKE negotiation process deletes the verification process of the UDP port number and realizes the discovery function of the NAT gateway device in the tunnel.-**false**: does not enable the NAT Traversal function.
        """
        return pulumi.get(self, "enable_nat_traversal")

    @_builtins.property
    @pulumi.getter(name="internetIp")
    def internet_ip(self) -> _builtins.str:
        """
        The local internet IP in Tunnel.
        """
        return pulumi.get(self, "internet_ip")

    @_builtins.property
    @pulumi.getter
    def role(self) -> _builtins.str:
        """
        The role of Tunnel.
        """
        return pulumi.get(self, "role")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        The state of Tunnel.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the resource. Valid values: `init`, `active`, `attaching`, `attached`, `detaching`, `financialLocked`, `provisioning`, `updating`, `upgrading`, `deleted`.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="tunnelBgpConfig")
    def tunnel_bgp_config(self) -> 'outputs.GetGatewayVpnAttachmentsAttachmentTunnelOptionsSpecificationTunnelBgpConfigResult':
        """
        Add the BGP configuration for the tunnel.> After you enable the BGP function for IPsec connections (that is, specify **EnableTunnelsBgp** as **true**), you must configure this parameter.
        """
        return pulumi.get(self, "tunnel_bgp_config")

    @_builtins.property
    @pulumi.getter(name="tunnelId")
    def tunnel_id(self) -> _builtins.str:
        """
        The tunnel ID of IPsec-VPN connection.
        """
        return pulumi.get(self, "tunnel_id")

    @_builtins.property
    @pulumi.getter(name="tunnelIkeConfig")
    def tunnel_ike_config(self) -> 'outputs.GetGatewayVpnAttachmentsAttachmentTunnelOptionsSpecificationTunnelIkeConfigResult':
        """
        Configuration information for the first phase negotiation.
        """
        return pulumi.get(self, "tunnel_ike_config")

    @_builtins.property
    @pulumi.getter(name="tunnelIndex")
    def tunnel_index(self) -> _builtins.int:
        """
        The order in which the tunnel was created.-**1**: First tunnel.-**2**: The second tunnel.
        """
        return pulumi.get(self, "tunnel_index")

    @_builtins.property
    @pulumi.getter(name="tunnelIpsecConfig")
    def tunnel_ipsec_config(self) -> 'outputs.GetGatewayVpnAttachmentsAttachmentTunnelOptionsSpecificationTunnelIpsecConfigResult':
        """
        Configuration information for the second-stage negotiation.
        """
        return pulumi.get(self, "tunnel_ipsec_config")

    @_builtins.property
    @pulumi.getter(name="zoneNo")
    def zone_no(self) -> _builtins.str:
        """
        The zoneNo of tunnel.
        """
        return pulumi.get(self, "zone_no")


@pulumi.output_type
class GetGatewayVpnAttachmentsAttachmentTunnelOptionsSpecificationTunnelBgpConfigResult(dict):
    def __init__(__self__, *,
                 bgp_status: _builtins.str,
                 local_asn: _builtins.int,
                 local_bgp_ip: _builtins.str,
                 peer_asn: _builtins.str,
                 peer_bgp_ip: _builtins.str,
                 tunnel_cidr: _builtins.str):
        """
        :param _builtins.str bgp_status: BGP status.
        :param _builtins.int local_asn: The number of the local (Alibaba Cloud) autonomous system of the tunnel. The value range of the autonomous system number is **1** to **4294967295**. Default value: **45104**.> We recommend that you use the private number of the autonomous system number to establish a BGP connection with Alibaba Cloud. The private number range of the autonomous system number please consult the document yourself.
        :param _builtins.str local_bgp_ip: The local BGP address of the tunnel (on the Alibaba Cloud side). This address is an IP address in the BGP network segment.
        :param _builtins.str peer_asn: Peer asn.
        :param _builtins.str peer_bgp_ip: Peer bgp ip.
        :param _builtins.str tunnel_cidr: The BGP network segment of the tunnel. The network segment must be a network segment with a mask length of 30 in 169.254.0.0/16, and cannot be 169.254.0.0/30, 169.254.1.0/30, 169.254.2.0/30, 169.254.3.0/30, 169.254.4.0/30, 169.254.5.0/30, 169.254.6.0/30, and 169.254.169.252/30.> the network segments of two tunnels under an IPsec connection cannot be the same.
        """
        pulumi.set(__self__, "bgp_status", bgp_status)
        pulumi.set(__self__, "local_asn", local_asn)
        pulumi.set(__self__, "local_bgp_ip", local_bgp_ip)
        pulumi.set(__self__, "peer_asn", peer_asn)
        pulumi.set(__self__, "peer_bgp_ip", peer_bgp_ip)
        pulumi.set(__self__, "tunnel_cidr", tunnel_cidr)

    @_builtins.property
    @pulumi.getter(name="bgpStatus")
    def bgp_status(self) -> _builtins.str:
        """
        BGP status.
        """
        return pulumi.get(self, "bgp_status")

    @_builtins.property
    @pulumi.getter(name="localAsn")
    def local_asn(self) -> _builtins.int:
        """
        The number of the local (Alibaba Cloud) autonomous system of the tunnel. The value range of the autonomous system number is **1** to **4294967295**. Default value: **45104**.> We recommend that you use the private number of the autonomous system number to establish a BGP connection with Alibaba Cloud. The private number range of the autonomous system number please consult the document yourself.
        """
        return pulumi.get(self, "local_asn")

    @_builtins.property
    @pulumi.getter(name="localBgpIp")
    def local_bgp_ip(self) -> _builtins.str:
        """
        The local BGP address of the tunnel (on the Alibaba Cloud side). This address is an IP address in the BGP network segment.
        """
        return pulumi.get(self, "local_bgp_ip")

    @_builtins.property
    @pulumi.getter(name="peerAsn")
    def peer_asn(self) -> _builtins.str:
        """
        Peer asn.
        """
        return pulumi.get(self, "peer_asn")

    @_builtins.property
    @pulumi.getter(name="peerBgpIp")
    def peer_bgp_ip(self) -> _builtins.str:
        """
        Peer bgp ip.
        """
        return pulumi.get(self, "peer_bgp_ip")

    @_builtins.property
    @pulumi.getter(name="tunnelCidr")
    def tunnel_cidr(self) -> _builtins.str:
        """
        The BGP network segment of the tunnel. The network segment must be a network segment with a mask length of 30 in 169.254.0.0/16, and cannot be 169.254.0.0/30, 169.254.1.0/30, 169.254.2.0/30, 169.254.3.0/30, 169.254.4.0/30, 169.254.5.0/30, 169.254.6.0/30, and 169.254.169.252/30.> the network segments of two tunnels under an IPsec connection cannot be the same.
        """
        return pulumi.get(self, "tunnel_cidr")


@pulumi.output_type
class GetGatewayVpnAttachmentsAttachmentTunnelOptionsSpecificationTunnelIkeConfigResult(dict):
    def __init__(__self__, *,
                 ike_auth_alg: _builtins.str,
                 ike_enc_alg: _builtins.str,
                 ike_lifetime: _builtins.int,
                 ike_mode: _builtins.str,
                 ike_pfs: _builtins.str,
                 ike_version: _builtins.str,
                 local_id: _builtins.str,
                 psk: _builtins.str,
                 remote_id: _builtins.str):
        """
        :param _builtins.str ike_auth_alg: The authentication algorithm negotiated in the first stage. Values: **md5**, **sha1**, **sha256**, **sha384**, **sha512**. Default value: **sha1**.
        :param _builtins.str ike_enc_alg: The encryption algorithm negotiated in the first stage. Value: **aes**, **aes192**, **aes256**, **des**, or **3des**. Default value: **aes**.
        :param _builtins.int ike_lifetime: The life cycle of SA negotiated in the first stage. Unit: seconds.Value range: **0** to **86400**. Default value: **86400**.
        :param _builtins.str ike_mode: IKE version of the negotiation mode. Value: **main** or **aggressive**. Default value: **main**.-**main**: main mode, high security during negotiation.-**aggressive**: Savage mode, fast negotiation and high negotiation success rate.
        :param _builtins.str ike_pfs: The first stage negotiates the Diffie-Hellman key exchange algorithm used. Default value: **group2**.Values: **group1**, **group2**, **group5**, **group14**.
        :param _builtins.str ike_version: Version of the IKE protocol. Value: **ikev1** or **ikev2**. Default value: **ikev2**.Compared with IKEv1, IKEv2 simplifies the SA negotiation process and provides better support for multiple network segments.
        :param _builtins.str local_id: The identifier of the local end of the tunnel (Alibaba Cloud side), which is used for the first phase of negotiation. The length is limited to 100 characters and cannot contain spaces. The default value is the IP address of the tunnel.**LocalId** supports the FQDN format. If you use the FQDN format, we recommend that you select **aggressive** (barbaric mode) as the negotiation mode.
        :param _builtins.str psk: The pre-shared key is used for identity authentication between the tunnel and the tunnel peer.-The key can be 1 to 100 characters in length. It supports numbers, upper and lower case English letters, and characters on the right. It cannot contain spaces. '''~! \\'@#$%^& *()_-+ ={}[]|;:',./? '''-If you do not specify a pre-shared key, the system randomly generates a 16-bit string as the pre-shared key. > The pre-shared key of the tunnel and the tunnel peer must be the same, otherwise the system cannot establish the tunnel normally.
        :param _builtins.str remote_id: Identifier of the tunnel peer, which is used for the first-stage negotiation. The length is limited to 100 characters and cannot contain spaces. The default value is the IP address of the user gateway associated with the tunnel.- **RemoteId** supports the FQDN format. If you use the FQDN format, we recommend that you select **aggressive** (barbaric mode) as the negotiation mode.
        """
        pulumi.set(__self__, "ike_auth_alg", ike_auth_alg)
        pulumi.set(__self__, "ike_enc_alg", ike_enc_alg)
        pulumi.set(__self__, "ike_lifetime", ike_lifetime)
        pulumi.set(__self__, "ike_mode", ike_mode)
        pulumi.set(__self__, "ike_pfs", ike_pfs)
        pulumi.set(__self__, "ike_version", ike_version)
        pulumi.set(__self__, "local_id", local_id)
        pulumi.set(__self__, "psk", psk)
        pulumi.set(__self__, "remote_id", remote_id)

    @_builtins.property
    @pulumi.getter(name="ikeAuthAlg")
    def ike_auth_alg(self) -> _builtins.str:
        """
        The authentication algorithm negotiated in the first stage. Values: **md5**, **sha1**, **sha256**, **sha384**, **sha512**. Default value: **sha1**.
        """
        return pulumi.get(self, "ike_auth_alg")

    @_builtins.property
    @pulumi.getter(name="ikeEncAlg")
    def ike_enc_alg(self) -> _builtins.str:
        """
        The encryption algorithm negotiated in the first stage. Value: **aes**, **aes192**, **aes256**, **des**, or **3des**. Default value: **aes**.
        """
        return pulumi.get(self, "ike_enc_alg")

    @_builtins.property
    @pulumi.getter(name="ikeLifetime")
    def ike_lifetime(self) -> _builtins.int:
        """
        The life cycle of SA negotiated in the first stage. Unit: seconds.Value range: **0** to **86400**. Default value: **86400**.
        """
        return pulumi.get(self, "ike_lifetime")

    @_builtins.property
    @pulumi.getter(name="ikeMode")
    def ike_mode(self) -> _builtins.str:
        """
        IKE version of the negotiation mode. Value: **main** or **aggressive**. Default value: **main**.-**main**: main mode, high security during negotiation.-**aggressive**: Savage mode, fast negotiation and high negotiation success rate.
        """
        return pulumi.get(self, "ike_mode")

    @_builtins.property
    @pulumi.getter(name="ikePfs")
    def ike_pfs(self) -> _builtins.str:
        """
        The first stage negotiates the Diffie-Hellman key exchange algorithm used. Default value: **group2**.Values: **group1**, **group2**, **group5**, **group14**.
        """
        return pulumi.get(self, "ike_pfs")

    @_builtins.property
    @pulumi.getter(name="ikeVersion")
    def ike_version(self) -> _builtins.str:
        """
        Version of the IKE protocol. Value: **ikev1** or **ikev2**. Default value: **ikev2**.Compared with IKEv1, IKEv2 simplifies the SA negotiation process and provides better support for multiple network segments.
        """
        return pulumi.get(self, "ike_version")

    @_builtins.property
    @pulumi.getter(name="localId")
    def local_id(self) -> _builtins.str:
        """
        The identifier of the local end of the tunnel (Alibaba Cloud side), which is used for the first phase of negotiation. The length is limited to 100 characters and cannot contain spaces. The default value is the IP address of the tunnel.**LocalId** supports the FQDN format. If you use the FQDN format, we recommend that you select **aggressive** (barbaric mode) as the negotiation mode.
        """
        return pulumi.get(self, "local_id")

    @_builtins.property
    @pulumi.getter
    def psk(self) -> _builtins.str:
        """
        The pre-shared key is used for identity authentication between the tunnel and the tunnel peer.-The key can be 1 to 100 characters in length. It supports numbers, upper and lower case English letters, and characters on the right. It cannot contain spaces. '''~! \\'@#$%^& *()_-+ ={}[]|;:',./? '''-If you do not specify a pre-shared key, the system randomly generates a 16-bit string as the pre-shared key. > The pre-shared key of the tunnel and the tunnel peer must be the same, otherwise the system cannot establish the tunnel normally.
        """
        return pulumi.get(self, "psk")

    @_builtins.property
    @pulumi.getter(name="remoteId")
    def remote_id(self) -> _builtins.str:
        """
        Identifier of the tunnel peer, which is used for the first-stage negotiation. The length is limited to 100 characters and cannot contain spaces. The default value is the IP address of the user gateway associated with the tunnel.- **RemoteId** supports the FQDN format. If you use the FQDN format, we recommend that you select **aggressive** (barbaric mode) as the negotiation mode.
        """
        return pulumi.get(self, "remote_id")


@pulumi.output_type
class GetGatewayVpnAttachmentsAttachmentTunnelOptionsSpecificationTunnelIpsecConfigResult(dict):
    def __init__(__self__, *,
                 ipsec_auth_alg: _builtins.str,
                 ipsec_enc_alg: _builtins.str,
                 ipsec_lifetime: _builtins.int,
                 ipsec_pfs: _builtins.str):
        """
        :param _builtins.str ipsec_auth_alg: The second stage negotiated authentication algorithm.Values: **md5**, **sha1**, **sha256**, **sha384**, **sha512**. Default value: **sha1**.
        :param _builtins.str ipsec_enc_alg: The encryption algorithm negotiated in the second stage. Value: **aes**, **aes192**, **aes256**, **des**, or **3des**. Default value: **aes**.
        :param _builtins.int ipsec_lifetime: The life cycle of SA negotiated in the second stage. Unit: seconds.Value range: **0** to **86400**. Default value: **86400**.
        :param _builtins.str ipsec_pfs: The second stage negotiates the Diffie-Hellman key exchange algorithm used. Default value: **group2**.Values: **disabled**, **group1**, **group2**, **group5**, **group14**.
        """
        pulumi.set(__self__, "ipsec_auth_alg", ipsec_auth_alg)
        pulumi.set(__self__, "ipsec_enc_alg", ipsec_enc_alg)
        pulumi.set(__self__, "ipsec_lifetime", ipsec_lifetime)
        pulumi.set(__self__, "ipsec_pfs", ipsec_pfs)

    @_builtins.property
    @pulumi.getter(name="ipsecAuthAlg")
    def ipsec_auth_alg(self) -> _builtins.str:
        """
        The second stage negotiated authentication algorithm.Values: **md5**, **sha1**, **sha256**, **sha384**, **sha512**. Default value: **sha1**.
        """
        return pulumi.get(self, "ipsec_auth_alg")

    @_builtins.property
    @pulumi.getter(name="ipsecEncAlg")
    def ipsec_enc_alg(self) -> _builtins.str:
        """
        The encryption algorithm negotiated in the second stage. Value: **aes**, **aes192**, **aes256**, **des**, or **3des**. Default value: **aes**.
        """
        return pulumi.get(self, "ipsec_enc_alg")

    @_builtins.property
    @pulumi.getter(name="ipsecLifetime")
    def ipsec_lifetime(self) -> _builtins.int:
        """
        The life cycle of SA negotiated in the second stage. Unit: seconds.Value range: **0** to **86400**. Default value: **86400**.
        """
        return pulumi.get(self, "ipsec_lifetime")

    @_builtins.property
    @pulumi.getter(name="ipsecPfs")
    def ipsec_pfs(self) -> _builtins.str:
        """
        The second stage negotiates the Diffie-Hellman key exchange algorithm used. Default value: **group2**.Values: **disabled**, **group1**, **group2**, **group5**, **group14**.
        """
        return pulumi.get(self, "ipsec_pfs")


@pulumi.output_type
class GetGatewayZonesZoneResult(dict):
    def __init__(__self__, *,
                 zone_id: _builtins.str,
                 zone_name: _builtins.str):
        """
        :param _builtins.str zone_id: The zone ID.
        :param _builtins.str zone_name: The zone name.
        """
        pulumi.set(__self__, "zone_id", zone_id)
        pulumi.set(__self__, "zone_name", zone_name)

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> _builtins.str:
        """
        The zone ID.
        """
        return pulumi.get(self, "zone_id")

    @_builtins.property
    @pulumi.getter(name="zoneName")
    def zone_name(self) -> _builtins.str:
        """
        The zone name.
        """
        return pulumi.get(self, "zone_name")


@pulumi.output_type
class GetGatewaysGatewayResult(dict):
    def __init__(__self__, *,
                 auto_propagate: _builtins.str,
                 business_status: _builtins.str,
                 create_time: _builtins.str,
                 description: _builtins.str,
                 disaster_recovery_internet_ip: _builtins.str,
                 disaster_recovery_vswitch_id: _builtins.str,
                 enable_ipsec: _builtins.str,
                 enable_ssl: _builtins.str,
                 end_time: _builtins.str,
                 id: _builtins.str,
                 instance_charge_type: _builtins.str,
                 internet_ip: _builtins.str,
                 name: _builtins.str,
                 network_type: _builtins.str,
                 resource_group_id: _builtins.str,
                 specification: _builtins.str,
                 ssl_connections: _builtins.int,
                 ssl_vpn: _builtins.str,
                 ssl_vpn_internet_ip: _builtins.str,
                 status: _builtins.str,
                 tags: Mapping[str, _builtins.str],
                 vpc_id: _builtins.str,
                 vpn_type: _builtins.str,
                 vswitch_id: _builtins.str):
        """
        :param _builtins.str auto_propagate: Whether to automatically propagate BGP routes to the VPC. Valid values: `true`, `false`.
        :param _builtins.str business_status: Limit search to specific business status - valid value is "Normal", "FinancialLocked".
        :param _builtins.str create_time: The creation time of the VPN gateway.
        :param _builtins.str description: The description of the VPN
        :param _builtins.str disaster_recovery_internet_ip: The backup public IP address of the VPN gateway. The second IP address assigned by the system to create an IPsec-VPN connection. This parameter is returned only when the VPN gateway supports the dual-tunnel mode.
        :param _builtins.str disaster_recovery_vswitch_id: - The ID of the backup vSwitch to which the VPN gateway is attached.
        :param _builtins.str enable_ipsec: Indicates whether the IPsec-VPN feature is enabled.
        :param _builtins.str enable_ssl: Whether the ssl function is enabled. It has been deprecated from provider version 1.243.0, and using `ssl_vpn` instead.
        :param _builtins.str end_time: The expiration time of the VPN gateway.
        :param _builtins.str id: ID of the VPN.
        :param _builtins.str instance_charge_type: The charge type of the VPN gateway.
        :param _builtins.str internet_ip: The internet ip of the VPN.
        :param _builtins.str name: The name of the VPN.
        :param _builtins.str network_type: The network type of the VPN gateway.
        :param _builtins.str resource_group_id: The ID of the resource group.
        :param _builtins.str specification: The Specification of the VPN
        :param _builtins.int ssl_connections: Total count of ssl vpn connections.
        :param _builtins.str ssl_vpn: Indicates whether the SSL-VPN feature is enabled. Valid value is `enable`, `disable`.
        :param _builtins.str ssl_vpn_internet_ip: The IP address of the SSL-VPN connection. This parameter is returned only when the VPN gateway is a public VPN gateway and supports only the single-tunnel mode. In addition, the VPN gateway must have the SSL-VPN feature enabled.
        :param _builtins.str status: Limit search to specific status - valid value is "Init", "Provisioning", "Active", "Updating", "Deleting".
        :param Mapping[str, _builtins.str] tags: The Tag of.
        :param _builtins.str vpc_id: Use the VPC ID as the search key.
        :param _builtins.str vpn_type: - The VPN gateway type. Value:  Normal (default): Normal type. NationalStandard: National Secret type.
        :param _builtins.str vswitch_id: - The ID of the vSwitch to which the VPN gateway is attached.
        """
        pulumi.set(__self__, "auto_propagate", auto_propagate)
        pulumi.set(__self__, "business_status", business_status)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "disaster_recovery_internet_ip", disaster_recovery_internet_ip)
        pulumi.set(__self__, "disaster_recovery_vswitch_id", disaster_recovery_vswitch_id)
        pulumi.set(__self__, "enable_ipsec", enable_ipsec)
        pulumi.set(__self__, "enable_ssl", enable_ssl)
        pulumi.set(__self__, "end_time", end_time)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "instance_charge_type", instance_charge_type)
        pulumi.set(__self__, "internet_ip", internet_ip)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "network_type", network_type)
        pulumi.set(__self__, "resource_group_id", resource_group_id)
        pulumi.set(__self__, "specification", specification)
        pulumi.set(__self__, "ssl_connections", ssl_connections)
        pulumi.set(__self__, "ssl_vpn", ssl_vpn)
        pulumi.set(__self__, "ssl_vpn_internet_ip", ssl_vpn_internet_ip)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "vpc_id", vpc_id)
        pulumi.set(__self__, "vpn_type", vpn_type)
        pulumi.set(__self__, "vswitch_id", vswitch_id)

    @_builtins.property
    @pulumi.getter(name="autoPropagate")
    def auto_propagate(self) -> _builtins.str:
        """
        Whether to automatically propagate BGP routes to the VPC. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "auto_propagate")

    @_builtins.property
    @pulumi.getter(name="businessStatus")
    def business_status(self) -> _builtins.str:
        """
        Limit search to specific business status - valid value is "Normal", "FinancialLocked".
        """
        return pulumi.get(self, "business_status")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        """
        The creation time of the VPN gateway.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the VPN
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="disasterRecoveryInternetIp")
    def disaster_recovery_internet_ip(self) -> _builtins.str:
        """
        The backup public IP address of the VPN gateway. The second IP address assigned by the system to create an IPsec-VPN connection. This parameter is returned only when the VPN gateway supports the dual-tunnel mode.
        """
        return pulumi.get(self, "disaster_recovery_internet_ip")

    @_builtins.property
    @pulumi.getter(name="disasterRecoveryVswitchId")
    def disaster_recovery_vswitch_id(self) -> _builtins.str:
        """
        - The ID of the backup vSwitch to which the VPN gateway is attached.
        """
        return pulumi.get(self, "disaster_recovery_vswitch_id")

    @_builtins.property
    @pulumi.getter(name="enableIpsec")
    def enable_ipsec(self) -> _builtins.str:
        """
        Indicates whether the IPsec-VPN feature is enabled.
        """
        return pulumi.get(self, "enable_ipsec")

    @_builtins.property
    @pulumi.getter(name="enableSsl")
    def enable_ssl(self) -> _builtins.str:
        """
        Whether the ssl function is enabled. It has been deprecated from provider version 1.243.0, and using `ssl_vpn` instead.
        """
        return pulumi.get(self, "enable_ssl")

    @_builtins.property
    @pulumi.getter(name="endTime")
    def end_time(self) -> _builtins.str:
        """
        The expiration time of the VPN gateway.
        """
        return pulumi.get(self, "end_time")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        ID of the VPN.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="instanceChargeType")
    def instance_charge_type(self) -> _builtins.str:
        """
        The charge type of the VPN gateway.
        """
        return pulumi.get(self, "instance_charge_type")

    @_builtins.property
    @pulumi.getter(name="internetIp")
    def internet_ip(self) -> _builtins.str:
        """
        The internet ip of the VPN.
        """
        return pulumi.get(self, "internet_ip")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the VPN.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="networkType")
    def network_type(self) -> _builtins.str:
        """
        The network type of the VPN gateway.
        """
        return pulumi.get(self, "network_type")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> _builtins.str:
        """
        The ID of the resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter
    def specification(self) -> _builtins.str:
        """
        The Specification of the VPN
        """
        return pulumi.get(self, "specification")

    @_builtins.property
    @pulumi.getter(name="sslConnections")
    def ssl_connections(self) -> _builtins.int:
        """
        Total count of ssl vpn connections.
        """
        return pulumi.get(self, "ssl_connections")

    @_builtins.property
    @pulumi.getter(name="sslVpn")
    def ssl_vpn(self) -> _builtins.str:
        """
        Indicates whether the SSL-VPN feature is enabled. Valid value is `enable`, `disable`.
        """
        return pulumi.get(self, "ssl_vpn")

    @_builtins.property
    @pulumi.getter(name="sslVpnInternetIp")
    def ssl_vpn_internet_ip(self) -> _builtins.str:
        """
        The IP address of the SSL-VPN connection. This parameter is returned only when the VPN gateway is a public VPN gateway and supports only the single-tunnel mode. In addition, the VPN gateway must have the SSL-VPN feature enabled.
        """
        return pulumi.get(self, "ssl_vpn_internet_ip")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Limit search to specific status - valid value is "Init", "Provisioning", "Active", "Updating", "Deleting".
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        The Tag of.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> _builtins.str:
        """
        Use the VPC ID as the search key.
        """
        return pulumi.get(self, "vpc_id")

    @_builtins.property
    @pulumi.getter(name="vpnType")
    def vpn_type(self) -> _builtins.str:
        """
        - The VPN gateway type. Value:  Normal (default): Normal type. NationalStandard: National Secret type.
        """
        return pulumi.get(self, "vpn_type")

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> _builtins.str:
        """
        - The ID of the vSwitch to which the VPN gateway is attached.
        """
        return pulumi.get(self, "vswitch_id")


