# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['InstanceArgs', 'Instance']

@pulumi.input_type
class InstanceArgs:
    def __init__(__self__, *,
                 big_screen: pulumi.Input[_builtins.str],
                 exclusive_ip_package: pulumi.Input[_builtins.str],
                 ext_bandwidth: pulumi.Input[_builtins.str],
                 ext_domain_package: pulumi.Input[_builtins.str],
                 log_storage: pulumi.Input[_builtins.str],
                 log_time: pulumi.Input[_builtins.str],
                 package_code: pulumi.Input[_builtins.str],
                 prefessional_service: pulumi.Input[_builtins.str],
                 subscription_type: pulumi.Input[_builtins.str],
                 waf_log: pulumi.Input[_builtins.str],
                 modify_type: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 renew_period: Optional[pulumi.Input[_builtins.int]] = None,
                 renewal_status: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Instance resource.
        :param pulumi.Input[_builtins.str] big_screen: Specify whether big screen is supported. Valid values: ["0", "1"]. "0" for false and "1" for true.
        :param pulumi.Input[_builtins.str] exclusive_ip_package: Specify the number of exclusive WAF IP addresses.
        :param pulumi.Input[_builtins.str] ext_bandwidth: The extra bandwidth. Unit: Mbit/s.
        :param pulumi.Input[_builtins.str] ext_domain_package: The number of extra domains.
        :param pulumi.Input[_builtins.str] log_storage: Log storage size. Unit: T. Valid values: [3, 5, 10, 20, 50].
        :param pulumi.Input[_builtins.str] log_time: Log storage period. Unit: day. Valid values: [180, 360].
        :param pulumi.Input[_builtins.str] package_code: Subscription plan:
               * China site customers can purchase the following versions of China Mainland region, valid values: ["version_3", "version_4", "version_5"].
               * China site customers can purchase the following versions of International region, valid values: ["version_pro_asia", "version_business_asia", "version_enterprise_asia"]
               * International site customers can purchase the following versions of China Mainland region: ["version_pro_china", "version_business_china", "version_enterprise_china"]
               * International site customers can purchase the following versions of International region: ["version_pro", "version_business", "version_enterprise"].
        :param pulumi.Input[_builtins.str] prefessional_service: Specify whether professional service is supported. Valid values: ["true", "false"]
        :param pulumi.Input[_builtins.str] subscription_type: Subscription of WAF service. Valid values: ["Subscription", "PayAsYouGo"].
        :param pulumi.Input[_builtins.str] waf_log: Specify whether Log service is supported. Valid values: ["true", "false"]
        :param pulumi.Input[_builtins.str] modify_type: Type of configuration change. Valid value: Upgrade.
        :param pulumi.Input[_builtins.int] period: Service time of Web Application Firewall.
        :param pulumi.Input[_builtins.str] region: The instance region ID.
        :param pulumi.Input[_builtins.int] renew_period: Renewal period of WAF service. Unit: month
        :param pulumi.Input[_builtins.str] renewal_status: Renewal status of WAF service. Valid values: 
               * AutoRenewal: The service time of WAF is renewed automatically.
               * ManualRenewal (default): The service time of WAF is renewed manually.Specifies whether to configure a Layer-7 proxy, such as Anti-DDoS Pro or CDN, to filter the inbound traffic before it is forwarded to WAF. Valid values: "On" and "Off". Default to "Off".
        :param pulumi.Input[_builtins.str] resource_group_id: The resource group ID.
        """
        pulumi.set(__self__, "big_screen", big_screen)
        pulumi.set(__self__, "exclusive_ip_package", exclusive_ip_package)
        pulumi.set(__self__, "ext_bandwidth", ext_bandwidth)
        pulumi.set(__self__, "ext_domain_package", ext_domain_package)
        pulumi.set(__self__, "log_storage", log_storage)
        pulumi.set(__self__, "log_time", log_time)
        pulumi.set(__self__, "package_code", package_code)
        pulumi.set(__self__, "prefessional_service", prefessional_service)
        pulumi.set(__self__, "subscription_type", subscription_type)
        pulumi.set(__self__, "waf_log", waf_log)
        if modify_type is not None:
            pulumi.set(__self__, "modify_type", modify_type)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if renew_period is not None:
            pulumi.set(__self__, "renew_period", renew_period)
        if renewal_status is not None:
            pulumi.set(__self__, "renewal_status", renewal_status)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)

    @_builtins.property
    @pulumi.getter(name="bigScreen")
    def big_screen(self) -> pulumi.Input[_builtins.str]:
        """
        Specify whether big screen is supported. Valid values: ["0", "1"]. "0" for false and "1" for true.
        """
        return pulumi.get(self, "big_screen")

    @big_screen.setter
    def big_screen(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "big_screen", value)

    @_builtins.property
    @pulumi.getter(name="exclusiveIpPackage")
    def exclusive_ip_package(self) -> pulumi.Input[_builtins.str]:
        """
        Specify the number of exclusive WAF IP addresses.
        """
        return pulumi.get(self, "exclusive_ip_package")

    @exclusive_ip_package.setter
    def exclusive_ip_package(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "exclusive_ip_package", value)

    @_builtins.property
    @pulumi.getter(name="extBandwidth")
    def ext_bandwidth(self) -> pulumi.Input[_builtins.str]:
        """
        The extra bandwidth. Unit: Mbit/s.
        """
        return pulumi.get(self, "ext_bandwidth")

    @ext_bandwidth.setter
    def ext_bandwidth(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "ext_bandwidth", value)

    @_builtins.property
    @pulumi.getter(name="extDomainPackage")
    def ext_domain_package(self) -> pulumi.Input[_builtins.str]:
        """
        The number of extra domains.
        """
        return pulumi.get(self, "ext_domain_package")

    @ext_domain_package.setter
    def ext_domain_package(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "ext_domain_package", value)

    @_builtins.property
    @pulumi.getter(name="logStorage")
    def log_storage(self) -> pulumi.Input[_builtins.str]:
        """
        Log storage size. Unit: T. Valid values: [3, 5, 10, 20, 50].
        """
        return pulumi.get(self, "log_storage")

    @log_storage.setter
    def log_storage(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "log_storage", value)

    @_builtins.property
    @pulumi.getter(name="logTime")
    def log_time(self) -> pulumi.Input[_builtins.str]:
        """
        Log storage period. Unit: day. Valid values: [180, 360].
        """
        return pulumi.get(self, "log_time")

    @log_time.setter
    def log_time(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "log_time", value)

    @_builtins.property
    @pulumi.getter(name="packageCode")
    def package_code(self) -> pulumi.Input[_builtins.str]:
        """
        Subscription plan:
        * China site customers can purchase the following versions of China Mainland region, valid values: ["version_3", "version_4", "version_5"].
        * China site customers can purchase the following versions of International region, valid values: ["version_pro_asia", "version_business_asia", "version_enterprise_asia"]
        * International site customers can purchase the following versions of China Mainland region: ["version_pro_china", "version_business_china", "version_enterprise_china"]
        * International site customers can purchase the following versions of International region: ["version_pro", "version_business", "version_enterprise"].
        """
        return pulumi.get(self, "package_code")

    @package_code.setter
    def package_code(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "package_code", value)

    @_builtins.property
    @pulumi.getter(name="prefessionalService")
    def prefessional_service(self) -> pulumi.Input[_builtins.str]:
        """
        Specify whether professional service is supported. Valid values: ["true", "false"]
        """
        return pulumi.get(self, "prefessional_service")

    @prefessional_service.setter
    def prefessional_service(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "prefessional_service", value)

    @_builtins.property
    @pulumi.getter(name="subscriptionType")
    def subscription_type(self) -> pulumi.Input[_builtins.str]:
        """
        Subscription of WAF service. Valid values: ["Subscription", "PayAsYouGo"].
        """
        return pulumi.get(self, "subscription_type")

    @subscription_type.setter
    def subscription_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "subscription_type", value)

    @_builtins.property
    @pulumi.getter(name="wafLog")
    def waf_log(self) -> pulumi.Input[_builtins.str]:
        """
        Specify whether Log service is supported. Valid values: ["true", "false"]
        """
        return pulumi.get(self, "waf_log")

    @waf_log.setter
    def waf_log(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "waf_log", value)

    @_builtins.property
    @pulumi.getter(name="modifyType")
    def modify_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of configuration change. Valid value: Upgrade.
        """
        return pulumi.get(self, "modify_type")

    @modify_type.setter
    def modify_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "modify_type", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Service time of Web Application Firewall.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The instance region ID.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="renewPeriod")
    def renew_period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Renewal period of WAF service. Unit: month
        """
        return pulumi.get(self, "renew_period")

    @renew_period.setter
    def renew_period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "renew_period", value)

    @_builtins.property
    @pulumi.getter(name="renewalStatus")
    def renewal_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Renewal status of WAF service. Valid values: 
        * AutoRenewal: The service time of WAF is renewed automatically.
        * ManualRenewal (default): The service time of WAF is renewed manually.Specifies whether to configure a Layer-7 proxy, such as Anti-DDoS Pro or CDN, to filter the inbound traffic before it is forwarded to WAF. Valid values: "On" and "Off". Default to "Off".
        """
        return pulumi.get(self, "renewal_status")

    @renewal_status.setter
    def renewal_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "renewal_status", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource group ID.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)


@pulumi.input_type
class _InstanceState:
    def __init__(__self__, *,
                 big_screen: Optional[pulumi.Input[_builtins.str]] = None,
                 exclusive_ip_package: Optional[pulumi.Input[_builtins.str]] = None,
                 ext_bandwidth: Optional[pulumi.Input[_builtins.str]] = None,
                 ext_domain_package: Optional[pulumi.Input[_builtins.str]] = None,
                 log_storage: Optional[pulumi.Input[_builtins.str]] = None,
                 log_time: Optional[pulumi.Input[_builtins.str]] = None,
                 modify_type: Optional[pulumi.Input[_builtins.str]] = None,
                 package_code: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 prefessional_service: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 renew_period: Optional[pulumi.Input[_builtins.int]] = None,
                 renewal_status: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.int]] = None,
                 subscription_type: Optional[pulumi.Input[_builtins.str]] = None,
                 waf_log: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Instance resources.
        :param pulumi.Input[_builtins.str] big_screen: Specify whether big screen is supported. Valid values: ["0", "1"]. "0" for false and "1" for true.
        :param pulumi.Input[_builtins.str] exclusive_ip_package: Specify the number of exclusive WAF IP addresses.
        :param pulumi.Input[_builtins.str] ext_bandwidth: The extra bandwidth. Unit: Mbit/s.
        :param pulumi.Input[_builtins.str] ext_domain_package: The number of extra domains.
        :param pulumi.Input[_builtins.str] log_storage: Log storage size. Unit: T. Valid values: [3, 5, 10, 20, 50].
        :param pulumi.Input[_builtins.str] log_time: Log storage period. Unit: day. Valid values: [180, 360].
        :param pulumi.Input[_builtins.str] modify_type: Type of configuration change. Valid value: Upgrade.
        :param pulumi.Input[_builtins.str] package_code: Subscription plan:
               * China site customers can purchase the following versions of China Mainland region, valid values: ["version_3", "version_4", "version_5"].
               * China site customers can purchase the following versions of International region, valid values: ["version_pro_asia", "version_business_asia", "version_enterprise_asia"]
               * International site customers can purchase the following versions of China Mainland region: ["version_pro_china", "version_business_china", "version_enterprise_china"]
               * International site customers can purchase the following versions of International region: ["version_pro", "version_business", "version_enterprise"].
        :param pulumi.Input[_builtins.int] period: Service time of Web Application Firewall.
        :param pulumi.Input[_builtins.str] prefessional_service: Specify whether professional service is supported. Valid values: ["true", "false"]
        :param pulumi.Input[_builtins.str] region: The instance region ID.
        :param pulumi.Input[_builtins.int] renew_period: Renewal period of WAF service. Unit: month
        :param pulumi.Input[_builtins.str] renewal_status: Renewal status of WAF service. Valid values: 
               * AutoRenewal: The service time of WAF is renewed automatically.
               * ManualRenewal (default): The service time of WAF is renewed manually.Specifies whether to configure a Layer-7 proxy, such as Anti-DDoS Pro or CDN, to filter the inbound traffic before it is forwarded to WAF. Valid values: "On" and "Off". Default to "Off".
        :param pulumi.Input[_builtins.str] resource_group_id: The resource group ID.
        :param pulumi.Input[_builtins.int] status: The status of the instance.
        :param pulumi.Input[_builtins.str] subscription_type: Subscription of WAF service. Valid values: ["Subscription", "PayAsYouGo"].
        :param pulumi.Input[_builtins.str] waf_log: Specify whether Log service is supported. Valid values: ["true", "false"]
        """
        if big_screen is not None:
            pulumi.set(__self__, "big_screen", big_screen)
        if exclusive_ip_package is not None:
            pulumi.set(__self__, "exclusive_ip_package", exclusive_ip_package)
        if ext_bandwidth is not None:
            pulumi.set(__self__, "ext_bandwidth", ext_bandwidth)
        if ext_domain_package is not None:
            pulumi.set(__self__, "ext_domain_package", ext_domain_package)
        if log_storage is not None:
            pulumi.set(__self__, "log_storage", log_storage)
        if log_time is not None:
            pulumi.set(__self__, "log_time", log_time)
        if modify_type is not None:
            pulumi.set(__self__, "modify_type", modify_type)
        if package_code is not None:
            pulumi.set(__self__, "package_code", package_code)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if prefessional_service is not None:
            pulumi.set(__self__, "prefessional_service", prefessional_service)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if renew_period is not None:
            pulumi.set(__self__, "renew_period", renew_period)
        if renewal_status is not None:
            pulumi.set(__self__, "renewal_status", renewal_status)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if subscription_type is not None:
            pulumi.set(__self__, "subscription_type", subscription_type)
        if waf_log is not None:
            pulumi.set(__self__, "waf_log", waf_log)

    @_builtins.property
    @pulumi.getter(name="bigScreen")
    def big_screen(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specify whether big screen is supported. Valid values: ["0", "1"]. "0" for false and "1" for true.
        """
        return pulumi.get(self, "big_screen")

    @big_screen.setter
    def big_screen(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "big_screen", value)

    @_builtins.property
    @pulumi.getter(name="exclusiveIpPackage")
    def exclusive_ip_package(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specify the number of exclusive WAF IP addresses.
        """
        return pulumi.get(self, "exclusive_ip_package")

    @exclusive_ip_package.setter
    def exclusive_ip_package(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "exclusive_ip_package", value)

    @_builtins.property
    @pulumi.getter(name="extBandwidth")
    def ext_bandwidth(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The extra bandwidth. Unit: Mbit/s.
        """
        return pulumi.get(self, "ext_bandwidth")

    @ext_bandwidth.setter
    def ext_bandwidth(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ext_bandwidth", value)

    @_builtins.property
    @pulumi.getter(name="extDomainPackage")
    def ext_domain_package(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The number of extra domains.
        """
        return pulumi.get(self, "ext_domain_package")

    @ext_domain_package.setter
    def ext_domain_package(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ext_domain_package", value)

    @_builtins.property
    @pulumi.getter(name="logStorage")
    def log_storage(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Log storage size. Unit: T. Valid values: [3, 5, 10, 20, 50].
        """
        return pulumi.get(self, "log_storage")

    @log_storage.setter
    def log_storage(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "log_storage", value)

    @_builtins.property
    @pulumi.getter(name="logTime")
    def log_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Log storage period. Unit: day. Valid values: [180, 360].
        """
        return pulumi.get(self, "log_time")

    @log_time.setter
    def log_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "log_time", value)

    @_builtins.property
    @pulumi.getter(name="modifyType")
    def modify_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of configuration change. Valid value: Upgrade.
        """
        return pulumi.get(self, "modify_type")

    @modify_type.setter
    def modify_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "modify_type", value)

    @_builtins.property
    @pulumi.getter(name="packageCode")
    def package_code(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Subscription plan:
        * China site customers can purchase the following versions of China Mainland region, valid values: ["version_3", "version_4", "version_5"].
        * China site customers can purchase the following versions of International region, valid values: ["version_pro_asia", "version_business_asia", "version_enterprise_asia"]
        * International site customers can purchase the following versions of China Mainland region: ["version_pro_china", "version_business_china", "version_enterprise_china"]
        * International site customers can purchase the following versions of International region: ["version_pro", "version_business", "version_enterprise"].
        """
        return pulumi.get(self, "package_code")

    @package_code.setter
    def package_code(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "package_code", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Service time of Web Application Firewall.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter(name="prefessionalService")
    def prefessional_service(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specify whether professional service is supported. Valid values: ["true", "false"]
        """
        return pulumi.get(self, "prefessional_service")

    @prefessional_service.setter
    def prefessional_service(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "prefessional_service", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The instance region ID.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="renewPeriod")
    def renew_period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Renewal period of WAF service. Unit: month
        """
        return pulumi.get(self, "renew_period")

    @renew_period.setter
    def renew_period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "renew_period", value)

    @_builtins.property
    @pulumi.getter(name="renewalStatus")
    def renewal_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Renewal status of WAF service. Valid values: 
        * AutoRenewal: The service time of WAF is renewed automatically.
        * ManualRenewal (default): The service time of WAF is renewed manually.Specifies whether to configure a Layer-7 proxy, such as Anti-DDoS Pro or CDN, to filter the inbound traffic before it is forwarded to WAF. Valid values: "On" and "Off". Default to "Off".
        """
        return pulumi.get(self, "renewal_status")

    @renewal_status.setter
    def renewal_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "renewal_status", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource group ID.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The status of the instance.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="subscriptionType")
    def subscription_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Subscription of WAF service. Valid values: ["Subscription", "PayAsYouGo"].
        """
        return pulumi.get(self, "subscription_type")

    @subscription_type.setter
    def subscription_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subscription_type", value)

    @_builtins.property
    @pulumi.getter(name="wafLog")
    def waf_log(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specify whether Log service is supported. Valid values: ["true", "false"]
        """
        return pulumi.get(self, "waf_log")

    @waf_log.setter
    def waf_log(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "waf_log", value)


@pulumi.type_token("alicloud:waf/instance:Instance")
class Instance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 big_screen: Optional[pulumi.Input[_builtins.str]] = None,
                 exclusive_ip_package: Optional[pulumi.Input[_builtins.str]] = None,
                 ext_bandwidth: Optional[pulumi.Input[_builtins.str]] = None,
                 ext_domain_package: Optional[pulumi.Input[_builtins.str]] = None,
                 log_storage: Optional[pulumi.Input[_builtins.str]] = None,
                 log_time: Optional[pulumi.Input[_builtins.str]] = None,
                 modify_type: Optional[pulumi.Input[_builtins.str]] = None,
                 package_code: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 prefessional_service: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 renew_period: Optional[pulumi.Input[_builtins.int]] = None,
                 renewal_status: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 subscription_type: Optional[pulumi.Input[_builtins.str]] = None,
                 waf_log: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Import

        WAF instance can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:waf/instance:Instance default waf-cn-132435
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] big_screen: Specify whether big screen is supported. Valid values: ["0", "1"]. "0" for false and "1" for true.
        :param pulumi.Input[_builtins.str] exclusive_ip_package: Specify the number of exclusive WAF IP addresses.
        :param pulumi.Input[_builtins.str] ext_bandwidth: The extra bandwidth. Unit: Mbit/s.
        :param pulumi.Input[_builtins.str] ext_domain_package: The number of extra domains.
        :param pulumi.Input[_builtins.str] log_storage: Log storage size. Unit: T. Valid values: [3, 5, 10, 20, 50].
        :param pulumi.Input[_builtins.str] log_time: Log storage period. Unit: day. Valid values: [180, 360].
        :param pulumi.Input[_builtins.str] modify_type: Type of configuration change. Valid value: Upgrade.
        :param pulumi.Input[_builtins.str] package_code: Subscription plan:
               * China site customers can purchase the following versions of China Mainland region, valid values: ["version_3", "version_4", "version_5"].
               * China site customers can purchase the following versions of International region, valid values: ["version_pro_asia", "version_business_asia", "version_enterprise_asia"]
               * International site customers can purchase the following versions of China Mainland region: ["version_pro_china", "version_business_china", "version_enterprise_china"]
               * International site customers can purchase the following versions of International region: ["version_pro", "version_business", "version_enterprise"].
        :param pulumi.Input[_builtins.int] period: Service time of Web Application Firewall.
        :param pulumi.Input[_builtins.str] prefessional_service: Specify whether professional service is supported. Valid values: ["true", "false"]
        :param pulumi.Input[_builtins.str] region: The instance region ID.
        :param pulumi.Input[_builtins.int] renew_period: Renewal period of WAF service. Unit: month
        :param pulumi.Input[_builtins.str] renewal_status: Renewal status of WAF service. Valid values: 
               * AutoRenewal: The service time of WAF is renewed automatically.
               * ManualRenewal (default): The service time of WAF is renewed manually.Specifies whether to configure a Layer-7 proxy, such as Anti-DDoS Pro or CDN, to filter the inbound traffic before it is forwarded to WAF. Valid values: "On" and "Off". Default to "Off".
        :param pulumi.Input[_builtins.str] resource_group_id: The resource group ID.
        :param pulumi.Input[_builtins.str] subscription_type: Subscription of WAF service. Valid values: ["Subscription", "PayAsYouGo"].
        :param pulumi.Input[_builtins.str] waf_log: Specify whether Log service is supported. Valid values: ["true", "false"]
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        WAF instance can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:waf/instance:Instance default waf-cn-132435
        ```

        :param str resource_name: The name of the resource.
        :param InstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 big_screen: Optional[pulumi.Input[_builtins.str]] = None,
                 exclusive_ip_package: Optional[pulumi.Input[_builtins.str]] = None,
                 ext_bandwidth: Optional[pulumi.Input[_builtins.str]] = None,
                 ext_domain_package: Optional[pulumi.Input[_builtins.str]] = None,
                 log_storage: Optional[pulumi.Input[_builtins.str]] = None,
                 log_time: Optional[pulumi.Input[_builtins.str]] = None,
                 modify_type: Optional[pulumi.Input[_builtins.str]] = None,
                 package_code: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 prefessional_service: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 renew_period: Optional[pulumi.Input[_builtins.int]] = None,
                 renewal_status: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 subscription_type: Optional[pulumi.Input[_builtins.str]] = None,
                 waf_log: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InstanceArgs.__new__(InstanceArgs)

            if big_screen is None and not opts.urn:
                raise TypeError("Missing required property 'big_screen'")
            __props__.__dict__["big_screen"] = big_screen
            if exclusive_ip_package is None and not opts.urn:
                raise TypeError("Missing required property 'exclusive_ip_package'")
            __props__.__dict__["exclusive_ip_package"] = exclusive_ip_package
            if ext_bandwidth is None and not opts.urn:
                raise TypeError("Missing required property 'ext_bandwidth'")
            __props__.__dict__["ext_bandwidth"] = ext_bandwidth
            if ext_domain_package is None and not opts.urn:
                raise TypeError("Missing required property 'ext_domain_package'")
            __props__.__dict__["ext_domain_package"] = ext_domain_package
            if log_storage is None and not opts.urn:
                raise TypeError("Missing required property 'log_storage'")
            __props__.__dict__["log_storage"] = log_storage
            if log_time is None and not opts.urn:
                raise TypeError("Missing required property 'log_time'")
            __props__.__dict__["log_time"] = log_time
            __props__.__dict__["modify_type"] = modify_type
            if package_code is None and not opts.urn:
                raise TypeError("Missing required property 'package_code'")
            __props__.__dict__["package_code"] = package_code
            __props__.__dict__["period"] = period
            if prefessional_service is None and not opts.urn:
                raise TypeError("Missing required property 'prefessional_service'")
            __props__.__dict__["prefessional_service"] = prefessional_service
            __props__.__dict__["region"] = region
            __props__.__dict__["renew_period"] = renew_period
            __props__.__dict__["renewal_status"] = renewal_status
            __props__.__dict__["resource_group_id"] = resource_group_id
            if subscription_type is None and not opts.urn:
                raise TypeError("Missing required property 'subscription_type'")
            __props__.__dict__["subscription_type"] = subscription_type
            if waf_log is None and not opts.urn:
                raise TypeError("Missing required property 'waf_log'")
            __props__.__dict__["waf_log"] = waf_log
            __props__.__dict__["status"] = None
        super(Instance, __self__).__init__(
            'alicloud:waf/instance:Instance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            big_screen: Optional[pulumi.Input[_builtins.str]] = None,
            exclusive_ip_package: Optional[pulumi.Input[_builtins.str]] = None,
            ext_bandwidth: Optional[pulumi.Input[_builtins.str]] = None,
            ext_domain_package: Optional[pulumi.Input[_builtins.str]] = None,
            log_storage: Optional[pulumi.Input[_builtins.str]] = None,
            log_time: Optional[pulumi.Input[_builtins.str]] = None,
            modify_type: Optional[pulumi.Input[_builtins.str]] = None,
            package_code: Optional[pulumi.Input[_builtins.str]] = None,
            period: Optional[pulumi.Input[_builtins.int]] = None,
            prefessional_service: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            renew_period: Optional[pulumi.Input[_builtins.int]] = None,
            renewal_status: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.int]] = None,
            subscription_type: Optional[pulumi.Input[_builtins.str]] = None,
            waf_log: Optional[pulumi.Input[_builtins.str]] = None) -> 'Instance':
        """
        Get an existing Instance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] big_screen: Specify whether big screen is supported. Valid values: ["0", "1"]. "0" for false and "1" for true.
        :param pulumi.Input[_builtins.str] exclusive_ip_package: Specify the number of exclusive WAF IP addresses.
        :param pulumi.Input[_builtins.str] ext_bandwidth: The extra bandwidth. Unit: Mbit/s.
        :param pulumi.Input[_builtins.str] ext_domain_package: The number of extra domains.
        :param pulumi.Input[_builtins.str] log_storage: Log storage size. Unit: T. Valid values: [3, 5, 10, 20, 50].
        :param pulumi.Input[_builtins.str] log_time: Log storage period. Unit: day. Valid values: [180, 360].
        :param pulumi.Input[_builtins.str] modify_type: Type of configuration change. Valid value: Upgrade.
        :param pulumi.Input[_builtins.str] package_code: Subscription plan:
               * China site customers can purchase the following versions of China Mainland region, valid values: ["version_3", "version_4", "version_5"].
               * China site customers can purchase the following versions of International region, valid values: ["version_pro_asia", "version_business_asia", "version_enterprise_asia"]
               * International site customers can purchase the following versions of China Mainland region: ["version_pro_china", "version_business_china", "version_enterprise_china"]
               * International site customers can purchase the following versions of International region: ["version_pro", "version_business", "version_enterprise"].
        :param pulumi.Input[_builtins.int] period: Service time of Web Application Firewall.
        :param pulumi.Input[_builtins.str] prefessional_service: Specify whether professional service is supported. Valid values: ["true", "false"]
        :param pulumi.Input[_builtins.str] region: The instance region ID.
        :param pulumi.Input[_builtins.int] renew_period: Renewal period of WAF service. Unit: month
        :param pulumi.Input[_builtins.str] renewal_status: Renewal status of WAF service. Valid values: 
               * AutoRenewal: The service time of WAF is renewed automatically.
               * ManualRenewal (default): The service time of WAF is renewed manually.Specifies whether to configure a Layer-7 proxy, such as Anti-DDoS Pro or CDN, to filter the inbound traffic before it is forwarded to WAF. Valid values: "On" and "Off". Default to "Off".
        :param pulumi.Input[_builtins.str] resource_group_id: The resource group ID.
        :param pulumi.Input[_builtins.int] status: The status of the instance.
        :param pulumi.Input[_builtins.str] subscription_type: Subscription of WAF service. Valid values: ["Subscription", "PayAsYouGo"].
        :param pulumi.Input[_builtins.str] waf_log: Specify whether Log service is supported. Valid values: ["true", "false"]
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InstanceState.__new__(_InstanceState)

        __props__.__dict__["big_screen"] = big_screen
        __props__.__dict__["exclusive_ip_package"] = exclusive_ip_package
        __props__.__dict__["ext_bandwidth"] = ext_bandwidth
        __props__.__dict__["ext_domain_package"] = ext_domain_package
        __props__.__dict__["log_storage"] = log_storage
        __props__.__dict__["log_time"] = log_time
        __props__.__dict__["modify_type"] = modify_type
        __props__.__dict__["package_code"] = package_code
        __props__.__dict__["period"] = period
        __props__.__dict__["prefessional_service"] = prefessional_service
        __props__.__dict__["region"] = region
        __props__.__dict__["renew_period"] = renew_period
        __props__.__dict__["renewal_status"] = renewal_status
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["status"] = status
        __props__.__dict__["subscription_type"] = subscription_type
        __props__.__dict__["waf_log"] = waf_log
        return Instance(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="bigScreen")
    def big_screen(self) -> pulumi.Output[_builtins.str]:
        """
        Specify whether big screen is supported. Valid values: ["0", "1"]. "0" for false and "1" for true.
        """
        return pulumi.get(self, "big_screen")

    @_builtins.property
    @pulumi.getter(name="exclusiveIpPackage")
    def exclusive_ip_package(self) -> pulumi.Output[_builtins.str]:
        """
        Specify the number of exclusive WAF IP addresses.
        """
        return pulumi.get(self, "exclusive_ip_package")

    @_builtins.property
    @pulumi.getter(name="extBandwidth")
    def ext_bandwidth(self) -> pulumi.Output[_builtins.str]:
        """
        The extra bandwidth. Unit: Mbit/s.
        """
        return pulumi.get(self, "ext_bandwidth")

    @_builtins.property
    @pulumi.getter(name="extDomainPackage")
    def ext_domain_package(self) -> pulumi.Output[_builtins.str]:
        """
        The number of extra domains.
        """
        return pulumi.get(self, "ext_domain_package")

    @_builtins.property
    @pulumi.getter(name="logStorage")
    def log_storage(self) -> pulumi.Output[_builtins.str]:
        """
        Log storage size. Unit: T. Valid values: [3, 5, 10, 20, 50].
        """
        return pulumi.get(self, "log_storage")

    @_builtins.property
    @pulumi.getter(name="logTime")
    def log_time(self) -> pulumi.Output[_builtins.str]:
        """
        Log storage period. Unit: day. Valid values: [180, 360].
        """
        return pulumi.get(self, "log_time")

    @_builtins.property
    @pulumi.getter(name="modifyType")
    def modify_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Type of configuration change. Valid value: Upgrade.
        """
        return pulumi.get(self, "modify_type")

    @_builtins.property
    @pulumi.getter(name="packageCode")
    def package_code(self) -> pulumi.Output[_builtins.str]:
        """
        Subscription plan:
        * China site customers can purchase the following versions of China Mainland region, valid values: ["version_3", "version_4", "version_5"].
        * China site customers can purchase the following versions of International region, valid values: ["version_pro_asia", "version_business_asia", "version_enterprise_asia"]
        * International site customers can purchase the following versions of China Mainland region: ["version_pro_china", "version_business_china", "version_enterprise_china"]
        * International site customers can purchase the following versions of International region: ["version_pro", "version_business", "version_enterprise"].
        """
        return pulumi.get(self, "package_code")

    @_builtins.property
    @pulumi.getter
    def period(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Service time of Web Application Firewall.
        """
        return pulumi.get(self, "period")

    @_builtins.property
    @pulumi.getter(name="prefessionalService")
    def prefessional_service(self) -> pulumi.Output[_builtins.str]:
        """
        Specify whether professional service is supported. Valid values: ["true", "false"]
        """
        return pulumi.get(self, "prefessional_service")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The instance region ID.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="renewPeriod")
    def renew_period(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Renewal period of WAF service. Unit: month
        """
        return pulumi.get(self, "renew_period")

    @_builtins.property
    @pulumi.getter(name="renewalStatus")
    def renewal_status(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Renewal status of WAF service. Valid values: 
        * AutoRenewal: The service time of WAF is renewed automatically.
        * ManualRenewal (default): The service time of WAF is renewed manually.Specifies whether to configure a Layer-7 proxy, such as Anti-DDoS Pro or CDN, to filter the inbound traffic before it is forwarded to WAF. Valid values: "On" and "Off". Default to "Off".
        """
        return pulumi.get(self, "renewal_status")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The resource group ID.
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.int]:
        """
        The status of the instance.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="subscriptionType")
    def subscription_type(self) -> pulumi.Output[_builtins.str]:
        """
        Subscription of WAF service. Valid values: ["Subscription", "PayAsYouGo"].
        """
        return pulumi.get(self, "subscription_type")

    @_builtins.property
    @pulumi.getter(name="wafLog")
    def waf_log(self) -> pulumi.Output[_builtins.str]:
        """
        Specify whether Log service is supported. Valid values: ["true", "false"]
        """
        return pulumi.get(self, "waf_log")

