# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['gridnet']

package_data = \
{'': ['*']}

install_requires = \
['aiohttp>=3.0.0', 'yarl>=1.6.0']

setup_kwargs = {
    'name': 'gridnet',
    'version': '4.0.0',
    'description': 'Asynchronous Python client for a NET2GRID devices',
    'long_description': '## Python - Net2Grid Client\n\n<!-- PROJECT SHIELDS -->\n[![GitHub Release][releases-shield]][releases]\n[![Python Versions][python-versions-shield]][pypi]\n![Project Stage][project-stage-shield]\n![Project Maintenance][maintenance-shield]\n[![License][license-shield]](LICENSE)\n\n[![GitHub Activity][commits-shield]][commits-url]\n[![Forks][forks-shield]][forks-url]\n[![Stargazers][stars-shield]][stars-url]\n[![Issues][issues-shield]][issues-url]\n[![GitHub Last Commit][last-commit-shield]][commits-url]\n\n[![Code Quality][code-quality-shield]][code-quality]\n[![Maintainability][maintainability-shield]][maintainability-url]\n[![Code Coverage][codecov-shield]][codecov-url]\n[![Build Status][build-shield]][build-url]\n\nAsynchronous Python client for Net2Grid devices.\n\n## About\n\nA python package with which you can read the data from a [NET2GRID][net2grid] device via a local api. Net2Grid supplies energy hardware to brands, that can market it as a white label product.\n\n## Supported SmartBridges\n\n- SBWF3102 ([Pure Energie][pure-energie])\n\n## Installation\n\n```bash\npip install gridnet\n```\n\n## Usage\n\n```py\nimport asyncio\n\nfrom gridnet import GridNet\n\nasync def main():\n    """Show example on getting data from your device."""\n    async with GridNet(\n        host="example.com",\n    ) as client:\n        device = await client.device()\n        smartbridge = await client.smartbridge()\n        print(device)\n        print(smartbridge)\n\nif __name__ == "__main__":\n    loop = asyncio.get_event_loop()\n    loop.run_until_complete(main())\n```\n\n## Data\n\nYou can read the following data with this package, the `power flow` entity can also give a negative value. The `energy` entities are total values of both low and high tariff together.\n\n### Device\n\n- ID\n- Model\n- Batch\n- Firmware version\n- Hardware version\n- Manufacturer\n\n### SmartBridge\n\n- Power Flow (W)\n- Energy Consumption (kWh)\n- Energy Production (kWh)\n\n## Setting up development environment\n\nThis Python project is fully managed using the [Poetry][poetry] dependency\nmanager.\n\nYou need at least:\n\n- Python 3.9+\n- [Poetry][poetry-install]\n\nInstall all packages, including all development requirements:\n\n```bash\npoetry install\n```\n\nPoetry creates by default an virtual environment where it installs all\nnecessary pip packages, to enter or exit the venv run the following commands:\n\n```bash\npoetry shell\nexit\n```\n\nSetup the pre-commit check, you must run this inside the virtual environment:\n\n```bash\npre-commit install\n```\n\n*Now you\'re all set to get started!*\n\nAs this repository uses the [pre-commit][pre-commit] framework, all changes\nare linted and tested with each commit. You can run all checks and tests\nmanually, using the following command:\n\n```bash\npoetry run pre-commit run --all-files\n```\n\nTo run just the Python tests:\n\n```bash\npoetry run pytest\n```\n\n## Trademark Legal Notices\n\nAll product names, trademarks and registered trademarks in this repository, are property of their respective owners, and are used by the author for identification purposes only. The use of these names, trademarks and brands, do not imply endorsement or affiliation.\n\n## License\n\nMIT License\n\nCopyright (c) 2021-2022 Klaas Schoute\n\nPermission is hereby granted, free of charge, to any person obtaining a copy\nof this software and associated documentation files (the "Software"), to deal\nin the Software without restriction, including without limitation the rights\nto use, copy, modify, merge, publish, distribute, sublicense, and/or sell\ncopies of the Software, and to permit persons to whom the Software is\nfurnished to do so, subject to the following conditions:\n\nThe above copyright notice and this permission notice shall be included in all\ncopies or substantial portions of the Software.\n\nTHE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR\nIMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\nFITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE\nAUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER\nLIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,\nOUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE\nSOFTWARE.\n\n[pure-energie]: https://pure-energie.nl\n[net2grid]: https://www.net2grid.com\n[poetry-install]: https://python-poetry.org/docs/#installation\n[poetry]: https://python-poetry.org\n[pre-commit]: https://pre-commit.com\n\n<!-- MARKDOWN LINKS & IMAGES -->\n[build-shield]: https://github.com/klaasnicolaas/python-gridnet/actions/workflows/tests.yaml/badge.svg\n[build-url]: https://github.com/klaasnicolaas/python-gridnet/actions/workflows/tests.yaml\n[code-quality-shield]: https://img.shields.io/lgtm/grade/python/g/klaasnicolaas/python-gridnet.svg?logo=lgtm&logoWidth=18\n[code-quality]: https://lgtm.com/projects/g/klaasnicolaas/python-gridnet/context:python\n[commits-shield]: https://img.shields.io/github/commit-activity/y/klaasnicolaas/python-gridnet.svg\n[commits-url]: https://github.com/klaasnicolaas/python-gridnet/commits/main\n[codecov-shield]: https://codecov.io/gh/klaasnicolaas/python-gridnet/branch/main/graph/badge.svg?token=CXCSJBsRPE\n[codecov-url]: https://codecov.io/gh/klaasnicolaas/python-gridnet\n[forks-shield]: https://img.shields.io/github/forks/klaasnicolaas/python-gridnet.svg\n[forks-url]: https://github.com/klaasnicolaas/python-gridnet/network/members\n[issues-shield]: https://img.shields.io/github/issues/klaasnicolaas/python-gridnet.svg\n[issues-url]: https://github.com/klaasnicolaas/python-gridnet/issues\n[license-shield]: https://img.shields.io/github/license/klaasnicolaas/python-gridnet.svg\n[last-commit-shield]: https://img.shields.io/github/last-commit/klaasnicolaas/python-gridnet.svg\n[maintenance-shield]: https://img.shields.io/maintenance/yes/2022.svg\n[maintainability-shield]: https://api.codeclimate.com/v1/badges/0b3297077cbc525a837e/maintainability\n[maintainability-url]: https://codeclimate.com/github/klaasnicolaas/python-gridnet/maintainability\n[project-stage-shield]: https://img.shields.io/badge/project%20stage-experimental-yellow.svg\n[pypi]: https://pypi.org/project/gridnet/\n[python-versions-shield]: https://img.shields.io/pypi/pyversions/gridnet\n[releases-shield]: https://img.shields.io/github/release/klaasnicolaas/python-gridnet.svg\n[releases]: https://github.com/klaasnicolaas/python-gridnet/releases\n[stars-shield]: https://img.shields.io/github/stars/klaasnicolaas/python-gridnet.svg\n[stars-url]: https://github.com/klaasnicolaas/python-gridnet/stargazers\n',
    'author': 'Klaas Schoute',
    'author_email': 'hello@student-techlife.com',
    'maintainer': 'Klaas Schoute',
    'maintainer_email': 'hello@student-techlife.com',
    'url': 'https://github.com/klaasnicolaas/python-gridnet',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.9,<4.0',
}


setup(**setup_kwargs)
