import socket
from contextlib import closing


def available_port() -> int:
  """Randomly get the next available port."""

  with closing(socket.socket(socket.AF_INET, socket.SOCK_STREAM)) as s:
    s.bind(("", 0))

    s.setsockopt(socket.SOL_SOCKET, socket.SO_REUSEADDR, 1)

    return s.getsockname()[1]
