# AIPY 变更日志 - v0.2.3 至 v0.3.0b25

## 概述
本文档记录了 AIPY 从 v0.2.3 到 v0.3.0b25 (当前版本) 的主要功能更新、架构改进和问题修复。此版本包含了大量的新功能和重构改进，显著提升了系统的可用性和可维护性。

**整体统计**：96 个文件修改，新增 8275 行代码，删除 1894 行代码

---

## 🚀 主要新功能

### 1. 任务状态管理系统 (TaskState)
- **新增** `TaskState` 类，统一任务状态的序列化、反序列化和文件操作
- **重构** 任务保存/加载逻辑，消除重复代码，提高可维护性
- **支持** 版本兼容性检查和错误处理
- **提供** 灵活的组件状态管理接口

### 2. 增强的命令行系统
#### 任务管理命令
- **新增** `/task replay` 命令 - 支持任务重放功能，可调节播放速度
- **新增** `/task resume` 命令 - 从 task.json 文件恢复任务
- **改进** `/task use` 命令 - 直接返回任务对象并进入任务模式
- **增加** 路径参数自动补齐功能，支持包含空格的文件名

#### 步骤管理命令
- **新增** `/steps` 命令系列：
  - `/steps list` - 列出所有任务步骤
  - `/steps clear` - 清空所有步骤
  - `/steps delete <index>` - 删除指定步骤及后续步骤
- **实现** 步骤删除时自动清理对应的事件记录

#### 代码块管理
- **新增** `/block` 命令 - 管理代码块，支持查看、编辑和执行

#### 角色和上下文管理
- **新增** `/role` 命令 - 切换和管理 AI 角色
- **移除** `/use` 和 `/env` 命令，功能集成到其他命令中

### 3. MCP (Model Context Protocol) 支持
- **重构** `/mcp` 命令，默认执行 `status` 子命令
- **合并** `/tools` 命令到 `/mcp` 命令中
- **完善** MCP 工具调用的异常处理
- **增加** 状态栏 MCP 状态显示
- **修复** 多个 MCP 相关的初始化和错误处理问题

### 4. Agent 模式支持
- **新增** Agent 模式运行支持
- **优化** 任务处理流程以支持自主代理操作

### 5. 显示风格支持
- **新增** 显示风格插件化
- **新增** 默认三种显示模式：简约，经典，现代
- **新增** 用户可轻易定制自己的显示模式

### 6. 上下文管理 (实验)
- **新增** 上下文管理功能
- **新增** 上下文自动压缩

### 7. 任务步骤管理
- **新增** /step 命令管理任务步骤

### 8. 任务 resume 和 replay
- **新增** 通过 /task resume|replay 重用历史任务

### 9. 界面改进
- **新增** 状态栏
- **新增** 自动补齐历史任务
- **新增** 区分 main 和 task 模式（色调，光标，命令集）

### 10. 提示词管理
- **新增** 改用 Jinja 模版处理所有提示词
- **新增** 统一采用 XML 格式

### 11. 角色改进
- **新增** 环境变量和插件支持

### 12. 插件改进
- **新增** 支持 Python Function Calling 插件
- **新增** /plugin 命令

### 13. 自定义命令
- **新增** 支持自定义命令
- **新增** /custom 命令

---

## 🔧 架构改进

### 1. 事件系统重构
- **重构** 事件处理机制，从全局 event_bus 改为 per-task 模式
- **新增** `Event` 类，标准化事件数据结构
- **实现** `EventRecorder` 的 `Trackable` 接口，支持步骤管理器统一管理
- **完善** 事件记录的序列化和反序列化功能

### 2. 命令行接口重构
- **重构** 命令行接口，提供更好的用户体验
- **改进** 命令补齐功能，支持文件路径自动补齐
- **修复** 命令行出错导致退出任务模式的问题
- **增加** 历史任务自动补齐支持

### 3. 上下文管理优化
- **重构** 上下文管理功能，增加自动压缩选项
- **简化** 策略处理逻辑
- **优化** 上下文缓存清理，保留最初两条和最后一条消息
- **支持** 更灵活的上下文配置

### 4. 显示系统改进
- **支持** 显示风格插件系统
- **新增** 简约风格显示模式
- **完善** 现代风格和相关文档
- **修改** `runtime.display` 为 `runtime.show_image`
- **实现** aipyapp.aipy 和 console 的完全解耦

### 5. 命令行接口重构
- **新增** 模糊命令匹配
- **新增** 支持用户自定义命令
- **新增** 支持命令目录

### 6. 插件系统重构
- **完善** 显示风格变成标准插件
- **新增** /plugin 命令

---

## 🐛 问题修复

### 系统稳定性
- **修复** Ctrl-C 中断时任务未保存的问题
- **修复** GUI 兼容性问题
- **修复** 各种编码问题和错误处理

### MCP 相关修复
- **修复** MCP 初始化错误 (no mcp.json)
- **修复** tools 启用前的错误
- **修复** `/mcp disable` 命令错误
- **修复** 工具调用异常处理

### 模型支持
- **新增** GLM 模型支持
- **兼容** TT 模型名称
- **新增** TT API key 检查
- **新增** OAuth2 客户端支持

### 文件处理
- **修复** 文本文件识别问题
- **修复** JS 代码块编码错误
- **修复** base64 编码错误
- **支持** 嵌入文本文件功能
- **更改** bs4 依赖为 beautifulsoup4

---

## 🎨 用户界面改进

### 1. 状态栏增强
- **完善** 状态栏功能
- **增加** MCP 状态显示
- **新增** TaskManager.get_status() 方法

### 2. 任务显示优化
- **修补** 简约模式显示问题
- **修改** 终端提示方式
- **增加** 项目 logo 显示

### 3. 命令行体验
- **新增** `--style` 和 `--role` 命令行参数
- **新增** `--update [--beta]` 命令，自动更新
- **去掉** 任务目录名中的空格
- **优化** 任务提示词模板，增加版本号

---

## 📚 文档和配置

### 插件系统
- **完善** 插件文档和 API
- **角色配置** 新增 plugins 配置支持
- **插件初始化** 移到 task 级别

### 配置优化
- **调整** temperature 和 params 配置处理
- **修补** 代码块版本检查问题
- **完善** prompts 路径获取方式

---

## 🔄 重构亮点

### 代码质量提升
- **重构** 补齐代码逻辑
- **代码清理** 移除未使用的 API 和函数
- **去掉** call_tool 函数，简化工具调用
- **移除** prompt.py 文件

### 架构简化
- **去掉** TaskManager.current_task 全局状态
- **统一** 任务状态管理接口
- **简化** 事件和插件管理机制

---

## 🚧 API 变更

### 移除的功能
- `/use` 和 `/env` 命令 (功能合并到其他命令)
- `/tools` 命令 (合并到 `/mcp`)
- 全局 event_bus (改为 per-task)
- TaskManager.current_task 属性

### 新增的 API
- `TaskState` 类及相关方法
- `/steps` 命令系列
- `/block` 命令
- `/role` 命令
- Agent 模式相关接口

### Event API
- 完全重构

---

## 📝 技术债务清理

- **修复** f-string 语法错误
- **修复** 代码合并错误和拼写错误
- **统一** 错误处理机制
- **完善** 异常处理和日志记录

---

## 🔮 版本演进

从 v0.2.3 到 v0.3.0b6，经历了多个 beta 版本迭代：
- v0.2.3b3-b12: 功能完善和错误修复
- v0.2.4b1-b20: 重大架构改进
- v0.3.0b1-b6: 新功能集成和稳定性提升

---

## 💡 开发者注意事项

1. **任务状态管理**：现在统一使用 `TaskState` 类处理任务序列化
2. **事件系统**：事件处理改为 per-task 模式，插件需要适配
3. **命令接口**：部分命令已重构，脚本需要更新
4. **MCP 集成**：工具调用接口有所变化，需要检查集成代码

---

*此变更日志基于 git commit 记录自动生成，记录了从 v0.2.3 (75次提交) 到当前版本的所有重要变更。*