# 更新日志 (Changelog)

## [v2.5.9.1] - 2025-01-12

### 🔧 重要修复
#### uvx环境配置文件路径问题修复
- **问题描述**：修复了uvx运行环境下配置文件路径错误的问题
- **解决方案**：
  - 智能检测uvx运行环境，自动使用用户主目录配置路径
  - 优化配置文件路径计算逻辑，避免在临时缓存目录中查找配置
  - 自动创建默认配置文件，提升首次使用体验
  - 改进错误消息，明确显示运行环境和配置文件路径
- **技术改进**：
  - 检测uvx环境特征（路径包含"uv"和"cache"或"archive"）
  - 在uvx环境中直接使用 `~/.interactive-feedback/config.json`
  - 首次运行时自动创建默认配置文件
- **用户体验**：解决了uvx用户看到配置文件路径错误的困扰

---

## [v2.5.9] - 2025-01-12

### 🎨 提示文字显示效果优化
- **工具提示优化**：创建专门的工具提示格式化工具类，支持长文本自动换行
- **样式统一**：在明暗主题中设置统一的字体、边距、圆角边框和阴影效果
- **动态提示**：优化工具提示显示延迟，添加加载状态动态提示
- **占位符优化**：根据用户配置和语言动态更新占位符文本，支持跨平台
- **文本渲染**：启用抗锯齿、字母间距和单词间距调整，提升可读性
- **语法高亮**：为文件引用添加蓝色高亮显示
- **反馈消息**：优化成功状态显示和加载状态提示，智能自动隐藏
- **格式化工具**：创建Markdown格式处理工具，支持撤销的文本替换

---

## [v2.5.8.3] - 2025-01-12

### 🔧 重要修复
#### MCP服务连续调用问题修复
- **问题描述**：修复了MCP服务连续调用两次的问题，原因是严格的参数验证逻辑导致第一次调用失败
- **解决方案**：实现智能回退机制，当主要参数为空时自动使用备用参数
- **技术改进**：
  - 完整模式：优先使用 `full_response`，如果为空则回退到 `message`
  - 精简模式：优先使用 `message`，如果为空则回退到 `full_response`
  - 只有当两个参数都为空时才返回错误
  - 保持实时模式检测，支持动态切换
- **代码优化**：
  - 提取公共参数验证函数，减少重复代码
  - 使用元组解包简化参数优先级逻辑
  - 更新工具文档，添加智能回退说明
- **用户体验**：避免了不必要的错误提示，提升了工具的稳定性和可靠性

---

## [当前版本] - 项目现状

### 🎯 项目概述
interactive-feedback-mcp 是一个专业的AI助手交互式反馈工具，提供图形化界面用于AI助手与用户之间的高效沟通。

### 🌟 核心功能
- **交互式反馈窗口**：支持文本输入、预定义选项选择、快捷键操作
- **多媒体处理**：图片粘贴/拖拽、文件引用、窗口截图功能
- **常用语管理**：预设管理、hover预览、快速插入
- **原生终端集成**：支持PowerShell、Git Bash、Command Prompt
- **文本优化功能**：多AI提供商支持、一键优化、自定义增强
- **界面布局**：垂直/水平布局、可拖拽分割器、主题切换
- **显示模式**：简单模式/完整模式、实时切换
- **音频提示**：窗口弹出提示音、自定义音频支持

### 🏗️ 技术架构
- **基于PySide6**：现代化的Qt图形界面框架
- **MCP协议**：标准的模型上下文协议集成
- **模块化设计**：清晰的代码结构和组件分离
- **主题系统**：统一的颜色管理和样式应用
- **配置管理**：灵活的配置文件和UI设置

### 📚 文档体系
- **README.md**：项目简介和使用技巧
- **功能说明.md**：详细的功能描述和操作指南
- **安装与配置指南.md**：完整的安装配置说明
- **CHANGELOG.md**：项目发展历程记录

---

## [主要版本历程]

### v4.x - 界面优化与文档重构期
#### UI界面稳定性提升
- 解决了UI窗口布局闪烁问题，优化初始化流程
- 实现主题一致性，所有UI元素统一使用主题感知颜色系统
- 调整按钮布局逻辑，提升用户操作体验
- 移除不协调的hover效果，保持视觉一致性

#### 代码质量改进
- 清理约50行冗余代码，统一配置读取和样式应用逻辑
- 优化初始化流程，减少定时器冲突，提升UI响应性
- 改进窗口显示和样式更新时序，提供更稳定的用户体验

#### 文档体系重构
- 重构README.md，突出使用技巧，更新AI助手工作流规则
- 精简功能说明.md，移除时间性描述，突出核心功能
- 优化安装与配置指南.md，移除重复内容，保持文档简洁

### v3.x - 功能扩展与体验优化期
#### 文本优化功能
- 集成多AI提供商支持（OpenAI、Gemini、DeepSeek、火山引擎）
- 实现一键优化和自定义增强功能
- 添加API密钥管理和加载动画
- 支持撤销功能和自动光标定位

#### 多媒体功能增强
- 添加窗口截图功能，支持矩形选择和智能窗口管理
- 实现音频提示功能，支持自定义音频文件
- 优化图片处理流程，提供更好的预览和管理体验

#### 界面布局系统
- 实现垂直/水平双布局模式
- 添加可拖拽分割器，支持双击重置
- 实现显示模式配置（简单模式/完整模式）
- 优化设置页面，统一UI风格

### v2.x - 核心功能完善期
#### 文件处理系统
- 实现文件拖拽功能，支持蓝色文件引用显示
- 添加文件选择按钮，支持多文件选择
- 智能处理图片文件和普通文件
- 实现智能光标定位和重复检测

#### 常用语系统
- 实现常用语管理功能，支持添加、编辑、删除和排序
- 添加hover预览功能，支持无限滚动
- 实现流畅的鼠标交互和主题适配
- 优化管理界面布局和用户体验

#### 终端集成
- 集成原生终端功能，支持PowerShell、Git Bash、Command Prompt
- 实现直接输入模式和完整键盘支持
- 添加ANSI转义序列支持，正确显示彩色输出
- 实现智能提示符识别和窗口管理

### v1.x - 基础功能建立期
#### 核心反馈系统
- 建立基础的交互式反馈窗口
- 实现文本输入和预定义选项选择
- 添加快捷键支持（Enter、Shift+Enter、Ctrl+V）
- 集成MCP协议，实现与AI助手的通信

#### 图片处理功能
- 实现图片粘贴和拖拽功能
- 添加图片预览和管理功能
- 支持多种图片格式和尺寸调整
- 实现图片与文本的混合处理

#### 基础UI框架
- 建立基于PySide6的图形界面框架
- 实现深色主题UI
- 添加基础的窗口控制功能
- 建立配置管理系统

---

## [发展里程碑]

### 🎯 项目成就
- **功能完整性**：从基础反馈工具发展为功能完整的AI助手交互平台
- **用户体验**：持续优化界面和交互，提供专业级的用户体验
- **技术架构**：建立了稳定、可扩展的技术架构
- **文档体系**：完善的文档体系，便于用户使用和开发者参与

### 🔮 技术演进
- **界面技术**：从基础Qt界面发展为主题感知的现代化UI
- **功能集成**：从单一反馈功能扩展为多媒体、终端、AI优化的综合平台
- **代码质量**：持续重构和优化，保持高质量的代码标准
- **用户导向**：始终以用户体验为中心，不断改进和完善功能
