# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetOauthResult',
    'AwaitableGetOauthResult',
    'get_oauth',
    'get_oauth_output',
]

@pulumi.output_type
class GetOauthResult:
    """
    A collection of values returned by getOauth.
    """
    def __init__(__self__, active_only=None, auto_submit_toolbar=None, client_id=None, client_secret=None, client_uri=None, grant_types=None, hide_ios=None, hide_web=None, id=None, label=None, label_prefix=None, links=None, login_mode=None, login_scopes=None, login_uri=None, logo_uri=None, name=None, policy_uri=None, post_logout_redirect_uris=None, redirect_uris=None, response_types=None, skip_groups=None, skip_users=None, status=None, type=None, wildcard_redirect=None):
        if active_only and not isinstance(active_only, bool):
            raise TypeError("Expected argument 'active_only' to be a bool")
        pulumi.set(__self__, "active_only", active_only)
        if auto_submit_toolbar and not isinstance(auto_submit_toolbar, bool):
            raise TypeError("Expected argument 'auto_submit_toolbar' to be a bool")
        pulumi.set(__self__, "auto_submit_toolbar", auto_submit_toolbar)
        if client_id and not isinstance(client_id, str):
            raise TypeError("Expected argument 'client_id' to be a str")
        pulumi.set(__self__, "client_id", client_id)
        if client_secret and not isinstance(client_secret, str):
            raise TypeError("Expected argument 'client_secret' to be a str")
        pulumi.set(__self__, "client_secret", client_secret)
        if client_uri and not isinstance(client_uri, str):
            raise TypeError("Expected argument 'client_uri' to be a str")
        pulumi.set(__self__, "client_uri", client_uri)
        if grant_types and not isinstance(grant_types, list):
            raise TypeError("Expected argument 'grant_types' to be a list")
        pulumi.set(__self__, "grant_types", grant_types)
        if hide_ios and not isinstance(hide_ios, bool):
            raise TypeError("Expected argument 'hide_ios' to be a bool")
        pulumi.set(__self__, "hide_ios", hide_ios)
        if hide_web and not isinstance(hide_web, bool):
            raise TypeError("Expected argument 'hide_web' to be a bool")
        pulumi.set(__self__, "hide_web", hide_web)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if label and not isinstance(label, str):
            raise TypeError("Expected argument 'label' to be a str")
        pulumi.set(__self__, "label", label)
        if label_prefix and not isinstance(label_prefix, str):
            raise TypeError("Expected argument 'label_prefix' to be a str")
        pulumi.set(__self__, "label_prefix", label_prefix)
        if links and not isinstance(links, str):
            raise TypeError("Expected argument 'links' to be a str")
        pulumi.set(__self__, "links", links)
        if login_mode and not isinstance(login_mode, str):
            raise TypeError("Expected argument 'login_mode' to be a str")
        pulumi.set(__self__, "login_mode", login_mode)
        if login_scopes and not isinstance(login_scopes, list):
            raise TypeError("Expected argument 'login_scopes' to be a list")
        pulumi.set(__self__, "login_scopes", login_scopes)
        if login_uri and not isinstance(login_uri, str):
            raise TypeError("Expected argument 'login_uri' to be a str")
        pulumi.set(__self__, "login_uri", login_uri)
        if logo_uri and not isinstance(logo_uri, str):
            raise TypeError("Expected argument 'logo_uri' to be a str")
        pulumi.set(__self__, "logo_uri", logo_uri)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if policy_uri and not isinstance(policy_uri, str):
            raise TypeError("Expected argument 'policy_uri' to be a str")
        pulumi.set(__self__, "policy_uri", policy_uri)
        if post_logout_redirect_uris and not isinstance(post_logout_redirect_uris, list):
            raise TypeError("Expected argument 'post_logout_redirect_uris' to be a list")
        pulumi.set(__self__, "post_logout_redirect_uris", post_logout_redirect_uris)
        if redirect_uris and not isinstance(redirect_uris, list):
            raise TypeError("Expected argument 'redirect_uris' to be a list")
        pulumi.set(__self__, "redirect_uris", redirect_uris)
        if response_types and not isinstance(response_types, list):
            raise TypeError("Expected argument 'response_types' to be a list")
        pulumi.set(__self__, "response_types", response_types)
        if skip_groups and not isinstance(skip_groups, bool):
            raise TypeError("Expected argument 'skip_groups' to be a bool")
        pulumi.set(__self__, "skip_groups", skip_groups)
        if skip_users and not isinstance(skip_users, bool):
            raise TypeError("Expected argument 'skip_users' to be a bool")
        pulumi.set(__self__, "skip_users", skip_users)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if wildcard_redirect and not isinstance(wildcard_redirect, str):
            raise TypeError("Expected argument 'wildcard_redirect' to be a str")
        pulumi.set(__self__, "wildcard_redirect", wildcard_redirect)

    @property
    @pulumi.getter(name="activeOnly")
    def active_only(self) -> Optional[bool]:
        """
        Search only ACTIVE applications.
        """
        return pulumi.get(self, "active_only")

    @property
    @pulumi.getter(name="autoSubmitToolbar")
    def auto_submit_toolbar(self) -> bool:
        """
        Display auto submit toolbar
        """
        return pulumi.get(self, "auto_submit_toolbar")

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> str:
        """
        OAuth client ID
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> str:
        """
        OAuth client secret
        """
        return pulumi.get(self, "client_secret")

    @property
    @pulumi.getter(name="clientUri")
    def client_uri(self) -> str:
        """
        URI to a web page providing information about the client.
        """
        return pulumi.get(self, "client_uri")

    @property
    @pulumi.getter(name="grantTypes")
    def grant_types(self) -> Sequence[str]:
        """
        List of OAuth 2.0 grant types
        """
        return pulumi.get(self, "grant_types")

    @property
    @pulumi.getter(name="hideIos")
    def hide_ios(self) -> bool:
        """
        Do not display application icon on mobile app
        """
        return pulumi.get(self, "hide_ios")

    @property
    @pulumi.getter(name="hideWeb")
    def hide_web(self) -> bool:
        """
        Do not display application icon to users
        """
        return pulumi.get(self, "hide_web")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Id of application to retrieve, conflicts with label and label_prefix.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def label(self) -> Optional[str]:
        """
        The label of the app to retrieve, conflicts with
        			label_prefix and id. Label uses the ?q=\\n\\n query parameter exposed by
        			Okta's List Apps API. The API will search both name and label using that
        			query. Therefore similarily named and labeled apps may be returned in the query
        			and have the unitended result of associating the wrong app with this data
        			source. See:
        			https://developer.okta.com/docs/reference/api/apps/#list-applications
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter(name="labelPrefix")
    def label_prefix(self) -> Optional[str]:
        """
        Label prefix of the app to retrieve, conflicts with label and id. This will tell the
        			provider to do a starts with query as opposed to an equals query.
        """
        return pulumi.get(self, "label_prefix")

    @property
    @pulumi.getter
    def links(self) -> str:
        """
        Discoverable resources related to the app
        """
        return pulumi.get(self, "links")

    @property
    @pulumi.getter(name="loginMode")
    def login_mode(self) -> str:
        """
        The type of Idp-Initiated login that the client supports, if any
        """
        return pulumi.get(self, "login_mode")

    @property
    @pulumi.getter(name="loginScopes")
    def login_scopes(self) -> Sequence[str]:
        """
        List of scopes to use for the request when 'login_mode' == OKTA
        """
        return pulumi.get(self, "login_scopes")

    @property
    @pulumi.getter(name="loginUri")
    def login_uri(self) -> str:
        """
        URI that initiates login.
        """
        return pulumi.get(self, "login_uri")

    @property
    @pulumi.getter(name="logoUri")
    def logo_uri(self) -> str:
        """
        URI that references a logo for the client.
        """
        return pulumi.get(self, "logo_uri")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of application.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="policyUri")
    def policy_uri(self) -> str:
        """
        URI to web page providing client policy document.
        """
        return pulumi.get(self, "policy_uri")

    @property
    @pulumi.getter(name="postLogoutRedirectUris")
    def post_logout_redirect_uris(self) -> Sequence[str]:
        """
        List of URIs for redirection after logout
        """
        return pulumi.get(self, "post_logout_redirect_uris")

    @property
    @pulumi.getter(name="redirectUris")
    def redirect_uris(self) -> Sequence[str]:
        """
        List of URIs for use in the redirect-based flow.
        """
        return pulumi.get(self, "redirect_uris")

    @property
    @pulumi.getter(name="responseTypes")
    def response_types(self) -> Sequence[str]:
        """
        List of OAuth 2.0 response type strings.
        """
        return pulumi.get(self, "response_types")

    @property
    @pulumi.getter(name="skipGroups")
    @_utilities.deprecated("""Because groups has been removed, this attribute is a no op and will be removed""")
    def skip_groups(self) -> Optional[bool]:
        """
        Ignore groups sync. This is a temporary solution until 'groups' field is supported in all the app-like resources
        """
        return pulumi.get(self, "skip_groups")

    @property
    @pulumi.getter(name="skipUsers")
    @_utilities.deprecated("""Because users has been removed, this attribute is a no op and will be removed""")
    def skip_users(self) -> Optional[bool]:
        """
        Ignore users sync. This is a temporary solution until 'users' field is supported in all the app-like resources
        """
        return pulumi.get(self, "skip_users")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Status of application.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of OAuth application.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="wildcardRedirect")
    def wildcard_redirect(self) -> str:
        """
        Indicates if the client is allowed to use wildcard matching of redirect_uris
        """
        return pulumi.get(self, "wildcard_redirect")


class AwaitableGetOauthResult(GetOauthResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetOauthResult(
            active_only=self.active_only,
            auto_submit_toolbar=self.auto_submit_toolbar,
            client_id=self.client_id,
            client_secret=self.client_secret,
            client_uri=self.client_uri,
            grant_types=self.grant_types,
            hide_ios=self.hide_ios,
            hide_web=self.hide_web,
            id=self.id,
            label=self.label,
            label_prefix=self.label_prefix,
            links=self.links,
            login_mode=self.login_mode,
            login_scopes=self.login_scopes,
            login_uri=self.login_uri,
            logo_uri=self.logo_uri,
            name=self.name,
            policy_uri=self.policy_uri,
            post_logout_redirect_uris=self.post_logout_redirect_uris,
            redirect_uris=self.redirect_uris,
            response_types=self.response_types,
            skip_groups=self.skip_groups,
            skip_users=self.skip_users,
            status=self.status,
            type=self.type,
            wildcard_redirect=self.wildcard_redirect)


def get_oauth(active_only: Optional[bool] = None,
              id: Optional[str] = None,
              label: Optional[str] = None,
              label_prefix: Optional[str] = None,
              skip_groups: Optional[bool] = None,
              skip_users: Optional[bool] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetOauthResult:
    """
    Get a OIDC application from Okta.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_okta as okta

    test = okta.app.get_oauth(label="Example App")
    ```


    :param bool active_only: Search only ACTIVE applications.
    :param str id: Id of application to retrieve, conflicts with label and label_prefix.
    :param str label: The label of the app to retrieve, conflicts with
           			label_prefix and id. Label uses the ?q=\\n\\n query parameter exposed by
           			Okta's List Apps API. The API will search both name and label using that
           			query. Therefore similarily named and labeled apps may be returned in the query
           			and have the unitended result of associating the wrong app with this data
           			source. See:
           			https://developer.okta.com/docs/reference/api/apps/#list-applications
    :param str label_prefix: Label prefix of the app to retrieve, conflicts with label and id. This will tell the
           			provider to do a starts with query as opposed to an equals query.
    :param bool skip_groups: Ignore groups sync. This is a temporary solution until 'groups' field is supported in all the app-like resources
    :param bool skip_users: Ignore users sync. This is a temporary solution until 'users' field is supported in all the app-like resources
    """
    __args__ = dict()
    __args__['activeOnly'] = active_only
    __args__['id'] = id
    __args__['label'] = label
    __args__['labelPrefix'] = label_prefix
    __args__['skipGroups'] = skip_groups
    __args__['skipUsers'] = skip_users
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('okta:app/getOauth:getOauth', __args__, opts=opts, typ=GetOauthResult).value

    return AwaitableGetOauthResult(
        active_only=pulumi.get(__ret__, 'active_only'),
        auto_submit_toolbar=pulumi.get(__ret__, 'auto_submit_toolbar'),
        client_id=pulumi.get(__ret__, 'client_id'),
        client_secret=pulumi.get(__ret__, 'client_secret'),
        client_uri=pulumi.get(__ret__, 'client_uri'),
        grant_types=pulumi.get(__ret__, 'grant_types'),
        hide_ios=pulumi.get(__ret__, 'hide_ios'),
        hide_web=pulumi.get(__ret__, 'hide_web'),
        id=pulumi.get(__ret__, 'id'),
        label=pulumi.get(__ret__, 'label'),
        label_prefix=pulumi.get(__ret__, 'label_prefix'),
        links=pulumi.get(__ret__, 'links'),
        login_mode=pulumi.get(__ret__, 'login_mode'),
        login_scopes=pulumi.get(__ret__, 'login_scopes'),
        login_uri=pulumi.get(__ret__, 'login_uri'),
        logo_uri=pulumi.get(__ret__, 'logo_uri'),
        name=pulumi.get(__ret__, 'name'),
        policy_uri=pulumi.get(__ret__, 'policy_uri'),
        post_logout_redirect_uris=pulumi.get(__ret__, 'post_logout_redirect_uris'),
        redirect_uris=pulumi.get(__ret__, 'redirect_uris'),
        response_types=pulumi.get(__ret__, 'response_types'),
        skip_groups=pulumi.get(__ret__, 'skip_groups'),
        skip_users=pulumi.get(__ret__, 'skip_users'),
        status=pulumi.get(__ret__, 'status'),
        type=pulumi.get(__ret__, 'type'),
        wildcard_redirect=pulumi.get(__ret__, 'wildcard_redirect'))
def get_oauth_output(active_only: Optional[pulumi.Input[Optional[bool]]] = None,
                     id: Optional[pulumi.Input[Optional[str]]] = None,
                     label: Optional[pulumi.Input[Optional[str]]] = None,
                     label_prefix: Optional[pulumi.Input[Optional[str]]] = None,
                     skip_groups: Optional[pulumi.Input[Optional[bool]]] = None,
                     skip_users: Optional[pulumi.Input[Optional[bool]]] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetOauthResult]:
    """
    Get a OIDC application from Okta.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_okta as okta

    test = okta.app.get_oauth(label="Example App")
    ```


    :param bool active_only: Search only ACTIVE applications.
    :param str id: Id of application to retrieve, conflicts with label and label_prefix.
    :param str label: The label of the app to retrieve, conflicts with
           			label_prefix and id. Label uses the ?q=\\n\\n query parameter exposed by
           			Okta's List Apps API. The API will search both name and label using that
           			query. Therefore similarily named and labeled apps may be returned in the query
           			and have the unitended result of associating the wrong app with this data
           			source. See:
           			https://developer.okta.com/docs/reference/api/apps/#list-applications
    :param str label_prefix: Label prefix of the app to retrieve, conflicts with label and id. This will tell the
           			provider to do a starts with query as opposed to an equals query.
    :param bool skip_groups: Ignore groups sync. This is a temporary solution until 'groups' field is supported in all the app-like resources
    :param bool skip_users: Ignore users sync. This is a temporary solution until 'users' field is supported in all the app-like resources
    """
    __args__ = dict()
    __args__['activeOnly'] = active_only
    __args__['id'] = id
    __args__['label'] = label
    __args__['labelPrefix'] = label_prefix
    __args__['skipGroups'] = skip_groups
    __args__['skipUsers'] = skip_users
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('okta:app/getOauth:getOauth', __args__, opts=opts, typ=GetOauthResult)
    return __ret__.apply(lambda __response__: GetOauthResult(
        active_only=pulumi.get(__response__, 'active_only'),
        auto_submit_toolbar=pulumi.get(__response__, 'auto_submit_toolbar'),
        client_id=pulumi.get(__response__, 'client_id'),
        client_secret=pulumi.get(__response__, 'client_secret'),
        client_uri=pulumi.get(__response__, 'client_uri'),
        grant_types=pulumi.get(__response__, 'grant_types'),
        hide_ios=pulumi.get(__response__, 'hide_ios'),
        hide_web=pulumi.get(__response__, 'hide_web'),
        id=pulumi.get(__response__, 'id'),
        label=pulumi.get(__response__, 'label'),
        label_prefix=pulumi.get(__response__, 'label_prefix'),
        links=pulumi.get(__response__, 'links'),
        login_mode=pulumi.get(__response__, 'login_mode'),
        login_scopes=pulumi.get(__response__, 'login_scopes'),
        login_uri=pulumi.get(__response__, 'login_uri'),
        logo_uri=pulumi.get(__response__, 'logo_uri'),
        name=pulumi.get(__response__, 'name'),
        policy_uri=pulumi.get(__response__, 'policy_uri'),
        post_logout_redirect_uris=pulumi.get(__response__, 'post_logout_redirect_uris'),
        redirect_uris=pulumi.get(__response__, 'redirect_uris'),
        response_types=pulumi.get(__response__, 'response_types'),
        skip_groups=pulumi.get(__response__, 'skip_groups'),
        skip_users=pulumi.get(__response__, 'skip_users'),
        status=pulumi.get(__response__, 'status'),
        type=pulumi.get(__response__, 'type'),
        wildcard_redirect=pulumi.get(__response__, 'wildcard_redirect')))
