# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetServerScopesResult',
    'AwaitableGetServerScopesResult',
    'get_server_scopes',
    'get_server_scopes_output',
]

@pulumi.output_type
class GetServerScopesResult:
    """
    A collection of values returned by getServerScopes.
    """
    def __init__(__self__, auth_server_id=None, id=None, scopes=None):
        if auth_server_id and not isinstance(auth_server_id, str):
            raise TypeError("Expected argument 'auth_server_id' to be a str")
        pulumi.set(__self__, "auth_server_id", auth_server_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if scopes and not isinstance(scopes, list):
            raise TypeError("Expected argument 'scopes' to be a list")
        pulumi.set(__self__, "scopes", scopes)

    @property
    @pulumi.getter(name="authServerId")
    def auth_server_id(self) -> str:
        """
        Auth server ID
        """
        return pulumi.get(self, "auth_server_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def scopes(self) -> Sequence['outputs.GetServerScopesScopeResult']:
        """
        Collection of authorization server scopes retrieved from Okta with the following properties.
        """
        return pulumi.get(self, "scopes")


class AwaitableGetServerScopesResult(GetServerScopesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetServerScopesResult(
            auth_server_id=self.auth_server_id,
            id=self.id,
            scopes=self.scopes)


def get_server_scopes(auth_server_id: Optional[str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetServerScopesResult:
    """
    Get a list of authorization server scopes from Okta.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_okta as okta

    test = okta.auth.get_server_scopes(auth_server_id="default")
    ```


    :param str auth_server_id: Auth server ID
    """
    __args__ = dict()
    __args__['authServerId'] = auth_server_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('okta:auth/getServerScopes:getServerScopes', __args__, opts=opts, typ=GetServerScopesResult).value

    return AwaitableGetServerScopesResult(
        auth_server_id=pulumi.get(__ret__, 'auth_server_id'),
        id=pulumi.get(__ret__, 'id'),
        scopes=pulumi.get(__ret__, 'scopes'))
def get_server_scopes_output(auth_server_id: Optional[pulumi.Input[str]] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetServerScopesResult]:
    """
    Get a list of authorization server scopes from Okta.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_okta as okta

    test = okta.auth.get_server_scopes(auth_server_id="default")
    ```


    :param str auth_server_id: Auth server ID
    """
    __args__ = dict()
    __args__['authServerId'] = auth_server_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('okta:auth/getServerScopes:getServerScopes', __args__, opts=opts, typ=GetServerScopesResult)
    return __ret__.apply(lambda __response__: GetServerScopesResult(
        auth_server_id=pulumi.get(__response__, 'auth_server_id'),
        id=pulumi.get(__response__, 'id'),
        scopes=pulumi.get(__response__, 'scopes')))
