# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetDefaultSigninPageResult',
    'AwaitableGetDefaultSigninPageResult',
    'get_default_signin_page',
    'get_default_signin_page_output',
]

@pulumi.output_type
class GetDefaultSigninPageResult:
    """
    A collection of values returned by getDefaultSigninPage.
    """
    def __init__(__self__, brand_id=None, content_security_policy_setting=None, id=None, page_content=None, widget_customizations=None, widget_version=None):
        if brand_id and not isinstance(brand_id, str):
            raise TypeError("Expected argument 'brand_id' to be a str")
        pulumi.set(__self__, "brand_id", brand_id)
        if content_security_policy_setting and not isinstance(content_security_policy_setting, dict):
            raise TypeError("Expected argument 'content_security_policy_setting' to be a dict")
        pulumi.set(__self__, "content_security_policy_setting", content_security_policy_setting)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if page_content and not isinstance(page_content, str):
            raise TypeError("Expected argument 'page_content' to be a str")
        pulumi.set(__self__, "page_content", page_content)
        if widget_customizations and not isinstance(widget_customizations, dict):
            raise TypeError("Expected argument 'widget_customizations' to be a dict")
        pulumi.set(__self__, "widget_customizations", widget_customizations)
        if widget_version and not isinstance(widget_version, str):
            raise TypeError("Expected argument 'widget_version' to be a str")
        pulumi.set(__self__, "widget_version", widget_version)

    @property
    @pulumi.getter(name="brandId")
    def brand_id(self) -> str:
        """
        brand id of the preview signin page
        """
        return pulumi.get(self, "brand_id")

    @property
    @pulumi.getter(name="contentSecurityPolicySetting")
    def content_security_policy_setting(self) -> Optional['outputs.GetDefaultSigninPageContentSecurityPolicySettingResult']:
        return pulumi.get(self, "content_security_policy_setting")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        placeholder id
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="pageContent")
    def page_content(self) -> str:
        """
        page content of the preview signin page
        """
        return pulumi.get(self, "page_content")

    @property
    @pulumi.getter(name="widgetCustomizations")
    def widget_customizations(self) -> Optional['outputs.GetDefaultSigninPageWidgetCustomizationsResult']:
        return pulumi.get(self, "widget_customizations")

    @property
    @pulumi.getter(name="widgetVersion")
    def widget_version(self) -> str:
        """
        widget version specified as a Semver
        """
        return pulumi.get(self, "widget_version")


class AwaitableGetDefaultSigninPageResult(GetDefaultSigninPageResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDefaultSigninPageResult(
            brand_id=self.brand_id,
            content_security_policy_setting=self.content_security_policy_setting,
            id=self.id,
            page_content=self.page_content,
            widget_customizations=self.widget_customizations,
            widget_version=self.widget_version)


def get_default_signin_page(brand_id: Optional[str] = None,
                            content_security_policy_setting: Optional[Union['GetDefaultSigninPageContentSecurityPolicySettingArgs', 'GetDefaultSigninPageContentSecurityPolicySettingArgsDict']] = None,
                            widget_customizations: Optional[Union['GetDefaultSigninPageWidgetCustomizationsArgs', 'GetDefaultSigninPageWidgetCustomizationsArgsDict']] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDefaultSigninPageResult:
    """
    Retrieve the default signin page of a brand


    :param str brand_id: brand id of the preview signin page
    """
    __args__ = dict()
    __args__['brandId'] = brand_id
    __args__['contentSecurityPolicySetting'] = content_security_policy_setting
    __args__['widgetCustomizations'] = widget_customizations
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('okta:index/getDefaultSigninPage:getDefaultSigninPage', __args__, opts=opts, typ=GetDefaultSigninPageResult).value

    return AwaitableGetDefaultSigninPageResult(
        brand_id=pulumi.get(__ret__, 'brand_id'),
        content_security_policy_setting=pulumi.get(__ret__, 'content_security_policy_setting'),
        id=pulumi.get(__ret__, 'id'),
        page_content=pulumi.get(__ret__, 'page_content'),
        widget_customizations=pulumi.get(__ret__, 'widget_customizations'),
        widget_version=pulumi.get(__ret__, 'widget_version'))
def get_default_signin_page_output(brand_id: Optional[pulumi.Input[str]] = None,
                                   content_security_policy_setting: Optional[pulumi.Input[Optional[Union['GetDefaultSigninPageContentSecurityPolicySettingArgs', 'GetDefaultSigninPageContentSecurityPolicySettingArgsDict']]]] = None,
                                   widget_customizations: Optional[pulumi.Input[Optional[Union['GetDefaultSigninPageWidgetCustomizationsArgs', 'GetDefaultSigninPageWidgetCustomizationsArgsDict']]]] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetDefaultSigninPageResult]:
    """
    Retrieve the default signin page of a brand


    :param str brand_id: brand id of the preview signin page
    """
    __args__ = dict()
    __args__['brandId'] = brand_id
    __args__['contentSecurityPolicySetting'] = content_security_policy_setting
    __args__['widgetCustomizations'] = widget_customizations
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('okta:index/getDefaultSigninPage:getDefaultSigninPage', __args__, opts=opts, typ=GetDefaultSigninPageResult)
    return __ret__.apply(lambda __response__: GetDefaultSigninPageResult(
        brand_id=pulumi.get(__response__, 'brand_id'),
        content_security_policy_setting=pulumi.get(__response__, 'content_security_policy_setting'),
        id=pulumi.get(__response__, 'id'),
        page_content=pulumi.get(__response__, 'page_content'),
        widget_customizations=pulumi.get(__response__, 'widget_customizations'),
        widget_version=pulumi.get(__response__, 'widget_version')))
