# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetNetworkZoneResult',
    'AwaitableGetNetworkZoneResult',
    'get_network_zone',
    'get_network_zone_output',
]

@pulumi.output_type
class GetNetworkZoneResult:
    """
    A collection of values returned by getNetworkZone.
    """
    def __init__(__self__, asns=None, dynamic_locations=None, dynamic_locations_excludes=None, dynamic_proxy_type=None, gateways=None, id=None, ip_service_categories_excludes=None, ip_service_categories_includes=None, name=None, proxies=None, status=None, type=None, usage=None):
        if asns and not isinstance(asns, list):
            raise TypeError("Expected argument 'asns' to be a list")
        pulumi.set(__self__, "asns", asns)
        if dynamic_locations and not isinstance(dynamic_locations, list):
            raise TypeError("Expected argument 'dynamic_locations' to be a list")
        pulumi.set(__self__, "dynamic_locations", dynamic_locations)
        if dynamic_locations_excludes and not isinstance(dynamic_locations_excludes, list):
            raise TypeError("Expected argument 'dynamic_locations_excludes' to be a list")
        pulumi.set(__self__, "dynamic_locations_excludes", dynamic_locations_excludes)
        if dynamic_proxy_type and not isinstance(dynamic_proxy_type, str):
            raise TypeError("Expected argument 'dynamic_proxy_type' to be a str")
        pulumi.set(__self__, "dynamic_proxy_type", dynamic_proxy_type)
        if gateways and not isinstance(gateways, list):
            raise TypeError("Expected argument 'gateways' to be a list")
        pulumi.set(__self__, "gateways", gateways)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ip_service_categories_excludes and not isinstance(ip_service_categories_excludes, list):
            raise TypeError("Expected argument 'ip_service_categories_excludes' to be a list")
        pulumi.set(__self__, "ip_service_categories_excludes", ip_service_categories_excludes)
        if ip_service_categories_includes and not isinstance(ip_service_categories_includes, list):
            raise TypeError("Expected argument 'ip_service_categories_includes' to be a list")
        pulumi.set(__self__, "ip_service_categories_includes", ip_service_categories_includes)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if proxies and not isinstance(proxies, list):
            raise TypeError("Expected argument 'proxies' to be a list")
        pulumi.set(__self__, "proxies", proxies)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if usage and not isinstance(usage, str):
            raise TypeError("Expected argument 'usage' to be a str")
        pulumi.set(__self__, "usage", usage)

    @property
    @pulumi.getter
    def asns(self) -> Sequence[str]:
        """
        List of asns included. Format of each array value: a string representation of an ASN numeric value. Use with type `DYNAMIC` or `DYNAMIC_V2`
        """
        return pulumi.get(self, "asns")

    @property
    @pulumi.getter(name="dynamicLocations")
    def dynamic_locations(self) -> Sequence[str]:
        """
        Array of locations ISO-3166-1(2) included. Format code: countryCode OR countryCode-regionCode. Use with type `DYNAMIC` or `DYNAMIC_V2`
        """
        return pulumi.get(self, "dynamic_locations")

    @property
    @pulumi.getter(name="dynamicLocationsExcludes")
    def dynamic_locations_excludes(self) -> Optional[Sequence[str]]:
        """
        Array of locations ISO-3166-1(2) excluded. Format code: countryCode OR countryCode-regionCode. Use with type `DYNAMIC_V2`
        """
        return pulumi.get(self, "dynamic_locations_excludes")

    @property
    @pulumi.getter(name="dynamicProxyType")
    def dynamic_proxy_type(self) -> str:
        """
        Type of proxy being controlled by this dynamic network zone - can be one of `Any`, `TorAnonymizer` or `NotTorAnonymizer`. Use with type `DYNAMIC`
        """
        return pulumi.get(self, "dynamic_proxy_type")

    @property
    @pulumi.getter
    def gateways(self) -> Sequence[str]:
        """
        Array of values in CIDR/range form depending on the way it's been declared (i.e. CIDR will contain /suffix). Please check API docs for examples. Use with type `IP`
        """
        return pulumi.get(self, "gateways")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        ID of the network zone to retrieve, conflicts with `name`.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ipServiceCategoriesExcludes")
    def ip_service_categories_excludes(self) -> Optional[Sequence[str]]:
        """
        List of ip service excluded. Use with type `DYNAMIC_V2`
        """
        return pulumi.get(self, "ip_service_categories_excludes")

    @property
    @pulumi.getter(name="ipServiceCategoriesIncludes")
    def ip_service_categories_includes(self) -> Optional[Sequence[str]]:
        """
        List of ip service included. Use with type `DYNAMIC_V2`
        """
        return pulumi.get(self, "ip_service_categories_includes")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the network zone to retrieve, conflicts with `id`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def proxies(self) -> Sequence[str]:
        """
        Array of values in CIDR/range form depending on the way it's been declared (i.e. CIDR will contain /suffix). Please check API docs for examples. Can not be set if `usage` is set to `BLOCKLIST`. Use with type `IP`
        """
        return pulumi.get(self, "proxies")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Network Status - can either be ACTIVE or INACTIVE only
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of the Network Zone - can be `IP`, `DYNAMIC` or `DYNAMIC_V2` only
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def usage(self) -> str:
        """
        Zone's purpose: POLICY or BLOCKLIST
        """
        return pulumi.get(self, "usage")


class AwaitableGetNetworkZoneResult(GetNetworkZoneResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetNetworkZoneResult(
            asns=self.asns,
            dynamic_locations=self.dynamic_locations,
            dynamic_locations_excludes=self.dynamic_locations_excludes,
            dynamic_proxy_type=self.dynamic_proxy_type,
            gateways=self.gateways,
            id=self.id,
            ip_service_categories_excludes=self.ip_service_categories_excludes,
            ip_service_categories_includes=self.ip_service_categories_includes,
            name=self.name,
            proxies=self.proxies,
            status=self.status,
            type=self.type,
            usage=self.usage)


def get_network_zone(dynamic_locations_excludes: Optional[Sequence[str]] = None,
                     id: Optional[str] = None,
                     ip_service_categories_excludes: Optional[Sequence[str]] = None,
                     ip_service_categories_includes: Optional[Sequence[str]] = None,
                     name: Optional[str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetNetworkZoneResult:
    """
    Gets Okta Network Zone.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_okta as okta

    example = okta.get_network_zone(name="Block Antarctica")
    ```


    :param Sequence[str] dynamic_locations_excludes: Array of locations ISO-3166-1(2) excluded. Format code: countryCode OR countryCode-regionCode. Use with type `DYNAMIC_V2`
    :param str id: ID of the network zone to retrieve, conflicts with `name`.
    :param Sequence[str] ip_service_categories_excludes: List of ip service excluded. Use with type `DYNAMIC_V2`
    :param Sequence[str] ip_service_categories_includes: List of ip service included. Use with type `DYNAMIC_V2`
    :param str name: Name of the network zone to retrieve, conflicts with `id`.
    """
    __args__ = dict()
    __args__['dynamicLocationsExcludes'] = dynamic_locations_excludes
    __args__['id'] = id
    __args__['ipServiceCategoriesExcludes'] = ip_service_categories_excludes
    __args__['ipServiceCategoriesIncludes'] = ip_service_categories_includes
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('okta:index/getNetworkZone:getNetworkZone', __args__, opts=opts, typ=GetNetworkZoneResult).value

    return AwaitableGetNetworkZoneResult(
        asns=pulumi.get(__ret__, 'asns'),
        dynamic_locations=pulumi.get(__ret__, 'dynamic_locations'),
        dynamic_locations_excludes=pulumi.get(__ret__, 'dynamic_locations_excludes'),
        dynamic_proxy_type=pulumi.get(__ret__, 'dynamic_proxy_type'),
        gateways=pulumi.get(__ret__, 'gateways'),
        id=pulumi.get(__ret__, 'id'),
        ip_service_categories_excludes=pulumi.get(__ret__, 'ip_service_categories_excludes'),
        ip_service_categories_includes=pulumi.get(__ret__, 'ip_service_categories_includes'),
        name=pulumi.get(__ret__, 'name'),
        proxies=pulumi.get(__ret__, 'proxies'),
        status=pulumi.get(__ret__, 'status'),
        type=pulumi.get(__ret__, 'type'),
        usage=pulumi.get(__ret__, 'usage'))
def get_network_zone_output(dynamic_locations_excludes: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                            id: Optional[pulumi.Input[Optional[str]]] = None,
                            ip_service_categories_excludes: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                            ip_service_categories_includes: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                            name: Optional[pulumi.Input[Optional[str]]] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetNetworkZoneResult]:
    """
    Gets Okta Network Zone.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_okta as okta

    example = okta.get_network_zone(name="Block Antarctica")
    ```


    :param Sequence[str] dynamic_locations_excludes: Array of locations ISO-3166-1(2) excluded. Format code: countryCode OR countryCode-regionCode. Use with type `DYNAMIC_V2`
    :param str id: ID of the network zone to retrieve, conflicts with `name`.
    :param Sequence[str] ip_service_categories_excludes: List of ip service excluded. Use with type `DYNAMIC_V2`
    :param Sequence[str] ip_service_categories_includes: List of ip service included. Use with type `DYNAMIC_V2`
    :param str name: Name of the network zone to retrieve, conflicts with `id`.
    """
    __args__ = dict()
    __args__['dynamicLocationsExcludes'] = dynamic_locations_excludes
    __args__['id'] = id
    __args__['ipServiceCategoriesExcludes'] = ip_service_categories_excludes
    __args__['ipServiceCategoriesIncludes'] = ip_service_categories_includes
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('okta:index/getNetworkZone:getNetworkZone', __args__, opts=opts, typ=GetNetworkZoneResult)
    return __ret__.apply(lambda __response__: GetNetworkZoneResult(
        asns=pulumi.get(__response__, 'asns'),
        dynamic_locations=pulumi.get(__response__, 'dynamic_locations'),
        dynamic_locations_excludes=pulumi.get(__response__, 'dynamic_locations_excludes'),
        dynamic_proxy_type=pulumi.get(__response__, 'dynamic_proxy_type'),
        gateways=pulumi.get(__response__, 'gateways'),
        id=pulumi.get(__response__, 'id'),
        ip_service_categories_excludes=pulumi.get(__response__, 'ip_service_categories_excludes'),
        ip_service_categories_includes=pulumi.get(__response__, 'ip_service_categories_includes'),
        name=pulumi.get(__response__, 'name'),
        proxies=pulumi.get(__response__, 'proxies'),
        status=pulumi.get(__response__, 'status'),
        type=pulumi.get(__response__, 'type'),
        usage=pulumi.get(__response__, 'usage')))
