# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['OidcArgs', 'Oidc']

@pulumi.input_type
class OidcArgs:
    def __init__(__self__, *,
                 authorization_binding: pulumi.Input[str],
                 authorization_url: pulumi.Input[str],
                 client_id: pulumi.Input[str],
                 client_secret: pulumi.Input[str],
                 issuer_url: pulumi.Input[str],
                 jwks_binding: pulumi.Input[str],
                 jwks_url: pulumi.Input[str],
                 scopes: pulumi.Input[Sequence[pulumi.Input[str]]],
                 token_binding: pulumi.Input[str],
                 token_url: pulumi.Input[str],
                 account_link_action: Optional[pulumi.Input[str]] = None,
                 account_link_group_includes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 deprovisioned_action: Optional[pulumi.Input[str]] = None,
                 groups_action: Optional[pulumi.Input[str]] = None,
                 groups_assignments: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 groups_attribute: Optional[pulumi.Input[str]] = None,
                 groups_filters: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 issuer_mode: Optional[pulumi.Input[str]] = None,
                 max_clock_skew: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 pkce_required: Optional[pulumi.Input[bool]] = None,
                 profile_master: Optional[pulumi.Input[bool]] = None,
                 protocol_type: Optional[pulumi.Input[str]] = None,
                 provisioning_action: Optional[pulumi.Input[str]] = None,
                 request_signature_algorithm: Optional[pulumi.Input[str]] = None,
                 request_signature_scope: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 subject_match_attribute: Optional[pulumi.Input[str]] = None,
                 subject_match_type: Optional[pulumi.Input[str]] = None,
                 suspended_action: Optional[pulumi.Input[str]] = None,
                 user_info_binding: Optional[pulumi.Input[str]] = None,
                 user_info_url: Optional[pulumi.Input[str]] = None,
                 username_template: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Oidc resource.
        :param pulumi.Input[str] authorization_binding: The method of making an authorization request. It can be set to `HTTP-POST` or `HTTP-REDIRECT`.
        :param pulumi.Input[str] authorization_url: IdP Authorization Server (AS) endpoint to request consent from the user and obtain an authorization code grant.
        :param pulumi.Input[str] client_id: Unique identifier issued by AS for the Okta IdP instance.
        :param pulumi.Input[str] client_secret: Client secret issued by AS for the Okta IdP instance.
        :param pulumi.Input[str] issuer_url: URI that identifies the issuer.
        :param pulumi.Input[str] jwks_binding: The method of making a request for the OIDC JWKS. It can be set to `HTTP-POST` or `HTTP-REDIRECT`
        :param pulumi.Input[str] jwks_url: Endpoint where the keys signer publishes its keys in a JWK Set.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] scopes: The scopes of the IdP.
        :param pulumi.Input[str] token_binding: The method of making a token request. It can be set to `HTTP-POST` or `HTTP-REDIRECT`.
        :param pulumi.Input[str] token_url: IdP Authorization Server (AS) endpoint to exchange the authorization code grant for an access token.
        :param pulumi.Input[str] account_link_action: Specifies the account linking action for an IdP user. Default: `AUTO`
        :param pulumi.Input[Sequence[pulumi.Input[str]]] account_link_group_includes: Group memberships to determine link candidates.
        :param pulumi.Input[str] deprovisioned_action: Action for a previously deprovisioned IdP user during authentication. Can be `NONE` or `REACTIVATE`. Default: `NONE`
        :param pulumi.Input[str] groups_action: Provisioning action for IdP user's group memberships. It can be `NONE`, `SYNC`, `APPEND`, or `ASSIGN`. Default: `NONE`
        :param pulumi.Input[Sequence[pulumi.Input[str]]] groups_assignments: List of Okta Group IDs to add an IdP user as a member with the `ASSIGN` `groups_action`.
        :param pulumi.Input[str] groups_attribute: IdP user profile attribute name (case-insensitive) for an array value that contains group memberships.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] groups_filters: Whitelist of Okta Group identifiers that are allowed for the `APPEND` or `SYNC` `groups_action`.
        :param pulumi.Input[str] issuer_mode: Indicates whether Okta uses the original Okta org domain URL, a custom domain URL, or dynamic. It can be `ORG_URL`, `CUSTOM_URL`, or `DYNAMIC`. Default: `ORG_URL`
        :param pulumi.Input[int] max_clock_skew: Maximum allowable clock-skew when processing messages from the IdP.
        :param pulumi.Input[str] name: Name of the IdP
        :param pulumi.Input[bool] pkce_required: Require Proof Key for Code Exchange (PKCE) for additional verification key rotation mode. See: https://developer.okta.com/docs/reference/api/idps/#oauth-2-0-and-openid-connect-client-object
        :param pulumi.Input[bool] profile_master: Determines if the IdP should act as a source of truth for user profile attributes.
        :param pulumi.Input[str] protocol_type: The type of protocol to use. It can be `OIDC` or `OAUTH2`. Default: `OIDC`
        :param pulumi.Input[str] provisioning_action: Provisioning action for an IdP user during authentication. Default: `AUTO`
        :param pulumi.Input[str] request_signature_algorithm: The HMAC Signature Algorithm used when signing an authorization request. Defaults to `HS256`. It can be `HS256`, `HS384`, `HS512`, `SHA-256`. `RS256`, `RS384`, or `RS512`. NOTE: `SHA-256` an undocumented legacy value and not continue to be valid. See API docs https://developer.okta.com/docs/reference/api/idps/#oidc-request-signature-algorithm-object
        :param pulumi.Input[str] request_signature_scope: Specifies whether to digitally sign an AuthnRequest messages to the IdP. Defaults to `REQUEST`. It can be `REQUEST` or `NONE`.
        :param pulumi.Input[str] status: Default to `ACTIVE`
        :param pulumi.Input[str] subject_match_attribute: Okta user profile attribute for matching transformed IdP username. Only for matchType `CUSTOM_ATTRIBUTE`.
        :param pulumi.Input[str] subject_match_type: Determines the Okta user profile attribute match conditions for account linking and authentication of the transformed IdP username. By default, it is set to `USERNAME`. It can be set to `USERNAME`, `EMAIL`, `USERNAME_OR_EMAIL` or `CUSTOM_ATTRIBUTE`.
        :param pulumi.Input[str] suspended_action: Action for a previously suspended IdP user during authentication. Can be `NONE` or `REACTIVATE`. Default: `NONE`
        :param pulumi.Input[str] user_info_url: Protected resource endpoint that returns claims about the authenticated user.
        :param pulumi.Input[str] username_template: Okta EL Expression to generate or transform a unique username for the IdP user. Default: `idpuser.email`
        """
        pulumi.set(__self__, "authorization_binding", authorization_binding)
        pulumi.set(__self__, "authorization_url", authorization_url)
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "client_secret", client_secret)
        pulumi.set(__self__, "issuer_url", issuer_url)
        pulumi.set(__self__, "jwks_binding", jwks_binding)
        pulumi.set(__self__, "jwks_url", jwks_url)
        pulumi.set(__self__, "scopes", scopes)
        pulumi.set(__self__, "token_binding", token_binding)
        pulumi.set(__self__, "token_url", token_url)
        if account_link_action is not None:
            pulumi.set(__self__, "account_link_action", account_link_action)
        if account_link_group_includes is not None:
            pulumi.set(__self__, "account_link_group_includes", account_link_group_includes)
        if deprovisioned_action is not None:
            pulumi.set(__self__, "deprovisioned_action", deprovisioned_action)
        if groups_action is not None:
            pulumi.set(__self__, "groups_action", groups_action)
        if groups_assignments is not None:
            pulumi.set(__self__, "groups_assignments", groups_assignments)
        if groups_attribute is not None:
            pulumi.set(__self__, "groups_attribute", groups_attribute)
        if groups_filters is not None:
            pulumi.set(__self__, "groups_filters", groups_filters)
        if issuer_mode is not None:
            pulumi.set(__self__, "issuer_mode", issuer_mode)
        if max_clock_skew is not None:
            pulumi.set(__self__, "max_clock_skew", max_clock_skew)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if pkce_required is not None:
            pulumi.set(__self__, "pkce_required", pkce_required)
        if profile_master is not None:
            pulumi.set(__self__, "profile_master", profile_master)
        if protocol_type is not None:
            pulumi.set(__self__, "protocol_type", protocol_type)
        if provisioning_action is not None:
            pulumi.set(__self__, "provisioning_action", provisioning_action)
        if request_signature_algorithm is not None:
            pulumi.set(__self__, "request_signature_algorithm", request_signature_algorithm)
        if request_signature_scope is not None:
            pulumi.set(__self__, "request_signature_scope", request_signature_scope)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if subject_match_attribute is not None:
            pulumi.set(__self__, "subject_match_attribute", subject_match_attribute)
        if subject_match_type is not None:
            pulumi.set(__self__, "subject_match_type", subject_match_type)
        if suspended_action is not None:
            pulumi.set(__self__, "suspended_action", suspended_action)
        if user_info_binding is not None:
            pulumi.set(__self__, "user_info_binding", user_info_binding)
        if user_info_url is not None:
            pulumi.set(__self__, "user_info_url", user_info_url)
        if username_template is not None:
            pulumi.set(__self__, "username_template", username_template)

    @property
    @pulumi.getter(name="authorizationBinding")
    def authorization_binding(self) -> pulumi.Input[str]:
        """
        The method of making an authorization request. It can be set to `HTTP-POST` or `HTTP-REDIRECT`.
        """
        return pulumi.get(self, "authorization_binding")

    @authorization_binding.setter
    def authorization_binding(self, value: pulumi.Input[str]):
        pulumi.set(self, "authorization_binding", value)

    @property
    @pulumi.getter(name="authorizationUrl")
    def authorization_url(self) -> pulumi.Input[str]:
        """
        IdP Authorization Server (AS) endpoint to request consent from the user and obtain an authorization code grant.
        """
        return pulumi.get(self, "authorization_url")

    @authorization_url.setter
    def authorization_url(self, value: pulumi.Input[str]):
        pulumi.set(self, "authorization_url", value)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> pulumi.Input[str]:
        """
        Unique identifier issued by AS for the Okta IdP instance.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> pulumi.Input[str]:
        """
        Client secret issued by AS for the Okta IdP instance.
        """
        return pulumi.get(self, "client_secret")

    @client_secret.setter
    def client_secret(self, value: pulumi.Input[str]):
        pulumi.set(self, "client_secret", value)

    @property
    @pulumi.getter(name="issuerUrl")
    def issuer_url(self) -> pulumi.Input[str]:
        """
        URI that identifies the issuer.
        """
        return pulumi.get(self, "issuer_url")

    @issuer_url.setter
    def issuer_url(self, value: pulumi.Input[str]):
        pulumi.set(self, "issuer_url", value)

    @property
    @pulumi.getter(name="jwksBinding")
    def jwks_binding(self) -> pulumi.Input[str]:
        """
        The method of making a request for the OIDC JWKS. It can be set to `HTTP-POST` or `HTTP-REDIRECT`
        """
        return pulumi.get(self, "jwks_binding")

    @jwks_binding.setter
    def jwks_binding(self, value: pulumi.Input[str]):
        pulumi.set(self, "jwks_binding", value)

    @property
    @pulumi.getter(name="jwksUrl")
    def jwks_url(self) -> pulumi.Input[str]:
        """
        Endpoint where the keys signer publishes its keys in a JWK Set.
        """
        return pulumi.get(self, "jwks_url")

    @jwks_url.setter
    def jwks_url(self, value: pulumi.Input[str]):
        pulumi.set(self, "jwks_url", value)

    @property
    @pulumi.getter
    def scopes(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        The scopes of the IdP.
        """
        return pulumi.get(self, "scopes")

    @scopes.setter
    def scopes(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "scopes", value)

    @property
    @pulumi.getter(name="tokenBinding")
    def token_binding(self) -> pulumi.Input[str]:
        """
        The method of making a token request. It can be set to `HTTP-POST` or `HTTP-REDIRECT`.
        """
        return pulumi.get(self, "token_binding")

    @token_binding.setter
    def token_binding(self, value: pulumi.Input[str]):
        pulumi.set(self, "token_binding", value)

    @property
    @pulumi.getter(name="tokenUrl")
    def token_url(self) -> pulumi.Input[str]:
        """
        IdP Authorization Server (AS) endpoint to exchange the authorization code grant for an access token.
        """
        return pulumi.get(self, "token_url")

    @token_url.setter
    def token_url(self, value: pulumi.Input[str]):
        pulumi.set(self, "token_url", value)

    @property
    @pulumi.getter(name="accountLinkAction")
    def account_link_action(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the account linking action for an IdP user. Default: `AUTO`
        """
        return pulumi.get(self, "account_link_action")

    @account_link_action.setter
    def account_link_action(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_link_action", value)

    @property
    @pulumi.getter(name="accountLinkGroupIncludes")
    def account_link_group_includes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Group memberships to determine link candidates.
        """
        return pulumi.get(self, "account_link_group_includes")

    @account_link_group_includes.setter
    def account_link_group_includes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "account_link_group_includes", value)

    @property
    @pulumi.getter(name="deprovisionedAction")
    def deprovisioned_action(self) -> Optional[pulumi.Input[str]]:
        """
        Action for a previously deprovisioned IdP user during authentication. Can be `NONE` or `REACTIVATE`. Default: `NONE`
        """
        return pulumi.get(self, "deprovisioned_action")

    @deprovisioned_action.setter
    def deprovisioned_action(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deprovisioned_action", value)

    @property
    @pulumi.getter(name="groupsAction")
    def groups_action(self) -> Optional[pulumi.Input[str]]:
        """
        Provisioning action for IdP user's group memberships. It can be `NONE`, `SYNC`, `APPEND`, or `ASSIGN`. Default: `NONE`
        """
        return pulumi.get(self, "groups_action")

    @groups_action.setter
    def groups_action(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "groups_action", value)

    @property
    @pulumi.getter(name="groupsAssignments")
    def groups_assignments(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of Okta Group IDs to add an IdP user as a member with the `ASSIGN` `groups_action`.
        """
        return pulumi.get(self, "groups_assignments")

    @groups_assignments.setter
    def groups_assignments(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "groups_assignments", value)

    @property
    @pulumi.getter(name="groupsAttribute")
    def groups_attribute(self) -> Optional[pulumi.Input[str]]:
        """
        IdP user profile attribute name (case-insensitive) for an array value that contains group memberships.
        """
        return pulumi.get(self, "groups_attribute")

    @groups_attribute.setter
    def groups_attribute(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "groups_attribute", value)

    @property
    @pulumi.getter(name="groupsFilters")
    def groups_filters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Whitelist of Okta Group identifiers that are allowed for the `APPEND` or `SYNC` `groups_action`.
        """
        return pulumi.get(self, "groups_filters")

    @groups_filters.setter
    def groups_filters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "groups_filters", value)

    @property
    @pulumi.getter(name="issuerMode")
    def issuer_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates whether Okta uses the original Okta org domain URL, a custom domain URL, or dynamic. It can be `ORG_URL`, `CUSTOM_URL`, or `DYNAMIC`. Default: `ORG_URL`
        """
        return pulumi.get(self, "issuer_mode")

    @issuer_mode.setter
    def issuer_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "issuer_mode", value)

    @property
    @pulumi.getter(name="maxClockSkew")
    def max_clock_skew(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum allowable clock-skew when processing messages from the IdP.
        """
        return pulumi.get(self, "max_clock_skew")

    @max_clock_skew.setter
    def max_clock_skew(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_clock_skew", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the IdP
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="pkceRequired")
    def pkce_required(self) -> Optional[pulumi.Input[bool]]:
        """
        Require Proof Key for Code Exchange (PKCE) for additional verification key rotation mode. See: https://developer.okta.com/docs/reference/api/idps/#oauth-2-0-and-openid-connect-client-object
        """
        return pulumi.get(self, "pkce_required")

    @pkce_required.setter
    def pkce_required(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "pkce_required", value)

    @property
    @pulumi.getter(name="profileMaster")
    def profile_master(self) -> Optional[pulumi.Input[bool]]:
        """
        Determines if the IdP should act as a source of truth for user profile attributes.
        """
        return pulumi.get(self, "profile_master")

    @profile_master.setter
    def profile_master(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "profile_master", value)

    @property
    @pulumi.getter(name="protocolType")
    def protocol_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of protocol to use. It can be `OIDC` or `OAUTH2`. Default: `OIDC`
        """
        return pulumi.get(self, "protocol_type")

    @protocol_type.setter
    def protocol_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protocol_type", value)

    @property
    @pulumi.getter(name="provisioningAction")
    def provisioning_action(self) -> Optional[pulumi.Input[str]]:
        """
        Provisioning action for an IdP user during authentication. Default: `AUTO`
        """
        return pulumi.get(self, "provisioning_action")

    @provisioning_action.setter
    def provisioning_action(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "provisioning_action", value)

    @property
    @pulumi.getter(name="requestSignatureAlgorithm")
    def request_signature_algorithm(self) -> Optional[pulumi.Input[str]]:
        """
        The HMAC Signature Algorithm used when signing an authorization request. Defaults to `HS256`. It can be `HS256`, `HS384`, `HS512`, `SHA-256`. `RS256`, `RS384`, or `RS512`. NOTE: `SHA-256` an undocumented legacy value and not continue to be valid. See API docs https://developer.okta.com/docs/reference/api/idps/#oidc-request-signature-algorithm-object
        """
        return pulumi.get(self, "request_signature_algorithm")

    @request_signature_algorithm.setter
    def request_signature_algorithm(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "request_signature_algorithm", value)

    @property
    @pulumi.getter(name="requestSignatureScope")
    def request_signature_scope(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies whether to digitally sign an AuthnRequest messages to the IdP. Defaults to `REQUEST`. It can be `REQUEST` or `NONE`.
        """
        return pulumi.get(self, "request_signature_scope")

    @request_signature_scope.setter
    def request_signature_scope(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "request_signature_scope", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Default to `ACTIVE`
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="subjectMatchAttribute")
    def subject_match_attribute(self) -> Optional[pulumi.Input[str]]:
        """
        Okta user profile attribute for matching transformed IdP username. Only for matchType `CUSTOM_ATTRIBUTE`.
        """
        return pulumi.get(self, "subject_match_attribute")

    @subject_match_attribute.setter
    def subject_match_attribute(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subject_match_attribute", value)

    @property
    @pulumi.getter(name="subjectMatchType")
    def subject_match_type(self) -> Optional[pulumi.Input[str]]:
        """
        Determines the Okta user profile attribute match conditions for account linking and authentication of the transformed IdP username. By default, it is set to `USERNAME`. It can be set to `USERNAME`, `EMAIL`, `USERNAME_OR_EMAIL` or `CUSTOM_ATTRIBUTE`.
        """
        return pulumi.get(self, "subject_match_type")

    @subject_match_type.setter
    def subject_match_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subject_match_type", value)

    @property
    @pulumi.getter(name="suspendedAction")
    def suspended_action(self) -> Optional[pulumi.Input[str]]:
        """
        Action for a previously suspended IdP user during authentication. Can be `NONE` or `REACTIVATE`. Default: `NONE`
        """
        return pulumi.get(self, "suspended_action")

    @suspended_action.setter
    def suspended_action(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "suspended_action", value)

    @property
    @pulumi.getter(name="userInfoBinding")
    def user_info_binding(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "user_info_binding")

    @user_info_binding.setter
    def user_info_binding(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_info_binding", value)

    @property
    @pulumi.getter(name="userInfoUrl")
    def user_info_url(self) -> Optional[pulumi.Input[str]]:
        """
        Protected resource endpoint that returns claims about the authenticated user.
        """
        return pulumi.get(self, "user_info_url")

    @user_info_url.setter
    def user_info_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_info_url", value)

    @property
    @pulumi.getter(name="usernameTemplate")
    def username_template(self) -> Optional[pulumi.Input[str]]:
        """
        Okta EL Expression to generate or transform a unique username for the IdP user. Default: `idpuser.email`
        """
        return pulumi.get(self, "username_template")

    @username_template.setter
    def username_template(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username_template", value)


@pulumi.input_type
class _OidcState:
    def __init__(__self__, *,
                 account_link_action: Optional[pulumi.Input[str]] = None,
                 account_link_group_includes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 authorization_binding: Optional[pulumi.Input[str]] = None,
                 authorization_url: Optional[pulumi.Input[str]] = None,
                 client_id: Optional[pulumi.Input[str]] = None,
                 client_secret: Optional[pulumi.Input[str]] = None,
                 deprovisioned_action: Optional[pulumi.Input[str]] = None,
                 groups_action: Optional[pulumi.Input[str]] = None,
                 groups_assignments: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 groups_attribute: Optional[pulumi.Input[str]] = None,
                 groups_filters: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 issuer_mode: Optional[pulumi.Input[str]] = None,
                 issuer_url: Optional[pulumi.Input[str]] = None,
                 jwks_binding: Optional[pulumi.Input[str]] = None,
                 jwks_url: Optional[pulumi.Input[str]] = None,
                 max_clock_skew: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 pkce_required: Optional[pulumi.Input[bool]] = None,
                 profile_master: Optional[pulumi.Input[bool]] = None,
                 protocol_type: Optional[pulumi.Input[str]] = None,
                 provisioning_action: Optional[pulumi.Input[str]] = None,
                 request_signature_algorithm: Optional[pulumi.Input[str]] = None,
                 request_signature_scope: Optional[pulumi.Input[str]] = None,
                 scopes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 subject_match_attribute: Optional[pulumi.Input[str]] = None,
                 subject_match_type: Optional[pulumi.Input[str]] = None,
                 suspended_action: Optional[pulumi.Input[str]] = None,
                 token_binding: Optional[pulumi.Input[str]] = None,
                 token_url: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 user_info_binding: Optional[pulumi.Input[str]] = None,
                 user_info_url: Optional[pulumi.Input[str]] = None,
                 user_type_id: Optional[pulumi.Input[str]] = None,
                 username_template: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Oidc resources.
        :param pulumi.Input[str] account_link_action: Specifies the account linking action for an IdP user. Default: `AUTO`
        :param pulumi.Input[Sequence[pulumi.Input[str]]] account_link_group_includes: Group memberships to determine link candidates.
        :param pulumi.Input[str] authorization_binding: The method of making an authorization request. It can be set to `HTTP-POST` or `HTTP-REDIRECT`.
        :param pulumi.Input[str] authorization_url: IdP Authorization Server (AS) endpoint to request consent from the user and obtain an authorization code grant.
        :param pulumi.Input[str] client_id: Unique identifier issued by AS for the Okta IdP instance.
        :param pulumi.Input[str] client_secret: Client secret issued by AS for the Okta IdP instance.
        :param pulumi.Input[str] deprovisioned_action: Action for a previously deprovisioned IdP user during authentication. Can be `NONE` or `REACTIVATE`. Default: `NONE`
        :param pulumi.Input[str] groups_action: Provisioning action for IdP user's group memberships. It can be `NONE`, `SYNC`, `APPEND`, or `ASSIGN`. Default: `NONE`
        :param pulumi.Input[Sequence[pulumi.Input[str]]] groups_assignments: List of Okta Group IDs to add an IdP user as a member with the `ASSIGN` `groups_action`.
        :param pulumi.Input[str] groups_attribute: IdP user profile attribute name (case-insensitive) for an array value that contains group memberships.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] groups_filters: Whitelist of Okta Group identifiers that are allowed for the `APPEND` or `SYNC` `groups_action`.
        :param pulumi.Input[str] issuer_mode: Indicates whether Okta uses the original Okta org domain URL, a custom domain URL, or dynamic. It can be `ORG_URL`, `CUSTOM_URL`, or `DYNAMIC`. Default: `ORG_URL`
        :param pulumi.Input[str] issuer_url: URI that identifies the issuer.
        :param pulumi.Input[str] jwks_binding: The method of making a request for the OIDC JWKS. It can be set to `HTTP-POST` or `HTTP-REDIRECT`
        :param pulumi.Input[str] jwks_url: Endpoint where the keys signer publishes its keys in a JWK Set.
        :param pulumi.Input[int] max_clock_skew: Maximum allowable clock-skew when processing messages from the IdP.
        :param pulumi.Input[str] name: Name of the IdP
        :param pulumi.Input[bool] pkce_required: Require Proof Key for Code Exchange (PKCE) for additional verification key rotation mode. See: https://developer.okta.com/docs/reference/api/idps/#oauth-2-0-and-openid-connect-client-object
        :param pulumi.Input[bool] profile_master: Determines if the IdP should act as a source of truth for user profile attributes.
        :param pulumi.Input[str] protocol_type: The type of protocol to use. It can be `OIDC` or `OAUTH2`. Default: `OIDC`
        :param pulumi.Input[str] provisioning_action: Provisioning action for an IdP user during authentication. Default: `AUTO`
        :param pulumi.Input[str] request_signature_algorithm: The HMAC Signature Algorithm used when signing an authorization request. Defaults to `HS256`. It can be `HS256`, `HS384`, `HS512`, `SHA-256`. `RS256`, `RS384`, or `RS512`. NOTE: `SHA-256` an undocumented legacy value and not continue to be valid. See API docs https://developer.okta.com/docs/reference/api/idps/#oidc-request-signature-algorithm-object
        :param pulumi.Input[str] request_signature_scope: Specifies whether to digitally sign an AuthnRequest messages to the IdP. Defaults to `REQUEST`. It can be `REQUEST` or `NONE`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] scopes: The scopes of the IdP.
        :param pulumi.Input[str] status: Default to `ACTIVE`
        :param pulumi.Input[str] subject_match_attribute: Okta user profile attribute for matching transformed IdP username. Only for matchType `CUSTOM_ATTRIBUTE`.
        :param pulumi.Input[str] subject_match_type: Determines the Okta user profile attribute match conditions for account linking and authentication of the transformed IdP username. By default, it is set to `USERNAME`. It can be set to `USERNAME`, `EMAIL`, `USERNAME_OR_EMAIL` or `CUSTOM_ATTRIBUTE`.
        :param pulumi.Input[str] suspended_action: Action for a previously suspended IdP user during authentication. Can be `NONE` or `REACTIVATE`. Default: `NONE`
        :param pulumi.Input[str] token_binding: The method of making a token request. It can be set to `HTTP-POST` or `HTTP-REDIRECT`.
        :param pulumi.Input[str] token_url: IdP Authorization Server (AS) endpoint to exchange the authorization code grant for an access token.
        :param pulumi.Input[str] type: Type of OIDC IdP.
        :param pulumi.Input[str] user_info_url: Protected resource endpoint that returns claims about the authenticated user.
        :param pulumi.Input[str] user_type_id: User type ID. Can be used as `target_id` in the `profile.Mapping` resource.
        :param pulumi.Input[str] username_template: Okta EL Expression to generate or transform a unique username for the IdP user. Default: `idpuser.email`
        """
        if account_link_action is not None:
            pulumi.set(__self__, "account_link_action", account_link_action)
        if account_link_group_includes is not None:
            pulumi.set(__self__, "account_link_group_includes", account_link_group_includes)
        if authorization_binding is not None:
            pulumi.set(__self__, "authorization_binding", authorization_binding)
        if authorization_url is not None:
            pulumi.set(__self__, "authorization_url", authorization_url)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)
        if deprovisioned_action is not None:
            pulumi.set(__self__, "deprovisioned_action", deprovisioned_action)
        if groups_action is not None:
            pulumi.set(__self__, "groups_action", groups_action)
        if groups_assignments is not None:
            pulumi.set(__self__, "groups_assignments", groups_assignments)
        if groups_attribute is not None:
            pulumi.set(__self__, "groups_attribute", groups_attribute)
        if groups_filters is not None:
            pulumi.set(__self__, "groups_filters", groups_filters)
        if issuer_mode is not None:
            pulumi.set(__self__, "issuer_mode", issuer_mode)
        if issuer_url is not None:
            pulumi.set(__self__, "issuer_url", issuer_url)
        if jwks_binding is not None:
            pulumi.set(__self__, "jwks_binding", jwks_binding)
        if jwks_url is not None:
            pulumi.set(__self__, "jwks_url", jwks_url)
        if max_clock_skew is not None:
            pulumi.set(__self__, "max_clock_skew", max_clock_skew)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if pkce_required is not None:
            pulumi.set(__self__, "pkce_required", pkce_required)
        if profile_master is not None:
            pulumi.set(__self__, "profile_master", profile_master)
        if protocol_type is not None:
            pulumi.set(__self__, "protocol_type", protocol_type)
        if provisioning_action is not None:
            pulumi.set(__self__, "provisioning_action", provisioning_action)
        if request_signature_algorithm is not None:
            pulumi.set(__self__, "request_signature_algorithm", request_signature_algorithm)
        if request_signature_scope is not None:
            pulumi.set(__self__, "request_signature_scope", request_signature_scope)
        if scopes is not None:
            pulumi.set(__self__, "scopes", scopes)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if subject_match_attribute is not None:
            pulumi.set(__self__, "subject_match_attribute", subject_match_attribute)
        if subject_match_type is not None:
            pulumi.set(__self__, "subject_match_type", subject_match_type)
        if suspended_action is not None:
            pulumi.set(__self__, "suspended_action", suspended_action)
        if token_binding is not None:
            pulumi.set(__self__, "token_binding", token_binding)
        if token_url is not None:
            pulumi.set(__self__, "token_url", token_url)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if user_info_binding is not None:
            pulumi.set(__self__, "user_info_binding", user_info_binding)
        if user_info_url is not None:
            pulumi.set(__self__, "user_info_url", user_info_url)
        if user_type_id is not None:
            pulumi.set(__self__, "user_type_id", user_type_id)
        if username_template is not None:
            pulumi.set(__self__, "username_template", username_template)

    @property
    @pulumi.getter(name="accountLinkAction")
    def account_link_action(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the account linking action for an IdP user. Default: `AUTO`
        """
        return pulumi.get(self, "account_link_action")

    @account_link_action.setter
    def account_link_action(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_link_action", value)

    @property
    @pulumi.getter(name="accountLinkGroupIncludes")
    def account_link_group_includes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Group memberships to determine link candidates.
        """
        return pulumi.get(self, "account_link_group_includes")

    @account_link_group_includes.setter
    def account_link_group_includes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "account_link_group_includes", value)

    @property
    @pulumi.getter(name="authorizationBinding")
    def authorization_binding(self) -> Optional[pulumi.Input[str]]:
        """
        The method of making an authorization request. It can be set to `HTTP-POST` or `HTTP-REDIRECT`.
        """
        return pulumi.get(self, "authorization_binding")

    @authorization_binding.setter
    def authorization_binding(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "authorization_binding", value)

    @property
    @pulumi.getter(name="authorizationUrl")
    def authorization_url(self) -> Optional[pulumi.Input[str]]:
        """
        IdP Authorization Server (AS) endpoint to request consent from the user and obtain an authorization code grant.
        """
        return pulumi.get(self, "authorization_url")

    @authorization_url.setter
    def authorization_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "authorization_url", value)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[pulumi.Input[str]]:
        """
        Unique identifier issued by AS for the Okta IdP instance.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[pulumi.Input[str]]:
        """
        Client secret issued by AS for the Okta IdP instance.
        """
        return pulumi.get(self, "client_secret")

    @client_secret.setter
    def client_secret(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_secret", value)

    @property
    @pulumi.getter(name="deprovisionedAction")
    def deprovisioned_action(self) -> Optional[pulumi.Input[str]]:
        """
        Action for a previously deprovisioned IdP user during authentication. Can be `NONE` or `REACTIVATE`. Default: `NONE`
        """
        return pulumi.get(self, "deprovisioned_action")

    @deprovisioned_action.setter
    def deprovisioned_action(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deprovisioned_action", value)

    @property
    @pulumi.getter(name="groupsAction")
    def groups_action(self) -> Optional[pulumi.Input[str]]:
        """
        Provisioning action for IdP user's group memberships. It can be `NONE`, `SYNC`, `APPEND`, or `ASSIGN`. Default: `NONE`
        """
        return pulumi.get(self, "groups_action")

    @groups_action.setter
    def groups_action(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "groups_action", value)

    @property
    @pulumi.getter(name="groupsAssignments")
    def groups_assignments(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of Okta Group IDs to add an IdP user as a member with the `ASSIGN` `groups_action`.
        """
        return pulumi.get(self, "groups_assignments")

    @groups_assignments.setter
    def groups_assignments(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "groups_assignments", value)

    @property
    @pulumi.getter(name="groupsAttribute")
    def groups_attribute(self) -> Optional[pulumi.Input[str]]:
        """
        IdP user profile attribute name (case-insensitive) for an array value that contains group memberships.
        """
        return pulumi.get(self, "groups_attribute")

    @groups_attribute.setter
    def groups_attribute(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "groups_attribute", value)

    @property
    @pulumi.getter(name="groupsFilters")
    def groups_filters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Whitelist of Okta Group identifiers that are allowed for the `APPEND` or `SYNC` `groups_action`.
        """
        return pulumi.get(self, "groups_filters")

    @groups_filters.setter
    def groups_filters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "groups_filters", value)

    @property
    @pulumi.getter(name="issuerMode")
    def issuer_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates whether Okta uses the original Okta org domain URL, a custom domain URL, or dynamic. It can be `ORG_URL`, `CUSTOM_URL`, or `DYNAMIC`. Default: `ORG_URL`
        """
        return pulumi.get(self, "issuer_mode")

    @issuer_mode.setter
    def issuer_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "issuer_mode", value)

    @property
    @pulumi.getter(name="issuerUrl")
    def issuer_url(self) -> Optional[pulumi.Input[str]]:
        """
        URI that identifies the issuer.
        """
        return pulumi.get(self, "issuer_url")

    @issuer_url.setter
    def issuer_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "issuer_url", value)

    @property
    @pulumi.getter(name="jwksBinding")
    def jwks_binding(self) -> Optional[pulumi.Input[str]]:
        """
        The method of making a request for the OIDC JWKS. It can be set to `HTTP-POST` or `HTTP-REDIRECT`
        """
        return pulumi.get(self, "jwks_binding")

    @jwks_binding.setter
    def jwks_binding(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "jwks_binding", value)

    @property
    @pulumi.getter(name="jwksUrl")
    def jwks_url(self) -> Optional[pulumi.Input[str]]:
        """
        Endpoint where the keys signer publishes its keys in a JWK Set.
        """
        return pulumi.get(self, "jwks_url")

    @jwks_url.setter
    def jwks_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "jwks_url", value)

    @property
    @pulumi.getter(name="maxClockSkew")
    def max_clock_skew(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum allowable clock-skew when processing messages from the IdP.
        """
        return pulumi.get(self, "max_clock_skew")

    @max_clock_skew.setter
    def max_clock_skew(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_clock_skew", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the IdP
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="pkceRequired")
    def pkce_required(self) -> Optional[pulumi.Input[bool]]:
        """
        Require Proof Key for Code Exchange (PKCE) for additional verification key rotation mode. See: https://developer.okta.com/docs/reference/api/idps/#oauth-2-0-and-openid-connect-client-object
        """
        return pulumi.get(self, "pkce_required")

    @pkce_required.setter
    def pkce_required(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "pkce_required", value)

    @property
    @pulumi.getter(name="profileMaster")
    def profile_master(self) -> Optional[pulumi.Input[bool]]:
        """
        Determines if the IdP should act as a source of truth for user profile attributes.
        """
        return pulumi.get(self, "profile_master")

    @profile_master.setter
    def profile_master(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "profile_master", value)

    @property
    @pulumi.getter(name="protocolType")
    def protocol_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of protocol to use. It can be `OIDC` or `OAUTH2`. Default: `OIDC`
        """
        return pulumi.get(self, "protocol_type")

    @protocol_type.setter
    def protocol_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protocol_type", value)

    @property
    @pulumi.getter(name="provisioningAction")
    def provisioning_action(self) -> Optional[pulumi.Input[str]]:
        """
        Provisioning action for an IdP user during authentication. Default: `AUTO`
        """
        return pulumi.get(self, "provisioning_action")

    @provisioning_action.setter
    def provisioning_action(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "provisioning_action", value)

    @property
    @pulumi.getter(name="requestSignatureAlgorithm")
    def request_signature_algorithm(self) -> Optional[pulumi.Input[str]]:
        """
        The HMAC Signature Algorithm used when signing an authorization request. Defaults to `HS256`. It can be `HS256`, `HS384`, `HS512`, `SHA-256`. `RS256`, `RS384`, or `RS512`. NOTE: `SHA-256` an undocumented legacy value and not continue to be valid. See API docs https://developer.okta.com/docs/reference/api/idps/#oidc-request-signature-algorithm-object
        """
        return pulumi.get(self, "request_signature_algorithm")

    @request_signature_algorithm.setter
    def request_signature_algorithm(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "request_signature_algorithm", value)

    @property
    @pulumi.getter(name="requestSignatureScope")
    def request_signature_scope(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies whether to digitally sign an AuthnRequest messages to the IdP. Defaults to `REQUEST`. It can be `REQUEST` or `NONE`.
        """
        return pulumi.get(self, "request_signature_scope")

    @request_signature_scope.setter
    def request_signature_scope(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "request_signature_scope", value)

    @property
    @pulumi.getter
    def scopes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The scopes of the IdP.
        """
        return pulumi.get(self, "scopes")

    @scopes.setter
    def scopes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "scopes", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Default to `ACTIVE`
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="subjectMatchAttribute")
    def subject_match_attribute(self) -> Optional[pulumi.Input[str]]:
        """
        Okta user profile attribute for matching transformed IdP username. Only for matchType `CUSTOM_ATTRIBUTE`.
        """
        return pulumi.get(self, "subject_match_attribute")

    @subject_match_attribute.setter
    def subject_match_attribute(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subject_match_attribute", value)

    @property
    @pulumi.getter(name="subjectMatchType")
    def subject_match_type(self) -> Optional[pulumi.Input[str]]:
        """
        Determines the Okta user profile attribute match conditions for account linking and authentication of the transformed IdP username. By default, it is set to `USERNAME`. It can be set to `USERNAME`, `EMAIL`, `USERNAME_OR_EMAIL` or `CUSTOM_ATTRIBUTE`.
        """
        return pulumi.get(self, "subject_match_type")

    @subject_match_type.setter
    def subject_match_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subject_match_type", value)

    @property
    @pulumi.getter(name="suspendedAction")
    def suspended_action(self) -> Optional[pulumi.Input[str]]:
        """
        Action for a previously suspended IdP user during authentication. Can be `NONE` or `REACTIVATE`. Default: `NONE`
        """
        return pulumi.get(self, "suspended_action")

    @suspended_action.setter
    def suspended_action(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "suspended_action", value)

    @property
    @pulumi.getter(name="tokenBinding")
    def token_binding(self) -> Optional[pulumi.Input[str]]:
        """
        The method of making a token request. It can be set to `HTTP-POST` or `HTTP-REDIRECT`.
        """
        return pulumi.get(self, "token_binding")

    @token_binding.setter
    def token_binding(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "token_binding", value)

    @property
    @pulumi.getter(name="tokenUrl")
    def token_url(self) -> Optional[pulumi.Input[str]]:
        """
        IdP Authorization Server (AS) endpoint to exchange the authorization code grant for an access token.
        """
        return pulumi.get(self, "token_url")

    @token_url.setter
    def token_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "token_url", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of OIDC IdP.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="userInfoBinding")
    def user_info_binding(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "user_info_binding")

    @user_info_binding.setter
    def user_info_binding(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_info_binding", value)

    @property
    @pulumi.getter(name="userInfoUrl")
    def user_info_url(self) -> Optional[pulumi.Input[str]]:
        """
        Protected resource endpoint that returns claims about the authenticated user.
        """
        return pulumi.get(self, "user_info_url")

    @user_info_url.setter
    def user_info_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_info_url", value)

    @property
    @pulumi.getter(name="userTypeId")
    def user_type_id(self) -> Optional[pulumi.Input[str]]:
        """
        User type ID. Can be used as `target_id` in the `profile.Mapping` resource.
        """
        return pulumi.get(self, "user_type_id")

    @user_type_id.setter
    def user_type_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_type_id", value)

    @property
    @pulumi.getter(name="usernameTemplate")
    def username_template(self) -> Optional[pulumi.Input[str]]:
        """
        Okta EL Expression to generate or transform a unique username for the IdP user. Default: `idpuser.email`
        """
        return pulumi.get(self, "username_template")

    @username_template.setter
    def username_template(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username_template", value)


class Oidc(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_link_action: Optional[pulumi.Input[str]] = None,
                 account_link_group_includes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 authorization_binding: Optional[pulumi.Input[str]] = None,
                 authorization_url: Optional[pulumi.Input[str]] = None,
                 client_id: Optional[pulumi.Input[str]] = None,
                 client_secret: Optional[pulumi.Input[str]] = None,
                 deprovisioned_action: Optional[pulumi.Input[str]] = None,
                 groups_action: Optional[pulumi.Input[str]] = None,
                 groups_assignments: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 groups_attribute: Optional[pulumi.Input[str]] = None,
                 groups_filters: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 issuer_mode: Optional[pulumi.Input[str]] = None,
                 issuer_url: Optional[pulumi.Input[str]] = None,
                 jwks_binding: Optional[pulumi.Input[str]] = None,
                 jwks_url: Optional[pulumi.Input[str]] = None,
                 max_clock_skew: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 pkce_required: Optional[pulumi.Input[bool]] = None,
                 profile_master: Optional[pulumi.Input[bool]] = None,
                 protocol_type: Optional[pulumi.Input[str]] = None,
                 provisioning_action: Optional[pulumi.Input[str]] = None,
                 request_signature_algorithm: Optional[pulumi.Input[str]] = None,
                 request_signature_scope: Optional[pulumi.Input[str]] = None,
                 scopes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 subject_match_attribute: Optional[pulumi.Input[str]] = None,
                 subject_match_type: Optional[pulumi.Input[str]] = None,
                 suspended_action: Optional[pulumi.Input[str]] = None,
                 token_binding: Optional[pulumi.Input[str]] = None,
                 token_url: Optional[pulumi.Input[str]] = None,
                 user_info_binding: Optional[pulumi.Input[str]] = None,
                 user_info_url: Optional[pulumi.Input[str]] = None,
                 username_template: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Creates an OIDC Identity Provider. This resource allows you to create and configure an OIDC Identity Provider.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_okta as okta

        example = okta.idp.Oidc("example",
            name="example",
            authorization_url="https://idp.example.com/authorize",
            authorization_binding="HTTP-REDIRECT",
            token_url="https://idp.example.com/token",
            token_binding="HTTP-POST",
            user_info_url="https://idp.example.com/userinfo",
            user_info_binding="HTTP-REDIRECT",
            jwks_url="https://idp.example.com/keys",
            jwks_binding="HTTP-REDIRECT",
            scopes=["openid"],
            client_id="efg456",
            client_secret="efg456",
            issuer_url="https://id.example.com",
            username_template="idpuser.email")
        ```

        ## Import

        ```sh
        $ pulumi import okta:idp/oidc:Oidc example <idp_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_link_action: Specifies the account linking action for an IdP user. Default: `AUTO`
        :param pulumi.Input[Sequence[pulumi.Input[str]]] account_link_group_includes: Group memberships to determine link candidates.
        :param pulumi.Input[str] authorization_binding: The method of making an authorization request. It can be set to `HTTP-POST` or `HTTP-REDIRECT`.
        :param pulumi.Input[str] authorization_url: IdP Authorization Server (AS) endpoint to request consent from the user and obtain an authorization code grant.
        :param pulumi.Input[str] client_id: Unique identifier issued by AS for the Okta IdP instance.
        :param pulumi.Input[str] client_secret: Client secret issued by AS for the Okta IdP instance.
        :param pulumi.Input[str] deprovisioned_action: Action for a previously deprovisioned IdP user during authentication. Can be `NONE` or `REACTIVATE`. Default: `NONE`
        :param pulumi.Input[str] groups_action: Provisioning action for IdP user's group memberships. It can be `NONE`, `SYNC`, `APPEND`, or `ASSIGN`. Default: `NONE`
        :param pulumi.Input[Sequence[pulumi.Input[str]]] groups_assignments: List of Okta Group IDs to add an IdP user as a member with the `ASSIGN` `groups_action`.
        :param pulumi.Input[str] groups_attribute: IdP user profile attribute name (case-insensitive) for an array value that contains group memberships.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] groups_filters: Whitelist of Okta Group identifiers that are allowed for the `APPEND` or `SYNC` `groups_action`.
        :param pulumi.Input[str] issuer_mode: Indicates whether Okta uses the original Okta org domain URL, a custom domain URL, or dynamic. It can be `ORG_URL`, `CUSTOM_URL`, or `DYNAMIC`. Default: `ORG_URL`
        :param pulumi.Input[str] issuer_url: URI that identifies the issuer.
        :param pulumi.Input[str] jwks_binding: The method of making a request for the OIDC JWKS. It can be set to `HTTP-POST` or `HTTP-REDIRECT`
        :param pulumi.Input[str] jwks_url: Endpoint where the keys signer publishes its keys in a JWK Set.
        :param pulumi.Input[int] max_clock_skew: Maximum allowable clock-skew when processing messages from the IdP.
        :param pulumi.Input[str] name: Name of the IdP
        :param pulumi.Input[bool] pkce_required: Require Proof Key for Code Exchange (PKCE) for additional verification key rotation mode. See: https://developer.okta.com/docs/reference/api/idps/#oauth-2-0-and-openid-connect-client-object
        :param pulumi.Input[bool] profile_master: Determines if the IdP should act as a source of truth for user profile attributes.
        :param pulumi.Input[str] protocol_type: The type of protocol to use. It can be `OIDC` or `OAUTH2`. Default: `OIDC`
        :param pulumi.Input[str] provisioning_action: Provisioning action for an IdP user during authentication. Default: `AUTO`
        :param pulumi.Input[str] request_signature_algorithm: The HMAC Signature Algorithm used when signing an authorization request. Defaults to `HS256`. It can be `HS256`, `HS384`, `HS512`, `SHA-256`. `RS256`, `RS384`, or `RS512`. NOTE: `SHA-256` an undocumented legacy value and not continue to be valid. See API docs https://developer.okta.com/docs/reference/api/idps/#oidc-request-signature-algorithm-object
        :param pulumi.Input[str] request_signature_scope: Specifies whether to digitally sign an AuthnRequest messages to the IdP. Defaults to `REQUEST`. It can be `REQUEST` or `NONE`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] scopes: The scopes of the IdP.
        :param pulumi.Input[str] status: Default to `ACTIVE`
        :param pulumi.Input[str] subject_match_attribute: Okta user profile attribute for matching transformed IdP username. Only for matchType `CUSTOM_ATTRIBUTE`.
        :param pulumi.Input[str] subject_match_type: Determines the Okta user profile attribute match conditions for account linking and authentication of the transformed IdP username. By default, it is set to `USERNAME`. It can be set to `USERNAME`, `EMAIL`, `USERNAME_OR_EMAIL` or `CUSTOM_ATTRIBUTE`.
        :param pulumi.Input[str] suspended_action: Action for a previously suspended IdP user during authentication. Can be `NONE` or `REACTIVATE`. Default: `NONE`
        :param pulumi.Input[str] token_binding: The method of making a token request. It can be set to `HTTP-POST` or `HTTP-REDIRECT`.
        :param pulumi.Input[str] token_url: IdP Authorization Server (AS) endpoint to exchange the authorization code grant for an access token.
        :param pulumi.Input[str] user_info_url: Protected resource endpoint that returns claims about the authenticated user.
        :param pulumi.Input[str] username_template: Okta EL Expression to generate or transform a unique username for the IdP user. Default: `idpuser.email`
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: OidcArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates an OIDC Identity Provider. This resource allows you to create and configure an OIDC Identity Provider.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_okta as okta

        example = okta.idp.Oidc("example",
            name="example",
            authorization_url="https://idp.example.com/authorize",
            authorization_binding="HTTP-REDIRECT",
            token_url="https://idp.example.com/token",
            token_binding="HTTP-POST",
            user_info_url="https://idp.example.com/userinfo",
            user_info_binding="HTTP-REDIRECT",
            jwks_url="https://idp.example.com/keys",
            jwks_binding="HTTP-REDIRECT",
            scopes=["openid"],
            client_id="efg456",
            client_secret="efg456",
            issuer_url="https://id.example.com",
            username_template="idpuser.email")
        ```

        ## Import

        ```sh
        $ pulumi import okta:idp/oidc:Oidc example <idp_id>
        ```

        :param str resource_name: The name of the resource.
        :param OidcArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OidcArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_link_action: Optional[pulumi.Input[str]] = None,
                 account_link_group_includes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 authorization_binding: Optional[pulumi.Input[str]] = None,
                 authorization_url: Optional[pulumi.Input[str]] = None,
                 client_id: Optional[pulumi.Input[str]] = None,
                 client_secret: Optional[pulumi.Input[str]] = None,
                 deprovisioned_action: Optional[pulumi.Input[str]] = None,
                 groups_action: Optional[pulumi.Input[str]] = None,
                 groups_assignments: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 groups_attribute: Optional[pulumi.Input[str]] = None,
                 groups_filters: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 issuer_mode: Optional[pulumi.Input[str]] = None,
                 issuer_url: Optional[pulumi.Input[str]] = None,
                 jwks_binding: Optional[pulumi.Input[str]] = None,
                 jwks_url: Optional[pulumi.Input[str]] = None,
                 max_clock_skew: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 pkce_required: Optional[pulumi.Input[bool]] = None,
                 profile_master: Optional[pulumi.Input[bool]] = None,
                 protocol_type: Optional[pulumi.Input[str]] = None,
                 provisioning_action: Optional[pulumi.Input[str]] = None,
                 request_signature_algorithm: Optional[pulumi.Input[str]] = None,
                 request_signature_scope: Optional[pulumi.Input[str]] = None,
                 scopes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 subject_match_attribute: Optional[pulumi.Input[str]] = None,
                 subject_match_type: Optional[pulumi.Input[str]] = None,
                 suspended_action: Optional[pulumi.Input[str]] = None,
                 token_binding: Optional[pulumi.Input[str]] = None,
                 token_url: Optional[pulumi.Input[str]] = None,
                 user_info_binding: Optional[pulumi.Input[str]] = None,
                 user_info_url: Optional[pulumi.Input[str]] = None,
                 username_template: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OidcArgs.__new__(OidcArgs)

            __props__.__dict__["account_link_action"] = account_link_action
            __props__.__dict__["account_link_group_includes"] = account_link_group_includes
            if authorization_binding is None and not opts.urn:
                raise TypeError("Missing required property 'authorization_binding'")
            __props__.__dict__["authorization_binding"] = authorization_binding
            if authorization_url is None and not opts.urn:
                raise TypeError("Missing required property 'authorization_url'")
            __props__.__dict__["authorization_url"] = authorization_url
            if client_id is None and not opts.urn:
                raise TypeError("Missing required property 'client_id'")
            __props__.__dict__["client_id"] = client_id
            if client_secret is None and not opts.urn:
                raise TypeError("Missing required property 'client_secret'")
            __props__.__dict__["client_secret"] = None if client_secret is None else pulumi.Output.secret(client_secret)
            __props__.__dict__["deprovisioned_action"] = deprovisioned_action
            __props__.__dict__["groups_action"] = groups_action
            __props__.__dict__["groups_assignments"] = groups_assignments
            __props__.__dict__["groups_attribute"] = groups_attribute
            __props__.__dict__["groups_filters"] = groups_filters
            __props__.__dict__["issuer_mode"] = issuer_mode
            if issuer_url is None and not opts.urn:
                raise TypeError("Missing required property 'issuer_url'")
            __props__.__dict__["issuer_url"] = issuer_url
            if jwks_binding is None and not opts.urn:
                raise TypeError("Missing required property 'jwks_binding'")
            __props__.__dict__["jwks_binding"] = jwks_binding
            if jwks_url is None and not opts.urn:
                raise TypeError("Missing required property 'jwks_url'")
            __props__.__dict__["jwks_url"] = jwks_url
            __props__.__dict__["max_clock_skew"] = max_clock_skew
            __props__.__dict__["name"] = name
            __props__.__dict__["pkce_required"] = pkce_required
            __props__.__dict__["profile_master"] = profile_master
            __props__.__dict__["protocol_type"] = protocol_type
            __props__.__dict__["provisioning_action"] = provisioning_action
            __props__.__dict__["request_signature_algorithm"] = request_signature_algorithm
            __props__.__dict__["request_signature_scope"] = request_signature_scope
            if scopes is None and not opts.urn:
                raise TypeError("Missing required property 'scopes'")
            __props__.__dict__["scopes"] = scopes
            __props__.__dict__["status"] = status
            __props__.__dict__["subject_match_attribute"] = subject_match_attribute
            __props__.__dict__["subject_match_type"] = subject_match_type
            __props__.__dict__["suspended_action"] = suspended_action
            if token_binding is None and not opts.urn:
                raise TypeError("Missing required property 'token_binding'")
            __props__.__dict__["token_binding"] = token_binding
            if token_url is None and not opts.urn:
                raise TypeError("Missing required property 'token_url'")
            __props__.__dict__["token_url"] = token_url
            __props__.__dict__["user_info_binding"] = user_info_binding
            __props__.__dict__["user_info_url"] = user_info_url
            __props__.__dict__["username_template"] = username_template
            __props__.__dict__["type"] = None
            __props__.__dict__["user_type_id"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["clientSecret"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Oidc, __self__).__init__(
            'okta:idp/oidc:Oidc',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_link_action: Optional[pulumi.Input[str]] = None,
            account_link_group_includes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            authorization_binding: Optional[pulumi.Input[str]] = None,
            authorization_url: Optional[pulumi.Input[str]] = None,
            client_id: Optional[pulumi.Input[str]] = None,
            client_secret: Optional[pulumi.Input[str]] = None,
            deprovisioned_action: Optional[pulumi.Input[str]] = None,
            groups_action: Optional[pulumi.Input[str]] = None,
            groups_assignments: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            groups_attribute: Optional[pulumi.Input[str]] = None,
            groups_filters: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            issuer_mode: Optional[pulumi.Input[str]] = None,
            issuer_url: Optional[pulumi.Input[str]] = None,
            jwks_binding: Optional[pulumi.Input[str]] = None,
            jwks_url: Optional[pulumi.Input[str]] = None,
            max_clock_skew: Optional[pulumi.Input[int]] = None,
            name: Optional[pulumi.Input[str]] = None,
            pkce_required: Optional[pulumi.Input[bool]] = None,
            profile_master: Optional[pulumi.Input[bool]] = None,
            protocol_type: Optional[pulumi.Input[str]] = None,
            provisioning_action: Optional[pulumi.Input[str]] = None,
            request_signature_algorithm: Optional[pulumi.Input[str]] = None,
            request_signature_scope: Optional[pulumi.Input[str]] = None,
            scopes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            status: Optional[pulumi.Input[str]] = None,
            subject_match_attribute: Optional[pulumi.Input[str]] = None,
            subject_match_type: Optional[pulumi.Input[str]] = None,
            suspended_action: Optional[pulumi.Input[str]] = None,
            token_binding: Optional[pulumi.Input[str]] = None,
            token_url: Optional[pulumi.Input[str]] = None,
            type: Optional[pulumi.Input[str]] = None,
            user_info_binding: Optional[pulumi.Input[str]] = None,
            user_info_url: Optional[pulumi.Input[str]] = None,
            user_type_id: Optional[pulumi.Input[str]] = None,
            username_template: Optional[pulumi.Input[str]] = None) -> 'Oidc':
        """
        Get an existing Oidc resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_link_action: Specifies the account linking action for an IdP user. Default: `AUTO`
        :param pulumi.Input[Sequence[pulumi.Input[str]]] account_link_group_includes: Group memberships to determine link candidates.
        :param pulumi.Input[str] authorization_binding: The method of making an authorization request. It can be set to `HTTP-POST` or `HTTP-REDIRECT`.
        :param pulumi.Input[str] authorization_url: IdP Authorization Server (AS) endpoint to request consent from the user and obtain an authorization code grant.
        :param pulumi.Input[str] client_id: Unique identifier issued by AS for the Okta IdP instance.
        :param pulumi.Input[str] client_secret: Client secret issued by AS for the Okta IdP instance.
        :param pulumi.Input[str] deprovisioned_action: Action for a previously deprovisioned IdP user during authentication. Can be `NONE` or `REACTIVATE`. Default: `NONE`
        :param pulumi.Input[str] groups_action: Provisioning action for IdP user's group memberships. It can be `NONE`, `SYNC`, `APPEND`, or `ASSIGN`. Default: `NONE`
        :param pulumi.Input[Sequence[pulumi.Input[str]]] groups_assignments: List of Okta Group IDs to add an IdP user as a member with the `ASSIGN` `groups_action`.
        :param pulumi.Input[str] groups_attribute: IdP user profile attribute name (case-insensitive) for an array value that contains group memberships.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] groups_filters: Whitelist of Okta Group identifiers that are allowed for the `APPEND` or `SYNC` `groups_action`.
        :param pulumi.Input[str] issuer_mode: Indicates whether Okta uses the original Okta org domain URL, a custom domain URL, or dynamic. It can be `ORG_URL`, `CUSTOM_URL`, or `DYNAMIC`. Default: `ORG_URL`
        :param pulumi.Input[str] issuer_url: URI that identifies the issuer.
        :param pulumi.Input[str] jwks_binding: The method of making a request for the OIDC JWKS. It can be set to `HTTP-POST` or `HTTP-REDIRECT`
        :param pulumi.Input[str] jwks_url: Endpoint where the keys signer publishes its keys in a JWK Set.
        :param pulumi.Input[int] max_clock_skew: Maximum allowable clock-skew when processing messages from the IdP.
        :param pulumi.Input[str] name: Name of the IdP
        :param pulumi.Input[bool] pkce_required: Require Proof Key for Code Exchange (PKCE) for additional verification key rotation mode. See: https://developer.okta.com/docs/reference/api/idps/#oauth-2-0-and-openid-connect-client-object
        :param pulumi.Input[bool] profile_master: Determines if the IdP should act as a source of truth for user profile attributes.
        :param pulumi.Input[str] protocol_type: The type of protocol to use. It can be `OIDC` or `OAUTH2`. Default: `OIDC`
        :param pulumi.Input[str] provisioning_action: Provisioning action for an IdP user during authentication. Default: `AUTO`
        :param pulumi.Input[str] request_signature_algorithm: The HMAC Signature Algorithm used when signing an authorization request. Defaults to `HS256`. It can be `HS256`, `HS384`, `HS512`, `SHA-256`. `RS256`, `RS384`, or `RS512`. NOTE: `SHA-256` an undocumented legacy value and not continue to be valid. See API docs https://developer.okta.com/docs/reference/api/idps/#oidc-request-signature-algorithm-object
        :param pulumi.Input[str] request_signature_scope: Specifies whether to digitally sign an AuthnRequest messages to the IdP. Defaults to `REQUEST`. It can be `REQUEST` or `NONE`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] scopes: The scopes of the IdP.
        :param pulumi.Input[str] status: Default to `ACTIVE`
        :param pulumi.Input[str] subject_match_attribute: Okta user profile attribute for matching transformed IdP username. Only for matchType `CUSTOM_ATTRIBUTE`.
        :param pulumi.Input[str] subject_match_type: Determines the Okta user profile attribute match conditions for account linking and authentication of the transformed IdP username. By default, it is set to `USERNAME`. It can be set to `USERNAME`, `EMAIL`, `USERNAME_OR_EMAIL` or `CUSTOM_ATTRIBUTE`.
        :param pulumi.Input[str] suspended_action: Action for a previously suspended IdP user during authentication. Can be `NONE` or `REACTIVATE`. Default: `NONE`
        :param pulumi.Input[str] token_binding: The method of making a token request. It can be set to `HTTP-POST` or `HTTP-REDIRECT`.
        :param pulumi.Input[str] token_url: IdP Authorization Server (AS) endpoint to exchange the authorization code grant for an access token.
        :param pulumi.Input[str] type: Type of OIDC IdP.
        :param pulumi.Input[str] user_info_url: Protected resource endpoint that returns claims about the authenticated user.
        :param pulumi.Input[str] user_type_id: User type ID. Can be used as `target_id` in the `profile.Mapping` resource.
        :param pulumi.Input[str] username_template: Okta EL Expression to generate or transform a unique username for the IdP user. Default: `idpuser.email`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _OidcState.__new__(_OidcState)

        __props__.__dict__["account_link_action"] = account_link_action
        __props__.__dict__["account_link_group_includes"] = account_link_group_includes
        __props__.__dict__["authorization_binding"] = authorization_binding
        __props__.__dict__["authorization_url"] = authorization_url
        __props__.__dict__["client_id"] = client_id
        __props__.__dict__["client_secret"] = client_secret
        __props__.__dict__["deprovisioned_action"] = deprovisioned_action
        __props__.__dict__["groups_action"] = groups_action
        __props__.__dict__["groups_assignments"] = groups_assignments
        __props__.__dict__["groups_attribute"] = groups_attribute
        __props__.__dict__["groups_filters"] = groups_filters
        __props__.__dict__["issuer_mode"] = issuer_mode
        __props__.__dict__["issuer_url"] = issuer_url
        __props__.__dict__["jwks_binding"] = jwks_binding
        __props__.__dict__["jwks_url"] = jwks_url
        __props__.__dict__["max_clock_skew"] = max_clock_skew
        __props__.__dict__["name"] = name
        __props__.__dict__["pkce_required"] = pkce_required
        __props__.__dict__["profile_master"] = profile_master
        __props__.__dict__["protocol_type"] = protocol_type
        __props__.__dict__["provisioning_action"] = provisioning_action
        __props__.__dict__["request_signature_algorithm"] = request_signature_algorithm
        __props__.__dict__["request_signature_scope"] = request_signature_scope
        __props__.__dict__["scopes"] = scopes
        __props__.__dict__["status"] = status
        __props__.__dict__["subject_match_attribute"] = subject_match_attribute
        __props__.__dict__["subject_match_type"] = subject_match_type
        __props__.__dict__["suspended_action"] = suspended_action
        __props__.__dict__["token_binding"] = token_binding
        __props__.__dict__["token_url"] = token_url
        __props__.__dict__["type"] = type
        __props__.__dict__["user_info_binding"] = user_info_binding
        __props__.__dict__["user_info_url"] = user_info_url
        __props__.__dict__["user_type_id"] = user_type_id
        __props__.__dict__["username_template"] = username_template
        return Oidc(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountLinkAction")
    def account_link_action(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the account linking action for an IdP user. Default: `AUTO`
        """
        return pulumi.get(self, "account_link_action")

    @property
    @pulumi.getter(name="accountLinkGroupIncludes")
    def account_link_group_includes(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Group memberships to determine link candidates.
        """
        return pulumi.get(self, "account_link_group_includes")

    @property
    @pulumi.getter(name="authorizationBinding")
    def authorization_binding(self) -> pulumi.Output[str]:
        """
        The method of making an authorization request. It can be set to `HTTP-POST` or `HTTP-REDIRECT`.
        """
        return pulumi.get(self, "authorization_binding")

    @property
    @pulumi.getter(name="authorizationUrl")
    def authorization_url(self) -> pulumi.Output[str]:
        """
        IdP Authorization Server (AS) endpoint to request consent from the user and obtain an authorization code grant.
        """
        return pulumi.get(self, "authorization_url")

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> pulumi.Output[str]:
        """
        Unique identifier issued by AS for the Okta IdP instance.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> pulumi.Output[str]:
        """
        Client secret issued by AS for the Okta IdP instance.
        """
        return pulumi.get(self, "client_secret")

    @property
    @pulumi.getter(name="deprovisionedAction")
    def deprovisioned_action(self) -> pulumi.Output[Optional[str]]:
        """
        Action for a previously deprovisioned IdP user during authentication. Can be `NONE` or `REACTIVATE`. Default: `NONE`
        """
        return pulumi.get(self, "deprovisioned_action")

    @property
    @pulumi.getter(name="groupsAction")
    def groups_action(self) -> pulumi.Output[Optional[str]]:
        """
        Provisioning action for IdP user's group memberships. It can be `NONE`, `SYNC`, `APPEND`, or `ASSIGN`. Default: `NONE`
        """
        return pulumi.get(self, "groups_action")

    @property
    @pulumi.getter(name="groupsAssignments")
    def groups_assignments(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of Okta Group IDs to add an IdP user as a member with the `ASSIGN` `groups_action`.
        """
        return pulumi.get(self, "groups_assignments")

    @property
    @pulumi.getter(name="groupsAttribute")
    def groups_attribute(self) -> pulumi.Output[Optional[str]]:
        """
        IdP user profile attribute name (case-insensitive) for an array value that contains group memberships.
        """
        return pulumi.get(self, "groups_attribute")

    @property
    @pulumi.getter(name="groupsFilters")
    def groups_filters(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Whitelist of Okta Group identifiers that are allowed for the `APPEND` or `SYNC` `groups_action`.
        """
        return pulumi.get(self, "groups_filters")

    @property
    @pulumi.getter(name="issuerMode")
    def issuer_mode(self) -> pulumi.Output[Optional[str]]:
        """
        Indicates whether Okta uses the original Okta org domain URL, a custom domain URL, or dynamic. It can be `ORG_URL`, `CUSTOM_URL`, or `DYNAMIC`. Default: `ORG_URL`
        """
        return pulumi.get(self, "issuer_mode")

    @property
    @pulumi.getter(name="issuerUrl")
    def issuer_url(self) -> pulumi.Output[str]:
        """
        URI that identifies the issuer.
        """
        return pulumi.get(self, "issuer_url")

    @property
    @pulumi.getter(name="jwksBinding")
    def jwks_binding(self) -> pulumi.Output[str]:
        """
        The method of making a request for the OIDC JWKS. It can be set to `HTTP-POST` or `HTTP-REDIRECT`
        """
        return pulumi.get(self, "jwks_binding")

    @property
    @pulumi.getter(name="jwksUrl")
    def jwks_url(self) -> pulumi.Output[str]:
        """
        Endpoint where the keys signer publishes its keys in a JWK Set.
        """
        return pulumi.get(self, "jwks_url")

    @property
    @pulumi.getter(name="maxClockSkew")
    def max_clock_skew(self) -> pulumi.Output[Optional[int]]:
        """
        Maximum allowable clock-skew when processing messages from the IdP.
        """
        return pulumi.get(self, "max_clock_skew")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the IdP
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="pkceRequired")
    def pkce_required(self) -> pulumi.Output[Optional[bool]]:
        """
        Require Proof Key for Code Exchange (PKCE) for additional verification key rotation mode. See: https://developer.okta.com/docs/reference/api/idps/#oauth-2-0-and-openid-connect-client-object
        """
        return pulumi.get(self, "pkce_required")

    @property
    @pulumi.getter(name="profileMaster")
    def profile_master(self) -> pulumi.Output[Optional[bool]]:
        """
        Determines if the IdP should act as a source of truth for user profile attributes.
        """
        return pulumi.get(self, "profile_master")

    @property
    @pulumi.getter(name="protocolType")
    def protocol_type(self) -> pulumi.Output[Optional[str]]:
        """
        The type of protocol to use. It can be `OIDC` or `OAUTH2`. Default: `OIDC`
        """
        return pulumi.get(self, "protocol_type")

    @property
    @pulumi.getter(name="provisioningAction")
    def provisioning_action(self) -> pulumi.Output[Optional[str]]:
        """
        Provisioning action for an IdP user during authentication. Default: `AUTO`
        """
        return pulumi.get(self, "provisioning_action")

    @property
    @pulumi.getter(name="requestSignatureAlgorithm")
    def request_signature_algorithm(self) -> pulumi.Output[Optional[str]]:
        """
        The HMAC Signature Algorithm used when signing an authorization request. Defaults to `HS256`. It can be `HS256`, `HS384`, `HS512`, `SHA-256`. `RS256`, `RS384`, or `RS512`. NOTE: `SHA-256` an undocumented legacy value and not continue to be valid. See API docs https://developer.okta.com/docs/reference/api/idps/#oidc-request-signature-algorithm-object
        """
        return pulumi.get(self, "request_signature_algorithm")

    @property
    @pulumi.getter(name="requestSignatureScope")
    def request_signature_scope(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies whether to digitally sign an AuthnRequest messages to the IdP. Defaults to `REQUEST`. It can be `REQUEST` or `NONE`.
        """
        return pulumi.get(self, "request_signature_scope")

    @property
    @pulumi.getter
    def scopes(self) -> pulumi.Output[Sequence[str]]:
        """
        The scopes of the IdP.
        """
        return pulumi.get(self, "scopes")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[Optional[str]]:
        """
        Default to `ACTIVE`
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="subjectMatchAttribute")
    def subject_match_attribute(self) -> pulumi.Output[Optional[str]]:
        """
        Okta user profile attribute for matching transformed IdP username. Only for matchType `CUSTOM_ATTRIBUTE`.
        """
        return pulumi.get(self, "subject_match_attribute")

    @property
    @pulumi.getter(name="subjectMatchType")
    def subject_match_type(self) -> pulumi.Output[Optional[str]]:
        """
        Determines the Okta user profile attribute match conditions for account linking and authentication of the transformed IdP username. By default, it is set to `USERNAME`. It can be set to `USERNAME`, `EMAIL`, `USERNAME_OR_EMAIL` or `CUSTOM_ATTRIBUTE`.
        """
        return pulumi.get(self, "subject_match_type")

    @property
    @pulumi.getter(name="suspendedAction")
    def suspended_action(self) -> pulumi.Output[Optional[str]]:
        """
        Action for a previously suspended IdP user during authentication. Can be `NONE` or `REACTIVATE`. Default: `NONE`
        """
        return pulumi.get(self, "suspended_action")

    @property
    @pulumi.getter(name="tokenBinding")
    def token_binding(self) -> pulumi.Output[str]:
        """
        The method of making a token request. It can be set to `HTTP-POST` or `HTTP-REDIRECT`.
        """
        return pulumi.get(self, "token_binding")

    @property
    @pulumi.getter(name="tokenUrl")
    def token_url(self) -> pulumi.Output[str]:
        """
        IdP Authorization Server (AS) endpoint to exchange the authorization code grant for an access token.
        """
        return pulumi.get(self, "token_url")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        Type of OIDC IdP.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="userInfoBinding")
    def user_info_binding(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "user_info_binding")

    @property
    @pulumi.getter(name="userInfoUrl")
    def user_info_url(self) -> pulumi.Output[Optional[str]]:
        """
        Protected resource endpoint that returns claims about the authenticated user.
        """
        return pulumi.get(self, "user_info_url")

    @property
    @pulumi.getter(name="userTypeId")
    def user_type_id(self) -> pulumi.Output[str]:
        """
        User type ID. Can be used as `target_id` in the `profile.Mapping` resource.
        """
        return pulumi.get(self, "user_type_id")

    @property
    @pulumi.getter(name="usernameTemplate")
    def username_template(self) -> pulumi.Output[Optional[str]]:
        """
        Okta EL Expression to generate or transform a unique username for the IdP user. Default: `idpuser.email`
        """
        return pulumi.get(self, "username_template")

