# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['LinkDefinitionArgs', 'LinkDefinition']

@pulumi.input_type
class LinkDefinitionArgs:
    def __init__(__self__, *,
                 associated_description: pulumi.Input[str],
                 associated_name: pulumi.Input[str],
                 associated_title: pulumi.Input[str],
                 primary_description: pulumi.Input[str],
                 primary_name: pulumi.Input[str],
                 primary_title: pulumi.Input[str]):
        """
        The set of arguments for constructing a LinkDefinition resource.
        :param pulumi.Input[str] associated_description: Description of the associated relationship.
        :param pulumi.Input[str] associated_name: API name of the associated link.
        :param pulumi.Input[str] associated_title: Display name of the associated link.
        :param pulumi.Input[str] primary_description: Description of the primary relationship.
        :param pulumi.Input[str] primary_name: API name of the primary link.
        :param pulumi.Input[str] primary_title: Display name of the primary link.
        """
        pulumi.set(__self__, "associated_description", associated_description)
        pulumi.set(__self__, "associated_name", associated_name)
        pulumi.set(__self__, "associated_title", associated_title)
        pulumi.set(__self__, "primary_description", primary_description)
        pulumi.set(__self__, "primary_name", primary_name)
        pulumi.set(__self__, "primary_title", primary_title)

    @property
    @pulumi.getter(name="associatedDescription")
    def associated_description(self) -> pulumi.Input[str]:
        """
        Description of the associated relationship.
        """
        return pulumi.get(self, "associated_description")

    @associated_description.setter
    def associated_description(self, value: pulumi.Input[str]):
        pulumi.set(self, "associated_description", value)

    @property
    @pulumi.getter(name="associatedName")
    def associated_name(self) -> pulumi.Input[str]:
        """
        API name of the associated link.
        """
        return pulumi.get(self, "associated_name")

    @associated_name.setter
    def associated_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "associated_name", value)

    @property
    @pulumi.getter(name="associatedTitle")
    def associated_title(self) -> pulumi.Input[str]:
        """
        Display name of the associated link.
        """
        return pulumi.get(self, "associated_title")

    @associated_title.setter
    def associated_title(self, value: pulumi.Input[str]):
        pulumi.set(self, "associated_title", value)

    @property
    @pulumi.getter(name="primaryDescription")
    def primary_description(self) -> pulumi.Input[str]:
        """
        Description of the primary relationship.
        """
        return pulumi.get(self, "primary_description")

    @primary_description.setter
    def primary_description(self, value: pulumi.Input[str]):
        pulumi.set(self, "primary_description", value)

    @property
    @pulumi.getter(name="primaryName")
    def primary_name(self) -> pulumi.Input[str]:
        """
        API name of the primary link.
        """
        return pulumi.get(self, "primary_name")

    @primary_name.setter
    def primary_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "primary_name", value)

    @property
    @pulumi.getter(name="primaryTitle")
    def primary_title(self) -> pulumi.Input[str]:
        """
        Display name of the primary link.
        """
        return pulumi.get(self, "primary_title")

    @primary_title.setter
    def primary_title(self, value: pulumi.Input[str]):
        pulumi.set(self, "primary_title", value)


@pulumi.input_type
class _LinkDefinitionState:
    def __init__(__self__, *,
                 associated_description: Optional[pulumi.Input[str]] = None,
                 associated_name: Optional[pulumi.Input[str]] = None,
                 associated_title: Optional[pulumi.Input[str]] = None,
                 primary_description: Optional[pulumi.Input[str]] = None,
                 primary_name: Optional[pulumi.Input[str]] = None,
                 primary_title: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering LinkDefinition resources.
        :param pulumi.Input[str] associated_description: Description of the associated relationship.
        :param pulumi.Input[str] associated_name: API name of the associated link.
        :param pulumi.Input[str] associated_title: Display name of the associated link.
        :param pulumi.Input[str] primary_description: Description of the primary relationship.
        :param pulumi.Input[str] primary_name: API name of the primary link.
        :param pulumi.Input[str] primary_title: Display name of the primary link.
        """
        if associated_description is not None:
            pulumi.set(__self__, "associated_description", associated_description)
        if associated_name is not None:
            pulumi.set(__self__, "associated_name", associated_name)
        if associated_title is not None:
            pulumi.set(__self__, "associated_title", associated_title)
        if primary_description is not None:
            pulumi.set(__self__, "primary_description", primary_description)
        if primary_name is not None:
            pulumi.set(__self__, "primary_name", primary_name)
        if primary_title is not None:
            pulumi.set(__self__, "primary_title", primary_title)

    @property
    @pulumi.getter(name="associatedDescription")
    def associated_description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the associated relationship.
        """
        return pulumi.get(self, "associated_description")

    @associated_description.setter
    def associated_description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "associated_description", value)

    @property
    @pulumi.getter(name="associatedName")
    def associated_name(self) -> Optional[pulumi.Input[str]]:
        """
        API name of the associated link.
        """
        return pulumi.get(self, "associated_name")

    @associated_name.setter
    def associated_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "associated_name", value)

    @property
    @pulumi.getter(name="associatedTitle")
    def associated_title(self) -> Optional[pulumi.Input[str]]:
        """
        Display name of the associated link.
        """
        return pulumi.get(self, "associated_title")

    @associated_title.setter
    def associated_title(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "associated_title", value)

    @property
    @pulumi.getter(name="primaryDescription")
    def primary_description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the primary relationship.
        """
        return pulumi.get(self, "primary_description")

    @primary_description.setter
    def primary_description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "primary_description", value)

    @property
    @pulumi.getter(name="primaryName")
    def primary_name(self) -> Optional[pulumi.Input[str]]:
        """
        API name of the primary link.
        """
        return pulumi.get(self, "primary_name")

    @primary_name.setter
    def primary_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "primary_name", value)

    @property
    @pulumi.getter(name="primaryTitle")
    def primary_title(self) -> Optional[pulumi.Input[str]]:
        """
        Display name of the primary link.
        """
        return pulumi.get(self, "primary_title")

    @primary_title.setter
    def primary_title(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "primary_title", value)


class LinkDefinition(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 associated_description: Optional[pulumi.Input[str]] = None,
                 associated_name: Optional[pulumi.Input[str]] = None,
                 associated_title: Optional[pulumi.Input[str]] = None,
                 primary_description: Optional[pulumi.Input[str]] = None,
                 primary_name: Optional[pulumi.Input[str]] = None,
                 primary_title: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manages the creation and removal of the link definitions.

        Link definition operations allow you to manage the creation and removal of the link definitions. If you remove a link
        definition, links based on that definition are unavailable. Note that this resource is immutable, thus can not be modified.
        > **NOTE:** Links reappear if you recreate the definition. However, Okta is likely to change this behavior so that links don't reappear. Don't rely on this behavior in production environments.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_okta as okta

        example = okta.LinkDefinition("example",
            primary_name="emperor",
            primary_title="Emperor",
            primary_description="Hereditary ruler of the Imperium and the Known Universe",
            associated_name="sardaukar",
            associated_title="Sardaukar",
            associated_description="Elite military force member")
        ```

        ## Import

        ```sh
        $ pulumi import okta:index/linkDefinition:LinkDefinition example <primary_name>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] associated_description: Description of the associated relationship.
        :param pulumi.Input[str] associated_name: API name of the associated link.
        :param pulumi.Input[str] associated_title: Display name of the associated link.
        :param pulumi.Input[str] primary_description: Description of the primary relationship.
        :param pulumi.Input[str] primary_name: API name of the primary link.
        :param pulumi.Input[str] primary_title: Display name of the primary link.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LinkDefinitionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages the creation and removal of the link definitions.

        Link definition operations allow you to manage the creation and removal of the link definitions. If you remove a link
        definition, links based on that definition are unavailable. Note that this resource is immutable, thus can not be modified.
        > **NOTE:** Links reappear if you recreate the definition. However, Okta is likely to change this behavior so that links don't reappear. Don't rely on this behavior in production environments.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_okta as okta

        example = okta.LinkDefinition("example",
            primary_name="emperor",
            primary_title="Emperor",
            primary_description="Hereditary ruler of the Imperium and the Known Universe",
            associated_name="sardaukar",
            associated_title="Sardaukar",
            associated_description="Elite military force member")
        ```

        ## Import

        ```sh
        $ pulumi import okta:index/linkDefinition:LinkDefinition example <primary_name>
        ```

        :param str resource_name: The name of the resource.
        :param LinkDefinitionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LinkDefinitionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 associated_description: Optional[pulumi.Input[str]] = None,
                 associated_name: Optional[pulumi.Input[str]] = None,
                 associated_title: Optional[pulumi.Input[str]] = None,
                 primary_description: Optional[pulumi.Input[str]] = None,
                 primary_name: Optional[pulumi.Input[str]] = None,
                 primary_title: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LinkDefinitionArgs.__new__(LinkDefinitionArgs)

            if associated_description is None and not opts.urn:
                raise TypeError("Missing required property 'associated_description'")
            __props__.__dict__["associated_description"] = associated_description
            if associated_name is None and not opts.urn:
                raise TypeError("Missing required property 'associated_name'")
            __props__.__dict__["associated_name"] = associated_name
            if associated_title is None and not opts.urn:
                raise TypeError("Missing required property 'associated_title'")
            __props__.__dict__["associated_title"] = associated_title
            if primary_description is None and not opts.urn:
                raise TypeError("Missing required property 'primary_description'")
            __props__.__dict__["primary_description"] = primary_description
            if primary_name is None and not opts.urn:
                raise TypeError("Missing required property 'primary_name'")
            __props__.__dict__["primary_name"] = primary_name
            if primary_title is None and not opts.urn:
                raise TypeError("Missing required property 'primary_title'")
            __props__.__dict__["primary_title"] = primary_title
        super(LinkDefinition, __self__).__init__(
            'okta:index/linkDefinition:LinkDefinition',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            associated_description: Optional[pulumi.Input[str]] = None,
            associated_name: Optional[pulumi.Input[str]] = None,
            associated_title: Optional[pulumi.Input[str]] = None,
            primary_description: Optional[pulumi.Input[str]] = None,
            primary_name: Optional[pulumi.Input[str]] = None,
            primary_title: Optional[pulumi.Input[str]] = None) -> 'LinkDefinition':
        """
        Get an existing LinkDefinition resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] associated_description: Description of the associated relationship.
        :param pulumi.Input[str] associated_name: API name of the associated link.
        :param pulumi.Input[str] associated_title: Display name of the associated link.
        :param pulumi.Input[str] primary_description: Description of the primary relationship.
        :param pulumi.Input[str] primary_name: API name of the primary link.
        :param pulumi.Input[str] primary_title: Display name of the primary link.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LinkDefinitionState.__new__(_LinkDefinitionState)

        __props__.__dict__["associated_description"] = associated_description
        __props__.__dict__["associated_name"] = associated_name
        __props__.__dict__["associated_title"] = associated_title
        __props__.__dict__["primary_description"] = primary_description
        __props__.__dict__["primary_name"] = primary_name
        __props__.__dict__["primary_title"] = primary_title
        return LinkDefinition(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="associatedDescription")
    def associated_description(self) -> pulumi.Output[str]:
        """
        Description of the associated relationship.
        """
        return pulumi.get(self, "associated_description")

    @property
    @pulumi.getter(name="associatedName")
    def associated_name(self) -> pulumi.Output[str]:
        """
        API name of the associated link.
        """
        return pulumi.get(self, "associated_name")

    @property
    @pulumi.getter(name="associatedTitle")
    def associated_title(self) -> pulumi.Output[str]:
        """
        Display name of the associated link.
        """
        return pulumi.get(self, "associated_title")

    @property
    @pulumi.getter(name="primaryDescription")
    def primary_description(self) -> pulumi.Output[str]:
        """
        Description of the primary relationship.
        """
        return pulumi.get(self, "primary_description")

    @property
    @pulumi.getter(name="primaryName")
    def primary_name(self) -> pulumi.Output[str]:
        """
        API name of the primary link.
        """
        return pulumi.get(self, "primary_name")

    @property
    @pulumi.getter(name="primaryTitle")
    def primary_title(self) -> pulumi.Output[str]:
        """
        Display name of the primary link.
        """
        return pulumi.get(self, "primary_title")

