# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['PolicyMfaDefaultArgs', 'PolicyMfaDefault']

@pulumi.input_type
class PolicyMfaDefaultArgs:
    def __init__(__self__, *,
                 duo: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 external_idp: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 external_idps: Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[str]]]]]] = None,
                 fido_u2f: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 fido_webauthn: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 google_otp: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 hotp: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 is_oie: Optional[pulumi.Input[bool]] = None,
                 okta_call: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 okta_email: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 okta_otp: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 okta_password: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 okta_push: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 okta_question: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 okta_sms: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 okta_verify: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 onprem_mfa: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 phone_number: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 rsa_token: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 security_question: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 symantec_vip: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 webauthn: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 yubikey_token: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a PolicyMfaDefault resource.
        :param pulumi.Input[bool] is_oie: Is the policy using Okta Identity Engine (OIE) with authenticators instead of factors?
        """
        if duo is not None:
            pulumi.set(__self__, "duo", duo)
        if external_idp is not None:
            warnings.warn("""Since okta now support multiple external_idps, this will be deprecated. Please use `external_idps` instead""", DeprecationWarning)
            pulumi.log.warn("""external_idp is deprecated: Since okta now support multiple external_idps, this will be deprecated. Please use `external_idps` instead""")
        if external_idp is not None:
            pulumi.set(__self__, "external_idp", external_idp)
        if external_idps is not None:
            pulumi.set(__self__, "external_idps", external_idps)
        if fido_u2f is not None:
            pulumi.set(__self__, "fido_u2f", fido_u2f)
        if fido_webauthn is not None:
            pulumi.set(__self__, "fido_webauthn", fido_webauthn)
        if google_otp is not None:
            pulumi.set(__self__, "google_otp", google_otp)
        if hotp is not None:
            pulumi.set(__self__, "hotp", hotp)
        if is_oie is not None:
            pulumi.set(__self__, "is_oie", is_oie)
        if okta_call is not None:
            pulumi.set(__self__, "okta_call", okta_call)
        if okta_email is not None:
            pulumi.set(__self__, "okta_email", okta_email)
        if okta_otp is not None:
            pulumi.set(__self__, "okta_otp", okta_otp)
        if okta_password is not None:
            pulumi.set(__self__, "okta_password", okta_password)
        if okta_push is not None:
            pulumi.set(__self__, "okta_push", okta_push)
        if okta_question is not None:
            pulumi.set(__self__, "okta_question", okta_question)
        if okta_sms is not None:
            pulumi.set(__self__, "okta_sms", okta_sms)
        if okta_verify is not None:
            pulumi.set(__self__, "okta_verify", okta_verify)
        if onprem_mfa is not None:
            pulumi.set(__self__, "onprem_mfa", onprem_mfa)
        if phone_number is not None:
            pulumi.set(__self__, "phone_number", phone_number)
        if rsa_token is not None:
            pulumi.set(__self__, "rsa_token", rsa_token)
        if security_question is not None:
            pulumi.set(__self__, "security_question", security_question)
        if symantec_vip is not None:
            pulumi.set(__self__, "symantec_vip", symantec_vip)
        if webauthn is not None:
            pulumi.set(__self__, "webauthn", webauthn)
        if yubikey_token is not None:
            pulumi.set(__self__, "yubikey_token", yubikey_token)

    @property
    @pulumi.getter
    def duo(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        return pulumi.get(self, "duo")

    @duo.setter
    def duo(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "duo", value)

    @property
    @pulumi.getter(name="externalIdp")
    @_utilities.deprecated("""Since okta now support multiple external_idps, this will be deprecated. Please use `external_idps` instead""")
    def external_idp(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        return pulumi.get(self, "external_idp")

    @external_idp.setter
    def external_idp(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "external_idp", value)

    @property
    @pulumi.getter(name="externalIdps")
    def external_idps(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[str]]]]]]:
        return pulumi.get(self, "external_idps")

    @external_idps.setter
    def external_idps(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[str]]]]]]):
        pulumi.set(self, "external_idps", value)

    @property
    @pulumi.getter(name="fidoU2f")
    def fido_u2f(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        return pulumi.get(self, "fido_u2f")

    @fido_u2f.setter
    def fido_u2f(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "fido_u2f", value)

    @property
    @pulumi.getter(name="fidoWebauthn")
    def fido_webauthn(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        return pulumi.get(self, "fido_webauthn")

    @fido_webauthn.setter
    def fido_webauthn(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "fido_webauthn", value)

    @property
    @pulumi.getter(name="googleOtp")
    def google_otp(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        return pulumi.get(self, "google_otp")

    @google_otp.setter
    def google_otp(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "google_otp", value)

    @property
    @pulumi.getter
    def hotp(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        return pulumi.get(self, "hotp")

    @hotp.setter
    def hotp(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "hotp", value)

    @property
    @pulumi.getter(name="isOie")
    def is_oie(self) -> Optional[pulumi.Input[bool]]:
        """
        Is the policy using Okta Identity Engine (OIE) with authenticators instead of factors?
        """
        return pulumi.get(self, "is_oie")

    @is_oie.setter
    def is_oie(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_oie", value)

    @property
    @pulumi.getter(name="oktaCall")
    def okta_call(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        return pulumi.get(self, "okta_call")

    @okta_call.setter
    def okta_call(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "okta_call", value)

    @property
    @pulumi.getter(name="oktaEmail")
    def okta_email(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        return pulumi.get(self, "okta_email")

    @okta_email.setter
    def okta_email(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "okta_email", value)

    @property
    @pulumi.getter(name="oktaOtp")
    def okta_otp(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        return pulumi.get(self, "okta_otp")

    @okta_otp.setter
    def okta_otp(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "okta_otp", value)

    @property
    @pulumi.getter(name="oktaPassword")
    def okta_password(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        return pulumi.get(self, "okta_password")

    @okta_password.setter
    def okta_password(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "okta_password", value)

    @property
    @pulumi.getter(name="oktaPush")
    def okta_push(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        return pulumi.get(self, "okta_push")

    @okta_push.setter
    def okta_push(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "okta_push", value)

    @property
    @pulumi.getter(name="oktaQuestion")
    def okta_question(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        return pulumi.get(self, "okta_question")

    @okta_question.setter
    def okta_question(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "okta_question", value)

    @property
    @pulumi.getter(name="oktaSms")
    def okta_sms(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        return pulumi.get(self, "okta_sms")

    @okta_sms.setter
    def okta_sms(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "okta_sms", value)

    @property
    @pulumi.getter(name="oktaVerify")
    def okta_verify(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        return pulumi.get(self, "okta_verify")

    @okta_verify.setter
    def okta_verify(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "okta_verify", value)

    @property
    @pulumi.getter(name="onpremMfa")
    def onprem_mfa(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        return pulumi.get(self, "onprem_mfa")

    @onprem_mfa.setter
    def onprem_mfa(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "onprem_mfa", value)

    @property
    @pulumi.getter(name="phoneNumber")
    def phone_number(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        return pulumi.get(self, "phone_number")

    @phone_number.setter
    def phone_number(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "phone_number", value)

    @property
    @pulumi.getter(name="rsaToken")
    def rsa_token(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        return pulumi.get(self, "rsa_token")

    @rsa_token.setter
    def rsa_token(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "rsa_token", value)

    @property
    @pulumi.getter(name="securityQuestion")
    def security_question(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        return pulumi.get(self, "security_question")

    @security_question.setter
    def security_question(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "security_question", value)

    @property
    @pulumi.getter(name="symantecVip")
    def symantec_vip(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        return pulumi.get(self, "symantec_vip")

    @symantec_vip.setter
    def symantec_vip(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "symantec_vip", value)

    @property
    @pulumi.getter
    def webauthn(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        return pulumi.get(self, "webauthn")

    @webauthn.setter
    def webauthn(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "webauthn", value)

    @property
    @pulumi.getter(name="yubikeyToken")
    def yubikey_token(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        return pulumi.get(self, "yubikey_token")

    @yubikey_token.setter
    def yubikey_token(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "yubikey_token", value)


@pulumi.input_type
class _PolicyMfaDefaultState:
    def __init__(__self__, *,
                 default_included_group_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 duo: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 external_idp: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 external_idps: Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[str]]]]]] = None,
                 fido_u2f: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 fido_webauthn: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 google_otp: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 hotp: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 is_oie: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 okta_call: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 okta_email: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 okta_otp: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 okta_password: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 okta_push: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 okta_question: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 okta_sms: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 okta_verify: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 onprem_mfa: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 phone_number: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 rsa_token: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 security_question: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 symantec_vip: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 webauthn: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 yubikey_token: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering PolicyMfaDefault resources.
        :param pulumi.Input[str] default_included_group_id: Default group ID (always included)
        :param pulumi.Input[str] description: Default policy description
        :param pulumi.Input[bool] is_oie: Is the policy using Okta Identity Engine (OIE) with authenticators instead of factors?
        :param pulumi.Input[str] name: Default policy name
        :param pulumi.Input[int] priority: Default policy priority
        :param pulumi.Input[str] status: Default policy status
        """
        if default_included_group_id is not None:
            pulumi.set(__self__, "default_included_group_id", default_included_group_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if duo is not None:
            pulumi.set(__self__, "duo", duo)
        if external_idp is not None:
            warnings.warn("""Since okta now support multiple external_idps, this will be deprecated. Please use `external_idps` instead""", DeprecationWarning)
            pulumi.log.warn("""external_idp is deprecated: Since okta now support multiple external_idps, this will be deprecated. Please use `external_idps` instead""")
        if external_idp is not None:
            pulumi.set(__self__, "external_idp", external_idp)
        if external_idps is not None:
            pulumi.set(__self__, "external_idps", external_idps)
        if fido_u2f is not None:
            pulumi.set(__self__, "fido_u2f", fido_u2f)
        if fido_webauthn is not None:
            pulumi.set(__self__, "fido_webauthn", fido_webauthn)
        if google_otp is not None:
            pulumi.set(__self__, "google_otp", google_otp)
        if hotp is not None:
            pulumi.set(__self__, "hotp", hotp)
        if is_oie is not None:
            pulumi.set(__self__, "is_oie", is_oie)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if okta_call is not None:
            pulumi.set(__self__, "okta_call", okta_call)
        if okta_email is not None:
            pulumi.set(__self__, "okta_email", okta_email)
        if okta_otp is not None:
            pulumi.set(__self__, "okta_otp", okta_otp)
        if okta_password is not None:
            pulumi.set(__self__, "okta_password", okta_password)
        if okta_push is not None:
            pulumi.set(__self__, "okta_push", okta_push)
        if okta_question is not None:
            pulumi.set(__self__, "okta_question", okta_question)
        if okta_sms is not None:
            pulumi.set(__self__, "okta_sms", okta_sms)
        if okta_verify is not None:
            pulumi.set(__self__, "okta_verify", okta_verify)
        if onprem_mfa is not None:
            pulumi.set(__self__, "onprem_mfa", onprem_mfa)
        if phone_number is not None:
            pulumi.set(__self__, "phone_number", phone_number)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if rsa_token is not None:
            pulumi.set(__self__, "rsa_token", rsa_token)
        if security_question is not None:
            pulumi.set(__self__, "security_question", security_question)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if symantec_vip is not None:
            pulumi.set(__self__, "symantec_vip", symantec_vip)
        if webauthn is not None:
            pulumi.set(__self__, "webauthn", webauthn)
        if yubikey_token is not None:
            pulumi.set(__self__, "yubikey_token", yubikey_token)

    @property
    @pulumi.getter(name="defaultIncludedGroupId")
    def default_included_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        Default group ID (always included)
        """
        return pulumi.get(self, "default_included_group_id")

    @default_included_group_id.setter
    def default_included_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_included_group_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Default policy description
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def duo(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        return pulumi.get(self, "duo")

    @duo.setter
    def duo(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "duo", value)

    @property
    @pulumi.getter(name="externalIdp")
    @_utilities.deprecated("""Since okta now support multiple external_idps, this will be deprecated. Please use `external_idps` instead""")
    def external_idp(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        return pulumi.get(self, "external_idp")

    @external_idp.setter
    def external_idp(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "external_idp", value)

    @property
    @pulumi.getter(name="externalIdps")
    def external_idps(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[str]]]]]]:
        return pulumi.get(self, "external_idps")

    @external_idps.setter
    def external_idps(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[str]]]]]]):
        pulumi.set(self, "external_idps", value)

    @property
    @pulumi.getter(name="fidoU2f")
    def fido_u2f(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        return pulumi.get(self, "fido_u2f")

    @fido_u2f.setter
    def fido_u2f(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "fido_u2f", value)

    @property
    @pulumi.getter(name="fidoWebauthn")
    def fido_webauthn(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        return pulumi.get(self, "fido_webauthn")

    @fido_webauthn.setter
    def fido_webauthn(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "fido_webauthn", value)

    @property
    @pulumi.getter(name="googleOtp")
    def google_otp(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        return pulumi.get(self, "google_otp")

    @google_otp.setter
    def google_otp(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "google_otp", value)

    @property
    @pulumi.getter
    def hotp(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        return pulumi.get(self, "hotp")

    @hotp.setter
    def hotp(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "hotp", value)

    @property
    @pulumi.getter(name="isOie")
    def is_oie(self) -> Optional[pulumi.Input[bool]]:
        """
        Is the policy using Okta Identity Engine (OIE) with authenticators instead of factors?
        """
        return pulumi.get(self, "is_oie")

    @is_oie.setter
    def is_oie(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_oie", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Default policy name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="oktaCall")
    def okta_call(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        return pulumi.get(self, "okta_call")

    @okta_call.setter
    def okta_call(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "okta_call", value)

    @property
    @pulumi.getter(name="oktaEmail")
    def okta_email(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        return pulumi.get(self, "okta_email")

    @okta_email.setter
    def okta_email(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "okta_email", value)

    @property
    @pulumi.getter(name="oktaOtp")
    def okta_otp(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        return pulumi.get(self, "okta_otp")

    @okta_otp.setter
    def okta_otp(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "okta_otp", value)

    @property
    @pulumi.getter(name="oktaPassword")
    def okta_password(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        return pulumi.get(self, "okta_password")

    @okta_password.setter
    def okta_password(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "okta_password", value)

    @property
    @pulumi.getter(name="oktaPush")
    def okta_push(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        return pulumi.get(self, "okta_push")

    @okta_push.setter
    def okta_push(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "okta_push", value)

    @property
    @pulumi.getter(name="oktaQuestion")
    def okta_question(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        return pulumi.get(self, "okta_question")

    @okta_question.setter
    def okta_question(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "okta_question", value)

    @property
    @pulumi.getter(name="oktaSms")
    def okta_sms(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        return pulumi.get(self, "okta_sms")

    @okta_sms.setter
    def okta_sms(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "okta_sms", value)

    @property
    @pulumi.getter(name="oktaVerify")
    def okta_verify(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        return pulumi.get(self, "okta_verify")

    @okta_verify.setter
    def okta_verify(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "okta_verify", value)

    @property
    @pulumi.getter(name="onpremMfa")
    def onprem_mfa(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        return pulumi.get(self, "onprem_mfa")

    @onprem_mfa.setter
    def onprem_mfa(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "onprem_mfa", value)

    @property
    @pulumi.getter(name="phoneNumber")
    def phone_number(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        return pulumi.get(self, "phone_number")

    @phone_number.setter
    def phone_number(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "phone_number", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[int]]:
        """
        Default policy priority
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter(name="rsaToken")
    def rsa_token(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        return pulumi.get(self, "rsa_token")

    @rsa_token.setter
    def rsa_token(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "rsa_token", value)

    @property
    @pulumi.getter(name="securityQuestion")
    def security_question(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        return pulumi.get(self, "security_question")

    @security_question.setter
    def security_question(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "security_question", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Default policy status
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="symantecVip")
    def symantec_vip(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        return pulumi.get(self, "symantec_vip")

    @symantec_vip.setter
    def symantec_vip(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "symantec_vip", value)

    @property
    @pulumi.getter
    def webauthn(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        return pulumi.get(self, "webauthn")

    @webauthn.setter
    def webauthn(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "webauthn", value)

    @property
    @pulumi.getter(name="yubikeyToken")
    def yubikey_token(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        return pulumi.get(self, "yubikey_token")

    @yubikey_token.setter
    def yubikey_token(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "yubikey_token", value)


class PolicyMfaDefault(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 duo: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 external_idp: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 external_idps: Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[str]]]]]] = None,
                 fido_u2f: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 fido_webauthn: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 google_otp: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 hotp: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 is_oie: Optional[pulumi.Input[bool]] = None,
                 okta_call: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 okta_email: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 okta_otp: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 okta_password: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 okta_push: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 okta_question: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 okta_sms: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 okta_verify: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 onprem_mfa: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 phone_number: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 rsa_token: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 security_question: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 symantec_vip: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 webauthn: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 yubikey_token: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        Configures default MFA Policy.
        This resource allows you to configure default MFA Policy.
        > Requires Org Feature Flag 'OKTA_MFA_POLICY'. Contact support to have this feature flag ***enabled***.
        Unless Org Feature Flag 'ENG_ENABLE_OPTIONAL_PASSWORD_ENROLLMENT' is ***disabled*** 'okta_password' or 'okta_email' must be present and its 'enroll' value set to 'REQUIRED'. Contact support to have this feature flag ***disabled***.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_okta as okta

        classic_example = okta.PolicyMfaDefault("classic_example",
            is_oie=False,
            okta_password={
                "enroll": "REQUIRED",
            },
            okta_otp={
                "enroll": "REQUIRED",
            })
        oie_example = okta.PolicyMfaDefault("oie_example",
            is_oie=True,
            okta_password={
                "enroll": "REQUIRED",
            },
            okta_verify={
                "enroll": "REQUIRED",
            })
        ```

        ## Import

        ```sh
        $ pulumi import okta:index/policyMfaDefault:PolicyMfaDefault example .
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] is_oie: Is the policy using Okta Identity Engine (OIE) with authenticators instead of factors?
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[PolicyMfaDefaultArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Configures default MFA Policy.
        This resource allows you to configure default MFA Policy.
        > Requires Org Feature Flag 'OKTA_MFA_POLICY'. Contact support to have this feature flag ***enabled***.
        Unless Org Feature Flag 'ENG_ENABLE_OPTIONAL_PASSWORD_ENROLLMENT' is ***disabled*** 'okta_password' or 'okta_email' must be present and its 'enroll' value set to 'REQUIRED'. Contact support to have this feature flag ***disabled***.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_okta as okta

        classic_example = okta.PolicyMfaDefault("classic_example",
            is_oie=False,
            okta_password={
                "enroll": "REQUIRED",
            },
            okta_otp={
                "enroll": "REQUIRED",
            })
        oie_example = okta.PolicyMfaDefault("oie_example",
            is_oie=True,
            okta_password={
                "enroll": "REQUIRED",
            },
            okta_verify={
                "enroll": "REQUIRED",
            })
        ```

        ## Import

        ```sh
        $ pulumi import okta:index/policyMfaDefault:PolicyMfaDefault example .
        ```

        :param str resource_name: The name of the resource.
        :param PolicyMfaDefaultArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PolicyMfaDefaultArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 duo: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 external_idp: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 external_idps: Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[str]]]]]] = None,
                 fido_u2f: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 fido_webauthn: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 google_otp: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 hotp: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 is_oie: Optional[pulumi.Input[bool]] = None,
                 okta_call: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 okta_email: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 okta_otp: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 okta_password: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 okta_push: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 okta_question: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 okta_sms: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 okta_verify: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 onprem_mfa: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 phone_number: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 rsa_token: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 security_question: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 symantec_vip: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 webauthn: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 yubikey_token: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PolicyMfaDefaultArgs.__new__(PolicyMfaDefaultArgs)

            __props__.__dict__["duo"] = duo
            __props__.__dict__["external_idp"] = external_idp
            __props__.__dict__["external_idps"] = external_idps
            __props__.__dict__["fido_u2f"] = fido_u2f
            __props__.__dict__["fido_webauthn"] = fido_webauthn
            __props__.__dict__["google_otp"] = google_otp
            __props__.__dict__["hotp"] = hotp
            __props__.__dict__["is_oie"] = is_oie
            __props__.__dict__["okta_call"] = okta_call
            __props__.__dict__["okta_email"] = okta_email
            __props__.__dict__["okta_otp"] = okta_otp
            __props__.__dict__["okta_password"] = okta_password
            __props__.__dict__["okta_push"] = okta_push
            __props__.__dict__["okta_question"] = okta_question
            __props__.__dict__["okta_sms"] = okta_sms
            __props__.__dict__["okta_verify"] = okta_verify
            __props__.__dict__["onprem_mfa"] = onprem_mfa
            __props__.__dict__["phone_number"] = phone_number
            __props__.__dict__["rsa_token"] = rsa_token
            __props__.__dict__["security_question"] = security_question
            __props__.__dict__["symantec_vip"] = symantec_vip
            __props__.__dict__["webauthn"] = webauthn
            __props__.__dict__["yubikey_token"] = yubikey_token
            __props__.__dict__["default_included_group_id"] = None
            __props__.__dict__["description"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["priority"] = None
            __props__.__dict__["status"] = None
        super(PolicyMfaDefault, __self__).__init__(
            'okta:index/policyMfaDefault:PolicyMfaDefault',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            default_included_group_id: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            duo: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            external_idp: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            external_idps: Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[str]]]]]] = None,
            fido_u2f: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            fido_webauthn: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            google_otp: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            hotp: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            is_oie: Optional[pulumi.Input[bool]] = None,
            name: Optional[pulumi.Input[str]] = None,
            okta_call: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            okta_email: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            okta_otp: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            okta_password: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            okta_push: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            okta_question: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            okta_sms: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            okta_verify: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            onprem_mfa: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            phone_number: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            priority: Optional[pulumi.Input[int]] = None,
            rsa_token: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            security_question: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            status: Optional[pulumi.Input[str]] = None,
            symantec_vip: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            webauthn: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            yubikey_token: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None) -> 'PolicyMfaDefault':
        """
        Get an existing PolicyMfaDefault resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] default_included_group_id: Default group ID (always included)
        :param pulumi.Input[str] description: Default policy description
        :param pulumi.Input[bool] is_oie: Is the policy using Okta Identity Engine (OIE) with authenticators instead of factors?
        :param pulumi.Input[str] name: Default policy name
        :param pulumi.Input[int] priority: Default policy priority
        :param pulumi.Input[str] status: Default policy status
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PolicyMfaDefaultState.__new__(_PolicyMfaDefaultState)

        __props__.__dict__["default_included_group_id"] = default_included_group_id
        __props__.__dict__["description"] = description
        __props__.__dict__["duo"] = duo
        __props__.__dict__["external_idp"] = external_idp
        __props__.__dict__["external_idps"] = external_idps
        __props__.__dict__["fido_u2f"] = fido_u2f
        __props__.__dict__["fido_webauthn"] = fido_webauthn
        __props__.__dict__["google_otp"] = google_otp
        __props__.__dict__["hotp"] = hotp
        __props__.__dict__["is_oie"] = is_oie
        __props__.__dict__["name"] = name
        __props__.__dict__["okta_call"] = okta_call
        __props__.__dict__["okta_email"] = okta_email
        __props__.__dict__["okta_otp"] = okta_otp
        __props__.__dict__["okta_password"] = okta_password
        __props__.__dict__["okta_push"] = okta_push
        __props__.__dict__["okta_question"] = okta_question
        __props__.__dict__["okta_sms"] = okta_sms
        __props__.__dict__["okta_verify"] = okta_verify
        __props__.__dict__["onprem_mfa"] = onprem_mfa
        __props__.__dict__["phone_number"] = phone_number
        __props__.__dict__["priority"] = priority
        __props__.__dict__["rsa_token"] = rsa_token
        __props__.__dict__["security_question"] = security_question
        __props__.__dict__["status"] = status
        __props__.__dict__["symantec_vip"] = symantec_vip
        __props__.__dict__["webauthn"] = webauthn
        __props__.__dict__["yubikey_token"] = yubikey_token
        return PolicyMfaDefault(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="defaultIncludedGroupId")
    def default_included_group_id(self) -> pulumi.Output[str]:
        """
        Default group ID (always included)
        """
        return pulumi.get(self, "default_included_group_id")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        Default policy description
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def duo(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        return pulumi.get(self, "duo")

    @property
    @pulumi.getter(name="externalIdp")
    @_utilities.deprecated("""Since okta now support multiple external_idps, this will be deprecated. Please use `external_idps` instead""")
    def external_idp(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        return pulumi.get(self, "external_idp")

    @property
    @pulumi.getter(name="externalIdps")
    def external_idps(self) -> pulumi.Output[Optional[Sequence[Mapping[str, str]]]]:
        return pulumi.get(self, "external_idps")

    @property
    @pulumi.getter(name="fidoU2f")
    def fido_u2f(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        return pulumi.get(self, "fido_u2f")

    @property
    @pulumi.getter(name="fidoWebauthn")
    def fido_webauthn(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        return pulumi.get(self, "fido_webauthn")

    @property
    @pulumi.getter(name="googleOtp")
    def google_otp(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        return pulumi.get(self, "google_otp")

    @property
    @pulumi.getter
    def hotp(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        return pulumi.get(self, "hotp")

    @property
    @pulumi.getter(name="isOie")
    def is_oie(self) -> pulumi.Output[Optional[bool]]:
        """
        Is the policy using Okta Identity Engine (OIE) with authenticators instead of factors?
        """
        return pulumi.get(self, "is_oie")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Default policy name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="oktaCall")
    def okta_call(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        return pulumi.get(self, "okta_call")

    @property
    @pulumi.getter(name="oktaEmail")
    def okta_email(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        return pulumi.get(self, "okta_email")

    @property
    @pulumi.getter(name="oktaOtp")
    def okta_otp(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        return pulumi.get(self, "okta_otp")

    @property
    @pulumi.getter(name="oktaPassword")
    def okta_password(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        return pulumi.get(self, "okta_password")

    @property
    @pulumi.getter(name="oktaPush")
    def okta_push(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        return pulumi.get(self, "okta_push")

    @property
    @pulumi.getter(name="oktaQuestion")
    def okta_question(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        return pulumi.get(self, "okta_question")

    @property
    @pulumi.getter(name="oktaSms")
    def okta_sms(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        return pulumi.get(self, "okta_sms")

    @property
    @pulumi.getter(name="oktaVerify")
    def okta_verify(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        return pulumi.get(self, "okta_verify")

    @property
    @pulumi.getter(name="onpremMfa")
    def onprem_mfa(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        return pulumi.get(self, "onprem_mfa")

    @property
    @pulumi.getter(name="phoneNumber")
    def phone_number(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        return pulumi.get(self, "phone_number")

    @property
    @pulumi.getter
    def priority(self) -> pulumi.Output[int]:
        """
        Default policy priority
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter(name="rsaToken")
    def rsa_token(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        return pulumi.get(self, "rsa_token")

    @property
    @pulumi.getter(name="securityQuestion")
    def security_question(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        return pulumi.get(self, "security_question")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        Default policy status
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="symantecVip")
    def symantec_vip(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        return pulumi.get(self, "symantec_vip")

    @property
    @pulumi.getter
    def webauthn(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        return pulumi.get(self, "webauthn")

    @property
    @pulumi.getter(name="yubikeyToken")
    def yubikey_token(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        return pulumi.get(self, "yubikey_token")

