# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'UserPasswordHash',
    'GetUserSearchResult',
    'GetUsersSearchResult',
    'GetUsersUserResult',
]

@pulumi.output_type
class UserPasswordHash(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "saltOrder":
            suggest = "salt_order"
        elif key == "workFactor":
            suggest = "work_factor"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserPasswordHash. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserPasswordHash.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserPasswordHash.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 algorithm: str,
                 value: str,
                 salt: Optional[str] = None,
                 salt_order: Optional[str] = None,
                 work_factor: Optional[int] = None):
        """
        :param str algorithm: The algorithm used to generate the hash using the password
        :param str value: For SHA-512, SHA-256, SHA-1, MD5, This is the actual base64-encoded hash of the password (and salt, if used). This is the Base64 encoded value of the SHA-512/SHA-256/SHA-1/MD5 digest that was computed by either pre-fixing or post-fixing the salt to the password, depending on the saltOrder. If a salt was not used in the source system, then this should just be the the Base64 encoded value of the password's SHA-512/SHA-256/SHA-1/MD5 digest. For BCRYPT, This is the actual radix64-encoded hashed password.
        :param str salt: Only required for salted hashes
        :param str salt_order: Specifies whether salt was pre- or postfixed to the password before hashing
        :param int work_factor: Governs the strength of the hash and the time required to compute it. Only required for BCRYPT algorithm
        """
        pulumi.set(__self__, "algorithm", algorithm)
        pulumi.set(__self__, "value", value)
        if salt is not None:
            pulumi.set(__self__, "salt", salt)
        if salt_order is not None:
            pulumi.set(__self__, "salt_order", salt_order)
        if work_factor is not None:
            pulumi.set(__self__, "work_factor", work_factor)

    @property
    @pulumi.getter
    def algorithm(self) -> str:
        """
        The algorithm used to generate the hash using the password
        """
        return pulumi.get(self, "algorithm")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        For SHA-512, SHA-256, SHA-1, MD5, This is the actual base64-encoded hash of the password (and salt, if used). This is the Base64 encoded value of the SHA-512/SHA-256/SHA-1/MD5 digest that was computed by either pre-fixing or post-fixing the salt to the password, depending on the saltOrder. If a salt was not used in the source system, then this should just be the the Base64 encoded value of the password's SHA-512/SHA-256/SHA-1/MD5 digest. For BCRYPT, This is the actual radix64-encoded hashed password.
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter
    def salt(self) -> Optional[str]:
        """
        Only required for salted hashes
        """
        return pulumi.get(self, "salt")

    @property
    @pulumi.getter(name="saltOrder")
    def salt_order(self) -> Optional[str]:
        """
        Specifies whether salt was pre- or postfixed to the password before hashing
        """
        return pulumi.get(self, "salt_order")

    @property
    @pulumi.getter(name="workFactor")
    def work_factor(self) -> Optional[int]:
        """
        Governs the strength of the hash and the time required to compute it. Only required for BCRYPT algorithm
        """
        return pulumi.get(self, "work_factor")


@pulumi.output_type
class GetUserSearchResult(dict):
    def __init__(__self__, *,
                 comparison: Optional[str] = None,
                 expression: Optional[str] = None,
                 name: Optional[str] = None,
                 value: Optional[str] = None):
        """
        :param str expression: A raw search expression string. This requires the search feature be on. Please see Okta documentation on their filter API for users. https://developer.okta.com/docs/api/resources/users#list-users-with-search
        :param str name: Property name to search for. This requires the search feature be on. Please see Okta documentation on their filter API for users. https://developer.okta.com/docs/api/resources/users#list-users-with-search
        """
        if comparison is not None:
            pulumi.set(__self__, "comparison", comparison)
        if expression is not None:
            pulumi.set(__self__, "expression", expression)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def comparison(self) -> Optional[str]:
        return pulumi.get(self, "comparison")

    @property
    @pulumi.getter
    def expression(self) -> Optional[str]:
        """
        A raw search expression string. This requires the search feature be on. Please see Okta documentation on their filter API for users. https://developer.okta.com/docs/api/resources/users#list-users-with-search
        """
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Property name to search for. This requires the search feature be on. Please see Okta documentation on their filter API for users. https://developer.okta.com/docs/api/resources/users#list-users-with-search
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        return pulumi.get(self, "value")


@pulumi.output_type
class GetUsersSearchResult(dict):
    def __init__(__self__, *,
                 comparison: Optional[str] = None,
                 expression: Optional[str] = None,
                 name: Optional[str] = None,
                 value: Optional[str] = None):
        """
        :param str expression: A raw search expression string. This requires the search feature be on. Please see Okta documentation on their filter API for users. https://developer.okta.com/docs/api/resources/users#list-users-with-search
        :param str name: Property name to search for. This requires the search feature be on. Please see Okta documentation on their filter API for users. https://developer.okta.com/docs/api/resources/users#list-users-with-search
        """
        if comparison is not None:
            pulumi.set(__self__, "comparison", comparison)
        if expression is not None:
            pulumi.set(__self__, "expression", expression)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def comparison(self) -> Optional[str]:
        return pulumi.get(self, "comparison")

    @property
    @pulumi.getter
    def expression(self) -> Optional[str]:
        """
        A raw search expression string. This requires the search feature be on. Please see Okta documentation on their filter API for users. https://developer.okta.com/docs/api/resources/users#list-users-with-search
        """
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Property name to search for. This requires the search feature be on. Please see Okta documentation on their filter API for users. https://developer.okta.com/docs/api/resources/users#list-users-with-search
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        return pulumi.get(self, "value")


@pulumi.output_type
class GetUsersUserResult(dict):
    def __init__(__self__, *,
                 admin_roles: Sequence[str],
                 city: str,
                 cost_center: str,
                 country_code: str,
                 custom_profile_attributes: str,
                 department: str,
                 display_name: str,
                 division: str,
                 email: str,
                 employee_number: str,
                 first_name: str,
                 group_memberships: Sequence[str],
                 honorific_prefix: str,
                 honorific_suffix: str,
                 id: str,
                 last_name: str,
                 locale: str,
                 login: str,
                 manager: str,
                 manager_id: str,
                 middle_name: str,
                 mobile_phone: str,
                 nick_name: str,
                 organization: str,
                 postal_address: str,
                 preferred_language: str,
                 primary_phone: str,
                 profile_url: str,
                 roles: Sequence[str],
                 second_email: str,
                 state: str,
                 status: str,
                 street_address: str,
                 timezone: str,
                 title: str,
                 user_type: str,
                 zip_code: str):
        pulumi.set(__self__, "admin_roles", admin_roles)
        pulumi.set(__self__, "city", city)
        pulumi.set(__self__, "cost_center", cost_center)
        pulumi.set(__self__, "country_code", country_code)
        pulumi.set(__self__, "custom_profile_attributes", custom_profile_attributes)
        pulumi.set(__self__, "department", department)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "division", division)
        pulumi.set(__self__, "email", email)
        pulumi.set(__self__, "employee_number", employee_number)
        pulumi.set(__self__, "first_name", first_name)
        pulumi.set(__self__, "group_memberships", group_memberships)
        pulumi.set(__self__, "honorific_prefix", honorific_prefix)
        pulumi.set(__self__, "honorific_suffix", honorific_suffix)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "last_name", last_name)
        pulumi.set(__self__, "locale", locale)
        pulumi.set(__self__, "login", login)
        pulumi.set(__self__, "manager", manager)
        pulumi.set(__self__, "manager_id", manager_id)
        pulumi.set(__self__, "middle_name", middle_name)
        pulumi.set(__self__, "mobile_phone", mobile_phone)
        pulumi.set(__self__, "nick_name", nick_name)
        pulumi.set(__self__, "organization", organization)
        pulumi.set(__self__, "postal_address", postal_address)
        pulumi.set(__self__, "preferred_language", preferred_language)
        pulumi.set(__self__, "primary_phone", primary_phone)
        pulumi.set(__self__, "profile_url", profile_url)
        pulumi.set(__self__, "roles", roles)
        pulumi.set(__self__, "second_email", second_email)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "street_address", street_address)
        pulumi.set(__self__, "timezone", timezone)
        pulumi.set(__self__, "title", title)
        pulumi.set(__self__, "user_type", user_type)
        pulumi.set(__self__, "zip_code", zip_code)

    @property
    @pulumi.getter(name="adminRoles")
    def admin_roles(self) -> Sequence[str]:
        return pulumi.get(self, "admin_roles")

    @property
    @pulumi.getter
    def city(self) -> str:
        return pulumi.get(self, "city")

    @property
    @pulumi.getter(name="costCenter")
    def cost_center(self) -> str:
        return pulumi.get(self, "cost_center")

    @property
    @pulumi.getter(name="countryCode")
    def country_code(self) -> str:
        return pulumi.get(self, "country_code")

    @property
    @pulumi.getter(name="customProfileAttributes")
    def custom_profile_attributes(self) -> str:
        return pulumi.get(self, "custom_profile_attributes")

    @property
    @pulumi.getter
    def department(self) -> str:
        return pulumi.get(self, "department")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def division(self) -> str:
        return pulumi.get(self, "division")

    @property
    @pulumi.getter
    def email(self) -> str:
        return pulumi.get(self, "email")

    @property
    @pulumi.getter(name="employeeNumber")
    def employee_number(self) -> str:
        return pulumi.get(self, "employee_number")

    @property
    @pulumi.getter(name="firstName")
    def first_name(self) -> str:
        return pulumi.get(self, "first_name")

    @property
    @pulumi.getter(name="groupMemberships")
    def group_memberships(self) -> Sequence[str]:
        return pulumi.get(self, "group_memberships")

    @property
    @pulumi.getter(name="honorificPrefix")
    def honorific_prefix(self) -> str:
        return pulumi.get(self, "honorific_prefix")

    @property
    @pulumi.getter(name="honorificSuffix")
    def honorific_suffix(self) -> str:
        return pulumi.get(self, "honorific_suffix")

    @property
    @pulumi.getter
    def id(self) -> str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lastName")
    def last_name(self) -> str:
        return pulumi.get(self, "last_name")

    @property
    @pulumi.getter
    def locale(self) -> str:
        return pulumi.get(self, "locale")

    @property
    @pulumi.getter
    def login(self) -> str:
        return pulumi.get(self, "login")

    @property
    @pulumi.getter
    def manager(self) -> str:
        return pulumi.get(self, "manager")

    @property
    @pulumi.getter(name="managerId")
    def manager_id(self) -> str:
        return pulumi.get(self, "manager_id")

    @property
    @pulumi.getter(name="middleName")
    def middle_name(self) -> str:
        return pulumi.get(self, "middle_name")

    @property
    @pulumi.getter(name="mobilePhone")
    def mobile_phone(self) -> str:
        return pulumi.get(self, "mobile_phone")

    @property
    @pulumi.getter(name="nickName")
    def nick_name(self) -> str:
        return pulumi.get(self, "nick_name")

    @property
    @pulumi.getter
    def organization(self) -> str:
        return pulumi.get(self, "organization")

    @property
    @pulumi.getter(name="postalAddress")
    def postal_address(self) -> str:
        return pulumi.get(self, "postal_address")

    @property
    @pulumi.getter(name="preferredLanguage")
    def preferred_language(self) -> str:
        return pulumi.get(self, "preferred_language")

    @property
    @pulumi.getter(name="primaryPhone")
    def primary_phone(self) -> str:
        return pulumi.get(self, "primary_phone")

    @property
    @pulumi.getter(name="profileUrl")
    def profile_url(self) -> str:
        return pulumi.get(self, "profile_url")

    @property
    @pulumi.getter
    def roles(self) -> Sequence[str]:
        return pulumi.get(self, "roles")

    @property
    @pulumi.getter(name="secondEmail")
    def second_email(self) -> str:
        return pulumi.get(self, "second_email")

    @property
    @pulumi.getter
    def state(self) -> str:
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def status(self) -> str:
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="streetAddress")
    def street_address(self) -> str:
        return pulumi.get(self, "street_address")

    @property
    @pulumi.getter
    def timezone(self) -> str:
        return pulumi.get(self, "timezone")

    @property
    @pulumi.getter
    def title(self) -> str:
        return pulumi.get(self, "title")

    @property
    @pulumi.getter(name="userType")
    def user_type(self) -> str:
        return pulumi.get(self, "user_type")

    @property
    @pulumi.getter(name="zipCode")
    def zip_code(self) -> str:
        return pulumi.get(self, "zip_code")


