# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['UserAdminRolesArgs', 'UserAdminRoles']

@pulumi.input_type
class UserAdminRolesArgs:
    def __init__(__self__, *,
                 admin_roles: pulumi.Input[Sequence[pulumi.Input[str]]],
                 user_id: pulumi.Input[str],
                 disable_notifications: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a UserAdminRoles resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] admin_roles: The list of Okta user admin roles, e.g. `['APP_ADMIN', 'USER_ADMIN']` See [API Docs](https://developer.okta.com/docs/reference/api/roles/#role-types).
        :param pulumi.Input[str] user_id: ID of a Okta User
        :param pulumi.Input[bool] disable_notifications: When this setting is enabled, the admins won't receive any of the default Okta administrator emails. These admins also won't have access to contact Okta Support and open support cases on behalf of your org.
        """
        pulumi.set(__self__, "admin_roles", admin_roles)
        pulumi.set(__self__, "user_id", user_id)
        if disable_notifications is not None:
            pulumi.set(__self__, "disable_notifications", disable_notifications)

    @property
    @pulumi.getter(name="adminRoles")
    def admin_roles(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        The list of Okta user admin roles, e.g. `['APP_ADMIN', 'USER_ADMIN']` See [API Docs](https://developer.okta.com/docs/reference/api/roles/#role-types).
        """
        return pulumi.get(self, "admin_roles")

    @admin_roles.setter
    def admin_roles(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "admin_roles", value)

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> pulumi.Input[str]:
        """
        ID of a Okta User
        """
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "user_id", value)

    @property
    @pulumi.getter(name="disableNotifications")
    def disable_notifications(self) -> Optional[pulumi.Input[bool]]:
        """
        When this setting is enabled, the admins won't receive any of the default Okta administrator emails. These admins also won't have access to contact Okta Support and open support cases on behalf of your org.
        """
        return pulumi.get(self, "disable_notifications")

    @disable_notifications.setter
    def disable_notifications(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_notifications", value)


@pulumi.input_type
class _UserAdminRolesState:
    def __init__(__self__, *,
                 admin_roles: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 disable_notifications: Optional[pulumi.Input[bool]] = None,
                 user_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering UserAdminRoles resources.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] admin_roles: The list of Okta user admin roles, e.g. `['APP_ADMIN', 'USER_ADMIN']` See [API Docs](https://developer.okta.com/docs/reference/api/roles/#role-types).
        :param pulumi.Input[bool] disable_notifications: When this setting is enabled, the admins won't receive any of the default Okta administrator emails. These admins also won't have access to contact Okta Support and open support cases on behalf of your org.
        :param pulumi.Input[str] user_id: ID of a Okta User
        """
        if admin_roles is not None:
            pulumi.set(__self__, "admin_roles", admin_roles)
        if disable_notifications is not None:
            pulumi.set(__self__, "disable_notifications", disable_notifications)
        if user_id is not None:
            pulumi.set(__self__, "user_id", user_id)

    @property
    @pulumi.getter(name="adminRoles")
    def admin_roles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of Okta user admin roles, e.g. `['APP_ADMIN', 'USER_ADMIN']` See [API Docs](https://developer.okta.com/docs/reference/api/roles/#role-types).
        """
        return pulumi.get(self, "admin_roles")

    @admin_roles.setter
    def admin_roles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "admin_roles", value)

    @property
    @pulumi.getter(name="disableNotifications")
    def disable_notifications(self) -> Optional[pulumi.Input[bool]]:
        """
        When this setting is enabled, the admins won't receive any of the default Okta administrator emails. These admins also won't have access to contact Okta Support and open support cases on behalf of your org.
        """
        return pulumi.get(self, "disable_notifications")

    @disable_notifications.setter
    def disable_notifications(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_notifications", value)

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of a Okta User
        """
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_id", value)


class UserAdminRoles(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 admin_roles: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 disable_notifications: Optional[pulumi.Input[bool]] = None,
                 user_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Resource to manage a set of administrator roles for a specific user. This resource allows you to manage admin roles for a single user, independent of the user schema itself.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_okta as okta

        test = okta.user.User("test",
            first_name="TestAcc",
            last_name="Smith",
            login="testAcc-replace_with_uuid@example.com",
            email="testAcc-replace_with_uuid@example.com")
        test_user_admin_roles = okta.UserAdminRoles("test",
            user_id=test.id,
            admin_roles=["APP_ADMIN"])
        ```

        ## Import

        ```sh
        $ pulumi import okta:index/userAdminRoles:UserAdminRoles example <user_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] admin_roles: The list of Okta user admin roles, e.g. `['APP_ADMIN', 'USER_ADMIN']` See [API Docs](https://developer.okta.com/docs/reference/api/roles/#role-types).
        :param pulumi.Input[bool] disable_notifications: When this setting is enabled, the admins won't receive any of the default Okta administrator emails. These admins also won't have access to contact Okta Support and open support cases on behalf of your org.
        :param pulumi.Input[str] user_id: ID of a Okta User
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: UserAdminRolesArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource to manage a set of administrator roles for a specific user. This resource allows you to manage admin roles for a single user, independent of the user schema itself.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_okta as okta

        test = okta.user.User("test",
            first_name="TestAcc",
            last_name="Smith",
            login="testAcc-replace_with_uuid@example.com",
            email="testAcc-replace_with_uuid@example.com")
        test_user_admin_roles = okta.UserAdminRoles("test",
            user_id=test.id,
            admin_roles=["APP_ADMIN"])
        ```

        ## Import

        ```sh
        $ pulumi import okta:index/userAdminRoles:UserAdminRoles example <user_id>
        ```

        :param str resource_name: The name of the resource.
        :param UserAdminRolesArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(UserAdminRolesArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 admin_roles: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 disable_notifications: Optional[pulumi.Input[bool]] = None,
                 user_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = UserAdminRolesArgs.__new__(UserAdminRolesArgs)

            if admin_roles is None and not opts.urn:
                raise TypeError("Missing required property 'admin_roles'")
            __props__.__dict__["admin_roles"] = admin_roles
            __props__.__dict__["disable_notifications"] = disable_notifications
            if user_id is None and not opts.urn:
                raise TypeError("Missing required property 'user_id'")
            __props__.__dict__["user_id"] = user_id
        super(UserAdminRoles, __self__).__init__(
            'okta:index/userAdminRoles:UserAdminRoles',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            admin_roles: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            disable_notifications: Optional[pulumi.Input[bool]] = None,
            user_id: Optional[pulumi.Input[str]] = None) -> 'UserAdminRoles':
        """
        Get an existing UserAdminRoles resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] admin_roles: The list of Okta user admin roles, e.g. `['APP_ADMIN', 'USER_ADMIN']` See [API Docs](https://developer.okta.com/docs/reference/api/roles/#role-types).
        :param pulumi.Input[bool] disable_notifications: When this setting is enabled, the admins won't receive any of the default Okta administrator emails. These admins also won't have access to contact Okta Support and open support cases on behalf of your org.
        :param pulumi.Input[str] user_id: ID of a Okta User
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _UserAdminRolesState.__new__(_UserAdminRolesState)

        __props__.__dict__["admin_roles"] = admin_roles
        __props__.__dict__["disable_notifications"] = disable_notifications
        __props__.__dict__["user_id"] = user_id
        return UserAdminRoles(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="adminRoles")
    def admin_roles(self) -> pulumi.Output[Sequence[str]]:
        """
        The list of Okta user admin roles, e.g. `['APP_ADMIN', 'USER_ADMIN']` See [API Docs](https://developer.okta.com/docs/reference/api/roles/#role-types).
        """
        return pulumi.get(self, "admin_roles")

    @property
    @pulumi.getter(name="disableNotifications")
    def disable_notifications(self) -> pulumi.Output[Optional[bool]]:
        """
        When this setting is enabled, the admins won't receive any of the default Okta administrator emails. These admins also won't have access to contact Okta Support and open support cases on behalf of your org.
        """
        return pulumi.get(self, "disable_notifications")

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> pulumi.Output[str]:
        """
        ID of a Okta User
        """
        return pulumi.get(self, "user_id")

