"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SnsNotify = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const iam = require("@aws-cdk/aws-iam");
const lambda = require("@aws-cdk/aws-lambda");
const subscriptions = require("@aws-cdk/aws-sns-subscriptions");
const cdk = require("@aws-cdk/core");
/**
 * @stability stable
 */
class SnsNotify extends cdk.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        super(scope, id);
        const lambdaFun = new lambda.Function(this, 'lambda_fun', {
            handler: 'index.handler',
            runtime: lambda.Runtime.NODEJS_12_X,
            code: lambda.Code.fromAsset(path.join(__dirname, '../', 'function')),
            environment: {
                LINE_NOTIFY_TOKEN: props.lineNotifyToken,
            },
        });
        const cloudwatchReadOnlyPolicyStatement = new iam.PolicyStatement({
            actions: ['cloudwatch:Get*'],
            resources: ['*'],
        });
        lambdaFun.role.addToPrincipalPolicy(cloudwatchReadOnlyPolicyStatement);
        this.lambdaSubscription = new subscriptions.LambdaSubscription(lambdaFun);
    }
}
exports.SnsNotify = SnsNotify;
_a = JSII_RTTI_SYMBOL_1;
SnsNotify[_a] = { fqn: "cdk-sns-notify.SnsNotify", version: "0.0.119" };
//# sourceMappingURL=data:application/json;base64,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