# This file is automatically generated by pyo3_stub_gen
# ruff: noqa: E501, F401

import builtins
import typing

import numpy
import numpy.typing

import omfiles

class OmFileReader:
    r"""
    An OmFileReader class for reading .om files synchronously.

    An OmFileReader object can represent a multidimensional array variable, a scalar variable (an attribute), or a group.
    An OmFileReader can have an arbitrary number of child readers, each representing a child node in a tree-hierarchy.
    Supports reading from local files via memory mapping or from remote files through fsspec compatibility.

    Variables in OM-Files do not have named dimensions! That means you have to know
    what the dimensions represent in advance or you need to explicitly encode them as
    some kind of attribute.
    """
    @property
    def closed(self) -> builtins.bool:
        r"""
        Check if the reader is closed.

        Returns:
            bool: True if the reader is closed, False otherwise.
        """
    @property
    def shape(self) -> tuple:
        r"""
        The shape of the variable.

        Returns:
            tuple[int, …]: The shape of the variable as a tuple.
        """
    @property
    def chunks(self) -> tuple:
        r"""
        The chunk shape of the variable.

        Returns:
            tuple[int, …]: The chunk shape of the variable as a tuple.
        """
    @property
    def is_array(self) -> builtins.bool:
        r"""
        Check if the variable is an array.

        Returns:
            bool: True if the variable is an array, False otherwise.
        """
    @property
    def is_scalar(self) -> builtins.bool:
        r"""
        Check if the variable is a scalar.

        Returns:
            bool: True if the variable is a scalar, False otherwise.
        """
    @property
    def is_group(self) -> builtins.bool:
        r"""
        Check if the variable is a group (a variable with data type None).

        Returns:
            bool: True if the variable is a group, False otherwise.
        """
    @property
    def dtype(self) -> typing.Any:
        r"""
        Get the data type of the data stored in the .om file.

        Returns:
            numpy.dtype | type: Data type of the data.
        """
    @property
    def name(self) -> builtins.str:
        r"""
        Get the name of the variable stored in the .om file.

        Returns:
            str: Name of the variable or an empty string if not available.
        """
    @property
    def compression_name(self) -> builtins.str:
        r"""
        Get the compression type of the variable.

        Returns:
            str: Compression type of the variable.
        """
    @property
    def num_children(self) -> builtins.int:
        r"""
        Number of children of the variable.

        Returns:
            int: Number of children of the variable.
        """
    def __new__(cls, source: typing.Any) -> OmFileReader:
        r"""
        Initialize an OmFileReader from a file path or fsspec file object.

        Args:
            source (str or fsspec.core.OpenFile): Path to the .om file to read or a fsspec file object.

        Raises:
            ValueError: If the file cannot be opened or is invalid.
        """
    @staticmethod
    def from_path(file_path: builtins.str) -> OmFileReader:
        r"""
        Create an OmFileReader from a file path.

        Args:
            file_path (str): Path to the .om file to read.

        Returns:
            OmFileReader: OmFileReader instance.
        """
    @staticmethod
    def from_fsspec(fs_obj: typing.Any, path: builtins.str) -> OmFileReader:
        r"""
        Create an OmFileReader from a fsspec fs object.

        Args:
            fs_obj (fsspec.spec.AbstractFileSystem): A fsspec file system object which needs to have the methods `cat_file` and `size`.
            path (str): The path to the file within the file system.

        Returns:
            OmFileReader: A new reader instance.
        """
    def _get_flat_variable_metadata(self) -> builtins.dict[builtins.str, OmVariable]:
        r"""
        Get a mapping of variable names to their file offsets and sizes.

        Returns:
            dict: Dictionary mapping variable names to their metadata.
        """
    def _init_from_variable(self, variable: OmVariable) -> OmFileReader:
        r"""
        Initialize a new OmFileReader from a child variable.

        Args:
            variable (OmVariable): Variable metadata to create a new reader from.

        Returns:
            OmFileReader: A new reader for the specified variable.
        """
    def __enter__(self) -> OmFileReader:
        r"""
        Enter a context manager block.

        Returns:
            OmFileReader: Self for use in context manager.
        """
    def __exit__(
        self,
        _exc_type: typing.Optional[typing.Any] = None,
        _exc_value: typing.Optional[typing.Any] = None,
        _traceback: typing.Optional[typing.Any] = None,
    ) -> builtins.bool:
        r"""
        Exit a context manager block, closing the reader.

        Args:
            _exc_type (type, optional): The exception type, if an exception was raised.
            _exc_value (Exception, optional): The exception value, if an exception was raised.
            _traceback (traceback, optional): The traceback, if an exception was raised.

        Returns:
            bool: False (exceptions are not suppressed).
        """
    def close(self) -> None:
        r"""
        Close the reader and release resources.

        This method releases all resources associated with the reader.
        After closing, any operation on the reader will raise a ValueError.

        It is safe to call this method multiple times.
        """
    def get_child_by_index(self, index: builtins.int) -> OmFileReader:
        r"""
        Get a child reader at the specified index.

        Returns:
            OmFileReader: Child reader at the specified index if exists.
        """
    def get_child_by_name(self, name: builtins.str) -> OmFileReader:
        r"""
        Get a child reader by name.

        Returns:
            OmFileReader: Child reader with the specified name if exists.
        """
    def read_array(
        self, ranges: omfiles.types.BasicSelection
    ) -> numpy.typing.NDArray[
        typing.Union[
            numpy.float32,
            numpy.float64,
            numpy.int32,
            numpy.int64,
            numpy.uint32,
            numpy.uint64,
            numpy.int8,
            numpy.uint8,
            numpy.int16,
            numpy.uint16,
        ]
    ]:
        r"""
        Read data from the open variable.om file using numpy-style indexing.

        Currently only slices with step 1 are supported.

        The returned array will have singleton dimensions removed (squeezed).
        For example, if you index a 3D array with [1,:,2], the result will
        be a 1D array since dimensions 0 and 2 have size 1.

        Args:
            ranges (:py:data:`omfiles.types.BasicSelection`): Index expression to select data from the array.
                Supports basic numpy indexing.

        Returns:
            numpy.typing.NDArray[numpy.int8 | numpy.int16 | numpy.int32 | numpy.int64 | numpy.uint8 | numpy.uint16 | numpy.uint32 | numpy.uint64 | numpy.float32 | numpy.float64]: NDArray containing the requested data with squeezed singleton dimensions.

        Raises:
            ValueError: If the requested ranges are invalid or if there's an error reading the data.
        """
    def __getitem__(
        self, ranges: omfiles.types.BasicSelection
    ) -> numpy.typing.NDArray[
        typing.Union[
            numpy.float32,
            numpy.float64,
            numpy.int32,
            numpy.int64,
            numpy.uint32,
            numpy.uint64,
            numpy.int8,
            numpy.uint8,
            numpy.int16,
            numpy.uint16,
        ]
    ]: ...
    def read_scalar(self) -> typing.Any:
        r"""
        Read the scalar value of the variable.

        Returns:
            object: The scalar value as a Python object (str, int, or float).

        Raises:
            ValueError: If the variable is not a scalar.
        """

class OmFileReaderAsync:
    r"""
    An OmFileReaderAsync class for reading .om files asynchronously.

    An OmFileReaderAsync object can represent a multidimensional array variable, a scalar variable (an attribute), or a group.
    An OmFileReaderAsync can have an arbitrary number of child readers, each representing a child node in a tree-hierarchy.
    Supports reading from local files via memory mapping or from remote files through fsspec compatibility.

    Variables in OM-Files do not have named dimensions! That means you have to know
    what the dimensions represent in advance or you need to explicitly encode them as
    some kind of attribute.
    """
    @property
    def closed(self) -> builtins.bool:
        r"""
        Check if the reader is closed.

        Returns:
            bool: True if the reader is closed, False otherwise.
        """
    @property
    def shape(self) -> tuple:
        r"""
        The shape of the variable.

        Returns:
            tuple[int, …]: The shape of the variable as a tuple.
        """
    @property
    def chunks(self) -> tuple:
        r"""
        The chunk shape of the variable.

        Returns:
            tuple[int, …]: The chunk shape of the variable as a tuple.
        """
    @property
    def is_array(self) -> builtins.bool:
        r"""
        Check if the variable is an array.

        Returns:
            bool: True if the variable is an array, False otherwise.
        """
    @property
    def is_scalar(self) -> builtins.bool:
        r"""
        Check if the variable is a scalar.

        Returns:
            bool: True if the variable is a scalar, False otherwise.
        """
    @property
    def is_group(self) -> builtins.bool:
        r"""
        Check if the variable is a group (a variable with data type None).

        Returns:
            bool: True if the variable is a group, False otherwise.
        """
    @property
    def dtype(self) -> typing.Any:
        r"""
        Get the data type of the data stored in the .om file.

        Returns:
            numpy.dtype | type: Data type of the data.
        """
    @property
    def name(self) -> builtins.str:
        r"""
        Get the name of the variable stored in the .om file.

        Returns:
            str: Name of the variable or an empty string if not available.
        """
    @property
    def compression_name(self) -> builtins.str:
        r"""
        Get the compression type of the variable.

        Returns:
            str: Compression type of the variable.
        """
    @property
    def num_children(self) -> builtins.int:
        r"""
        Number of children of the variable.

        Returns:
            int: Number of children of the variable.
        """
    @staticmethod
    async def from_fsspec(fs_obj: typing.Any, path: builtins.str) -> OmFileReaderAsync:
        r"""
        Create a new async reader from an fsspec fs object.

        Args:
            fs_obj (fsspec.spec.AbstractFileSystem): A fsspec file system object which needs to have the async methods `_cat_file` and `_size`.
            path (str): The path to the file within the file system.

        Returns:
            OmFileReaderAsync: A new reader instance.

        Raises:
            TypeError: If the provided file object is not a valid fsspec file.
            IOError: If there's an error reading the file.
        """
    @staticmethod
    async def from_path(file_path: builtins.str) -> OmFileReaderAsync:
        r"""
        Create a new async reader from a local file path.

        Args:
            file_path (str): Path to the OM file to read.

        Returns:
            OmFileReaderAsync: A new reader instance.

        Raises:
            IOError: If the file cannot be opened or read.
        """
    def __enter__(self) -> OmFileReaderAsync:
        r"""
        Enter a context manager block.

        Returns:
            OmFileReaderAsync: Self for use in context manager.
        """
    def __exit__(
        self,
        _exc_type: typing.Optional[typing.Any] = None,
        _exc_value: typing.Optional[typing.Any] = None,
        _traceback: typing.Optional[typing.Any] = None,
    ) -> builtins.bool:
        r"""
        Exit a context manager block, closing the reader.

        Args:
            _exc_type (type, optional): The exception type, if an exception was raised.
            _exc_value (Exception, optional): The exception value, if an exception was raised.
            _traceback (traceback, optional): The traceback, if an exception was raised.

        Returns:
            bool: False (exceptions are not suppressed).
        """
    def close(self) -> None:
        r"""
        Close the reader and release any resources.

        Properly closes the underlying file resources.

        Returns:
            None

        Raises:
            RuntimeError: If the reader cannot be closed due to concurrent access.
        """
    async def get_child_by_index(self, index: builtins.int) -> OmFileReaderAsync:
        r"""
        Get a child reader at the specified index.

        Returns:
            OmFileReaderAsync: Child reader at the specified index if exists.
        """
    async def get_child_by_name(self, name: builtins.str) -> OmFileReaderAsync:
        r"""
        Get a child reader by name.

        Returns:
            OmFileReaderAsync: Child reader with the specified name if exists.
        """
    async def read_array(
        self, ranges: omfiles.types.BasicSelection
    ) -> numpy.typing.NDArray[
        typing.Union[
            numpy.float32,
            numpy.float64,
            numpy.int32,
            numpy.int64,
            numpy.uint32,
            numpy.uint64,
            numpy.int8,
            numpy.uint8,
            numpy.int16,
            numpy.uint16,
        ]
    ]:
        r"""
        Read data from the array concurrently based on specified ranges.

        Args:
            ranges (:py:data:`omfiles.types.BasicSelection`): Index or slice object specifying the ranges to read.

        Returns:
            OmFileTypedArray: Array data of the appropriate numpy type.

        Raises:
            ValueError: If the reader is closed.
            TypeError: If the data type is not supported.
        """
    def read_scalar(self) -> typing.Any:
        r"""
        Read the scalar value of the variable.

        Returns:
            object: The scalar value as a Python object (str, int, or float).

        Raises:
            ValueError: If the variable is not a scalar.
        """

class OmFileWriter:
    r"""
    A Python wrapper for the Rust OmFileWriter implementation.
    """
    @property
    def closed(self) -> builtins.bool:
        r"""
        Check if the writer is closed.
        """
    def __new__(cls, file_path: builtins.str) -> OmFileWriter:
        r"""
        Initialize an OmFileWriter.

        Args:
            file_path: Path where the .om file will be created
        """
    @staticmethod
    def at_path(path: builtins.str) -> OmFileWriter:
        r"""
        Initialize an OmFileWriter to write to a file at the specified path.

        Args:
            path: Path where the .om file will be created

        Returns:
            OmFileWriter: A new writer instance
        """
    @staticmethod
    def from_fsspec(fs_obj: typing.Any, path: builtins.str) -> OmFileWriter:
        r"""
        Create an OmFileWriter from a fsspec filesystem object.

        Args:
            fs_obj: A fsspec filesystem object that supports write operations
            path: The path to the file within the file system

        Returns:
            OmFileWriter: A new writer instance
        """
    def close(self, root_variable: OmVariable) -> None:
        r"""
        Finalize and close the .om file by writing the trailer with the root variable.

        Args:
            root_variable (:py:data:`omfiles.OmVariable`): The OmVariable that serves as the root/entry point of the file hierarchy.
                           All other variables should be accessible through this root variable.

        Returns:
            None on success.

        Raises:
            ValueError: If the writer has already been closed
            RuntimeError: If a thread lock error occurs or if there's an error writing to the file
        """
    def write_array(
        self,
        data: numpy.typing.NDArray[typing.Any],
        chunks: typing.Sequence[builtins.int],
        scale_factor: typing.Optional[builtins.float] = None,
        add_offset: typing.Optional[builtins.float] = None,
        compression: typing.Optional[builtins.str] = None,
        name: typing.Optional[builtins.str] = None,
        children: typing.Optional[typing.Sequence[OmVariable]] = None,
    ) -> OmVariable:
        r"""
        Write a numpy array to the .om file with specified chunking and scaling parameters.

        ``scale_factor`` and ``add_offset`` are only respected and required for float32
        and float64 data types. Recommended compression is "pfor_delta_2d" as it achieves
        best compression ratios (on spatio-temporally correlated data), but it will be lossy
        when applied to floating-point data types because of the scale-offset encoding applied
        to convert float values to integer values.

        Args:
            data: Input array to be written. Supported dtypes are:
                  float32, float64, int8, uint8, int16, uint16, int32, uint32, int64, uint64,
            chunks: Chunk sizes for each dimension of the array
            scale_factor: Scale factor for data compression (default: 1.0)
            add_offset: Offset value for data compression (default: 0.0)
            compression: Compression algorithm to use (default: "pfor_delta_2d")
                         Supported values: "pfor_delta_2d", "fpx_xor_2d", "pfor_delta_2d_int16", "pfor_delta_2d_int16_logarithmic"
            name: Name of the variable to be written (default: "data")
            children: List of child variables (default: [])

        Returns:
            :py:data:`omfiles.OmVariable` representing the written group in the file structure

        Raises:
            ValueError: If the data type is unsupported or if parameters are invalid
        """
    def write_scalar(
        self, value: typing.Any, name: builtins.str, children: typing.Optional[typing.Sequence[OmVariable]] = None
    ) -> OmVariable:
        r"""
        Write a scalar value to the .om file.

        Args:
            value: Scalar value to write. Supported types are:
                   int8, int16, int32, int64, uint8, uint16, uint32, uint64, float32, float64, String
            name: Name of the scalar variable
            children: List of child variables (default: None)

        Returns:
            :py:data:`omfiles.OmVariable` representing the written scalar in the file structure

        Raises:
            ValueError: If the value type is unsupported (e.g., booleans)
            RuntimeError: If there's an error writing to the file
        """
    def write_group(self, name: builtins.str, children: typing.Sequence[OmVariable]) -> OmVariable:
        r"""
        Create a new group in the .om file.

        This is essentially a variable with no data, which serves as a container for other variables.

        Args:
            name: Name of the group
            children: List of child variables

        Returns:
            :py:data:`omfiles.OmVariable` representing the written group in the file structure

        Raises:
            RuntimeError: If there's an error writing to the file
        """

class OmVariable:
    r"""
    Represents a variable in an OM file.
    """
    @property
    def name(self) -> builtins.str:
        r"""
        The name of the variable.
        """
    @property
    def offset(self) -> builtins.int:
        r"""
        The offset of the variable in the OM file.
        """
    @property
    def size(self) -> builtins.int:
        r"""
        The size of the variable in bytes in the OM file.
        """
    def __repr__(self) -> builtins.str: ...

class RustPforCodec:
    r"""
    RustPforCodec codec for compressing and decompressing integer arrays.

    Supports numpy arrays of dtype: int8, int16, int32, int64, uint8, uint16, uint32, uint64.
    """
    def __new__(cls) -> RustPforCodec:
        r"""
        Create a new RustPforCodec codec instance.
        """
    def encode_array(self, array: numpy.typing.NDArray[typing.Any], dtype: numpy.dtype) -> bytes:
        r"""
        Compress a numpy integer array using RustPforCodec.

        Args:
            array: Input numpy array (integer dtype).
            dtype: Numpy dtype of the array.

        Returns:
            Compressed bytes.
        """
    def decode_array(self, data: bytes, dtype: numpy.dtype, length: builtins.int) -> numpy.typing.NDArray[typing.Any]:
        r"""
        Decompress RustPforCodec-compressed bytes into a numpy array.

        Args:
            data: Compressed bytes.
            dtype: Numpy dtype of the output array.
            length: Number of elements in the output array.

        Returns:
            Decompressed numpy array.
        """

def _check_cpu_features() -> None:
    r"""
    Check if the CPU has the required features for SIMD compression operations.
    """
