# Experiments (DVC Integration)

DataChain Studio provides comprehensive ML experiment tracking through DVC integration, allowing you to track, compare, and manage your machine learning experiments with Git-based versioning.

## Overview

DataChain Studio integrates with DVC (Data Version Control) to provide a powerful web-based interface for managing your ML experiments. By connecting your Git repositories, you can visualize experiment results, compare different runs, and collaborate with your team—all without leaving your browser.

### Key Features

**Project Management**

- [Create projects](./create-a-project.md) by connecting to GitHub, GitLab, or Bitbucket repositories
- [Configure project settings](./configure-a-project.md) including project directory, data remotes, and column tracking
- Support for monorepos with multiple ML projects in different sub-directories
- [Share projects](./share-a-project.md) with your team or make them publicly accessible

**Experiment Tracking**

- [Explore ML experiments](./explore-ml-experiments.md) with a comprehensive project table showing Git history, metrics, hyperparameters, and DVC-tracked files
- [Generate live metrics and plots](./live-metrics-and-plots.md) for running experiments using DVCLive
- [Monitor running experiments](./run-experiments.md) in real-time with status updates and output logs
- Automatic tracking of experiments pushed with `dvc exp push`

**Visualization and Comparison**
- [Visualize and compare experiments](./visualize-and-compare.md) using plots, images, and trend charts
- Display plots generated by DVCLive including AUC curves, loss functions, and confusion matrices
- Compare up to seven experiments side by side
- Generate trend charts to see how metrics changed over time
- Export project data to CSV for external analysis

**Collaboration**
- Create teams with multiple collaborators
- Share projects within a team or publicly on the web
- Track experiments from different branches and commits
- Review and manage experiments through pull/merge requests

### Getting Started

1. **[Create a project](./create-a-project.md)** - Connect your Git repository to DataChain Studio
2. **[Configure your project](./configure-a-project.md)** - Set up data remotes, credentials, and tracking preferences
3. **[Run experiments](./run-experiments.md)** - Start tracking your ML experiments with DVC and DVCLive
4. **[Explore and visualize](./explore-ml-experiments.md)** - Analyze your results in the project table and plots
5. **[Share your work](./share-a-project.md)** - Collaborate with your team or share publicly
