# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['AppSecActivationsArgs', 'AppSecActivations']

@pulumi.input_type
class AppSecActivationsArgs:
    def __init__(__self__, *,
                 config_id: pulumi.Input[_builtins.int],
                 notification_emails: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 version: pulumi.Input[_builtins.int],
                 network: Optional[pulumi.Input[_builtins.str]] = None,
                 note: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a AppSecActivations resource.
        :param pulumi.Input[_builtins.int] config_id: Unique identifier of the security configuration to be activated
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] notification_emails: List of email addresses to be notified with the results of the activation
        :param pulumi.Input[_builtins.int] version: Version of the security configuration to be activated
        :param pulumi.Input[_builtins.str] network: Network on which to activate the configuration version (STAGING or PRODUCTION)
        :param pulumi.Input[_builtins.str] note: Note describing the activation. Will use timestamp if omitted.
        """
        pulumi.set(__self__, "config_id", config_id)
        pulumi.set(__self__, "notification_emails", notification_emails)
        pulumi.set(__self__, "version", version)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if note is not None:
            pulumi.set(__self__, "note", note)

    @_builtins.property
    @pulumi.getter(name="configId")
    def config_id(self) -> pulumi.Input[_builtins.int]:
        """
        Unique identifier of the security configuration to be activated
        """
        return pulumi.get(self, "config_id")

    @config_id.setter
    def config_id(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "config_id", value)

    @_builtins.property
    @pulumi.getter(name="notificationEmails")
    def notification_emails(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        List of email addresses to be notified with the results of the activation
        """
        return pulumi.get(self, "notification_emails")

    @notification_emails.setter
    def notification_emails(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "notification_emails", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Input[_builtins.int]:
        """
        Version of the security configuration to be activated
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "version", value)

    @_builtins.property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Network on which to activate the configuration version (STAGING or PRODUCTION)
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network", value)

    @_builtins.property
    @pulumi.getter
    def note(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Note describing the activation. Will use timestamp if omitted.
        """
        return pulumi.get(self, "note")

    @note.setter
    def note(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "note", value)


@pulumi.input_type
class _AppSecActivationsState:
    def __init__(__self__, *,
                 config_id: Optional[pulumi.Input[_builtins.int]] = None,
                 network: Optional[pulumi.Input[_builtins.str]] = None,
                 note: Optional[pulumi.Input[_builtins.str]] = None,
                 notification_emails: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 version: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering AppSecActivations resources.
        :param pulumi.Input[_builtins.int] config_id: Unique identifier of the security configuration to be activated
        :param pulumi.Input[_builtins.str] network: Network on which to activate the configuration version (STAGING or PRODUCTION)
        :param pulumi.Input[_builtins.str] note: Note describing the activation. Will use timestamp if omitted.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] notification_emails: List of email addresses to be notified with the results of the activation
        :param pulumi.Input[_builtins.str] status: The results of the activation
        :param pulumi.Input[_builtins.int] version: Version of the security configuration to be activated
        """
        if config_id is not None:
            pulumi.set(__self__, "config_id", config_id)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if note is not None:
            pulumi.set(__self__, "note", note)
        if notification_emails is not None:
            pulumi.set(__self__, "notification_emails", notification_emails)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter(name="configId")
    def config_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Unique identifier of the security configuration to be activated
        """
        return pulumi.get(self, "config_id")

    @config_id.setter
    def config_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "config_id", value)

    @_builtins.property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Network on which to activate the configuration version (STAGING or PRODUCTION)
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network", value)

    @_builtins.property
    @pulumi.getter
    def note(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Note describing the activation. Will use timestamp if omitted.
        """
        return pulumi.get(self, "note")

    @note.setter
    def note(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "note", value)

    @_builtins.property
    @pulumi.getter(name="notificationEmails")
    def notification_emails(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of email addresses to be notified with the results of the activation
        """
        return pulumi.get(self, "notification_emails")

    @notification_emails.setter
    def notification_emails(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "notification_emails", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The results of the activation
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Version of the security configuration to be activated
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "version", value)


@pulumi.type_token("akamai:index/appSecActivations:AppSecActivations")
class AppSecActivations(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 config_id: Optional[pulumi.Input[_builtins.int]] = None,
                 network: Optional[pulumi.Input[_builtins.str]] = None,
                 note: Optional[pulumi.Input[_builtins.str]] = None,
                 notification_emails: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 version: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        Create a AppSecActivations resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] config_id: Unique identifier of the security configuration to be activated
        :param pulumi.Input[_builtins.str] network: Network on which to activate the configuration version (STAGING or PRODUCTION)
        :param pulumi.Input[_builtins.str] note: Note describing the activation. Will use timestamp if omitted.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] notification_emails: List of email addresses to be notified with the results of the activation
        :param pulumi.Input[_builtins.int] version: Version of the security configuration to be activated
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AppSecActivationsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a AppSecActivations resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param AppSecActivationsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AppSecActivationsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 config_id: Optional[pulumi.Input[_builtins.int]] = None,
                 network: Optional[pulumi.Input[_builtins.str]] = None,
                 note: Optional[pulumi.Input[_builtins.str]] = None,
                 notification_emails: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 version: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AppSecActivationsArgs.__new__(AppSecActivationsArgs)

            if config_id is None and not opts.urn:
                raise TypeError("Missing required property 'config_id'")
            __props__.__dict__["config_id"] = config_id
            __props__.__dict__["network"] = network
            __props__.__dict__["note"] = note
            if notification_emails is None and not opts.urn:
                raise TypeError("Missing required property 'notification_emails'")
            __props__.__dict__["notification_emails"] = notification_emails
            if version is None and not opts.urn:
                raise TypeError("Missing required property 'version'")
            __props__.__dict__["version"] = version
            __props__.__dict__["status"] = None
        super(AppSecActivations, __self__).__init__(
            'akamai:index/appSecActivations:AppSecActivations',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            config_id: Optional[pulumi.Input[_builtins.int]] = None,
            network: Optional[pulumi.Input[_builtins.str]] = None,
            note: Optional[pulumi.Input[_builtins.str]] = None,
            notification_emails: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            version: Optional[pulumi.Input[_builtins.int]] = None) -> 'AppSecActivations':
        """
        Get an existing AppSecActivations resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] config_id: Unique identifier of the security configuration to be activated
        :param pulumi.Input[_builtins.str] network: Network on which to activate the configuration version (STAGING or PRODUCTION)
        :param pulumi.Input[_builtins.str] note: Note describing the activation. Will use timestamp if omitted.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] notification_emails: List of email addresses to be notified with the results of the activation
        :param pulumi.Input[_builtins.str] status: The results of the activation
        :param pulumi.Input[_builtins.int] version: Version of the security configuration to be activated
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AppSecActivationsState.__new__(_AppSecActivationsState)

        __props__.__dict__["config_id"] = config_id
        __props__.__dict__["network"] = network
        __props__.__dict__["note"] = note
        __props__.__dict__["notification_emails"] = notification_emails
        __props__.__dict__["status"] = status
        __props__.__dict__["version"] = version
        return AppSecActivations(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="configId")
    def config_id(self) -> pulumi.Output[_builtins.int]:
        """
        Unique identifier of the security configuration to be activated
        """
        return pulumi.get(self, "config_id")

    @_builtins.property
    @pulumi.getter
    def network(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Network on which to activate the configuration version (STAGING or PRODUCTION)
        """
        return pulumi.get(self, "network")

    @_builtins.property
    @pulumi.getter
    def note(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Note describing the activation. Will use timestamp if omitted.
        """
        return pulumi.get(self, "note")

    @_builtins.property
    @pulumi.getter(name="notificationEmails")
    def notification_emails(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        List of email addresses to be notified with the results of the activation
        """
        return pulumi.get(self, "notification_emails")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The results of the activation
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Output[_builtins.int]:
        """
        Version of the security configuration to be activated
        """
        return pulumi.get(self, "version")

