# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['AppSecReputationProfileArgs', 'AppSecReputationProfile']

@pulumi.input_type
class AppSecReputationProfileArgs:
    def __init__(__self__, *,
                 config_id: pulumi.Input[_builtins.int],
                 reputation_profile: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a AppSecReputationProfile resource.
        :param pulumi.Input[_builtins.int] config_id: Unique identifier of the security configuration
        :param pulumi.Input[_builtins.str] reputation_profile: JSON-formatted definition of the reputation profile
        """
        pulumi.set(__self__, "config_id", config_id)
        pulumi.set(__self__, "reputation_profile", reputation_profile)

    @_builtins.property
    @pulumi.getter(name="configId")
    def config_id(self) -> pulumi.Input[_builtins.int]:
        """
        Unique identifier of the security configuration
        """
        return pulumi.get(self, "config_id")

    @config_id.setter
    def config_id(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "config_id", value)

    @_builtins.property
    @pulumi.getter(name="reputationProfile")
    def reputation_profile(self) -> pulumi.Input[_builtins.str]:
        """
        JSON-formatted definition of the reputation profile
        """
        return pulumi.get(self, "reputation_profile")

    @reputation_profile.setter
    def reputation_profile(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "reputation_profile", value)


@pulumi.input_type
class _AppSecReputationProfileState:
    def __init__(__self__, *,
                 config_id: Optional[pulumi.Input[_builtins.int]] = None,
                 reputation_profile: Optional[pulumi.Input[_builtins.str]] = None,
                 reputation_profile_id: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering AppSecReputationProfile resources.
        :param pulumi.Input[_builtins.int] config_id: Unique identifier of the security configuration
        :param pulumi.Input[_builtins.str] reputation_profile: JSON-formatted definition of the reputation profile
        :param pulumi.Input[_builtins.int] reputation_profile_id: Unique identifier of the reputation profile
        """
        if config_id is not None:
            pulumi.set(__self__, "config_id", config_id)
        if reputation_profile is not None:
            pulumi.set(__self__, "reputation_profile", reputation_profile)
        if reputation_profile_id is not None:
            pulumi.set(__self__, "reputation_profile_id", reputation_profile_id)

    @_builtins.property
    @pulumi.getter(name="configId")
    def config_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Unique identifier of the security configuration
        """
        return pulumi.get(self, "config_id")

    @config_id.setter
    def config_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "config_id", value)

    @_builtins.property
    @pulumi.getter(name="reputationProfile")
    def reputation_profile(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        JSON-formatted definition of the reputation profile
        """
        return pulumi.get(self, "reputation_profile")

    @reputation_profile.setter
    def reputation_profile(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "reputation_profile", value)

    @_builtins.property
    @pulumi.getter(name="reputationProfileId")
    def reputation_profile_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Unique identifier of the reputation profile
        """
        return pulumi.get(self, "reputation_profile_id")

    @reputation_profile_id.setter
    def reputation_profile_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "reputation_profile_id", value)


@pulumi.type_token("akamai:index/appSecReputationProfile:AppSecReputationProfile")
class AppSecReputationProfile(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 config_id: Optional[pulumi.Input[_builtins.int]] = None,
                 reputation_profile: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Create a AppSecReputationProfile resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] config_id: Unique identifier of the security configuration
        :param pulumi.Input[_builtins.str] reputation_profile: JSON-formatted definition of the reputation profile
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AppSecReputationProfileArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a AppSecReputationProfile resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param AppSecReputationProfileArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AppSecReputationProfileArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 config_id: Optional[pulumi.Input[_builtins.int]] = None,
                 reputation_profile: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AppSecReputationProfileArgs.__new__(AppSecReputationProfileArgs)

            if config_id is None and not opts.urn:
                raise TypeError("Missing required property 'config_id'")
            __props__.__dict__["config_id"] = config_id
            if reputation_profile is None and not opts.urn:
                raise TypeError("Missing required property 'reputation_profile'")
            __props__.__dict__["reputation_profile"] = reputation_profile
            __props__.__dict__["reputation_profile_id"] = None
        super(AppSecReputationProfile, __self__).__init__(
            'akamai:index/appSecReputationProfile:AppSecReputationProfile',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            config_id: Optional[pulumi.Input[_builtins.int]] = None,
            reputation_profile: Optional[pulumi.Input[_builtins.str]] = None,
            reputation_profile_id: Optional[pulumi.Input[_builtins.int]] = None) -> 'AppSecReputationProfile':
        """
        Get an existing AppSecReputationProfile resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] config_id: Unique identifier of the security configuration
        :param pulumi.Input[_builtins.str] reputation_profile: JSON-formatted definition of the reputation profile
        :param pulumi.Input[_builtins.int] reputation_profile_id: Unique identifier of the reputation profile
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AppSecReputationProfileState.__new__(_AppSecReputationProfileState)

        __props__.__dict__["config_id"] = config_id
        __props__.__dict__["reputation_profile"] = reputation_profile
        __props__.__dict__["reputation_profile_id"] = reputation_profile_id
        return AppSecReputationProfile(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="configId")
    def config_id(self) -> pulumi.Output[_builtins.int]:
        """
        Unique identifier of the security configuration
        """
        return pulumi.get(self, "config_id")

    @_builtins.property
    @pulumi.getter(name="reputationProfile")
    def reputation_profile(self) -> pulumi.Output[_builtins.str]:
        """
        JSON-formatted definition of the reputation profile
        """
        return pulumi.get(self, "reputation_profile")

    @_builtins.property
    @pulumi.getter(name="reputationProfileId")
    def reputation_profile_id(self) -> pulumi.Output[_builtins.int]:
        """
        Unique identifier of the reputation profile
        """
        return pulumi.get(self, "reputation_profile_id")

