# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['AppsecRapidRulesArgs', 'AppsecRapidRules']

@pulumi.input_type
class AppsecRapidRulesArgs:
    def __init__(__self__, *,
                 config_id: pulumi.Input[_builtins.int],
                 security_policy_id: pulumi.Input[_builtins.str],
                 default_action: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_definitions: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a AppsecRapidRules resource.
        :param pulumi.Input[_builtins.int] config_id: Unique identifier of the security configuration
        :param pulumi.Input[_builtins.str] security_policy_id: Unique identifier of the security policy
        :param pulumi.Input[_builtins.str] default_action: Default action that applies to violations of all rapid rules
        :param pulumi.Input[_builtins.str] rule_definitions: JSON-formatted list of rule definition (ID, action, action lock and exception)
        """
        pulumi.set(__self__, "config_id", config_id)
        pulumi.set(__self__, "security_policy_id", security_policy_id)
        if default_action is not None:
            pulumi.set(__self__, "default_action", default_action)
        if rule_definitions is not None:
            pulumi.set(__self__, "rule_definitions", rule_definitions)

    @_builtins.property
    @pulumi.getter(name="configId")
    def config_id(self) -> pulumi.Input[_builtins.int]:
        """
        Unique identifier of the security configuration
        """
        return pulumi.get(self, "config_id")

    @config_id.setter
    def config_id(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "config_id", value)

    @_builtins.property
    @pulumi.getter(name="securityPolicyId")
    def security_policy_id(self) -> pulumi.Input[_builtins.str]:
        """
        Unique identifier of the security policy
        """
        return pulumi.get(self, "security_policy_id")

    @security_policy_id.setter
    def security_policy_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "security_policy_id", value)

    @_builtins.property
    @pulumi.getter(name="defaultAction")
    def default_action(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Default action that applies to violations of all rapid rules
        """
        return pulumi.get(self, "default_action")

    @default_action.setter
    def default_action(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_action", value)

    @_builtins.property
    @pulumi.getter(name="ruleDefinitions")
    def rule_definitions(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        JSON-formatted list of rule definition (ID, action, action lock and exception)
        """
        return pulumi.get(self, "rule_definitions")

    @rule_definitions.setter
    def rule_definitions(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rule_definitions", value)


@pulumi.input_type
class _AppsecRapidRulesState:
    def __init__(__self__, *,
                 config_id: Optional[pulumi.Input[_builtins.int]] = None,
                 default_action: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 rule_definitions: Optional[pulumi.Input[_builtins.str]] = None,
                 security_policy_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering AppsecRapidRules resources.
        :param pulumi.Input[_builtins.int] config_id: Unique identifier of the security configuration
        :param pulumi.Input[_builtins.str] default_action: Default action that applies to violations of all rapid rules
        :param pulumi.Input[_builtins.bool] enabled: Hidden attribute containing information about rapid rules status enabled/disabled
        :param pulumi.Input[_builtins.str] rule_definitions: JSON-formatted list of rule definition (ID, action, action lock and exception)
        :param pulumi.Input[_builtins.str] security_policy_id: Unique identifier of the security policy
        """
        if config_id is not None:
            pulumi.set(__self__, "config_id", config_id)
        if default_action is not None:
            pulumi.set(__self__, "default_action", default_action)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if rule_definitions is not None:
            pulumi.set(__self__, "rule_definitions", rule_definitions)
        if security_policy_id is not None:
            pulumi.set(__self__, "security_policy_id", security_policy_id)

    @_builtins.property
    @pulumi.getter(name="configId")
    def config_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Unique identifier of the security configuration
        """
        return pulumi.get(self, "config_id")

    @config_id.setter
    def config_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "config_id", value)

    @_builtins.property
    @pulumi.getter(name="defaultAction")
    def default_action(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Default action that applies to violations of all rapid rules
        """
        return pulumi.get(self, "default_action")

    @default_action.setter
    def default_action(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_action", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Hidden attribute containing information about rapid rules status enabled/disabled
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="ruleDefinitions")
    def rule_definitions(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        JSON-formatted list of rule definition (ID, action, action lock and exception)
        """
        return pulumi.get(self, "rule_definitions")

    @rule_definitions.setter
    def rule_definitions(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rule_definitions", value)

    @_builtins.property
    @pulumi.getter(name="securityPolicyId")
    def security_policy_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique identifier of the security policy
        """
        return pulumi.get(self, "security_policy_id")

    @security_policy_id.setter
    def security_policy_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_policy_id", value)


@pulumi.type_token("akamai:index/appsecRapidRules:AppsecRapidRules")
class AppsecRapidRules(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 config_id: Optional[pulumi.Input[_builtins.int]] = None,
                 default_action: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_definitions: Optional[pulumi.Input[_builtins.str]] = None,
                 security_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Create a AppsecRapidRules resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] config_id: Unique identifier of the security configuration
        :param pulumi.Input[_builtins.str] default_action: Default action that applies to violations of all rapid rules
        :param pulumi.Input[_builtins.str] rule_definitions: JSON-formatted list of rule definition (ID, action, action lock and exception)
        :param pulumi.Input[_builtins.str] security_policy_id: Unique identifier of the security policy
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AppsecRapidRulesArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a AppsecRapidRules resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param AppsecRapidRulesArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AppsecRapidRulesArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 config_id: Optional[pulumi.Input[_builtins.int]] = None,
                 default_action: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_definitions: Optional[pulumi.Input[_builtins.str]] = None,
                 security_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AppsecRapidRulesArgs.__new__(AppsecRapidRulesArgs)

            if config_id is None and not opts.urn:
                raise TypeError("Missing required property 'config_id'")
            __props__.__dict__["config_id"] = config_id
            __props__.__dict__["default_action"] = default_action
            __props__.__dict__["rule_definitions"] = rule_definitions
            if security_policy_id is None and not opts.urn:
                raise TypeError("Missing required property 'security_policy_id'")
            __props__.__dict__["security_policy_id"] = security_policy_id
            __props__.__dict__["enabled"] = None
        super(AppsecRapidRules, __self__).__init__(
            'akamai:index/appsecRapidRules:AppsecRapidRules',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            config_id: Optional[pulumi.Input[_builtins.int]] = None,
            default_action: Optional[pulumi.Input[_builtins.str]] = None,
            enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            rule_definitions: Optional[pulumi.Input[_builtins.str]] = None,
            security_policy_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'AppsecRapidRules':
        """
        Get an existing AppsecRapidRules resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] config_id: Unique identifier of the security configuration
        :param pulumi.Input[_builtins.str] default_action: Default action that applies to violations of all rapid rules
        :param pulumi.Input[_builtins.bool] enabled: Hidden attribute containing information about rapid rules status enabled/disabled
        :param pulumi.Input[_builtins.str] rule_definitions: JSON-formatted list of rule definition (ID, action, action lock and exception)
        :param pulumi.Input[_builtins.str] security_policy_id: Unique identifier of the security policy
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AppsecRapidRulesState.__new__(_AppsecRapidRulesState)

        __props__.__dict__["config_id"] = config_id
        __props__.__dict__["default_action"] = default_action
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["rule_definitions"] = rule_definitions
        __props__.__dict__["security_policy_id"] = security_policy_id
        return AppsecRapidRules(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="configId")
    def config_id(self) -> pulumi.Output[_builtins.int]:
        """
        Unique identifier of the security configuration
        """
        return pulumi.get(self, "config_id")

    @_builtins.property
    @pulumi.getter(name="defaultAction")
    def default_action(self) -> pulumi.Output[_builtins.str]:
        """
        Default action that applies to violations of all rapid rules
        """
        return pulumi.get(self, "default_action")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Hidden attribute containing information about rapid rules status enabled/disabled
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="ruleDefinitions")
    def rule_definitions(self) -> pulumi.Output[_builtins.str]:
        """
        JSON-formatted list of rule definition (ID, action, action lock and exception)
        """
        return pulumi.get(self, "rule_definitions")

    @_builtins.property
    @pulumi.getter(name="securityPolicyId")
    def security_policy_id(self) -> pulumi.Output[_builtins.str]:
        """
        Unique identifier of the security policy
        """
        return pulumi.get(self, "security_policy_id")

