# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CloudletsPolicyActivationArgs', 'CloudletsPolicyActivation']

@pulumi.input_type
class CloudletsPolicyActivationArgs:
    def __init__(__self__, *,
                 network: pulumi.Input[_builtins.str],
                 policy_id: pulumi.Input[_builtins.int],
                 version: pulumi.Input[_builtins.int],
                 associated_properties: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input['CloudletsPolicyActivationTimeoutsArgs']] = None):
        """
        The set of arguments for constructing a CloudletsPolicyActivation resource.
        :param pulumi.Input[_builtins.str] network: The network you want to activate the policy version on (options are Staging and Production)
        :param pulumi.Input[_builtins.int] policy_id: ID of the Cloudlets policy you want to activate
        :param pulumi.Input[_builtins.int] version: Cloudlets policy version you want to activate
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] associated_properties: Set of property IDs to link to this Cloudlets policy. It is required for non-shared policies
        :param pulumi.Input['CloudletsPolicyActivationTimeoutsArgs'] timeouts: Enables to set timeout for processing
        """
        pulumi.set(__self__, "network", network)
        pulumi.set(__self__, "policy_id", policy_id)
        pulumi.set(__self__, "version", version)
        if associated_properties is not None:
            pulumi.set(__self__, "associated_properties", associated_properties)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @_builtins.property
    @pulumi.getter
    def network(self) -> pulumi.Input[_builtins.str]:
        """
        The network you want to activate the policy version on (options are Staging and Production)
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "network", value)

    @_builtins.property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> pulumi.Input[_builtins.int]:
        """
        ID of the Cloudlets policy you want to activate
        """
        return pulumi.get(self, "policy_id")

    @policy_id.setter
    def policy_id(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "policy_id", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Input[_builtins.int]:
        """
        Cloudlets policy version you want to activate
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "version", value)

    @_builtins.property
    @pulumi.getter(name="associatedProperties")
    def associated_properties(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Set of property IDs to link to this Cloudlets policy. It is required for non-shared policies
        """
        return pulumi.get(self, "associated_properties")

    @associated_properties.setter
    def associated_properties(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "associated_properties", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['CloudletsPolicyActivationTimeoutsArgs']]:
        """
        Enables to set timeout for processing
        """
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['CloudletsPolicyActivationTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.input_type
class _CloudletsPolicyActivationState:
    def __init__(__self__, *,
                 associated_properties: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 is_shared: Optional[pulumi.Input[_builtins.bool]] = None,
                 network: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_id: Optional[pulumi.Input[_builtins.int]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 timeouts: Optional[pulumi.Input['CloudletsPolicyActivationTimeoutsArgs']] = None,
                 version: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering CloudletsPolicyActivation resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] associated_properties: Set of property IDs to link to this Cloudlets policy. It is required for non-shared policies
        :param pulumi.Input[_builtins.bool] is_shared: Indicates if policy that is being activated is a shared policy
        :param pulumi.Input[_builtins.str] network: The network you want to activate the policy version on (options are Staging and Production)
        :param pulumi.Input[_builtins.int] policy_id: ID of the Cloudlets policy you want to activate
        :param pulumi.Input[_builtins.str] status: Activation status for this Cloudlets policy
        :param pulumi.Input['CloudletsPolicyActivationTimeoutsArgs'] timeouts: Enables to set timeout for processing
        :param pulumi.Input[_builtins.int] version: Cloudlets policy version you want to activate
        """
        if associated_properties is not None:
            pulumi.set(__self__, "associated_properties", associated_properties)
        if is_shared is not None:
            pulumi.set(__self__, "is_shared", is_shared)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if policy_id is not None:
            pulumi.set(__self__, "policy_id", policy_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter(name="associatedProperties")
    def associated_properties(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Set of property IDs to link to this Cloudlets policy. It is required for non-shared policies
        """
        return pulumi.get(self, "associated_properties")

    @associated_properties.setter
    def associated_properties(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "associated_properties", value)

    @_builtins.property
    @pulumi.getter(name="isShared")
    def is_shared(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates if policy that is being activated is a shared policy
        """
        return pulumi.get(self, "is_shared")

    @is_shared.setter
    def is_shared(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_shared", value)

    @_builtins.property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The network you want to activate the policy version on (options are Staging and Production)
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network", value)

    @_builtins.property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        ID of the Cloudlets policy you want to activate
        """
        return pulumi.get(self, "policy_id")

    @policy_id.setter
    def policy_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "policy_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Activation status for this Cloudlets policy
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['CloudletsPolicyActivationTimeoutsArgs']]:
        """
        Enables to set timeout for processing
        """
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['CloudletsPolicyActivationTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Cloudlets policy version you want to activate
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "version", value)


@pulumi.type_token("akamai:index/cloudletsPolicyActivation:CloudletsPolicyActivation")
class CloudletsPolicyActivation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 associated_properties: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 network: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_id: Optional[pulumi.Input[_builtins.int]] = None,
                 timeouts: Optional[pulumi.Input[Union['CloudletsPolicyActivationTimeoutsArgs', 'CloudletsPolicyActivationTimeoutsArgsDict']]] = None,
                 version: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        Create a CloudletsPolicyActivation resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] associated_properties: Set of property IDs to link to this Cloudlets policy. It is required for non-shared policies
        :param pulumi.Input[_builtins.str] network: The network you want to activate the policy version on (options are Staging and Production)
        :param pulumi.Input[_builtins.int] policy_id: ID of the Cloudlets policy you want to activate
        :param pulumi.Input[Union['CloudletsPolicyActivationTimeoutsArgs', 'CloudletsPolicyActivationTimeoutsArgsDict']] timeouts: Enables to set timeout for processing
        :param pulumi.Input[_builtins.int] version: Cloudlets policy version you want to activate
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CloudletsPolicyActivationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a CloudletsPolicyActivation resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param CloudletsPolicyActivationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CloudletsPolicyActivationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 associated_properties: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 network: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_id: Optional[pulumi.Input[_builtins.int]] = None,
                 timeouts: Optional[pulumi.Input[Union['CloudletsPolicyActivationTimeoutsArgs', 'CloudletsPolicyActivationTimeoutsArgsDict']]] = None,
                 version: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CloudletsPolicyActivationArgs.__new__(CloudletsPolicyActivationArgs)

            __props__.__dict__["associated_properties"] = associated_properties
            if network is None and not opts.urn:
                raise TypeError("Missing required property 'network'")
            __props__.__dict__["network"] = network
            if policy_id is None and not opts.urn:
                raise TypeError("Missing required property 'policy_id'")
            __props__.__dict__["policy_id"] = policy_id
            __props__.__dict__["timeouts"] = timeouts
            if version is None and not opts.urn:
                raise TypeError("Missing required property 'version'")
            __props__.__dict__["version"] = version
            __props__.__dict__["is_shared"] = None
            __props__.__dict__["status"] = None
        super(CloudletsPolicyActivation, __self__).__init__(
            'akamai:index/cloudletsPolicyActivation:CloudletsPolicyActivation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            associated_properties: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            is_shared: Optional[pulumi.Input[_builtins.bool]] = None,
            network: Optional[pulumi.Input[_builtins.str]] = None,
            policy_id: Optional[pulumi.Input[_builtins.int]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            timeouts: Optional[pulumi.Input[Union['CloudletsPolicyActivationTimeoutsArgs', 'CloudletsPolicyActivationTimeoutsArgsDict']]] = None,
            version: Optional[pulumi.Input[_builtins.int]] = None) -> 'CloudletsPolicyActivation':
        """
        Get an existing CloudletsPolicyActivation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] associated_properties: Set of property IDs to link to this Cloudlets policy. It is required for non-shared policies
        :param pulumi.Input[_builtins.bool] is_shared: Indicates if policy that is being activated is a shared policy
        :param pulumi.Input[_builtins.str] network: The network you want to activate the policy version on (options are Staging and Production)
        :param pulumi.Input[_builtins.int] policy_id: ID of the Cloudlets policy you want to activate
        :param pulumi.Input[_builtins.str] status: Activation status for this Cloudlets policy
        :param pulumi.Input[Union['CloudletsPolicyActivationTimeoutsArgs', 'CloudletsPolicyActivationTimeoutsArgsDict']] timeouts: Enables to set timeout for processing
        :param pulumi.Input[_builtins.int] version: Cloudlets policy version you want to activate
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CloudletsPolicyActivationState.__new__(_CloudletsPolicyActivationState)

        __props__.__dict__["associated_properties"] = associated_properties
        __props__.__dict__["is_shared"] = is_shared
        __props__.__dict__["network"] = network
        __props__.__dict__["policy_id"] = policy_id
        __props__.__dict__["status"] = status
        __props__.__dict__["timeouts"] = timeouts
        __props__.__dict__["version"] = version
        return CloudletsPolicyActivation(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="associatedProperties")
    def associated_properties(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Set of property IDs to link to this Cloudlets policy. It is required for non-shared policies
        """
        return pulumi.get(self, "associated_properties")

    @_builtins.property
    @pulumi.getter(name="isShared")
    def is_shared(self) -> pulumi.Output[_builtins.bool]:
        """
        Indicates if policy that is being activated is a shared policy
        """
        return pulumi.get(self, "is_shared")

    @_builtins.property
    @pulumi.getter
    def network(self) -> pulumi.Output[_builtins.str]:
        """
        The network you want to activate the policy version on (options are Staging and Production)
        """
        return pulumi.get(self, "network")

    @_builtins.property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> pulumi.Output[_builtins.int]:
        """
        ID of the Cloudlets policy you want to activate
        """
        return pulumi.get(self, "policy_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Activation status for this Cloudlets policy
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> pulumi.Output[Optional['outputs.CloudletsPolicyActivationTimeouts']]:
        """
        Enables to set timeout for processing
        """
        return pulumi.get(self, "timeouts")

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Output[_builtins.int]:
        """
        Cloudlets policy version you want to activate
        """
        return pulumi.get(self, "version")

