# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CpsDvEnrollmentArgs', 'CpsDvEnrollment']

@pulumi.input_type
class CpsDvEnrollmentArgs:
    def __init__(__self__, *,
                 admin_contact: pulumi.Input['CpsDvEnrollmentAdminContactArgs'],
                 common_name: pulumi.Input[_builtins.str],
                 contract_id: pulumi.Input[_builtins.str],
                 csr: pulumi.Input['CpsDvEnrollmentCsrArgs'],
                 network_configuration: pulumi.Input['CpsDvEnrollmentNetworkConfigurationArgs'],
                 organization: pulumi.Input['CpsDvEnrollmentOrganizationArgs'],
                 secure_network: pulumi.Input[_builtins.str],
                 signature_algorithm: pulumi.Input[_builtins.str],
                 sni_only: pulumi.Input[_builtins.bool],
                 tech_contact: pulumi.Input['CpsDvEnrollmentTechContactArgs'],
                 acknowledge_pre_verification_warnings: Optional[pulumi.Input[_builtins.bool]] = None,
                 allow_duplicate_common_name: Optional[pulumi.Input[_builtins.bool]] = None,
                 certificate_chain_type: Optional[pulumi.Input[_builtins.str]] = None,
                 sans: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input['CpsDvEnrollmentTimeoutsArgs']] = None):
        """
        The set of arguments for constructing a CpsDvEnrollment resource.
        :param pulumi.Input['CpsDvEnrollmentAdminContactArgs'] admin_contact: Contact information for the certificate administrator to use at organization
        :param pulumi.Input[_builtins.str] common_name: Common name used for enrollment
        :param pulumi.Input[_builtins.str] contract_id: Contract ID for which enrollment is retrieved
        :param pulumi.Input['CpsDvEnrollmentCsrArgs'] csr: Certificate signing request generated during enrollment creation
        :param pulumi.Input['CpsDvEnrollmentNetworkConfigurationArgs'] network_configuration: Settings containing network information and TLS Metadata used by CPS
        :param pulumi.Input['CpsDvEnrollmentOrganizationArgs'] organization: Organization information
        :param pulumi.Input[_builtins.str] secure_network: Type of TLS deployment network
        :param pulumi.Input[_builtins.str] signature_algorithm: SHA algorithm type
        :param pulumi.Input[_builtins.bool] sni_only: Whether Server Name Indication is used for enrollment
        :param pulumi.Input['CpsDvEnrollmentTechContactArgs'] tech_contact: Contact information for an administrator at Akamai
        :param pulumi.Input[_builtins.bool] acknowledge_pre_verification_warnings: Whether acknowledge warnings before certificate verification. Default is false
        :param pulumi.Input[_builtins.bool] allow_duplicate_common_name: Allow to duplicate common name. Default is false
        :param pulumi.Input[_builtins.str] certificate_chain_type: Certificate trust chain type. Default is 'default'
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] sans: List of SANs
        :param pulumi.Input['CpsDvEnrollmentTimeoutsArgs'] timeouts: Enables to set timeout for processing
        """
        pulumi.set(__self__, "admin_contact", admin_contact)
        pulumi.set(__self__, "common_name", common_name)
        pulumi.set(__self__, "contract_id", contract_id)
        pulumi.set(__self__, "csr", csr)
        pulumi.set(__self__, "network_configuration", network_configuration)
        pulumi.set(__self__, "organization", organization)
        pulumi.set(__self__, "secure_network", secure_network)
        pulumi.set(__self__, "signature_algorithm", signature_algorithm)
        pulumi.set(__self__, "sni_only", sni_only)
        pulumi.set(__self__, "tech_contact", tech_contact)
        if acknowledge_pre_verification_warnings is not None:
            pulumi.set(__self__, "acknowledge_pre_verification_warnings", acknowledge_pre_verification_warnings)
        if allow_duplicate_common_name is not None:
            pulumi.set(__self__, "allow_duplicate_common_name", allow_duplicate_common_name)
        if certificate_chain_type is not None:
            pulumi.set(__self__, "certificate_chain_type", certificate_chain_type)
        if sans is not None:
            pulumi.set(__self__, "sans", sans)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @_builtins.property
    @pulumi.getter(name="adminContact")
    def admin_contact(self) -> pulumi.Input['CpsDvEnrollmentAdminContactArgs']:
        """
        Contact information for the certificate administrator to use at organization
        """
        return pulumi.get(self, "admin_contact")

    @admin_contact.setter
    def admin_contact(self, value: pulumi.Input['CpsDvEnrollmentAdminContactArgs']):
        pulumi.set(self, "admin_contact", value)

    @_builtins.property
    @pulumi.getter(name="commonName")
    def common_name(self) -> pulumi.Input[_builtins.str]:
        """
        Common name used for enrollment
        """
        return pulumi.get(self, "common_name")

    @common_name.setter
    def common_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "common_name", value)

    @_builtins.property
    @pulumi.getter(name="contractId")
    def contract_id(self) -> pulumi.Input[_builtins.str]:
        """
        Contract ID for which enrollment is retrieved
        """
        return pulumi.get(self, "contract_id")

    @contract_id.setter
    def contract_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "contract_id", value)

    @_builtins.property
    @pulumi.getter
    def csr(self) -> pulumi.Input['CpsDvEnrollmentCsrArgs']:
        """
        Certificate signing request generated during enrollment creation
        """
        return pulumi.get(self, "csr")

    @csr.setter
    def csr(self, value: pulumi.Input['CpsDvEnrollmentCsrArgs']):
        pulumi.set(self, "csr", value)

    @_builtins.property
    @pulumi.getter(name="networkConfiguration")
    def network_configuration(self) -> pulumi.Input['CpsDvEnrollmentNetworkConfigurationArgs']:
        """
        Settings containing network information and TLS Metadata used by CPS
        """
        return pulumi.get(self, "network_configuration")

    @network_configuration.setter
    def network_configuration(self, value: pulumi.Input['CpsDvEnrollmentNetworkConfigurationArgs']):
        pulumi.set(self, "network_configuration", value)

    @_builtins.property
    @pulumi.getter
    def organization(self) -> pulumi.Input['CpsDvEnrollmentOrganizationArgs']:
        """
        Organization information
        """
        return pulumi.get(self, "organization")

    @organization.setter
    def organization(self, value: pulumi.Input['CpsDvEnrollmentOrganizationArgs']):
        pulumi.set(self, "organization", value)

    @_builtins.property
    @pulumi.getter(name="secureNetwork")
    def secure_network(self) -> pulumi.Input[_builtins.str]:
        """
        Type of TLS deployment network
        """
        return pulumi.get(self, "secure_network")

    @secure_network.setter
    def secure_network(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "secure_network", value)

    @_builtins.property
    @pulumi.getter(name="signatureAlgorithm")
    def signature_algorithm(self) -> pulumi.Input[_builtins.str]:
        """
        SHA algorithm type
        """
        return pulumi.get(self, "signature_algorithm")

    @signature_algorithm.setter
    def signature_algorithm(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "signature_algorithm", value)

    @_builtins.property
    @pulumi.getter(name="sniOnly")
    def sni_only(self) -> pulumi.Input[_builtins.bool]:
        """
        Whether Server Name Indication is used for enrollment
        """
        return pulumi.get(self, "sni_only")

    @sni_only.setter
    def sni_only(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "sni_only", value)

    @_builtins.property
    @pulumi.getter(name="techContact")
    def tech_contact(self) -> pulumi.Input['CpsDvEnrollmentTechContactArgs']:
        """
        Contact information for an administrator at Akamai
        """
        return pulumi.get(self, "tech_contact")

    @tech_contact.setter
    def tech_contact(self, value: pulumi.Input['CpsDvEnrollmentTechContactArgs']):
        pulumi.set(self, "tech_contact", value)

    @_builtins.property
    @pulumi.getter(name="acknowledgePreVerificationWarnings")
    def acknowledge_pre_verification_warnings(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether acknowledge warnings before certificate verification. Default is false
        """
        return pulumi.get(self, "acknowledge_pre_verification_warnings")

    @acknowledge_pre_verification_warnings.setter
    def acknowledge_pre_verification_warnings(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "acknowledge_pre_verification_warnings", value)

    @_builtins.property
    @pulumi.getter(name="allowDuplicateCommonName")
    def allow_duplicate_common_name(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Allow to duplicate common name. Default is false
        """
        return pulumi.get(self, "allow_duplicate_common_name")

    @allow_duplicate_common_name.setter
    def allow_duplicate_common_name(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allow_duplicate_common_name", value)

    @_builtins.property
    @pulumi.getter(name="certificateChainType")
    def certificate_chain_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Certificate trust chain type. Default is 'default'
        """
        return pulumi.get(self, "certificate_chain_type")

    @certificate_chain_type.setter
    def certificate_chain_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "certificate_chain_type", value)

    @_builtins.property
    @pulumi.getter
    def sans(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of SANs
        """
        return pulumi.get(self, "sans")

    @sans.setter
    def sans(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "sans", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['CpsDvEnrollmentTimeoutsArgs']]:
        """
        Enables to set timeout for processing
        """
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['CpsDvEnrollmentTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.input_type
class _CpsDvEnrollmentState:
    def __init__(__self__, *,
                 acknowledge_pre_verification_warnings: Optional[pulumi.Input[_builtins.bool]] = None,
                 admin_contact: Optional[pulumi.Input['CpsDvEnrollmentAdminContactArgs']] = None,
                 allow_duplicate_common_name: Optional[pulumi.Input[_builtins.bool]] = None,
                 certificate_chain_type: Optional[pulumi.Input[_builtins.str]] = None,
                 certificate_type: Optional[pulumi.Input[_builtins.str]] = None,
                 common_name: Optional[pulumi.Input[_builtins.str]] = None,
                 contract_id: Optional[pulumi.Input[_builtins.str]] = None,
                 csr: Optional[pulumi.Input['CpsDvEnrollmentCsrArgs']] = None,
                 dns_challenges: Optional[pulumi.Input[Sequence[pulumi.Input['CpsDvEnrollmentDnsChallengeArgs']]]] = None,
                 http_challenges: Optional[pulumi.Input[Sequence[pulumi.Input['CpsDvEnrollmentHttpChallengeArgs']]]] = None,
                 network_configuration: Optional[pulumi.Input['CpsDvEnrollmentNetworkConfigurationArgs']] = None,
                 organization: Optional[pulumi.Input['CpsDvEnrollmentOrganizationArgs']] = None,
                 registration_authority: Optional[pulumi.Input[_builtins.str]] = None,
                 sans: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 secure_network: Optional[pulumi.Input[_builtins.str]] = None,
                 signature_algorithm: Optional[pulumi.Input[_builtins.str]] = None,
                 sni_only: Optional[pulumi.Input[_builtins.bool]] = None,
                 tech_contact: Optional[pulumi.Input['CpsDvEnrollmentTechContactArgs']] = None,
                 timeouts: Optional[pulumi.Input['CpsDvEnrollmentTimeoutsArgs']] = None,
                 validation_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering CpsDvEnrollment resources.
        :param pulumi.Input[_builtins.bool] acknowledge_pre_verification_warnings: Whether acknowledge warnings before certificate verification. Default is false
        :param pulumi.Input['CpsDvEnrollmentAdminContactArgs'] admin_contact: Contact information for the certificate administrator to use at organization
        :param pulumi.Input[_builtins.bool] allow_duplicate_common_name: Allow to duplicate common name. Default is false
        :param pulumi.Input[_builtins.str] certificate_chain_type: Certificate trust chain type. Default is 'default'
        :param pulumi.Input[_builtins.str] certificate_type: Certificate type of enrollment
        :param pulumi.Input[_builtins.str] common_name: Common name used for enrollment
        :param pulumi.Input[_builtins.str] contract_id: Contract ID for which enrollment is retrieved
        :param pulumi.Input['CpsDvEnrollmentCsrArgs'] csr: Certificate signing request generated during enrollment creation
        :param pulumi.Input[Sequence[pulumi.Input['CpsDvEnrollmentDnsChallengeArgs']]] dns_challenges: DNS challenge information
        :param pulumi.Input[Sequence[pulumi.Input['CpsDvEnrollmentHttpChallengeArgs']]] http_challenges: HTTP challenge information
        :param pulumi.Input['CpsDvEnrollmentNetworkConfigurationArgs'] network_configuration: Settings containing network information and TLS Metadata used by CPS
        :param pulumi.Input['CpsDvEnrollmentOrganizationArgs'] organization: Organization information
        :param pulumi.Input[_builtins.str] registration_authority: The registration authority or certificate authority (CA) used to obtain a certificate
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] sans: List of SANs
        :param pulumi.Input[_builtins.str] secure_network: Type of TLS deployment network
        :param pulumi.Input[_builtins.str] signature_algorithm: SHA algorithm type
        :param pulumi.Input[_builtins.bool] sni_only: Whether Server Name Indication is used for enrollment
        :param pulumi.Input['CpsDvEnrollmentTechContactArgs'] tech_contact: Contact information for an administrator at Akamai
        :param pulumi.Input['CpsDvEnrollmentTimeoutsArgs'] timeouts: Enables to set timeout for processing
        :param pulumi.Input[_builtins.str] validation_type: Enrolment validation type
        """
        if acknowledge_pre_verification_warnings is not None:
            pulumi.set(__self__, "acknowledge_pre_verification_warnings", acknowledge_pre_verification_warnings)
        if admin_contact is not None:
            pulumi.set(__self__, "admin_contact", admin_contact)
        if allow_duplicate_common_name is not None:
            pulumi.set(__self__, "allow_duplicate_common_name", allow_duplicate_common_name)
        if certificate_chain_type is not None:
            pulumi.set(__self__, "certificate_chain_type", certificate_chain_type)
        if certificate_type is not None:
            pulumi.set(__self__, "certificate_type", certificate_type)
        if common_name is not None:
            pulumi.set(__self__, "common_name", common_name)
        if contract_id is not None:
            pulumi.set(__self__, "contract_id", contract_id)
        if csr is not None:
            pulumi.set(__self__, "csr", csr)
        if dns_challenges is not None:
            pulumi.set(__self__, "dns_challenges", dns_challenges)
        if http_challenges is not None:
            pulumi.set(__self__, "http_challenges", http_challenges)
        if network_configuration is not None:
            pulumi.set(__self__, "network_configuration", network_configuration)
        if organization is not None:
            pulumi.set(__self__, "organization", organization)
        if registration_authority is not None:
            pulumi.set(__self__, "registration_authority", registration_authority)
        if sans is not None:
            pulumi.set(__self__, "sans", sans)
        if secure_network is not None:
            pulumi.set(__self__, "secure_network", secure_network)
        if signature_algorithm is not None:
            pulumi.set(__self__, "signature_algorithm", signature_algorithm)
        if sni_only is not None:
            pulumi.set(__self__, "sni_only", sni_only)
        if tech_contact is not None:
            pulumi.set(__self__, "tech_contact", tech_contact)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)
        if validation_type is not None:
            pulumi.set(__self__, "validation_type", validation_type)

    @_builtins.property
    @pulumi.getter(name="acknowledgePreVerificationWarnings")
    def acknowledge_pre_verification_warnings(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether acknowledge warnings before certificate verification. Default is false
        """
        return pulumi.get(self, "acknowledge_pre_verification_warnings")

    @acknowledge_pre_verification_warnings.setter
    def acknowledge_pre_verification_warnings(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "acknowledge_pre_verification_warnings", value)

    @_builtins.property
    @pulumi.getter(name="adminContact")
    def admin_contact(self) -> Optional[pulumi.Input['CpsDvEnrollmentAdminContactArgs']]:
        """
        Contact information for the certificate administrator to use at organization
        """
        return pulumi.get(self, "admin_contact")

    @admin_contact.setter
    def admin_contact(self, value: Optional[pulumi.Input['CpsDvEnrollmentAdminContactArgs']]):
        pulumi.set(self, "admin_contact", value)

    @_builtins.property
    @pulumi.getter(name="allowDuplicateCommonName")
    def allow_duplicate_common_name(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Allow to duplicate common name. Default is false
        """
        return pulumi.get(self, "allow_duplicate_common_name")

    @allow_duplicate_common_name.setter
    def allow_duplicate_common_name(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allow_duplicate_common_name", value)

    @_builtins.property
    @pulumi.getter(name="certificateChainType")
    def certificate_chain_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Certificate trust chain type. Default is 'default'
        """
        return pulumi.get(self, "certificate_chain_type")

    @certificate_chain_type.setter
    def certificate_chain_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "certificate_chain_type", value)

    @_builtins.property
    @pulumi.getter(name="certificateType")
    def certificate_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Certificate type of enrollment
        """
        return pulumi.get(self, "certificate_type")

    @certificate_type.setter
    def certificate_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "certificate_type", value)

    @_builtins.property
    @pulumi.getter(name="commonName")
    def common_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Common name used for enrollment
        """
        return pulumi.get(self, "common_name")

    @common_name.setter
    def common_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "common_name", value)

    @_builtins.property
    @pulumi.getter(name="contractId")
    def contract_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Contract ID for which enrollment is retrieved
        """
        return pulumi.get(self, "contract_id")

    @contract_id.setter
    def contract_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "contract_id", value)

    @_builtins.property
    @pulumi.getter
    def csr(self) -> Optional[pulumi.Input['CpsDvEnrollmentCsrArgs']]:
        """
        Certificate signing request generated during enrollment creation
        """
        return pulumi.get(self, "csr")

    @csr.setter
    def csr(self, value: Optional[pulumi.Input['CpsDvEnrollmentCsrArgs']]):
        pulumi.set(self, "csr", value)

    @_builtins.property
    @pulumi.getter(name="dnsChallenges")
    def dns_challenges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CpsDvEnrollmentDnsChallengeArgs']]]]:
        """
        DNS challenge information
        """
        return pulumi.get(self, "dns_challenges")

    @dns_challenges.setter
    def dns_challenges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CpsDvEnrollmentDnsChallengeArgs']]]]):
        pulumi.set(self, "dns_challenges", value)

    @_builtins.property
    @pulumi.getter(name="httpChallenges")
    def http_challenges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CpsDvEnrollmentHttpChallengeArgs']]]]:
        """
        HTTP challenge information
        """
        return pulumi.get(self, "http_challenges")

    @http_challenges.setter
    def http_challenges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CpsDvEnrollmentHttpChallengeArgs']]]]):
        pulumi.set(self, "http_challenges", value)

    @_builtins.property
    @pulumi.getter(name="networkConfiguration")
    def network_configuration(self) -> Optional[pulumi.Input['CpsDvEnrollmentNetworkConfigurationArgs']]:
        """
        Settings containing network information and TLS Metadata used by CPS
        """
        return pulumi.get(self, "network_configuration")

    @network_configuration.setter
    def network_configuration(self, value: Optional[pulumi.Input['CpsDvEnrollmentNetworkConfigurationArgs']]):
        pulumi.set(self, "network_configuration", value)

    @_builtins.property
    @pulumi.getter
    def organization(self) -> Optional[pulumi.Input['CpsDvEnrollmentOrganizationArgs']]:
        """
        Organization information
        """
        return pulumi.get(self, "organization")

    @organization.setter
    def organization(self, value: Optional[pulumi.Input['CpsDvEnrollmentOrganizationArgs']]):
        pulumi.set(self, "organization", value)

    @_builtins.property
    @pulumi.getter(name="registrationAuthority")
    def registration_authority(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The registration authority or certificate authority (CA) used to obtain a certificate
        """
        return pulumi.get(self, "registration_authority")

    @registration_authority.setter
    def registration_authority(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "registration_authority", value)

    @_builtins.property
    @pulumi.getter
    def sans(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of SANs
        """
        return pulumi.get(self, "sans")

    @sans.setter
    def sans(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "sans", value)

    @_builtins.property
    @pulumi.getter(name="secureNetwork")
    def secure_network(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of TLS deployment network
        """
        return pulumi.get(self, "secure_network")

    @secure_network.setter
    def secure_network(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secure_network", value)

    @_builtins.property
    @pulumi.getter(name="signatureAlgorithm")
    def signature_algorithm(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        SHA algorithm type
        """
        return pulumi.get(self, "signature_algorithm")

    @signature_algorithm.setter
    def signature_algorithm(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "signature_algorithm", value)

    @_builtins.property
    @pulumi.getter(name="sniOnly")
    def sni_only(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether Server Name Indication is used for enrollment
        """
        return pulumi.get(self, "sni_only")

    @sni_only.setter
    def sni_only(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "sni_only", value)

    @_builtins.property
    @pulumi.getter(name="techContact")
    def tech_contact(self) -> Optional[pulumi.Input['CpsDvEnrollmentTechContactArgs']]:
        """
        Contact information for an administrator at Akamai
        """
        return pulumi.get(self, "tech_contact")

    @tech_contact.setter
    def tech_contact(self, value: Optional[pulumi.Input['CpsDvEnrollmentTechContactArgs']]):
        pulumi.set(self, "tech_contact", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['CpsDvEnrollmentTimeoutsArgs']]:
        """
        Enables to set timeout for processing
        """
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['CpsDvEnrollmentTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)

    @_builtins.property
    @pulumi.getter(name="validationType")
    def validation_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Enrolment validation type
        """
        return pulumi.get(self, "validation_type")

    @validation_type.setter
    def validation_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "validation_type", value)


@pulumi.type_token("akamai:index/cpsDvEnrollment:CpsDvEnrollment")
class CpsDvEnrollment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acknowledge_pre_verification_warnings: Optional[pulumi.Input[_builtins.bool]] = None,
                 admin_contact: Optional[pulumi.Input[Union['CpsDvEnrollmentAdminContactArgs', 'CpsDvEnrollmentAdminContactArgsDict']]] = None,
                 allow_duplicate_common_name: Optional[pulumi.Input[_builtins.bool]] = None,
                 certificate_chain_type: Optional[pulumi.Input[_builtins.str]] = None,
                 common_name: Optional[pulumi.Input[_builtins.str]] = None,
                 contract_id: Optional[pulumi.Input[_builtins.str]] = None,
                 csr: Optional[pulumi.Input[Union['CpsDvEnrollmentCsrArgs', 'CpsDvEnrollmentCsrArgsDict']]] = None,
                 network_configuration: Optional[pulumi.Input[Union['CpsDvEnrollmentNetworkConfigurationArgs', 'CpsDvEnrollmentNetworkConfigurationArgsDict']]] = None,
                 organization: Optional[pulumi.Input[Union['CpsDvEnrollmentOrganizationArgs', 'CpsDvEnrollmentOrganizationArgsDict']]] = None,
                 sans: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 secure_network: Optional[pulumi.Input[_builtins.str]] = None,
                 signature_algorithm: Optional[pulumi.Input[_builtins.str]] = None,
                 sni_only: Optional[pulumi.Input[_builtins.bool]] = None,
                 tech_contact: Optional[pulumi.Input[Union['CpsDvEnrollmentTechContactArgs', 'CpsDvEnrollmentTechContactArgsDict']]] = None,
                 timeouts: Optional[pulumi.Input[Union['CpsDvEnrollmentTimeoutsArgs', 'CpsDvEnrollmentTimeoutsArgsDict']]] = None,
                 __props__=None):
        """
        Create a CpsDvEnrollment resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] acknowledge_pre_verification_warnings: Whether acknowledge warnings before certificate verification. Default is false
        :param pulumi.Input[Union['CpsDvEnrollmentAdminContactArgs', 'CpsDvEnrollmentAdminContactArgsDict']] admin_contact: Contact information for the certificate administrator to use at organization
        :param pulumi.Input[_builtins.bool] allow_duplicate_common_name: Allow to duplicate common name. Default is false
        :param pulumi.Input[_builtins.str] certificate_chain_type: Certificate trust chain type. Default is 'default'
        :param pulumi.Input[_builtins.str] common_name: Common name used for enrollment
        :param pulumi.Input[_builtins.str] contract_id: Contract ID for which enrollment is retrieved
        :param pulumi.Input[Union['CpsDvEnrollmentCsrArgs', 'CpsDvEnrollmentCsrArgsDict']] csr: Certificate signing request generated during enrollment creation
        :param pulumi.Input[Union['CpsDvEnrollmentNetworkConfigurationArgs', 'CpsDvEnrollmentNetworkConfigurationArgsDict']] network_configuration: Settings containing network information and TLS Metadata used by CPS
        :param pulumi.Input[Union['CpsDvEnrollmentOrganizationArgs', 'CpsDvEnrollmentOrganizationArgsDict']] organization: Organization information
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] sans: List of SANs
        :param pulumi.Input[_builtins.str] secure_network: Type of TLS deployment network
        :param pulumi.Input[_builtins.str] signature_algorithm: SHA algorithm type
        :param pulumi.Input[_builtins.bool] sni_only: Whether Server Name Indication is used for enrollment
        :param pulumi.Input[Union['CpsDvEnrollmentTechContactArgs', 'CpsDvEnrollmentTechContactArgsDict']] tech_contact: Contact information for an administrator at Akamai
        :param pulumi.Input[Union['CpsDvEnrollmentTimeoutsArgs', 'CpsDvEnrollmentTimeoutsArgsDict']] timeouts: Enables to set timeout for processing
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CpsDvEnrollmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a CpsDvEnrollment resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param CpsDvEnrollmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CpsDvEnrollmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acknowledge_pre_verification_warnings: Optional[pulumi.Input[_builtins.bool]] = None,
                 admin_contact: Optional[pulumi.Input[Union['CpsDvEnrollmentAdminContactArgs', 'CpsDvEnrollmentAdminContactArgsDict']]] = None,
                 allow_duplicate_common_name: Optional[pulumi.Input[_builtins.bool]] = None,
                 certificate_chain_type: Optional[pulumi.Input[_builtins.str]] = None,
                 common_name: Optional[pulumi.Input[_builtins.str]] = None,
                 contract_id: Optional[pulumi.Input[_builtins.str]] = None,
                 csr: Optional[pulumi.Input[Union['CpsDvEnrollmentCsrArgs', 'CpsDvEnrollmentCsrArgsDict']]] = None,
                 network_configuration: Optional[pulumi.Input[Union['CpsDvEnrollmentNetworkConfigurationArgs', 'CpsDvEnrollmentNetworkConfigurationArgsDict']]] = None,
                 organization: Optional[pulumi.Input[Union['CpsDvEnrollmentOrganizationArgs', 'CpsDvEnrollmentOrganizationArgsDict']]] = None,
                 sans: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 secure_network: Optional[pulumi.Input[_builtins.str]] = None,
                 signature_algorithm: Optional[pulumi.Input[_builtins.str]] = None,
                 sni_only: Optional[pulumi.Input[_builtins.bool]] = None,
                 tech_contact: Optional[pulumi.Input[Union['CpsDvEnrollmentTechContactArgs', 'CpsDvEnrollmentTechContactArgsDict']]] = None,
                 timeouts: Optional[pulumi.Input[Union['CpsDvEnrollmentTimeoutsArgs', 'CpsDvEnrollmentTimeoutsArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CpsDvEnrollmentArgs.__new__(CpsDvEnrollmentArgs)

            __props__.__dict__["acknowledge_pre_verification_warnings"] = acknowledge_pre_verification_warnings
            if admin_contact is None and not opts.urn:
                raise TypeError("Missing required property 'admin_contact'")
            __props__.__dict__["admin_contact"] = admin_contact
            __props__.__dict__["allow_duplicate_common_name"] = allow_duplicate_common_name
            __props__.__dict__["certificate_chain_type"] = certificate_chain_type
            if common_name is None and not opts.urn:
                raise TypeError("Missing required property 'common_name'")
            __props__.__dict__["common_name"] = common_name
            if contract_id is None and not opts.urn:
                raise TypeError("Missing required property 'contract_id'")
            __props__.__dict__["contract_id"] = contract_id
            if csr is None and not opts.urn:
                raise TypeError("Missing required property 'csr'")
            __props__.__dict__["csr"] = csr
            if network_configuration is None and not opts.urn:
                raise TypeError("Missing required property 'network_configuration'")
            __props__.__dict__["network_configuration"] = network_configuration
            if organization is None and not opts.urn:
                raise TypeError("Missing required property 'organization'")
            __props__.__dict__["organization"] = organization
            __props__.__dict__["sans"] = sans
            if secure_network is None and not opts.urn:
                raise TypeError("Missing required property 'secure_network'")
            __props__.__dict__["secure_network"] = secure_network
            if signature_algorithm is None and not opts.urn:
                raise TypeError("Missing required property 'signature_algorithm'")
            __props__.__dict__["signature_algorithm"] = signature_algorithm
            if sni_only is None and not opts.urn:
                raise TypeError("Missing required property 'sni_only'")
            __props__.__dict__["sni_only"] = sni_only
            if tech_contact is None and not opts.urn:
                raise TypeError("Missing required property 'tech_contact'")
            __props__.__dict__["tech_contact"] = tech_contact
            __props__.__dict__["timeouts"] = timeouts
            __props__.__dict__["certificate_type"] = None
            __props__.__dict__["dns_challenges"] = None
            __props__.__dict__["http_challenges"] = None
            __props__.__dict__["registration_authority"] = None
            __props__.__dict__["validation_type"] = None
        super(CpsDvEnrollment, __self__).__init__(
            'akamai:index/cpsDvEnrollment:CpsDvEnrollment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            acknowledge_pre_verification_warnings: Optional[pulumi.Input[_builtins.bool]] = None,
            admin_contact: Optional[pulumi.Input[Union['CpsDvEnrollmentAdminContactArgs', 'CpsDvEnrollmentAdminContactArgsDict']]] = None,
            allow_duplicate_common_name: Optional[pulumi.Input[_builtins.bool]] = None,
            certificate_chain_type: Optional[pulumi.Input[_builtins.str]] = None,
            certificate_type: Optional[pulumi.Input[_builtins.str]] = None,
            common_name: Optional[pulumi.Input[_builtins.str]] = None,
            contract_id: Optional[pulumi.Input[_builtins.str]] = None,
            csr: Optional[pulumi.Input[Union['CpsDvEnrollmentCsrArgs', 'CpsDvEnrollmentCsrArgsDict']]] = None,
            dns_challenges: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CpsDvEnrollmentDnsChallengeArgs', 'CpsDvEnrollmentDnsChallengeArgsDict']]]]] = None,
            http_challenges: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CpsDvEnrollmentHttpChallengeArgs', 'CpsDvEnrollmentHttpChallengeArgsDict']]]]] = None,
            network_configuration: Optional[pulumi.Input[Union['CpsDvEnrollmentNetworkConfigurationArgs', 'CpsDvEnrollmentNetworkConfigurationArgsDict']]] = None,
            organization: Optional[pulumi.Input[Union['CpsDvEnrollmentOrganizationArgs', 'CpsDvEnrollmentOrganizationArgsDict']]] = None,
            registration_authority: Optional[pulumi.Input[_builtins.str]] = None,
            sans: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            secure_network: Optional[pulumi.Input[_builtins.str]] = None,
            signature_algorithm: Optional[pulumi.Input[_builtins.str]] = None,
            sni_only: Optional[pulumi.Input[_builtins.bool]] = None,
            tech_contact: Optional[pulumi.Input[Union['CpsDvEnrollmentTechContactArgs', 'CpsDvEnrollmentTechContactArgsDict']]] = None,
            timeouts: Optional[pulumi.Input[Union['CpsDvEnrollmentTimeoutsArgs', 'CpsDvEnrollmentTimeoutsArgsDict']]] = None,
            validation_type: Optional[pulumi.Input[_builtins.str]] = None) -> 'CpsDvEnrollment':
        """
        Get an existing CpsDvEnrollment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] acknowledge_pre_verification_warnings: Whether acknowledge warnings before certificate verification. Default is false
        :param pulumi.Input[Union['CpsDvEnrollmentAdminContactArgs', 'CpsDvEnrollmentAdminContactArgsDict']] admin_contact: Contact information for the certificate administrator to use at organization
        :param pulumi.Input[_builtins.bool] allow_duplicate_common_name: Allow to duplicate common name. Default is false
        :param pulumi.Input[_builtins.str] certificate_chain_type: Certificate trust chain type. Default is 'default'
        :param pulumi.Input[_builtins.str] certificate_type: Certificate type of enrollment
        :param pulumi.Input[_builtins.str] common_name: Common name used for enrollment
        :param pulumi.Input[_builtins.str] contract_id: Contract ID for which enrollment is retrieved
        :param pulumi.Input[Union['CpsDvEnrollmentCsrArgs', 'CpsDvEnrollmentCsrArgsDict']] csr: Certificate signing request generated during enrollment creation
        :param pulumi.Input[Sequence[pulumi.Input[Union['CpsDvEnrollmentDnsChallengeArgs', 'CpsDvEnrollmentDnsChallengeArgsDict']]]] dns_challenges: DNS challenge information
        :param pulumi.Input[Sequence[pulumi.Input[Union['CpsDvEnrollmentHttpChallengeArgs', 'CpsDvEnrollmentHttpChallengeArgsDict']]]] http_challenges: HTTP challenge information
        :param pulumi.Input[Union['CpsDvEnrollmentNetworkConfigurationArgs', 'CpsDvEnrollmentNetworkConfigurationArgsDict']] network_configuration: Settings containing network information and TLS Metadata used by CPS
        :param pulumi.Input[Union['CpsDvEnrollmentOrganizationArgs', 'CpsDvEnrollmentOrganizationArgsDict']] organization: Organization information
        :param pulumi.Input[_builtins.str] registration_authority: The registration authority or certificate authority (CA) used to obtain a certificate
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] sans: List of SANs
        :param pulumi.Input[_builtins.str] secure_network: Type of TLS deployment network
        :param pulumi.Input[_builtins.str] signature_algorithm: SHA algorithm type
        :param pulumi.Input[_builtins.bool] sni_only: Whether Server Name Indication is used for enrollment
        :param pulumi.Input[Union['CpsDvEnrollmentTechContactArgs', 'CpsDvEnrollmentTechContactArgsDict']] tech_contact: Contact information for an administrator at Akamai
        :param pulumi.Input[Union['CpsDvEnrollmentTimeoutsArgs', 'CpsDvEnrollmentTimeoutsArgsDict']] timeouts: Enables to set timeout for processing
        :param pulumi.Input[_builtins.str] validation_type: Enrolment validation type
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CpsDvEnrollmentState.__new__(_CpsDvEnrollmentState)

        __props__.__dict__["acknowledge_pre_verification_warnings"] = acknowledge_pre_verification_warnings
        __props__.__dict__["admin_contact"] = admin_contact
        __props__.__dict__["allow_duplicate_common_name"] = allow_duplicate_common_name
        __props__.__dict__["certificate_chain_type"] = certificate_chain_type
        __props__.__dict__["certificate_type"] = certificate_type
        __props__.__dict__["common_name"] = common_name
        __props__.__dict__["contract_id"] = contract_id
        __props__.__dict__["csr"] = csr
        __props__.__dict__["dns_challenges"] = dns_challenges
        __props__.__dict__["http_challenges"] = http_challenges
        __props__.__dict__["network_configuration"] = network_configuration
        __props__.__dict__["organization"] = organization
        __props__.__dict__["registration_authority"] = registration_authority
        __props__.__dict__["sans"] = sans
        __props__.__dict__["secure_network"] = secure_network
        __props__.__dict__["signature_algorithm"] = signature_algorithm
        __props__.__dict__["sni_only"] = sni_only
        __props__.__dict__["tech_contact"] = tech_contact
        __props__.__dict__["timeouts"] = timeouts
        __props__.__dict__["validation_type"] = validation_type
        return CpsDvEnrollment(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="acknowledgePreVerificationWarnings")
    def acknowledge_pre_verification_warnings(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether acknowledge warnings before certificate verification. Default is false
        """
        return pulumi.get(self, "acknowledge_pre_verification_warnings")

    @_builtins.property
    @pulumi.getter(name="adminContact")
    def admin_contact(self) -> pulumi.Output['outputs.CpsDvEnrollmentAdminContact']:
        """
        Contact information for the certificate administrator to use at organization
        """
        return pulumi.get(self, "admin_contact")

    @_builtins.property
    @pulumi.getter(name="allowDuplicateCommonName")
    def allow_duplicate_common_name(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Allow to duplicate common name. Default is false
        """
        return pulumi.get(self, "allow_duplicate_common_name")

    @_builtins.property
    @pulumi.getter(name="certificateChainType")
    def certificate_chain_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Certificate trust chain type. Default is 'default'
        """
        return pulumi.get(self, "certificate_chain_type")

    @_builtins.property
    @pulumi.getter(name="certificateType")
    def certificate_type(self) -> pulumi.Output[_builtins.str]:
        """
        Certificate type of enrollment
        """
        return pulumi.get(self, "certificate_type")

    @_builtins.property
    @pulumi.getter(name="commonName")
    def common_name(self) -> pulumi.Output[_builtins.str]:
        """
        Common name used for enrollment
        """
        return pulumi.get(self, "common_name")

    @_builtins.property
    @pulumi.getter(name="contractId")
    def contract_id(self) -> pulumi.Output[_builtins.str]:
        """
        Contract ID for which enrollment is retrieved
        """
        return pulumi.get(self, "contract_id")

    @_builtins.property
    @pulumi.getter
    def csr(self) -> pulumi.Output['outputs.CpsDvEnrollmentCsr']:
        """
        Certificate signing request generated during enrollment creation
        """
        return pulumi.get(self, "csr")

    @_builtins.property
    @pulumi.getter(name="dnsChallenges")
    def dns_challenges(self) -> pulumi.Output[Sequence['outputs.CpsDvEnrollmentDnsChallenge']]:
        """
        DNS challenge information
        """
        return pulumi.get(self, "dns_challenges")

    @_builtins.property
    @pulumi.getter(name="httpChallenges")
    def http_challenges(self) -> pulumi.Output[Sequence['outputs.CpsDvEnrollmentHttpChallenge']]:
        """
        HTTP challenge information
        """
        return pulumi.get(self, "http_challenges")

    @_builtins.property
    @pulumi.getter(name="networkConfiguration")
    def network_configuration(self) -> pulumi.Output['outputs.CpsDvEnrollmentNetworkConfiguration']:
        """
        Settings containing network information and TLS Metadata used by CPS
        """
        return pulumi.get(self, "network_configuration")

    @_builtins.property
    @pulumi.getter
    def organization(self) -> pulumi.Output['outputs.CpsDvEnrollmentOrganization']:
        """
        Organization information
        """
        return pulumi.get(self, "organization")

    @_builtins.property
    @pulumi.getter(name="registrationAuthority")
    def registration_authority(self) -> pulumi.Output[_builtins.str]:
        """
        The registration authority or certificate authority (CA) used to obtain a certificate
        """
        return pulumi.get(self, "registration_authority")

    @_builtins.property
    @pulumi.getter
    def sans(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of SANs
        """
        return pulumi.get(self, "sans")

    @_builtins.property
    @pulumi.getter(name="secureNetwork")
    def secure_network(self) -> pulumi.Output[_builtins.str]:
        """
        Type of TLS deployment network
        """
        return pulumi.get(self, "secure_network")

    @_builtins.property
    @pulumi.getter(name="signatureAlgorithm")
    def signature_algorithm(self) -> pulumi.Output[_builtins.str]:
        """
        SHA algorithm type
        """
        return pulumi.get(self, "signature_algorithm")

    @_builtins.property
    @pulumi.getter(name="sniOnly")
    def sni_only(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether Server Name Indication is used for enrollment
        """
        return pulumi.get(self, "sni_only")

    @_builtins.property
    @pulumi.getter(name="techContact")
    def tech_contact(self) -> pulumi.Output['outputs.CpsDvEnrollmentTechContact']:
        """
        Contact information for an administrator at Akamai
        """
        return pulumi.get(self, "tech_contact")

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> pulumi.Output[Optional['outputs.CpsDvEnrollmentTimeouts']]:
        """
        Enables to set timeout for processing
        """
        return pulumi.get(self, "timeouts")

    @_builtins.property
    @pulumi.getter(name="validationType")
    def validation_type(self) -> pulumi.Output[_builtins.str]:
        """
        Enrolment validation type
        """
        return pulumi.get(self, "validation_type")

