# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CpsUploadCertificateArgs', 'CpsUploadCertificate']

@pulumi.input_type
class CpsUploadCertificateArgs:
    def __init__(__self__, *,
                 enrollment_id: pulumi.Input[_builtins.int],
                 acknowledge_change_management: Optional[pulumi.Input[_builtins.bool]] = None,
                 acknowledge_post_verification_warnings: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_approve_warnings: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 certificate_ecdsa_pem: Optional[pulumi.Input[_builtins.str]] = None,
                 certificate_rsa_pem: Optional[pulumi.Input[_builtins.str]] = None,
                 timeouts: Optional[pulumi.Input['CpsUploadCertificateTimeoutsArgs']] = None,
                 trust_chain_ecdsa_pem: Optional[pulumi.Input[_builtins.str]] = None,
                 trust_chain_rsa_pem: Optional[pulumi.Input[_builtins.str]] = None,
                 wait_for_deployment: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a CpsUploadCertificate resource.
        :param pulumi.Input[_builtins.int] enrollment_id: The unique identifier of the enrollment
        :param pulumi.Input[_builtins.bool] acknowledge_change_management: Whether to acknowledge change management
        :param pulumi.Input[_builtins.bool] acknowledge_post_verification_warnings: Whether to acknowledge post-verification warnings
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] auto_approve_warnings: List of post-verification warnings to be automatically acknowledged
        :param pulumi.Input[_builtins.str] certificate_ecdsa_pem: ECDSA certificate in pem format to be uploaded
        :param pulumi.Input[_builtins.str] certificate_rsa_pem: RSA certificate in pem format to be uploaded
        :param pulumi.Input['CpsUploadCertificateTimeoutsArgs'] timeouts: Enables to set timeout for processing
        :param pulumi.Input[_builtins.str] trust_chain_ecdsa_pem: Trust chain in pem format for provided ECDSA certificate
        :param pulumi.Input[_builtins.str] trust_chain_rsa_pem: Trust chain in pem format for provided RSA certificate
        :param pulumi.Input[_builtins.bool] wait_for_deployment: Whether to wait for certificate to be deployed
        """
        pulumi.set(__self__, "enrollment_id", enrollment_id)
        if acknowledge_change_management is not None:
            pulumi.set(__self__, "acknowledge_change_management", acknowledge_change_management)
        if acknowledge_post_verification_warnings is not None:
            pulumi.set(__self__, "acknowledge_post_verification_warnings", acknowledge_post_verification_warnings)
        if auto_approve_warnings is not None:
            pulumi.set(__self__, "auto_approve_warnings", auto_approve_warnings)
        if certificate_ecdsa_pem is not None:
            pulumi.set(__self__, "certificate_ecdsa_pem", certificate_ecdsa_pem)
        if certificate_rsa_pem is not None:
            pulumi.set(__self__, "certificate_rsa_pem", certificate_rsa_pem)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)
        if trust_chain_ecdsa_pem is not None:
            pulumi.set(__self__, "trust_chain_ecdsa_pem", trust_chain_ecdsa_pem)
        if trust_chain_rsa_pem is not None:
            pulumi.set(__self__, "trust_chain_rsa_pem", trust_chain_rsa_pem)
        if wait_for_deployment is not None:
            pulumi.set(__self__, "wait_for_deployment", wait_for_deployment)

    @_builtins.property
    @pulumi.getter(name="enrollmentId")
    def enrollment_id(self) -> pulumi.Input[_builtins.int]:
        """
        The unique identifier of the enrollment
        """
        return pulumi.get(self, "enrollment_id")

    @enrollment_id.setter
    def enrollment_id(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "enrollment_id", value)

    @_builtins.property
    @pulumi.getter(name="acknowledgeChangeManagement")
    def acknowledge_change_management(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to acknowledge change management
        """
        return pulumi.get(self, "acknowledge_change_management")

    @acknowledge_change_management.setter
    def acknowledge_change_management(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "acknowledge_change_management", value)

    @_builtins.property
    @pulumi.getter(name="acknowledgePostVerificationWarnings")
    def acknowledge_post_verification_warnings(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to acknowledge post-verification warnings
        """
        return pulumi.get(self, "acknowledge_post_verification_warnings")

    @acknowledge_post_verification_warnings.setter
    def acknowledge_post_verification_warnings(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "acknowledge_post_verification_warnings", value)

    @_builtins.property
    @pulumi.getter(name="autoApproveWarnings")
    def auto_approve_warnings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of post-verification warnings to be automatically acknowledged
        """
        return pulumi.get(self, "auto_approve_warnings")

    @auto_approve_warnings.setter
    def auto_approve_warnings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "auto_approve_warnings", value)

    @_builtins.property
    @pulumi.getter(name="certificateEcdsaPem")
    def certificate_ecdsa_pem(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ECDSA certificate in pem format to be uploaded
        """
        return pulumi.get(self, "certificate_ecdsa_pem")

    @certificate_ecdsa_pem.setter
    def certificate_ecdsa_pem(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "certificate_ecdsa_pem", value)

    @_builtins.property
    @pulumi.getter(name="certificateRsaPem")
    def certificate_rsa_pem(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        RSA certificate in pem format to be uploaded
        """
        return pulumi.get(self, "certificate_rsa_pem")

    @certificate_rsa_pem.setter
    def certificate_rsa_pem(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "certificate_rsa_pem", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['CpsUploadCertificateTimeoutsArgs']]:
        """
        Enables to set timeout for processing
        """
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['CpsUploadCertificateTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)

    @_builtins.property
    @pulumi.getter(name="trustChainEcdsaPem")
    def trust_chain_ecdsa_pem(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Trust chain in pem format for provided ECDSA certificate
        """
        return pulumi.get(self, "trust_chain_ecdsa_pem")

    @trust_chain_ecdsa_pem.setter
    def trust_chain_ecdsa_pem(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "trust_chain_ecdsa_pem", value)

    @_builtins.property
    @pulumi.getter(name="trustChainRsaPem")
    def trust_chain_rsa_pem(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Trust chain in pem format for provided RSA certificate
        """
        return pulumi.get(self, "trust_chain_rsa_pem")

    @trust_chain_rsa_pem.setter
    def trust_chain_rsa_pem(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "trust_chain_rsa_pem", value)

    @_builtins.property
    @pulumi.getter(name="waitForDeployment")
    def wait_for_deployment(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to wait for certificate to be deployed
        """
        return pulumi.get(self, "wait_for_deployment")

    @wait_for_deployment.setter
    def wait_for_deployment(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "wait_for_deployment", value)


@pulumi.input_type
class _CpsUploadCertificateState:
    def __init__(__self__, *,
                 acknowledge_change_management: Optional[pulumi.Input[_builtins.bool]] = None,
                 acknowledge_post_verification_warnings: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_approve_warnings: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 certificate_ecdsa_pem: Optional[pulumi.Input[_builtins.str]] = None,
                 certificate_rsa_pem: Optional[pulumi.Input[_builtins.str]] = None,
                 enrollment_id: Optional[pulumi.Input[_builtins.int]] = None,
                 timeouts: Optional[pulumi.Input['CpsUploadCertificateTimeoutsArgs']] = None,
                 trust_chain_ecdsa_pem: Optional[pulumi.Input[_builtins.str]] = None,
                 trust_chain_rsa_pem: Optional[pulumi.Input[_builtins.str]] = None,
                 wait_for_deployment: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering CpsUploadCertificate resources.
        :param pulumi.Input[_builtins.bool] acknowledge_change_management: Whether to acknowledge change management
        :param pulumi.Input[_builtins.bool] acknowledge_post_verification_warnings: Whether to acknowledge post-verification warnings
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] auto_approve_warnings: List of post-verification warnings to be automatically acknowledged
        :param pulumi.Input[_builtins.str] certificate_ecdsa_pem: ECDSA certificate in pem format to be uploaded
        :param pulumi.Input[_builtins.str] certificate_rsa_pem: RSA certificate in pem format to be uploaded
        :param pulumi.Input[_builtins.int] enrollment_id: The unique identifier of the enrollment
        :param pulumi.Input['CpsUploadCertificateTimeoutsArgs'] timeouts: Enables to set timeout for processing
        :param pulumi.Input[_builtins.str] trust_chain_ecdsa_pem: Trust chain in pem format for provided ECDSA certificate
        :param pulumi.Input[_builtins.str] trust_chain_rsa_pem: Trust chain in pem format for provided RSA certificate
        :param pulumi.Input[_builtins.bool] wait_for_deployment: Whether to wait for certificate to be deployed
        """
        if acknowledge_change_management is not None:
            pulumi.set(__self__, "acknowledge_change_management", acknowledge_change_management)
        if acknowledge_post_verification_warnings is not None:
            pulumi.set(__self__, "acknowledge_post_verification_warnings", acknowledge_post_verification_warnings)
        if auto_approve_warnings is not None:
            pulumi.set(__self__, "auto_approve_warnings", auto_approve_warnings)
        if certificate_ecdsa_pem is not None:
            pulumi.set(__self__, "certificate_ecdsa_pem", certificate_ecdsa_pem)
        if certificate_rsa_pem is not None:
            pulumi.set(__self__, "certificate_rsa_pem", certificate_rsa_pem)
        if enrollment_id is not None:
            pulumi.set(__self__, "enrollment_id", enrollment_id)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)
        if trust_chain_ecdsa_pem is not None:
            pulumi.set(__self__, "trust_chain_ecdsa_pem", trust_chain_ecdsa_pem)
        if trust_chain_rsa_pem is not None:
            pulumi.set(__self__, "trust_chain_rsa_pem", trust_chain_rsa_pem)
        if wait_for_deployment is not None:
            pulumi.set(__self__, "wait_for_deployment", wait_for_deployment)

    @_builtins.property
    @pulumi.getter(name="acknowledgeChangeManagement")
    def acknowledge_change_management(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to acknowledge change management
        """
        return pulumi.get(self, "acknowledge_change_management")

    @acknowledge_change_management.setter
    def acknowledge_change_management(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "acknowledge_change_management", value)

    @_builtins.property
    @pulumi.getter(name="acknowledgePostVerificationWarnings")
    def acknowledge_post_verification_warnings(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to acknowledge post-verification warnings
        """
        return pulumi.get(self, "acknowledge_post_verification_warnings")

    @acknowledge_post_verification_warnings.setter
    def acknowledge_post_verification_warnings(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "acknowledge_post_verification_warnings", value)

    @_builtins.property
    @pulumi.getter(name="autoApproveWarnings")
    def auto_approve_warnings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of post-verification warnings to be automatically acknowledged
        """
        return pulumi.get(self, "auto_approve_warnings")

    @auto_approve_warnings.setter
    def auto_approve_warnings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "auto_approve_warnings", value)

    @_builtins.property
    @pulumi.getter(name="certificateEcdsaPem")
    def certificate_ecdsa_pem(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ECDSA certificate in pem format to be uploaded
        """
        return pulumi.get(self, "certificate_ecdsa_pem")

    @certificate_ecdsa_pem.setter
    def certificate_ecdsa_pem(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "certificate_ecdsa_pem", value)

    @_builtins.property
    @pulumi.getter(name="certificateRsaPem")
    def certificate_rsa_pem(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        RSA certificate in pem format to be uploaded
        """
        return pulumi.get(self, "certificate_rsa_pem")

    @certificate_rsa_pem.setter
    def certificate_rsa_pem(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "certificate_rsa_pem", value)

    @_builtins.property
    @pulumi.getter(name="enrollmentId")
    def enrollment_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The unique identifier of the enrollment
        """
        return pulumi.get(self, "enrollment_id")

    @enrollment_id.setter
    def enrollment_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "enrollment_id", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['CpsUploadCertificateTimeoutsArgs']]:
        """
        Enables to set timeout for processing
        """
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['CpsUploadCertificateTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)

    @_builtins.property
    @pulumi.getter(name="trustChainEcdsaPem")
    def trust_chain_ecdsa_pem(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Trust chain in pem format for provided ECDSA certificate
        """
        return pulumi.get(self, "trust_chain_ecdsa_pem")

    @trust_chain_ecdsa_pem.setter
    def trust_chain_ecdsa_pem(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "trust_chain_ecdsa_pem", value)

    @_builtins.property
    @pulumi.getter(name="trustChainRsaPem")
    def trust_chain_rsa_pem(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Trust chain in pem format for provided RSA certificate
        """
        return pulumi.get(self, "trust_chain_rsa_pem")

    @trust_chain_rsa_pem.setter
    def trust_chain_rsa_pem(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "trust_chain_rsa_pem", value)

    @_builtins.property
    @pulumi.getter(name="waitForDeployment")
    def wait_for_deployment(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to wait for certificate to be deployed
        """
        return pulumi.get(self, "wait_for_deployment")

    @wait_for_deployment.setter
    def wait_for_deployment(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "wait_for_deployment", value)


@pulumi.type_token("akamai:index/cpsUploadCertificate:CpsUploadCertificate")
class CpsUploadCertificate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acknowledge_change_management: Optional[pulumi.Input[_builtins.bool]] = None,
                 acknowledge_post_verification_warnings: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_approve_warnings: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 certificate_ecdsa_pem: Optional[pulumi.Input[_builtins.str]] = None,
                 certificate_rsa_pem: Optional[pulumi.Input[_builtins.str]] = None,
                 enrollment_id: Optional[pulumi.Input[_builtins.int]] = None,
                 timeouts: Optional[pulumi.Input[Union['CpsUploadCertificateTimeoutsArgs', 'CpsUploadCertificateTimeoutsArgsDict']]] = None,
                 trust_chain_ecdsa_pem: Optional[pulumi.Input[_builtins.str]] = None,
                 trust_chain_rsa_pem: Optional[pulumi.Input[_builtins.str]] = None,
                 wait_for_deployment: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        Create a CpsUploadCertificate resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] acknowledge_change_management: Whether to acknowledge change management
        :param pulumi.Input[_builtins.bool] acknowledge_post_verification_warnings: Whether to acknowledge post-verification warnings
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] auto_approve_warnings: List of post-verification warnings to be automatically acknowledged
        :param pulumi.Input[_builtins.str] certificate_ecdsa_pem: ECDSA certificate in pem format to be uploaded
        :param pulumi.Input[_builtins.str] certificate_rsa_pem: RSA certificate in pem format to be uploaded
        :param pulumi.Input[_builtins.int] enrollment_id: The unique identifier of the enrollment
        :param pulumi.Input[Union['CpsUploadCertificateTimeoutsArgs', 'CpsUploadCertificateTimeoutsArgsDict']] timeouts: Enables to set timeout for processing
        :param pulumi.Input[_builtins.str] trust_chain_ecdsa_pem: Trust chain in pem format for provided ECDSA certificate
        :param pulumi.Input[_builtins.str] trust_chain_rsa_pem: Trust chain in pem format for provided RSA certificate
        :param pulumi.Input[_builtins.bool] wait_for_deployment: Whether to wait for certificate to be deployed
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CpsUploadCertificateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a CpsUploadCertificate resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param CpsUploadCertificateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CpsUploadCertificateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acknowledge_change_management: Optional[pulumi.Input[_builtins.bool]] = None,
                 acknowledge_post_verification_warnings: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_approve_warnings: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 certificate_ecdsa_pem: Optional[pulumi.Input[_builtins.str]] = None,
                 certificate_rsa_pem: Optional[pulumi.Input[_builtins.str]] = None,
                 enrollment_id: Optional[pulumi.Input[_builtins.int]] = None,
                 timeouts: Optional[pulumi.Input[Union['CpsUploadCertificateTimeoutsArgs', 'CpsUploadCertificateTimeoutsArgsDict']]] = None,
                 trust_chain_ecdsa_pem: Optional[pulumi.Input[_builtins.str]] = None,
                 trust_chain_rsa_pem: Optional[pulumi.Input[_builtins.str]] = None,
                 wait_for_deployment: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CpsUploadCertificateArgs.__new__(CpsUploadCertificateArgs)

            __props__.__dict__["acknowledge_change_management"] = acknowledge_change_management
            __props__.__dict__["acknowledge_post_verification_warnings"] = acknowledge_post_verification_warnings
            __props__.__dict__["auto_approve_warnings"] = auto_approve_warnings
            __props__.__dict__["certificate_ecdsa_pem"] = certificate_ecdsa_pem
            __props__.__dict__["certificate_rsa_pem"] = certificate_rsa_pem
            if enrollment_id is None and not opts.urn:
                raise TypeError("Missing required property 'enrollment_id'")
            __props__.__dict__["enrollment_id"] = enrollment_id
            __props__.__dict__["timeouts"] = timeouts
            __props__.__dict__["trust_chain_ecdsa_pem"] = trust_chain_ecdsa_pem
            __props__.__dict__["trust_chain_rsa_pem"] = trust_chain_rsa_pem
            __props__.__dict__["wait_for_deployment"] = wait_for_deployment
        super(CpsUploadCertificate, __self__).__init__(
            'akamai:index/cpsUploadCertificate:CpsUploadCertificate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            acknowledge_change_management: Optional[pulumi.Input[_builtins.bool]] = None,
            acknowledge_post_verification_warnings: Optional[pulumi.Input[_builtins.bool]] = None,
            auto_approve_warnings: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            certificate_ecdsa_pem: Optional[pulumi.Input[_builtins.str]] = None,
            certificate_rsa_pem: Optional[pulumi.Input[_builtins.str]] = None,
            enrollment_id: Optional[pulumi.Input[_builtins.int]] = None,
            timeouts: Optional[pulumi.Input[Union['CpsUploadCertificateTimeoutsArgs', 'CpsUploadCertificateTimeoutsArgsDict']]] = None,
            trust_chain_ecdsa_pem: Optional[pulumi.Input[_builtins.str]] = None,
            trust_chain_rsa_pem: Optional[pulumi.Input[_builtins.str]] = None,
            wait_for_deployment: Optional[pulumi.Input[_builtins.bool]] = None) -> 'CpsUploadCertificate':
        """
        Get an existing CpsUploadCertificate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] acknowledge_change_management: Whether to acknowledge change management
        :param pulumi.Input[_builtins.bool] acknowledge_post_verification_warnings: Whether to acknowledge post-verification warnings
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] auto_approve_warnings: List of post-verification warnings to be automatically acknowledged
        :param pulumi.Input[_builtins.str] certificate_ecdsa_pem: ECDSA certificate in pem format to be uploaded
        :param pulumi.Input[_builtins.str] certificate_rsa_pem: RSA certificate in pem format to be uploaded
        :param pulumi.Input[_builtins.int] enrollment_id: The unique identifier of the enrollment
        :param pulumi.Input[Union['CpsUploadCertificateTimeoutsArgs', 'CpsUploadCertificateTimeoutsArgsDict']] timeouts: Enables to set timeout for processing
        :param pulumi.Input[_builtins.str] trust_chain_ecdsa_pem: Trust chain in pem format for provided ECDSA certificate
        :param pulumi.Input[_builtins.str] trust_chain_rsa_pem: Trust chain in pem format for provided RSA certificate
        :param pulumi.Input[_builtins.bool] wait_for_deployment: Whether to wait for certificate to be deployed
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CpsUploadCertificateState.__new__(_CpsUploadCertificateState)

        __props__.__dict__["acknowledge_change_management"] = acknowledge_change_management
        __props__.__dict__["acknowledge_post_verification_warnings"] = acknowledge_post_verification_warnings
        __props__.__dict__["auto_approve_warnings"] = auto_approve_warnings
        __props__.__dict__["certificate_ecdsa_pem"] = certificate_ecdsa_pem
        __props__.__dict__["certificate_rsa_pem"] = certificate_rsa_pem
        __props__.__dict__["enrollment_id"] = enrollment_id
        __props__.__dict__["timeouts"] = timeouts
        __props__.__dict__["trust_chain_ecdsa_pem"] = trust_chain_ecdsa_pem
        __props__.__dict__["trust_chain_rsa_pem"] = trust_chain_rsa_pem
        __props__.__dict__["wait_for_deployment"] = wait_for_deployment
        return CpsUploadCertificate(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="acknowledgeChangeManagement")
    def acknowledge_change_management(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to acknowledge change management
        """
        return pulumi.get(self, "acknowledge_change_management")

    @_builtins.property
    @pulumi.getter(name="acknowledgePostVerificationWarnings")
    def acknowledge_post_verification_warnings(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to acknowledge post-verification warnings
        """
        return pulumi.get(self, "acknowledge_post_verification_warnings")

    @_builtins.property
    @pulumi.getter(name="autoApproveWarnings")
    def auto_approve_warnings(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of post-verification warnings to be automatically acknowledged
        """
        return pulumi.get(self, "auto_approve_warnings")

    @_builtins.property
    @pulumi.getter(name="certificateEcdsaPem")
    def certificate_ecdsa_pem(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        ECDSA certificate in pem format to be uploaded
        """
        return pulumi.get(self, "certificate_ecdsa_pem")

    @_builtins.property
    @pulumi.getter(name="certificateRsaPem")
    def certificate_rsa_pem(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        RSA certificate in pem format to be uploaded
        """
        return pulumi.get(self, "certificate_rsa_pem")

    @_builtins.property
    @pulumi.getter(name="enrollmentId")
    def enrollment_id(self) -> pulumi.Output[_builtins.int]:
        """
        The unique identifier of the enrollment
        """
        return pulumi.get(self, "enrollment_id")

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> pulumi.Output[Optional['outputs.CpsUploadCertificateTimeouts']]:
        """
        Enables to set timeout for processing
        """
        return pulumi.get(self, "timeouts")

    @_builtins.property
    @pulumi.getter(name="trustChainEcdsaPem")
    def trust_chain_ecdsa_pem(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Trust chain in pem format for provided ECDSA certificate
        """
        return pulumi.get(self, "trust_chain_ecdsa_pem")

    @_builtins.property
    @pulumi.getter(name="trustChainRsaPem")
    def trust_chain_rsa_pem(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Trust chain in pem format for provided RSA certificate
        """
        return pulumi.get(self, "trust_chain_rsa_pem")

    @_builtins.property
    @pulumi.getter(name="waitForDeployment")
    def wait_for_deployment(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to wait for certificate to be deployed
        """
        return pulumi.get(self, "wait_for_deployment")

