# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['EdgeKvArgs', 'EdgeKv']

@pulumi.input_type
class EdgeKvArgs:
    def __init__(__self__, *,
                 group_id: pulumi.Input[_builtins.int],
                 namespace_name: pulumi.Input[_builtins.str],
                 network: pulumi.Input[_builtins.str],
                 retention_in_seconds: pulumi.Input[_builtins.int],
                 geo_location: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a EdgeKv resource.
        :param pulumi.Input[_builtins.int] group_id: Namespace ACC group ID. It will be used in EdgeKV API v2. Not updatable.
        :param pulumi.Input[_builtins.str] namespace_name: Name for the EKV namespace
        :param pulumi.Input[_builtins.str] network: The network on which the namespace will be activated
        :param pulumi.Input[_builtins.int] retention_in_seconds: Retention period for data in this namespace. An update of this value will just affect new EKV items.
        :param pulumi.Input[_builtins.str] geo_location: Storage location for data
        """
        pulumi.set(__self__, "group_id", group_id)
        pulumi.set(__self__, "namespace_name", namespace_name)
        pulumi.set(__self__, "network", network)
        pulumi.set(__self__, "retention_in_seconds", retention_in_seconds)
        if geo_location is not None:
            pulumi.set(__self__, "geo_location", geo_location)

    @_builtins.property
    @pulumi.getter(name="groupId")
    def group_id(self) -> pulumi.Input[_builtins.int]:
        """
        Namespace ACC group ID. It will be used in EdgeKV API v2. Not updatable.
        """
        return pulumi.get(self, "group_id")

    @group_id.setter
    def group_id(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "group_id", value)

    @_builtins.property
    @pulumi.getter(name="namespaceName")
    def namespace_name(self) -> pulumi.Input[_builtins.str]:
        """
        Name for the EKV namespace
        """
        return pulumi.get(self, "namespace_name")

    @namespace_name.setter
    def namespace_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "namespace_name", value)

    @_builtins.property
    @pulumi.getter
    def network(self) -> pulumi.Input[_builtins.str]:
        """
        The network on which the namespace will be activated
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "network", value)

    @_builtins.property
    @pulumi.getter(name="retentionInSeconds")
    def retention_in_seconds(self) -> pulumi.Input[_builtins.int]:
        """
        Retention period for data in this namespace. An update of this value will just affect new EKV items.
        """
        return pulumi.get(self, "retention_in_seconds")

    @retention_in_seconds.setter
    def retention_in_seconds(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "retention_in_seconds", value)

    @_builtins.property
    @pulumi.getter(name="geoLocation")
    def geo_location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Storage location for data
        """
        return pulumi.get(self, "geo_location")

    @geo_location.setter
    def geo_location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "geo_location", value)


@pulumi.input_type
class _EdgeKvState:
    def __init__(__self__, *,
                 geo_location: Optional[pulumi.Input[_builtins.str]] = None,
                 group_id: Optional[pulumi.Input[_builtins.int]] = None,
                 namespace_name: Optional[pulumi.Input[_builtins.str]] = None,
                 network: Optional[pulumi.Input[_builtins.str]] = None,
                 retention_in_seconds: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering EdgeKv resources.
        :param pulumi.Input[_builtins.str] geo_location: Storage location for data
        :param pulumi.Input[_builtins.int] group_id: Namespace ACC group ID. It will be used in EdgeKV API v2. Not updatable.
        :param pulumi.Input[_builtins.str] namespace_name: Name for the EKV namespace
        :param pulumi.Input[_builtins.str] network: The network on which the namespace will be activated
        :param pulumi.Input[_builtins.int] retention_in_seconds: Retention period for data in this namespace. An update of this value will just affect new EKV items.
        """
        if geo_location is not None:
            pulumi.set(__self__, "geo_location", geo_location)
        if group_id is not None:
            pulumi.set(__self__, "group_id", group_id)
        if namespace_name is not None:
            pulumi.set(__self__, "namespace_name", namespace_name)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if retention_in_seconds is not None:
            pulumi.set(__self__, "retention_in_seconds", retention_in_seconds)

    @_builtins.property
    @pulumi.getter(name="geoLocation")
    def geo_location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Storage location for data
        """
        return pulumi.get(self, "geo_location")

    @geo_location.setter
    def geo_location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "geo_location", value)

    @_builtins.property
    @pulumi.getter(name="groupId")
    def group_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Namespace ACC group ID. It will be used in EdgeKV API v2. Not updatable.
        """
        return pulumi.get(self, "group_id")

    @group_id.setter
    def group_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "group_id", value)

    @_builtins.property
    @pulumi.getter(name="namespaceName")
    def namespace_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name for the EKV namespace
        """
        return pulumi.get(self, "namespace_name")

    @namespace_name.setter
    def namespace_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace_name", value)

    @_builtins.property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The network on which the namespace will be activated
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network", value)

    @_builtins.property
    @pulumi.getter(name="retentionInSeconds")
    def retention_in_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Retention period for data in this namespace. An update of this value will just affect new EKV items.
        """
        return pulumi.get(self, "retention_in_seconds")

    @retention_in_seconds.setter
    def retention_in_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "retention_in_seconds", value)


@pulumi.type_token("akamai:index/edgeKv:EdgeKv")
class EdgeKv(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 geo_location: Optional[pulumi.Input[_builtins.str]] = None,
                 group_id: Optional[pulumi.Input[_builtins.int]] = None,
                 namespace_name: Optional[pulumi.Input[_builtins.str]] = None,
                 network: Optional[pulumi.Input[_builtins.str]] = None,
                 retention_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        Create a EdgeKv resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] geo_location: Storage location for data
        :param pulumi.Input[_builtins.int] group_id: Namespace ACC group ID. It will be used in EdgeKV API v2. Not updatable.
        :param pulumi.Input[_builtins.str] namespace_name: Name for the EKV namespace
        :param pulumi.Input[_builtins.str] network: The network on which the namespace will be activated
        :param pulumi.Input[_builtins.int] retention_in_seconds: Retention period for data in this namespace. An update of this value will just affect new EKV items.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EdgeKvArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a EdgeKv resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param EdgeKvArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EdgeKvArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 geo_location: Optional[pulumi.Input[_builtins.str]] = None,
                 group_id: Optional[pulumi.Input[_builtins.int]] = None,
                 namespace_name: Optional[pulumi.Input[_builtins.str]] = None,
                 network: Optional[pulumi.Input[_builtins.str]] = None,
                 retention_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EdgeKvArgs.__new__(EdgeKvArgs)

            __props__.__dict__["geo_location"] = geo_location
            if group_id is None and not opts.urn:
                raise TypeError("Missing required property 'group_id'")
            __props__.__dict__["group_id"] = group_id
            if namespace_name is None and not opts.urn:
                raise TypeError("Missing required property 'namespace_name'")
            __props__.__dict__["namespace_name"] = namespace_name
            if network is None and not opts.urn:
                raise TypeError("Missing required property 'network'")
            __props__.__dict__["network"] = network
            if retention_in_seconds is None and not opts.urn:
                raise TypeError("Missing required property 'retention_in_seconds'")
            __props__.__dict__["retention_in_seconds"] = retention_in_seconds
        super(EdgeKv, __self__).__init__(
            'akamai:index/edgeKv:EdgeKv',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            geo_location: Optional[pulumi.Input[_builtins.str]] = None,
            group_id: Optional[pulumi.Input[_builtins.int]] = None,
            namespace_name: Optional[pulumi.Input[_builtins.str]] = None,
            network: Optional[pulumi.Input[_builtins.str]] = None,
            retention_in_seconds: Optional[pulumi.Input[_builtins.int]] = None) -> 'EdgeKv':
        """
        Get an existing EdgeKv resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] geo_location: Storage location for data
        :param pulumi.Input[_builtins.int] group_id: Namespace ACC group ID. It will be used in EdgeKV API v2. Not updatable.
        :param pulumi.Input[_builtins.str] namespace_name: Name for the EKV namespace
        :param pulumi.Input[_builtins.str] network: The network on which the namespace will be activated
        :param pulumi.Input[_builtins.int] retention_in_seconds: Retention period for data in this namespace. An update of this value will just affect new EKV items.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EdgeKvState.__new__(_EdgeKvState)

        __props__.__dict__["geo_location"] = geo_location
        __props__.__dict__["group_id"] = group_id
        __props__.__dict__["namespace_name"] = namespace_name
        __props__.__dict__["network"] = network
        __props__.__dict__["retention_in_seconds"] = retention_in_seconds
        return EdgeKv(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="geoLocation")
    def geo_location(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Storage location for data
        """
        return pulumi.get(self, "geo_location")

    @_builtins.property
    @pulumi.getter(name="groupId")
    def group_id(self) -> pulumi.Output[_builtins.int]:
        """
        Namespace ACC group ID. It will be used in EdgeKV API v2. Not updatable.
        """
        return pulumi.get(self, "group_id")

    @_builtins.property
    @pulumi.getter(name="namespaceName")
    def namespace_name(self) -> pulumi.Output[_builtins.str]:
        """
        Name for the EKV namespace
        """
        return pulumi.get(self, "namespace_name")

    @_builtins.property
    @pulumi.getter
    def network(self) -> pulumi.Output[_builtins.str]:
        """
        The network on which the namespace will be activated
        """
        return pulumi.get(self, "network")

    @_builtins.property
    @pulumi.getter(name="retentionInSeconds")
    def retention_in_seconds(self) -> pulumi.Output[_builtins.int]:
        """
        Retention period for data in this namespace. An update of this value will just affect new EKV items.
        """
        return pulumi.get(self, "retention_in_seconds")

